package com.artfess.cqlt.model;

import java.math.BigDecimal;
import com.baomidou.mybatisplus.annotation.IdType;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import java.time.LocalDate;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.TableId;
import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 财务--国资委子企业季度填报详情表
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2023-03-02
 */
@Data
@ApiModel(value="QfFinanceSasacCompanyD对象", description="财务--国资委子企业季度填报详情表")
public class QfFinanceSasacCompanyD extends BaseModel<QfFinanceSasacCompanyD> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "id_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "主表ID")
    @TableField("main_id_")
    private String mainId;

    @ApiModelProperty(value = "填报日期")
    @TableField("fill_date_")
    private LocalDate fillDate;

    @ApiModelProperty(value = "科目编码")
    @TableField("subject_code_")
    private String subjectCode;

    @ApiModelProperty(value = "科目中文名称")
    @TableField("subject_name_")
    private String subjectName;

    @ApiModelProperty(value = "科目英文名称")
    @TableField("subject_name_en_")
    private String subjectNameEn;

    @ApiModelProperty(value = "科目层级")
    @TableField("subject_level_")
    private Integer subjectLevel;

    @ApiModelProperty(value = "科目计量单位位（由科目关联）")
    @TableField("subject_unit_")
    private String subjectUnit;

    @ApiModelProperty(value = "所属企业编码")
    @TableField("enterprise_code_")
    private String enterpriseCode;

    @ApiModelProperty(value = "所属企业名称")
    @TableField("enterprise_name_")
    private String enterpriseName;

    @ApiModelProperty(value = "所属企业英文名称")
    @TableField("enterprise_name_en_")
    private String enterpriseNameEn;

    @ApiModelProperty(value = "填报虚数据（一个季度少一个月的数据）")
    @TableField("fill_unreal_data_")
    private BigDecimal fillUnrealData;

    @ApiModelProperty(value = "去年填报虚数据（一个季度少一个月的数据）")
    @TableField("lastYear_fillUnreal_data")
    private BigDecimal lastYearfillUnrealData;

    @ApiModelProperty(value = "填报真实数据（真实的一个季度的数据）")
    @TableField("fill_real_data_")
    private BigDecimal fillRealData;

    @ApiModelProperty(value = "去年填报真实数据（真实的一个季度的数据）")
    @TableField("lastYear_fillReal_data")
    private BigDecimal lastYearfillRealData;



    @ApiModelProperty(value = "起始月")
    @TableField("start_month_")
    private Integer startMonth;

    @ApiModelProperty(value = "截止月")
    @TableField("end_month_")
    private Integer endMonth;


    @ApiModelProperty(value = "排序号")
    @TableField("SN_")
    protected Integer sn;

    @ApiModelProperty(value = "最终编辑时间")
    @TableField("last_time_")
    private LocalDateTime lastTime = LocalDateTime.now();

}
