package com.artfess.cqlt.model;

import com.artfess.base.annotation.Excel;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * 资金--贷款填报数据详情
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2023-03-02
 */
@Data
@ApiModel(value="QfFinanceLoanD对象", description="资金--贷款填报数据详情")
public class QfFinanceLoanD extends BaseModel<QfFinanceLoanD> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "id_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "主表ID")
    @TableField("main_id_")
    private String mainId;

    @ApiModelProperty(value = "填报日期")
    @TableField("fill_date_")
    private LocalDate fillDate;

    @Excel(name = "银行名称", column = "A")
    @ApiModelProperty(value = "银行名称")
    @TableField("bank_name_")
    private String bankName;

    @Excel(name = "银行简称", column = "B")
    @ApiModelProperty(value = "银行简称")
    @TableField("short_name_")
    private String shortName;

    @Excel(name = "公司名称", column = "C")
    @ApiModelProperty(value = "公司名称")
    @TableField("enterprise_name_")
    private String enterpriseName;

    @Excel(name = "公司代码", column = "D")
    @ApiModelProperty(value = "公司代码")
    @TableField("enterprise_code_")
    private String enterpriseCode;

    @ApiModelProperty(value = "所属企业英文名称")
    @TableField("enterprise_name_en_")
    private String enterpriseNameEn;

    @Excel(name = "内保外贷借款余额(万欧)", column = "E")
    @ApiModelProperty(value = "内保外贷借款余额(万欧)")
    @TableField("borrowing_balance_")
    private BigDecimal borrowingBalance;

    @Excel(name = "年初担保批准额度水平线(万欧)", column = "F")
    @ApiModelProperty(value = "年初担保批准额度水平线(万欧)")
    @TableField("early_uarantee_money_")
    private BigDecimal earlyGuaranteeMoney;

    @Excel(name = "担保金额（万欧）", column = "G")
    @ApiModelProperty(value = "担保金额（万欧）")
    @TableField("guarantee_amount_")
    private BigDecimal guaranteeAmount;

    @ApiModelProperty(value = "萨固密中国担保贷款余额（万欧）")
    @TableField("china_guarantee_")
    private BigDecimal chinaGuarantee;

    @Excel(name = "自主融资借款余额（万欧）", column = "H")
    @ApiModelProperty(value = "自主融资借款余额（万欧）")
    @TableField("loan_balance_")
    private BigDecimal loanBalance;

    @Excel(name = "利率（%）", column = "I")
    @ApiModelProperty(value = "利率（%）")
    @TableField("interest_rate_")
    private String interestRate;

    @Excel(name = "借款起期", column = "J")
    @ApiModelProperty(value = "借款起期")
    @TableField("start_date_")
    private LocalDate startDate;

    @Excel(name = "借款止期", column = "K")
    @ApiModelProperty(value = "借款止期")
    @TableField("end_date_")
    private LocalDate endDate;

    @Excel(name = "类型", column = "L")
    @ApiModelProperty(value = "类型,1:内保外贷，2:自主融资")
    @TableField("type_")
    private String type;

    @ApiModelProperty(value = "最终编辑时间")
    @TableField("last_time_")
    private LocalDateTime lastTime = LocalDateTime.now();

}
