package com.artfess.cqlt.model;

import com.artfess.base.entity.AutoFillModel;
import com.artfess.base.valid.AddGroup;
import com.artfess.base.valid.UpdateGroup;
import com.baomidou.mybatisplus.annotation.FieldStrategy;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableLogic;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Null;
import java.time.LocalDate;
import java.util.List;

/**
 * 资金-欧元同业拆借利率主表
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2023-07-17
 */
@Data
@ApiModel(value="QfEuroRatesM对象", description="资金-欧元同业拆借利率主表")
public class QfEuroRatesM extends AutoFillModel<QfEuroRatesM> {

    private static final long serialVersionUID = 1L;

    @NotNull(message = "修改必须指定id",groups = {UpdateGroup.class})
    @Null(message = "新增不能指定id",groups = {AddGroup.class})
    @ApiModelProperty(value = "主键ID")
    @TableId(value = "id_", type = IdType.ASSIGN_ID)
    private String id;

    @NotBlank(message = "QfOperationKpiM.reportId", groups = {AddGroup.class,UpdateGroup.class})
    @ApiModelProperty(value = "报表ID")
    @TableField("report_id_")
    private String reportId;

    @NotNull(message = "QfOperationKpiM.fillYear", groups = {AddGroup.class,UpdateGroup.class})
    @ApiModelProperty(value = "填报年")
    @TableField("fill_year_")
    private Integer fillYear;

    @ApiModelProperty(value = "填报日期")
    @TableField("fill_date_")
    private LocalDate fillDate;

    @ApiModelProperty(value = "填报人")
    @TableField("fill_user_")
    private String fillUser;

    @ApiModelProperty(value = "报表状态【字典】（0：临时，1：正式）")
    @TableField("status_")
    private Integer status;

    @TableLogic
    @ApiModelProperty(value = "是否已删，1已删除，0未删除")
    @TableField(value = "IS_DELE_", updateStrategy = FieldStrategy.NOT_EMPTY)
    private String isDele;

    @ApiModelProperty(value = "资金-欧元同业拆借利率详情数据")
    @TableField(exist=false)
    private List<QfEuroRatesD> list;
}
