package com.artfess.cqlt.manager.impl;

import com.artfess.base.exception.BaseException;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.cqlt.dao.QfInvestProductivityMDao;
import com.artfess.cqlt.manager.QfInvestProductivityDManager;
import com.artfess.cqlt.manager.QfInvestProductivityMManager;
import com.artfess.cqlt.model.QfInvestProductivityD;
import com.artfess.cqlt.model.QfInvestProductivityM;
import com.artfess.i18n.util.I18nUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

import java.time.LocalDate;
import java.util.List;

/**
 * 投资--萨固密集团产能分布情况数据填报主表 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2023-02-27
 */
@Service
public class QfInvestProductivityMManagerImpl extends BaseManagerImpl<QfInvestProductivityMDao, QfInvestProductivityM> implements QfInvestProductivityMManager {

    @Autowired
    private QfInvestProductivityDManager investProductivityDManager;

    @Override
    @Transactional(rollbackFor = Exception.class)
    public boolean importExcel(List<QfInvestProductivityD> list, String mainId) {
        QfInvestProductivityM qfOperationKpiM = this.baseMapper.selectById(mainId);
        Assert.notNull(qfOperationKpiM, I18nUtil.getMessage("filldata.notExist", LocaleContextHolder.getLocale()));
        Assert.isTrue(!"1".equals(qfOperationKpiM.getStatus()),  I18nUtil.getMessage("data_operate", LocaleContextHolder.getLocale()));
        QueryWrapper<QfInvestProductivityD> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("main_id_", mainId);
        investProductivityDManager.remove(queryWrapper);
        list.forEach(detail -> {
            detail.setMainId(mainId);
            detail.setFillDate(LocalDate.now());
        });
        boolean b = investProductivityDManager.saveBatch(list);
        return b;
    }

    @Override
    public boolean updateStatus(QfInvestProductivityM t) {
        QfInvestProductivityM qfOperationKpiM = baseMapper.selectById(t.getId());
        if(null == qfOperationKpiM) {
            return false;
        }
        qfOperationKpiM.setStatus(qfOperationKpiM.getStatus() == 0? 1:0 );
        int i = this.baseMapper.updateById(qfOperationKpiM);
        if(i > 0){
            return true;
        }
        return false;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public boolean insertInfo(QfInvestProductivityM t) {
        QueryWrapper<QfInvestProductivityM> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("fill_year_", t.getFillYear());
        queryWrapper.eq("fill_month_", t.getFillMonth());
        queryWrapper.eq("report_id_", t.getReportId());
        List<QfInvestProductivityM> qfOperationKpiMS = this.baseMapper.selectList(queryWrapper);
        if(!CollectionUtils.isEmpty(qfOperationKpiMS)) {
            throw new BaseException(I18nUtil.getMessage("QfOperationKpiM.repeat", LocaleContextHolder.getLocale()));
        }
        int insert = this.baseMapper.insert(t);
        if(insert > 0){
            return true;
        }
        return false;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public boolean updateInfo(QfInvestProductivityM t) {
        QueryWrapper<QfInvestProductivityM> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("fill_year_", t.getFillYear());
        queryWrapper.eq("fill_month_", t.getFillMonth());
        queryWrapper.eq("report_id_", t.getReportId());
        queryWrapper.ne("id_", t.getId());
        List<QfInvestProductivityM> qfOperationKpiMS = this.baseMapper.selectList(queryWrapper);
        if(!CollectionUtils.isEmpty(qfOperationKpiMS)) {
            throw new BaseException(I18nUtil.getMessage("QfOperationKpiM.repeat", LocaleContextHolder.getLocale()));
        }
        int insert = this.baseMapper.updateById(t);
        if(insert > 0){
            return true;
        }
        return false;
    }

}
