package com.artfess.cqlt.manager.impl;

import com.artfess.base.exception.BaseException;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.cqlt.dao.QfEuroRatesMDao;
import com.artfess.cqlt.manager.QfEuroRatesDManager;
import com.artfess.cqlt.manager.QfEuroRatesMManager;
import com.artfess.cqlt.model.QfEuroRatesD;
import com.artfess.cqlt.model.QfEuroRatesM;
import com.artfess.i18n.util.I18nUtil;
import com.artfess.poi.util.HeaderNode;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 资金-欧元同业拆借利率主表 服务实现类
 *
 * @author min.wu
 * @company 阿特菲斯信息技术有限公司
 * @since 2023-07-17
 */
@Service
public class QfEuroRatesMManagerImpl extends BaseManagerImpl<QfEuroRatesMDao, QfEuroRatesM> implements QfEuroRatesMManager {

    @Autowired
    private QfEuroRatesDManager qfEuroRatesDManager;

    @Override
    @Transactional(rollbackFor = Exception.class)
    public boolean insertInfo(QfEuroRatesM t) {
        QueryWrapper<QfEuroRatesM> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("fill_year_", t.getFillYear());
        queryWrapper.eq("report_id_", t.getReportId());
        List<QfEuroRatesM> financeLeaseMS = this.baseMapper.selectList(queryWrapper);
        if (!CollectionUtils.isEmpty(financeLeaseMS)) {
            throw new BaseException(I18nUtil.getMessage("QfOperationKpiM.repeat", LocaleContextHolder.getLocale()));
        }
        int insert = this.baseMapper.insert(t);
        if (insert > 0) {
            return true;
        }
        return false;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public boolean updateInfo(QfEuroRatesM t) {
        QueryWrapper<QfEuroRatesM> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("fill_year_", t.getFillYear());
        queryWrapper.eq("report_id_", t.getReportId());
        queryWrapper.ne("id_", t.getId());
        List<QfEuroRatesM> financeLeaseMS = this.baseMapper.selectList(queryWrapper);
        if (!CollectionUtils.isEmpty(financeLeaseMS)) {
            throw new BaseException(I18nUtil.getMessage("QfOperationKpiM.repeat", LocaleContextHolder.getLocale()));
        }
        int insert = this.baseMapper.updateById(t);
        if (insert > 0) {
            return true;
        }
        return false;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public boolean updateStatus(QfEuroRatesM t) {
        QfEuroRatesM financeLeaseM = baseMapper.selectById(t.getId());
        if (null == financeLeaseM) {
            return false;
        }
        financeLeaseM.setStatus(financeLeaseM.getStatus() == 0 ? 1 : 0);
        int i = this.baseMapper.updateById(financeLeaseM);
        if (i > 0) {
            return true;
        }
        return false;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public boolean importExcel(List<HeaderNode> list, String mainId) {

        if (CollectionUtils.isEmpty(list)) {
            return false;
        }
        QfEuroRatesM mainInfo = this.baseMapper.selectById(mainId);
        Assert.notNull(mainInfo, I18nUtil.getMessage("filldata.notExist", LocaleContextHolder.getLocale()));
        this.removeInfo(mainId);

        List<HeaderNode> headerNodeList = list.stream().collect(Collectors.groupingBy(HeaderNode::getRow)).get(0);
        Map<Integer, String> headerMap = Maps.newHashMap();
        for (HeaderNode headerNode : headerNodeList) {
            headerMap.put(headerNode.getColumn(), headerNode.getHeaderName());
        }

        Map<Integer, List<HeaderNode>> detailMap = list.stream().collect(Collectors.groupingBy(HeaderNode::getColumn));
        List<HeaderNode> types = detailMap.get(0);
        Map<Integer, String> rowMap = Maps.newHashMap();
        for (HeaderNode headerNode : types) {
            rowMap.put(headerNode.getRow(), headerNode.getHeaderName());
        }

        List<QfEuroRatesD> detailList = Lists.newArrayList();
        for (Map.Entry<Integer, List<HeaderNode>> entry : detailMap.entrySet()) {
            Integer column = entry.getKey();
            List<HeaderNode> nodes = entry.getValue();
            //获取企业编码
            String month = headerMap.get(column);

            for (HeaderNode node : nodes) {
                if (0 == node.getRow()) {
                    continue;
                }
                if (0 == node.getColumn()) {
                    continue;
                }
                String type = rowMap.get(node.getRow());
                QfEuroRatesD euroRatesD = new QfEuroRatesD();
                euroRatesD.setMonth(month.substring(0, month.length() - 1));
                euroRatesD.setType(type);
                euroRatesD.setFillDate(LocalDate.now());
                euroRatesD.setMainId(mainId);
                if (!StringUtils.isEmpty(node.getHeaderName())) {
                    euroRatesD.setFillData(new BigDecimal(node.getHeaderName()).multiply(new BigDecimal(100)));
                    detailList.add(euroRatesD);
                }
            }
        }
        boolean b = qfEuroRatesDManager.saveBatch(detailList);
        return b;
    }

    private void removeInfo(String mainId) {
        QueryWrapper<QfEuroRatesD> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("main_id_", mainId);
        qfEuroRatesDManager.remove(queryWrapper);

    }

}
