package com.artfess.cqlt.manager;

import com.alibaba.fastjson.JSONObject;
import com.artfess.base.manager.BaseManager;
import com.artfess.cqlt.model.QfFinanceLiquidityDetail;
import com.artfess.cqlt.model.QfFinanceLiquidityM;
import com.artfess.cqlt.vo.FaReportRespVo;
import com.artfess.cqlt.vo.ReportReqVo;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;

/**
 * 资金--周资金计划填报实际数据详情表 服务类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2023-03-02
 */
public interface QfFinanceLiquidityDetailManager extends BaseManager<QfFinanceLiquidityDetail> {

    List<JSONObject> detailQuery(List<QfFinanceLiquidityDetail> pageList);

    void export(HttpServletRequest request, HttpServletResponse response, List<QfFinanceLiquidityDetail> rows, String sheetName) throws IOException;

    boolean batchUpdate(QfFinanceLiquidityM t);

    List<FaReportRespVo> poolPlanData(ReportReqVo t);

    List<FaReportRespVo> groupPlanData(ReportReqVo t);

    List<FaReportRespVo> companyPlanData(ReportReqVo t);

    List<FaReportRespVo> chinaCompanyData(ReportReqVo t);
}
