package com.artfess.cqlt.dao;

import com.artfess.cqlt.model.QfFinancePlD;
import com.artfess.cqlt.model.QfHrPersonM;
import com.artfess.cqlt.vo.ReportDataVo;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 财务--利润填报详情表 Mapper 接口
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2023-03-02
 */
public interface QfFinancePlDDao extends BaseMapper<QfFinancePlD> {

    List<String> getEnterpriseCodeHeader(@Param("mainId") String mainId);

    List<String> getSubjectCodes(@Param("mainId") String mainId);

    List<ReportDataVo> getActualDataList(@Param("subjectCodes") List<String> subjectCodes,
                                         @Param("fillYear") Integer fillYear,
                                         @Param("endMonth") Integer endMonth);

    List<QfFinancePlD> getQfDetailList(@Param("vo") QfHrPersonM mainInfo, @Param("subjectCode") String subjectCode);
}
