package com.artfess.cqlt.controller;


import cn.hutool.core.util.NumberUtil;
import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.controller.BaseController;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.cqlt.manager.QfOperationNewOrdersDManager;
import com.artfess.cqlt.model.QfOperationKpiD;
import com.artfess.cqlt.model.QfOperationNewOrdersD;
import com.artfess.cqlt.model.QfOperationNewOrdersM;
import com.artfess.i18n.util.I18nUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.math.BigDecimal;
import java.util.Arrays;

/**
 * 运营--新订单数据填报详情表 前端控制器
 *
 * @author min.wu
 * @company 阿特菲斯信息技术有限公司
 * @since 2023-02-21
 */
@Slf4j
@RestController
@Api(tags = "运营--新订单数据填报详情表")
@RequestMapping("/qf/operation/newOrdersDetail/")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
public class QfOperationNewOrdersDController extends BaseController<QfOperationNewOrdersDManager, QfOperationNewOrdersD> {


    @PostMapping("/batchSave")
    @ApiOperation("批量添加实体的接口")
    public CommonResult<String> batchSave(@ApiParam(name = "model", value = "实体信息") @RequestBody QfOperationNewOrdersM t) {
        boolean result = baseService.batchSave(t);
        if (!result) {
            return new CommonResult<String>(false, I18nUtil.getMessage("option.fail", LocaleContextHolder.getLocale()), null);
        }

        return new CommonResult<String>(true, I18nUtil.getMessage("option.success", LocaleContextHolder.getLocale()), null);
    }

    @PutMapping("/batchUpdate")
    @ApiOperation("批量更新实体")
    public CommonResult<String> batchUpdate(@ApiParam(name = "model", value = "实体信息") @RequestBody QfOperationNewOrdersM t) {
        boolean result = baseService.batchUpdate(t);
        if (!result) {
            return new CommonResult<String>(false, I18nUtil.getMessage("option.fail", LocaleContextHolder.getLocale()), null);
        }
        return new CommonResult<String>(true, I18nUtil.getMessage("option.success", LocaleContextHolder.getLocale()), null);
    }


    @Override
    @DeleteMapping("/{id}")
    @ApiOperation("根据id删除")
    public CommonResult<String> deleteById(@ApiParam(name = "id", value = "实体id") @PathVariable String id) {
        boolean result = baseService.removeById(id);
        if (!result) {
            return new CommonResult<String>(false, I18nUtil.getMessage("delete.fail", LocaleContextHolder.getLocale()), null);
        }
        return new CommonResult<String>(true, I18nUtil.getMessage("option.success", LocaleContextHolder.getLocale()), null);
    }

    @Override
    @DeleteMapping("/")
    @ApiOperation("根据id集合批量删除")
    public CommonResult<String> deleteByIds(@ApiParam(name = "ids", value = "实体集合") @RequestParam String... ids) {
        boolean result = baseService.removeByIds(Arrays.asList(ids));
        if (!result) {
            return new CommonResult<String>(false, I18nUtil.getMessage("delete.fail", LocaleContextHolder.getLocale()), null);
        }
        return new CommonResult<String>(true, I18nUtil.getMessage("option.success", LocaleContextHolder.getLocale()), null);
    }

    @Override
    @PostMapping(value = "/query", produces = {"application/json; charset=utf-8"})
    @ApiOperation("分页查询结果")
    public PageList<QfOperationNewOrdersD> query(@ApiParam(name = "queryFilter", value = "分页查询信息") @RequestBody QueryFilter<QfOperationNewOrdersD> queryFilter) {
        PageList<QfOperationNewOrdersD> query = baseService.query(queryFilter);
        query.getRows().forEach(detail -> {
            if (null != detail.getEbitdaRate()) {
                detail.setEbitdaRate(NumberUtil.roundDown(detail.getEbitdaRate().multiply(new BigDecimal(100)), 2));
            }
        });
        return query;
    }

}
