package com.artfess.cqlt.controller;


import com.alibaba.fastjson.JSONObject;
import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.Direction;
import com.artfess.base.query.FieldSort;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.cqlt.model.QfFinanceLiquidityM;
import com.artfess.cqlt.model.QfHrPersonM;
import com.artfess.i18n.util.I18nUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import com.artfess.base.controller.BaseController;
import com.artfess.cqlt.model.QfFinanceLiquidityDetail;
import com.artfess.cqlt.manager.QfFinanceLiquidityDetailManager;

import java.util.Arrays;
import java.util.List;

/**
 * 资金--周资金计划填报实际数据详情表 前端控制器
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2023-03-02
 */
@Slf4j
@RestController
@Api(tags = "资金--周资金计划填报详情数据")
@RequestMapping("/qf/finance/liquidity/detail/")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
public class QfFinanceLiquidityDetailController extends BaseController<QfFinanceLiquidityDetailManager, QfFinanceLiquidityDetail> {


    @PutMapping("/batchUpdate")
    @ApiOperation("批量更新实体")
    public CommonResult<String> batchUpdate(@ApiParam(name = "model", value = "实体信息") @RequestBody QfFinanceLiquidityM t) {
        boolean result = baseService.batchUpdate(t);
        if (!result) {
            return new CommonResult<String>(false, I18nUtil.getMessage("option.fail", LocaleContextHolder.getLocale()), null);
        }
        return new CommonResult<String>(true, I18nUtil.getMessage("option.success", LocaleContextHolder.getLocale()), null);
    }


    @Override
    @DeleteMapping("/{id}")
    @ApiOperation("根据id删除")
    public CommonResult<String> deleteById(@ApiParam(name = "id", value = "实体id") @PathVariable String id) {
        boolean result = baseService.removeById(id);
        if (!result) {
            return new CommonResult<String>(false, I18nUtil.getMessage("delete.fail", LocaleContextHolder.getLocale()), null);
        }
        return new CommonResult<String>(true, I18nUtil.getMessage("option.success", LocaleContextHolder.getLocale()), null);
    }

    @Override
    @DeleteMapping("/")
    @ApiOperation("根据id集合批量删除")
    public CommonResult<String> deleteByIds(@ApiParam(name = "ids", value = "实体集合") @RequestParam String... ids) {
        boolean result = baseService.removeByIds(Arrays.asList(ids));
        if (!result) {
            return new CommonResult<String>(false, I18nUtil.getMessage("delete.fail", LocaleContextHolder.getLocale()), null);
        }
        return new CommonResult<String>(true, I18nUtil.getMessage("option.success", LocaleContextHolder.getLocale()), null);
    }

    @PostMapping(value="/detailQuery", produces={"application/json; charset=utf-8" })
    @ApiOperation("获取详情数据")
    public CommonResult detailQuery(@ApiParam(name="queryFilter", value="分页查询信息") @RequestBody QueryFilter<QfFinanceLiquidityDetail> queryFilter) {
        List<FieldSort> sorter = queryFilter.getSorter();
        sorter.add(new FieldSort("sn_", Direction.ASC));
        queryFilter.setSorter(sorter);
        PageList<QfFinanceLiquidityDetail> pageList = baseService.query(queryFilter);
        List<JSONObject> list = baseService.detailQuery(pageList.getRows());
        return CommonResult.success(list, null);
    }
}
