package com.artfess.cqlt.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.exception.RequiredException;
import com.artfess.base.model.CommonResult;
import com.artfess.cqlt.manager.BizOrgManager;
import com.artfess.i18n.util.I18nUtil;
import com.artfess.poi.util.FileDownloadUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.core.io.ClassPathResource;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;

/**
 * @author 黎沐华
 * @date 2023/3/15 10:50
 */
@Slf4j
@RestController
@Api(tags = "业务组织架构")
@RequestMapping("/biz/org/v1/")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
public class BizOrgController {

    @Resource
    private BizOrgManager orgManager;

    @PostMapping("/sync")
    @ApiOperation("全量同步组织架构及人员")
    public CommonResult<String> sync() throws Exception {
        Boolean result = orgManager.sync();
        if(!result) {
            return new CommonResult<>(false, I18nUtil.getMessage("option.fail", LocaleContextHolder.getLocale()), null);
        }
        return new CommonResult<>(true, I18nUtil.getMessage("option.success", LocaleContextHolder.getLocale()), null);
    }

    /**
     * 下载导入模板
     *
     * @param response
     * @return
     */
    @ApiOperation(value = "操作手册下载")
    @GetMapping("/downModel")
    public void downTemplate(HttpServletResponse response) {
        try {
            ClassPathResource classPathResource = new ClassPathResource("model/轻纺数字管控平台-操作手册.docx");
            FileDownloadUtil.fileDownload(response, classPathResource.getInputStream(), "轻纺数字管控平台-操作手册.docx");
        } catch (Exception e) {
            response.setCharacterEncoding("utf-8");
            throw new RequiredException(I18nUtil.getMessage("resources.noexist", LocaleContextHolder.getLocale()));
        }
    }

}
