/*
 Navicat Premium Data Transfer

 Source Server         : 重庆轻纺.dev.oceanbase
 Source Server Type    : MySQL
 Source Server Version : 50725 (5.7.25)
 Source Host           : 183.230.176.125:22881
 Source Schema         : CQLT

 Target Server Type    : MySQL
 Target Server Version : 50725 (5.7.25)
 File Encoding         : 65001

 Date: 08/03/2023 16:31:32
*/

SET NAMES utf8mb4;
SET FOREIGN_KEY_CHECKS = 0;

-- ----------------------------
-- Table structure for qf_subject_info
-- ----------------------------
DROP TABLE IF EXISTS `qf_subject_info`;
CREATE TABLE `qf_subject_info`  (
  `id_` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '主键ID',
  `type_` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '科目类型：科目所属的报表【字典】',
  `code_` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '科目编码（唯一值）',
  `name_` varchar(120) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '科目中文名称',
  `name_en_` varchar(120) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '科目英文名称',
  `unit_` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '科目计量单位',
  `level_` int(11) NULL DEFAULT NULL COMMENT '级别【字典】（1：1级，2：二级，3：三级）',
  `rate_type_` int(2) NULL DEFAULT NULL COMMENT '汇率类型（1：平均汇率，2：期末汇率）',
  `parent_id_` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '父级ID',
  `parent_code_` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '父级code',
  `has_children_` int(11) NULL DEFAULT NULL COMMENT '子节点个数',
  `full_id_` varchar(2000) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'ID_全路径',
  `full_name_` varchar(2000) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'name_全路径',
  `full_code_` varchar(2000) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'code_全路径',
  `expression_` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '计算公式',
  `memo_` varchar(500) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '备注',
  `sn_` int(11) NULL DEFAULT NULL COMMENT '排序',
  `is_dele_` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '0' COMMENT '删除标识【字典】（0：未删除，1：已删除）',
  `create_by_` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '创建人',
  `create_org_id_` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '创建人_组织_ID',
  `create_time_` timestamp NULL DEFAULT NULL COMMENT '创建时间',
  `update_by_` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '修改人员',
  `update_time_` timestamp NULL DEFAULT NULL COMMENT '修改时间',
  PRIMARY KEY (`id_`) USING BTREE
) ENGINE = oceanbase CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '国内准则科目信息' ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of qf_subject_info
-- ----------------------------
INSERT INTO `qf_subject_info` VALUES ('1633360681195671552', 'BS1', 'BS10000', '货币资金', NULL, '￥', 3, 2, '1633360692599984128', 'BS10015', 0, '/1633360706839646208/1633360692599984128/1633360681195671552', '/资产总计/流动资产合计/货币资金', '/BS10037/BS10015/BS10000', NULL, NULL, 3, '0', '1', '1', '2023-03-08 14:55:08', '1', '2023-03-08 14:55:08');
INSERT INTO `qf_subject_info` VALUES ('1633360682680455168', 'BS1', 'BS10001', '交易性金融资产', NULL, '￥', 3, 2, '1633360692599984128', 'BS10015', 0, '/1633360706839646208/1633360692599984128/1633360682680455168', '/资产总计/流动资产合计/交易性金融资产', '/BS10037/BS10015/BS10001', NULL, NULL, 3, '0', '1', '1', '2023-03-08 14:55:08', '1', '2023-03-08 14:55:08');
INSERT INTO `qf_subject_info` VALUES ('1633360683276046336', 'BS1', 'BS10002', '以公允价值计量且其变动计入当期损益的金融资产', NULL, '￥', 3, 2, '1633360692599984128', 'BS10015', 0, '/1633360706839646208/1633360692599984128/1633360683276046336', '/资产总计/流动资产合计/以公允价值计量且其变动计入当期损益的金融资产', '/BS10037/BS10015/BS10002', NULL, NULL, 3, '0', '1', '1', '2023-03-08 14:55:08', '1', '2023-03-08 14:55:08');
INSERT INTO `qf_subject_info` VALUES ('1633360684815355904', 'BS1', 'BS10003', '衍生金融资产', NULL, '￥', 3, 2, '1633360692599984128', 'BS10015', 0, '/1633360706839646208/1633360692599984128/1633360684815355904', '/资产总计/流动资产合计/衍生金融资产', '/BS10037/BS10015/BS10003', NULL, NULL, 3, '0', '1', '1', '2023-03-08 14:55:08', '1', '2023-03-08 14:55:08');
INSERT INTO `qf_subject_info` VALUES ('1633360686312722432', 'BS1', 'BS10004', '应收票据', NULL, '￥', 3, 2, '1633360692599984128', 'BS10015', 0, '/1633360706839646208/1633360692599984128/1633360686312722432', '/资产总计/流动资产合计/应收票据', '/BS10037/BS10015/BS10004', NULL, NULL, 3, '0', '1', '1', '2023-03-08 14:55:09', '1', '2023-03-08 14:55:09');
INSERT INTO `qf_subject_info` VALUES ('1633360686870564864', 'BS1', 'BS10005', '应收账款', NULL, '￥', 3, 2, '1633360692599984128', 'BS10015', 0, '/1633360706839646208/1633360692599984128/1633360686870564864', '/资产总计/流动资产合计/应收账款', '/BS10037/BS10015/BS10005', NULL, NULL, 3, '0', '1', '1', '2023-03-08 14:55:09', '1', '2023-03-08 14:55:09');
INSERT INTO `qf_subject_info` VALUES ('1633360687461961728', 'BS1', 'BS10006', '预付款项', NULL, '￥', 3, 2, '1633360692599984128', 'BS10015', 0, '/1633360706839646208/1633360692599984128/1633360687461961728', '/资产总计/流动资产合计/预付款项', '/BS10006/BS10037/BS10015', NULL, NULL, 3, '0', '1', '1', '2023-03-08 14:55:09', '1', '2023-03-08 14:55:09');
INSERT INTO `qf_subject_info` VALUES ('1633360688086913024', 'BS1', 'BS10007', '其他应收款', NULL, '￥', 3, 2, '1633360692599984128', 'BS10015', 0, '/1633360706839646208/1633360692599984128/1633360688086913024', '/其他应收款/资产总计/流动资产合计', '/BS10037/BS10015/BS10007', NULL, NULL, 3, '0', '1', '1', '2023-03-08 14:55:09', '1', '2023-03-08 14:55:09');
INSERT INTO `qf_subject_info` VALUES ('1633360688804139008', 'BS1', 'BS10008', '存货', NULL, '￥', 3, 2, '1633360692599984128', 'BS10015', 0, '/1633360706839646208/1633360692599984128/1633360688804139008', '/资产总计/流动资产合计/存货', '/BS10037/BS10015/BS10008', NULL, NULL, 3, '0', '1', '1', '2023-03-08 14:55:09', '1', '2023-03-08 14:55:09');
INSERT INTO `qf_subject_info` VALUES ('1633360689336815616', 'BS1', 'BS10009', '原材料', NULL, '￥', 4, 2, NULL, 'BS10011', 0, '/1633360689336815616', '/原材料', '/BS10009', NULL, NULL, 4, '0', '1', '1', '2023-03-08 14:55:09', '1', '2023-03-08 14:55:09');
INSERT INTO `qf_subject_info` VALUES ('1633360689848520704', 'BS1', 'BS10010', '库存商品', NULL, '￥', 4, 2, NULL, 'BS10011', 0, '/1633360689848520704', '/库存商品', '/BS10010', NULL, NULL, 4, '0', '1', '1', '2023-03-08 14:55:10', '1', '2023-03-08 14:55:10');
INSERT INTO `qf_subject_info` VALUES ('1633360690406363136', 'BS1', 'BS10011', '合同资产', NULL, '￥', 3, 2, '1633360692599984128', 'BS10015', 0, '/1633360706839646208/1633360692599984128/1633360690406363136', '/资产总计/流动资产合计/合同资产', '/BS10037/BS10015/BS10011', NULL, NULL, 3, '0', '1', '1', '2023-03-08 14:55:10', '1', '2023-03-08 14:55:10');
INSERT INTO `qf_subject_info` VALUES ('1633360690926456832', 'BS1', 'BS10012', '持有待售资产', NULL, '￥', 3, 2, '1633360692599984128', 'BS10015', 0, '/1633360706839646208/1633360692599984128/1633360690926456832', '/资产总计/流动资产合计/持有待售资产', '/BS10037/BS10015/BS10012', NULL, NULL, 3, '0', '1', '1', '2023-03-08 14:55:10', '1', '2023-03-08 14:55:10');
INSERT INTO `qf_subject_info` VALUES ('1633360691446550528', 'BS1', 'BS10013', '一年内到期的非流动资产', NULL, '￥', 3, 2, '1633360692599984128', 'BS10015', 0, '/1633360706839646208/1633360692599984128/1633360691446550528', '/资产总计/流动资产合计/一年内到期的非流动资产', '/BS10037/BS10015/BS10013', NULL, NULL, 3, '0', '1', '1', '2023-03-08 14:55:10', '1', '2023-03-08 14:55:10');
INSERT INTO `qf_subject_info` VALUES ('1633360692037947392', 'BS1', 'BS10014', '其他流动资产', NULL, '￥', 3, 2, '1633360692599984128', 'BS10015', 0, '/1633360706839646208/1633360692599984128/1633360692037947392', '/资产总计/流动资产合计/其他流动资产', '/BS10037/BS10015/BS10014', NULL, NULL, 3, '0', '1', '1', '2023-03-08 14:55:10', '1', '2023-03-08 14:55:10');
INSERT INTO `qf_subject_info` VALUES ('1633360692599984128', 'BS1', 'BS10015', '流动资产合计', NULL, '￥', 2, 2, '1633360706839646208', 'BS10037', 22, '/1633360706839646208/1633360692599984128', '/资产总计/流动资产合计', '/BS10037/BS10015', '三级之和', NULL, 2, '0', '1', '1', '2023-03-08 14:55:10', '1', '2023-03-08 14:55:12');
INSERT INTO `qf_subject_info` VALUES ('1633360693132660736', 'BS1', 'BS10016', '债权投资', NULL, '￥', 3, 2, '1633360692599984128', 'BS10015', 0, '/1633360692599984128/1633360693132660736', '/流动资产合计/债权投资', '/BS10015/BS10016', NULL, NULL, 3, '0', '1', '1', '2023-03-08 14:55:10', '1', '2023-03-08 14:55:10');
INSERT INTO `qf_subject_info` VALUES ('1633360694713913344', 'BS1', 'BS10017', '可供出售金融资产', NULL, '￥', 3, 2, '1633360692599984128', 'BS10015', 0, '/1633360692599984128/1633360694713913344', '/流动资产合计/可供出售金融资产', '/BS10015/BS10017', NULL, NULL, 3, '0', '1', '1', '2023-03-08 14:55:11', '1', '2023-03-08 14:55:11');
INSERT INTO `qf_subject_info` VALUES ('1633360695380807680', 'BS1', 'BS10018', '其他债权投资', NULL, '￥', 3, 2, '1633360692599984128', 'BS10015', 0, '/1633360692599984128/1633360695380807680', '/流动资产合计/其他债权投资', '/BS10015/BS10018', NULL, NULL, 3, '0', '1', '1', '2023-03-08 14:55:11', '1', '2023-03-08 14:55:11');
INSERT INTO `qf_subject_info` VALUES ('1633360696030924800', 'BS1', 'BS10019', '持有至到期投资', NULL, '￥', 3, 2, '1633360692599984128', 'BS10015', 0, '/1633360692599984128/1633360696030924800', '/流动资产合计/持有至到期投资', '/BS10015/BS10019', NULL, NULL, 3, '0', '1', '1', '2023-03-08 14:55:11', '1', '2023-03-08 14:55:11');
INSERT INTO `qf_subject_info` VALUES ('1633360696718790656', 'BS1', 'BS10020', '长期应收款', NULL, '￥', 3, 2, '1633360692599984128', 'BS10015', 0, '/1633360692599984128/1633360696718790656', '/流动资产合计/长期应收款', '/BS10015/BS10020', NULL, NULL, 3, '0', '1', '1', '2023-03-08 14:55:11', '1', '2023-03-08 14:55:11');
INSERT INTO `qf_subject_info` VALUES ('1633360697406656512', 'BS1', 'BS10021', '长期股权投资', NULL, '￥', 3, 2, '1633360692599984128', 'BS10015', 0, '/1633360692599984128/1633360697406656512', '/流动资产合计/长期股权投资', '/BS10015/BS10021', NULL, NULL, 3, '0', '1', '1', '2023-03-08 14:55:11', '1', '2023-03-08 14:55:11');
INSERT INTO `qf_subject_info` VALUES ('1633360698111299584', 'BS1', 'BS10022', '其他权益工具投资', NULL, '￥', 3, 2, '1633360692599984128', 'BS10015', 0, '/1633360692599984128/1633360698111299584', '/流动资产合计/其他权益工具投资', '/BS10015/BS10022', NULL, NULL, 3, '0', '1', '1', '2023-03-08 14:55:12', '1', '2023-03-08 14:55:12');
INSERT INTO `qf_subject_info` VALUES ('1633360698753028096', 'BS1', 'BS10023', '其他非流动金融资产', NULL, '￥', 3, 2, '1633360692599984128', 'BS10015', 0, '/1633360692599984128/1633360698753028096', '/流动资产合计/其他非流动金融资产', '/BS10015/BS10023', NULL, NULL, 3, '0', '1', '1', '2023-03-08 14:55:12', '1', '2023-03-08 14:55:12');
INSERT INTO `qf_subject_info` VALUES ('1633360699411533824', 'BS1', 'BS10024', '投资性房地产', NULL, '￥', 3, 2, '1633360692599984128', 'BS10015', 0, '/1633360692599984128/1633360699411533824', '/流动资产合计/投资性房地产', '/BS10015/BS10024', NULL, NULL, 3, '0', '1', '1', '2023-03-08 14:55:12', '1', '2023-03-08 14:55:12');
INSERT INTO `qf_subject_info` VALUES ('1633360700078428160', 'BS1', 'BS10025', '固定资产', NULL, '￥', 3, 2, '1633360706319552512', 'BS10036', 0, '/1633360706839646208/1633360706319552512/1633360700078428160', '/资产总计/非流动资产合计/固定资产', '/BS10037/BS10036/BS10025', NULL, NULL, 3, '0', '1', '1', '2023-03-08 14:55:12', '1', '2023-03-08 14:55:12');
INSERT INTO `qf_subject_info` VALUES ('1633360700653047808', 'BS1', 'BS10026', '在建工程', NULL, '￥', 3, 2, '1633360706319552512', 'BS10036', 0, '/1633360706839646208/1633360706319552512/1633360700653047808', '/资产总计/非流动资产合计/在建工程', '/BS10037/BS10036/BS10026', NULL, NULL, 3, '0', '1', '1', '2023-03-08 14:55:12', '1', '2023-03-08 14:55:12');
INSERT INTO `qf_subject_info` VALUES ('1633360701223473152', 'BS1', 'BS10027', '生产性生物资产', NULL, '￥', 3, 2, '1633360706319552512', 'BS10036', 0, '/1633360706839646208/1633360706319552512/1633360701223473152', '/资产总计/非流动资产合计/生产性生物资产', '/BS10037/BS10036/BS10027', NULL, NULL, 3, '0', '1', '1', '2023-03-08 14:55:12', '1', '2023-03-08 14:55:12');
INSERT INTO `qf_subject_info` VALUES ('1633360701823258624', 'BS1', 'BS10028', '油气资产', NULL, '￥', 3, 2, '1633360706319552512', 'BS10036', 0, '/1633360706839646208/1633360706319552512/1633360701823258624', '/资产总计/非流动资产合计/油气资产', '/BS10037/BS10036/BS10028', NULL, NULL, 3, '0', '1', '1', '2023-03-08 14:55:12', '1', '2023-03-08 14:55:12');
INSERT INTO `qf_subject_info` VALUES ('1633360702364323840', 'BS1', 'BS10029', '使用权资产', NULL, '￥', 3, 2, '1633360706319552512', 'BS10036', 0, '/1633360706839646208/1633360706319552512/1633360702364323840', '/资产总计/非流动资产合计/使用权资产', '/BS10037/BS10036/BS10029', NULL, NULL, 3, '0', '1', '1', '2023-03-08 14:55:13', '1', '2023-03-08 14:55:13');
INSERT INTO `qf_subject_info` VALUES ('1633360702901194752', 'BS1', 'BS10030', '无形资产', NULL, '￥', 3, 2, '1633360706319552512', 'BS10036', 0, '/1633360706839646208/1633360706319552512/1633360702901194752', '/资产总计/非流动资产合计/无形资产', '/BS10037/BS10036/BS10030', NULL, NULL, 3, '0', '1', '1', '2023-03-08 14:55:13', '1', '2023-03-08 14:55:13');
INSERT INTO `qf_subject_info` VALUES ('1633360703438065664', 'BS1', 'BS10031', '开发支出', NULL, '￥', 3, 2, '1633360706319552512', 'BS10036', 0, '/1633360706839646208/1633360706319552512/1633360703438065664', '/资产总计/非流动资产合计/开发支出', '/BS10037/BS10036/BS10031', NULL, NULL, 3, '0', '1', '1', '2023-03-08 14:55:13', '1', '2023-03-08 14:55:13');
INSERT INTO `qf_subject_info` VALUES ('1633360704016879616', 'BS1', 'BS10032', '商誉', NULL, '￥', 3, 2, '1633360706319552512', 'BS10036', 0, '/1633360706839646208/1633360706319552512/1633360704016879616', '/资产总计/非流动资产合计/商誉', '/BS10037/BS10036/BS10032', NULL, NULL, 3, '0', '1', '1', '2023-03-08 14:55:13', '1', '2023-03-08 14:55:13');
INSERT INTO `qf_subject_info` VALUES ('1633360704616665088', 'BS1', 'BS10033', '长期待摊费用', NULL, '￥', 3, 2, '1633360706319552512', 'BS10036', 0, '/1633360706839646208/1633360706319552512/1633360704616665088', '/资产总计/非流动资产合计/长期待摊费用', '/BS10037/BS10036/BS10033', NULL, NULL, 3, '0', '1', '1', '2023-03-08 14:55:13', '1', '2023-03-08 14:55:13');
INSERT INTO `qf_subject_info` VALUES ('1633360705216450560', 'BS1', 'BS10034', '递延所得税资产', NULL, '￥', 3, 2, '1633360706319552512', 'BS10036', 0, '/1633360706839646208/1633360706319552512/1633360705216450560', '/资产总计/非流动资产合计/递延所得税资产', '/BS10037/BS10036/BS10034', NULL, NULL, 3, '0', '1', '1', '2023-03-08 14:55:13', '1', '2023-03-08 14:55:13');
INSERT INTO `qf_subject_info` VALUES ('1633360705774292992', 'BS1', 'BS10035', '其他非流动资产', NULL, '￥', 3, 2, '1633360706319552512', 'BS10036', 0, '/1633360706839646208/1633360706319552512/1633360705774292992', '/资产总计/非流动资产合计/其他非流动资产', '/BS10037/BS10036/BS10035', NULL, NULL, 3, '0', '1', '1', '2023-03-08 14:55:13', '1', '2023-03-08 14:55:13');
INSERT INTO `qf_subject_info` VALUES ('1633360706319552512', 'BS1', 'BS10036', '非流动资产合计', NULL, '￥', 2, 2, '1633360706839646208', 'BS10037', 0, '/1633360706839646208/1633360706319552512', '/资产总计/非流动资产合计', '/BS10037/BS10036', '三级之和', NULL, 2, '0', '1', '1', '2023-03-08 14:55:13', '1', '2023-03-08 14:55:13');
INSERT INTO `qf_subject_info` VALUES ('1633360706839646208', 'BS1', 'BS10037', '资产总计', NULL, '￥', 1, 2, '0', NULL, 0, '/1633360706839646208', '/资产总计', '/BS10037', '二级之和', NULL, 1, '0', '1', '1', '2023-03-08 14:55:14', '1', '2023-03-08 14:55:14');
INSERT INTO `qf_subject_info` VALUES ('1633360707380711424', 'BS3', 'BS10038', '短期借款', NULL, '￥', 3, 2, '1633360716348133376', 'BS10052', 0, '/1633360733653831680/1633360716348133376/1633360707380711424', '/负债合计/流动负债合计/短期借款', '/BS10063/BS10052/BS10038', NULL, NULL, 3, '0', '1', '1', '2023-03-08 14:55:14', '1', '2023-03-08 14:55:14');
INSERT INTO `qf_subject_info` VALUES ('1633360707934359552', 'BS3', 'BS10039', '交易性金融负债', NULL, '￥', 3, 2, '1633360716348133376', 'BS10052', 0, '/1633360733653831680/1633360716348133376/1633360707934359552', '/负债合计/流动负债合计/交易性金融负债', '/BS10063/BS10052/BS10039', NULL, NULL, 3, '0', '1', '1', '2023-03-08 14:55:14', '1', '2023-03-08 14:55:14');
INSERT INTO `qf_subject_info` VALUES ('1633360708462841856', 'BS3', 'BS10040', '以公允价值计量且其变动计入当期损益的金融负债', NULL, '￥', 3, 2, '1633360716348133376', 'BS10052', 0, '/1633360733653831680/1633360716348133376/1633360708462841856', '/负债合计/流动负债合计/以公允价值计量且其变动计入当期损益的金融负债', '/BS10063/BS10052/BS10040', NULL, NULL, 3, '0', '1', '1', '2023-03-08 14:55:14', '1', '2023-03-08 14:55:14');
INSERT INTO `qf_subject_info` VALUES ('1633360709037461504', 'BS3', 'BS10041', '衍生金融负债', NULL, '￥', 3, 2, '1633360716348133376', 'BS10052', 0, '/1633360733653831680/1633360716348133376/1633360709037461504', '/衍生金融负债/负债合计/流动负债合计', '/BS10063/BS10052/BS10041', NULL, NULL, 3, '0', '1', '1', '2023-03-08 14:55:14', '1', '2023-03-08 14:55:14');
INSERT INTO `qf_subject_info` VALUES ('1633360709565943808', 'BS3', 'BS10042', '应付票据', NULL, '￥', 3, 2, '1633360716348133376', 'BS10052', 0, '/1633360733653831680/1633360716348133376/1633360709565943808', '/负债合计/流动负债合计/应付票据', '/BS10063/BS10052/BS10042', NULL, NULL, 3, '0', '1', '1', '2023-03-08 14:55:14', '1', '2023-03-08 14:55:14');
INSERT INTO `qf_subject_info` VALUES ('1633360710102814720', 'BS3', 'BS10043', '应付账款', NULL, '￥', 3, 2, '1633360716348133376', 'BS10052', 0, '/1633360733653831680/1633360716348133376/1633360710102814720', '/负债合计/流动负债合计/应付账款', '/BS10063/BS10052/BS10043', NULL, NULL, 3, '0', '1', '1', '2023-03-08 14:55:14', '1', '2023-03-08 14:55:14');
INSERT INTO `qf_subject_info` VALUES ('1633360710677434368', 'BS3', 'BS10044', '预收款项', NULL, '￥', 3, 2, '1633360716348133376', 'BS10052', 0, '/1633360733653831680/1633360716348133376/1633360710677434368', '/负债合计/流动负债合计/预收款项', '/BS10063/BS10052/BS10044', NULL, NULL, 3, '0', '1', '1', '2023-03-08 14:55:15', '1', '2023-03-08 14:55:15');
INSERT INTO `qf_subject_info` VALUES ('1633360711218499584', 'BS3', 'BS10045', '合同负债', NULL, '￥', 3, 2, '1633360716348133376', 'BS10052', 0, '/1633360733653831680/1633360716348133376/1633360711218499584', '/负债合计/流动负债合计/合同负债', '/BS10063/BS10052/BS10045', NULL, NULL, 3, '0', '1', '1', '2023-03-08 14:55:15', '1', '2023-03-08 14:55:15');
INSERT INTO `qf_subject_info` VALUES ('1633360711755370496', 'BS3', 'BS10046', '应付职工薪酬', NULL, '￥', 3, 2, '1633360716348133376', 'BS10052', 0, '/1633360733653831680/1633360716348133376/1633360711755370496', '/负债合计/流动负债合计/应付职工薪酬', '/BS10063/BS10052/BS10046', NULL, NULL, 3, '0', '1', '1', '2023-03-08 14:55:15', '1', '2023-03-08 14:55:15');
INSERT INTO `qf_subject_info` VALUES ('1633360712577454080', 'BS3', 'BS10047', '应交税费', NULL, '￥', 3, 2, '1633360716348133376', 'BS10052', 0, '/1633360733653831680/1633360716348133376/1633360712577454080', '/负债合计/流动负债合计/应交税费', '/BS10063/BS10052/BS10047', NULL, NULL, 3, '0', '1', '1', '2023-03-08 14:55:15', '1', '2023-03-08 14:55:15');
INSERT INTO `qf_subject_info` VALUES ('1633360713357594624', 'BS3', 'BS10048', '其他应付款', NULL, '￥', 3, 2, '1633360716348133376', 'BS10052', 0, '/1633360733653831680/1633360716348133376/1633360713357594624', '/负债合计/流动负债合计/其他应付款', '/BS10063/BS10052/BS10048', NULL, NULL, 3, '0', '1', '1', '2023-03-08 14:55:15', '1', '2023-03-08 14:55:15');
INSERT INTO `qf_subject_info` VALUES ('1633360713995128832', 'BS3', 'BS10049', '持有待售负债', NULL, '￥', 3, 2, '1633360716348133376', 'BS10052', 0, '/1633360733653831680/1633360716348133376/1633360713995128832', '/负债合计/流动负债合计/持有待售负债', '/BS10063/BS10052/BS10049', NULL, NULL, 3, '0', '1', '1', '2023-03-08 14:55:15', '1', '2023-03-08 14:55:15');
INSERT INTO `qf_subject_info` VALUES ('1633360714670411776', 'BS3', 'BS10050', '一年内到期的非流动负债', NULL, '￥', 3, 2, '1633360716348133376', 'BS10052', 0, '/1633360733653831680/1633360716348133376/1633360714670411776', '/负债合计/流动负债合计/一年内到期的非流动负债', '/BS10063/BS10052/BS10050', NULL, NULL, 3, '0', '1', '1', '2023-03-08 14:55:16', '1', '2023-03-08 14:55:16');
INSERT INTO `qf_subject_info` VALUES ('1633360715748347904', 'BS3', 'BS10051', '其他流动负债', NULL, '￥', 3, 2, '1633360716348133376', 'BS10052', 0, '/1633360733653831680/1633360716348133376/1633360715748347904', '/负债合计/流动负债合计/其他流动负债', '/BS10063/BS10052/BS10051', NULL, NULL, 3, '0', '1', '1', '2023-03-08 14:55:16', '1', '2023-03-08 14:55:16');
INSERT INTO `qf_subject_info` VALUES ('1633360716348133376', 'BS3', 'BS10052', '流动负债合计', NULL, '￥', 2, 2, '1633360733653831680', 'BS10063', 0, '/1633360733653831680/1633360716348133376', '/负债合计/流动负债合计', '/BS10063/BS10052', '三级之和', NULL, 2, '0', '1', '1', '2023-03-08 14:55:16', '1', '2023-03-08 14:55:16');
INSERT INTO `qf_subject_info` VALUES ('1633360716981473280', 'BS3', 'BS10053', '长期借款', NULL, '￥', 3, 2, NULL, 'BS10062', 0, '/1633360733653831680/1633360732991131648/1633360716981473280', '/负债合计/非流动负债合计/长期借款', '/BS10063/BS10062/BS10053', NULL, NULL, 3, '0', '1', '1', '2023-03-08 14:55:16', '1', '2023-03-08 14:55:16');
INSERT INTO `qf_subject_info` VALUES ('1633360717690310656', 'BS3', 'BS10054', '应付债券', NULL, '￥', 3, 2, '1633360732991131648', 'BS10062', 0, '/1633360733653831680/1633360732991131648/1633360717690310656', '/应付债券/负债合计/非流动负债合计', '/BS10054/BS10063/BS10062', NULL, NULL, 3, '0', '1', '1', '2023-03-08 14:55:16', '1', '2023-03-08 14:55:16');
INSERT INTO `qf_subject_info` VALUES ('1633360718378176512', 'BS3', 'BS10055', '租赁负债', NULL, '￥', 3, 2, '1633360732991131648', 'BS10062', 0, '/1633360733653831680/1633360732991131648/1633360718378176512', '/负债合计/非流动负债合计/租赁负债', '/BS10063/BS10062/BS10055', NULL, NULL, 3, '0', '1', '1', '2023-03-08 14:55:16', '1', '2023-03-08 14:55:16');
INSERT INTO `qf_subject_info` VALUES ('1633360718948601856', 'BS3', 'BS10056', '长期应付款', NULL, '￥', 3, 2, '1633360732991131648', 'BS10062', 0, '/1633360733653831680/1633360732991131648/1633360718948601856', '/负债合计/非流动负债合计/长期应付款', '/BS10063/BS10062/BS10056', NULL, NULL, 3, '0', '1', '1', '2023-03-08 14:55:16', '1', '2023-03-08 14:55:17');
INSERT INTO `qf_subject_info` VALUES ('1633360719749713920', 'BS3', 'BS10057', '长期应付职工薪酬', NULL, '￥', 3, 2, '1633360732991131648', 'BS10062', 0, '/1633360733653831680/1633360732991131648/1633360719749713920', '/负债合计/非流动负债合计/长期应付职工薪酬', '/BS10057/BS10063/BS10062', NULL, NULL, 3, '0', '1', '1', '2023-03-08 14:55:17', '1', '2023-03-08 14:55:18');
INSERT INTO `qf_subject_info` VALUES ('1633360724887736320', 'BS3', 'BS10058', '预计负债', NULL, '￥', 3, 2, '1633360732991131648', 'BS10062', 0, '/1633360733653831680/1633360732991131648/1633360724887736320', '/负债合计/非流动负债合计/预计负债', '/BS10063/BS10062/BS10058', NULL, NULL, 3, '0', '1', '1', '2023-03-08 14:55:19', '1', '2023-03-08 14:55:19');
INSERT INTO `qf_subject_info` VALUES ('1633360731007225856', 'BS3', 'BS10059', '递延收益', NULL, '￥', 3, 2, '1633360732991131648', 'BS10062', 0, '/1633360733653831680/1633360732991131648/1633360731007225856', '/负债合计/非流动负债合计/递延收益', '/BS10063/BS10062/BS10059', NULL, NULL, 3, '0', '1', '1', '2023-03-08 14:55:19', '1', '2023-03-08 14:55:19');
INSERT INTO `qf_subject_info` VALUES ('1633360731728646144', 'BS3', 'BS10060', '递延所得税负债', NULL, '￥', 3, 2, '1633360732991131648', 'BS10062', 0, '/1633360733653831680/1633360732991131648/1633360731728646144', '/负债合计/非流动负债合计/递延所得税负债', '/BS10063/BS10062/BS10060', NULL, NULL, 3, '0', '1', '1', '2023-03-08 14:55:20', '1', '2023-03-08 14:55:20');
INSERT INTO `qf_subject_info` VALUES ('1633360732370374656', 'BS3', 'BS10061', '其他非流动负债', NULL, '￥', 3, 2, '1633360732991131648', 'BS10062', 0, '/1633360733653831680/1633360732991131648/1633360732370374656', '/负债合计/非流动负债合计/其他非流动负债', '/BS10063/BS10062/BS10061', NULL, NULL, 3, '0', '1', '1', '2023-03-08 14:55:20', '1', '2023-03-08 14:55:20');
INSERT INTO `qf_subject_info` VALUES ('1633360732991131648', 'BS3', 'BS10062', '非流动负债合计', NULL, '￥', 2, 2, '1633360733653831680', 'BS10063', 0, '/1633360733653831680/1633360732991131648', '/负债合计/非流动负债合计', '/BS10063/BS10062', '三级之和', NULL, 2, '0', '1', '1', '2023-03-08 14:55:20', '1', '2023-03-08 14:55:20');
INSERT INTO `qf_subject_info` VALUES ('1633360733653831680', 'BS3', 'BS10063', '负债合计', NULL, '￥', 1, 2, '0', NULL, 0, '/1633360733653831680', '/负债合计', '/BS10063', '二级之和', NULL, 1, '0', '1', '1', '2023-03-08 14:55:20', '1', '2023-03-08 14:55:20');
INSERT INTO `qf_subject_info` VALUES ('1633360734241034240', 'BS2', 'BS10064', '实收资本', NULL, '￥', 3, 2, '1633360739370668032', 'BS10070', 0, '/1633360734241034240/1633360742201823232/1633360739370668032', '/所有者权益合计/归属于母公司所有者权益合计/实收资本', '/BS10072/BS10070/BS10064', NULL, NULL, 3, '0', '1', '1', '2023-03-08 14:55:20', '1', '2023-03-08 14:55:20');
INSERT INTO `qf_subject_info` VALUES ('1633360734861791232', 'BS2', 'BS10065', '其他权益工具', NULL, '￥', 3, 2, '1633360739370668032', 'BS10070', 0, '/1633360742201823232/1633360739370668032/1633360734861791232', '/所有者权益合计/归属于母公司所有者权益合计/其他权益工具', '/BS10065/BS10072/BS10070', NULL, NULL, 3, '0', '1', '1', '2023-03-08 14:55:20', '1', '2023-03-08 14:55:20');
INSERT INTO `qf_subject_info` VALUES ('1633360735440605184', 'BS2', 'BS10066', '资本公积', NULL, '￥', 3, 2, '1633360739370668032', 'BS10070', 0, '/1633360742201823232/1633360739370668032/1633360735440605184', '/所有者权益合计/归属于母公司所有者权益合计/资本公积', '/BS10066/BS10072/BS10070', NULL, NULL, 3, '0', '1', '1', '2023-03-08 14:55:20', '1', '2023-03-08 14:55:20');
INSERT INTO `qf_subject_info` VALUES ('1633360736040390656', 'BS2', 'BS10067', '其他综合收益', NULL, '￥', 3, 2, '1633360739370668032', 'BS10070', 0, '/1633360742201823232/1633360739370668032/1633360736040390656', '/所有者权益合计/归属于母公司所有者权益合计/其他综合收益', '/BS10072/BS10070/BS10067', NULL, NULL, 3, '0', '1', '1', '2023-03-08 14:55:21', '1', '2023-03-08 14:55:21');
INSERT INTO `qf_subject_info` VALUES ('1633360736656953344', 'BS2', 'BS10068', '盈余公积', NULL, '￥', 3, 2, '1633360739370668032', 'BS10070', 0, '/1633360742201823232/1633360739370668032/1633360736656953344', '/所有者权益合计/归属于母公司所有者权益合计/盈余公积', '/BS10072/BS10070/BS10068', NULL, NULL, 3, '0', '1', '1', '2023-03-08 14:55:21', '1', '2023-03-08 14:55:21');
INSERT INTO `qf_subject_info` VALUES ('1633360737445482496', 'BS2', 'BS10069', '未分配利润', NULL, '￥', 3, 2, '1633360739370668032', 'BS10070', 0, '/1633360742201823232/1633360739370668032/1633360737445482496', '/所有者权益合计/归属于母公司所有者权益合计/未分配利润', '/BS10072/BS10070/BS10069', NULL, NULL, 3, '0', '1', '1', '2023-03-08 14:55:21', '1', '2023-03-08 14:55:21');
INSERT INTO `qf_subject_info` VALUES ('1633360739370668032', 'BS2', 'BS10070', '归属于母公司所有者权益合计', NULL, '￥', 2, 2, '1633360742201823232', 'BS10072', 0, '/1633360742201823232/1633360739370668032', '/所有者权益合计/归属于母公司所有者权益合计', '/BS10072/BS10070', '三级之和', NULL, 2, '0', '1', '1', '2023-03-08 14:55:22', '1', '2023-03-08 14:55:22');
INSERT INTO `qf_subject_info` VALUES ('1633360741488791552', 'BS2', 'BS10071', '少数股东权益', NULL, '￥', 2, 2, '1633360742201823232', 'BS10072', 0, '/1633360742201823232/1633360741488791552', '/所有者权益合计/少数股东权益', '/BS10072/BS10071', NULL, NULL, 2, '0', '1', '1', '2023-03-08 14:55:22', '1', '2023-03-08 14:55:22');
INSERT INTO `qf_subject_info` VALUES ('1633360742201823232', 'BS2', 'BS10072', '所有者权益合计', NULL, '￥', 1, 2, '0', NULL, 0, '/1633360746303852544/1633360746303852544/1633360742201823232', '/所有者权益合计', '/BS10072', '二级之和', NULL, 1, '0', '1', '1', '2023-03-08 14:55:22', '1', '2023-03-08 14:55:22');
INSERT INTO `qf_subject_info` VALUES ('1633360742960992256', 'CF1', 'CF30000', '销售商品、提供劳务收到的现金', NULL, '￥', 3, 1, '1633360746303852544', 'CF30003', 0, '/1633360742960992256/1633360746303852544/1633360746303852544', '/经营活动产生的现金流量净额/经营活动现金流入小计/销售商品、提供劳务收到的现金', '/CF30000/CF30009/CF30003', NULL, NULL, 3, '0', '1', '1', '2023-03-08 14:55:22', '1', '2023-03-08 14:55:22');
INSERT INTO `qf_subject_info` VALUES ('1633360743678218240', 'CF1', 'CF30001', '收到的税费返还', NULL, '￥', 3, 1, '1633360746303852544', 'CF30003', 0, '/1633360746303852544/1633360746303852544/1633360743678218240', '/经营活动产生的现金流量净额/经营活动现金流入小计/收到的税费返还', '/CF30009/CF30003/CF30001', NULL, NULL, 3, '0', '1', '1', '2023-03-08 14:55:22', '1', '2023-03-08 14:55:22');
INSERT INTO `qf_subject_info` VALUES ('1633360745502740480', 'CF1', 'CF30002', '收到其他与经营活动有关的现金', NULL, '￥', 3, 1, '1633360746303852544', 'CF30003', 0, '/1633360746303852544/1633360746303852544/1633360745502740480', '/经营活动产生的现金流量净额/经营活动现金流入小计/收到其他与经营活动有关的现金', '/CF30009/CF30003/CF30002', NULL, NULL, 3, '0', '1', '1', '2023-03-08 14:55:23', '1', '2023-03-08 14:55:23');
INSERT INTO `qf_subject_info` VALUES ('1633360746303852544', 'CF1', 'CF30003', '经营活动现金流入小计', NULL, '￥', 2, 1, '1633360751647395840', 'CF30009', 0, '/1633360746303852544/1633360746303852544', '/经营活动产生的现金流量净额/经营活动现金流入小计', '/CF30009/CF30003', NULL, NULL, 2, '0', '1', '1', '2023-03-08 14:55:23', '1', '2023-03-08 14:55:23');
INSERT INTO `qf_subject_info` VALUES ('1633360748107403264', 'CF1', 'CF30004', '购买商品、接收劳务支付的现金', NULL, '￥', 3, 1, '1633360750959529984', 'CF30008', 0, '/1633360751647395840/1633360750959529984/1633360748107403264', '/经营活动产生的现金流量净额/经营活动现金流出小计/购买商品、接收劳务支付的现金', '/CF30004/CF30009/CF30008', NULL, NULL, 3, '0', '1', '1', '2023-03-08 14:55:23', '1', '2023-03-08 14:55:23');
INSERT INTO `qf_subject_info` VALUES ('1633360748807852032', 'CF1', 'CF30005', '支付给职工以及为职工支付的现金', NULL, '￥', 3, 1, '1633360750959529984', 'CF30008', 0, '/1633360751647395840/1633360750959529984/1633360748807852032', '/经营活动产生的现金流量净额/经营活动现金流出小计/支付给职工以及为职工支付的现金', '/CF30009/CF30008/CF30005', NULL, NULL, 3, '0', '1', '1', '2023-03-08 14:55:24', '1', '2023-03-08 14:55:24');
INSERT INTO `qf_subject_info` VALUES ('1633360749453774848', 'CF1', 'CF30006', '支付的各项税费', NULL, '￥', 3, 1, '1633360750959529984', 'CF30008', 0, '/1633360751647395840/1633360750959529984/1633360749453774848', '/经营活动产生的现金流量净额/经营活动现金流出小计/支付的各项税费', '/CF30009/CF30008/CF30006', NULL, NULL, 3, '0', '1', '1', '2023-03-08 14:55:24', '1', '2023-03-08 14:55:24');
INSERT INTO `qf_subject_info` VALUES ('1633360750242304000', 'CF1', 'CF30007', '支付其他与经营活动有关的现金', NULL, '￥', 3, 1, '1633360750959529984', 'CF30008', 0, '/1633360751647395840/1633360750959529984/1633360750242304000', '/经营活动产生的现金流量净额/经营活动现金流出小计/支付其他与经营活动有关的现金', '/CF30009/CF30008/CF30007', NULL, NULL, 3, '0', '1', '1', '2023-03-08 14:55:24', '1', '2023-03-08 14:55:24');
INSERT INTO `qf_subject_info` VALUES ('1633360750959529984', 'CF1', 'CF30008', '经营活动现金流出小计', NULL, '￥', 2, 1, '1633360751647395840', 'CF30009', 0, '/1633360751647395840/1633360750959529984', '/经营活动产生的现金流量净额/经营活动现金流出小计', '/CF30009/CF30008', NULL, NULL, 2, '0', '1', '1', '2023-03-08 14:55:24', '1', '2023-03-08 14:55:24');
INSERT INTO `qf_subject_info` VALUES ('1633360751647395840', 'CF1', 'CF30009', '经营活动产生的现金流量净额', NULL, '￥', 1, 1, '0', NULL, 0, '/1633360751647395840', '/经营活动产生的现金流量净额', '/CF30009', NULL, NULL, 1, '0', '1', '1', '2023-03-08 14:55:24', '1', '2023-03-08 14:55:24');
INSERT INTO `qf_subject_info` VALUES ('1633360752561754112', 'CF1', 'CF30010', '收回投资收到的现金', NULL, '￥', 3, 1, '1633360756974161920', 'CF30015', 0, '/1633360761696948224/1633360756974161920/1633360752561754112', '/投资活动产生的现金流量净额/投资活动现金流入小计/收回投资收到的现金', '/CF30021/CF30015/CF30010', NULL, NULL, 3, '0', '1', '1', '2023-03-08 14:55:25', '1', '2023-03-08 14:55:25');
INSERT INTO `qf_subject_info` VALUES ('1633360753140568064', 'CF1', 'CF30011', '取得投资收益收到的现金', NULL, '￥', 3, 1, '1633360756974161920', 'CF30015', 0, '/1633360761696948224/1633360756974161920/1633360753140568064', '/投资活动产生的现金流量净额/投资活动现金流入小计/取得投资收益收到的现金', '/CF30021/CF30015/CF30011', NULL, NULL, 3, '0', '1', '1', '2023-03-08 14:55:25', '1', '2023-03-08 14:55:25');
INSERT INTO `qf_subject_info` VALUES ('1633360754759569408', 'CF1', 'CF30012', '处置固定资产、无形资产和其他长期资产所收回的现金净额', NULL, '￥', 3, 1, '1633360756974161920', 'CF30015', 0, '/1633360754759569408/1633360761696948224/1633360756974161920', '/投资活动产生的现金流量净额/投资活动现金流入小计/处置固定资产、无形资产和其他长期资产所收回的现金净额', '/CF30021/CF30015/CF30012', NULL, NULL, 3, '0', '1', '1', '2023-03-08 14:55:25', '1', '2023-03-08 14:55:25');
INSERT INTO `qf_subject_info` VALUES ('1633360755489378304', 'CF1', 'CF30013', '处置子公司及其他营业单位收回的现金净额', NULL, '￥', 3, 1, '1633360756974161920', 'CF30015', 0, '/1633360761696948224/1633360756974161920/1633360755489378304', '/投资活动产生的现金流量净额/投资活动现金流入小计/处置子公司及其他营业单位收回的现金净额', '/CF30021/CF30015/CF30013', NULL, NULL, 3, '0', '1', '1', '2023-03-08 14:55:25', '1', '2023-03-08 14:55:25');
INSERT INTO `qf_subject_info` VALUES ('1633360756336627712', 'CF1', 'CF30014', '收到其他与投资活动有关的现金', NULL, '￥', 3, 1, '1633360756974161920', 'CF30015', 0, '/1633360761696948224/1633360756974161920/1633360756336627712', '/投资活动产生的现金流量净额/投资活动现金流入小计/收到其他与投资活动有关的现金', '/CF30021/CF30015/CF30014', NULL, NULL, 3, '0', '1', '1', '2023-03-08 14:55:25', '1', '2023-03-08 14:55:25');
INSERT INTO `qf_subject_info` VALUES ('1633360756974161920', 'CF1', 'CF30015', '投资活动现金流入小计', NULL, '￥', 2, 1, '1633360761696948224', 'CF30021', 0, '/1633360761696948224/1633360756974161920', '/投资活动产生的现金流量净额/投资活动现金流入小计', '/CF30021/CF30015', NULL, NULL, 2, '0', '1', '1', '2023-03-08 14:55:26', '1', '2023-03-08 14:55:26');
INSERT INTO `qf_subject_info` VALUES ('1633360758639300608', 'CF1', 'CF30016', '购建固定资产、无形资产和其他长期资产所支付的现金', NULL, '￥', 3, 1, '1633360761092968448', 'CF30020', 0, '/1633360761696948224/1633360761092968448/1633360758639300608', '/投资活动产生的现金流量净额/投资活动现金流出小计/购建固定资产、无形资产和其他长期资产所支付的现金', '/CF30016/CF30021/CF30020', NULL, NULL, 3, '0', '1', '1', '2023-03-08 14:55:26', '1', '2023-03-08 14:55:26');
INSERT INTO `qf_subject_info` VALUES ('1633360759247474688', 'CF1', 'CF30017', '投资支付的现金', NULL, '￥', 3, 1, '1633360761092968448', 'CF30020', 0, '/1633360761696948224/1633360761092968448/1633360759247474688', '/投资活动产生的现金流量净额/投资活动现金流出小计/投资支付的现金', '/CF30017/CF30021/CF30020', NULL, NULL, 3, '0', '1', '1', '2023-03-08 14:55:26', '1', '2023-03-08 14:55:26');
INSERT INTO `qf_subject_info` VALUES ('1633360759864037376', 'CF1', 'CF30018', '取得子公司及其他营业单位支付的现金净额', NULL, '￥', 3, 1, '1633360761092968448', 'CF30020', 0, '/1633360761696948224/1633360761092968448/1633360759864037376', '/取得子公司及其他营业单位支付的现金净额/投资活动产生的现金流量净额/投资活动现金流出小计', '/CF30021/CF30020/CF30018', NULL, NULL, 3, '0', '1', '1', '2023-03-08 14:55:26', '1', '2023-03-08 14:55:26');
INSERT INTO `qf_subject_info` VALUES ('1633360760509960192', 'CF1', 'CF30019', '支付其他与投资活动有关的现金', NULL, '￥', 3, 1, '1633360761092968448', 'CF30020', 0, '/1633360761696948224/1633360761092968448/1633360760509960192', '/投资活动产生的现金流量净额/投资活动现金流出小计/支付其他与投资活动有关的现金', '/CF30021/CF30020/CF30019', NULL, NULL, 3, '0', '1', '1', '2023-03-08 14:55:26', '1', '2023-03-08 14:55:26');
INSERT INTO `qf_subject_info` VALUES ('1633360761092968448', 'CF1', 'CF30020', '投资活动现金流出小计', NULL, '￥', 2, 1, '1633360761696948224', 'CF30021', 0, '/1633360761696948224/1633360761092968448', '/投资活动产生的现金流量净额/投资活动现金流出小计', '/CF30021/CF30020', NULL, NULL, 2, '0', '1', '1', '2023-03-08 14:55:27', '1', '2023-03-08 14:55:27');
INSERT INTO `qf_subject_info` VALUES ('1633360761696948224', 'CF1', 'CF30021', '投资活动产生的现金流量净额', NULL, '￥', 1, 1, '0', NULL, 0, '/1633360761696948224', '/投资活动产生的现金流量净额', '/CF30021', NULL, NULL, 1, '0', '1', '1', '2023-03-08 14:55:27', '1', '2023-03-08 14:55:27');
INSERT INTO `qf_subject_info` VALUES ('1633360762275762176', 'CF1', 'CF30022', '吸收投资收到的现金', NULL, '￥', 3, 1, '1633360765039808512', 'CF30026', 0, '/1633360768835653632/1633360765039808512/1633360762275762176', '/筹资活动产生的现金流量净额/筹资活动现金流入小计/吸收投资收到的现金', '/CF30032/CF30026/CF30022', NULL, NULL, 3, '0', '1', '1', '2023-03-08 14:55:27', '1', '2023-03-08 14:55:27');
INSERT INTO `qf_subject_info` VALUES ('1633360763177537536', 'CF1', 'CF30023', '子公司吸收少数股东投资收到的现金', NULL, '￥', 4, 1, '1633360763777323008', 'CF30024', 0, '/1633360768835653632/1633360765039808512/1633360763777323008/1633360763177537536', '/取得借款所收到的现金/筹资活动产生的现金流量净额/筹资活动现金流入小计/子公司吸收少数股东投资收到的现金', '/CF30032/CF30026/CF30024/CF30023', NULL, NULL, 4, '0', '1', '1', '2023-03-08 14:55:27', '1', '2023-03-08 14:55:27');
INSERT INTO `qf_subject_info` VALUES ('1633360763777323008', 'CF1', 'CF30024', '取得借款所收到的现金', NULL, '￥', 3, 1, '1633360765039808512', 'CF30026', 0, '/1633360768835653632/1633360765039808512/1633360763777323008', '/取得借款所收到的现金/筹资活动产生的现金流量净额/筹资活动现金流入小计', '/CF30032/CF30026/CF30024', NULL, NULL, 3, '0', '1', '1', '2023-03-08 14:55:27', '1', '2023-03-08 14:55:27');
INSERT INTO `qf_subject_info` VALUES ('1633360764393885696', 'CF1', 'CF30025', '收到其他与筹资活动有关的现金', NULL, '￥', 3, 1, '1633360765039808512', 'CF30026', 0, '/1633360768835653632/1633360765039808512/1633360764393885696', '/筹资活动产生的现金流量净额/筹资活动现金流入小计/收到其他与筹资活动有关的现金', '/CF30032/CF30026/CF30025', NULL, NULL, 3, '0', '1', '1', '2023-03-08 14:55:27', '1', '2023-03-08 14:55:27');
INSERT INTO `qf_subject_info` VALUES ('1633360765039808512', 'CF1', 'CF30026', '筹资活动现金流入小计', NULL, '￥', 2, 1, '1633360768835653632', 'CF30032', 0, '/1633360768835653632/1633360765039808512', '/筹资活动产生的现金流量净额/筹资活动现金流入小计', '/CF30032/CF30026', NULL, NULL, 2, '0', '1', '1', '2023-03-08 14:55:27', '1', '2023-03-08 14:55:28');
INSERT INTO `qf_subject_info` VALUES ('1633360765639593984', 'CF1', 'CF30027', '偿还债务所支付的现金', NULL, '￥', 3, 1, '1633360768160370688', 'CF30031', 0, '/1633360768835653632/1633360768160370688/1633360765639593984', '/筹资活动产生的现金流量净额/筹资活动现金流出小计/偿还债务所支付的现金', '/CF30032/CF30031/CF30027', NULL, NULL, 3, '0', '1', '1', '2023-03-08 14:55:28', '1', '2023-03-08 14:55:28');
INSERT INTO `qf_subject_info` VALUES ('1633360766314876928', 'CF1', 'CF30028', '分配股利、利润或偿付利息所支付的现金', NULL, '￥', 3, 1, '1633360768160370688', 'CF30031', 0, '/1633360768835653632/1633360768160370688/1633360766314876928', '/筹资活动产生的现金流量净额/筹资活动现金流出小计/分配股利、利润或偿付利息所支付的现金', '/CF30032/CF30031/CF30028', NULL, NULL, 3, '0', '1', '1', '2023-03-08 14:55:28', '1', '2023-03-08 14:55:28');
INSERT INTO `qf_subject_info` VALUES ('1633360766944022528', 'CF1', 'CF30029', '子公司支付给少数股东的股利、利润', NULL, '￥', 4, 1, '1633360767535419392', 'CF30030', 0, '/1633360768835653632/1633360768160370688/1633360767535419392/1633360766944022528', '/筹资活动产生的现金流量净额/筹资活动现金流出小计/支付其他与筹资活动有关的现金/子公司支付给少数股东的股利、利润', '/CF30032/CF30031/CF30030/CF30029', NULL, NULL, 4, '0', '1', '1', '2023-03-08 14:55:28', '1', '2023-03-08 14:55:28');
INSERT INTO `qf_subject_info` VALUES ('1633360767535419392', 'CF1', 'CF30030', '支付其他与筹资活动有关的现金', NULL, '￥', 3, 1, '1633360768160370688', 'CF30031', 0, '/1633360768835653632/1633360768160370688/1633360767535419392', '/筹资活动产生的现金流量净额/筹资活动现金流出小计/支付其他与筹资活动有关的现金', '/CF30032/CF30031/CF30030', NULL, NULL, 3, '0', '1', '1', '2023-03-08 14:55:28', '1', '2023-03-08 14:55:28');
INSERT INTO `qf_subject_info` VALUES ('1633360768160370688', 'CF1', 'CF30031', '筹资活动现金流出小计', NULL, '￥', 2, 1, '1633360768835653632', 'CF30032', 0, '/1633360768835653632/1633360768160370688', '/筹资活动产生的现金流量净额/筹资活动现金流出小计', '/CF30032/CF30031', NULL, NULL, 2, '0', '1', '1', '2023-03-08 14:55:28', '1', '2023-03-08 14:55:28');
INSERT INTO `qf_subject_info` VALUES ('1633360768835653632', 'CF1', 'CF30032', '筹资活动产生的现金流量净额', NULL, '￥', 1, 1, '0', NULL, 0, '/1633360768835653632', '/筹资活动产生的现金流量净额', '/CF30032', NULL, NULL, 1, '0', '1', '1', '2023-03-08 14:55:28', '1', '2023-03-08 14:55:28');
INSERT INTO `qf_subject_info` VALUES ('1633360769590628352', 'CF1', 'CF30033', '汇率变动对现金及现金等价物的影响', NULL, '￥', 1, 1, '0', NULL, 0, '/1633360769590628352', '/汇率变动对现金及现金等价物的影响', '/CF30033', NULL, NULL, 1, '0', '1', '1', '2023-03-08 14:55:29', '1', '2023-03-08 14:55:29');
INSERT INTO `qf_subject_info` VALUES ('1633360770228162560', 'CF1', 'CF30034', '现金及现金等价物净增加额', NULL, '￥', 1, 1, '0', NULL, 0, '/1633360770228162560', '/现金及现金等价物净增加额', '/CF30034', NULL, NULL, 1, '0', '1', '1', '2023-03-08 14:55:29', '1', '2023-03-08 14:55:29');
INSERT INTO `qf_subject_info` VALUES ('1633360770815365120', 'CF1', 'CF30035', '期初现金及现金等价物余额', NULL, '￥', 1, 1, '0', NULL, 0, '/1633360770815365120', '/期初现金及现金等价物余额', '/CF30035', NULL, NULL, 1, '0', '1', '1', '2023-03-08 14:55:29', '1', '2023-03-08 14:55:29');
INSERT INTO `qf_subject_info` VALUES ('1633360771389984768', 'CF1', 'CF30036', '期末现金及现金等价物余额', NULL, '￥', 1, 1, '0', NULL, 0, '/1633360771389984768', '/期末现金及现金等价物余额', '/CF30036', NULL, NULL, 1, '0', '1', '1', '2023-03-08 14:55:29', '1', '2023-03-08 14:55:29');
INSERT INTO `qf_subject_info` VALUES ('1633360771935244288', 'PL1', 'PL20000', '营业总收入', NULL, '￥', 1, 1, '0', NULL, 1, '/1633360771935244288', '/营业总收入', '/PL20000', '等于二级', NULL, 1, '0', '1', '1', '2023-03-08 14:55:29', '1', '2023-03-08 14:55:29');
INSERT INTO `qf_subject_info` VALUES ('1633360772472115200', 'PL1', 'PL20001', '营业收入', NULL, '￥', 2, 1, '1633360771935244288', 'PL20000', 2, '/1633360771935244288/1633360772472115200', '/营业总收入/营业收入', '/PL20000/PL20001', '等于其中项三级之和', NULL, 2, '0', '1', '1', '2023-03-08 14:55:29', '1', '2023-03-08 14:55:30');
INSERT INTO `qf_subject_info` VALUES ('1633360773214507008', 'PL1', 'PL20002', '主营业务收入', NULL, '￥', 3, 1, '1633360772472115200', 'PL20001', 0, '/1633360771935244288/1633360772472115200/1633360773214507008', '/营业总收入/营业收入/主营业务收入', '/PL20000/PL20001/PL20002', NULL, NULL, 3, '0', '1', '1', '2023-03-08 14:55:29', '1', '2023-03-08 14:55:29');
INSERT INTO `qf_subject_info` VALUES ('1633360773940121600', 'PL1', 'PL20003', '其他业务收入', NULL, '￥', 3, 1, '1633360772472115200', 'PL20001', 0, '/1633360771935244288/1633360772472115200/1633360773940121600', '/营业总收入/营业收入/其他业务收入', '/PL20000/PL20001/PL20003', NULL, NULL, 3, '0', '1', '1', '2023-03-08 14:55:30', '1', '2023-03-08 14:55:30');
INSERT INTO `qf_subject_info` VALUES ('1633360774644764672', 'PL2', 'PL20004', '营业总成本', NULL, '￥', 1, 1, '0', NULL, 15, '/1633360774644764672', '/营业总成本', '/PL20004', '等于其中项二级之和', NULL, 1, '0', '1', '1', '2023-03-08 14:55:30', '1', '2023-03-08 14:55:33');
INSERT INTO `qf_subject_info` VALUES ('1633360775223578624', 'PL2', 'PL20005', '营业成本', NULL, '￥', 2, 1, '1633360774644764672', 'PL20004', 2, '/1633360774644764672/1633360775223578624', '/营业总成本/营业成本', '/PL20004/PL20005', '等于其中项三级之和', NULL, 2, '0', '1', '1', '2023-03-08 14:55:30', '1', '2023-03-08 14:55:30');
INSERT INTO `qf_subject_info` VALUES ('1633360775877890048', 'PL2', 'PL20006', '主营业务成本', NULL, '￥', 3, 1, '1633360775223578624', 'PL20005', 0, '/1633360774644764672/1633360775223578624/1633360775877890048', '/营业总成本/营业成本/主营业务成本', '/PL20004/PL20005/PL20006', NULL, NULL, 3, '0', '1', '1', '2023-03-08 14:55:30', '1', '2023-03-08 14:55:30');
INSERT INTO `qf_subject_info` VALUES ('1633360776964214784', 'PL2', 'PL20007', '其他业务成本', NULL, '￥', 3, 1, '1633360775223578624', 'PL20005', 0, '/1633360774644764672/1633360775223578624/1633360776964214784', '/营业总成本/营业成本/其他业务成本', '/PL20004/PL20005/PL20007', NULL, NULL, 3, '0', '1', '1', '2023-03-08 14:55:30', '1', '2023-03-08 14:55:30');
INSERT INTO `qf_subject_info` VALUES ('1633360777647886336', 'PL2', 'PL20008', '税金及附加', NULL, '￥', 2, 1, '1633360774644764672', 'PL20004', 0, '/1633360774644764672/1633360777647886336', '/营业总成本/税金及附加', '/PL20004/PL20008', NULL, NULL, 2, '0', '1', '1', '2023-03-08 14:55:30', '1', '2023-03-08 14:55:31');
INSERT INTO `qf_subject_info` VALUES ('1633360778306392064', 'PL2', 'PL20009', '销售费用', NULL, '￥', 2, 1, '1633360774644764672', 'PL20004', 0, '/1633360774644764672/1633360778306392064', '/营业总成本/销售费用', '/PL20004/PL20009', NULL, NULL, 2, '0', '1', '1', '2023-03-08 14:55:31', '1', '2023-03-08 14:55:31');
INSERT INTO `qf_subject_info` VALUES ('1633360779044589568', 'PL2', 'PL20010', '管理费用', NULL, '￥', 2, 1, '1633360774644764672', 'PL20004', 0, '/1633360774644764672/1633360779044589568', '/营业总成本/管理费用', '/PL20004/PL20010', NULL, NULL, 2, '0', '1', '1', '2023-03-08 14:55:31', '1', '2023-03-08 14:55:31');
INSERT INTO `qf_subject_info` VALUES ('1633360779791175680', 'PL2', 'PL20011', '研发费用', NULL, '￥', 2, 1, '1633360774644764672', 'PL20004', 0, '/1633360774644764672/1633360779791175680', '/营业总成本/研发费用', '/PL20004/PL20011', NULL, NULL, 2, '0', '1', '1', '2023-03-08 14:55:31', '1', '2023-03-08 14:55:31');
INSERT INTO `qf_subject_info` VALUES ('1633360780806197248', 'PL2', 'PL20012', '财务费用', NULL, '￥', 2, 1, '1633360774644764672', 'PL20004', 0, '/1633360774644764672/1633360780806197248', '/营业总成本/财务费用', '/PL20004/PL20012', NULL, NULL, 2, '0', '1', '1', '2023-03-08 14:55:31', '1', '2023-03-08 14:55:31');
INSERT INTO `qf_subject_info` VALUES ('1633360781921882112', 'PL1', 'PL20016', '其他收益', NULL, '￥', 2, 1, '1633360774644764672', 'PL20004', 0, '/1633360774644764672/1633360781921882112', '/营业总成本/其他收益', '/PL20004/PL20016', NULL, NULL, 2, '0', '1', '1', '2023-03-08 14:55:32', '1', '2023-03-08 14:55:32');
INSERT INTO `qf_subject_info` VALUES ('1633360782815268864', 'PL1', 'PL20017', '投资收益', NULL, '￥', 2, 1, '1633360774644764672', 'PL20004', 0, '/1633360774644764672/1633360782815268864', '/营业总成本/投资收益', '/PL20004/PL20017', NULL, NULL, 2, '0', '1', '1', '2023-03-08 14:55:32', '1', '2023-03-08 14:55:32');
INSERT INTO `qf_subject_info` VALUES ('1633360783507329024', 'PL1', 'PL20018', '对联营企业和合营企业的投资收益', NULL, '￥', 2, 1, '1633360774644764672', 'PL20004', 0, '/1633360774644764672/1633360783507329024', '/营业总成本/对联营企业和合营企业的投资收益', '/PL20004/PL20018', NULL, NULL, 2, '0', '1', '1', '2023-03-08 14:55:32', '1', '2023-03-08 14:55:32');
INSERT INTO `qf_subject_info` VALUES ('1633360784207777792', 'PL1', 'PL20019', '以摊余成本计量的金融资产终止确认收益', NULL, '￥', 2, 1, '1633360774644764672', 'PL20004', 0, '/1633360774644764672/1633360784207777792', '/营业总成本/以摊余成本计量的金融资产终止确认收益', '/PL20004/PL20019', NULL, NULL, 2, '0', '1', '1', '2023-03-08 14:55:32', '1', '2023-03-08 14:55:32');
INSERT INTO `qf_subject_info` VALUES ('1633360784933392384', 'PL1', 'PL20020', '净敞口套期收益', NULL, '￥', 2, 1, '1633360774644764672', 'PL20004', 0, '/1633360774644764672/1633360784933392384', '/营业总成本/净敞口套期收益', '/PL20004/PL20020', NULL, NULL, 2, '0', '1', '1', '2023-03-08 14:55:32', '1', '2023-03-08 14:55:32');
INSERT INTO `qf_subject_info` VALUES ('1633360785654812672', 'PL1', 'PL20021', '公允价值变动收益', NULL, '￥', 2, 1, '1633360774644764672', 'PL20004', 0, '/1633360774644764672/1633360785654812672', '/营业总成本/公允价值变动收益', '/PL20004/PL20021', NULL, NULL, 2, '0', '1', '1', '2023-03-08 14:55:32', '1', '2023-03-08 14:55:32');
INSERT INTO `qf_subject_info` VALUES ('1633360786309124096', 'PL2', 'PL20022', '信用减值损失', NULL, '￥', 2, 1, '1633360774644764672', 'PL20004', 0, '/1633360774644764672/1633360786309124096', '/营业总成本/信用减值损失', '/PL20004/PL20022', NULL, NULL, 2, '0', '1', '1', '2023-03-08 14:55:33', '1', '2023-03-08 14:55:33');
INSERT INTO `qf_subject_info` VALUES ('1633360786976018432', 'PL2', 'PL20023', '资产减值损失', NULL, '￥', 2, 1, '1633360774644764672', 'PL20004', 0, '/1633360774644764672/1633360786976018432', '/营业总成本/资产减值损失', '/PL20004/PL20023', NULL, NULL, 2, '0', '1', '1', '2023-03-08 14:55:33', '1', '2023-03-08 14:55:33');
INSERT INTO `qf_subject_info` VALUES ('1633360787705827328', 'PL2', 'PL20024', '资产处置收益', NULL, '￥', 2, 1, '1633360774644764672', 'PL20004', 0, '/1633360774644764672/1633360787705827328', '/营业总成本/资产处置收益', '/PL20004/PL20024', NULL, NULL, 2, '0', '1', '1', '2023-03-08 14:55:33', '1', '2023-03-08 14:55:33');
INSERT INTO `qf_subject_info` VALUES ('1633360788372721664', 'PL3', 'PL20025', '营业利润', NULL, '￥', 1, 1, '0', NULL, 2, '/1633360788372721664', '/营业利润', '/PL20025', NULL, NULL, 1, '0', '1', '1', '2023-03-08 14:55:33', '1', '2023-03-08 14:55:34');
INSERT INTO `qf_subject_info` VALUES ('1633360788989284352', 'PL1', 'PL20026', '营业外收入', NULL, '￥', 2, 1, '1633360788372721664', 'PL20025', 1, '/1633360788372721664/1633360788989284352', '/营业利润/营业外收入', '/PL20025/PL20026', NULL, NULL, 2, '0', '1', '1', '2023-03-08 14:55:33', '1', '2023-03-08 14:55:33');
INSERT INTO `qf_subject_info` VALUES ('1633360789769424896', 'PL1', 'PL20027', '政府补助', NULL, '￥', 3, 1, '1633360788989284352', 'PL20026', 0, '/1633360788372721664/1633360788989284352/1633360789769424896', '/营业利润/营业外收入/政府补助', '/PL20025/PL20026/PL20027', NULL, NULL, 3, '0', '1', '1', '2023-03-08 14:55:33', '1', '2023-03-08 14:55:33');
INSERT INTO `qf_subject_info` VALUES ('1633360790469873664', 'PL2', 'PL20028', '营业外支出', NULL, '￥', 2, 1, '1633360788372721664', 'PL20025', 0, '/1633360788372721664/1633360790469873664', '/营业利润/营业外支出', '/PL20025/PL20028', NULL, NULL, 2, '0', '1', '1', '2023-03-08 14:55:34', '1', '2023-03-08 14:55:34');
INSERT INTO `qf_subject_info` VALUES ('1633360792411836416', 'PL3', 'PL20029', '利润总额', NULL, '￥', 1, 1, '0', NULL, 1, '/1633360792411836416', '/利润总额', '/PL20029', NULL, NULL, 1, '0', '1', '1', '2023-03-08 14:55:34', '1', '2023-03-08 14:55:34');
INSERT INTO `qf_subject_info` VALUES ('1633360793917591552', 'PL2', 'PL20030', '所得税费用', NULL, '￥', 2, 1, '1633360792411836416', 'PL20029', 0, '/1633360792411836416/1633360793917591552', '/利润总额/所得税费用', '/PL20029/PL20030', NULL, NULL, 2, '0', '1', '1', '2023-03-08 14:55:34', '1', '2023-03-08 14:55:34');
INSERT INTO `qf_subject_info` VALUES ('1633360794529959936', 'PL3', 'PL20031', '净利润', NULL, '￥', 1, 1, '0', NULL, 2, '/1633360794529959936', '/净利润', '/PL20031', NULL, NULL, 1, '0', '1', '1', '2023-03-08 14:55:35', '1', '2023-03-08 14:55:35');
INSERT INTO `qf_subject_info` VALUES ('1633360795062636544', 'PL3', 'PL20032', '归属于母公司所有者的净利润', NULL, '￥', 2, 1, '1633360794529959936', 'PL20031', 0, '/1633360794529959936/1633360795062636544', '/净利润/归属于母公司所有者的净利润', '/PL20031/PL20032', NULL, NULL, 2, '0', '1', '1', '2023-03-08 14:55:35', '1', '2023-03-08 14:55:35');
INSERT INTO `qf_subject_info` VALUES ('1633360795729530880', 'PL3', 'PL20033', '少数股东损益', NULL, '￥', 2, 1, '1633360794529959936', 'PL20031', 0, '/1633360794529959936/1633360795729530880', '/净利润/少数股东损益', '/PL20031/PL20033', NULL, NULL, 2, '0', '1', '1', '2023-03-08 14:55:35', '1', '2023-03-08 14:55:35');
INSERT INTO `qf_subject_info` VALUES ('1633380371557126144', 'RP1', 'RP', '财务-上报类', 'report', NULL, 2, NULL, '0', NULL, 24, '/1633380371557126144', '/上报类', '/RP', NULL, NULL, 1, '0', '1', '1', '2023-03-08 16:13:22', '1', '2023-03-08 16:20:47');
INSERT INTO `qf_subject_info` VALUES ('1633380373150961664', 'RP1', 'RP001', '开立银行账户个数（个）', NULL, '个', 2, NULL, '1633380371557126144', 'RP', 0, '/1633380371557126144/1633380373150961664', '/财务-上报类/开立银行账户个数（个）', '/RP/RP001', NULL, NULL, 2, '0', '1', '1', '2023-03-08 16:13:22', '1', '2023-03-08 16:13:22');
INSERT INTO `qf_subject_info` VALUES ('1633380373918519296', 'RP1', 'RP002', '其中：在中资银行开立账户个数', NULL, '个', 2, NULL, '1633380371557126144', 'RP', 0, '/1633380371557126144/1633380373918519296', '/财务-上报类/其中：在中资银行开立账户个数', '/RP/RP002', NULL, NULL, 2, '0', '1', '1', '2023-03-08 16:13:23', '1', '2023-03-08 16:13:23');
INSERT INTO `qf_subject_info` VALUES ('1633380374635745280', 'RP1', 'RP003', '在其他银行开立账户个数', NULL, '个', 2, NULL, '1633380371557126144', 'RP', 0, '/1633380371557126144/1633380374635745280', '/财务-上报类/在其他银行开立账户个数', '/RP/RP003', NULL, NULL, 2, '0', '1', '1', '2023-03-08 16:13:23', '1', '2023-03-08 16:13:23');
INSERT INTO `qf_subject_info` VALUES ('1633380375344582656', 'RP1', 'RP004', '其中:中方（人）', NULL, '人', 2, NULL, '1633380371557126144', 'RP', 0, '/1633380371557126144/1633380375344582656', '/财务-上报类/其中:中方（人）', '/RP/RP004', NULL, NULL, 2, '0', '1', '1', '2023-03-08 16:13:23', '1', '2023-03-08 16:13:23');
INSERT INTO `qf_subject_info` VALUES ('1633380376036642816', 'RP1', 'RP005', '注册资本', NULL, '￥', 2, NULL, '1633380371557126144', 'RP', 0, '/1633380371557126144/1633380376036642816', '/财务-上报类/注册资本', '/RP/RP005', NULL, NULL, 2, '0', '1', '1', '2023-03-08 16:13:23', '1', '2023-03-08 16:13:23');
INSERT INTO `qf_subject_info` VALUES ('1633380376774840320', 'RP1', 'RP006', '其中：中方', NULL, '人', 2, NULL, '1633380371557126144', 'RP', 0, '/1633380371557126144/1633380376774840320', '/财务-上报类/其中：中方', '/RP/RP006', NULL, NULL, 2, '0', '1', '1', '2023-03-08 16:13:23', '1', '2023-03-08 16:13:23');
INSERT INTO `qf_subject_info` VALUES ('1633380377492066304', 'RP1', 'RP007', '其中：以个人名义注册', NULL, '人', 2, NULL, '1633380371557126144', 'RP', 0, '/1633380371557126144/1633380377492066304', '/财务-上报类/其中：以个人名义注册', '/RP/RP007', NULL, NULL, 2, '0', '1', '1', '2023-03-08 16:13:23', '1', '2023-03-08 16:13:23');
INSERT INTO `qf_subject_info` VALUES ('1633380378167349248', 'RP1', 'RP008', '中方实际投资额', NULL, '￥', 2, NULL, '1633380371557126144', 'RP', 0, '/1633380371557126144/1633380378167349248', '/财务-上报类/中方实际投资额', '/RP/RP008', NULL, NULL, 2, '0', '1', '1', '2023-03-08 16:13:24', '1', '2023-03-08 16:13:24');
INSERT INTO `qf_subject_info` VALUES ('1633380378855215104', 'RP1', 'RP009', '其中：本年新增投资', NULL, '￥', 2, NULL, '1633380371557126144', 'RP', 0, '/1633380371557126144/1633380378855215104', '/财务-上报类/其中：本年新增投资', '/RP/RP009', NULL, NULL, 2, '0', '1', '1', '2023-03-08 16:13:24', '1', '2023-03-08 16:13:24');
INSERT INTO `qf_subject_info` VALUES ('1633380379748601856', 'RP1', 'RP010', '境外单位返投境内投资', NULL, '￥', 2, NULL, '1633380371557126144', 'RP', 0, '/1633380371557126144/1633380379748601856', '/财务-上报类/境外单位返投境内投资', '/RP/RP010', NULL, NULL, 2, '0', '1', '1', '2023-03-08 16:13:24', '1', '2023-03-08 16:13:24');
INSERT INTO `qf_subject_info` VALUES ('1633380380419690496', 'RP1', 'RP011', '驻在地所得税率（%）（按实际执行税率）', NULL, NULL, 2, NULL, '1633380371557126144', 'RP', 0, '/1633380371557126144/1633380380419690496', '/财务-上报类/驻在地所得税率（%）（按实际执行税率）', '/RP/RP011', NULL, NULL, 2, '0', '1', '1', '2023-03-08 16:13:24', '1', '2023-03-08 16:13:24');
INSERT INTO `qf_subject_info` VALUES ('1633380381103362048', 'RP1', 'RP012', '实际上交驻在地税金（费）总额', NULL, '￥', 2, NULL, '1633380371557126144', 'RP', 0, '/1633380371557126144/1633380381103362048', '/财务-上报类/实际上交驻在地税金（费）总额', '/RP/RP012', NULL, NULL, 2, '0', '1', '1', '2023-03-08 16:13:24', '1', '2023-03-08 16:13:24');
INSERT INTO `qf_subject_info` VALUES ('1633380381824782336', 'RP1', 'RP013', '对驻在地社会捐赠总额', NULL, '￥', 2, NULL, '1633380371557126144', 'RP', 0, '/1633380371557126144/1633380381824782336', '/财务-上报类/对驻在地社会捐赠总额', '/RP/RP013', NULL, NULL, 2, '0', '1', '1', '2023-03-08 16:13:24', '1', '2023-03-08 16:13:25');
INSERT INTO `qf_subject_info` VALUES ('1633380382529425408', 'RP1', 'RP014', '中方提供担保额', NULL, '￥', 2, NULL, '1633380371557126144', 'RP', 0, '/1633380371557126144/1633380382529425408', '/财务-上报类/中方提供担保额', '/RP/RP014', NULL, NULL, 2, '0', '1', '1', '2023-03-08 16:13:25', '1', '2023-03-08 16:13:25');
INSERT INTO `qf_subject_info` VALUES ('1633380383234068480', 'RP1', 'RP015', '其中：担保逾期额', NULL, '￥', 2, NULL, '1633380371557126144', 'RP', 0, '/1633380371557126144/1633380383234068480', '/财务-上报类/其中：担保逾期额', '/RP/RP015', NULL, NULL, 2, '0', '1', '1', '2023-03-08 16:13:25', '1', '2023-03-08 16:13:25');
INSERT INTO `qf_subject_info` VALUES ('1633380383917740032', 'RP1', 'RP016', '中方提供借款额', NULL, '￥', 2, NULL, '1633380371557126144', 'RP', 0, '/1633380371557126144/1633380383917740032', '/财务-上报类/中方提供借款额', '/RP/RP016', NULL, NULL, 2, '0', '1', '1', '2023-03-08 16:13:25', '1', '2023-03-08 16:13:25');
INSERT INTO `qf_subject_info` VALUES ('1633380384563662848', 'RP1', 'RP017', '其中：借款逾期额', NULL, '￥', 2, NULL, '1633380371557126144', 'RP', 0, '/1633380371557126144/1633380384563662848', '/财务-上报类/其中：借款逾期额', '/RP/RP017', NULL, NULL, 2, '0', '1', '1', '2023-03-08 16:13:25', '1', '2023-03-08 16:13:25');
INSERT INTO `qf_subject_info` VALUES ('1633380385222168576', 'RP1', 'RP018', '成立以来累计向中方分配利润', NULL, '￥', 2, NULL, '1633380371557126144', 'RP', 0, '/1633380371557126144/1633380385222168576', '/财务-上报类/成立以来累计向中方分配利润', '/RP/RP018', NULL, NULL, 2, '0', '1', '1', '2023-03-08 16:13:25', '1', '2023-03-08 16:13:25');
INSERT INTO `qf_subject_info` VALUES ('1633380385931005952', 'RP1', 'RP019', '其中：本年分配利润', NULL, '￥', 2, NULL, '1633380371557126144', 'RP', 0, '/1633380371557126144/1633380385931005952', '/财务-上报类/其中：本年分配利润', '/RP/RP019', NULL, NULL, 2, '0', '1', '1', '2023-03-08 16:13:25', '1', '2023-03-08 16:13:25');
INSERT INTO `qf_subject_info` VALUES ('1633380386652426240', 'RP1', 'RP020', '中方派出高管数（人）', NULL, '人', 2, NULL, '1633380371557126144', 'RP', 0, '/1633380371557126144/1633380386652426240', '/财务-上报类/中方派出高管数（人）', '/RP/RP020', NULL, NULL, 2, '0', '1', '1', '2023-03-08 16:13:26', '1', '2023-03-08 16:13:26');
INSERT INTO `qf_subject_info` VALUES ('1633380387407400960', 'RP1', 'RP021', '经营情况', NULL, NULL, 2, NULL, '1633380371557126144', 'RP', 0, '/1633380371557126144/1633380387407400960', '/财务-上报类/经营情况', '/RP/RP021', NULL, NULL, 2, '0', '1', '1', '2023-03-08 16:13:26', '1', '2023-03-08 16:13:26');
INSERT INTO `qf_subject_info` VALUES ('1633380388128821248', 'RP1', 'RP022', '其中：中方', NULL, NULL, 2, NULL, '1633380371557126144', 'RP', 0, '/1633380371557126144/1633380388128821248', '/财务-上报类/其中：中方', '/RP/RP022', NULL, NULL, 2, '0', '1', '1', '2023-03-08 16:13:26', '1', '2023-03-08 16:13:26');
INSERT INTO `qf_subject_info` VALUES ('1633380388892184576', 'RP1', 'RP023', '资金情况', NULL, NULL, 2, NULL, '1633380371557126144', 'RP', 0, '/1633380371557126144/1633380388892184576', '/财务-上报类/资金情况', '/RP/RP023', NULL, NULL, 2, '0', '1', '1', '2023-03-08 16:13:26', '1', '2023-03-08 16:13:26');
INSERT INTO `qf_subject_info` VALUES ('1633380389617799168', 'RP1', 'RP024', '其中：在中资银行存款余额', NULL, NULL, 2, NULL, '1633380371557126144', 'RP', 0, '/1633380371557126144/1633380389617799168', '/财务-上报类/其中：在中资银行存款余额', '/RP/RP024', NULL, NULL, 2, '0', '1', '1', '2023-03-08 16:13:26', '1', '2023-03-08 16:13:26');

-- ----------------------------
-- Table structure for qf_subject_international_info
-- ----------------------------
DROP TABLE IF EXISTS `qf_subject_international_info`;
CREATE TABLE `qf_subject_international_info`  (
  `id_` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '主键ID',
  `type_` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '科目类型：科目所属的报表【字典】',
  `code_` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '科目编码（唯一值）',
  `name_` varchar(120) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '科目中文名称',
  `name_en_` varchar(120) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '科目英文名称',
  `unit_` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '科目计量单位',
  `level_` varchar(11) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '级别【字典】（1：1级，2：二级，3：三级）',
  `parent_id_` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '父级ID',
  `has_children_` int(11) NULL DEFAULT NULL COMMENT '子节点个数',
  `full_id_` varchar(2000) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'ID_全路径',
  `full_name_` varchar(2000) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'name_全路径',
  `full_code_` varchar(2000) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'code_全路径',
  `memo_` varchar(500) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '备注',
  `sn_` int(11) NULL DEFAULT NULL COMMENT '排序',
  `is_dele_` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '0' COMMENT '删除标识【字典】（0：未删除，1：已删除）',
  `create_by_` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '创建人',
  `create_org_id_` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '创建人_组织_ID',
  `create_time_` timestamp NULL DEFAULT NULL COMMENT '创建时间',
  `update_by_` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '修改人员',
  `update_time_` timestamp NULL DEFAULT NULL COMMENT '修改时间',
  PRIMARY KEY (`id_`) USING BTREE
) ENGINE = oceanbase CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '国际准则科目信息' ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of qf_subject_international_info
-- ----------------------------
INSERT INTO `qf_subject_international_info` VALUES ('1630784869674127360', 'BS1,BS2,BS3', 'BS', '财务-资产负债类', 'BS', '', '0', '0', 2, '/1630784869674127360', '/财务-资产负责类', '/BS', '', 1, '0', '1', '1', '2023-03-01 12:19:46', '1', '2023-03-01 14:58:49');
INSERT INTO `qf_subject_international_info` VALUES ('1630785212050968576', 'PL1,PL2,PL3', 'PL', '财务-利润类', 'PL', '', '0', '0', 6, '/1630785212050968576', '/财务-利润类', '/PL', '', 2, '0', '1', '1', '2023-03-01 12:21:08', '1', '2023-03-01 14:51:05');
INSERT INTO `qf_subject_international_info` VALUES ('1630785386760507392', 'CF1', 'CF', '财务-现金流量类', 'CF', '', '0', '0', 7, '/1630785386760507392', '/财务-现金流量类', '/CF', '', 3, '0', '1', '1', '2023-03-01 12:21:49', '1', '2023-03-01 15:07:12');
INSERT INTO `qf_subject_international_info` VALUES ('1630785662485663744', 'HR1', 'HR', '人力资源类', 'HR', '', '0', '0', 36, '/1630785662485663744', '/人力资源类', '/HR', '', 6, '0', '1', '1', '2023-03-01 12:22:55', '1', '2023-03-01 15:11:07');
INSERT INTO `qf_subject_international_info` VALUES ('1630786034092609536', 'OP1,OP2', 'OP', '运营类', 'OP', '', '0', '0', 10, '/1630786034092609536', '/运营类', '/OP', '', 4, '0', '1', '1', '2023-03-01 12:24:24', '1', '2023-03-03 13:59:24');
INSERT INTO `qf_subject_international_info` VALUES ('1630786302679060480', 'IN1', 'INV', '投资类', 'invest', '', '2', '1630785662485663744', 0, '/1630785662485663744/1630786302679060480', '/人力资源类/投资类', '/HR/INV', '', 5, '1', '1', '1', '2023-03-01 12:25:28', '1', '2023-03-01 13:57:56');
INSERT INTO `qf_subject_international_info` VALUES ('1630812037636558848', 'IN1', 'INV', '投资类', 'invest', '', '1', '0', 4, '/1630812037636558848', '/投资类', '/INV', '', 1, '0', '1', '1', '2023-03-01 14:07:43', '1', '2023-03-03 13:58:12');
INSERT INTO `qf_subject_international_info` VALUES ('1630822946622803968', 'PL1', 'PL3300S', '销售收入', 'Revenues', '€', '1', '1630785212050968576', 14, '/1630785212050968576/1630822946622803968', '/财务-利润类/销售收入', '/PL/PL3300S', NULL, 1, '0', '1', '1', '2023-03-01 14:51:04', '1', '2023-03-01 14:54:07');
INSERT INTO `qf_subject_international_info` VALUES ('1630822947239366656', 'PL3', 'EBITDA', '息税折旧摊销前利润', 'EBITDA', '€', '1', '1630785212050968576', 2, '/1630785212050968576/1630822947239366656', '/财务-利润类/息税折旧摊销前利润', '/PL/EBITDA', NULL, 2, '0', '1', '1', '2023-03-01 14:51:05', '1', '2023-03-01 14:54:07');
INSERT INTO `qf_subject_international_info` VALUES ('1630822947855929344', 'PL3', 'EBITA', '息税摊销前利润', 'EBITA', '€', '1', '1630785212050968576', 3, '/1630785212050968576/1630822947855929344', '/财务-利润类/息税摊销前利润', '/PL/EBITA', NULL, 3, '0', '1', '1', '2023-03-01 14:51:05', '1', '2023-03-01 14:54:08');
INSERT INTO `qf_subject_international_info` VALUES ('1630822948472492032', 'PL3', 'EBIT', '息税前利润', 'EBIT', '€', '1', '1630785212050968576', 8, '/1630785212050968576/1630822948472492032', '/财务-利润类/息税前利润', '/PL/EBIT', NULL, 4, '0', '1', '1', '2023-03-01 14:51:05', '1', '2023-03-03 15:57:01');
INSERT INTO `qf_subject_international_info` VALUES ('1630822949101637632', 'PL3', 'PL5800', '利润总额', 'EBT', '€', '1', '1630785212050968576', 2, '/1630785212050968576/1630822949101637632', '/财务-利润类/利润总额', '/PL/PL5800', NULL, 5, '0', '1', '1', '2023-03-01 14:51:05', '1', '2023-03-01 14:54:09');
INSERT INTO `qf_subject_international_info` VALUES ('1630822949776920576', 'PL3', '900000', '净利润', 'Net result for the period', '€', '1', '1630785212050968576', 2, '/1630785212050968576/1630822949776920576', '/财务-利润类/净利润', '/PL/900000', NULL, 6, '0', '1', '1', '2023-03-01 14:51:05', '1', '2023-03-01 14:54:09');
INSERT INTO `qf_subject_international_info` VALUES ('1630823702440579072', 'PL1', 'PL3000', '商品销售收入', 'Revenues from the sale of goods', '€', '2', '1630822946622803968', 14, '/1630785212050968576/1630822946622803968/1630823702440579072', '/财务-利润类/销售收入/商品销售收入', '/PL/PL3300S/PL3000', NULL, 1, '0', '1', '1', '2023-03-01 14:54:05', '1', '2023-03-01 14:54:35');
INSERT INTO `qf_subject_international_info` VALUES ('1630823703258468352', 'PL1', 'PL3100', '关联公司的商品销售收入', 'Revenues from the sale of goods from affiliated companies', '€', '2', '1630822946622803968', 6, '/1630785212050968576/1630822946622803968/1630823703258468352', '/财务-利润类/销售收入/关联公司的商品销售收入', '/PL/PL3300S/PL3100', NULL, 2, '0', '1', '1', '2023-03-01 14:54:05', '1', '2023-03-01 14:54:36');
INSERT INTO `qf_subject_international_info` VALUES ('1630823703875031040', 'PL1', 'PL3200', '其他销售收入', 'Other revenues', '€', '2', '1630822946622803968', 4, '/1630785212050968576/1630822946622803968/1630823703875031040', '/财务-利润类/销售收入/其他销售收入', '/PL/PL3300S/PL3200', NULL, 3, '0', '1', '1', '2023-03-01 14:54:05', '1', '2023-03-01 14:54:37');
INSERT INTO `qf_subject_international_info` VALUES ('1630823704491593728', 'PL1', 'PL3400', '其他营业收入', 'Other operating income', '€', '2', '1630822946622803968', 3, '/1630785212050968576/1630822946622803968/1630823704491593728', '/财务-利润类/销售收入/其他营业收入', '/PL/PL3300S/PL3400', NULL, 4, '0', '1', '1', '2023-03-01 14:54:05', '1', '2023-03-01 14:54:37');
INSERT INTO `qf_subject_international_info` VALUES ('1630823705154293760', 'PL1', 'PL3500', '以公允价值计量的其他营业收入', 'Other operating income from fair value measurement', '€', '2', '1630822946622803968', 2, '/1630785212050968576/1630822946622803968/1630823705154293760', '/财务-利润类/销售收入/以公允价值计量的其他营业收入', '/PL/PL3300S/PL3500', NULL, 5, '0', '1', '1', '2023-03-01 14:54:05', '1', '2023-03-01 14:54:38');
INSERT INTO `qf_subject_international_info` VALUES ('1630823705775050752', 'PL1', 'PL3600', '来自关联公司的其他营业收入', 'Other operating income from affiliated companies', '€', '2', '1630822946622803968', 8, '/1630785212050968576/1630822946622803968/1630823705775050752', '/财务-利润类/销售收入/来自关联公司的其他营业收入', '/PL/PL3300S/PL3600', NULL, 6, '0', '1', '1', '2023-03-01 14:54:05', '1', '2023-03-01 14:54:39');
INSERT INTO `qf_subject_international_info` VALUES ('1630823706400002048', 'PL1', 'PL3700', '来自关联公司的其他收入', 'other revenues from affiliated companies', '€', '2', '1630822946622803968', 8, '/1630785212050968576/1630822946622803968/1630823706400002048', '/财务-利润类/销售收入/来自关联公司的其他收入', '/PL/PL3300S/PL3700', NULL, 7, '0', '1', '1', '2023-03-01 14:54:06', '1', '2023-03-01 14:54:41');
INSERT INTO `qf_subject_international_info` VALUES ('1630823707041730560', 'PL2', 'PL3800', '成品和半产品库存的变动', 'Changes in stock of finished and unfinished products', '€', '2', '1630822946622803968', 10, '/1630785212050968576/1630822946622803968/1630823707041730560', '/财务-利润类/销售收入/成品和半产品库存的变动', '/PL/PL3300S/PL3800', NULL, 8, '0', '1', '1', '2023-03-01 14:54:06', '1', '2023-03-01 14:54:42');
INSERT INTO `qf_subject_international_info` VALUES ('1630823707637321728', 'PL2', 'PL3900', '其他制造费用', 'Other own work capitalised', '€', '2', '1630822946622803968', 2, '/1630785212050968576/1630822946622803968/1630823707637321728', '/财务-利润类/销售收入/其他制造费用', '/PL/PL3300S/PL3900', NULL, 9, '0', '1', '1', '2023-03-01 14:54:06', '1', '2023-03-01 14:54:42');
INSERT INTO `qf_subject_international_info` VALUES ('1630823708253884416', 'PL2', 'PL4000', '购买的材料和服务成本', 'Cost of material and services purchased', '€', '2', '1630822946622803968', 44, '/1630785212050968576/1630822946622803968/1630823708253884416', '/财务-利润类/销售收入/购买的材料和服务成本', '/PL/PL3300S/PL4000', NULL, 10, '0', '1', '1', '2023-03-01 14:54:06', '1', '2023-03-01 14:54:49');
INSERT INTO `qf_subject_international_info` VALUES ('1630823708904001536', 'PL2', 'PL4100', '关联公司商品和服务的材料支出', 'Material expenditure for goods and services from affiliated companies', '€', '2', '1630822946622803968', 5, '/1630785212050968576/1630822946622803968/1630823708904001536', '/财务-利润类/销售收入/关联公司商品和服务的材料支出', '/PL/PL3300S/PL4100', NULL, 11, '0', '1', '1', '2023-03-01 14:54:06', '1', '2023-03-01 14:54:50');
INSERT INTO `qf_subject_international_info` VALUES ('1630823709545730048', 'PL2', 'PL4200', '人工费用', 'Personnel expenses', '€', '2', '1630822946622803968', 60, '/1630785212050968576/1630822946622803968/1630823709545730048', '/财务-利润类/销售收入/人工费用', '/PL/PL3300S/PL4200', NULL, 12, '0', '1', '1', '2023-03-01 14:54:06', '1', '2023-03-08 09:25:11');
INSERT INTO `qf_subject_international_info` VALUES ('1630823710183264256', 'PL2', 'PL4600', '其他经营费用', 'Other operating expenses', '€', '2', '1630823709545730048', 0, '/1630785212050968576/1630822946622803968/1630823709545730048/1630823710183264256', '/财务-利润类/销售收入/人工费用/其他经营费用', '/PL/PL3300S/PL4200/PL4600', NULL, 13, '0', '1', '1', '2023-03-01 14:54:06', '1', '2023-03-01 14:54:06');
INSERT INTO `qf_subject_international_info` VALUES ('1630823710804021248', 'PL2', 'PL4700', '公允价值计量的其他营业费用', 'Other operating expense of fair value measurement', '€', '2', '1630822946622803968', 2, '/1630785212050968576/1630822946622803968/1630823710804021248', '/财务-利润类/销售收入/公允价值计量的其他营业费用', '/PL/PL3300S/PL4700', NULL, 14, '0', '1', '1', '2023-03-01 14:54:07', '1', '2023-03-01 14:54:59');
INSERT INTO `qf_subject_international_info` VALUES ('1630823711399612416', 'PL2', 'PL4800', '关联公司提供服务的其他营业费用', 'Other operating expenses for services from affiliated companies', '€', '2', '1630822946622803968', 11, '/1630785212050968576/1630822946622803968/1630823711399612416', '/财务-利润类/销售收入/关联公司提供服务的其他营业费用', '/PL/PL3300S/PL4800', NULL, 15, '0', '1', '1', '2023-03-01 14:54:07', '1', '2023-03-01 14:55:01');
INSERT INTO `qf_subject_international_info` VALUES ('1630823712150392832', 'PL2', 'PL4320', '国定资产折旧', 'Depreciation on property, plant and equipment', '€', '2', '1630822947239366656', 5, '/1630785212050968576/1630822947239366656/1630823712150392832', '/财务-利润类/息税折旧摊销前利润/国定资产折旧', '/PL/EBITDA/PL4320', NULL, 1, '0', '1', '1', '2023-03-01 14:54:07', '1', '2023-03-01 14:55:02');
INSERT INTO `qf_subject_international_info` VALUES ('1630823712745984000', 'PL2', 'PL4520', '固定资产减值', 'Impairment tangible assets', '€', '2', '1630822947239366656', 4, '/1630785212050968576/1630822947239366656/1630823712745984000', '/财务-利润类/息税折旧摊销前利润/固定资产减值', '/PL/EBITDA/PL4520', NULL, 2, '0', '1', '1', '2023-03-01 14:54:07', '1', '2023-03-01 14:55:02');
INSERT INTO `qf_subject_international_info` VALUES ('1630823713421266944', 'PL2', 'PL4310', '无形资产摊销', 'Amortisation on intangible assets', '€', '2', '1630822947855929344', 1, '/1630785212050968576/1630822947855929344/1630823713421266944', '/财务-利润类/息税摊销前利润/无形资产摊销', '/PL/EBITA/PL4310', NULL, 1, '0', '1', '1', '2023-03-01 14:54:07', '1', '2023-03-01 14:55:03');
INSERT INTO `qf_subject_international_info` VALUES ('1630823714054606848', 'PL2', 'PL4400', '商誉减值', 'Impairment of goodwill', '€', '2', '1630822947855929344', 1, '/1630785212050968576/1630822947855929344/1630823714054606848', '/财务-利润类/息税摊销前利润/商誉减值', '/PL/EBITA/PL4400', NULL, 2, '0', '1', '1', '2023-03-01 14:54:07', '1', '2023-03-01 14:55:03');
INSERT INTO `qf_subject_international_info` VALUES ('1630823714662780928', 'PL2', 'PL4510', '无形资产减值', 'Impairment intangible assets', '€', '2', '1630822947855929344', 2, '/1630785212050968576/1630822947855929344/1630823714662780928', '/财务-利润类/息税摊销前利润/无形资产减值', '/PL/EBITA/PL4510', NULL, 3, '0', '1', '1', '2023-03-01 14:54:08', '1', '2023-03-01 14:55:03');
INSERT INTO `qf_subject_international_info` VALUES ('1630823715338063872', 'PL1', 'PL5000', '关联公司利息收入', 'Interest income affiliated companies', '€', '3', '1630822948472492032', 2, '/1630785212050968576/1630822948472492032/1630823715338063872', '/财务-利润类/息税前利润/关联公司利息收入', '/PL/EBIT/PL5000', NULL, 1, '0', '1', '1', '2023-03-01 14:54:08', '1', '2023-03-03 15:56:35');
INSERT INTO `qf_subject_international_info` VALUES ('1630823715921072128', 'PL1', 'PL5100', '财务收入', 'Financial income', '€', '3', '1630822948472492032', 3, '/1630785212050968576/1630822948472492032/1630823715921072128', '/财务-利润类/息税前利润/财务收入', '/PL/EBIT/PL5100', NULL, 2, '0', '1', '1', '2023-03-01 14:54:08', '1', '2023-03-03 15:58:19');
INSERT INTO `qf_subject_international_info` VALUES ('1630823716533440512', 'PL1', 'PL5200', '股利收入', 'dividend income', '€', '2', '1630822948472492032', 1, '/1630785212050968576/1630822948472492032/1630823716533440512', '/财务-利润类/息税前利润/股利收入', '/PL/EBIT/PL5200', NULL, 3, '0', '1', '1', '2023-03-01 14:54:08', '1', '2023-03-01 14:55:04');
INSERT INTO `qf_subject_international_info` VALUES ('1630823717204529152', 'PL1', 'PL5300', '利率衍生品公允价值变动收益', 'Gain on fair value of interest rate derivatives', '€', '2', '1630822948472492032', 1, '/1630785212050968576/1630822948472492032/1630823717204529152', '/财务-利润类/息税前利润/利率衍生品公允价值变动收益', '/PL/EBIT/PL5300', NULL, 4, '0', '1', '1', '2023-03-01 14:54:08', '1', '2023-03-01 14:55:04');
INSERT INTO `qf_subject_international_info` VALUES ('1630823717833674752', 'PL2', 'PL5500', '关联公司利息费用', 'Interest expenses affiliated companies', '€', '2', '1630822948472492032', 3, '/1630785212050968576/1630822948472492032/1630823717833674752', '/财务-利润类/息税前利润/关联公司利息费用', '/PL/EBIT/PL5500', NULL, 5, '0', '1', '1', '2023-03-01 14:54:08', '1', '2023-03-01 14:55:05');
INSERT INTO `qf_subject_international_info` VALUES ('1630823718479597568', 'PL2', 'PL5400', '财务费用', 'Financial expenses', '€', '2', '1630822948472492032', 12, '/1630785212050968576/1630822948472492032/1630823718479597568', '/财务-利润类/息税前利润/财务费用', '/PL/EBIT/PL5400', NULL, 6, '0', '1', '1', '2023-03-01 14:54:08', '1', '2023-03-01 14:55:06');
INSERT INTO `qf_subject_international_info` VALUES ('1630823719180046336', 'PL2', 'PL5600', '利率衍生品公允价值变动损失', 'loss on fair value of interest rate derivatives', '€', '2', '1630822948472492032', 1, '/1630785212050968576/1630822948472492032/1630823719180046336', '/财务-利润类/息税前利润/利率衍生品公允价值变动损失', '/PL/EBIT/PL5600', NULL, 7, '0', '1', '1', '2023-03-01 14:54:09', '1', '2023-03-01 14:55:06');
INSERT INTO `qf_subject_international_info` VALUES ('1630823719813386240', 'PL2', 'PL5700', '投资收益/损失', 'Share in profit of associates', '€', '2', '1630822948472492032', 1, '/1630785212050968576/1630822948472492032/1630823719813386240', '/财务-利润类/息税前利润/投资收益/损失', '/PL/EBIT/PL5700', NULL, 8, '0', '1', '1', '2023-03-01 14:54:09', '1', '2023-03-01 14:55:07');
INSERT INTO `qf_subject_international_info` VALUES ('1630823720438337536', 'PL2', 'PL5900', '所得税', 'Income taxes', '€', '2', '1630822949101637632', 4, '/1630785212050968576/1630822949101637632/1630823720438337536', '/财务-利润类/利润总额/所得税', '/PL/PL5800/PL5900', NULL, 1, '0', '1', '1', '2023-03-01 14:54:09', '1', '2023-03-01 14:55:07');
INSERT INTO `qf_subject_international_info` VALUES ('1630823721075871744', 'PL2', '480000', '利润转移协议', 'P+L Transfer Agreement', '€', '2', '1630822949101637632', 1, '/1630785212050968576/1630822949101637632/1630823721075871744', '/财务-利润类/利润总额/利润转移协议', '/PL/PL5800/480000', NULL, 2, '0', '1', '1', '2023-03-01 14:54:09', '1', '2023-03-01 14:55:07');
INSERT INTO `qf_subject_international_info` VALUES ('1630823721801486336', 'PL3', 'PL8100', '归属于母公司的净利润', 'Attributable to owners of the parent', '€', '2', '1630822949776920576', 0, '/1630785212050968576/1630822949776920576/1630823721801486336', '/财务-利润类/净利润/归属于母公司的净利润', '/PL/900000/PL8100', NULL, 1, '0', '1', '1', '2023-03-01 14:54:09', '1', '2023-03-01 14:54:09');
INSERT INTO `qf_subject_international_info` VALUES ('1630823722422243328', 'PL3', 'PL8200', '归属于非控制性权益的净利润', 'Attributable to non-controlling interests', '€', '2', '1630822949776920576', 1, '/1630785212050968576/1630822949776920576/1630823722422243328', '/财务-利润类/净利润/归属于非控制性权益的净利润', '/PL/900000/PL8200', NULL, 2, '0', '1', '1', '2023-03-01 14:54:09', '1', '2023-03-01 14:55:08');
INSERT INTO `qf_subject_international_info` VALUES ('1630823822192152576', 'PL1', '311001', '国内商品销售收入', 'Sales revenue from goods domestic', '€', '3', '1630823702440579072', 0, '/1630785212050968576/1630822946622803968/1630823702440579072/1630823822192152576', '/财务-利润类/销售收入/商品销售收入/国内商品销售收入', '/PL/PL3300S/PL3000/311001', NULL, 1, '0', '1', '1', '2023-03-01 14:54:33', '1', '2023-03-01 14:54:33');
INSERT INTO `qf_subject_international_info` VALUES ('1630823822842269696', 'PL1', '311002', '欧盟商品销售收入', 'Sales revenue from goods European Union (EU)', '€', '3', '1630823702440579072', 0, '/1630785212050968576/1630822946622803968/1630823702440579072/1630823822842269696', '/财务-利润类/销售收入/商品销售收入/欧盟商品销售收入', '/PL/PL3300S/PL3000/311002', NULL, 2, '0', '1', '1', '2023-03-01 14:54:33', '1', '2023-03-01 14:54:33');
INSERT INTO `qf_subject_international_info` VALUES ('1630823823509164032', 'PL1', '311003', '第三国商品销售收入', 'Sales revenue from goods third country', '€', '3', '1630823702440579072', 0, '/1630785212050968576/1630822946622803968/1630823702440579072/1630823823509164032', '/财务-利润类/销售收入/商品销售收入/第三国商品销售收入', '/PL/PL3300S/PL3000/311003', NULL, 3, '0', '1', '1', '2023-03-01 14:54:33', '1', '2023-03-01 14:54:33');
INSERT INTO `qf_subject_international_info` VALUES ('1630823824134115328', 'PL1', '311004', '国内其他商品销售收入', 'Sales revenue from goods other domestic', '€', '3', '1630823702440579072', 0, '/1630785212050968576/1630822946622803968/1630823702440579072/1630823824134115328', '/财务-利润类/销售收入/商品销售收入/国内其他商品销售收入', '/PL/PL3300S/PL3000/311004', NULL, 4, '0', '1', '1', '2023-03-01 14:54:34', '1', '2023-03-01 14:54:34');
INSERT INTO `qf_subject_international_info` VALUES ('1630823824788426752', 'PL1', '311005', '来自其他欧盟（EU）的销售收入', 'Sales revenue from sales other European Union (EU)', '€', '3', '1630823702440579072', 0, '/1630785212050968576/1630822946622803968/1630823702440579072/1630823824788426752', '/财务-利润类/销售收入/商品销售收入/来自其他欧盟（EU）的销售收入', '/PL/PL3300S/PL3000/311005', NULL, 5, '0', '1', '1', '2023-03-01 14:54:34', '1', '2023-03-01 14:54:34');
INSERT INTO `qf_subject_international_info` VALUES ('1630823825514041344', 'PL1', '311006', '来自其他第三国的商品销售收入', 'Sales revenue from goods other third country', '€', '3', '1630823702440579072', 0, '/1630785212050968576/1630822946622803968/1630823702440579072/1630823825514041344', '/财务-利润类/销售收入/商品销售收入/来自其他第三国的商品销售收入', '/PL/PL3300S/PL3000/311006', NULL, 6, '0', '1', '1', '2023-03-01 14:54:34', '1', '2023-03-01 14:54:34');
INSERT INTO `qf_subject_international_info` VALUES ('1630823826243850240', 'PL1', '311013', '国内退货/投诉', 'return shipments/complaints domestic', '€', '3', '1630823702440579072', 0, '/1630785212050968576/1630822946622803968/1630823702440579072/1630823826243850240', '/财务-利润类/销售收入/商品销售收入/国内退货/投诉', '/PL/PL3300S/PL3000/311013', NULL, 7, '0', '1', '1', '2023-03-01 14:54:34', '1', '2023-03-01 14:54:34');
INSERT INTO `qf_subject_international_info` VALUES ('1630823826914938880', 'PL1', '311014', '欧盟退货/投诉EU）', 'return shipments/complaints European Union (EU)', '€', '3', '1630823702440579072', 0, '/1630785212050968576/1630822946622803968/1630823702440579072/1630823826914938880', '/财务-利润类/销售收入/商品销售收入/欧盟退货/投诉EU）', '/PL/PL3300S/PL3000/311014', NULL, 8, '0', '1', '1', '2023-03-01 14:54:34', '1', '2023-03-01 14:54:34');
INSERT INTO `qf_subject_international_info` VALUES ('1630823827527307264', 'PL1', '311026', '国内折扣/奖金', 'rebates/bonuses domestic', '€', '3', '1630823702440579072', 0, '/1630785212050968576/1630822946622803968/1630823702440579072/1630823827527307264', '/财务-利润类/销售收入/商品销售收入/国内折扣/奖金', '/PL/PL3300S/PL3000/311026', NULL, 9, '0', '1', '1', '2023-03-01 14:54:34', '1', '2023-03-01 14:54:34');
INSERT INTO `qf_subject_international_info` VALUES ('1630823828110315520', 'PL1', '311027', '欧盟（EU）的回扣/奖金', 'rebates/bonuses European Union (EU)', '€', '3', '1630823702440579072', 0, '/1630785212050968576/1630822946622803968/1630823702440579072/1630823828110315520', '/财务-利润类/销售收入/商品销售收入/欧盟（EU）的回扣/奖金', '/PL/PL3300S/PL3000/311027', NULL, 10, '0', '1', '1', '2023-03-01 14:54:35', '1', '2023-03-01 14:54:35');
INSERT INTO `qf_subject_international_info` VALUES ('1630823828731072512', 'PL1', '311028', '第三国的回扣/奖金', 'rebates/bonuses third country', '€', '3', '1630823702440579072', 0, '/1630785212050968576/1630822946622803968/1630823702440579072/1630823828731072512', '/财务-利润类/销售收入/商品销售收入/第三国的回扣/奖金', '/PL/PL3300S/PL3000/311028', NULL, 11, '0', '1', '1', '2023-03-01 14:54:35', '1', '2023-03-01 14:54:35');
INSERT INTO `qf_subject_international_info` VALUES ('1630823829347635200', 'PL1', '313001', '国内客户现金折扣', 'customer cash discount domestic', '€', '3', '1630823702440579072', 0, '/1630785212050968576/1630822946622803968/1630823702440579072/1630823829347635200', '/财务-利润类/销售收入/商品销售收入/国内客户现金折扣', '/PL/PL3300S/PL3000/313001', NULL, 12, '0', '1', '1', '2023-03-01 14:54:35', '1', '2023-03-01 14:54:35');
INSERT INTO `qf_subject_international_info` VALUES ('1630823829951614976', 'PL1', '313002', '欧盟客户现金折扣（EU）', 'customer cash discount European Union (EU)', '€', '3', '1630823702440579072', 0, '/1630785212050968576/1630822946622803968/1630823702440579072/1630823829951614976', '/财务-利润类/销售收入/商品销售收入/欧盟客户现金折扣（EU）', '/PL/PL3300S/PL3000/313002', NULL, 13, '0', '1', '1', '2023-03-01 14:54:35', '1', '2023-03-01 14:54:35');
INSERT INTO `qf_subject_international_info` VALUES ('1630823830593343488', 'PL1', '313003', '第三国客户现金折扣', 'customer cash discount third country', '€', '3', '1630823702440579072', 0, '/1630785212050968576/1630822946622803968/1630823702440579072/1630823830593343488', '/财务-利润类/销售收入/商品销售收入/第三国客户现金折扣', '/PL/PL3300S/PL3000/313003', NULL, 14, '0', '1', '1', '2023-03-01 14:54:35', '1', '2023-03-01 14:54:35');
INSERT INTO `qf_subject_international_info` VALUES ('1630823831193128960', 'PL1', '311007', '附属公司间的国内商品销售收入', 'Sales revenue from goods to consolidated companies domestic', '€', '3', '1630823703258468352', 0, '/1630785212050968576/1630822946622803968/1630823703258468352/1630823831193128960', '/财务-利润类/销售收入/关联公司的商品销售收入/附属公司间的国内商品销售收入', '/PL/PL3300S/PL3100/311007', NULL, 1, '0', '1', '1', '2023-03-01 14:54:35', '1', '2023-03-01 14:54:35');
INSERT INTO `qf_subject_international_info` VALUES ('1630823831805497344', 'PL1', '311008', '附属公司间的欧盟商品销售收入', 'Sales revenue from goods to consolidated comp. within Europ.Union (EU)', '€', '3', '1630823703258468352', 0, '/1630785212050968576/1630822946622803968/1630823703258468352/1630823831805497344', '/财务-利润类/销售收入/关联公司的商品销售收入/附属公司间的欧盟商品销售收入', '/PL/PL3300S/PL3100/311008', NULL, 2, '0', '1', '1', '2023-03-01 14:54:35', '1', '2023-03-01 14:54:35');
INSERT INTO `qf_subject_international_info` VALUES ('1630823832547889152', 'PL1', '311009', '附属公司间的第三国商品销售收入', 'Sales revenue from goods to consolidated companies third country', '€', '3', '1630823703258468352', 0, '/1630785212050968576/1630822946622803968/1630823703258468352/1630823832547889152', '/财务-利润类/销售收入/关联公司的商品销售收入/附属公司间的第三国商品销售收入', '/PL/PL3300S/PL3100/311009', NULL, 3, '0', '1', '1', '2023-03-01 14:54:36', '1', '2023-03-01 14:54:36');
INSERT INTO `qf_subject_international_info` VALUES ('1630823833160257536', 'PL1', '311017', '附属公司间的欧盟退货/投诉', 'return shipments/complaints to consolidated companies Europ. Union EU', '€', '3', '1630823703258468352', 0, '/1630785212050968576/1630822946622803968/1630823703258468352/1630823833160257536', '/财务-利润类/销售收入/关联公司的商品销售收入/附属公司间的欧盟退货/投诉', '/PL/PL3300S/PL3100/311017', NULL, 4, '0', '1', '1', '2023-03-01 14:54:36', '1', '2023-03-01 14:54:36');
INSERT INTO `qf_subject_international_info` VALUES ('1630823833768431616', 'PL1', '311018', '附属公司间的第三国退货/投诉EU', 'return shipments/complaints to consolidated companies third country', '€', '3', '1630823703258468352', 0, '/1630785212050968576/1630822946622803968/1630823703258468352/1630823833768431616', '/财务-利润类/销售收入/关联公司的商品销售收入/附属公司间的第三国退货/投诉EU', '/PL/PL3300S/PL3100/311018', NULL, 5, '0', '1', '1', '2023-03-01 14:54:36', '1', '2023-03-01 14:54:36');
INSERT INTO `qf_subject_international_info` VALUES ('1630823834431131648', 'PL1', '311029', '关联公司间固定资产交付的收入', 'Sales rev. from delivery of fixed assets generated to affiliated comp.', '€', '3', '1630823703258468352', 0, '/1630785212050968576/1630822946622803968/1630823703258468352/1630823834431131648', '/财务-利润类/销售收入/关联公司的商品销售收入/关联公司间固定资产交付的收入', '/PL/PL3300S/PL3100/311029', NULL, 6, '0', '1', '1', '2023-03-01 14:54:36', '1', '2023-03-01 14:54:36');
INSERT INTO `qf_subject_international_info` VALUES ('1630823835093831680', 'PL1', '311019', '国内开发/工具成本报销收入', 'revenues for reimbursement of development-/tooling costs domestic', '€', '3', '1630823703875031040', 0, '/1630785212050968576/1630822946622803968/1630823703875031040/1630823835093831680', '/财务-利润类/销售收入/其他销售收入/国内开发/工具成本报销收入', '/PL/PL3300S/PL3200/311019', NULL, 1, '0', '1', '1', '2023-03-01 14:54:36', '1', '2023-03-01 14:54:36');
INSERT INTO `qf_subject_international_info` VALUES ('1630823835714588672', 'PL1', '311020', '欧盟开发/工具成本报销收入', 'rev. for reimbursem. of development-/tooling costs Europ.Union(EU)', '€', '3', '1630823703875031040', 0, '/1630785212050968576/1630822946622803968/1630823703875031040/1630823835714588672', '/财务-利润类/销售收入/其他销售收入/欧盟开发/工具成本报销收入', '/PL/PL3300S/PL3200/311020', NULL, 2, '0', '1', '1', '2023-03-01 14:54:36', '1', '2023-03-01 14:54:36');
INSERT INTO `qf_subject_international_info` VALUES ('1630823836347928576', 'PL1', '311021', '第三国开发/工具成本报销收入', 'rev. for reimbursem. of development-/tooling costs third country', '€', '3', '1630823703875031040', 0, '/1630785212050968576/1630822946622803968/1630823703875031040/1630823836347928576', '/财务-利润类/销售收入/其他销售收入/第三国开发/工具成本报销收入', '/PL/PL3300S/PL3200/311021', NULL, 3, '0', '1', '1', '2023-03-01 14:54:37', '1', '2023-03-01 14:54:37');
INSERT INTO `qf_subject_international_info` VALUES ('1630823837035794432', 'PL1', '311025', '施工合同收入（PoC/ZPMM）', 'revenues construction contracts (PoC/ZPMM)', '€', '3', '1630823703875031040', 0, '/1630785212050968576/1630822946622803968/1630823703875031040/1630823837035794432', '/财务-利润类/销售收入/其他销售收入/施工合同收入（PoC/ZPMM）', '/PL/PL3300S/PL3200/311025', NULL, 4, '0', '1', '1', '2023-03-01 14:54:37', '1', '2023-03-01 14:54:37');
INSERT INTO `qf_subject_international_info` VALUES ('1630823837677522944', 'PL1', 'PL3410', '其他营业收入-管理类', 'Other operating income - administrative', '€', '3', '1630823704491593728', 14, '/1630785212050968576/1630822946622803968/1630823704491593728/1630823837677522944', '/财务-利润类/销售收入/其他营业收入/其他营业收入-管理类', '/PL/PL3300S/PL3400/PL3410', NULL, 1, '0', '1', '1', '2023-03-01 14:54:37', '1', '2023-03-01 14:55:26');
INSERT INTO `qf_subject_international_info` VALUES ('1630823838289891328', 'PL1', 'PL3420', '其他营业收入-财务类', 'Other operating income - financial', '€', '3', '1630823704491593728', 3, '/1630785212050968576/1630822946622803968/1630823704491593728/1630823838289891328', '/财务-利润类/销售收入/其他营业收入/其他营业收入-财务类', '/PL/PL3300S/PL3400/PL3420', NULL, 2, '0', '1', '1', '2023-03-01 14:54:37', '1', '2023-03-01 14:55:27');
INSERT INTO `qf_subject_international_info` VALUES ('1630823838977757184', 'PL1', 'PL3430', '其他营业收入-非经营性', 'Other operating income - non-operative', '€', '3', '1630823704491593728', 6, '/1630785212050968576/1630822946622803968/1630823704491593728/1630823838977757184', '/财务-利润类/销售收入/其他营业收入/其他营业收入-非经营性', '/PL/PL3300S/PL3400/PL3430', NULL, 3, '0', '1', '1', '2023-03-01 14:54:37', '1', '2023-03-01 14:55:28');
INSERT INTO `qf_subject_international_info` VALUES ('1630823839715954688', 'PL1', '344004', '衍生货币合约公允价值估值收益', 'gain of fair value valuation of derivative currency contract', '€', '3', '1630823705154293760', 0, '/1630785212050968576/1630822946622803968/1630823705154293760/1630823839715954688', '/财务-利润类/销售收入/以公允价值计量的其他营业收入/衍生货币合约公允价值估值收益', '/PL/PL3300S/PL3500/344004', NULL, 1, '0', '1', '1', '2023-03-01 14:54:37', '1', '2023-03-01 14:54:37');
INSERT INTO `qf_subject_international_info` VALUES ('1630823840340905984', 'PL1', '344005', '公司间衍生货币合约公允价值估值收益', 'IC gain of fair value valuation of derivative currency contract', '€', '3', '1630823705154293760', 0, '/1630785212050968576/1630822946622803968/1630823705154293760/1630823840340905984', '/财务-利润类/销售收入/以公允价值计量的其他营业收入/公司间衍生货币合约公允价值估值收益', '/PL/PL3300S/PL3500/344005', NULL, 2, '0', '1', '1', '2023-03-01 14:54:37', '1', '2023-03-01 14:54:38');
INSERT INTO `qf_subject_international_info` VALUES ('1630823841003606016', 'PL1', '312005', '附属公司间管理服务收入', 'sales charged costs for administrative services to consolidated comp.', '€', '3', '1630823705775050752', 0, '/1630785212050968576/1630822946622803968/1630823705775050752/1630823841003606016', '/财务-利润类/销售收入/来自关联公司的其他营业收入/附属公司间管理服务收入', '/PL/PL3300S/PL3600/312005', NULL, 1, '0', '1', '1', '2023-03-01 14:54:38', '1', '2023-03-01 14:54:38');
INSERT INTO `qf_subject_international_info` VALUES ('1630823841615974400', 'PL1', '312006', '附属公司间销售服务收入', 'sales charged distribution costs to consolidated companies', '€', '3', '1630823705775050752', 0, '/1630785212050968576/1630822946622803968/1630823705775050752/1630823841615974400', '/财务-利润类/销售收入/来自关联公司的其他营业收入/附属公司间销售服务收入', '/PL/PL3300S/PL3600/312006', NULL, 2, '0', '1', '1', '2023-03-01 14:54:38', '1', '2023-03-01 14:54:38');
INSERT INTO `qf_subject_international_info` VALUES ('1630823842245120000', 'PL1', '312009', '附属公司间质保收入', 'sales charged quality assurance fee to consolidated companies', '€', '3', '1630823705775050752', 0, '/1630785212050968576/1630822946622803968/1630823705775050752/1630823842245120000', '/财务-利润类/销售收入/来自关联公司的其他营业收入/附属公司间质保收入', '/PL/PL3300S/PL3600/312009', NULL, 3, '0', '1', '1', '2023-03-01 14:54:38', '1', '2023-03-01 14:54:38');
INSERT INTO `qf_subject_international_info` VALUES ('1630823842865876992', 'PL1', '312010', '附属公司间管理服务/执照收入', 'sales charged management fee/ license to consolidated companies', '€', '3', '1630823705775050752', 0, '/1630785212050968576/1630822946622803968/1630823705775050752/1630823842865876992', '/财务-利润类/销售收入/来自关联公司的其他营业收入/附属公司间管理服务/执照收入', '/PL/PL3300S/PL3600/312010', NULL, 4, '0', '1', '1', '2023-03-01 14:54:38', '1', '2023-03-01 14:54:38');
INSERT INTO `qf_subject_international_info` VALUES ('1630823844400992256', 'PL1', '312011', '附属公司间其他收入', 'sales charged costs other to consolidated companies', '€', '3', '1630823705775050752', 0, '/1630785212050968576/1630822946622803968/1630823705775050752/1630823844400992256', '/财务-利润类/销售收入/来自关联公司的其他营业收入/附属公司间其他收入', '/PL/PL3300S/PL3600/312011', NULL, 5, '0', '1', '1', '2023-03-01 14:54:38', '1', '2023-03-01 14:54:38');
INSERT INTO `qf_subject_international_info` VALUES ('1630823844984000512', 'PL1', '312016', '附属公司间全球IT收入', 'sales charged costs for global IT', '€', '3', '1630823705775050752', 0, '/1630785212050968576/1630822946622803968/1630823705775050752/1630823844984000512', '/财务-利润类/销售收入/来自关联公司的其他营业收入/附属公司间全球IT收入', '/PL/PL3300S/PL3600/312016', NULL, 6, '0', '1', '1', '2023-03-01 14:54:39', '1', '2023-03-01 14:54:39');
INSERT INTO `qf_subject_international_info` VALUES ('1630823845587980288', 'PL1', '341003', '附属公司间固定资产处置收入', 'revenue on disposal of fixed assets consolid. Companies', '€', '3', '1630823705775050752', 0, '/1630785212050968576/1630822946622803968/1630823705775050752/1630823845587980288', '/财务-利润类/销售收入/来自关联公司的其他营业收入/附属公司间固定资产处置收入', '/PL/PL3300S/PL3600/341003', NULL, 7, '0', '1', '1', '2023-03-01 14:54:39', '1', '2023-03-01 14:54:39');
INSERT INTO `qf_subject_international_info` VALUES ('1630823847131484160', 'PL1', '341004', 'SG集团内部固定资产处置（净收益）', 'disposal of fixed assets (when net gain) when sale within SGgroup', '€', '3', '1630823705775050752', 0, '/1630785212050968576/1630822946622803968/1630823705775050752/1630823847131484160', '/财务-利润类/销售收入/来自关联公司的其他营业收入/SG集团内部固定资产处置（净收益）', '/PL/PL3300S/PL3600/341004', NULL, 8, '0', '1', '1', '2023-03-01 14:54:39', '1', '2023-03-01 14:54:39');
INSERT INTO `qf_subject_international_info` VALUES ('1630823847798378496', 'PL1', '311022', '国内附属公司间开发、模具业务产生的收入', 'rev. for reimb. of development-/tooling costs to consol. comp.dom.', '€', '3', '1630823706400002048', 0, '/1630785212050968576/1630822946622803968/1630823706400002048/1630823847798378496', '/财务-利润类/销售收入/来自关联公司的其他收入/国内附属公司间开发、模具业务产生的收入', '/PL/PL3300S/PL3700/311022', NULL, 1, '0', '1', '1', '2023-03-01 14:54:39', '1', '2023-03-01 14:54:39');
INSERT INTO `qf_subject_international_info` VALUES ('1630823848431718400', 'PL1', '311023', '欧盟附属公司间开发、模具业务产生的收入', 'rev. for reimb. of development-/tooling costs to consol. comp. EU', '€', '3', '1630823706400002048', 0, '/1630785212050968576/1630822946622803968/1630823706400002048/1630823848431718400', '/财务-利润类/销售收入/来自关联公司的其他收入/欧盟附属公司间开发、模具业务产生的收入', '/PL/PL3300S/PL3700/311023', NULL, 2, '0', '1', '1', '2023-03-01 14:54:39', '1', '2023-03-01 14:54:39');
INSERT INTO `qf_subject_international_info` VALUES ('1630823849933279232', 'PL1', '311024', '第三国附属公司间开发、模具业务产生的收入', 'rev. for reimb. of develop-/tooling costs to consol. comp. 3rd country', '€', '3', '1630823706400002048', 0, '/1630785212050968576/1630822946622803968/1630823706400002048/1630823849933279232', '/财务-利润类/销售收入/来自关联公司的其他收入/第三国附属公司间开发、模具业务产生的收入', '/PL/PL3300S/PL3700/311024', NULL, 3, '0', '1', '1', '2023-03-01 14:54:40', '1', '2023-03-01 14:54:40');
INSERT INTO `qf_subject_international_info` VALUES ('1630823850675671040', 'PL1', '312001', '附属公司间租金收入', 'sales charged rent to consolidated companies', '€', '3', '1630823706400002048', 0, '/1630785212050968576/1630822946622803968/1630823706400002048/1630823850675671040', '/财务-利润类/销售收入/来自关联公司的其他收入/附属公司间租金收入', '/PL/PL3300S/PL3700/312001', NULL, 4, '0', '1', '1', '2023-03-01 14:54:40', '1', '2023-03-01 14:54:40');
INSERT INTO `qf_subject_international_info` VALUES ('1630823851288039424', 'PL1', '312002', '附属公司间产品支持收入', 'sales charged costs for production support to consolidated companies', '€', '3', '1630823706400002048', 0, '/1630785212050968576/1630822946622803968/1630823706400002048/1630823851288039424', '/财务-利润类/销售收入/来自关联公司的其他收入/附属公司间产品支持收入', '/PL/PL3300S/PL3700/312002', NULL, 5, '0', '1', '1', '2023-03-01 14:54:40', '1', '2023-03-01 14:54:40');
INSERT INTO `qf_subject_international_info` VALUES ('1630823851963322368', 'PL1', '312003', '附属公司间维护服务收入', 'sales charged costs for maintenance/repairs to consolidated companies', '€', '3', '1630823706400002048', 0, '/1630785212050968576/1630822946622803968/1630823706400002048/1630823851963322368', '/财务-利润类/销售收入/来自关联公司的其他收入/附属公司间维护服务收入', '/PL/PL3300S/PL3700/312003', NULL, 6, '0', '1', '1', '2023-03-01 14:54:40', '1', '2023-03-01 14:54:40');
INSERT INTO `qf_subject_international_info` VALUES ('1630823852772823040', 'PL1', '312007', '附属公司间研发服务收入', 'sales charged research and development costs to consolidated companies', '€', '3', '1630823706400002048', 0, '/1630785212050968576/1630822946622803968/1630823706400002048/1630823852772823040', '/财务-利润类/销售收入/来自关联公司的其他收入/附属公司间研发服务收入', '/PL/PL3300S/PL3700/312007', NULL, 7, '0', '1', '1', '2023-03-01 14:54:40', '1', '2023-03-01 14:54:40');
INSERT INTO `qf_subject_international_info` VALUES ('1630823853385191424', 'PL1', '312008', '附属公司间购置费的收入', 'sales charged purchasing fee to consolidated companies', '€', '3', '1630823706400002048', 0, '/1630785212050968576/1630822946622803968/1630823706400002048/1630823853385191424', '/财务-利润类/销售收入/来自关联公司的其他收入/附属公司间购置费的收入', '/PL/PL3300S/PL3700/312008', NULL, 8, '0', '1', '1', '2023-03-01 14:54:41', '1', '2023-03-01 14:54:41');
INSERT INTO `qf_subject_international_info` VALUES ('1630823854014337024', 'PL2', '321001', '库存半成品的变动', 'change in stock unfinished  goods', '€', '3', '1630823707041730560', 0, '/1630785212050968576/1630822946622803968/1630823707041730560/1630823854014337024', '/财务-利润类/销售收入/成品和半产品库存的变动/库存半成品的变动', '/PL/PL3300S/PL3800/321001', NULL, 1, '0', '1', '1', '2023-03-01 14:54:41', '1', '2023-03-01 14:54:41');
INSERT INTO `qf_subject_international_info` VALUES ('1630823854718980096', 'PL2', '321002', '库存混合物的变动', 'change in stock mixtures', '€', '3', '1630823707041730560', 0, '/1630785212050968576/1630822946622803968/1630823707041730560/1630823854718980096', '/财务-利润类/销售收入/成品和半产品库存的变动/库存混合物的变动', '/PL/PL3300S/PL3800/321002', NULL, 2, '0', '1', '1', '2023-03-01 14:54:41', '1', '2023-03-01 14:54:41');
INSERT INTO `qf_subject_international_info` VALUES ('1630823855360708608', 'PL2', '321003', '挤出半成品库存变动', 'change in stock semi finished goods Extrudate', '€', '3', '1630823707041730560', 0, '/1630785212050968576/1630822946622803968/1630823707041730560/1630823855360708608', '/财务-利润类/销售收入/成品和半产品库存的变动/挤出半成品库存变动', '/PL/PL3300S/PL3800/321003', NULL, 3, '0', '1', '1', '2023-03-01 14:54:41', '1', '2023-03-01 14:54:41');
INSERT INTO `qf_subject_international_info` VALUES ('1630823856015020032', 'PL2', '321004', '库存半成品的变动', 'change in stock semi finished goods form articles', '€', '3', '1630823707041730560', 0, '/1630785212050968576/1630822946622803968/1630823707041730560/1630823856015020032', '/财务-利润类/销售收入/成品和半产品库存的变动/库存半成品的变动', '/PL/PL3300S/PL3800/321004', NULL, 4, '0', '1', '1', '2023-03-01 14:54:41', '1', '2023-03-01 14:54:41');
INSERT INTO `qf_subject_international_info` VALUES ('1630823856593833984', 'PL2', '321006', '存货变动的后续计量', 'change in stock subsequent treatment of goods', '€', '3', '1630823707041730560', 0, '/1630785212050968576/1630822946622803968/1630823707041730560/1630823856593833984', '/财务-利润类/销售收入/成品和半产品库存的变动/存货变动的后续计量', '/PL/PL3300S/PL3800/321006', NULL, 5, '0', '1', '1', '2023-03-01 14:54:41', '1', '2023-03-01 14:54:41');
INSERT INTO `qf_subject_international_info` VALUES ('1630823857231368192', 'PL2', '322001', '库存产成品的变动', 'change in stock finished goods', '€', '3', '1630823707041730560', 0, '/1630785212050968576/1630822946622803968/1630823707041730560/1630823857231368192', '/财务-利润类/销售收入/成品和半产品库存的变动/库存产成品的变动', '/PL/PL3300S/PL3800/322001', NULL, 6, '0', '1', '1', '2023-03-01 14:54:42', '1', '2023-03-01 14:54:42');
INSERT INTO `qf_subject_international_info` VALUES ('1630823857885679616', 'PL2', '322002', '库存产成品变化增加', 'change in stock finished goods increase', '€', '3', '1630823707041730560', 0, '/1630785212050968576/1630822946622803968/1630823707041730560/1630823857885679616', '/财务-利润类/销售收入/成品和半产品库存的变动/库存产成品变化增加', '/PL/PL3300S/PL3800/322002', NULL, 7, '0', '1', '1', '2023-03-01 14:54:42', '1', '2023-03-01 14:54:42');
INSERT INTO `qf_subject_international_info` VALUES ('1630823858519019520', 'PL2', '322003', '库存产成品变化减少', 'change in stock finished goods decrease', '€', '3', '1630823707041730560', 0, '/1630785212050968576/1630822946622803968/1630823707041730560/1630823858519019520', '/财务-利润类/销售收入/成品和半产品库存的变动/库存产成品变化减少', '/PL/PL3300S/PL3800/322003', NULL, 8, '0', '1', '1', '2023-03-01 14:54:42', '1', '2023-03-01 14:54:42');
INSERT INTO `qf_subject_international_info` VALUES ('1630823859122999296', 'PL2', '323001', '增加（减少）开发费用', 'Increase (Decrease) development expenses', '€', '3', '1630823707041730560', 0, '/1630785212050968576/1630822946622803968/1630823707041730560/1630823859122999296', '/财务-利润类/销售收入/成品和半产品库存的变动/增加（减少）开发费用', '/PL/PL3300S/PL3800/323001', NULL, 9, '0', '1', '1', '2023-03-01 14:54:42', '1', '2023-03-01 14:54:42');
INSERT INTO `qf_subject_international_info` VALUES ('1630823859760533504', 'PL2', '324001', '增加（减少）在制的工装模具', 'Increase (Decrease) tooling work in progress', '€', '3', '1630823707041730560', 0, '/1630785212050968576/1630822946622803968/1630823707041730560/1630823859760533504', '/财务-利润类/销售收入/成品和半产品库存的变动/增加（减少）在制的工装模具', '/PL/PL3300S/PL3800/324001', NULL, 10, '0', '1', '1', '2023-03-01 14:54:42', '1', '2023-03-01 14:54:42');
INSERT INTO `qf_subject_international_info` VALUES ('1630823860419039232', 'PL2', '331001', '自有资本化服务', 'own capitalized services', '€', '3', '1630823707637321728', 0, '/1630785212050968576/1630822946622803968/1630823707637321728/1630823860419039232', '/财务-利润类/销售收入/其他制造费用/自有资本化服务', '/PL/PL3300S/PL3900/331001', NULL, 1, '0', '1', '1', '2023-03-01 14:54:42', '1', '2023-03-01 14:54:42');
INSERT INTO `qf_subject_international_info` VALUES ('1630823861064962048', 'PL2', '332001', '资本化服务启动费用', 'capitalized service start up expenses', '€', '3', '1630823707637321728', 0, '/1630785212050968576/1630822946622803968/1630823707637321728/1630823861064962048', '/财务-利润类/销售收入/其他制造费用/资本化服务启动费用', '/PL/PL3300S/PL3900/332001', NULL, 2, '0', '1', '1', '2023-03-01 14:54:42', '1', '2023-03-01 14:54:42');
INSERT INTO `qf_subject_international_info` VALUES ('1630823861702496256', 'PL2', '351009', '供应商现金折扣的收入', 'income cash discount from suppliers', '€', '3', '1630823708253884416', 0, '/1630785212050968576/1630822946622803968/1630823708253884416/1630823861702496256', '/财务-利润类/销售收入/购买的材料和服务成本/供应商现金折扣的收入', '/PL/PL3300S/PL4000/351009', NULL, 1, '0', '1', '1', '2023-03-01 14:54:43', '1', '2023-03-01 14:54:43');
INSERT INTO `qf_subject_international_info` VALUES ('1630823862365196288', 'PL2', '411001', '原材料的使用', 'usage raw materials', '€', '3', '1630823708253884416', 0, '/1630785212050968576/1630822946622803968/1630823708253884416/1630823862365196288', '/财务-利润类/销售收入/购买的材料和服务成本/原材料的使用', '/PL/PL3300S/PL4000/411001', NULL, 2, '0', '1', '1', '2023-03-01 14:54:43', '1', '2023-03-01 14:54:43');
INSERT INTO `qf_subject_international_info` VALUES ('1630823863128559616', 'PL2', '411002', '购买的混合物的使用', 'usage purchased mixture', '€', '3', '1630823708253884416', 0, '/1630785212050968576/1630822946622803968/1630823708253884416/1630823863128559616', '/财务-利润类/销售收入/购买的材料和服务成本/购买的混合物的使用', '/PL/PL3300S/PL4000/411002', NULL, 3, '0', '1', '1', '2023-03-01 14:54:43', '1', '2023-03-01 14:54:43');
INSERT INTO `qf_subject_international_info` VALUES ('1630823863740928000', 'PL2', '411003', '操作用品的使用', 'usage operating supplies', '€', '3', '1630823708253884416', 0, '/1630785212050968576/1630822946622803968/1630823708253884416/1630823863740928000', '/财务-利润类/销售收入/购买的材料和服务成本/操作用品的使用', '/PL/PL3300S/PL4000/411003', NULL, 4, '0', '1', '1', '2023-03-01 14:54:43', '1', '2023-03-01 14:54:43');
INSERT INTO `qf_subject_international_info` VALUES ('1630823864420405248', 'PL2', '411005', '橡胶的使用', 'usage rubber', '€', '3', '1630823708253884416', 0, '/1630785212050968576/1630822946622803968/1630823708253884416/1630823864420405248', '/财务-利润类/销售收入/购买的材料和服务成本/橡胶的使用', '/PL/PL3300S/PL4000/411005', NULL, 5, '0', '1', '1', '2023-03-01 14:54:43', '1', '2023-03-01 14:54:43');
INSERT INTO `qf_subject_international_info` VALUES ('1630823865049550848', 'PL2', '411006', '老化保护剂的使用', 'usage ageing protective agent', '€', '3', '1630823708253884416', 0, '/1630785212050968576/1630822946622803968/1630823708253884416/1630823865049550848', '/财务-利润类/销售收入/购买的材料和服务成本/老化保护剂的使用', '/PL/PL3300S/PL4000/411006', NULL, 6, '0', '1', '1', '2023-03-01 14:54:43', '1', '2023-03-01 14:54:43');
INSERT INTO `qf_subject_international_info` VALUES ('1630823865678696448', 'PL2', '411007', '炭黑的使用', 'usage carbon black', '€', '3', '1630823708253884416', 0, '/1630785212050968576/1630822946622803968/1630823708253884416/1630823865678696448', '/财务-利润类/销售收入/购买的材料和服务成本/炭黑的使用', '/PL/PL3300S/PL4000/411007', NULL, 7, '0', '1', '1', '2023-03-01 14:54:44', '1', '2023-03-01 14:54:44');
INSERT INTO `qf_subject_international_info` VALUES ('1630823866341396480', 'PL2', '411008', '填充物的使用', 'usage fillers', '€', '3', '1630823708253884416', 0, '/1630785212050968576/1630822946622803968/1630823708253884416/1630823866341396480', '/财务-利润类/销售收入/购买的材料和服务成本/填充物的使用', '/PL/PL3300S/PL4000/411008', NULL, 8, '0', '1', '1', '2023-03-01 14:54:44', '1', '2023-03-01 14:54:44');
INSERT INTO `qf_subject_international_info` VALUES ('1630823866920210432', 'PL2', '411009', '增塑剂和树脂的使用', 'usage plasticizer and resin', '€', '3', '1630823708253884416', 0, '/1630785212050968576/1630822946622803968/1630823708253884416/1630823866920210432', '/财务-利润类/销售收入/购买的材料和服务成本/增塑剂和树脂的使用', '/PL/PL3300S/PL4000/411009', NULL, 9, '0', '1', '1', '2023-03-01 14:54:44', '1', '2023-03-01 14:54:44');
INSERT INTO `qf_subject_international_info` VALUES ('1630823867566133248', 'PL2', '411010', '交联剂和促进剂的使用', 'usage cross linking agent and accelerator', '€', '3', '1630823708253884416', 0, '/1630785212050968576/1630822946622803968/1630823708253884416/1630823867566133248', '/财务-利润类/销售收入/购买的材料和服务成本/交联剂和促进剂的使用', '/PL/PL3300S/PL4000/411010', NULL, 10, '0', '1', '1', '2023-03-01 14:54:44', '1', '2023-03-01 14:54:44');
INSERT INTO `qf_subject_international_info` VALUES ('1630823868228833280', 'PL2', '411011', '发泡剂的使用', 'usage blowing agent', '€', '3', '1630823708253884416', 0, '/1630785212050968576/1630822946622803968/1630823708253884416/1630823868228833280', '/财务-利润类/销售收入/购买的材料和服务成本/发泡剂的使用', '/PL/PL3300S/PL4000/411011', NULL, 11, '0', '1', '1', '2023-03-01 14:54:44', '1', '2023-03-01 14:54:44');
INSERT INTO `qf_subject_international_info` VALUES ('1630823868866367488', 'PL2', '411012', '胶带的使用', 'usage tapes', '€', '3', '1630823708253884416', 0, '/1630785212050968576/1630822946622803968/1630823708253884416/1630823868866367488', '/财务-利润类/销售收入/购买的材料和服务成本/胶带的使用', '/PL/PL3300S/PL4000/411012', NULL, 12, '0', '1', '1', '2023-03-01 14:54:44', '1', '2023-03-01 14:54:44');
INSERT INTO `qf_subject_international_info` VALUES ('1630823869457764352', 'PL2', '411013', '工具和其他材料的使用', 'usage utilities and other material', '€', '3', '1630823708253884416', 0, '/1630785212050968576/1630822946622803968/1630823708253884416/1630823869457764352', '/财务-利润类/销售收入/购买的材料和服务成本/工具和其他材料的使用', '/PL/PL3300S/PL4000/411013', NULL, 13, '0', '1', '1', '2023-03-01 14:54:44', '1', '2023-03-01 14:54:44');
INSERT INTO `qf_subject_international_info` VALUES ('1630823870049161216', 'PL2', '411014', '塑料的使用', 'usage plastics', '€', '3', '1630823708253884416', 0, '/1630785212050968576/1630822946622803968/1630823708253884416/1630823870049161216', '/财务-利润类/销售收入/购买的材料和服务成本/塑料的使用', '/PL/PL3300S/PL4000/411014', NULL, 14, '0', '1', '1', '2023-03-01 14:54:45', '1', '2023-03-01 14:54:45');
INSERT INTO `qf_subject_international_info` VALUES ('1630823870665723904', 'PL2', '411015', '从第三方购入的在产品的使用', 'usage purchased articles work in progress from third parties', '€', '3', '1630823708253884416', 0, '/1630785212050968576/1630822946622803968/1630823708253884416/1630823870665723904', '/财务-利润类/销售收入/购买的材料和服务成本/从第三方购入的在产品的使用', '/PL/PL3300S/PL4000/411015', NULL, 15, '0', '1', '1', '2023-03-01 14:54:45', '1', '2023-03-01 14:54:45');
INSERT INTO `qf_subject_international_info` VALUES ('1630823871315841024', 'PL2', '411016', '清漆和颜色的使用', 'usage varnish and colours', '€', '3', '1630823708253884416', 0, '/1630785212050968576/1630822946622803968/1630823708253884416/1630823871315841024', '/财务-利润类/销售收入/购买的材料和服务成本/清漆和颜色的使用', '/PL/PL3300S/PL4000/411016', NULL, 16, '0', '1', '1', '2023-03-01 14:54:45', '1', '2023-03-01 14:54:45');
INSERT INTO `qf_subject_international_info` VALUES ('1630823871957569536', 'PL2', '411017', '载体的使用', 'usage carriers', '€', '3', '1630823708253884416', 0, '/1630785212050968576/1630822946622803968/1630823708253884416/1630823871957569536', '/财务-利润类/销售收入/购买的材料和服务成本/载体的使用', '/PL/PL3300S/PL4000/411017', NULL, 17, '0', '1', '1', '2023-03-01 14:54:45', '1', '2023-03-01 14:54:45');
INSERT INTO `qf_subject_international_info` VALUES ('1630823872653824000', 'PL2', '411018', '产品包装材料的使用', 'usage package material for product', '€', '3', '1630823708253884416', 0, '/1630785212050968576/1630822946622803968/1630823708253884416/1630823872653824000', '/财务-利润类/销售收入/购买的材料和服务成本/产品包装材料的使用', '/PL/PL3300S/PL4000/411018', NULL, 18, '0', '1', '1', '2023-03-01 14:54:45', '1', '2023-03-01 14:54:45');
INSERT INTO `qf_subject_international_info` VALUES ('1630823873324912640', 'PL2', '411019', '外部借方票据（无交付）', 'external debit notes (without delivery)', '€', '3', '1630823708253884416', 0, '/1630785212050968576/1630822946622803968/1630823708253884416/1630823873324912640', '/财务-利润类/销售收入/购买的材料和服务成本/外部借方票据（无交付）', '/PL/PL3300S/PL4000/411019', NULL, 19, '0', '1', '1', '2023-03-01 14:54:45', '1', '2023-03-01 14:54:45');
INSERT INTO `qf_subject_international_info` VALUES ('1630823873970835456', 'PL2', '411020', '供应商奖金', 'supplier bonuses', '€', '3', '1630823708253884416', 0, '/1630785212050968576/1630822946622803968/1630823708253884416/1630823873970835456', '/财务-利润类/销售收入/购买的材料和服务成本/供应商奖金', '/PL/PL3300S/PL4000/411020', NULL, 20, '0', '1', '1', '2023-03-01 14:54:45', '1', '2023-03-01 14:54:46');
INSERT INTO `qf_subject_international_info` VALUES ('1630823874608369664', 'PL2', '411021', '交易商品的核销', 'Write-off of trading goods', '€', '3', '1630823708253884416', 0, '/1630785212050968576/1630822946622803968/1630823708253884416/1630823874608369664', '/财务-利润类/销售收入/购买的材料和服务成本/交易商品的核销', '/PL/PL3300S/PL4000/411021', NULL, 21, '0', '1', '1', '2023-03-01 14:54:46', '1', '2023-03-01 14:54:46');
INSERT INTO `qf_subject_international_info` VALUES ('1630823875224932352', 'PL2', '411022', '更正通过分包购买的交易商品', 'correction purchased trading goods by subcontracting', '€', '3', '1630823708253884416', 0, '/1630785212050968576/1630822946622803968/1630823708253884416/1630823875224932352', '/财务-利润类/销售收入/购买的材料和服务成本/更正通过分包购买的交易商品', '/PL/PL3300S/PL4000/411022', NULL, 22, '0', '1', '1', '2023-03-01 14:54:46', '1', '2023-03-01 14:54:46');
INSERT INTO `qf_subject_international_info` VALUES ('1630823875858272256', 'PL2', '411023', '购买的交易商品的使用', 'usage purchased trading goods', '€', '3', '1630823708253884416', 0, '/1630785212050968576/1630822946622803968/1630823708253884416/1630823875858272256', '/财务-利润类/销售收入/购买的材料和服务成本/购买的交易商品的使用', '/PL/PL3300S/PL4000/411023', NULL, 23, '0', '1', '1', '2023-03-01 14:54:46', '1', '2023-03-01 14:54:46');
INSERT INTO `qf_subject_international_info` VALUES ('1630823876520972288', 'PL2', '411026', '电量的使用', 'usage electricity', '€', '3', '1630823708253884416', 0, '/1630785212050968576/1630822946622803968/1630823708253884416/1630823876520972288', '/财务-利润类/销售收入/购买的材料和服务成本/电量的使用', '/PL/PL3300S/PL4000/411026', NULL, 24, '0', '1', '1', '2023-03-01 14:54:46', '1', '2023-03-01 14:54:46');
INSERT INTO `qf_subject_international_info` VALUES ('1630823877137534976', 'PL2', '411027', '水的使用', 'usage water', '€', '3', '1630823708253884416', 0, '/1630785212050968576/1630822946622803968/1630823708253884416/1630823877137534976', '/财务-利润类/销售收入/购买的材料和服务成本/水的使用', '/PL/PL3300S/PL4000/411027', NULL, 25, '0', '1', '1', '2023-03-01 14:54:46', '1', '2023-03-01 14:54:46');
INSERT INTO `qf_subject_international_info` VALUES ('1630823877749903360', 'PL2', '411028', '燃油的使用', 'usage fuel oil', '€', '3', '1630823708253884416', 0, '/1630785212050968576/1630822946622803968/1630823708253884416/1630823877749903360', '/财务-利润类/销售收入/购买的材料和服务成本/燃油的使用', '/PL/PL3300S/PL4000/411028', NULL, 26, '0', '1', '1', '2023-03-01 14:54:46', '1', '2023-03-01 14:54:46');
INSERT INTO `qf_subject_international_info` VALUES ('1630823878387437568', 'PL2', '411029', '天然气的使用', 'usage natural gas', '€', '3', '1630823708253884416', 0, '/1630785212050968576/1630822946622803968/1630823708253884416/1630823878387437568', '/财务-利润类/销售收入/购买的材料和服务成本/天然气的使用', '/PL/PL3300S/PL4000/411029', NULL, 27, '0', '1', '1', '2023-03-01 14:54:47', '1', '2023-03-01 14:54:47');
INSERT INTO `qf_subject_international_info` VALUES ('1630823879134023680', 'PL2', '411030', '生产工具的使用', 'usage production tools', '€', '3', '1630823708253884416', 0, '/1630785212050968576/1630822946622803968/1630823708253884416/1630823879134023680', '/财务-利润类/销售收入/购买的材料和服务成本/生产工具的使用', '/PL/PL3300S/PL4000/411030', NULL, 28, '0', '1', '1', '2023-03-01 14:54:47', '1', '2023-03-01 14:54:47');
INSERT INTO `qf_subject_international_info` VALUES ('1630823879901581312', 'PL2', '411031', '润滑剂和冷却剂的使用', 'usage lubricant and cooling agent', '€', '3', '1630823708253884416', 0, '/1630785212050968576/1630822946622803968/1630823708253884416/1630823879901581312', '/财务-利润类/销售收入/购买的材料和服务成本/润滑剂和冷却剂的使用', '/PL/PL3300S/PL4000/411031', NULL, 29, '0', '1', '1', '2023-03-01 14:54:47', '1', '2023-03-01 14:54:47');
INSERT INTO `qf_subject_international_info` VALUES ('1630823880526532608', 'PL2', '411033', '维修材料和备件的使用', 'usage repair materials and spare parts', '€', '3', '1630823708253884416', 0, '/1630785212050968576/1630822946622803968/1630823708253884416/1630823880526532608', '/财务-利润类/销售收入/购买的材料和服务成本/维修材料和备件的使用', '/PL/PL3300S/PL4000/411033', NULL, 30, '0', '1', '1', '2023-03-01 14:54:47', '1', '2023-03-01 14:54:47');
INSERT INTO `qf_subject_international_info` VALUES ('1630823881210204160', 'PL2', '411034', '二氧化碳和氮气的使用', 'usage carbonic dioxide and nitrogen', '€', '3', '1630823708253884416', 0, '/1630785212050968576/1630822946622803968/1630823708253884416/1630823881210204160', '/财务-利润类/销售收入/购买的材料和服务成本/二氧化碳和氮气的使用', '/PL/PL3300S/PL4000/411034', NULL, 31, '0', '1', '1', '2023-03-01 14:54:47', '1', '2023-03-01 14:54:47');
INSERT INTO `qf_subject_international_info` VALUES ('1630823881822572544', 'PL2', '411035', '客户支付的加工和形状变更费用', 'expenses for tooling and changes of shapes paid by customers', '€', '3', '1630823708253884416', 0, '/1630785212050968576/1630822946622803968/1630823708253884416/1630823881822572544', '/财务-利润类/销售收入/购买的材料和服务成本/客户支付的加工和形状变更费用', '/PL/PL3300S/PL4000/411035', NULL, 32, '0', '1', '1', '2023-03-01 14:54:47', '1', '2023-03-01 14:54:47');
INSERT INTO `qf_subject_international_info` VALUES ('1630823882460106752', 'PL2', '411037', '负库存余额差额的注销', 'write-off negative stock balance difference', '€', '3', '1630823708253884416', 0, '/1630785212050968576/1630822946622803968/1630823708253884416/1630823882460106752', '/财务-利润类/销售收入/购买的材料和服务成本/负库存余额差额的注销', '/PL/PL3300S/PL4000/411037', NULL, 33, '0', '1', '1', '2023-03-01 14:54:48', '1', '2023-03-01 14:54:48');
INSERT INTO `qf_subject_international_info` VALUES ('1630823883093446656', 'PL2', '411038', '正库存余额差额的注销', 'write-off positive stock balance difference', '€', '3', '1630823708253884416', 0, '/1630785212050968576/1630822946622803968/1630823708253884416/1630823883093446656', '/财务-利润类/销售收入/购买的材料和服务成本/正库存余额差额的注销', '/PL/PL3300S/PL4000/411038', NULL, 34, '0', '1', '1', '2023-03-01 14:54:48', '1', '2023-03-01 14:54:48');
INSERT INTO `qf_subject_international_info` VALUES ('1630823883735175168', 'PL2', '412001', '进货运费收入', 'income freight for purchased goods', '€', '3', '1630823708253884416', 0, '/1630785212050968576/1630822946622803968/1630823708253884416/1630823883735175168', '/财务-利润类/销售收入/购买的材料和服务成本/进货运费收入', '/PL/PL3300S/PL4000/412001', NULL, 35, '0', '1', '1', '2023-03-01 14:54:48', '1', '2023-03-01 14:54:48');
INSERT INTO `qf_subject_international_info` VALUES ('1630823884368515072', 'PL2', '412002', '非加速混合物的价格差异SAP自动', 'price differences for non accelerated mixtures SAP automatically acc.', '€', '3', '1630823708253884416', 0, '/1630785212050968576/1630822946622803968/1630823708253884416/1630823884368515072', '/财务-利润类/销售收入/购买的材料和服务成本/非加速混合物的价格差异SAP自动', '/PL/PL3300S/PL4000/412002', NULL, 36, '0', '1', '1', '2023-03-01 14:54:48', '1', '2023-03-01 14:54:48');
INSERT INTO `qf_subject_international_info` VALUES ('1630823884997660672', 'PL2', '412003', '特殊进货运费', 'Special ingoing freight', '€', '3', '1630823708253884416', 0, '/1630785212050968576/1630822946622803968/1630823708253884416/1630823884997660672', '/财务-利润类/销售收入/购买的材料和服务成本/特殊进货运费', '/PL/PL3300S/PL4000/412003', NULL, 37, '0', '1', '1', '2023-03-01 14:54:48', '1', '2023-03-01 14:54:48');
INSERT INTO `qf_subject_international_info` VALUES ('1630823885635194880', 'PL2', '413001', '购买的其他服务', 'purchased services other', '€', '3', '1630823708253884416', 0, '/1630785212050968576/1630822946622803968/1630823708253884416/1630823885635194880', '/财务-利润类/销售收入/购买的材料和服务成本/购买的其他服务', '/PL/PL3300S/PL4000/413001', NULL, 38, '0', '1', '1', '2023-03-01 14:54:48', '1', '2023-03-01 14:54:48');
INSERT INTO `qf_subject_international_info` VALUES ('1630823886243368960', 'PL2', '413004', '直接临时雇佣费用', 'temporary employment direct', '€', '3', '1630823708253884416', 0, '/1630785212050968576/1630822946622803968/1630823708253884416/1630823886243368960', '/财务-利润类/销售收入/购买的材料和服务成本/直接临时雇佣费用', '/PL/PL3300S/PL4000/413004', NULL, 39, '0', '1', '1', '2023-03-01 14:54:48', '1', '2023-03-01 14:54:48');
INSERT INTO `qf_subject_international_info` VALUES ('1630823886872514560', 'PL2', '413005', '间接临时雇佣费用', 'temporary employment indirect', '€', '3', '1630823708253884416', 0, '/1630785212050968576/1630822946622803968/1630823708253884416/1630823886872514560', '/财务-利润类/销售收入/购买的材料和服务成本/间接临时雇佣费用', '/PL/PL3300S/PL4000/413005', NULL, 40, '0', '1', '1', '2023-03-01 14:54:49', '1', '2023-03-01 14:54:49');
INSERT INTO `qf_subject_international_info` VALUES ('1630823887510048768', 'PL2', '413006', '采购的分拣和返工服务', 'purchased services for soring and rework', '€', '3', '1630823708253884416', 0, '/1630785212050968576/1630822946622803968/1630823708253884416/1630823887510048768', '/财务-利润类/销售收入/购买的材料和服务成本/采购的分拣和返工服务', '/PL/PL3300S/PL4000/413006', NULL, 41, '0', '1', '1', '2023-03-01 14:54:49', '1', '2023-03-01 14:54:49');
INSERT INTO `qf_subject_international_info` VALUES ('1630823888231469056', 'PL2', '413007', '分包成本', 'subcontracting costs', '€', '3', '1630823708253884416', 0, '/1630785212050968576/1630822946622803968/1630823708253884416/1630823888231469056', '/财务-利润类/销售收入/购买的材料和服务成本/分包成本', '/PL/PL3300S/PL4000/413007', NULL, 42, '0', '1', '1', '2023-03-01 14:54:49', '1', '2023-03-01 14:54:49');
INSERT INTO `qf_subject_international_info` VALUES ('1630823888856420352', 'PL2', '413008', '客户投诉成本', 'costs for customer complaints', '€', '3', '1630823708253884416', 0, '/1630785212050968576/1630822946622803968/1630823708253884416/1630823888856420352', '/财务-利润类/销售收入/购买的材料和服务成本/客户投诉成本', '/PL/PL3300S/PL4000/413008', NULL, 43, '0', '1', '1', '2023-03-01 14:54:49', '1', '2023-03-01 14:54:49');
INSERT INTO `qf_subject_international_info` VALUES ('1630823889472983040', 'PL2', '413010', '质量保证成本', 'costs quality assurance', '€', '3', '1630823708253884416', 0, '/1630785212050968576/1630822946622803968/1630823708253884416/1630823889472983040', '/财务-利润类/销售收入/购买的材料和服务成本/质量保证成本', '/PL/PL3300S/PL4000/413010', NULL, 44, '0', '1', '1', '2023-03-01 14:54:49', '1', '2023-03-01 14:54:49');
INSERT INTO `qf_subject_international_info` VALUES ('1630823890085351424', 'PL2', '411004', '附属公司间原材料采购', 'purchased material consolidated companies', '€', '3', '1630823708904001536', 0, '/1630785212050968576/1630822946622803968/1630823708904001536/1630823890085351424', '/财务-利润类/销售收入/关联公司商品和服务的材料支出/附属公司间原材料采购', '/PL/PL3300S/PL4100/411004', NULL, 1, '0', '1', '1', '2023-03-01 14:54:49', '1', '2023-03-01 14:54:49');
INSERT INTO `qf_subject_international_info` VALUES ('1630823890706108416', 'PL2', '411024', '附属公司间使用购置的交易货物', 'usage purchased trading goods consolidated companies', '€', '3', '1630823708904001536', 0, '/1630785212050968576/1630822946622803968/1630823708904001536/1630823890706108416', '/财务-利润类/销售收入/关联公司商品和服务的材料支出/附属公司间使用购置的交易货物', '/PL/PL3300S/PL4100/411024', NULL, 2, '0', '1', '1', '2023-03-01 14:54:49', '1', '2023-03-01 14:54:50');
INSERT INTO `qf_subject_international_info` VALUES ('1630823891360419840', 'PL2', '411036', '附属公司间模具费用', 'expenses for tooling consolidated companies paid by customers', '€', '3', '1630823708904001536', 0, '/1630785212050968576/1630822946622803968/1630823708904001536/1630823891360419840', '/财务-利润类/销售收入/关联公司商品和服务的材料支出/附属公司间模具费用', '/PL/PL3300S/PL4100/411036', NULL, 3, '0', '1', '1', '2023-03-01 14:54:50', '1', '2023-03-01 14:54:50');
INSERT INTO `qf_subject_international_info` VALUES ('1630823892203474944', 'PL2', '413002', '附属公司间产品采购服务', 'purchased services for production consolidated companies', '€', '3', '1630823708904001536', 0, '/1630785212050968576/1630822946622803968/1630823708904001536/1630823892203474944', '/财务-利润类/销售收入/关联公司商品和服务的材料支出/附属公司间产品采购服务', '/PL/PL3300S/PL4100/413002', NULL, 4, '0', '1', '1', '2023-03-01 14:54:50', '1', '2023-03-01 14:54:50');
INSERT INTO `qf_subject_international_info` VALUES ('1630823892992004096', 'PL2', '413003', '附属公司间维护服务费用', 'purchased services for maintenance/repairs consolidated companies', '€', '3', '1630823708904001536', 0, '/1630785212050968576/1630822946622803968/1630823708904001536/1630823892992004096', '/财务-利润类/销售收入/关联公司商品和服务的材料支出/附属公司间维护服务费用', '/PL/PL3300S/PL4100/413003', NULL, 5, '0', '1', '1', '2023-03-01 14:54:50', '1', '2023-03-01 14:54:50');
INSERT INTO `qf_subject_international_info` VALUES ('1630823893633732608', 'PL2', '421101', '直接员工工资', 'wages for wages earner', '€', '3', '1630823709545730048', 0, '/1630785212050968576/1630822946622803968/1630823709545730048/1630823893633732608', '/财务-利润类/销售收入/人工费用/直接员工工资', '/PL/PL3300S/PL4200/421101', NULL, 1, '0', '1', '1', '2023-03-01 14:54:50', '1', '2023-03-01 14:54:50');
INSERT INTO `qf_subject_international_info` VALUES ('1630823894233518080', 'PL2', '421102', '直接员工补充补助金', 'supplementary grant for wage earner', '€', '3', '1630823709545730048', 0, '/1630785212050968576/1630822946622803968/1630823709545730048/1630823894233518080', '/财务-利润类/销售收入/人工费用/直接员工补充补助金', '/PL/PL3300S/PL4200/421102', NULL, 2, '0', '1', '1', '2023-03-01 14:54:50', '1', '2023-03-01 14:54:50');
INSERT INTO `qf_subject_international_info` VALUES ('1630823894833303552', 'PL2', '421103', '直接员工轮班津贴', 'shift premium wage earner', '€', '3', '1630823709545730048', 0, '/1630785212050968576/1630822946622803968/1630823709545730048/1630823894833303552', '/财务-利润类/销售收入/人工费用/直接员工轮班津贴', '/PL/PL3300S/PL4200/421103', NULL, 3, '0', '1', '1', '2023-03-01 14:54:50', '1', '2023-03-01 14:54:50');
INSERT INTO `qf_subject_international_info` VALUES ('1630823895420506112', 'PL2', '421104', '直接员工夜间轮班津贴', 'night shift premium wage earner', '€', '3', '1630823709545730048', 0, '/1630785212050968576/1630822946622803968/1630823709545730048/1630823895420506112', '/财务-利润类/销售收入/人工费用/直接员工夜间轮班津贴', '/PL/PL3300S/PL4200/421104', NULL, 4, '0', '1', '1', '2023-03-01 14:54:51', '1', '2023-03-01 14:54:51');
INSERT INTO `qf_subject_international_info` VALUES ('1630823896032874496', 'PL2', '421105', '直接员工加班津贴', 'overtime premium wage earner', '€', '3', '1630823709545730048', 0, '/1630785212050968576/1630822946622803968/1630823709545730048/1630823896032874496', '/财务-利润类/销售收入/人工费用/直接员工加班津贴', '/PL/PL3300S/PL4200/421105', NULL, 5, '0', '1', '1', '2023-03-01 14:54:51', '1', '2023-03-01 14:54:51');
INSERT INTO `qf_subject_international_info` VALUES ('1630823896662020096', 'PL2', '421106', '直接员工假期支付', 'Holiday payment wage earner', '€', '3', '1630823709545730048', 0, '/1630785212050968576/1630822946622803968/1630823709545730048/1630823896662020096', '/财务-利润类/销售收入/人工费用/直接员工假期支付', '/PL/PL3300S/PL4200/421106', NULL, 6, '0', '1', '1', '2023-03-01 14:54:51', '1', '2023-03-01 14:54:51');
INSERT INTO `qf_subject_international_info` VALUES ('1630823897328914432', 'PL2', '421107', '直接员工假期按日支付工资', 'Holiday payment daily fee wage earner', '€', '3', '1630823709545730048', 0, '/1630785212050968576/1630822946622803968/1630823709545730048/1630823897328914432', '/财务-利润类/销售收入/人工费用/直接员工假期按日支付工资', '/PL/PL3300S/PL4200/421107', NULL, 7, '0', '1', '1', '2023-03-01 14:54:51', '1', '2023-03-01 14:54:51');
INSERT INTO `qf_subject_international_info` VALUES ('1630823898004197376', 'PL2', '421108', '直接员工假日工资未使用天数', 'Holiday payment unused days wage earner', '€', '3', '1630823709545730048', 0, '/1630785212050968576/1630822946622803968/1630823709545730048/1630823898004197376', '/财务-利润类/销售收入/人工费用/直接员工假日工资未使用天数', '/PL/PL3300S/PL4200/421108', NULL, 8, '0', '1', '1', '2023-03-01 14:54:51', '1', '2023-03-01 14:54:51');
INSERT INTO `qf_subject_international_info` VALUES ('1630823898624954368', 'PL2', '421109', '直接员工假期工资支付', 'Public Holiday Payment wage earner', '€', '3', '1630823709545730048', 0, '/1630785212050968576/1630822946622803968/1630823709545730048/1630823898624954368', '/财务-利润类/销售收入/人工费用/直接员工假期工资支付', '/PL/PL3300S/PL4200/421109', NULL, 9, '0', '1', '1', '2023-03-01 14:54:51', '1', '2023-03-01 14:54:51');
INSERT INTO `qf_subject_international_info` VALUES ('1630823899258294272', 'PL2', '421110', '直接员工工资延续', 'wage continuation wage earner', '€', '3', '1630823709545730048', 0, '/1630785212050968576/1630822946622803968/1630823709545730048/1630823899258294272', '/财务-利润类/销售收入/人工费用/直接员工工资延续', '/PL/PL3300S/PL4200/421110', NULL, 10, '0', '1', '1', '2023-03-01 14:54:52', '1', '2023-03-01 14:54:52');
INSERT INTO `qf_subject_international_info` VALUES ('1630823899937771520', 'PL2', '421112', '直接员工疾病每日津贴', 'sickness daily allowance wages earner', '€', '3', '1630823709545730048', 0, '/1630785212050968576/1630822946622803968/1630823709545730048/1630823899937771520', '/财务-利润类/销售收入/人工费用/直接员工疾病每日津贴', '/PL/PL3300S/PL4200/421112', NULL, 11, '0', '1', '1', '2023-03-01 14:54:52', '1', '2023-03-01 14:54:52');
INSERT INTO `qf_subject_international_info` VALUES ('1630823900600471552', 'PL2', '421113', '直接员工孕产保护津贴', 'allowance maternity protection wages earner', '€', '3', '1630823709545730048', 0, '/1630785212050968576/1630822946622803968/1630823709545730048/1630823900600471552', '/财务-利润类/销售收入/人工费用/直接员工孕产保护津贴', '/PL/PL3300S/PL4200/421113', NULL, 12, '0', '1', '1', '2023-03-01 14:54:52', '1', '2023-03-01 14:54:52');
INSERT INTO `qf_subject_international_info` VALUES ('1630823901368029184', 'PL2', '421117', '直接员工奖金发放', 'bonus paid release wages earner', '€', '3', '1630823709545730048', 0, '/1630785212050968576/1630822946622803968/1630823709545730048/1630823901368029184', '/财务-利润类/销售收入/人工费用/直接员工奖金发放', '/PL/PL3300S/PL4200/421117', NULL, 13, '0', '1', '1', '2023-03-01 14:54:52', '1', '2023-03-01 14:54:52');
INSERT INTO `qf_subject_international_info` VALUES ('1630823902034923520', 'PL2', '421118', '直接员工奖金发放', 'bonuses wage earner', '€', '3', '1630823709545730048', 0, '/1630785212050968576/1630822946622803968/1630823709545730048/1630823902034923520', '/财务-利润类/销售收入/人工费用/直接员工奖金发放', '/PL/PL3300S/PL4200/421118', NULL, 14, '0', '1', '1', '2023-03-01 14:54:52', '1', '2023-03-01 14:54:52');
INSERT INTO `qf_subject_international_info` VALUES ('1630823902680846336', 'PL2', '421119', '直接员工遣散费', 'Severances wages earner', '€', '3', '1630823709545730048', 0, '/1630785212050968576/1630822946622803968/1630823709545730048/1630823902680846336', '/财务-利润类/销售收入/人工费用/直接员工遣散费', '/PL/PL3300S/PL4200/421119', NULL, 15, '0', '1', '1', '2023-03-01 14:54:52', '1', '2023-03-01 14:54:52');
INSERT INTO `qf_subject_international_info` VALUES ('1630823903284826112', 'PL2', '421120', '直接员工每月应计工资', 'monthly accrual wage payment wages earner', '€', '3', '1630823709545730048', 0, '/1630785212050968576/1630822946622803968/1630823709545730048/1630823903284826112', '/财务-利润类/销售收入/人工费用/直接员工每月应计工资', '/PL/PL3300S/PL4200/421120', NULL, 16, '0', '1', '1', '2023-03-01 14:54:52', '1', '2023-03-01 14:54:53');
INSERT INTO `qf_subject_international_info` VALUES ('1630823903897194496', 'PL2', '421121', '直接员工每月应计时工资', 'monthly accrual time account wage earner', '€', '3', '1630823709545730048', 0, '/1630785212050968576/1630822946622803968/1630823709545730048/1630823903897194496', '/财务-利润类/销售收入/人工费用/直接员工每月应计时工资', '/PL/PL3300S/PL4200/421121', NULL, 17, '0', '1', '1', '2023-03-01 14:54:53', '1', '2023-03-01 14:54:53');
INSERT INTO `qf_subject_international_info` VALUES ('1630823904476008448', 'PL2', '421201', '间接员工工资', 'salary', '€', '3', '1630823709545730048', 0, '/1630785212050968576/1630822946622803968/1630823709545730048/1630823904476008448', '/财务-利润类/销售收入/人工费用/间接员工工资', '/PL/PL3300S/PL4200/421201', NULL, 18, '0', '1', '1', '2023-03-01 14:54:53', '1', '2023-03-01 14:54:53');
INSERT INTO `qf_subject_international_info` VALUES ('1630823905130319872', 'PL2', '421202', '间接员工补助金', 'supplementary grant salary earner', '€', '3', '1630823709545730048', 0, '/1630785212050968576/1630822946622803968/1630823709545730048/1630823905130319872', '/财务-利润类/销售收入/人工费用/间接员工补助金', '/PL/PL3300S/PL4200/421202', NULL, 19, '0', '1', '1', '2023-03-01 14:54:53', '1', '2023-03-01 14:54:53');
INSERT INTO `qf_subject_international_info` VALUES ('1630823905763659776', 'PL2', '421203', '间接员工轮班津贴', 'shift premium salary earner', '€', '3', '1630823709545730048', 0, '/1630785212050968576/1630822946622803968/1630823709545730048/1630823905763659776', '/财务-利润类/销售收入/人工费用/间接员工轮班津贴', '/PL/PL3300S/PL4200/421203', NULL, 20, '0', '1', '1', '2023-03-01 14:54:53', '1', '2023-03-01 14:54:53');
INSERT INTO `qf_subject_international_info` VALUES ('1630823906405388288', 'PL2', '421204', '间接员工加班津贴', 'overtime premium salary earner', '€', '3', '1630823709545730048', 0, '/1630785212050968576/1630822946622803968/1630823709545730048/1630823906405388288', '/财务-利润类/销售收入/人工费用/间接员工加班津贴', '/PL/PL3300S/PL4200/421204', NULL, 21, '0', '1', '1', '2023-03-01 14:54:53', '1', '2023-03-01 14:54:53');
INSERT INTO `qf_subject_international_info` VALUES ('1630823907097448448', 'PL2', '421205', '间接员工夜间轮班津贴', 'night shift premium salary earner', '€', '3', '1630823709545730048', 0, '/1630785212050968576/1630822946622803968/1630823709545730048/1630823907097448448', '/财务-利润类/销售收入/人工费用/间接员工夜间轮班津贴', '/PL/PL3300S/PL4200/421205', NULL, 22, '0', '1', '1', '2023-03-01 14:54:53', '1', '2023-03-01 14:54:53');
INSERT INTO `qf_subject_international_info` VALUES ('1630823907751759872', 'PL2', '421206', '间接员工假期按日支付工资', 'Holiday payment daily fee salary earner', '€', '3', '1630823709545730048', 0, '/1630785212050968576/1630822946622803968/1630823709545730048/1630823907751759872', '/财务-利润类/销售收入/人工费用/间接员工假期按日支付工资', '/PL/PL3300S/PL4200/421206', NULL, 23, '0', '1', '1', '2023-03-01 14:54:54', '1', '2023-03-01 14:54:54');
INSERT INTO `qf_subject_international_info` VALUES ('1630823908393488384', 'PL2', '421207', '间接员工假日工资未使用天数', 'Holiday payment unused days salary earner', '€', '3', '1630823709545730048', 0, '/1630785212050968576/1630822946622803968/1630823709545730048/1630823908393488384', '/财务-利润类/销售收入/人工费用/间接员工假日工资未使用天数', '/PL/PL3300S/PL4200/421207', NULL, 24, '0', '1', '1', '2023-03-01 14:54:54', '1', '2023-03-01 14:54:54');
INSERT INTO `qf_subject_international_info` VALUES ('1630823908993273856', 'PL2', '421208', '间接员工资本化工资', 'capital forming payments salary earner', '€', '3', '1630823709545730048', 0, '/1630785212050968576/1630822946622803968/1630823709545730048/1630823908993273856', '/财务-利润类/销售收入/人工费用/间接员工资本化工资', '/PL/PL3300S/PL4200/421208', NULL, 25, '0', '1', '1', '2023-03-01 14:54:54', '1', '2023-03-01 14:54:54');
INSERT INTO `qf_subject_international_info` VALUES ('1630823909681139712', 'PL2', '421209', '间接员工产妇保护津贴', 'allowance maternity protection', '€', '3', '1630823709545730048', 0, '/1630785212050968576/1630822946622803968/1630823709545730048/1630823909681139712', '/财务-利润类/销售收入/人工费用/间接员工产妇保护津贴', '/PL/PL3300S/PL4200/421209', NULL, 26, '0', '1', '1', '2023-03-01 14:54:54', '1', '2023-03-01 14:54:54');
INSERT INTO `qf_subject_international_info` VALUES ('1630823910369005568', 'PL2', '421211', '间接员工奖金工资收入者', 'bonuses salary earner', '€', '3', '1630823709545730048', 0, '/1630785212050968576/1630822946622803968/1630823709545730048/1630823910369005568', '/财务-利润类/销售收入/人工费用/间接员工奖金工资收入者', '/PL/PL3300S/PL4200/421211', NULL, 27, '0', '1', '1', '2023-03-01 14:54:54', '1', '2023-03-01 14:54:54');
INSERT INTO `qf_subject_international_info` VALUES ('1630823910998151168', 'PL2', '421212', '间接员工每月应计工资支付', 'monthly accrual salary payment', '€', '3', '1630823709545730048', 0, '/1630785212050968576/1630822946622803968/1630823709545730048/1630823910998151168', '/财务-利润类/销售收入/人工费用/间接员工每月应计工资支付', '/PL/PL3300S/PL4200/421212', NULL, 28, '0', '1', '1', '2023-03-01 14:54:54', '1', '2023-03-01 14:54:54');
INSERT INTO `qf_subject_international_info` VALUES ('1630823911732154368', 'PL2', '421213', '间接员工每月应计时工资', 'monthly accrual time account salary earner', '€', '3', '1630823709545730048', 0, '/1630785212050968576/1630822946622803968/1630823709545730048/1630823911732154368', '/财务-利润类/销售收入/人工费用/间接员工每月应计时工资', '/PL/PL3300S/PL4200/421213', NULL, 29, '0', '1', '1', '2023-03-01 14:54:55', '1', '2023-03-01 14:54:55');
INSERT INTO `qf_subject_international_info` VALUES ('1630823912344522752', 'PL2', '421214', '间接员工解雇与工会签订合同的员工', 'severances employees with union contracts salary earner', '€', '3', '1630823709545730048', 0, '/1630785212050968576/1630822946622803968/1630823709545730048/1630823912344522752', '/财务-利润类/销售收入/人工费用/间接员工解雇与工会签订合同的员工', '/PL/PL3300S/PL4200/421214', NULL, 30, '0', '1', '1', '2023-03-01 14:54:55', '1', '2023-03-01 14:54:55');
INSERT INTO `qf_subject_international_info` VALUES ('1630823913032388608', 'PL2', '421215', '间接员工遣散费无工会合同的雇员', 'severances employees without union contracts salary earner', '€', '3', '1630823709545730048', 0, '/1630785212050968576/1630822946622803968/1630823709545730048/1630823913032388608', '/财务-利润类/销售收入/人工费用/间接员工遣散费无工会合同的雇员', '/PL/PL3300S/PL4200/421215', NULL, 31, '0', '1', '1', '2023-03-01 14:54:55', '1', '2023-03-01 14:54:55');
INSERT INTO `qf_subject_international_info` VALUES ('1630823913883832320', 'PL2', '421216', '间接员工最终付款/版税工资收入者', 'final payments/royalties salary earner', '€', '3', '1630823709545730048', 0, '/1630785212050968576/1630822946622803968/1630823709545730048/1630823913883832320', '/财务-利润类/销售收入/人工费用/间接员工最终付款/版税工资收入者', '/PL/PL3300S/PL4200/421216', NULL, 32, '0', '1', '1', '2023-03-01 14:54:55', '1', '2023-03-01 14:54:55');
INSERT INTO `qf_subject_international_info` VALUES ('1630823914676555776', 'PL2', '422101', '直接员工的社会责任费用', 'expenses for social duties wage earner', '€', '3', '1630823709545730048', 0, '/1630785212050968576/1630822946622803968/1630823709545730048/1630823914676555776', '/财务-利润类/销售收入/人工费用/直接员工的社会责任费用', '/PL/PL3300S/PL4200/422101', NULL, 33, '0', '1', '1', '2023-03-01 14:54:55', '1', '2023-03-01 14:54:55');
INSERT INTO `qf_subject_international_info` VALUES ('1630823915314089984', 'PL2', '422102', '直接员工雇主供款养老基金', 'employer\'s contribution pension fund wages earner', '€', '3', '1630823709545730048', 0, '/1630785212050968576/1630822946622803968/1630823709545730048/1630823915314089984', '/财务-利润类/销售收入/人工费用/直接员工雇主供款养老基金', '/PL/PL3300S/PL4200/422102', NULL, 34, '0', '1', '1', '2023-03-01 14:54:55', '1', '2023-03-01 14:54:55');
INSERT INTO `qf_subject_international_info` VALUES ('1630823915951624192', 'PL2', '422103', '直接员工雇主缴费失业保险', 'employer\'s contribution unemployment insurance wages earner', '€', '3', '1630823709545730048', 0, '/1630785212050968576/1630822946622803968/1630823709545730048/1630823915951624192', '/财务-利润类/销售收入/人工费用/直接员工雇主缴费失业保险', '/PL/PL3300S/PL4200/422103', NULL, 35, '0', '1', '1', '2023-03-01 14:54:56', '1', '2023-03-01 14:54:56');
INSERT INTO `qf_subject_international_info` VALUES ('1630823916551409664', 'PL2', '422104', '直接员工雇主供款长期护理保险', 'employer\'s contribution long term care insurance wages earner', '€', '3', '1630823709545730048', 0, '/1630785212050968576/1630822946622803968/1630823709545730048/1630823916551409664', '/财务-利润类/销售收入/人工费用/直接员工雇主供款长期护理保险', '/PL/PL3300S/PL4200/422104', NULL, 36, '0', '1', '1', '2023-03-01 14:54:56', '1', '2023-03-01 14:54:56');
INSERT INTO `qf_subject_international_info` VALUES ('1630823917163778048', 'PL2', '422105', '直接员工主缴费健康保险', 'employer\'s contribution health insurance wages earner', '€', '3', '1630823709545730048', 0, '/1630785212050968576/1630822946622803968/1630823709545730048/1630823917163778048', '/财务-利润类/销售收入/人工费用/直接员工主缴费健康保险', '/PL/PL3300S/PL4200/422105', NULL, 37, '0', '1', '1', '2023-03-01 14:54:56', '1', '2023-03-01 14:54:56');
INSERT INTO `qf_subject_international_info` VALUES ('1630823917755174912', 'PL2', '422106', '直接员工合法工人补偿工资', 'legal workers compensation wages earner', '€', '3', '1630823709545730048', 0, '/1630785212050968576/1630822946622803968/1630823709545730048/1630823917755174912', '/财务-利润类/销售收入/人工费用/直接员工合法工人补偿工资', '/PL/PL3300S/PL4200/422106', NULL, 38, '0', '1', '1', '2023-03-01 14:54:56', '1', '2023-03-01 14:54:56');
INSERT INTO `qf_subject_international_info` VALUES ('1630823918363348992', 'PL2', '422107', '直接员工残疾雇员与直接员工的平等待遇', 'equalisation for handicapped employees wages earner', '€', '3', '1630823709545730048', 0, '/1630785212050968576/1630822946622803968/1630823709545730048/1630823918363348992', '/财务-利润类/销售收入/人工费用/直接员工残疾雇员与直接员工的平等待遇', '/PL/PL3300S/PL4200/422107', NULL, 39, '0', '1', '1', '2023-03-01 14:54:56', '1', '2023-03-01 14:54:56');
INSERT INTO `qf_subject_international_info` VALUES ('1630823919034437632', 'PL2', '422108', '直接员工向退休基金支付工资', 'Payments to Pension Funds wages earner', '€', '3', '1630823709545730048', 0, '/1630785212050968576/1630822946622803968/1630823709545730048/1630823919034437632', '/财务-利润类/销售收入/人工费用/直接员工向退休基金支付工资', '/PL/PL3300S/PL4200/422108', NULL, 40, '0', '1', '1', '2023-03-01 14:54:56', '1', '2023-03-01 14:54:56');
INSERT INTO `qf_subject_international_info` VALUES ('1630823919659388928', 'PL2', '422109', '直接员工养老金负债的增加', 'increase of pension liabilities wages earner', '€', '3', '1630823709545730048', 0, '/1630785212050968576/1630822946622803968/1630823709545730048/1630823919659388928', '/财务-利润类/销售收入/人工费用/直接员工养老金负债的增加', '/PL/PL3300S/PL4200/422109', NULL, 41, '0', '1', '1', '2023-03-01 14:54:56', '1', '2023-03-01 14:54:56');
INSERT INTO `qf_subject_international_info` VALUES ('1630823920305311744', 'PL2', '422110', '直接员工公司计划负债的增加', 'increase of company scheme liabilities wages earner', '€', '3', '1630823709545730048', 0, '/1630785212050968576/1630822946622803968/1630823709545730048/1630823920305311744', '/财务-利润类/销售收入/人工费用/直接员工公司计划负债的增加', '/PL/PL3300S/PL4200/422110', NULL, 42, '0', '1', '1', '2023-03-01 14:54:57', '1', '2023-03-01 14:54:57');
INSERT INTO `qf_subject_international_info` VALUES ('1630823920921874432', 'PL2', '422201', '间接员工社会责任费用', 'expenses for social duties salary earner', '€', '3', '1630823709545730048', 0, '/1630785212050968576/1630822946622803968/1630823709545730048/1630823920921874432', '/财务-利润类/销售收入/人工费用/间接员工社会责任费用', '/PL/PL3300S/PL4200/422201', NULL, 43, '0', '1', '1', '2023-03-01 14:54:57', '1', '2023-03-01 14:54:57');
INSERT INTO `qf_subject_international_info` VALUES ('1630823921546825728', 'PL2', '422202', '间接员工雇主缴费法定的社会保险', 'employer\'s contribution legal social insurance salary earner', '€', '3', '1630823709545730048', 0, '/1630785212050968576/1630822946622803968/1630823709545730048/1630823921546825728', '/财务-利润类/销售收入/人工费用/间接员工雇主缴费法定的社会保险', '/PL/PL3300S/PL4200/422202', NULL, 44, '0', '1', '1', '2023-03-01 14:54:57', '1', '2023-03-01 14:54:57');
INSERT INTO `qf_subject_international_info` VALUES ('1630823922154999808', 'PL2', '422203', '间接员工雇主缴费的养老金', 'employer\'s contribution pension fund salary earner', '€', '3', '1630823709545730048', 0, '/1630785212050968576/1630822946622803968/1630823709545730048/1630823922154999808', '/财务-利润类/销售收入/人工费用/间接员工雇主缴费的养老金', '/PL/PL3300S/PL4200/422203', NULL, 45, '0', '1', '1', '2023-03-01 14:54:57', '1', '2023-03-01 14:54:57');
INSERT INTO `qf_subject_international_info` VALUES ('1630823922821894144', 'PL2', '422204', '间接员工雇主缴费的失业保险', 'employer\'s contribution unemployment insurance salary earner', '€', '3', '1630823709545730048', 0, '/1630785212050968576/1630822946622803968/1630823709545730048/1630823922821894144', '/财务-利润类/销售收入/人工费用/间接员工雇主缴费的失业保险', '/PL/PL3300S/PL4200/422204', NULL, 46, '0', '1', '1', '2023-03-01 14:54:57', '1', '2023-03-01 14:54:57');
INSERT INTO `qf_subject_international_info` VALUES ('1630823923442651136', 'PL2', '422205', '间接员工雇主供款长期的护理保险', 'employer\'s contribution long term care insurance salary earner', '€', '3', '1630823709545730048', 0, '/1630785212050968576/1630822946622803968/1630823709545730048/1630823923442651136', '/财务-利润类/销售收入/人工费用/间接员工雇主供款长期的护理保险', '/PL/PL3300S/PL4200/422205', NULL, 47, '0', '1', '1', '2023-03-01 14:54:57', '1', '2023-03-01 14:54:57');
INSERT INTO `qf_subject_international_info` VALUES ('1630823924042436608', 'PL2', '422206', '间接员工雇主供款的健康保险', 'employer\'s contribution health insurance salary earner', '€', '3', '1630823709545730048', 0, '/1630785212050968576/1630822946622803968/1630823709545730048/1630823924042436608', '/财务-利润类/销售收入/人工费用/间接员工雇主供款的健康保险', '/PL/PL3300S/PL4200/422206', NULL, 48, '0', '1', '1', '2023-03-01 14:54:57', '1', '2023-03-01 14:54:57');
INSERT INTO `qf_subject_international_info` VALUES ('1630823924663193600', 'PL2', '422208', '间接员工合法工人补偿工资', 'legal workers compensation salary earner', '€', '3', '1630823709545730048', 0, '/1630785212050968576/1630822946622803968/1630823709545730048/1630823924663193600', '/财务-利润类/销售收入/人工费用/间接员工合法工人补偿工资', '/PL/PL3300S/PL4200/422208', NULL, 49, '0', '1', '1', '2023-03-01 14:54:58', '1', '2023-03-01 14:54:58');
INSERT INTO `qf_subject_international_info` VALUES ('1630823925292339200', 'PL2', '422209', '间接员工残疾雇员工资收入均等化', 'equalisation for handicapped employees salary earner', '€', '3', '1630823709545730048', 0, '/1630785212050968576/1630822946622803968/1630823709545730048/1630823925292339200', '/财务-利润类/销售收入/人工费用/间接员工残疾雇员工资收入均等化', '/PL/PL3300S/PL4200/422209', NULL, 50, '0', '1', '1', '2023-03-01 14:54:58', '1', '2023-03-01 14:54:58');
INSERT INTO `qf_subject_international_info` VALUES ('1630823925900513280', 'PL2', '422210', '间接员工养恤基金工资支付', 'Payments to Pension Funds salary earner', '€', '4', '1630823709545730048', 0, '/1630785212050968576/1630822946622803968/1630823709545730048/1630823925900513280', '/财务-利润类/销售收入/人工费用/间接员工养恤基金工资支付', '/PL/PL3300S/PL4200/422210', NULL, 51, '0', '1', '1', '2023-03-01 14:54:58', '1', '2023-03-08 09:25:11');
INSERT INTO `qf_subject_international_info` VALUES ('1630823926546436096', 'PL2', '422211', '间接员工养老金负债的增加', 'increase of pension liabilities salary earner', '€', '3', '1630823709545730048', 0, '/1630785212050968576/1630822946622803968/1630823709545730048/1630823926546436096', '/财务-利润类/销售收入/人工费用/间接员工养老金负债的增加', '/PL/PL3300S/PL4200/422211', NULL, 52, '0', '1', '1', '2023-03-01 14:54:58', '1', '2023-03-01 14:54:58');
INSERT INTO `qf_subject_international_info` VALUES ('1630823927259467776', 'PL2', '422212', '间接员工公司计划负债的增加', 'increase of company scheme liabilities salary earner', '€', '3', '1630823709545730048', 0, '/1630785212050968576/1630822946622803968/1630823709545730048/1630823927259467776', '/财务-利润类/销售收入/人工费用/间接员工公司计划负债的增加', '/PL/PL3300S/PL4200/422212', NULL, 53, '0', '1', '1', '2023-03-01 14:54:58', '1', '2023-03-01 14:54:58');
INSERT INTO `qf_subject_international_info` VALUES ('1630823927897001984', 'PL2', 'PL4610', '其他经营费用——主要业务支出', 'Other operating expense - main business cost', '€', '3', '1630823709545730048', 34, '/1630785212050968576/1630822946622803968/1630823709545730048/1630823927897001984', '/财务-利润类/销售收入/人工费用/其他经营费用——主要业务支出', '/PL/PL3300S/PL4200/PL4610', NULL, 1, '0', '1', '1', '2023-03-01 14:54:58', '1', '2023-03-01 14:55:34');
INSERT INTO `qf_subject_international_info` VALUES ('1630823928488398848', 'PL2', 'PL4611', '其他营业费用-其他业务成本', 'Other operating expense - other business cost', '€', '3', '1630823709545730048', 6, '/1630785212050968576/1630822946622803968/1630823709545730048/1630823928488398848', '/财务-利润类/销售收入/人工费用/其他营业费用-其他业务成本', '/PL/PL3300S/PL4200/PL4611', NULL, 2, '0', '1', '1', '2023-03-01 14:54:58', '1', '2023-03-01 14:55:35');
INSERT INTO `qf_subject_international_info` VALUES ('1630823929092378624', 'PL2', 'PL4619', '其他营业费用-营业税和额外费用', 'Other operating expense - operation tax and extra', '€', '3', '1630823709545730048', 3, '/1630785212050968576/1630822946622803968/1630823709545730048/1630823929092378624', '/财务-利润类/销售收入/人工费用/其他营业费用-营业税和额外费用', '/PL/PL3300S/PL4200/PL4619', NULL, 3, '0', '1', '1', '2023-03-01 14:54:59', '1', '2023-03-01 14:55:35');
INSERT INTO `qf_subject_international_info` VALUES ('1630823929725718528', 'PL2', 'PL4620', '其他营业费用-销售费用', 'Other operating expense - sales expenses', '€', '3', '1630823709545730048', 14, '/1630785212050968576/1630822946622803968/1630823709545730048/1630823929725718528', '/财务-利润类/销售收入/人工费用/其他营业费用-销售费用', '/PL/PL3300S/PL4200/PL4620', NULL, 4, '0', '1', '1', '2023-03-01 14:54:59', '1', '2023-03-01 14:55:37');
INSERT INTO `qf_subject_international_info` VALUES ('1630823930338086912', 'PL2', 'PL4621', '其他营业费用-管理费用', 'Other operating expense - administrative expenses', '€', '3', '1630823709545730048', 19, '/1630785212050968576/1630822946622803968/1630823709545730048/1630823930338086912', '/财务-利润类/销售收入/人工费用/其他营业费用-管理费用', '/PL/PL3300S/PL4200/PL4621', NULL, 5, '0', '1', '1', '2023-03-01 14:54:59', '1', '2023-03-01 14:55:40');
INSERT INTO `qf_subject_international_info` VALUES ('1630823930942066688', 'PL2', 'PL4624', '其他营业费用-财务费用', 'Other operating expense - financial expenses', '€', '3', '1630823709545730048', 3, '/1630785212050968576/1630822946622803968/1630823709545730048/1630823930942066688', '/财务-利润类/销售收入/人工费用/其他营业费用-财务费用', '/PL/PL3300S/PL4200/PL4624', NULL, 6, '0', '1', '1', '2023-03-01 14:54:59', '1', '2023-03-01 14:55:41');
INSERT INTO `qf_subject_international_info` VALUES ('1630823931583795200', 'PL2', '440904', '货币衍生工具公允价值计量费用', 'expenses from of fair value measurment of currency derivatives', '€', '3', '1630823710804021248', 0, '/1630785212050968576/1630822946622803968/1630823710804021248/1630823931583795200', '/财务-利润类/销售收入/公允价值计量的其他营业费用/货币衍生工具公允价值计量费用', '/PL/PL3300S/PL4700/440904', NULL, 1, '0', '1', '1', '2023-03-01 14:54:59', '1', '2023-03-01 14:54:59');
INSERT INTO `qf_subject_international_info` VALUES ('1630823932217135104', 'PL2', '440905', '以公允价值计量且其变动计入当期损益的货币衍生品的公司间损失', 'IC loss of currency derivatives FVTPL', '€', '3', '1630823710804021248', 0, '/1630785212050968576/1630822946622803968/1630823710804021248/1630823932217135104', '/财务-利润类/销售收入/公允价值计量的其他营业费用/以公允价值计量且其变动计入当期损益的货币衍生品的公司间损失', '/PL/PL3300S/PL4700/440905', NULL, 2, '0', '1', '1', '2023-03-01 14:54:59', '1', '2023-03-01 14:54:59');
INSERT INTO `qf_subject_international_info` VALUES ('1630823932884029440', 'PL2', '440201', '附属公司间租金费用', 'charged rent from consolidated companies', '€', '3', '1630823711399612416', 0, '/1630785212050968576/1630822946622803968/1630823711399612416/1630823932884029440', '/财务-利润类/销售收入/关联公司提供服务的其他营业费用/附属公司间租金费用', '/PL/PL3300S/PL4800/440201', NULL, 1, '0', '1', '1', '2023-03-01 14:55:00', '1', '2023-03-01 14:55:00');
INSERT INTO `qf_subject_international_info` VALUES ('1630823933517369344', 'PL2', '440812', '附属公司间管理服务费用', 'charged costs for administrative services from consolidated companies', '€', '3', '1630823711399612416', 0, '/1630785212050968576/1630822946622803968/1630823711399612416/1630823933517369344', '/财务-利润类/销售收入/关联公司提供服务的其他营业费用/附属公司间管理服务费用', '/PL/PL3300S/PL4800/440812', NULL, 2, '0', '1', '1', '2023-03-01 14:55:00', '1', '2023-03-01 14:55:00');
INSERT INTO `qf_subject_international_info` VALUES ('1630823934146514944', 'PL2', '440813', '附属公司间其他成本', 'charged costs other from consolidated companies', '€', '3', '1630823711399612416', 0, '/1630785212050968576/1630822946622803968/1630823711399612416/1630823934146514944', '/财务-利润类/销售收入/关联公司提供服务的其他营业费用/附属公司间其他成本', '/PL/PL3300S/PL4800/440813', NULL, 3, '0', '1', '1', '2023-03-01 14:55:00', '1', '2023-03-01 14:55:00');
INSERT INTO `qf_subject_international_info` VALUES ('1630823934771466240', 'PL2', '440814', '附属公司间销售服务费用', 'charged  distribution costs from consolidated companies', '€', '3', '1630823711399612416', 0, '/1630785212050968576/1630822946622803968/1630823711399612416/1630823934771466240', '/财务-利润类/销售收入/关联公司提供服务的其他营业费用/附属公司间销售服务费用', '/PL/PL3300S/PL4800/440814', NULL, 4, '0', '1', '1', '2023-03-01 14:55:00', '1', '2023-03-01 14:55:00');
INSERT INTO `qf_subject_international_info` VALUES ('1630823935438360576', 'PL2', '440815', '附属公司间研发费用', 'charged research and development costs from consolidated companies', '€', '3', '1630823711399612416', 0, '/1630785212050968576/1630822946622803968/1630823711399612416/1630823935438360576', '/财务-利润类/销售收入/关联公司提供服务的其他营业费用/附属公司间研发费用', '/PL/PL3300S/PL4800/440815', NULL, 5, '0', '1', '1', '2023-03-01 14:55:00', '1', '2023-03-01 14:55:00');
INSERT INTO `qf_subject_international_info` VALUES ('1630823936075894784', 'PL2', '440816', '附属公司间管理费用', 'charged management fees from consolidated companies', '€', '3', '1630823711399612416', 0, '/1630785212050968576/1630822946622803968/1630823711399612416/1630823936075894784', '/财务-利润类/销售收入/关联公司提供服务的其他营业费用/附属公司间管理费用', '/PL/PL3300S/PL4800/440816', NULL, 6, '0', '1', '1', '2023-03-01 14:55:00', '1', '2023-03-01 14:55:00');
INSERT INTO `qf_subject_international_info` VALUES ('1630823936679874560', 'PL2', '440817', '附属公司间购置费用', 'charged purchasing fee from consolidated companies', '€', '3', '1630823711399612416', 0, '/1630785212050968576/1630822946622803968/1630823711399612416/1630823936679874560', '/财务-利润类/销售收入/关联公司提供服务的其他营业费用/附属公司间购置费用', '/PL/PL3300S/PL4800/440817', NULL, 7, '0', '1', '1', '2023-03-01 14:55:00', '1', '2023-03-01 14:55:00');
INSERT INTO `qf_subject_international_info` VALUES ('1630823937309020160', 'PL2', '440818', '附属公司间质保费用', 'charged quality assurance fee from consolidated companies', '€', '3', '1630823711399612416', 0, '/1630785212050968576/1630822946622803968/1630823711399612416/1630823937309020160', '/财务-利润类/销售收入/关联公司提供服务的其他营业费用/附属公司间质保费用', '/PL/PL3300S/PL4800/440818', NULL, 8, '0', '1', '1', '2023-03-01 14:55:01', '1', '2023-03-01 14:55:01');
INSERT INTO `qf_subject_international_info` VALUES ('1630823937942360064', 'PL2', '440819', '附属公司间全球IT费用', 'charged costs for Global IT from consolidated companies', '€', '3', '1630823711399612416', 0, '/1630785212050968576/1630822946622803968/1630823711399612416/1630823937942360064', '/财务-利润类/销售收入/关联公司提供服务的其他营业费用/附属公司间全球IT费用', '/PL/PL3300S/PL4800/440819', NULL, 9, '0', '1', '1', '2023-03-01 14:55:01', '1', '2023-03-01 14:55:01');
INSERT INTO `qf_subject_international_info` VALUES ('1630823938542145536', 'PL2', '441113', '附属公司间固定资产处置费用', 'revenue on disposal of fixed assets consolid. Co. (when net loss)', '€', '3', '1630823711399612416', 0, '/1630785212050968576/1630822946622803968/1630823711399612416/1630823938542145536', '/财务-利润类/销售收入/关联公司提供服务的其他营业费用/附属公司间固定资产处置费用', '/PL/PL3300S/PL4800/441113', NULL, 10, '0', '1', '1', '2023-03-01 14:55:01', '1', '2023-03-01 14:55:01');
INSERT INTO `qf_subject_international_info` VALUES ('1630823939167096832', 'PL2', '441114', '萨固密集团内固定资产处置费用', 'disposal of fixed assets (when net loss) when sale within SG group', '€', '3', '1630823711399612416', 0, '/1630785212050968576/1630822946622803968/1630823711399612416/1630823939167096832', '/财务-利润类/销售收入/关联公司提供服务的其他营业费用/萨固密集团内固定资产处置费用', '/PL/PL3300S/PL4800/441114', NULL, 11, '0', '1', '1', '2023-03-01 14:55:01', '1', '2023-03-01 14:55:01');
INSERT INTO `qf_subject_international_info` VALUES ('1630823939775270912', 'PL2', '431003', '不动产、厂房和机器设备折旧', 'Depreciation for Property, Plant and Equipment', '€', '3', '1630823712150392832', 0, '/1630785212050968576/1630822947239366656/1630823712150392832/1630823939775270912', '/财务-利润类/息税折旧摊销前利润/国定资产折旧/不动产、厂房和机器设备折旧', '/PL/EBITDA/PL4320/431003', NULL, 1, '0', '1', '1', '2023-03-01 14:55:01', '1', '2023-03-01 14:55:01');
INSERT INTO `qf_subject_international_info` VALUES ('1630823940521857024', 'PL2', '431004', '年度不动产、厂房和机器设备折旧', 'Depreciation Expenses for Property, Plant and Equipment yearly', '€', '3', '1630823712150392832', 0, '/1630785212050968576/1630822947239366656/1630823712150392832/1630823940521857024', '/财务-利润类/息税折旧摊销前利润/国定资产折旧/年度不动产、厂房和机器设备折旧', '/PL/EBITDA/PL4320/431004', NULL, 2, '0', '1', '1', '2023-03-01 14:55:01', '1', '2023-03-01 14:55:01');
INSERT INTO `qf_subject_international_info` VALUES ('1630823941100670976', 'PL2', '431006', '低价值资产折旧', 'Depreciation low value assets', '€', '3', '1630823712150392832', 0, '/1630785212050968576/1630822947239366656/1630823712150392832/1630823941100670976', '/财务-利润类/息税折旧摊销前利润/国定资产折旧/低价值资产折旧', '/PL/EBITDA/PL4320/431006', NULL, 3, '0', '1', '1', '2023-03-01 14:55:02', '1', '2023-03-01 14:55:02');
INSERT INTO `qf_subject_international_info` VALUES ('1630823941708845056', 'PL2', '431007', '租赁货物折旧', 'Depreciation Leased goods', '€', '3', '1630823712150392832', 0, '/1630785212050968576/1630822947239366656/1630823712150392832/1630823941708845056', '/财务-利润类/息税折旧摊销前利润/国定资产折旧/租赁货物折旧', '/PL/EBITDA/PL4320/431007', NULL, 4, '0', '1', '1', '2023-03-01 14:55:02', '1', '2023-03-01 14:55:02');
INSERT INTO `qf_subject_international_info` VALUES ('1630823942317019136', 'PL2', '431012', '使用权资产折旧', 'depreciation on right of use', '€', '3', '1630823712150392832', 0, '/1630785212050968576/1630822947239366656/1630823712150392832/1630823942317019136', '/财务-利润类/息税折旧摊销前利润/国定资产折旧/使用权资产折旧', '/PL/EBITDA/PL4320/431012', NULL, 5, '0', '1', '1', '2023-03-01 14:55:02', '1', '2023-03-01 14:55:02');
INSERT INTO `qf_subject_international_info` VALUES ('1630823942929387520', 'PL2', '431005', '不动产、厂房和机器设备减值损失', 'impairment losses of property, plant and equipment yearly', '€', '3', '1630823712745984000', 0, '/1630785212050968576/1630822947239366656/1630823712745984000/1630823942929387520', '/财务-利润类/息税折旧摊销前利润/固定资产减值/不动产、厂房和机器设备减值损失', '/PL/EBITDA/PL4520/431005', NULL, 1, '0', '1', '1', '2023-03-01 14:55:02', '1', '2023-03-01 14:55:02');
INSERT INTO `qf_subject_international_info` VALUES ('1630823943512395776', 'PL2', '431011', '减值损失冲回', 'Reversal of impairment losses', '€', '3', '1630823712745984000', 0, '/1630785212050968576/1630822947239366656/1630823712745984000/1630823943512395776', '/财务-利润类/息税折旧摊销前利润/固定资产减值/减值损失冲回', '/PL/EBITDA/PL4520/431011', NULL, 2, '0', '1', '1', '2023-03-01 14:55:02', '1', '2023-03-01 14:55:02');
INSERT INTO `qf_subject_international_info` VALUES ('1630823944133152768', 'PL2', '431013', '使用权资产减值损失', 'Impairment on right of use', '€', '3', '1630823712745984000', 0, '/1630785212050968576/1630822947239366656/1630823712745984000/1630823944133152768', '/财务-利润类/息税折旧摊销前利润/固定资产减值/使用权资产减值损失', '/PL/EBITDA/PL4520/431013', NULL, 3, '0', '1', '1', '2023-03-01 14:55:02', '1', '2023-03-01 14:55:02');
INSERT INTO `qf_subject_international_info` VALUES ('1630823944749715456', 'PL2', '452001', '金融资产减值损失', 'impairment losses of financial assets', '€', '3', '1630823712745984000', 0, '/1630785212050968576/1630822947239366656/1630823712745984000/1630823944749715456', '/财务-利润类/息税折旧摊销前利润/固定资产减值/金融资产减值损失', '/PL/EBITDA/PL4520/452001', NULL, 4, '0', '1', '1', '2023-03-01 14:55:02', '1', '2023-03-01 14:55:02');
INSERT INTO `qf_subject_international_info` VALUES ('1630823945387249664', 'PL2', '431001', '年度无形资产摊销', 'Depreciation for intagible assets yearly', '€', '3', '1630823713421266944', 0, '/1630785212050968576/1630822947855929344/1630823713421266944/1630823945387249664', '/财务-利润类/息税摊销前利润/无形资产摊销/年度无形资产摊销', '/PL/EBITA/PL4310/431001', NULL, 1, '0', '1', '1', '2023-03-01 14:55:03', '1', '2023-03-01 14:55:03');
INSERT INTO `qf_subject_international_info` VALUES ('1630823945982840832', 'PL2', '431010', '商誉减值损失', 'impairment losses of Goodwill', '€', '3', '1630823714054606848', 0, '/1630785212050968576/1630822947855929344/1630823714054606848/1630823945982840832', '/财务-利润类/息税摊销前利润/商誉减值/商誉减值损失', '/PL/EBITA/PL4400/431010', NULL, 1, '0', '1', '1', '2023-03-01 14:55:03', '1', '2023-03-01 14:55:03');
INSERT INTO `qf_subject_international_info` VALUES ('1630823946561654784', 'PL2', '431002', '年度无形资产减值损失', 'impairment losses of intangible assets yearly', '€', '3', '1630823714662780928', 0, '/1630785212050968576/1630822947855929344/1630823714662780928/1630823946561654784', '/财务-利润类/息税摊销前利润/无形资产减值/年度无形资产减值损失', '/PL/EBITA/PL4510/431002', NULL, 1, '0', '1', '1', '2023-03-01 14:55:03', '1', '2023-03-01 14:55:03');
INSERT INTO `qf_subject_international_info` VALUES ('1630823947157245952', 'PL2', '431009', '以购买价格分摊的无形资产的摊销费用', 'Depreciation expen. Intang. assets based of purchase price allocation', '€', '3', '1630823714662780928', 0, '/1630785212050968576/1630822947855929344/1630823714662780928/1630823947157245952', '/财务-利润类/息税摊销前利润/无形资产减值/以购买价格分摊的无形资产的摊销费用', '/PL/EBITA/PL4510/431009', NULL, 2, '0', '1', '1', '2023-03-01 14:55:03', '1', '2023-03-01 14:55:03');
INSERT INTO `qf_subject_international_info` VALUES ('1630823947773808640', 'PL1', '351005', '附属公司间利息收入', 'interest income to consolidated comp. all comp.', '€', '4', '1630823715338063872', 0, '/1630785212050968576/1630822948472492032/1630823715338063872/1630823947773808640', '/财务-利润类/息税前利润/关联公司利息收入/附属公司间利息收入', '/PL/EBIT/PL5000/351005', NULL, 1, '0', '1', '1', '2023-03-01 14:55:03', '1', '2023-03-03 15:56:17');
INSERT INTO `qf_subject_international_info` VALUES ('1630823948415537152', 'PL1', '351013', '附属公司间衍生工具利息收入', 'interest income to IC derivatives', '€', '4', '1630823715338063872', 0, '/1630785212050968576/1630822948472492032/1630823715338063872/1630823948415537152', '/财务-利润类/息税前利润/关联公司利息收入/附属公司间衍生工具利息收入', '/PL/EBIT/PL5000/351013', NULL, 2, '0', '1', '1', '2023-03-01 14:55:03', '1', '2023-03-03 15:56:35');
INSERT INTO `qf_subject_international_info` VALUES ('1630823949019516928', 'PL1', '351001', '银行存款利息收入', 'interest income from cash at bank on current accounts', '€', '4', '1630823715921072128', 0, '/1630785212050968576/1630822948472492032/1630823715921072128/1630823949019516928', '/财务-利润类/息税前利润/财务收入/银行存款利息收入', '/PL/EBIT/PL5100/351001', NULL, 1, '0', '1', '1', '2023-03-01 14:55:03', '1', '2023-03-03 15:57:28');
INSERT INTO `qf_subject_international_info` VALUES ('1630823949644468224', 'PL1', '351010', '退税利息收入', 'interest Income from refund of tax', '€', '4', '1630823715921072128', 0, '/1630785212050968576/1630822948472492032/1630823715921072128/1630823949644468224', '/财务-利润类/息税前利润/财务收入/退税利息收入', '/PL/EBIT/PL5100/351010', NULL, 2, '0', '1', '1', '2023-03-01 14:55:04', '1', '2023-03-03 15:57:53');
INSERT INTO `qf_subject_international_info` VALUES ('1630823950273613824', 'PL1', '351012', '衍生品利息收入', 'interest income from derivatives', '€', '4', '1630823715921072128', 0, '/1630785212050968576/1630822948472492032/1630823715921072128/1630823950273613824', '/财务-利润类/息税前利润/财务收入/衍生品利息收入', '/PL/EBIT/PL5100/351012', NULL, 3, '0', '1', '1', '2023-03-01 14:55:04', '1', '2023-03-03 15:58:19');
INSERT INTO `qf_subject_international_info` VALUES ('1630823950911148032', 'PL1', '351007', '股利收入', 'dividends income', '€', '3', '1630823716533440512', 0, '/1630785212050968576/1630822948472492032/1630823716533440512/1630823950911148032', '/财务-利润类/息税前利润/股利收入/股利收入', '/PL/EBIT/PL5200/351007', NULL, 1, '0', '1', '1', '2023-03-01 14:55:04', '1', '2023-03-01 14:55:04');
INSERT INTO `qf_subject_international_info` VALUES ('1630823951578042368', 'PL1', '351011', '利率衍生品公允价值计量变动收益', 'gain from FV measurement of interest derivatives', '€', '3', '1630823717204529152', 0, '/1630785212050968576/1630822948472492032/1630823717204529152/1630823951578042368', '/财务-利润类/息税前利润/利率衍生品公允价值变动收益/利率衍生品公允价值计量变动收益', '/PL/EBIT/PL5300/351011', NULL, 1, '0', '1', '1', '2023-03-01 14:55:04', '1', '2023-03-01 14:55:04');
INSERT INTO `qf_subject_international_info` VALUES ('1630823952265908224', 'PL2', '451001', '附属公司间租赁相关利息费用', 'Interest element of Leasing payments consol. companies', '€', '3', '1630823717833674752', 0, '/1630785212050968576/1630822948472492032/1630823717833674752/1630823952265908224', '/财务-利润类/息税前利润/关联公司利息费用/附属公司间租赁相关利息费用', '/PL/EBIT/PL5500/451001', NULL, 1, '0', '1', '1', '2023-03-01 14:55:04', '1', '2023-03-01 14:55:04');
INSERT INTO `qf_subject_international_info` VALUES ('1630823952907636736', 'PL2', '451002', '附属公司间利息费用', 'interest expenses from consol. comp. all comp.', '€', '3', '1630823717833674752', 0, '/1630785212050968576/1630822948472492032/1630823717833674752/1630823952907636736', '/财务-利润类/息税前利润/关联公司利息费用/附属公司间利息费用', '/PL/EBIT/PL5500/451002', NULL, 2, '0', '1', '1', '2023-03-01 14:55:04', '1', '2023-03-01 14:55:04');
INSERT INTO `qf_subject_international_info` VALUES ('1630823953540976640', 'PL2', '451021', '附属公司间衍生工具利息费用', 'interest expenses of IC derivatives', '€', '3', '1630823717833674752', 0, '/1630785212050968576/1630822948472492032/1630823717833674752/1630823953540976640', '/财务-利润类/息税前利润/关联公司利息费用/附属公司间衍生工具利息费用', '/PL/EBIT/PL5500/451021', NULL, 3, '0', '1', '1', '2023-03-01 14:55:04', '1', '2023-03-01 14:55:04');
INSERT INTO `qf_subject_international_info` VALUES ('1630823954144956416', 'PL2', '451005', '养老金和类似债务的利息支出', 'Interest expenses for pensions and similiar obligations', '€', '3', '1630823718479597568', 0, '/1630785212050968576/1630822948472492032/1630823718479597568/1630823954144956416', '/财务-利润类/息税前利润/财务费用/养老金和类似债务的利息支出', '/PL/EBIT/PL5400/451005', NULL, 1, '0', '1', '1', '2023-03-01 14:55:05', '1', '2023-03-01 14:55:05');
INSERT INTO `qf_subject_international_info` VALUES ('1630823954761519104', 'PL2', '451006', '短期银行贷款利息支出', 'Interest Expenses bank loans short term', '€', '3', '1630823718479597568', 0, '/1630785212050968576/1630822948472492032/1630823718479597568/1630823954761519104', '/财务-利润类/息税前利润/财务费用/短期银行贷款利息支出', '/PL/EBIT/PL5400/451006', NULL, 2, '0', '1', '1', '2023-03-01 14:55:05', '1', '2023-03-01 14:55:05');
INSERT INTO `qf_subject_international_info` VALUES ('1630823955357110272', 'PL2', '451007', '循环银行贷款利息支出', 'Interest bank loan revolving cash facility', '€', '3', '1630823718479597568', 0, '/1630785212050968576/1630822948472492032/1630823718479597568/1630823955357110272', '/财务-利润类/息税前利润/财务费用/循环银行贷款利息支出', '/PL/EBIT/PL5400/451007', NULL, 3, '0', '1', '1', '2023-03-01 14:55:05', '1', '2023-03-01 14:55:05');
INSERT INTO `qf_subject_international_info` VALUES ('1630823956015616000', 'PL2', '451008', '长期银行贷款利息支出', 'Interest Expenses bank loans long term', '€', '3', '1630823718479597568', 0, '/1630785212050968576/1630822948472492032/1630823718479597568/1630823956015616000', '/财务-利润类/息税前利润/财务费用/长期银行贷款利息支出', '/PL/EBIT/PL5400/451008', NULL, 4, '0', '1', '1', '2023-03-01 14:55:05', '1', '2023-03-01 14:55:05');
INSERT INTO `qf_subject_international_info` VALUES ('1630823956636372992', 'PL2', '451013', '租赁利息支出', 'Interest expenses Leasing', '€', '3', '1630823718479597568', 0, '/1630785212050968576/1630822948472492032/1630823718479597568/1630823956636372992', '/财务-利润类/息税前利润/财务费用/租赁利息支出', '/PL/EBIT/PL5400/451013', NULL, 5, '0', '1', '1', '2023-03-01 14:55:05', '1', '2023-03-01 14:55:05');
INSERT INTO `qf_subject_international_info` VALUES ('1630823957269712896', 'PL2', '451014', '保理利息费用', 'Interest expenses from Factoring', '€', '3', '1630823718479597568', 0, '/1630785212050968576/1630822948472492032/1630823718479597568/1630823957269712896', '/财务-利润类/息税前利润/财务费用/保理利息费用', '/PL/EBIT/PL5400/451014', NULL, 6, '0', '1', '1', '2023-03-01 14:55:05', '1', '2023-03-01 14:55:05');
INSERT INTO `qf_subject_international_info` VALUES ('1630823957852721152', 'PL2', '451015', '掉期利息费用', 'Interest Expenses for swap', '€', '3', '1630823718479597568', 0, '/1630785212050968576/1630822948472492032/1630823718479597568/1630823957852721152', '/财务-利润类/息税前利润/财务费用/掉期利息费用', '/PL/EBIT/PL5400/451015', NULL, 7, '0', '1', '1', '2023-03-01 14:55:06', '1', '2023-03-01 14:55:06');
INSERT INTO `qf_subject_international_info` VALUES ('1630823958553169920', 'PL2', '451016', '其他利息费用', 'Other Interests', '€', '3', '1630823718479597568', 0, '/1630785212050968576/1630822948472492032/1630823718479597568/1630823958553169920', '/财务-利润类/息税前利润/财务费用/其他利息费用', '/PL/EBIT/PL5400/451016', NULL, 8, '0', '1', '1', '2023-03-01 14:55:06', '1', '2023-03-01 14:55:06');
INSERT INTO `qf_subject_international_info` VALUES ('1630823959161344000', 'PL2', '451017', '担保佣金', 'Guarantee commissions', '€', '3', '1630823718479597568', 0, '/1630785212050968576/1630822948472492032/1630823718479597568/1630823959161344000', '/财务-利润类/息税前利润/财务费用/担保佣金', '/PL/EBIT/PL5400/451017', NULL, 9, '0', '1', '1', '2023-03-01 14:55:06', '1', '2023-03-01 14:55:06');
INSERT INTO `qf_subject_international_info` VALUES ('1630823959769518080', 'PL2', '451018', '退税利息费用', 'Interest expenses for tax back duty', '€', '3', '1630823718479597568', 0, '/1630785212050968576/1630822948472492032/1630823718479597568/1630823959769518080', '/财务-利润类/息税前利润/财务费用/退税利息费用', '/PL/EBIT/PL5400/451018', NULL, 10, '0', '1', '1', '2023-03-01 14:55:06', '1', '2023-03-01 14:55:06');
INSERT INTO `qf_subject_international_info` VALUES ('1630823960386080768', 'PL2', '451020', '衍生品利息费用', 'Interest expenses for derivatives', '€', '3', '1630823718479597568', 0, '/1630785212050968576/1630822948472492032/1630823718479597568/1630823960386080768', '/财务-利润类/息税前利润/财务费用/衍生品利息费用', '/PL/EBIT/PL5400/451020', NULL, 11, '0', '1', '1', '2023-03-01 14:55:06', '1', '2023-03-01 14:55:06');
INSERT INTO `qf_subject_international_info` VALUES ('1630823961011032064', 'PL2', '451022', '利息费用-租赁负债', 'interest expense -  right of use', '€', '3', '1630823718479597568', 0, '/1630785212050968576/1630822948472492032/1630823718479597568/1630823961011032064', '/财务-利润类/息税前利润/财务费用/利息费用-租赁负债', '/PL/EBIT/PL5400/451022', NULL, 12, '0', '1', '1', '2023-03-01 14:55:06', '1', '2023-03-01 14:55:06');
INSERT INTO `qf_subject_international_info` VALUES ('1630823961606623232', 'PL2', '451019', '利率衍生品公允价值计量变动损失', 'loss from FV measurement of interest derivatives', '€', '3', '1630823719180046336', 0, '/1630785212050968576/1630822948472492032/1630823719180046336/1630823961606623232', '/财务-利润类/息税前利润/利率衍生品公允价值变动损失/利率衍生品公允价值计量变动损失', '/PL/EBIT/PL5600/451019', NULL, 1, '0', '1', '1', '2023-03-01 14:55:06', '1', '2023-03-01 14:55:06');
INSERT INTO `qf_subject_international_info` VALUES ('1630823962218991616', 'PL2', '346010', '联营公司其他投资收益/损失', 'other income investments in associates', '€', '3', '1630823719813386240', 0, '/1630785212050968576/1630822948472492032/1630823719813386240/1630823962218991616', '/财务-利润类/息税前利润/投资收益/损失/联营公司其他投资收益/损失', '/PL/EBIT/PL5700/346010', NULL, 1, '0', '1', '1', '2023-03-01 14:55:07', '1', '2023-03-01 14:55:07');
INSERT INTO `qf_subject_international_info` VALUES ('1630823962822971392', 'PL2', '471001', '当地交易税', 'local trade tax', '€', '3', '1630823720438337536', 0, '/1630785212050968576/1630822949101637632/1630823720438337536/1630823962822971392', '/财务-利润类/利润总额/所得税/当地交易税', '/PL/PL5800/PL5900/471001', NULL, 1, '0', '1', '1', '2023-03-01 14:55:07', '1', '2023-03-01 14:55:07');
INSERT INTO `qf_subject_international_info` VALUES ('1630823963456311296', 'PL2', '471002', '公司/联邦税、团结税', 'corporate/federal tax, solidarity tax contribution', '€', '3', '1630823720438337536', 0, '/1630785212050968576/1630822949101637632/1630823720438337536/1630823963456311296', '/财务-利润类/利润总额/所得税/公司/联邦税、团结税', '/PL/PL5800/PL5900/471002', NULL, 2, '0', '1', '1', '2023-03-01 14:55:07', '1', '2023-03-01 14:55:07');
INSERT INTO `qf_subject_international_info` VALUES ('1630823964135788544', 'PL2', '471003', '预提所得税', 'withholding tax', '€', '3', '1630823720438337536', 0, '/1630785212050968576/1630822949101637632/1630823720438337536/1630823964135788544', '/财务-利润类/利润总额/所得税/预提所得税', '/PL/PL5800/PL5900/471003', NULL, 3, '0', '1', '1', '2023-03-01 14:55:07', '1', '2023-03-01 14:55:07');
INSERT INTO `qf_subject_international_info` VALUES ('1630823964760739840', 'PL2', '472001', '暂时性差异递延税', 'deferred taxes on temporary differences', '€', '3', '1630823720438337536', 0, '/1630785212050968576/1630822949101637632/1630823720438337536/1630823964760739840', '/财务-利润类/利润总额/所得税/暂时性差异递延税', '/PL/PL5800/PL5900/472001', NULL, 4, '0', '1', '1', '2023-03-01 14:55:07', '1', '2023-03-01 14:55:07');
INSERT INTO `qf_subject_international_info` VALUES ('1630823965364719616', 'PL2', '481001', '利润转移协议', 'P+L Transfer Agreement', '€', '3', '1630823721075871744', 0, '/1630785212050968576/1630822949101637632/1630823721075871744/1630823965364719616', '/财务-利润类/利润总额/利润转移协议/利润转移协议', '/PL/PL5800/480000/481001', NULL, 1, '0', '1', '1', '2023-03-01 14:55:07', '1', '2023-03-01 14:55:07');
INSERT INTO `qf_subject_international_info` VALUES ('1630823966002253824', 'PL3', '900100', '少数股东损益', 'minority interests', '€', '3', '1630823722422243328', 1, '/1630785212050968576/1630822949776920576/1630823722422243328/1630823966002253824', '/财务-利润类/净利润/归属于非控制性权益的净利润/少数股东损益', '/PL/900000/PL8200/900100', NULL, 1, '0', '1', '1', '2023-03-01 14:55:07', '1', '2023-03-01 14:55:41');
INSERT INTO `qf_subject_international_info` VALUES ('1630824037024403456', 'PL1', '312013', '型材废品收入', 'sales profile waste', '€', '4', '1630823837677522944', 0, '/1630785212050968576/1630822946622803968/1630823704491593728/1630823837677522944/1630824037024403456', '/财务-利润类/销售收入/其他营业收入/其他营业收入-管理类/型材废品收入', '/PL/PL3300S/PL3400/PL3410/312013', NULL, 1, '0', '1', '1', '2023-03-01 14:55:24', '1', '2023-03-01 14:55:24');
INSERT INTO `qf_subject_international_info` VALUES ('1630824037670326272', 'PL1', '312015', '再收费运费收入', 'income recharged freight costs', '€', '4', '1630823837677522944', 0, '/1630785212050968576/1630822946622803968/1630823704491593728/1630823837677522944/1630824037670326272', '/财务-利润类/销售收入/其他营业收入/其他营业收入-管理类/再收费运费收入', '/PL/PL3300S/PL3400/PL3410/312015', NULL, 2, '0', '1', '1', '2023-03-01 14:55:25', '1', '2023-03-01 14:55:25');
INSERT INTO `qf_subject_international_info` VALUES ('1630824038307860480', 'PL1', '342004', '冲回其他准备金收入', 'Income from release of other reserves', '€', '4', '1630823837677522944', 0, '/1630785212050968576/1630822946622803968/1630823704491593728/1630823837677522944/1630824038307860480', '/财务-利润类/销售收入/其他营业收入/其他营业收入-管理类/冲回其他准备金收入', '/PL/PL3300S/PL3400/PL3410/342004', NULL, 3, '0', '1', '1', '2023-03-01 14:55:25', '1', '2023-03-01 14:55:25');
INSERT INTO `qf_subject_international_info` VALUES ('1630824038937006080', 'PL1', '343001', '从津贴中扣除的重新分类冲销收入', 'Income out of reclass write offs charged against the allowance', '€', '4', '1630823837677522944', 0, '/1630785212050968576/1630822946622803968/1630823704491593728/1630823837677522944/1630824038937006080', '/财务-利润类/销售收入/其他营业收入/其他营业收入-管理类/从津贴中扣除的重新分类冲销收入', '/PL/PL3300S/PL3400/PL3410/343001', NULL, 4, '0', '1', '1', '2023-03-01 14:55:25', '1', '2023-03-01 14:55:25');
INSERT INTO `qf_subject_international_info` VALUES ('1630824039587123200', 'PL1', '343002', '从坏账准备中重分类的收入', 'Income reclass from allowance for bad debts', '€', '4', '1630823837677522944', 0, '/1630785212050968576/1630822946622803968/1630823704491593728/1630823837677522944/1630824039587123200', '/财务-利润类/销售收入/其他营业收入/其他营业收入-管理类/从坏账准备中重分类的收入', '/PL/PL3300S/PL3400/PL3410/343002', NULL, 5, '0', '1', '1', '2023-03-01 14:55:25', '1', '2023-03-01 14:55:25');
INSERT INTO `qf_subject_international_info` VALUES ('1630824040228851712', 'PL1', '346001', '工资/薪金报销', 'reimbursement of wages/salary', '€', '4', '1630823837677522944', 0, '/1630785212050968576/1630822946622803968/1630823704491593728/1630823837677522944/1630824040228851712', '/财务-利润类/销售收入/其他营业收入/其他营业收入-管理类/工资/薪金报销', '/PL/PL3300S/PL3400/PL3410/346001', NULL, 6, '0', '1', '1', '2023-03-01 14:55:25', '1', '2023-03-01 14:55:25');
INSERT INTO `qf_subject_international_info` VALUES ('1630824040845414400', 'PL1', '346002', '员工保险报销收入', 'Income from insurance reimbursement sickness employees', '€', '4', '1630823837677522944', 0, '/1630785212050968576/1630822946622803968/1630823704491593728/1630823837677522944/1630824040845414400', '/财务-利润类/销售收入/其他营业收入/其他营业收入-管理类/员工保险报销收入', '/PL/PL3300S/PL3400/PL3410/346002', NULL, 7, '0', '1', '1', '2023-03-01 14:55:25', '1', '2023-03-01 14:55:25');
INSERT INTO `qf_subject_international_info` VALUES ('1630824041604583424', 'PL1', '346003', '废金属收入', 'income scrap metal', '€', '4', '1630823837677522944', 0, '/1630785212050968576/1630822946622803968/1630823704491593728/1630823837677522944/1630824041604583424', '/财务-利润类/销售收入/其他营业收入/其他营业收入-管理类/废金属收入', '/PL/PL3300S/PL3400/PL3410/346003', NULL, 8, '0', '1', '1', '2023-03-01 14:55:25', '1', '2023-03-01 14:55:25');
INSERT INTO `qf_subject_international_info` VALUES ('1630824042212757504', 'PL1', '346005', '非现金福利', 'non cash benefit', '€', '4', '1630823837677522944', 0, '/1630785212050968576/1630822946622803968/1630823704491593728/1630823837677522944/1630824042212757504', '/财务-利润类/销售收入/其他营业收入/其他营业收入-管理类/非现金福利', '/PL/PL3300S/PL3400/PL3410/346005', NULL, 9, '0', '1', '1', '2023-03-01 14:55:26', '1', '2023-03-01 14:55:26');
INSERT INTO `qf_subject_international_info` VALUES ('1630824042850291712', 'PL1', '346006', '租金收入', 'income rent received', '€', '4', '1630823837677522944', 0, '/1630785212050968576/1630822946622803968/1630823704491593728/1630823837677522944/1630824042850291712', '/财务-利润类/销售收入/其他营业收入/其他营业收入-管理类/租金收入', '/PL/PL3300S/PL3400/PL3410/346006', NULL, 10, '0', '1', '1', '2023-03-01 14:55:26', '1', '2023-03-01 14:55:26');
INSERT INTO `qf_subject_international_info` VALUES ('1630824043479437312', 'PL1', '346007', '国内其他收入', 'other income domestic', '€', '4', '1630823837677522944', 0, '/1630785212050968576/1630822946622803968/1630823704491593728/1630823837677522944/1630824043479437312', '/财务-利润类/销售收入/其他营业收入/其他营业收入-管理类/国内其他收入', '/PL/PL3300S/PL3400/PL3410/346007', NULL, 11, '0', '1', '1', '2023-03-01 14:55:26', '1', '2023-03-01 14:55:26');
INSERT INTO `qf_subject_international_info` VALUES ('1630824044297326592', 'PL1', '346008', '欧盟其他收入', 'other income European Union (EU)', '€', '4', '1630823837677522944', 0, '/1630785212050968576/1630822946622803968/1630823704491593728/1630823837677522944/1630824044297326592', '/财务-利润类/销售收入/其他营业收入/其他营业收入-管理类/欧盟其他收入', '/PL/PL3300S/PL3400/PL3410/346008', NULL, 12, '0', '1', '1', '2023-03-01 14:55:26', '1', '2023-03-01 14:55:26');
INSERT INTO `qf_subject_international_info` VALUES ('1630824044955832320', 'PL1', '346009', '第三国其他收入', 'other income third country', '€', '4', '1630823837677522944', 0, '/1630785212050968576/1630822946622803968/1630823704491593728/1630823837677522944/1630824044955832320', '/财务-利润类/销售收入/其他营业收入/其他营业收入-管理类/第三国其他收入', '/PL/PL3300S/PL3400/PL3410/346009', NULL, 13, '0', '1', '1', '2023-03-01 14:55:26', '1', '2023-03-01 14:55:26');
INSERT INTO `qf_subject_international_info` VALUES ('1630824045568200704', 'PL1', '346011', '其他保险损失收入', 'income insured loss other', '€', '4', '1630823837677522944', 0, '/1630785212050968576/1630822946622803968/1630823704491593728/1630823837677522944/1630824045568200704', '/财务-利润类/销售收入/其他营业收入/其他营业收入-管理类/其他保险损失收入', '/PL/PL3300S/PL3400/PL3410/346011', NULL, 14, '0', '1', '1', '2023-03-01 14:55:26', '1', '2023-03-01 14:55:26');
INSERT INTO `qf_subject_international_info` VALUES ('1630824046188957696', 'PL1', '344001', '已实现的汇兑收益-经营业务', 'exchange gains realized - operational business', '€', '4', '1630823838289891328', 0, '/1630785212050968576/1630822946622803968/1630823704491593728/1630823838289891328/1630824046188957696', '/财务-利润类/销售收入/其他营业收入/其他营业收入-财务类/已实现的汇兑收益-经营业务', '/PL/PL3300S/PL3400/PL3420/344001', NULL, 1, '0', '1', '1', '2023-03-01 14:55:27', '1', '2023-03-01 14:55:27');
INSERT INTO `qf_subject_international_info` VALUES ('1630824046830686208', 'PL1', '344002', '已实现的汇兑收益-资金交易', 'exchange gains realized from treasury transactions', '€', '4', '1630823838289891328', 0, '/1630785212050968576/1630822946622803968/1630823704491593728/1630823838289891328/1630824046830686208', '/财务-利润类/销售收入/其他营业收入/其他营业收入-财务类/已实现的汇兑收益-资金交易', '/PL/PL3300S/PL3400/PL3420/344002', NULL, 2, '0', '1', '1', '2023-03-01 14:55:27', '1', '2023-03-01 14:55:27');
INSERT INTO `qf_subject_international_info` VALUES ('1630824047468220416', 'PL1', '344003', '未实现的汇兑损益', 'exchange gains unrealized', '€', '4', '1630823838289891328', 0, '/1630785212050968576/1630822946622803968/1630823704491593728/1630823838289891328/1630824047468220416', '/财务-利润类/销售收入/其他营业收入/其他营业收入-财务类/未实现的汇兑损益', '/PL/PL3300S/PL3400/PL3420/344003', NULL, 3, '0', '1', '1', '2023-03-01 14:55:27', '1', '2023-03-01 14:55:27');
INSERT INTO `qf_subject_international_info` VALUES ('1630824048101560320', 'PL1', '341001', '固定资产处置和金融资产收入', 'Income from disposal of PPE and financial assets', '€', '4', '1630823838977757184', 0, '/1630785212050968576/1630822946622803968/1630823704491593728/1630823838977757184/1630824048101560320', '/财务-利润类/销售收入/其他营业收入/其他营业收入-非经营性/固定资产处置和金融资产收入', '/PL/PL3300S/PL3400/PL3430/341001', NULL, 1, '0', '1', '1', '2023-03-01 14:55:27', '1', '2023-03-01 14:55:27');
INSERT INTO `qf_subject_international_info` VALUES ('1630824048764260352', 'PL1', '341002', '资产处置（账面利润）', 'Asset disposals (at book profit- NBV)', '€', '4', '1630823838977757184', 0, '/1630785212050968576/1630822946622803968/1630823704491593728/1630823838977757184/1630824048764260352', '/财务-利润类/销售收入/其他营业收入/其他营业收入-非经营性/资产处置（账面利润）', '/PL/PL3300S/PL3400/PL3430/341002', NULL, 2, '0', '1', '1', '2023-03-01 14:55:27', '1', '2023-03-01 14:55:27');
INSERT INTO `qf_subject_international_info` VALUES ('1630824049368240128', 'PL1', '341005', '租赁资产处置收入', 'revenues from disposal of leased assets', '€', '4', '1630823838977757184', 0, '/1630785212050968576/1630822946622803968/1630823704491593728/1630823838977757184/1630824049368240128', '/财务-利润类/销售收入/其他营业收入/其他营业收入-非经营性/租赁资产处置收入', '/PL/PL3300S/PL3400/PL3430/341005', NULL, 3, '0', '1', '1', '2023-03-01 14:55:27', '1', '2023-03-01 14:55:27');
INSERT INTO `qf_subject_international_info` VALUES ('1630824049980608512', 'PL1', '345002', '其他杂项补助', 'sundry other grant', '€', '4', '1630823838977757184', 0, '/1630785212050968576/1630822946622803968/1630823704491593728/1630823838977757184/1630824049980608512', '/财务-利润类/销售收入/其他营业收入/其他营业收入-非经营性/其他杂项补助', '/PL/PL3300S/PL3400/PL3430/345002', NULL, 4, '0', '1', '1', '2023-03-01 14:55:27', '1', '2023-03-01 14:55:27');
INSERT INTO `qf_subject_international_info` VALUES ('1630824050588782592', 'PL1', '345003', '就业中心为退休/教育等提供的补助金', 'grands from employment centre for retirement/education etc.', '€', '4', '1630823838977757184', 0, '/1630785212050968576/1630822946622803968/1630823704491593728/1630823838977757184/1630824050588782592', '/财务-利润类/销售收入/其他营业收入/其他营业收入-非经营性/就业中心为退休/教育等提供的补助金', '/PL/PL3300S/PL3400/PL3430/345003', NULL, 5, '0', '1', '1', '2023-03-01 14:55:28', '1', '2023-03-01 14:55:28');
INSERT INTO `qf_subject_international_info` VALUES ('1630824051196956672', 'PL1', '345004', '与固定资产相关的补助', 'grants releated to fixed assets', '€', '4', '1630823838977757184', 0, '/1630785212050968576/1630822946622803968/1630823704491593728/1630823838977757184/1630824051196956672', '/财务-利润类/销售收入/其他营业收入/其他营业收入-非经营性/与固定资产相关的补助', '/PL/PL3300S/PL3400/PL3430/345004', NULL, 6, '0', '1', '1', '2023-03-01 14:55:28', '1', '2023-03-01 14:55:28');
INSERT INTO `qf_subject_international_info` VALUES ('1630824051796742144', 'PL2', '440202', '租赁/租金支付', 'lease/rental payments', '€', '4', '1630823927897001984', 0, '/1630785212050968576/1630822946622803968/1630823709545730048/1630823927897001984/1630824051796742144', '/财务-利润类/销售收入/人工费用/其他经营费用——主要业务支出/租赁/租金支付', '/PL/PL3300S/PL4200/PL4610/440202', NULL, 1, '0', '1', '1', '2023-03-01 14:55:28', '1', '2023-03-01 14:55:28');
INSERT INTO `qf_subject_international_info` VALUES ('1630824052455247872', 'PL2', '440301', '其他外部服务', 'miscellaneous external services', '€', '4', '1630823927897001984', 0, '/1630785212050968576/1630822946622803968/1630823709545730048/1630823927897001984/1630824052455247872', '/财务-利润类/销售收入/人工费用/其他经营费用——主要业务支出/其他外部服务', '/PL/PL3300S/PL4200/PL4610/440301', NULL, 2, '0', '1', '1', '2023-03-01 14:55:28', '1', '2023-03-01 14:55:28');
INSERT INTO `qf_subject_international_info` VALUES ('1630824053998751744', 'PL2', '440302', '维护生产的外部服务', 'external services for maintenance production', '€', '4', '1630823927897001984', 0, '/1630785212050968576/1630822946622803968/1630823709545730048/1630823927897001984/1630824053998751744', '/财务-利润类/销售收入/人工费用/其他经营费用——主要业务支出/维护生产的外部服务', '/PL/PL3300S/PL4200/PL4610/440302', NULL, 3, '0', '1', '1', '2023-03-01 14:55:28', '1', '2023-03-01 14:55:28');
INSERT INTO `qf_subject_international_info` VALUES ('1630824054678228992', 'PL2', '440303', '维护管理的外部服务', 'external services for maintenance administration', '€', '4', '1630823927897001984', 0, '/1630785212050968576/1630822946622803968/1630823709545730048/1630823927897001984/1630824054678228992', '/财务-利润类/销售收入/人工费用/其他经营费用——主要业务支出/维护管理的外部服务', '/PL/PL3300S/PL4200/PL4610/440303', NULL, 4, '0', '1', '1', '2023-03-01 14:55:29', '1', '2023-03-01 14:55:29');
INSERT INTO `qf_subject_international_info` VALUES ('1630824055307374592', 'PL2', '440304', '第三方/外部物流费用', 'logistic expenses third parties/external', '€', '4', '1630823927897001984', 0, '/1630785212050968576/1630822946622803968/1630823709545730048/1630823927897001984/1630824055307374592', '/财务-利润类/销售收入/人工费用/其他经营费用——主要业务支出/第三方/外部物流费用', '/PL/PL3300S/PL4200/PL4610/440304', NULL, 5, '0', '1', '1', '2023-03-01 14:55:29', '1', '2023-03-01 14:55:29');
INSERT INTO `qf_subject_international_info` VALUES ('1630824056850878464', 'PL2', '440305', '维护IT的外部服务', 'external services for maintenance IT', '€', '4', '1630823927897001984', 0, '/1630785212050968576/1630822946622803968/1630823709545730048/1630823927897001984/1630824056850878464', '/财务-利润类/销售收入/人工费用/其他经营费用——主要业务支出/维护IT的外部服务', '/PL/PL3300S/PL4200/PL4610/440305', NULL, 6, '0', '1', '1', '2023-03-01 14:55:29', '1', '2023-03-01 14:55:29');
INSERT INTO `qf_subject_international_info` VALUES ('1630824057517772800', 'PL2', '440307', '外部服务数据处理项目', 'external services data processing projects', '€', '4', '1630823927897001984', 0, '/1630785212050968576/1630822946622803968/1630823709545730048/1630823927897001984/1630824057517772800', '/财务-利润类/销售收入/人工费用/其他经营费用——主要业务支出/外部服务数据处理项目', '/PL/PL3300S/PL4200/PL4610/440307', NULL, 7, '0', '1', '1', '2023-03-01 14:55:29', '1', '2023-03-01 14:55:29');
INSERT INTO `qf_subject_international_info` VALUES ('1630824058121752576', 'PL2', '440308', '外部服务用户费用IT', 'external services user fees IT', '€', '4', '1630823927897001984', 0, '/1630785212050968576/1630822946622803968/1630823709545730048/1630823927897001984/1630824058121752576', '/财务-利润类/销售收入/人工费用/其他经营费用——主要业务支出/外部服务用户费用IT', '/PL/PL3300S/PL4200/PL4610/440308', NULL, 8, '0', '1', '1', '2023-03-01 14:55:29', '1', '2023-03-01 14:55:29');
INSERT INTO `qf_subject_international_info` VALUES ('1630824058746703872', 'PL2', '440309', '外部服务互联网费用', 'external services internet fees', '€', '4', '1630823927897001984', 0, '/1630785212050968576/1630822946622803968/1630823709545730048/1630823927897001984/1630824058746703872', '/财务-利润类/销售收入/人工费用/其他经营费用——主要业务支出/外部服务互联网费用', '/PL/PL3300S/PL4200/PL4610/440309', NULL, 9, '0', '1', '1', '2023-03-01 14:55:30', '1', '2023-03-01 14:55:30');
INSERT INTO `qf_subject_international_info` VALUES ('1630824059526844416', 'PL2', '440501', '火灾保险', 'fire insurance', '€', '4', '1630823927897001984', 0, '/1630785212050968576/1630822946622803968/1630823709545730048/1630823927897001984/1630824059526844416', '/财务-利润类/销售收入/人工费用/其他经营费用——主要业务支出/火灾保险', '/PL/PL3300S/PL4200/PL4610/440501', NULL, 10, '0', '1', '1', '2023-03-01 14:55:30', '1', '2023-03-01 14:55:30');
INSERT INTO `qf_subject_international_info` VALUES ('1630824060139212800', 'PL2', '440502', '经营保险', 'operating insurance', '€', '4', '1630823927897001984', 0, '/1630785212050968576/1630822946622803968/1630823709545730048/1630823927897001984/1630824060139212800', '/财务-利润类/销售收入/人工费用/其他经营费用——主要业务支出/经营保险', '/PL/PL3300S/PL4200/PL4610/440502', NULL, 11, '0', '1', '1', '2023-03-01 14:55:30', '1', '2023-03-01 14:55:30');
INSERT INTO `qf_subject_international_info` VALUES ('1630824060768358400', 'PL2', '440503', '机动车辆保险', 'motor vehicle insurance', '€', '4', '1630823927897001984', 0, '/1630785212050968576/1630822946622803968/1630823709545730048/1630823927897001984/1630824060768358400', '/财务-利润类/销售收入/人工费用/其他经营费用——主要业务支出/机动车辆保险', '/PL/PL3300S/PL4200/PL4610/440503', NULL, 12, '0', '1', '1', '2023-03-01 14:55:30', '1', '2023-03-01 14:55:30');
INSERT INTO `qf_subject_international_info` VALUES ('1630824061582053376', 'PL2', '440504', '业务中断保险', 'business interrupt insurance', '€', '4', '1630823927897001984', 0, '/1630785212050968576/1630822946622803968/1630823709545730048/1630823927897001984/1630824061582053376', '/财务-利润类/销售收入/人工费用/其他经营费用——主要业务支出/业务中断保险', '/PL/PL3300S/PL4200/PL4610/440504', NULL, 13, '0', '1', '1', '2023-03-01 14:55:30', '1', '2023-03-01 14:55:30');
INSERT INTO `qf_subject_international_info` VALUES ('1630824062202810368', 'PL2', '440505', '贸易信用保险', 'trade credit insurance', '€', '4', '1630823927897001984', 0, '/1630785212050968576/1630822946622803968/1630823709545730048/1630823927897001984/1630824062202810368', '/财务-利润类/销售收入/人工费用/其他经营费用——主要业务支出/贸易信用保险', '/PL/PL3300S/PL4200/PL4610/440505', NULL, 14, '0', '1', '1', '2023-03-01 14:55:30', '1', '2023-03-01 14:55:30');
INSERT INTO `qf_subject_international_info` VALUES ('1630824062882287616', 'PL2', '440506', '其他保险', 'miscellaneous insurances', '€', '4', '1630823927897001984', 0, '/1630785212050968576/1630822946622803968/1630823709545730048/1630823927897001984/1630824062882287616', '/财务-利润类/销售收入/人工费用/其他经营费用——主要业务支出/其他保险', '/PL/PL3300S/PL4200/PL4610/440506', NULL, 15, '0', '1', '1', '2023-03-01 14:55:31', '1', '2023-03-01 14:55:31');
INSERT INTO `qf_subject_international_info` VALUES ('1630824063503044608', 'PL2', '440601', '杂项交通津贴', 'miscellaneous transport allowance', '€', '4', '1630823927897001984', 0, '/1630785212050968576/1630822946622803968/1630823709545730048/1630823927897001984/1630824063503044608', '/财务-利润类/销售收入/人工费用/其他经营费用——主要业务支出/杂项交通津贴', '/PL/PL3300S/PL4200/PL4610/440601', NULL, 16, '0', '1', '1', '2023-03-01 14:55:31', '1', '2023-03-01 14:55:31');
INSERT INTO `qf_subject_international_info` VALUES ('1630824064157356032', 'PL2', '440603', '杂项社会福利和发放津贴', 'miscellaneous social benefits and granted allowance', '€', '4', '1630823927897001984', 0, '/1630785212050968576/1630822946622803968/1630823709545730048/1630823927897001984/1630824064157356032', '/财务-利润类/销售收入/人工费用/其他经营费用——主要业务支出/杂项社会福利和发放津贴', '/PL/PL3300S/PL4200/PL4610/440603', NULL, 17, '0', '1', '1', '2023-03-01 14:55:31', '1', '2023-03-01 14:55:31');
INSERT INTO `qf_subject_international_info` VALUES ('1630824064824250368', 'PL2', '440605', '高级培训和继续教育费用', 'fees for advanced training and continuing education', '€', '4', '1630823927897001984', 0, '/1630785212050968576/1630822946622803968/1630823709545730048/1630823927897001984/1630824064824250368', '/财务-利润类/销售收入/人工费用/其他经营费用——主要业务支出/高级培训和继续教育费用', '/PL/PL3300S/PL4200/PL4610/440605', NULL, 18, '0', '1', '1', '2023-03-01 14:55:31', '1', '2023-03-01 14:55:31');
INSERT INTO `qf_subject_international_info` VALUES ('1630824065482756096', 'PL2', '440606', '医疗物资', 'medical supplies', '€', '4', '1630823927897001984', 0, '/1630785212050968576/1630822946622803968/1630823709545730048/1630823927897001984/1630824065482756096', '/财务-利润类/销售收入/人工费用/其他经营费用——主要业务支出/医疗物资', '/PL/PL3300S/PL4200/PL4610/440606', NULL, 19, '0', '1', '1', '2023-03-01 14:55:31', '1', '2023-03-01 14:55:31');
INSERT INTO `qf_subject_international_info` VALUES ('1630824066099318784', 'PL2', '440701', '差旅费', 'travelling expenses', '€', '4', '1630823927897001984', 0, '/1630785212050968576/1630822946622803968/1630823709545730048/1630823927897001984/1630824066099318784', '/财务-利润类/销售收入/人工费用/其他经营费用——主要业务支出/差旅费', '/PL/PL3300S/PL4200/PL4610/440701', NULL, 20, '0', '1', '1', '2023-03-01 14:55:31', '1', '2023-03-01 14:55:31');
INSERT INTO `qf_subject_international_info` VALUES ('1630824066715881472', 'PL2', '440702', '机动车辆费用', 'motor vehicle expenses', '€', '4', '1630823927897001984', 0, '/1630785212050968576/1630822946622803968/1630823709545730048/1630823927897001984/1630824066715881472', '/财务-利润类/销售收入/人工费用/其他经营费用——主要业务支出/机动车辆费用', '/PL/PL3300S/PL4200/PL4610/440702', NULL, 21, '0', '1', '1', '2023-03-01 14:55:31', '1', '2023-03-01 14:55:31');
INSERT INTO `qf_subject_international_info` VALUES ('1630824067307278336', 'PL2', '440703', '工作面试费用', 'expenses for job interviews', '€', '4', '1630823927897001984', 0, '/1630785212050968576/1630822946622803968/1630823709545730048/1630823927897001984/1630824067307278336', '/财务-利润类/销售收入/人工费用/其他经营费用——主要业务支出/工作面试费用', '/PL/PL3300S/PL4200/PL4610/440703', NULL, 22, '0', '1', '1', '2023-03-01 14:55:32', '1', '2023-03-01 14:55:32');
INSERT INTO `qf_subject_international_info` VALUES ('1630824068120973312', 'PL2', '440704', '私家车里程津贴', 'mileage allowance for private owned vehicles', '€', '4', '1630823927897001984', 0, '/1630785212050968576/1630822946622803968/1630823709545730048/1630823927897001984/1630824068120973312', '/财务-利润类/销售收入/人工费用/其他经营费用——主要业务支出/私家车里程津贴', '/PL/PL3300S/PL4200/PL4610/440704', NULL, 23, '0', '1', '1', '2023-03-01 14:55:32', '1', '2023-03-01 14:55:32');
INSERT INTO `qf_subject_international_info` VALUES ('1630824068771090432', 'PL2', '441006', '杂项费用', 'miscellaneous expenses', '€', '4', '1630823927897001984', 0, '/1630785212050968576/1630822946622803968/1630823709545730048/1630823927897001984/1630824068771090432', '/财务-利润类/销售收入/人工费用/其他经营费用——主要业务支出/杂项费用', '/PL/PL3300S/PL4200/PL4610/441006', NULL, 24, '0', '1', '1', '2023-03-01 14:55:32', '1', '2023-03-01 14:55:32');
INSERT INTO `qf_subject_international_info` VALUES ('1630824069412818944', 'PL2', '441021', '安全巡逻', 'security patrol', '€', '4', '1630823927897001984', 0, '/1630785212050968576/1630822946622803968/1630823709545730048/1630823927897001984/1630824069412818944', '/财务-利润类/销售收入/人工费用/其他经营费用——主要业务支出/安全巡逻', '/PL/PL3300S/PL4200/PL4610/441021', NULL, 25, '0', '1', '1', '2023-03-01 14:55:32', '1', '2023-03-01 14:55:32');
INSERT INTO `qf_subject_international_info` VALUES ('1630824070566252544', 'PL2', '441102', '实验室材料和测试成本', 'laboratory material and costs for tests', '€', '4', '1630823927897001984', 0, '/1630785212050968576/1630822946622803968/1630823709545730048/1630823927897001984/1630824070566252544', '/财务-利润类/销售收入/人工费用/其他经营费用——主要业务支出/实验室材料和测试成本', '/PL/PL3300S/PL4200/PL4610/441102', NULL, 26, '0', '1', '1', '2023-03-01 14:55:32', '1', '2023-03-01 14:55:32');
INSERT INTO `qf_subject_international_info` VALUES ('1630824071426084864', 'PL2', '441103', '实验室试验用原材料样品', 'samples of raw material for laboratory tests', '€', '4', '1630823927897001984', 0, '/1630785212050968576/1630822946622803968/1630823709545730048/1630823927897001984/1630824071426084864', '/财务-利润类/销售收入/人工费用/其他经营费用——主要业务支出/实验室试验用原材料样品', '/PL/PL3300S/PL4200/PL4610/441103', NULL, 27, '0', '1', '1', '2023-03-01 14:55:33', '1', '2023-03-01 14:55:33');
INSERT INTO `qf_subject_international_info` VALUES ('1630824072055230464', 'PL2', '441104', '工作服', 'working clothes', '€', '4', '1630823927897001984', 0, '/1630785212050968576/1630822946622803968/1630823709545730048/1630823927897001984/1630824072055230464', '/财务-利润类/销售收入/人工费用/其他经营费用——主要业务支出/工作服', '/PL/PL3300S/PL4200/PL4610/441104', NULL, 28, '0', '1', '1', '2023-03-01 14:55:33', '1', '2023-03-01 14:55:33');
INSERT INTO `qf_subject_international_info` VALUES ('1630824072692764672', 'PL2', '441105', '清洁费用', 'cleaning costs', '€', '4', '1630823927897001984', 0, '/1630785212050968576/1630822946622803968/1630823709545730048/1630823927897001984/1630824072692764672', '/财务-利润类/销售收入/人工费用/其他经营费用——主要业务支出/清洁费用', '/PL/PL3300S/PL4200/PL4610/441105', NULL, 29, '0', '1', '1', '2023-03-01 14:55:33', '1', '2023-03-01 14:55:33');
INSERT INTO `qf_subject_international_info` VALUES ('1630824073397407744', 'PL2', '441107', '特许权使用费', 'royalties', '€', '4', '1630823927897001984', 0, '/1630785212050968576/1630822946622803968/1630823709545730048/1630823927897001984/1630824073397407744', '/财务-利润类/销售收入/人工费用/其他经营费用——主要业务支出/特许权使用费', '/PL/PL3300S/PL4200/PL4610/441107', NULL, 30, '0', '1', '1', '2023-03-01 14:55:33', '1', '2023-03-01 14:55:33');
INSERT INTO `qf_subject_international_info` VALUES ('1630824074043330560', 'PL2', '441108', '专利费', 'patent', '€', '4', '1630823927897001984', 0, '/1630785212050968576/1630822946622803968/1630823709545730048/1630823927897001984/1630824074043330560', '/财务-利润类/销售收入/人工费用/其他经营费用——主要业务支出/专利费', '/PL/PL3300S/PL4200/PL4610/441108', NULL, 31, '0', '1', '1', '2023-03-01 14:55:33', '1', '2023-03-01 14:55:33');
INSERT INTO `qf_subject_international_info` VALUES ('1630824074718613504', 'PL2', '441109', '消防费用', 'expenses fire protection', '€', '4', '1630823927897001984', 0, '/1630785212050968576/1630822946622803968/1630823709545730048/1630823927897001984/1630824074718613504', '/财务-利润类/销售收入/人工费用/其他经营费用——主要业务支出/消防费用', '/PL/PL3300S/PL4200/PL4610/441109', NULL, 32, '0', '1', '1', '2023-03-01 14:55:33', '1', '2023-03-01 14:55:33');
INSERT INTO `qf_subject_international_info` VALUES ('1630824075360342016', 'PL2', '441110', '环境保护费用', 'expenses environment protection', '€', '4', '1630823927897001984', 0, '/1630785212050968576/1630822946622803968/1630823709545730048/1630823927897001984/1630824075360342016', '/财务-利润类/销售收入/人工费用/其他经营费用——主要业务支出/环境保护费用', '/PL/PL3300S/PL4200/PL4610/441110', NULL, 33, '0', '1', '1', '2023-03-01 14:55:34', '1', '2023-03-01 14:55:34');
INSERT INTO `qf_subject_international_info` VALUES ('1630824075997876224', 'PL2', '441111', '残渣/废物清除费用', 'expenses residue/waste removal', '€', '4', '1630823927897001984', 0, '/1630785212050968576/1630822946622803968/1630823709545730048/1630823927897001984/1630824075997876224', '/财务-利润类/销售收入/人工费用/其他经营费用——主要业务支出/残渣/废物清除费用', '/PL/PL3300S/PL4200/PL4610/441111', NULL, 34, '0', '1', '1', '2023-03-01 14:55:34', '1', '2023-03-01 14:55:34');
INSERT INTO `qf_subject_international_info` VALUES ('1630824076761239552', 'PL2', '440101', '按组合计提坏账准备', 'collectively allowance for doubtful accounts', '€', '4', '1630823928488398848', 0, '/1630785212050968576/1630822946622803968/1630823709545730048/1630823928488398848/1630824076761239552', '/财务-利润类/销售收入/人工费用/其他营业费用-其他业务成本/按组合计提坏账准备', '/PL/PL3300S/PL4200/PL4611/440101', NULL, 1, '0', '1', '1', '2023-03-01 14:55:34', '1', '2023-03-01 14:55:34');
INSERT INTO `qf_subject_international_info` VALUES ('1630824077436522496', 'PL2', '440102', '坏账专项准备', 'specific allowance for bad debts', '€', '4', '1630823928488398848', 0, '/1630785212050968576/1630822946622803968/1630823709545730048/1630823928488398848/1630824077436522496', '/财务-利润类/销售收入/人工费用/其他营业费用-其他业务成本/坏账专项准备', '/PL/PL3300S/PL4200/PL4611/440102', NULL, 2, '0', '1', '1', '2023-03-01 14:55:34', '1', '2023-03-01 14:55:34');
INSERT INTO `qf_subject_international_info` VALUES ('1630824078153748480', 'PL2', '440104', '实际核销坏账', 'actual bad debts written off', '€', '4', '1630823928488398848', 0, '/1630785212050968576/1630822946622803968/1630823709545730048/1630823928488398848/1630824078153748480', '/财务-利润类/销售收入/人工费用/其他营业费用-其他业务成本/实际核销坏账', '/PL/PL3300S/PL4200/PL4611/440104', NULL, 3, '0', '1', '1', '2023-03-01 14:55:34', '1', '2023-03-01 14:55:34');
INSERT INTO `qf_subject_international_info` VALUES ('1630824078829031424', 'PL2', '440402', '预期损失准备金', 'provision for anticipated losses', '€', '4', '1630823928488398848', 0, '/1630785212050968576/1630822946622803968/1630823709545730048/1630823928488398848/1630824078829031424', '/财务-利润类/销售收入/人工费用/其他营业费用-其他业务成本/预期损失准备金', '/PL/PL3300S/PL4200/PL4611/440402', NULL, 4, '0', '1', '1', '2023-03-01 14:55:34', '1', '2023-03-01 14:55:34');
INSERT INTO `qf_subject_international_info` VALUES ('1630824079504314368', 'PL2', '440403', '施工合同预期损失准备金（PoC/ZPMM）', 'provision for anticipated losses from construction contracts(PoC/ZPMM)', '€', '4', '1630823928488398848', 0, '/1630785212050968576/1630822946622803968/1630823709545730048/1630823928488398848/1630824079504314368', '/财务-利润类/销售收入/人工费用/其他营业费用-其他业务成本/施工合同预期损失准备金（PoC/ZPMM）', '/PL/PL3300S/PL4200/PL4611/440403', NULL, 5, '0', '1', '1', '2023-03-01 14:55:35', '1', '2023-03-01 14:55:35');
INSERT INTO `qf_subject_international_info` VALUES ('1630824080141848576', 'PL2', '462001', '恶性通货膨胀效应导致的净货币头寸的收益/损失', 'Gain/Loss on net monetary position due to hyperinflation effect', '€', '4', '1630823928488398848', 0, '/1630785212050968576/1630822946622803968/1630823709545730048/1630823928488398848/1630824080141848576', '/财务-利润类/销售收入/人工费用/其他营业费用-其他业务成本/恶性通货膨胀效应导致的净货币头寸的收益/损失', '/PL/PL3300S/PL4200/PL4611/462001', NULL, 6, '0', '1', '1', '2023-03-01 14:55:35', '1', '2023-03-01 14:55:35');
INSERT INTO `qf_subject_international_info` VALUES ('1630824080745828352', 'PL2', '441201', '不动产税', 'real property taxes', '€', '4', '1630823929092378624', 0, '/1630785212050968576/1630822946622803968/1630823709545730048/1630823929092378624/1630824080745828352', '/财务-利润类/销售收入/人工费用/其他营业费用-营业税和额外费用/不动产税', '/PL/PL3300S/PL4200/PL4619/441201', NULL, 1, '0', '1', '1', '2023-03-01 14:55:35', '1', '2023-03-01 14:55:35');
INSERT INTO `qf_subject_international_info` VALUES ('1630824081345613824', 'PL2', '441202', '机动车税', 'motor vehicle taxes', '€', '4', '1630823929092378624', 0, '/1630785212050968576/1630822946622803968/1630823709545730048/1630823929092378624/1630824081345613824', '/财务-利润类/销售收入/人工费用/其他营业费用-营业税和额外费用/机动车税', '/PL/PL3300S/PL4200/PL4619/441202', NULL, 2, '0', '1', '1', '2023-03-01 14:55:35', '1', '2023-03-01 14:55:35');
INSERT INTO `qf_subject_international_info` VALUES ('1630824081974759424', 'PL2', '441204', '其他税费', 'other taxes', '€', '4', '1630823929092378624', 0, '/1630785212050968576/1630822946622803968/1630823709545730048/1630823929092378624/1630824081974759424', '/财务-利润类/销售收入/人工费用/其他营业费用-营业税和额外费用/其他税费', '/PL/PL3300S/PL4200/PL4619/441204', NULL, 3, '0', '1', '1', '2023-03-01 14:55:35', '1', '2023-03-01 14:55:35');
INSERT INTO `qf_subject_international_info` VALUES ('1630824082595516416', 'PL2', '440401', '交付货物的保修服务', 'warranty service for delivered goods', '€', '4', '1630823929725718528', 0, '/1630785212050968576/1630822946622803968/1630823709545730048/1630823929725718528/1630824082595516416', '/财务-利润类/销售收入/人工费用/其他营业费用-销售费用/交付货物的保修服务', '/PL/PL3300S/PL4200/PL4620/440401', NULL, 1, '0', '1', '1', '2023-03-01 14:55:35', '1', '2023-03-01 14:55:35');
INSERT INTO `qf_subject_international_info` VALUES ('1630824083207884800', 'PL2', '440705', '客户和业务伙伴的招待费', 'entertainment for customers and business associates', '€', '4', '1630823929725718528', 0, '/1630785212050968576/1630822946622803968/1630823709545730048/1630823929725718528/1630824083207884800', '/财务-利润类/销售收入/人工费用/其他营业费用-销售费用/客户和业务伙伴的招待费', '/PL/PL3300S/PL4200/PL4620/440705', NULL, 2, '0', '1', '1', '2023-03-01 14:55:35', '1', '2023-03-01 14:55:35');
INSERT INTO `qf_subject_international_info` VALUES ('1630824083866390528', 'PL2', '440706', '其他招待费', 'entertainment other', '€', '4', '1630823929725718528', 0, '/1630785212050968576/1630822946622803968/1630823709545730048/1630823929725718528/1630824083866390528', '/财务-利润类/销售收入/人工费用/其他营业费用-销售费用/其他招待费', '/PL/PL3300S/PL4200/PL4620/440706', NULL, 3, '0', '1', '1', '2023-03-01 14:55:36', '1', '2023-03-01 14:55:36');
INSERT INTO `qf_subject_international_info` VALUES ('1630824084487147520', 'PL2', '440801', '出境运费', 'outgoing freights', '€', '4', '1630823929725718528', 0, '/1630785212050968576/1630822946622803968/1630823709545730048/1630823929725718528/1630824084487147520', '/财务-利润类/销售收入/人工费用/其他营业费用-销售费用/出境运费', '/PL/PL3300S/PL4200/PL4620/440801', NULL, 4, '0', '1', '1', '2023-03-01 14:55:36', '1', '2023-03-01 14:55:36');
INSERT INTO `qf_subject_international_info` VALUES ('1630824085099515904', 'PL2', '440802', '进出口半成品运费', 'freight inward and outward semi finished goods', '€', '4', '1630823929725718528', 0, '/1630785212050968576/1630822946622803968/1630823709545730048/1630823929725718528/1630824085099515904', '/财务-利润类/销售收入/人工费用/其他营业费用-销售费用/进出口半成品运费', '/PL/PL3300S/PL4200/PL4620/440802', NULL, 5, '0', '1', '1', '2023-03-01 14:55:36', '1', '2023-03-01 14:55:36');
INSERT INTO `qf_subject_international_info` VALUES ('1630824085728661504', 'PL2', '440803', '清关费用', 'costs of customs clearance', '€', '4', '1630823929725718528', 0, '/1630785212050968576/1630822946622803968/1630823709545730048/1630823929725718528/1630824085728661504', '/财务-利润类/销售收入/人工费用/其他营业费用-销售费用/清关费用', '/PL/PL3300S/PL4200/PL4620/440803', NULL, 6, '0', '1', '1', '2023-03-01 14:55:36', '1', '2023-03-01 14:55:36');
INSERT INTO `qf_subject_international_info` VALUES ('1630824086357807104', 'PL2', '440804', '授权/认证和考试费', 'authorization/accreditation and examination fees', '€', '4', '1630823929725718528', 0, '/1630785212050968576/1630822946622803968/1630823709545730048/1630823929725718528/1630824086357807104', '/财务-利润类/销售收入/人工费用/其他营业费用-销售费用/授权/认证和考试费', '/PL/PL3300S/PL4200/PL4620/440804', NULL, 7, '0', '1', '1', '2023-03-01 14:55:36', '1', '2023-03-01 14:55:36');
INSERT INTO `qf_subject_international_info` VALUES ('1630824087003729920', 'PL2', '440805', '佣金', 'commission', '€', '4', '1630823929725718528', 0, '/1630785212050968576/1630822946622803968/1630823709545730048/1630823929725718528/1630824087003729920', '/财务-利润类/销售收入/人工费用/其他营业费用-销售费用/佣金', '/PL/PL3300S/PL4200/PL4620/440805', NULL, 8, '0', '1', '1', '2023-03-01 14:55:36', '1', '2023-03-01 14:55:36');
INSERT INTO `qf_subject_international_info` VALUES ('1630824087616098304', 'PL2', '440806', '广告/促销礼品', 'advertising/promotional gifts', '€', '4', '1630823929725718528', 0, '/1630785212050968576/1630822946622803968/1630823709545730048/1630823929725718528/1630824087616098304', '/财务-利润类/销售收入/人工费用/其他营业费用-销售费用/广告/促销礼品', '/PL/PL3300S/PL4200/PL4620/440806', NULL, 9, '0', '1', '1', '2023-03-01 14:55:36', '1', '2023-03-01 14:55:36');
INSERT INTO `qf_subject_international_info` VALUES ('1630824088220078080', 'PL2', '440808', '其他广告费用', 'other advertising expenses', '€', '4', '1630823929725718528', 0, '/1630785212050968576/1630822946622803968/1630823709545730048/1630823929725718528/1630824088220078080', '/财务-利润类/销售收入/人工费用/其他营业费用-销售费用/其他广告费用', '/PL/PL3300S/PL4200/PL4620/440808', NULL, 10, '0', '1', '1', '2023-03-01 14:55:37', '1', '2023-03-01 14:55:37');
INSERT INTO `qf_subject_international_info` VALUES ('1630824088870195200', 'PL2', '440809', '运输和包装', 'shipping and packaging', '€', '4', '1630823929725718528', 0, '/1630785212050968576/1630822946622803968/1630823709545730048/1630823929725718528/1630824088870195200', '/财务-利润类/销售收入/人工费用/其他营业费用-销售费用/运输和包装', '/PL/PL3300S/PL4200/PL4620/440809', NULL, 11, '0', '1', '1', '2023-03-01 14:55:37', '1', '2023-03-01 14:55:37');
INSERT INTO `qf_subject_international_info` VALUES ('1630824089495146496', 'PL2', '440810', '租用包装费', 'expenses for rented packaging', '€', '4', '1630823929725718528', 0, '/1630785212050968576/1630822946622803968/1630823709545730048/1630823929725718528/1630824089495146496', '/财务-利润类/销售收入/人工费用/其他营业费用-销售费用/租用包装费', '/PL/PL3300S/PL4200/PL4620/440810', NULL, 12, '0', '1', '1', '2023-03-01 14:55:37', '1', '2023-03-01 14:55:37');
INSERT INTO `qf_subject_international_info` VALUES ('1630824090229149696', 'PL2', '440811', '通行费', 'toll fee', '€', '4', '1630823929725718528', 0, '/1630785212050968576/1630822946622803968/1630823709545730048/1630823929725718528/1630824090229149696', '/财务-利润类/销售收入/人工费用/其他营业费用-销售费用/通行费', '/PL/PL3300S/PL4200/PL4620/440811', NULL, 13, '0', '1', '1', '2023-03-01 14:55:37', '1', '2023-03-01 14:55:37');
INSERT INTO `qf_subject_international_info` VALUES ('1630824090875072512', 'PL2', '440850', '特殊出港运费', 'special outgoing freights', '€', '4', '1630823929725718528', 0, '/1630785212050968576/1630822946622803968/1630823709545730048/1630823929725718528/1630824090875072512', '/财务-利润类/销售收入/人工费用/其他营业费用-销售费用/特殊出港运费', '/PL/PL3300S/PL4200/PL4620/440850', NULL, 14, '0', '1', '1', '2023-03-01 14:55:37', '1', '2023-03-01 14:55:37');
INSERT INTO `qf_subject_international_info` VALUES ('1630824091504218112', 'PL2', '441001', '邮费', 'postage', '€', '4', '1630823930338086912', 0, '/1630785212050968576/1630822946622803968/1630823709545730048/1630823930338086912/1630824091504218112', '/财务-利润类/销售收入/人工费用/其他营业费用-管理费用/邮费', '/PL/PL3300S/PL4200/PL4621/441001', NULL, 1, '0', '1', '1', '2023-03-01 14:55:37', '1', '2023-03-01 14:55:37');
INSERT INTO `qf_subject_international_info` VALUES ('1630824092133363712', 'PL2', '441002', '电话、传真机', 'Telephone, fax machine', '€', '4', '1630823930338086912', 0, '/1630785212050968576/1630822946622803968/1630823709545730048/1630823930338086912/1630824092133363712', '/财务-利润类/销售收入/人工费用/其他营业费用-管理费用/电话、传真机', '/PL/PL3300S/PL4200/PL4621/441002', NULL, 2, '0', '1', '1', '2023-03-01 14:55:38', '1', '2023-03-01 14:55:38');
INSERT INTO `qf_subject_international_info` VALUES ('1630824092749926400', 'PL2', '441003', '办公用品', 'office supplies', '€', '4', '1630823930338086912', 0, '/1630785212050968576/1630822946622803968/1630823709545730048/1630823930338086912/1630824092749926400', '/财务-利润类/销售收入/人工费用/其他营业费用-管理费用/办公用品', '/PL/PL3300S/PL4200/PL4621/441003', NULL, 3, '0', '1', '1', '2023-03-01 14:55:38', '1', '2023-03-01 14:55:38');
INSERT INTO `qf_subject_international_info` VALUES ('1630824093387460608', 'PL2', '441004', '信息文献', 'informative literature', '€', '4', '1630823930338086912', 0, '/1630785212050968576/1630822946622803968/1630823709545730048/1630823930338086912/1630824093387460608', '/财务-利润类/销售收入/人工费用/其他营业费用-管理费用/信息文献', '/PL/PL3300S/PL4200/PL4621/441004', NULL, 4, '0', '1', '1', '2023-03-01 14:55:38', '1', '2023-03-01 14:55:38');
INSERT INTO `qf_subject_international_info` VALUES ('1630824094024994816', 'PL2', '441005', '印刷品和形式', 'printed matter and form', '€', '4', '1630823930338086912', 0, '/1630785212050968576/1630822946622803968/1630823709545730048/1630823930338086912/1630824094024994816', '/财务-利润类/销售收入/人工费用/其他营业费用-管理费用/印刷品和形式', '/PL/PL3300S/PL4200/PL4621/441005', NULL, 5, '0', '1', '1', '2023-03-01 14:55:38', '1', '2023-03-01 14:55:38');
INSERT INTO `qf_subject_international_info` VALUES ('1630824094662529024', 'PL2', '441008', '捐赠', 'donations', '€', '4', '1630823930338086912', 0, '/1630785212050968576/1630822946622803968/1630823709545730048/1630823930338086912/1630824094662529024', '/财务-利润类/销售收入/人工费用/其他营业费用-管理费用/捐赠', '/PL/PL3300S/PL4200/PL4621/441008', NULL, 6, '0', '1', '1', '2023-03-01 14:55:38', '1', '2023-03-01 14:55:38');
INSERT INTO `qf_subject_international_info` VALUES ('1630824095367172096', 'PL2', '441009', '其他费用', 'fees', '€', '4', '1630823930338086912', 0, '/1630785212050968576/1630822946622803968/1630823709545730048/1630823930338086912/1630824095367172096', '/财务-利润类/销售收入/人工费用/其他营业费用-管理费用/其他费用', '/PL/PL3300S/PL4200/PL4621/441009', NULL, 7, '0', '1', '1', '2023-03-01 14:55:38', '1', '2023-03-01 14:55:38');
INSERT INTO `qf_subject_international_info` VALUES ('1630824095996317696', 'PL2', '441010', '会费', 'contributions', '€', '4', '1630823930338086912', 0, '/1630785212050968576/1630822946622803968/1630823709545730048/1630823930338086912/1630824095996317696', '/财务-利润类/销售收入/人工费用/其他营业费用-管理费用/会费', '/PL/PL3300S/PL4200/PL4621/441010', NULL, 8, '0', '1', '1', '2023-03-01 14:55:38', '1', '2023-03-01 14:55:38');
INSERT INTO `qf_subject_international_info` VALUES ('1630824096621268992', 'PL2', '441011', '保理费用', 'contributions Factoring', '€', '4', '1630823930338086912', 0, '/1630785212050968576/1630822946622803968/1630823709545730048/1630823930338086912/1630824096621268992', '/财务-利润类/销售收入/人工费用/其他营业费用-管理费用/保理费用', '/PL/PL3300S/PL4200/PL4621/441011', NULL, 9, '0', '1', '1', '2023-03-01 14:55:39', '1', '2023-03-01 14:55:39');
INSERT INTO `qf_subject_international_info` VALUES ('1630824097434963968', 'PL2', '441012', '银行手续费', 'bank charges', '€', '4', '1630823930338086912', 0, '/1630785212050968576/1630822946622803968/1630823709545730048/1630823930338086912/1630824097434963968', '/财务-利润类/销售收入/人工费用/其他营业费用-管理费用/银行手续费', '/PL/PL3300S/PL4200/PL4621/441012', NULL, 10, '0', '1', '1', '2023-03-01 14:55:39', '1', '2023-03-01 14:55:39');
INSERT INTO `qf_subject_international_info` VALUES ('1630824098072498176', 'PL2', '441013', '董事薪酬', 'directors\' remuneration', '€', '4', '1630823930338086912', 0, '/1630785212050968576/1630822946622803968/1630823709545730048/1630823930338086912/1630824098072498176', '/财务-利润类/销售收入/人工费用/其他营业费用-管理费用/董事薪酬', '/PL/PL3300S/PL4200/PL4621/441013', NULL, 11, '0', '1', '1', '2023-03-01 14:55:39', '1', '2023-03-01 14:55:39');
INSERT INTO `qf_subject_international_info` VALUES ('1630824098722615296', 'PL2', '441014', '法庭和公证费', 'court and notary expenses', '€', '4', '1630823930338086912', 0, '/1630785212050968576/1630822946622803968/1630823709545730048/1630823930338086912/1630824098722615296', '/财务-利润类/销售收入/人工费用/其他营业费用-管理费用/法庭和公证费', '/PL/PL3300S/PL4200/PL4621/441014', NULL, 12, '0', '1', '1', '2023-03-01 14:55:39', '1', '2023-03-01 14:55:39');
INSERT INTO `qf_subject_international_info` VALUES ('1630824099385315328', 'PL2', '441015', '对协会的会费', 'contributions to association', '€', '4', '1630823930338086912', 0, '/1630785212050968576/1630822946622803968/1630823709545730048/1630823930338086912/1630824099385315328', '/财务-利润类/销售收入/人工费用/其他营业费用-管理费用/对协会的会费', '/PL/PL3300S/PL4200/PL4621/441015', NULL, 13, '0', '1', '1', '2023-03-01 14:55:39', '1', '2023-03-01 14:55:39');
INSERT INTO `qf_subject_international_info` VALUES ('1630824100018655232', 'PL2', '441016', '法律咨询费', 'expenses for legal advice', '€', '4', '1630823930338086912', 0, '/1630785212050968576/1630822946622803968/1630823709545730048/1630823930338086912/1630824100018655232', '/财务-利润类/销售收入/人工费用/其他营业费用-管理费用/法律咨询费', '/PL/PL3300S/PL4200/PL4621/441016', NULL, 14, '0', '1', '1', '2023-03-01 14:55:39', '1', '2023-03-01 14:55:39');
INSERT INTO `qf_subject_international_info` VALUES ('1630824100622635008', 'PL2', '441017', '咨询税务审计员的费用', 'expenses for consulting tax auditors', '€', '4', '1630823930338086912', 0, '/1630785212050968576/1630822946622803968/1630823709545730048/1630823930338086912/1630824100622635008', '/财务-利润类/销售收入/人工费用/其他营业费用-管理费用/咨询税务审计员的费用', '/PL/PL3300S/PL4200/PL4621/441017', NULL, 15, '0', '1', '1', '2023-03-01 14:55:40', '1', '2023-03-01 14:55:40');
INSERT INTO `qf_subject_international_info` VALUES ('1630824101285335040', 'PL2', '441018', '其他咨询费用', 'other expenses for consulting', '€', '4', '1630823930338086912', 0, '/1630785212050968576/1630822946622803968/1630823709545730048/1630823930338086912/1630824101285335040', '/财务-利润类/销售收入/人工费用/其他营业费用-管理费用/其他咨询费用', '/PL/PL3300S/PL4200/PL4621/441018', NULL, 16, '0', '1', '1', '2023-03-01 14:55:40', '1', '2023-03-01 14:55:40');
INSERT INTO `qf_subject_international_info` VALUES ('1630824101927063552', 'PL2', '441019', '招聘费', 'recruitment fee', '€', '4', '1630823930338086912', 0, '/1630785212050968576/1630822946622803968/1630823709545730048/1630823930338086912/1630824101927063552', '/财务-利润类/销售收入/人工费用/其他营业费用-管理费用/招聘费', '/PL/PL3300S/PL4200/PL4621/441019', NULL, 17, '0', '1', '1', '2023-03-01 14:55:40', '1', '2023-03-01 14:55:40');
INSERT INTO `qf_subject_international_info` VALUES ('1630824102552014848', 'PL2', '441020', '人事工资核算成本', 'costs personnel and wage accounting', '€', '4', '1630823930338086912', 0, '/1630785212050968576/1630822946622803968/1630823709545730048/1630823930338086912/1630824102552014848', '/财务-利润类/销售收入/人工费用/其他营业费用-管理费用/人事工资核算成本', '/PL/PL3300S/PL4200/PL4621/441020', NULL, 18, '0', '1', '1', '2023-03-01 14:55:40', '1', '2023-03-01 14:55:40');
INSERT INTO `qf_subject_international_info` VALUES ('1630824103361515520', 'PL2', '441106', '披露费', 'disclosure fee', '€', '4', '1630823930338086912', 0, '/1630785212050968576/1630822946622803968/1630823709545730048/1630823930338086912/1630824103361515520', '/财务-利润类/销售收入/人工费用/其他营业费用-管理费用/披露费', '/PL/PL3300S/PL4200/PL4621/441106', NULL, 19, '0', '1', '1', '2023-03-01 14:55:40', '1', '2023-03-01 14:55:40');
INSERT INTO `qf_subject_international_info` VALUES ('1630824103990661120', 'PL2', '440901', '已实现的经营性业务汇兑损失', 'exchange rate loss realized operational business', '€', '4', '1630823930942066688', 0, '/1630785212050968576/1630822946622803968/1630823709545730048/1630823930942066688/1630824103990661120', '/财务-利润类/销售收入/人工费用/其他营业费用-财务费用/已实现的经营性业务汇兑损失', '/PL/PL3300S/PL4200/PL4624/440901', NULL, 1, '0', '1', '1', '2023-03-01 14:55:40', '1', '2023-03-01 14:55:40');
INSERT INTO `qf_subject_international_info` VALUES ('1630824104619806720', 'PL2', '440902', '已实现资金交易汇兑损失', 'exchange rate loss realized from treasury transactions', '€', '4', '1630823930942066688', 0, '/1630785212050968576/1630822946622803968/1630823709545730048/1630823930942066688/1630824104619806720', '/财务-利润类/销售收入/人工费用/其他营业费用-财务费用/已实现资金交易汇兑损失', '/PL/PL3300S/PL4200/PL4624/440902', NULL, 2, '0', '1', '1', '2023-03-01 14:55:40', '1', '2023-03-01 14:55:41');
INSERT INTO `qf_subject_international_info` VALUES ('1630824105240563712', 'PL2', '440903', '未实现汇兑损失', 'exchange rate loss unrealized', '€', '4', '1630823930942066688', 0, '/1630785212050968576/1630822946622803968/1630823709545730048/1630823930942066688/1630824105240563712', '/财务-利润类/销售收入/人工费用/其他营业费用-财务费用/未实现汇兑损失', '/PL/PL3300S/PL4200/PL4624/440903', NULL, 3, '0', '1', '1', '2023-03-01 14:55:41', '1', '2023-03-01 14:55:41');
INSERT INTO `qf_subject_international_info` VALUES ('1630824105878097920', 'PL3', 'K3430', '当年净利润/净损失-少数股东', 'net income/net loss for the year - minority interests', '€', '4', '1630823966002253824', 0, '/1630785212050968576/1630822949776920576/1630823722422243328/1630823966002253824/1630824105878097920', '/财务-利润类/净利润/归属于非控制性权益的净利润/少数股东损益/当年净利润/净损失-少数股东', '/PL/900000/PL8200/900100/K3430', NULL, 1, '0', '1', '1', '2023-03-01 14:55:41', '1', '2023-03-01 14:55:41');
INSERT INTO `qf_subject_international_info` VALUES ('1630824894071705600', 'BS1', 'A1000', '资产', 'ASSETS', '€', '1', '1630784869674127360', 2, '/1630784869674127360/1630824894071705600', '/财务-资产负责类/资产', '/BS/A1000', NULL, 1, '0', '1', '1', '2023-03-01 14:58:49', '1', '2023-03-01 14:59:35');
INSERT INTO `qf_subject_international_info` VALUES ('1630824894692462592', 'BS2,BS3', 'P2000', '所有者权益和负债', 'EQUITY AND LIABILITIES', '€', '1', '1630784869674127360', 3, '/1630784869674127360/1630824894692462592', '/财务-资产负责类/所有者权益和负债', '/BS/P2000', NULL, 2, '0', '1', '1', '2023-03-01 14:58:49', '1', '2023-03-01 14:59:35');
INSERT INTO `qf_subject_international_info` VALUES ('1630825086661562368', 'BS1', 'A1100', '非流动资产', 'Non-current assets', '€', '2', '1630824894071705600', 9, '/1630784869674127360/1630824894071705600/1630825086661562368', '/财务-资产负责类/资产/非流动资产', '/BS/A1000/A1100', NULL, 1, '0', '1', '1', '2023-03-01 14:59:35', '1', '2023-03-01 15:00:02');
INSERT INTO `qf_subject_international_info` VALUES ('1630825087282319360', 'BS1', 'A1200', '流动资产', 'Current assets', '€', '2', '1630824894071705600', 8, '/1630784869674127360/1630824894071705600/1630825087282319360', '/财务-资产负责类/资产/流动资产', '/BS/A1000/A1200', NULL, 2, '0', '1', '1', '2023-03-01 14:59:35', '1', '2023-03-01 15:00:04');
INSERT INTO `qf_subject_international_info` VALUES ('1630825087873716224', 'BS2', 'P2100', '所有者权益和负债', 'Equity', '€', '2', '1630824894692462592', 5, '/1630784869674127360/1630824894692462592/1630825087873716224', '/财务-资产负责类/所有者权益和负债/所有者权益和负债', '/BS/P2000/P2100', NULL, 1, '0', '1', '1', '2023-03-01 14:59:35', '1', '2023-03-01 15:00:05');
INSERT INTO `qf_subject_international_info` VALUES ('1630825088481890304', 'BS3', 'P2200', '非流动负债', 'Non-current liabilities', '€', '2', '1630824894692462592', 7, '/1630784869674127360/1630824894692462592/1630825088481890304', '/财务-资产负责类/所有者权益和负债/非流动负债', '/BS/P2000/P2200', NULL, 2, '0', '1', '1', '2023-03-01 14:59:35', '1', '2023-03-01 15:00:05');
INSERT INTO `qf_subject_international_info` VALUES ('1630825089119424512', 'BS3', 'P2300', '流动负债', 'Current liabilities', '€', '2', '1630824894692462592', 6, '/1630784869674127360/1630824894692462592/1630825089119424512', '/财务-资产负责类/所有者权益和负债/流动负债', '/BS/P2000/P2300', NULL, 3, '0', '1', '1', '2023-03-01 14:59:35', '1', '2023-03-01 15:00:06');
INSERT INTO `qf_subject_international_info` VALUES ('1630825197982584832', 'BS1', 'A1120', '无形资产', 'Intangible assets', '€', '3', '1630825086661562368', 8, '/1630784869674127360/1630824894071705600/1630825086661562368/1630825197982584832', '/财务-资产负责类/资产/非流动资产/无形资产', '/BS/A1000/A1100/A1120', NULL, 1, '0', '1', '1', '2023-03-01 15:00:01', '1', '2023-03-01 15:01:26');
INSERT INTO `qf_subject_international_info` VALUES ('1630825198599147520', 'BS1', 'A1110', '固定资产', 'Property, plant and equipment', '€', '3', '1630825086661562368', 10, '/1630784869674127360/1630824894071705600/1630825086661562368/1630825198599147520', '/财务-资产负责类/资产/非流动资产/固定资产', '/BS/A1000/A1100/A1110', NULL, 2, '0', '1', '1', '2023-03-01 15:00:01', '1', '2023-03-01 15:01:28');
INSERT INTO `qf_subject_international_info` VALUES ('1630825199190544384', 'BS1', 'A1115', '使用权资产', 'Right-of-use assets', '€', '3', '1630825086661562368', 1, '/1630784869674127360/1630824894071705600/1630825086661562368/1630825199190544384', '/财务-资产负责类/资产/非流动资产/使用权资产', '/BS/A1000/A1100/A1115', NULL, 3, '0', '1', '1', '2023-03-01 15:00:01', '1', '2023-03-01 15:01:28');
INSERT INTO `qf_subject_international_info` VALUES ('1630825199773552640', 'BS1', 'A1111', '融资租赁', 'Finance lease', '€', '3', '1630825086661562368', 2, '/1630784869674127360/1630824894071705600/1630825086661562368/1630825199773552640', '/财务-资产负责类/资产/非流动资产/融资租赁', '/BS/A1000/A1100/A1111', NULL, 4, '0', '1', '1', '2023-03-01 15:00:02', '1', '2023-03-01 15:01:28');
INSERT INTO `qf_subject_international_info` VALUES ('1630825200381726720', 'BS1', 'A1125', '对关联公司股份', 'Shares in affiliated companies', '€', '3', '1630825086661562368', 1, '/1630784869674127360/1630824894071705600/1630825086661562368/1630825200381726720', '/财务-资产负责类/资产/非流动资产/对关联公司股份', '/BS/A1000/A1100/A1125', NULL, 5, '0', '1', '1', '2023-03-01 15:00:02', '1', '2023-03-01 15:01:28');
INSERT INTO `qf_subject_international_info` VALUES ('1630825201019260928', 'BS1', 'A1140', '其他非流动金融资产', 'Other non-current financial assets', '€', '3', '1630825086661562368', 2, '/1630784869674127360/1630824894071705600/1630825086661562368/1630825201019260928', '/财务-资产负责类/资产/非流动资产/其他非流动金融资产', '/BS/A1000/A1100/A1140', NULL, 6, '0', '1', '1', '2023-03-01 15:00:02', '1', '2023-03-01 15:01:28');
INSERT INTO `qf_subject_international_info` VALUES ('1630825201635823616', 'BS1', 'A1150', '其他非流动应收账款', 'Other non-current receivables', '€', '3', '1630825086661562368', 1, '/1630784869674127360/1630824894071705600/1630825086661562368/1630825201635823616', '/财务-资产负责类/资产/非流动资产/其他非流动应收账款', '/BS/A1000/A1100/A1150', NULL, 7, '0', '1', '1', '2023-03-01 15:00:02', '1', '2023-03-01 15:01:29');
INSERT INTO `qf_subject_international_info` VALUES ('1630825202332078080', 'BS1', 'A1165', '非流动所得税资产', 'Non-current income tax assets', '€', '3', '1630825086661562368', 1, '/1630784869674127360/1630824894071705600/1630825086661562368/1630825202332078080', '/财务-资产负责类/资产/非流动资产/非流动所得税资产', '/BS/A1000/A1100/A1165', NULL, 8, '0', '1', '1', '2023-03-01 15:00:02', '1', '2023-03-01 15:01:29');
INSERT INTO `qf_subject_international_info` VALUES ('1630825202919280640', 'BS1', 'A1160', '递延所得说资产', 'Deferred tax assets', '€', '3', '1630825086661562368', 1, '/1630784869674127360/1630824894071705600/1630825086661562368/1630825202919280640', '/财务-资产负责类/资产/非流动资产/递延所得说资产', '/BS/A1000/A1100/A1160', NULL, 9, '0', '1', '1', '2023-03-01 15:00:02', '1', '2023-03-01 15:01:29');
INSERT INTO `qf_subject_international_info` VALUES ('1630825203519066112', 'BS1', 'A1210', '存货', 'Inventories', '€', '3', '1630825087282319360', 7, '/1630784869674127360/1630824894071705600/1630825087282319360/1630825203519066112', '/财务-资产负责类/资产/流动资产/存货', '/BS/A1000/A1200/A1210', NULL, 1, '0', '1', '1', '2023-03-01 15:00:02', '1', '2023-03-01 15:01:30');
INSERT INTO `qf_subject_international_info` VALUES ('1630825204102074368', 'BS1', 'A1220', '应收账款和其他资产', 'Trade receivables and other assets', '€', '3', '1630825087282319360', 3, '/1630784869674127360/1630824894071705600/1630825087282319360/1630825204102074368', '/财务-资产负责类/资产/流动资产/应收账款和其他资产', '/BS/A1000/A1200/A1220', NULL, 2, '0', '1', '1', '2023-03-01 15:00:03', '1', '2023-03-01 15:01:31');
INSERT INTO `qf_subject_international_info` VALUES ('1630825205607829504', 'BS1', 'A1225', '应收关联公司款项', 'receivables from affiliated companies', '€', '3', '1630825087282319360', 1, '/1630784869674127360/1630824894071705600/1630825087282319360/1630825205607829504', '/财务-资产负责类/资产/流动资产/应收关联公司款项', '/BS/A1000/A1200/A1225', NULL, 3, '0', '1', '1', '2023-03-01 15:00:03', '1', '2023-03-01 15:01:31');
INSERT INTO `qf_subject_international_info` VALUES ('1630825206216003584', 'BS1', 'A1227', '应收关联公司贷款', 'loan receivables from affiliated companies', '€', '3', '1630825087282319360', 1, '/1630784869674127360/1630824894071705600/1630825087282319360/1630825206216003584', '/财务-资产负责类/资产/流动资产/应收关联公司贷款', '/BS/A1000/A1200/A1227', NULL, 4, '0', '1', '1', '2023-03-01 15:00:03', '1', '2023-03-01 15:01:31');
INSERT INTO `qf_subject_international_info` VALUES ('1630825206824177664', 'BS1', 'A1230', '预付账款', 'Prepayments', '€', '3', '1630825087282319360', 2, '/1630784869674127360/1630824894071705600/1630825087282319360/1630825206824177664', '/财务-资产负责类/资产/流动资产/预付账款', '/BS/A1000/A1200/A1230', NULL, 5, '0', '1', '1', '2023-03-01 15:00:03', '1', '2023-03-01 15:01:31');
INSERT INTO `qf_subject_international_info` VALUES ('1630825207423963136', 'BS1', 'A1232', '流动所得税资产', 'Current income tax assets', '€', '3', '1630825087282319360', 1, '/1630784869674127360/1630824894071705600/1630825087282319360/1630825207423963136', '/财务-资产负责类/资产/流动资产/流动所得税资产', '/BS/A1000/A1200/A1232', NULL, 6, '0', '1', '1', '2023-03-01 15:00:03', '1', '2023-03-01 15:01:31');
INSERT INTO `qf_subject_international_info` VALUES ('1630825208011165696', 'BS1', 'A1235', '以公允价值计量的金融工具', 'Financial instruments measured at fair value', '€', '3', '1630825087282319360', 1, '/1630784869674127360/1630824894071705600/1630825087282319360/1630825208011165696', '/财务-资产负责类/资产/流动资产/以公允价值计量的金融工具', '/BS/A1000/A1200/A1235', NULL, 7, '0', '1', '1', '2023-03-01 15:00:04', '1', '2023-03-01 15:01:32');
INSERT INTO `qf_subject_international_info` VALUES ('1630825208610951168', 'BS1', 'A1240', '现金和现金等价物', 'Cash and cash equivalents', '€', '3', '1630825087282319360', 1, '/1630784869674127360/1630824894071705600/1630825087282319360/1630825208610951168', '/财务-资产负责类/资产/流动资产/现金和现金等价物', '/BS/A1000/A1200/A1240', NULL, 8, '0', '1', '1', '2023-03-01 15:00:04', '1', '2023-03-01 15:01:32');
INSERT INTO `qf_subject_international_info` VALUES ('1630825209185570816', 'BS2', 'P2110', '实收资本', 'Subscribed capital', '€', '3', '1630825087873716224', 1, '/1630784869674127360/1630824894692462592/1630825087873716224/1630825209185570816', '/财务-资产负责类/所有者权益和负债/所有者权益和负债/实收资本', '/BS/P2000/P2100/P2110', NULL, 1, '0', '1', '1', '2023-03-01 15:00:04', '1', '2023-03-01 15:01:32');
INSERT INTO `qf_subject_international_info` VALUES ('1630825209789550592', 'BS2', 'P2120', '资本公积', 'Additional paid in capital', '€', '3', '1630825087873716224', 1, '/1630784869674127360/1630824894692462592/1630825087873716224/1630825209789550592', '/财务-资产负责类/所有者权益和负债/所有者权益和负债/资本公积', '/BS/P2000/P2100/P2120', NULL, 2, '0', '1', '1', '2023-03-01 15:00:04', '1', '2023-03-01 15:01:32');
INSERT INTO `qf_subject_international_info` VALUES ('1630825210569691136', 'BS2', 'P2130', '未分配利润', 'Retained earnings', '€', '3', '1630825087873716224', 4, '/1630784869674127360/1630824894692462592/1630825087873716224/1630825210569691136', '/财务-资产负责类/所有者权益和负债/所有者权益和负债/未分配利润', '/BS/P2000/P2100/P2130', NULL, 3, '0', '1', '1', '2023-03-01 15:00:04', '1', '2023-03-01 15:01:33');
INSERT INTO `qf_subject_international_info` VALUES ('1630825211165282304', 'BS2', 'P2140', '其他权益组成部分', 'Other components of equity', '€', '3', '1630825087873716224', 4, '/1630784869674127360/1630824894692462592/1630825087873716224/1630825211165282304', '/财务-资产负责类/所有者权益和负债/所有者权益和负债/其他权益组成部分', '/BS/P2000/P2100/P2140', NULL, 4, '0', '1', '1', '2023-03-01 15:00:04', '1', '2023-03-01 15:01:33');
INSERT INTO `qf_subject_international_info` VALUES ('1630825211731513344', 'BS2', 'P2150', '非控制性权益', 'Non-controlling interests', '€', '3', '1630825087873716224', 1, '/1630784869674127360/1630824894692462592/1630825087873716224/1630825211731513344', '/财务-资产负责类/所有者权益和负债/所有者权益和负债/非控制性权益', '/BS/P2000/P2100/P2150', NULL, 5, '0', '1', '1', '2023-03-01 15:00:04', '1', '2023-03-01 15:01:33');
INSERT INTO `qf_subject_international_info` VALUES ('1630825212343881728', 'BS3', 'P2210', '非流动带息贷款和借款', 'Non-current interest-bearing loans and borrowings', '€', '3', '1630825088481890304', 2, '/1630784869674127360/1630824894692462592/1630825088481890304/1630825212343881728', '/财务-资产负责类/所有者权益和负债/非流动负债/非流动带息贷款和借款', '/BS/P2000/P2200/P2210', NULL, 1, '0', '1', '1', '2023-03-01 15:00:05', '1', '2023-03-01 15:01:34');
INSERT INTO `qf_subject_international_info` VALUES ('1630825212905918464', 'BS3', 'P2225', '对关联公司的贷款负债', 'loan liabilities to affiliated companies', '€', '3', '1630825088481890304', 1, '/1630784869674127360/1630824894692462592/1630825088481890304/1630825212905918464', '/财务-资产负责类/所有者权益和负债/非流动负债/对关联公司的贷款负债', '/BS/P2000/P2200/P2225', NULL, 2, '0', '1', '1', '2023-03-01 15:00:05', '1', '2023-03-01 15:01:34');
INSERT INTO `qf_subject_international_info` VALUES ('1630825213480538112', 'BS3', 'P2240', '养老金预计负债', 'Provisions for pensions', '€', '3', '1630825088481890304', 1, '/1630784869674127360/1630824894692462592/1630825088481890304/1630825213480538112', '/财务-资产负责类/所有者权益和负债/非流动负债/养老金预计负债', '/BS/P2000/P2200/P2240', NULL, 3, '0', '1', '1', '2023-03-01 15:00:05', '1', '2023-03-01 15:01:34');
INSERT INTO `qf_subject_international_info` VALUES ('1630825214071934976', 'BS3', 'P2230', '其他非流动预计负债', 'Other non-current provisions', '€', '3', '1630825088481890304', 1, '/1630784869674127360/1630824894692462592/1630825088481890304/1630825214071934976', '/财务-资产负责类/所有者权益和负债/非流动负债/其他非流动预计负债', '/BS/P2000/P2200/P2230', NULL, 4, '0', '1', '1', '2023-03-01 15:00:05', '1', '2023-03-01 15:01:34');
INSERT INTO `qf_subject_international_info` VALUES ('1630825214650748928', 'BS3', 'P2250', '其他非流动负债', 'Other non-current liabilities', '€', '3', '1630825088481890304', 4, '/1630784869674127360/1630824894692462592/1630825088481890304/1630825214650748928', '/财务-资产负责类/所有者权益和负债/非流动负债/其他非流动负债', '/BS/P2000/P2200/P2250', NULL, 5, '0', '1', '1', '2023-03-01 15:00:05', '1', '2023-03-01 15:01:35');
INSERT INTO `qf_subject_international_info` VALUES ('1630825215250534400', 'BS3', 'P2270', '非流动所得税负债', 'Non-current income tax liabilities', '€', '3', '1630825088481890304', 1, '/1630784869674127360/1630824894692462592/1630825088481890304/1630825215250534400', '/财务-资产负责类/所有者权益和负债/非流动负债/非流动所得税负债', '/BS/P2000/P2200/P2270', NULL, 6, '0', '1', '1', '2023-03-01 15:00:05', '1', '2023-03-01 15:01:35');
INSERT INTO `qf_subject_international_info` VALUES ('1630825215812571136', 'BS3', 'P2260', '递延所得税负债', 'Deferred tax liabilities', '€', '3', '1630825088481890304', 1, '/1630784869674127360/1630824894692462592/1630825088481890304/1630825215812571136', '/财务-资产负责类/所有者权益和负债/非流动负债/递延所得税负债', '/BS/P2000/P2200/P2260', NULL, 7, '0', '1', '1', '2023-03-01 15:00:05', '1', '2023-03-01 15:01:35');
INSERT INTO `qf_subject_international_info` VALUES ('1630825216387190784', 'BS3', 'P2310', '应付账款、其他应付款及合同负债', 'Trade and other payables and contract liabilities', '€', '3', '1630825089119424512', 11, '/1630784869674127360/1630824894692462592/1630825089119424512/1630825216387190784', '/财务-资产负责类/所有者权益和负债/流动负债/应付账款、其他应付款及合同负债', '/BS/P2000/P2300/P2310', NULL, 1, '0', '1', '1', '2023-03-01 15:00:06', '1', '2023-03-01 15:01:36');
INSERT INTO `qf_subject_international_info` VALUES ('1630825217146359808', 'BS3', 'P2317', '关联公司应付款', 'trade  payables  affiliated companies', '€', '3', '1630825089119424512', 1, '/1630784869674127360/1630824894692462592/1630825089119424512/1630825217146359808', '/财务-资产负责类/所有者权益和负债/流动负债/关联公司应付款', '/BS/P2000/P2300/P2317', NULL, 2, '0', '1', '1', '2023-03-01 15:00:06', '1', '2023-03-01 15:01:37');
INSERT INTO `qf_subject_international_info` VALUES ('1630825217716785152', 'BS3', 'P2320', '流动带息贷款和借款', 'Current interest-bearing loans and borrowings', '€', '3', '1630825089119424512', 3, '/1630784869674127360/1630824894692462592/1630825089119424512/1630825217716785152', '/财务-资产负责类/所有者权益和负债/流动负债/流动带息贷款和借款', '/BS/P2000/P2300/P2320', NULL, 3, '0', '1', '1', '2023-03-01 15:00:06', '1', '2023-03-01 15:01:37');
INSERT INTO `qf_subject_international_info` VALUES ('1630825218303987712', 'BS3', 'P2330', '以公允价值计量的金融工具', 'Financial instruments measured at fair value', '€', '3', '1630825089119424512', 1, '/1630784869674127360/1630824894692462592/1630825089119424512/1630825218303987712', '/财务-资产负责类/所有者权益和负债/流动负债/以公允价值计量的金融工具', '/BS/P2000/P2300/P2330', NULL, 4, '0', '1', '1', '2023-03-01 15:00:06', '1', '2023-03-01 15:01:37');
INSERT INTO `qf_subject_international_info` VALUES ('1630825218941521920', 'BS3', 'P2350', '其他流动预计负债', 'Other current provisions', '€', '3', '1630825089119424512', 1, '/1630784869674127360/1630824894692462592/1630825089119424512/1630825218941521920', '/财务-资产负责类/所有者权益和负债/流动负债/其他流动预计负债', '/BS/P2000/P2300/P2350', NULL, 5, '0', '1', '1', '2023-03-01 15:00:06', '1', '2023-03-01 15:01:37');
INSERT INTO `qf_subject_international_info` VALUES ('1630825219503558656', 'BS3', 'P2340', '所得税负债', 'Income tax liabilities', '€', '3', '1630825089119424512', 1, '/1630784869674127360/1630824894692462592/1630825089119424512/1630825219503558656', '/财务-资产负责类/所有者权益和负债/流动负债/所得税负债', '/BS/P2000/P2300/P2340', NULL, 6, '0', '1', '1', '2023-03-01 15:00:06', '1', '2023-03-01 15:01:37');
INSERT INTO `qf_subject_international_info` VALUES ('1630825548529930240', 'BS1', '111100', '订单簿', 'Order Book', '€', '4', '1630825197982584832', 2, '/1630784869674127360/1630824894071705600/1630825086661562368/1630825197982584832/1630825548529930240', '/财务-资产负责类/资产/非流动资产/无形资产/订单簿', '/BS/A1000/A1100/A1120/111100', NULL, 1, '0', '1', '1', '2023-03-01 15:01:25', '1', '2023-03-01 15:02:16');
INSERT INTO `qf_subject_international_info` VALUES ('1630825549297487872', 'BS1', '111300', '客户关系', 'Customer Relationship Industry', '€', '4', '1630825197982584832', 2, '/1630784869674127360/1630824894071705600/1630825086661562368/1630825197982584832/1630825549297487872', '/财务-资产负责类/资产/非流动资产/无形资产/客户关系', '/BS/A1000/A1100/A1120/111300', NULL, 2, '0', '1', '1', '2023-03-01 15:01:25', '1', '2023-03-01 15:02:16');
INSERT INTO `qf_subject_international_info` VALUES ('1630825549905661952', 'BS1', '111500', '其他无形资产', 'Other intangible assets', '€', '4', '1630825197982584832', 2, '/1630784869674127360/1630824894071705600/1630825086661562368/1630825197982584832/1630825549905661952', '/财务-资产负责类/资产/非流动资产/无形资产/其他无形资产', '/BS/A1000/A1100/A1120/111500', NULL, 3, '0', '1', '1', '2023-03-01 15:01:25', '1', '2023-03-01 15:02:16');
INSERT INTO `qf_subject_international_info` VALUES ('1630825550639665152', 'BS1', '111600', '开发', 'Development', '€', '4', '1630825197982584832', 3, '/1630784869674127360/1630824894071705600/1630825086661562368/1630825197982584832/1630825550639665152', '/财务-资产负责类/资产/非流动资产/无形资产/开发', '/BS/A1000/A1100/A1120/111600', NULL, 4, '0', '1', '1', '2023-03-01 15:01:25', '1', '2023-03-01 15:02:17');
INSERT INTO `qf_subject_international_info` VALUES ('1630825551373668352', 'BS1', '111700', '软件', 'Software', '€', '4', '1630825197982584832', 2, '/1630784869674127360/1630824894071705600/1630825086661562368/1630825197982584832/1630825551373668352', '/财务-资产负责类/资产/非流动资产/无形资产/软件', '/BS/A1000/A1100/A1120/111700', NULL, 5, '0', '1', '1', '2023-03-01 15:01:25', '1', '2023-03-01 15:02:17');
INSERT INTO `qf_subject_international_info` VALUES ('1630825551969259520', 'BS1', '111800', '特许权/许可证/专利', 'Consessions/Licenses/Patents', '€', '4', '1630825197982584832', 2, '/1630784869674127360/1630824894071705600/1630825086661562368/1630825197982584832/1630825551969259520', '/财务-资产负责类/资产/非流动资产/无形资产/特许权/许可证/专利', '/BS/A1000/A1100/A1120/111800', NULL, 6, '0', '1', '1', '2023-03-01 15:01:26', '1', '2023-03-01 15:02:18');
INSERT INTO `qf_subject_international_info` VALUES ('1630825552531296256', 'BS1', '111900', '商誉', 'Goodwill', '€', '4', '1630825197982584832', 2, '/1630784869674127360/1630824894071705600/1630825086661562368/1630825197982584832/1630825552531296256', '/财务-资产负责类/资产/非流动资产/无形资产/商誉', '/BS/A1000/A1100/A1120/111900', NULL, 7, '0', '1', '1', '2023-03-01 15:01:26', '1', '2023-03-01 15:02:18');
INSERT INTO `qf_subject_international_info` VALUES ('1630825553160441856', 'BS1', '112430', '无形资产预付款', 'prepayments on intangible assets', '€', '4', '1630825197982584832', 0, '/1630784869674127360/1630824894071705600/1630825086661562368/1630825197982584832/1630825553160441856', '/财务-资产负责类/资产/非流动资产/无形资产/无形资产预付款', '/BS/A1000/A1100/A1120/112430', NULL, 8, '0', '1', '1', '2023-03-01 15:01:26', '1', '2023-03-01 15:01:26');
INSERT INTO `qf_subject_international_info` VALUES ('1630825553764421632', 'BS1', '112100', '不动产', 'Real Estate, Right equivalent to a Real Property Right', '€', '4', '1630825198599147520', 3, '/1630784869674127360/1630824894071705600/1630825086661562368/1630825198599147520/1630825553764421632', '/财务-资产负责类/资产/非流动资产/固定资产/不动产', '/BS/A1000/A1100/A1110/112100', NULL, 1, '0', '1', '1', '2023-03-01 15:01:26', '1', '2023-03-01 15:02:18');
INSERT INTO `qf_subject_international_info` VALUES ('1630825554401955840', 'BS1', '112150', '不动产折旧', 'Real Estate, Right equivalent to a Real Property Right - depreciation', '€', '4', '1630825198599147520', 2, '/1630784869674127360/1630824894071705600/1630825086661562368/1630825198599147520/1630825554401955840', '/财务-资产负责类/资产/非流动资产/固定资产/不动产折旧', '/BS/A1000/A1100/A1110/112150', NULL, 2, '0', '1', '1', '2023-03-01 15:01:26', '1', '2023-03-01 15:02:19');
INSERT INTO `qf_subject_international_info` VALUES ('1630825554984964096', 'BS1', '112190', '不动产减值', 'Real Estate, Right equivalent to a Real Property Right - Impairment', '€', '4', '1630825198599147520', 2, '/1630784869674127360/1630824894071705600/1630825086661562368/1630825198599147520/1630825554984964096', '/财务-资产负责类/资产/非流动资产/固定资产/不动产减值', '/BS/A1000/A1100/A1110/112190', NULL, 3, '0', '1', '1', '2023-03-01 15:01:26', '1', '2023-03-01 15:02:19');
INSERT INTO `qf_subject_international_info` VALUES ('1630825555572166656', 'BS1', '112200', '技术资产及机器设备', 'Technical Assets and Machinery', '€', '4', '1630825198599147520', 3, '/1630784869674127360/1630824894071705600/1630825086661562368/1630825198599147520/1630825555572166656', '/财务-资产负责类/资产/非流动资产/固定资产/技术资产及机器设备', '/BS/A1000/A1100/A1110/112200', NULL, 4, '0', '1', '1', '2023-03-01 15:01:26', '1', '2023-03-01 15:02:19');
INSERT INTO `qf_subject_international_info` VALUES ('1630825556142592000', 'BS1', '112250', '技术资产及机器设备折旧', 'Technical Assets and Machinery - depreciation', '€', '4', '1630825198599147520', 2, '/1630784869674127360/1630824894071705600/1630825086661562368/1630825198599147520/1630825556142592000', '/财务-资产负责类/资产/非流动资产/固定资产/技术资产及机器设备折旧', '/BS/A1000/A1100/A1110/112250', NULL, 5, '0', '1', '1', '2023-03-01 15:01:27', '1', '2023-03-01 15:02:20');
INSERT INTO `qf_subject_international_info` VALUES ('1630825556780126208', 'BS1', '112290', '技术资产及机器设备减值', 'Technical Assets and Machinery - impairment', '€', '4', '1630825198599147520', 2, '/1630784869674127360/1630824894071705600/1630825086661562368/1630825198599147520/1630825556780126208', '/财务-资产负责类/资产/非流动资产/固定资产/技术资产及机器设备减值', '/BS/A1000/A1100/A1110/112290', NULL, 6, '0', '1', '1', '2023-03-01 15:01:27', '1', '2023-03-01 15:02:20');
INSERT INTO `qf_subject_international_info` VALUES ('1630825557409271808', 'BS1', '112300', '其他设备、工厂及办公设备', 'other equipment, factory and office equipment', '€', '4', '1630825198599147520', 4, '/1630784869674127360/1630824894071705600/1630825086661562368/1630825198599147520/1630825557409271808', '/财务-资产负责类/资产/非流动资产/固定资产/其他设备、工厂及办公设备', '/BS/A1000/A1100/A1110/112300', NULL, 7, '0', '1', '1', '2023-03-01 15:01:27', '1', '2023-03-01 15:02:20');
INSERT INTO `qf_subject_international_info` VALUES ('1630825558046806016', 'BS1', '112350', '其他设备、工厂及办公设备折旧', 'other equipment, factory and office equipment - depreciation', '€', '4', '1630825198599147520', 4, '/1630784869674127360/1630824894071705600/1630825086661562368/1630825198599147520/1630825558046806016', '/财务-资产负责类/资产/非流动资产/固定资产/其他设备、工厂及办公设备折旧', '/BS/A1000/A1100/A1110/112350', NULL, 8, '0', '1', '1', '2023-03-01 15:01:27', '1', '2023-03-01 15:02:21');
INSERT INTO `qf_subject_international_info` VALUES ('1630825558684340224', 'BS1', '112390', '其他设备、工厂及办公设备减值', 'other equipment, factory and office equipment - impairment', '€', '4', '1630825198599147520', 2, '/1630784869674127360/1630824894071705600/1630825086661562368/1630825198599147520/1630825558684340224', '/财务-资产负责类/资产/非流动资产/固定资产/其他设备、工厂及办公设备减值', '/BS/A1000/A1100/A1110/112390', NULL, 9, '0', '1', '1', '2023-03-01 15:01:27', '1', '2023-03-01 15:02:21');
INSERT INTO `qf_subject_international_info` VALUES ('1630825559275737088', 'BS1', '112400', '预付款及在建工程', 'Prepayments & construction in progress', '€', '4', '1630825198599147520', 2, '/1630784869674127360/1630824894071705600/1630825086661562368/1630825198599147520/1630825559275737088', '/财务-资产负责类/资产/非流动资产/固定资产/预付款及在建工程', '/BS/A1000/A1100/A1110/112400', NULL, 10, '0', '1', '1', '2023-03-01 15:01:27', '1', '2023-03-01 15:02:22');
INSERT INTO `qf_subject_international_info` VALUES ('1630825560747937792', 'BS1', '111949', '使用权资产', 'Right of use asset', '€', '4', '1630825199190544384', 7, '/1630784869674127360/1630824894071705600/1630825086661562368/1630825199190544384/1630825560747937792', '/财务-资产负责类/资产/非流动资产/使用权资产/使用权资产', '/BS/A1000/A1100/A1115/111949', NULL, 1, '0', '1', '1', '2023-03-01 15:01:28', '1', '2023-03-01 15:02:23');
INSERT INTO `qf_subject_international_info` VALUES ('1630825561473552384', 'BS1', 'A11110', '融资租赁', 'Finance lease', '€', '4', '1630825199773552640', 1, '/1630784869674127360/1630824894071705600/1630825086661562368/1630825199773552640/1630825561473552384', '/财务-资产负责类/资产/非流动资产/融资租赁/融资租赁', '/BS/A1000/A1100/A1111/A11110', NULL, 1, '0', '1', '1', '2023-03-01 15:01:28', '1', '2023-03-01 15:02:23');
INSERT INTO `qf_subject_international_info` VALUES ('1630825562056560640', 'BS1', 'A11115', '融资租赁—折旧', 'Finance lease - depreciation', '€', '4', '1630825199773552640', 1, '/1630784869674127360/1630824894071705600/1630825086661562368/1630825199773552640/1630825562056560640', '/财务-资产负责类/资产/非流动资产/融资租赁/融资租赁—折旧', '/BS/A1000/A1100/A1111/A11115', NULL, 2, '0', '1', '1', '2023-03-01 15:01:28', '1', '2023-03-01 15:02:23');
INSERT INTO `qf_subject_international_info` VALUES ('1630825562643763200', 'BS1', '113100', '关联公司股份', 'Shares in affiliated companies', '€', '4', '1630825200381726720', 26, '/1630784869674127360/1630824894071705600/1630825086661562368/1630825200381726720/1630825562643763200', '/财务-资产负责类/资产/非流动资产/对关联公司股份/关联公司股份', '/BS/A1000/A1100/A1125/113100', NULL, 1, '0', '1', '1', '2023-03-01 15:01:28', '1', '2023-03-01 15:02:27');
INSERT INTO `qf_subject_international_info` VALUES ('1630825563268714496', 'BS1', 'A1141', '保证金', 'Deposits', '€', '4', '1630825201019260928', 1, '/1630784869674127360/1630824894071705600/1630825086661562368/1630825201019260928/1630825563268714496', '/财务-资产负责类/资产/非流动资产/其他非流动金融资产/保证金', '/BS/A1000/A1100/A1140/A1141', NULL, 1, '0', '1', '1', '2023-03-01 15:01:28', '1', '2023-03-01 15:02:27');
INSERT INTO `qf_subject_international_info` VALUES ('1630825563855917056', 'BS1', '113250', '投资', 'Investments', '€', '4', '1630825201019260928', 1, '/1630784869674127360/1630824894071705600/1630825086661562368/1630825201019260928/1630825563855917056', '/财务-资产负责类/资产/非流动资产/其他非流动金融资产/投资', '/BS/A1000/A1100/A1140/113250', NULL, 2, '0', '1', '1', '2023-03-01 15:01:28', '1', '2023-03-01 15:02:27');
INSERT INTO `qf_subject_international_info` VALUES ('1630825564464091136', 'BS1', 'A1151', '贸易应收款和其他应收款', 'Trade receivables and Other receivables', '€', '4', '1630825201635823616', 4, '/1630784869674127360/1630824894071705600/1630825086661562368/1630825201635823616/1630825564464091136', '/财务-资产负责类/资产/非流动资产/其他非流动应收账款/贸易应收款和其他应收款', '/BS/A1000/A1100/A1150/A1151', NULL, 1, '0', '1', '1', '2023-03-01 15:01:29', '1', '2023-03-01 15:02:27');
INSERT INTO `qf_subject_international_info` VALUES ('1630825565055488000', 'BS1', 'A1166', '非流动所得税资产', 'Non-current income tax assets', '€', '4', '1630825202332078080', 1, '/1630784869674127360/1630824894071705600/1630825086661562368/1630825202332078080/1630825565055488000', '/财务-资产负责类/资产/非流动资产/非流动所得税资产/非流动所得税资产', '/BS/A1000/A1100/A1165/A1166', NULL, 1, '0', '1', '1', '2023-03-01 15:01:29', '1', '2023-03-01 15:02:28');
INSERT INTO `qf_subject_international_info` VALUES ('1630825565672050688', 'BS1', '141100', '递延所得税资产', '** Deferred tax assets', '€', '4', '1630825202919280640', 2, '/1630784869674127360/1630824894071705600/1630825086661562368/1630825202919280640/1630825565672050688', '/财务-资产负责类/资产/非流动资产/递延所得说资产/递延所得税资产', '/BS/A1000/A1100/A1160/141100', NULL, 1, '0', '1', '1', '2023-03-01 15:01:29', '1', '2023-03-01 15:02:28');
INSERT INTO `qf_subject_international_info` VALUES ('1630825566250864640', 'BS1', '121100', '原材料及供应', 'Raw Materials and supplies', '€', '4', '1630825203519066112', 4, '/1630784869674127360/1630824894071705600/1630825087282319360/1630825203519066112/1630825566250864640', '/财务-资产负责类/资产/流动资产/存货/原材料及供应', '/BS/A1000/A1200/A1210/121100', NULL, 1, '0', '1', '1', '2023-03-01 15:01:29', '1', '2023-03-01 15:02:29');
INSERT INTO `qf_subject_international_info` VALUES ('1630825566833872896', 'BS1', '121200', '半成品', 'Semi finished goods', '€', '4', '1630825203519066112', 4, '/1630784869674127360/1630824894071705600/1630825087282319360/1630825203519066112/1630825566833872896', '/财务-资产负责类/资产/流动资产/存货/半成品', '/BS/A1000/A1200/A1210/121200', NULL, 2, '0', '1', '1', '2023-03-01 15:01:29', '1', '2023-03-01 15:02:29');
INSERT INTO `qf_subject_international_info` VALUES ('1630825567421075456', 'BS1', '121300', '产成品', 'Finished Goods', '€', '4', '1630825203519066112', 2, '/1630784869674127360/1630824894071705600/1630825087282319360/1630825203519066112/1630825567421075456', '/财务-资产负责类/资产/流动资产/存货/产成品', '/BS/A1000/A1200/A1210/121300', NULL, 3, '0', '1', '1', '2023-03-01 15:01:29', '1', '2023-03-01 15:02:30');
INSERT INTO `qf_subject_international_info` VALUES ('1630825568926830592', 'BS1', '121400', '商品', 'Merchandise', '€', '4', '1630825203519066112', 2, '/1630784869674127360/1630824894071705600/1630825087282319360/1630825203519066112/1630825568926830592', '/财务-资产负责类/资产/流动资产/存货/商品', '/BS/A1000/A1200/A1210/121400', NULL, 4, '0', '1', '1', '2023-03-01 15:01:30', '1', '2023-03-01 15:02:30');
INSERT INTO `qf_subject_international_info` VALUES ('1630825569736331264', 'BS1', '121500', '在产品/半成品', 'Work in progress', '€', '4', '1630825203519066112', 4, '/1630784869674127360/1630824894071705600/1630825087282319360/1630825203519066112/1630825569736331264', '/财务-资产负责类/资产/流动资产/存货/在产品/半成品', '/BS/A1000/A1200/A1210/121500', NULL, 5, '0', '1', '1', '2023-03-01 15:01:30', '1', '2023-03-01 15:02:31');
INSERT INTO `qf_subject_international_info` VALUES ('1630825570390642688', 'BS1', '121600', '在途产品/材料', 'Goods/Material in Transit', '€', '4', '1630825203519066112', 2, '/1630784869674127360/1630824894071705600/1630825087282319360/1630825203519066112/1630825570390642688', '/财务-资产负责类/资产/流动资产/存货/在途产品/材料', '/BS/A1000/A1200/A1210/121600', NULL, 6, '0', '1', '1', '2023-03-01 15:01:30', '1', '2023-03-01 15:02:31');
INSERT INTO `qf_subject_international_info` VALUES ('1630825570977845248', 'BS1', '121700', '设备备件', 'Spareparts for equipment', '€', '4', '1630825203519066112', 1, '/1630784869674127360/1630824894071705600/1630825087282319360/1630825203519066112/1630825570977845248', '/财务-资产负责类/资产/流动资产/存货/设备备件', '/BS/A1000/A1200/A1210/121700', NULL, 7, '0', '1', '1', '2023-03-01 15:01:30', '1', '2023-03-01 15:02:32');
INSERT INTO `qf_subject_international_info` VALUES ('1630825571569242112', 'BS1', '122100', '应收账款及合同资产', 'Trade receivables and contract assets', '€', '4', '1630825204102074368', 8, '/1630784869674127360/1630824894071705600/1630825087282319360/1630825204102074368/1630825571569242112', '/财务-资产负责类/资产/流动资产/应收账款和其他资产/应收账款及合同资产', '/BS/A1000/A1200/A1220/122100', NULL, 1, '0', '1', '1', '2023-03-01 15:01:30', '1', '2023-03-01 15:02:33');
INSERT INTO `qf_subject_international_info` VALUES ('1630825572169027584', 'BS1', 'A1221', '其他资产', 'other assets', '€', '4', '1630825204102074368', 2, '/1630784869674127360/1630824894071705600/1630825087282319360/1630825204102074368/1630825572169027584', '/财务-资产负责类/资产/流动资产/应收账款和其他资产/其他资产', '/BS/A1000/A1200/A1220/A1221', NULL, 2, '0', '1', '1', '2023-03-01 15:01:30', '1', '2023-03-01 15:02:33');
INSERT INTO `qf_subject_international_info` VALUES ('1630825572739452928', 'BS1', '131100', '预付费用', '** Prepaid expenses', '€', '4', '1630825204102074368', 6, '/1630784869674127360/1630824894071705600/1630825087282319360/1630825204102074368/1630825572739452928', '/财务-资产负责类/资产/流动资产/应收账款和其他资产/预付费用', '/BS/A1000/A1200/A1220/131100', NULL, 3, '0', '1', '1', '2023-03-01 15:01:31', '1', '2023-03-01 15:02:34');
INSERT INTO `qf_subject_international_info` VALUES ('1630825573649616896', 'BS1', '122200', '附属公司间应收账款', 'Trade receivables consolidated companies', '€', '4', '1630825205607829504', 26, '/1630784869674127360/1630824894071705600/1630825087282319360/1630825205607829504/1630825573649616896', '/财务-资产负责类/资产/流动资产/应收关联公司款项/附属公司间应收账款', '/BS/A1000/A1200/A1225/122200', NULL, 1, '0', '1', '1', '2023-03-01 15:01:31', '1', '2023-03-01 15:02:38');
INSERT INTO `qf_subject_international_info` VALUES ('1630825574438146048', 'BS1', '122300', '应收附属公司间贷款', 'Loan receivables consolidated companies', '€', '4', '1630825206216003584', 25, '/1630784869674127360/1630824894071705600/1630825087282319360/1630825206216003584/1630825574438146048', '/财务-资产负责类/资产/流动资产/应收关联公司贷款/应收附属公司间贷款', '/BS/A1000/A1200/A1227/122300', NULL, 1, '0', '1', '1', '2023-03-01 15:01:31', '1', '2023-03-01 15:02:42');
INSERT INTO `qf_subject_international_info` VALUES ('1630825575016960000', 'BS1', '122450', '附属公司间预付账款', 'advance payments affiliated companies', '€', '4', '1630825206824177664', 0, '/1630784869674127360/1630824894071705600/1630825087282319360/1630825206824177664/1630825575016960000', '/财务-资产负责类/资产/流动资产/预付账款/附属公司间预付账款', '/BS/A1000/A1200/A1230/122450', NULL, 1, '0', '1', '1', '2023-03-01 15:01:31', '1', '2023-03-01 15:01:31');
INSERT INTO `qf_subject_international_info` VALUES ('1630825575620939776', 'BS1', '122451', '给第三方预付账款', 'Prepayments to third parties', '€', '4', '1630825206824177664', 0, '/1630784869674127360/1630824894071705600/1630825087282319360/1630825206824177664/1630825575620939776', '/财务-资产负责类/资产/流动资产/预付账款/给第三方预付账款', '/BS/A1000/A1200/A1230/122451', NULL, 2, '0', '1', '1', '2023-03-01 15:01:31', '1', '2023-03-01 15:01:31');
INSERT INTO `qf_subject_international_info` VALUES ('1630825576208142336', 'BS1', 'A1233', '流动所得税资产', 'Current income tax assets', '€', '4', '1630825207423963136', 2, '/1630784869674127360/1630824894071705600/1630825087282319360/1630825207423963136/1630825576208142336', '/财务-资产负责类/资产/流动资产/流动所得税资产/流动所得税资产', '/BS/A1000/A1200/A1232/A1233', NULL, 1, '0', '1', '1', '2023-03-01 15:01:31', '1', '2023-03-01 15:02:42');
INSERT INTO `qf_subject_international_info` VALUES ('1630825576820510720', 'BS1', 'A1236', '以公允价值计量的金融工具', 'Financial instruments measured at fair value', '€', '4', '1630825208011165696', 5, '/1630784869674127360/1630824894071705600/1630825087282319360/1630825208011165696/1630825576820510720', '/财务-资产负责类/资产/流动资产/以公允价值计量的金融工具/以公允价值计量的金融工具', '/BS/A1000/A1200/A1235/A1236', NULL, 1, '0', '1', '1', '2023-03-01 15:01:31', '1', '2023-03-01 15:02:43');
INSERT INTO `qf_subject_international_info` VALUES ('1630825577399324672', 'BS1', '123100', '支票、现金、银行存款', '* Cheques, Cash, Bank', '€', '4', '1630825208610951168', 4, '/1630784869674127360/1630824894071705600/1630825087282319360/1630825208610951168/1630825577399324672', '/财务-资产负责类/资产/流动资产/现金和现金等价物/支票、现金、银行存款', '/BS/A1000/A1200/A1240/123100', NULL, 1, '0', '1', '1', '2023-03-01 15:01:32', '1', '2023-03-01 15:02:43');
INSERT INTO `qf_subject_international_info` VALUES ('1630825578015887360', 'BS2', '211100', '实收资本', 'Subscribed capital', '€', '4', '1630825209185570816', 2, '/1630784869674127360/1630824894692462592/1630825087873716224/1630825209185570816/1630825578015887360', '/财务-资产负责类/所有者权益和负债/所有者权益和负债/实收资本/实收资本', '/BS/P2000/P2100/P2110/211100', NULL, 1, '0', '1', '1', '2023-03-01 15:01:32', '1', '2023-03-01 15:02:44');
INSERT INTO `qf_subject_international_info` VALUES ('1630825578603089920', 'BS2', 'P2121', '资本公积', 'Additional paid in capital', '€', '4', '1630825209789550592', 2, '/1630784869674127360/1630824894692462592/1630825087873716224/1630825209789550592/1630825578603089920', '/财务-资产负责类/所有者权益和负债/所有者权益和负债/资本公积/资本公积', '/BS/P2000/P2100/P2120/P2121', NULL, 1, '0', '1', '1', '2023-03-01 15:01:32', '1', '2023-03-01 15:02:44');
INSERT INTO `qf_subject_international_info` VALUES ('1630825579202875392', 'BS2', '213100', '利润/亏损的结转-留存收益部分', 'Profit / loss carried forward - retained', '€', '4', '1630825210569691136', 8, '/1630784869674127360/1630824894692462592/1630825087873716224/1630825210569691136/1630825579202875392', '/财务-资产负责类/所有者权益和负债/所有者权益和负债/未分配利润/利润/亏损的结转-留存收益部分', '/BS/P2000/P2100/P2130/213100', NULL, 1, '0', '1', '1', '2023-03-01 15:01:32', '1', '2023-03-01 15:02:45');
INSERT INTO `qf_subject_international_info` VALUES ('1630825579848798208', 'BS2', '213110', '利润/亏损的结转-股利部分', 'Profit / loss carried forward - Dividends', '€', '4', '1630825210569691136', 1, '/1630784869674127360/1630824894692462592/1630825087873716224/1630825210569691136/1630825579848798208', '/财务-资产负责类/所有者权益和负债/所有者权益和负债/未分配利润/利润/亏损的结转-股利部分', '/BS/P2000/P2100/P2130/213110', NULL, 2, '0', '1', '1', '2023-03-01 15:01:32', '1', '2023-03-01 15:02:45');
INSERT INTO `qf_subject_international_info` VALUES ('1630825580431806464', 'BS2', '219300', '少数股东损益', 'Non controlling interests', '€', '4', '1630825210569691136', 1, '/1630784869674127360/1630824894692462592/1630825087873716224/1630825210569691136/1630825580431806464', '/财务-资产负责类/所有者权益和负债/所有者权益和负债/未分配利润/少数股东损益', '/BS/P2000/P2100/P2130/219300', NULL, 3, '0', '1', '1', '2023-03-01 15:01:32', '1', '2023-03-01 15:02:45');
INSERT INTO `qf_subject_international_info` VALUES ('1630825581031591936', 'BS2', '219200', '当期净利润', 'Net result of the periode', '€', '4', '1630825210569691136', 1, '/1630784869674127360/1630824894692462592/1630825087873716224/1630825210569691136/1630825581031591936', '/财务-资产负责类/所有者权益和负债/所有者权益和负债/未分配利润/当期净利润', '/BS/P2000/P2100/P2130/219200', NULL, 4, '0', '1', '1', '2023-03-01 15:01:32', '1', '2023-03-01 15:02:45');
INSERT INTO `qf_subject_international_info` VALUES ('1630825581635571712', 'BS2', '219100', '货币折算差额', 'Currency translation differences', '€', '4', '1630825211165282304', 1, '/1630784869674127360/1630824894692462592/1630825087873716224/1630825211165282304/1630825581635571712', '/财务-资产负责类/所有者权益和负债/所有者权益和负债/其他权益组成部分/货币折算差额', '/BS/P2000/P2100/P2140/219100', NULL, 1, '0', '1', '1', '2023-03-01 15:01:33', '1', '2023-03-01 15:02:46');
INSERT INTO `qf_subject_international_info` VALUES ('1630825582222774272', 'BS2', 'P2142', '其他综合收益', 'Other OCI items', '€', '4', '1630825211165282304', 2, '/1630784869674127360/1630824894692462592/1630825087873716224/1630825211165282304/1630825582222774272', '/财务-资产负责类/所有者权益和负债/所有者权益和负债/其他权益组成部分/其他综合收益', '/BS/P2000/P2100/P2140/P2142', NULL, 2, '0', '1', '1', '2023-03-01 15:01:33', '1', '2023-03-01 15:02:46');
INSERT INTO `qf_subject_international_info` VALUES ('1630825582822559744', 'BS2', 'P2143', '重新测量', 'Remeasurments', '€', '4', '1630825211165282304', 2, '/1630784869674127360/1630824894692462592/1630825087873716224/1630825211165282304/1630825582822559744', '/财务-资产负责类/所有者权益和负债/所有者权益和负债/其他权益组成部分/重新测量', '/BS/P2000/P2100/P2140/P2143', NULL, 3, '0', '1', '1', '2023-03-01 15:01:33', '1', '2023-03-01 15:02:46');
INSERT INTO `qf_subject_international_info` VALUES ('1630825583409762304', 'BS2', 'P2141', '法定储备', 'statutory reserves', '€', '4', '1630825211165282304', 1, '/1630784869674127360/1630824894692462592/1630825087873716224/1630825211165282304/1630825583409762304', '/财务-资产负责类/所有者权益和负债/所有者权益和负债/其他权益组成部分/法定储备', '/BS/P2000/P2100/P2140/P2141', NULL, 4, '0', '1', '1', '2023-03-01 15:01:33', '1', '2023-03-01 15:02:46');
INSERT INTO `qf_subject_international_info` VALUES ('1630825584089239552', 'BS2', '214100', '非控制性权益', 'Non controlling interests', '€', '4', '1630825211731513344', 1, '/1630784869674127360/1630824894692462592/1630825087873716224/1630825211731513344/1630825584089239552', '/财务-资产负责类/所有者权益和负债/所有者权益和负债/非控制性权益/非控制性权益', '/BS/P2000/P2100/P2150/214100', NULL, 1, '0', '1', '1', '2023-03-01 15:01:33', '1', '2023-03-01 15:02:46');
INSERT INTO `qf_subject_international_info` VALUES ('1630825584668053504', 'BS3', '231200', '长期银行及类似借款', 'long term bank and similiar loans', '€', '4', '1630825212343881728', 4, '/1630784869674127360/1630824894692462592/1630825088481890304/1630825212343881728/1630825584668053504', '/财务-资产负责类/所有者权益和负债/非流动负债/非流动带息贷款和借款/长期银行及类似借款', '/BS/P2000/P2200/P2210/231200', NULL, 1, '0', '1', '1', '2023-03-01 15:01:33', '1', '2023-03-01 15:02:47');
INSERT INTO `qf_subject_international_info` VALUES ('1630825585347530752', 'BS3', '231050', '其他贷款和借款', 'Other loans and borrowings', '€', '4', '1630825212343881728', 2, '/1630784869674127360/1630824894692462592/1630825088481890304/1630825212343881728/1630825585347530752', '/财务-资产负责类/所有者权益和负债/非流动负债/非流动带息贷款和借款/其他贷款和借款', '/BS/P2000/P2200/P2210/231050', NULL, 1, '0', '1', '1', '2023-03-01 15:01:34', '1', '2023-03-01 15:02:47');
INSERT INTO `qf_subject_international_info` VALUES ('1630825585922150400', 'BS3', '235200', '应付关联公司的贷款', 'Liabilities loan consolidated companies', '€', '4', '1630825212905918464', 25, '/1630784869674127360/1630824894692462592/1630825088481890304/1630825212905918464/1630825585922150400', '/财务-资产负责类/所有者权益和负债/非流动负债/对关联公司的贷款负债/应付关联公司的贷款', '/BS/P2000/P2200/P2225/235200', NULL, 1, '0', '1', '1', '2023-03-01 15:01:34', '1', '2023-03-01 15:02:51');
INSERT INTO `qf_subject_international_info` VALUES ('1630825586459021312', 'BS3', '221100', '养老金预计负债', 'Provisions for pensions', '€', '4', '1630825213480538112', 2, '/1630784869674127360/1630824894692462592/1630825088481890304/1630825213480538112/1630825586459021312', '/财务-资产负责类/所有者权益和负债/非流动负债/养老金预计负债/养老金预计负债', '/BS/P2000/P2200/P2240/221100', NULL, 1, '0', '1', '1', '2023-03-01 15:01:34', '1', '2023-03-01 15:02:51');
INSERT INTO `qf_subject_international_info` VALUES ('1630825587046223872', 'BS3', '223100', '其他非流动预计负债', 'Other non-current provisions', '€', '4', '1630825214071934976', 2, '/1630784869674127360/1630824894692462592/1630825088481890304/1630825214071934976/1630825587046223872', '/财务-资产负责类/所有者权益和负债/非流动负债/其他非流动预计负债/其他非流动预计负债', '/BS/P2000/P2200/P2230/223100', NULL, 1, '0', '1', '1', '2023-03-01 15:01:34', '1', '2023-03-01 15:02:51');
INSERT INTO `qf_subject_international_info` VALUES ('1630825587646009344', 'BS3', '233300', '长期应付账款', 'Trade Payables long term', '€', '4', '1630825214650748928', 8, '/1630784869674127360/1630824894692462592/1630825088481890304/1630825214650748928/1630825587646009344', '/财务-资产负责类/所有者权益和负债/非流动负债/其他非流动负债/长期应付账款', '/BS/P2000/P2200/P2250/233300', NULL, 1, '0', '1', '1', '2023-03-01 15:01:34', '1', '2023-03-01 15:02:52');
INSERT INTO `qf_subject_international_info` VALUES ('1630825588312903680', 'BS3', '237100', '应交税费', 'taxes', '€', '4', '1630825214650748928', 1, '/1630784869674127360/1630824894692462592/1630825088481890304/1630825214650748928/1630825588312903680', '/财务-资产负责类/所有者权益和负债/非流动负债/其他非流动负债/应交税费', '/BS/P2000/P2200/P2250/237100', NULL, 2, '0', '1', '1', '2023-03-01 15:01:34', '1', '2023-03-01 15:02:53');
INSERT INTO `qf_subject_international_info` VALUES ('1630825588879134720', 'BS3', '237200', '长期应付职工薪酬', 'Owed to employees', '€', '4', '1630825214650748928', 10, '/1630784869674127360/1630824894692462592/1630825088481890304/1630825214650748928/1630825588879134720', '/财务-资产负责类/所有者权益和负债/非流动负债/其他非流动负债/长期应付职工薪酬', '/BS/P2000/P2200/P2250/237200', NULL, 3, '0', '1', '1', '2023-03-01 15:01:34', '1', '2023-03-01 15:02:54');
INSERT INTO `qf_subject_international_info` VALUES ('1630825589436977152', 'BS3', '237400', '其他负债', 'others liabilities', '€', '4', '1630825214650748928', 1, '/1630784869674127360/1630824894692462592/1630825088481890304/1630825214650748928/1630825589436977152', '/财务-资产负责类/所有者权益和负债/非流动负债/其他非流动负债/其他负债', '/BS/P2000/P2200/P2250/237400', NULL, 4, '0', '1', '1', '2023-03-01 15:01:35', '1', '2023-03-01 15:02:54');
INSERT INTO `qf_subject_international_info` VALUES ('1630825590024179712', 'BS3', '234300', '一年以上的应交所得税', 'Liabilities for income taxes long term > one year', '€', '4', '1630825215250534400', 2, '/1630784869674127360/1630824894692462592/1630825088481890304/1630825215250534400/1630825590024179712', '/财务-资产负责类/所有者权益和负债/非流动负债/非流动所得税负债/一年以上的应交所得税', '/BS/P2000/P2200/P2270/234300', NULL, 1, '0', '1', '1', '2023-03-01 15:01:35', '1', '2023-03-01 15:02:55');
INSERT INTO `qf_subject_international_info` VALUES ('1630825590753988608', 'BS3', '234100', '递延税款负债', 'Liabilities deferred taxes', '€', '4', '1630825215812571136', 2, '/1630784869674127360/1630824894692462592/1630825088481890304/1630825215812571136/1630825590753988608', '/财务-资产负责类/所有者权益和负债/非流动负债/递延所得税负债/递延税款负债', '/BS/P2000/P2200/P2260/234100', NULL, 1, '0', '1', '1', '2023-03-01 15:01:35', '1', '2023-03-01 15:02:55');
INSERT INTO `qf_subject_international_info` VALUES ('1630825591374745600', 'BS3', '232100', '合同负债', 'Contract liabilities', '€', '4', '1630825216387190784', 3, '/1630784869674127360/1630824894692462592/1630825089119424512/1630825216387190784/1630825591374745600', '/财务-资产负责类/所有者权益和负债/流动负债/应付账款、其他应付款及合同负债/合同负债', '/BS/P2000/P2300/P2310/232100', NULL, 1, '0', '1', '1', '2023-03-01 15:01:35', '1', '2023-03-01 15:02:55');
INSERT INTO `qf_subject_international_info` VALUES ('1630825591970336768', 'BS3', '232110', '客户预付款', 'Prepayments from customers', '€', '4', '1630825216387190784', 1, '/1630784869674127360/1630824894692462592/1630825089119424512/1630825216387190784/1630825591970336768', '/财务-资产负责类/所有者权益和负债/流动负债/应付账款、其他应付款及合同负债/客户预付款', '/BS/P2000/P2300/P2310/232110', NULL, 2, '0', '1', '1', '2023-03-01 15:01:35', '1', '2023-03-01 15:02:56');
INSERT INTO `qf_subject_international_info` VALUES ('1630825592591093760', 'BS3', '233100', '应付账款（债权人）', 'Trade Payables (creditors)', '€', '4', '1630825216387190784', 8, '/1630784869674127360/1630824894692462592/1630825089119424512/1630825216387190784/1630825592591093760', '/财务-资产负责类/所有者权益和负债/流动负债/应付账款、其他应付款及合同负债/应付账款（债权人）', '/BS/P2000/P2300/P2310/233100', NULL, 3, '0', '1', '1', '2023-03-01 15:01:35', '1', '2023-03-01 15:02:57');
INSERT INTO `qf_subject_international_info` VALUES ('1630825593148936192', 'BS3', '233106', '客户的应付账款', 'Trade Payables to Customers', '€', '4', '1630825216387190784', 0, '/1630784869674127360/1630824894692462592/1630825089119424512/1630825216387190784/1630825593148936192', '/财务-资产负责类/所有者权益和负债/流动负债/应付账款、其他应付款及合同负债/客户的应付账款', '/BS/P2000/P2300/P2310/233106', NULL, 4, '0', '1', '1', '2023-03-01 15:01:35', '1', '2023-03-01 15:01:35');
INSERT INTO `qf_subject_international_info` VALUES ('1630825593740333056', 'BS3', '233200', '短期应付账款', 'Trade Payables short term', '€', '4', '1630825216387190784', 5, '/1630784869674127360/1630824894692462592/1630825089119424512/1630825216387190784/1630825593740333056', '/财务-资产负责类/所有者权益和负债/流动负债/应付账款、其他应付款及合同负债/短期应付账款', '/BS/P2000/P2300/P2310/233200', NULL, 5, '0', '1', '1', '2023-03-01 15:01:36', '1', '2023-03-01 15:02:57');
INSERT INTO `qf_subject_international_info` VALUES ('1630825594323341312', 'BS3', '233210', '其他短期负债', 'other liabilities short term', '€', '4', '1630825216387190784', 2, '/1630784869674127360/1630824894692462592/1630825089119424512/1630825216387190784/1630825594323341312', '/财务-资产负责类/所有者权益和负债/流动负债/应付账款、其他应付款及合同负债/其他短期负债', '/BS/P2000/P2300/P2310/233210', NULL, 6, '0', '1', '1', '2023-03-01 15:01:36', '1', '2023-03-01 15:02:58');
INSERT INTO `qf_subject_international_info` VALUES ('1630825594902155264', 'BS3', '236100', '应交税金', 'taxes', '€', '4', '1630825216387190784', 3, '/1630784869674127360/1630824894692462592/1630825089119424512/1630825216387190784/1630825594902155264', '/财务-资产负责类/所有者权益和负债/流动负债/应付账款、其他应付款及合同负债/应交税金', '/BS/P2000/P2300/P2310/236100', NULL, 7, '0', '1', '1', '2023-03-01 15:01:36', '1', '2023-03-01 15:02:58');
INSERT INTO `qf_subject_international_info` VALUES ('1630825595497746432', 'BS3', '236110', '应交税金', 'taxes', '€', '4', '1630825216387190784', 1, '/1630784869674127360/1630824894692462592/1630825089119424512/1630825216387190784/1630825595497746432', '/财务-资产负责类/所有者权益和负债/流动负债/应付账款、其他应付款及合同负债/应交税金', '/BS/P2000/P2300/P2310/236110', NULL, 8, '0', '1', '1', '2023-03-01 15:01:36', '1', '2023-03-01 15:02:58');
INSERT INTO `qf_subject_international_info` VALUES ('1630825596072366080', 'BS3', '236200', '应付社保费', 'Liabilities from social security', '€', '4', '1630825216387190784', 4, '/1630784869674127360/1630824894692462592/1630825089119424512/1630825216387190784/1630825596072366080', '/财务-资产负责类/所有者权益和负债/流动负债/应付账款、其他应付款及合同负债/应付社保费', '/BS/P2000/P2300/P2310/236200', NULL, 9, '0', '1', '1', '2023-03-01 15:01:36', '1', '2023-03-01 15:02:59');
INSERT INTO `qf_subject_international_info` VALUES ('1630825596676345856', 'BS3', '236300', '应付职工薪酬', 'Owed to employees', '€', '4', '1630825216387190784', 15, '/1630784869674127360/1630824894692462592/1630825089119424512/1630825216387190784/1630825596676345856', '/财务-资产负责类/所有者权益和负债/流动负债/应付账款、其他应付款及合同负债/应付职工薪酬', '/BS/P2000/P2300/P2310/236300', NULL, 10, '0', '1', '1', '2023-03-01 15:01:36', '1', '2023-03-01 15:03:01');
INSERT INTO `qf_subject_international_info` VALUES ('1630825597255159808', 'BS3', 'P2315', '其他应付款', 'other payables', '€', '4', '1630825216387190784', 9, '/1630784869674127360/1630824894692462592/1630825089119424512/1630825216387190784/1630825597255159808', '/财务-资产负责类/所有者权益和负债/流动负债/应付账款、其他应付款及合同负债/其他应付款', '/BS/P2000/P2300/P2310/P2315', NULL, 11, '0', '1', '1', '2023-03-01 15:01:36', '1', '2023-03-01 15:03:02');
INSERT INTO `qf_subject_international_info` VALUES ('1630825597842362368', 'BS3', '235400', '附属公司间应付款', 'Trade payables consolidated Companies', '€', '4', '1630825217146359808', 25, '/1630784869674127360/1630824894692462592/1630825089119424512/1630825217146359808/1630825597842362368', '/财务-资产负责类/所有者权益和负债/流动负债/关联公司应付款/附属公司间应付款', '/BS/P2000/P2300/P2317/235400', NULL, 1, '0', '1', '1', '2023-03-01 15:01:37', '1', '2023-03-01 15:03:06');
INSERT INTO `qf_subject_international_info` VALUES ('1630825598429564928', 'BS3', '231100', '流动银行及类似贷款', 'Current bank and similiar loans', '€', '4', '1630825217716785152', 10, '/1630784869674127360/1630824894692462592/1630825089119424512/1630825217716785152/1630825598429564928', '/财务-资产负责类/所有者权益和负债/流动负债/流动带息贷款和借款/流动银行及类似贷款', '/BS/P2000/P2300/P2320/231100', NULL, 1, '0', '1', '1', '2023-03-01 15:01:37', '1', '2023-03-01 15:03:08');
INSERT INTO `qf_subject_international_info` VALUES ('1630825598999990272', 'BS3', '231220', '一年内应付股东借款', 'Liabilities to shareholder < one year', '€', '4', '1630825217716785152', 1, '/1630784869674127360/1630824894692462592/1630825089119424512/1630825217716785152/1630825598999990272', '/财务-资产负责类/所有者权益和负债/流动负债/流动带息贷款和借款/一年内应付股东借款', '/BS/P2000/P2300/P2320/231220', NULL, 2, '0', '1', '1', '2023-03-01 15:01:37', '1', '2023-03-01 15:03:08');
INSERT INTO `qf_subject_international_info` VALUES ('1630825599763353600', 'BS3', '233310', '对关联方的贷款负债', 'loan liabilities to related parties', '€', '4', '1630825217716785152', 0, '/1630784869674127360/1630824894692462592/1630825089119424512/1630825217716785152/1630825599763353600', '/财务-资产负责类/所有者权益和负债/流动负债/流动带息贷款和借款/对关联方的贷款负债', '/BS/P2000/P2300/P2320/233310', NULL, 3, '0', '1', '1', '2023-03-01 15:01:37', '1', '2023-03-01 15:01:37');
INSERT INTO `qf_subject_international_info` VALUES ('1630825600333778944', 'BS3', 'P2331', '以公允价值计量的金融工具', 'Financial instruments measured at fair value', '€', '4', '1630825218303987712', 5, '/1630784869674127360/1630824894692462592/1630825089119424512/1630825218303987712/1630825600333778944', '/财务-资产负责类/所有者权益和负债/流动负债/以公允价值计量的金融工具/以公允价值计量的金融工具', '/BS/P2000/P2300/P2330/P2331', NULL, 1, '0', '1', '1', '2023-03-01 15:01:37', '1', '2023-03-01 15:03:09');
INSERT INTO `qf_subject_international_info` VALUES ('1630825600954535936', 'BS3', '222100', '其他流动预计负债', 'Other current provisions', '€', '4', '1630825218941521920', 3, '/1630784869674127360/1630824894692462592/1630825089119424512/1630825218941521920/1630825600954535936', '/财务-资产负责类/所有者权益和负债/流动负债/其他流动预计负债/其他流动预计负债', '/BS/P2000/P2300/P2350/222100', NULL, 1, '0', '1', '1', '2023-03-01 15:01:37', '1', '2023-03-01 15:03:09');
INSERT INTO `qf_subject_international_info` VALUES ('1630825601550127104', 'BS3', '234200', '短期所得税负债（一年内）', 'Liabilities for income taxes short term < one year', '€', '4', '1630825219503558656', 2, '/1630784869674127360/1630824894692462592/1630825089119424512/1630825219503558656/1630825601550127104', '/财务-资产负责类/所有者权益和负债/流动负债/所得税负债/短期所得税负债（一年内）', '/BS/P2000/P2300/P2340/234200', NULL, 1, '0', '1', '1', '2023-03-01 15:01:37', '1', '2023-03-01 15:03:10');
INSERT INTO `qf_subject_international_info` VALUES ('1630825760723963904', 'BS1', '111110', '订单簿', 'Order Book', '€', '5', '1630825548529930240', 0, '/1630784869674127360/1630824894071705600/1630825086661562368/1630825197982584832/1630825548529930240/1630825760723963904', '/财务-资产负责类/资产/非流动资产/无形资产/订单簿/订单簿', '/BS/A1000/A1100/A1120/111100/111110', NULL, 1, '0', '1', '1', '2023-03-01 15:02:15', '1', '2023-03-01 15:02:15');
INSERT INTO `qf_subject_international_info` VALUES ('1630825761302777856', 'BS1', '111111', '摊销订单簿', 'amortization Order Book', '€', '5', '1630825548529930240', 0, '/1630784869674127360/1630824894071705600/1630825086661562368/1630825197982584832/1630825548529930240/1630825761302777856', '/财务-资产负责类/资产/非流动资产/无形资产/订单簿/摊销订单簿', '/BS/A1000/A1100/A1120/111100/111111', NULL, 2, '0', '1', '1', '2023-03-01 15:02:15', '1', '2023-03-01 15:02:16');
INSERT INTO `qf_subject_international_info` VALUES ('1630825762049363968', 'BS1', '111310', '客户关系', 'Customer Relationship Industry', '€', '5', '1630825549297487872', 0, '/1630784869674127360/1630824894071705600/1630825086661562368/1630825197982584832/1630825549297487872/1630825762049363968', '/财务-资产负责类/资产/非流动资产/无形资产/客户关系/客户关系', '/BS/A1000/A1100/A1120/111300/111310', NULL, 1, '0', '1', '1', '2023-03-01 15:02:16', '1', '2023-03-01 15:02:16');
INSERT INTO `qf_subject_international_info` VALUES ('1630825762712064000', 'BS1', '111311', '摊销客户关系', 'amortization Customer Relationship Industry', '€', '5', '1630825549297487872', 0, '/1630784869674127360/1630824894071705600/1630825086661562368/1630825197982584832/1630825549297487872/1630825762712064000', '/财务-资产负责类/资产/非流动资产/无形资产/客户关系/摊销客户关系', '/BS/A1000/A1100/A1120/111300/111311', NULL, 2, '0', '1', '1', '2023-03-01 15:02:16', '1', '2023-03-01 15:02:16');
INSERT INTO `qf_subject_international_info` VALUES ('1630825763567702016', 'BS1', '111510', '其他无形资产', 'other intangible assets', '€', '5', '1630825549905661952', 0, '/1630784869674127360/1630824894071705600/1630825086661562368/1630825197982584832/1630825549905661952/1630825763567702016', '/财务-资产负责类/资产/非流动资产/无形资产/其他无形资产/其他无形资产', '/BS/A1000/A1100/A1120/111500/111510', NULL, 1, '0', '1', '1', '2023-03-01 15:02:16', '1', '2023-03-01 15:02:16');
INSERT INTO `qf_subject_international_info` VALUES ('1630825764519809024', 'BS1', '111511', '摊销其他无形资产', 'amortization other intangible assets', '€', '5', '1630825549905661952', 0, '/1630784869674127360/1630824894071705600/1630825086661562368/1630825197982584832/1630825549905661952/1630825764519809024', '/财务-资产负责类/资产/非流动资产/无形资产/其他无形资产/摊销其他无形资产', '/BS/A1000/A1100/A1120/111500/111511', NULL, 2, '0', '1', '1', '2023-03-01 15:02:16', '1', '2023-03-01 15:02:16');
INSERT INTO `qf_subject_international_info` VALUES ('1630825765073457152', 'BS1', '111610', '开发', 'development', '€', '5', '1630825550639665152', 0, '/1630784869674127360/1630824894071705600/1630825086661562368/1630825197982584832/1630825550639665152/1630825765073457152', '/财务-资产负责类/资产/非流动资产/无形资产/开发/开发', '/BS/A1000/A1100/A1120/111600/111610', NULL, 1, '0', '1', '1', '2023-03-01 15:02:16', '1', '2023-03-01 15:02:16');
INSERT INTO `qf_subject_international_info` VALUES ('1630825765715185664', 'BS1', '111611', '摊销开发', 'amortization development', '€', '5', '1630825550639665152', 0, '/1630784869674127360/1630824894071705600/1630825086661562368/1630825197982584832/1630825550639665152/1630825765715185664', '/财务-资产负责类/资产/非流动资产/无形资产/开发/摊销开发', '/BS/A1000/A1100/A1120/111600/111611', NULL, 2, '0', '1', '1', '2023-03-01 15:02:17', '1', '2023-03-01 15:02:17');
INSERT INTO `qf_subject_international_info` VALUES ('1630825766440800256', 'BS1', '111612', '开发减值', 'impairment development', '€', '5', '1630825550639665152', 0, '/1630784869674127360/1630824894071705600/1630825086661562368/1630825197982584832/1630825550639665152/1630825766440800256', '/财务-资产负责类/资产/非流动资产/无形资产/开发/开发减值', '/BS/A1000/A1100/A1120/111600/111612', NULL, 3, '0', '1', '1', '2023-03-01 15:02:17', '1', '2023-03-01 15:02:17');
INSERT INTO `qf_subject_international_info` VALUES ('1630825767044780032', 'BS1', '111710', '软件', 'Software', '€', '5', '1630825551373668352', 0, '/1630784869674127360/1630824894071705600/1630825086661562368/1630825197982584832/1630825551373668352/1630825767044780032', '/财务-资产负责类/资产/非流动资产/无形资产/软件/软件', '/BS/A1000/A1100/A1120/111700/111710', NULL, 1, '0', '1', '1', '2023-03-01 15:02:17', '1', '2023-03-01 15:02:17');
INSERT INTO `qf_subject_international_info` VALUES ('1630825767611011072', 'BS1', '111711', '软件摊销', 'amortization software', '€', '5', '1630825551373668352', 0, '/1630784869674127360/1630824894071705600/1630825086661562368/1630825197982584832/1630825551373668352/1630825767611011072', '/财务-资产负责类/资产/非流动资产/无形资产/软件/软件摊销', '/BS/A1000/A1100/A1120/111700/111711', NULL, 2, '0', '1', '1', '2023-03-01 15:02:17', '1', '2023-03-01 15:02:17');
INSERT INTO `qf_subject_international_info` VALUES ('1630825768240156672', 'BS1', '111810', '特许权/许可证/专利', 'Concessions/Licenses/Patents', '€', '5', '1630825551969259520', 0, '/1630784869674127360/1630824894071705600/1630825086661562368/1630825197982584832/1630825551969259520/1630825768240156672', '/财务-资产负责类/资产/非流动资产/无形资产/特许权/许可证/专利/特许权/许可证/专利', '/BS/A1000/A1100/A1120/111800/111810', NULL, 1, '0', '1', '1', '2023-03-01 15:02:17', '1', '2023-03-01 15:02:17');
INSERT INTO `qf_subject_international_info` VALUES ('1630825769775271936', 'BS1', '111811', '特许权/许可证/专利摊销', 'amortization concessions/licenses/patents', '€', '5', '1630825551969259520', 0, '/1630784869674127360/1630824894071705600/1630825086661562368/1630825197982584832/1630825551969259520/1630825769775271936', '/财务-资产负责类/资产/非流动资产/无形资产/特许权/许可证/专利/特许权/许可证/专利摊销', '/BS/A1000/A1100/A1120/111800/111811', NULL, 2, '0', '1', '1', '2023-03-01 15:02:17', '1', '2023-03-01 15:02:18');
INSERT INTO `qf_subject_international_info` VALUES ('1630825770349891584', 'BS1', '111901', '商誉', 'Goodwill', '€', '5', '1630825552531296256', 0, '/1630784869674127360/1630824894071705600/1630825086661562368/1630825197982584832/1630825552531296256/1630825770349891584', '/财务-资产负责类/资产/非流动资产/无形资产/商誉/商誉', '/BS/A1000/A1100/A1120/111900/111901', NULL, 1, '0', '1', '1', '2023-03-01 15:02:18', '1', '2023-03-01 15:02:18');
INSERT INTO `qf_subject_international_info` VALUES ('1630825770928705536', 'BS1', '111902', '商誉减值', 'impairment goodwill', '€', '5', '1630825552531296256', 0, '/1630784869674127360/1630824894071705600/1630825086661562368/1630825197982584832/1630825552531296256/1630825770928705536', '/财务-资产负责类/资产/非流动资产/无形资产/商誉/商誉减值', '/BS/A1000/A1100/A1120/111900/111902', NULL, 2, '0', '1', '1', '2023-03-01 15:02:18', '1', '2023-03-01 15:02:18');
INSERT INTO `qf_subject_international_info` VALUES ('1630825771507519488', 'BS1', '112110', '历史建筑成本', 'historical costs building', '€', '5', '1630825553764421632', 0, '/1630784869674127360/1630824894071705600/1630825086661562368/1630825198599147520/1630825553764421632/1630825771507519488', '/财务-资产负责类/资产/非流动资产/固定资产/不动产/历史建筑成本', '/BS/A1000/A1100/A1110/112100/112110', NULL, 1, '0', '1', '1', '2023-03-01 15:02:18', '1', '2023-03-01 15:02:18');
INSERT INTO `qf_subject_international_info` VALUES ('1630825772086333440', 'BS1', '112120', '第三方土地建造', 'building on third party land', '€', '5', '1630825553764421632', 0, '/1630784869674127360/1630824894071705600/1630825086661562368/1630825198599147520/1630825553764421632/1630825772086333440', '/财务-资产负责类/资产/非流动资产/固定资产/不动产/第三方土地建造', '/BS/A1000/A1100/A1110/112100/112120', NULL, 2, '0', '1', '1', '2023-03-01 15:02:18', '1', '2023-03-01 15:02:18');
INSERT INTO `qf_subject_international_info` VALUES ('1630825772702896128', 'BS1', '112130', '历史土地成本', 'historical costs land', '€', '5', '1630825553764421632', 0, '/1630784869674127360/1630824894071705600/1630825086661562368/1630825198599147520/1630825553764421632/1630825772702896128', '/财务-资产负责类/资产/非流动资产/固定资产/不动产/历史土地成本', '/BS/A1000/A1100/A1110/112100/112130', NULL, 3, '0', '1', '1', '2023-03-01 15:02:18', '1', '2023-03-01 15:02:18');
INSERT INTO `qf_subject_international_info` VALUES ('1630825773290098688', 'BS1', '112111', '建筑物折旧', 'depreciation building', '€', '5', '1630825554401955840', 0, '/1630784869674127360/1630824894071705600/1630825086661562368/1630825198599147520/1630825554401955840/1630825773290098688', '/财务-资产负责类/资产/非流动资产/固定资产/不动产折旧/建筑物折旧', '/BS/A1000/A1100/A1110/112150/112111', NULL, 1, '0', '1', '1', '2023-03-01 15:02:18', '1', '2023-03-01 15:02:18');
INSERT INTO `qf_subject_international_info` VALUES ('1630825773881495552', 'BS1', '112121', '第三方土地建造折旧', 'depreciation building on third parties land', '€', '5', '1630825554401955840', 0, '/1630784869674127360/1630824894071705600/1630825086661562368/1630825198599147520/1630825554401955840/1630825773881495552', '/财务-资产负责类/资产/非流动资产/固定资产/不动产折旧/第三方土地建造折旧', '/BS/A1000/A1100/A1110/112150/112121', NULL, 2, '0', '1', '1', '2023-03-01 15:02:18', '1', '2023-03-01 15:02:18');
INSERT INTO `qf_subject_international_info` VALUES ('1630825774468698112', 'BS1', '112112', '建筑物减值', 'impairment building', '€', '5', '1630825554984964096', 0, '/1630784869674127360/1630824894071705600/1630825086661562368/1630825198599147520/1630825554984964096/1630825774468698112', '/财务-资产负责类/资产/非流动资产/固定资产/不动产减值/建筑物减值', '/BS/A1000/A1100/A1110/112190/112112', NULL, 1, '0', '1', '1', '2023-03-01 15:02:19', '1', '2023-03-01 15:02:19');
INSERT INTO `qf_subject_international_info` VALUES ('1630825775051706368', 'BS1', '112122', '第三方土地建造减值', 'impairment building on third parties land', '€', '5', '1630825554984964096', 0, '/1630784869674127360/1630824894071705600/1630825086661562368/1630825198599147520/1630825554984964096/1630825775051706368', '/财务-资产负责类/资产/非流动资产/固定资产/不动产减值/第三方土地建造减值', '/BS/A1000/A1100/A1110/112190/112122', NULL, 2, '0', '1', '1', '2023-03-01 15:02:19', '1', '2023-03-01 15:02:19');
INSERT INTO `qf_subject_international_info` VALUES ('1630825775685046272', 'BS1', '112210', '技术设备和机械的购置和生产成本', 'acquisition and production costs for technical equipment and machinery', '€', '5', '1630825555572166656', 0, '/1630784869674127360/1630824894071705600/1630825086661562368/1630825198599147520/1630825555572166656/1630825775685046272', '/财务-资产负责类/资产/非流动资产/固定资产/技术资产及机器设备/技术设备和机械的购置和生产成本', '/BS/A1000/A1100/A1110/112200/112210', NULL, 1, '0', '1', '1', '2023-03-01 15:02:19', '1', '2023-03-01 15:02:19');
INSERT INTO `qf_subject_international_info` VALUES ('1630825776289026048', 'BS1', '112213', '技术设备和机械的购置和生产成本固定价值', 'acquisition and prod. costs for techn. Equipment/machinery fixed value', '€', '5', '1630825555572166656', 0, '/1630784869674127360/1630824894071705600/1630825086661562368/1630825198599147520/1630825555572166656/1630825776289026048', '/财务-资产负责类/资产/非流动资产/固定资产/技术资产及机器设备/技术设备和机械的购置和生产成本固定价值', '/BS/A1000/A1100/A1110/112200/112213', NULL, 2, '0', '1', '1', '2023-03-01 15:02:19', '1', '2023-03-01 15:02:19');
INSERT INTO `qf_subject_international_info` VALUES ('1630825776867840000', 'BS1', '112220', '工具', 'tools', '€', '5', '1630825555572166656', 0, '/1630784869674127360/1630824894071705600/1630825086661562368/1630825198599147520/1630825555572166656/1630825776867840000', '/财务-资产负责类/资产/非流动资产/固定资产/技术资产及机器设备/工具', '/BS/A1000/A1100/A1110/112200/112220', NULL, 3, '0', '1', '1', '2023-03-01 15:02:19', '1', '2023-03-01 15:02:19');
INSERT INTO `qf_subject_international_info` VALUES ('1630825777417293824', 'BS1', '112211', '技术设备和机器的折旧', 'depreciation  technical equipment and machinery', '€', '5', '1630825556142592000', 0, '/1630784869674127360/1630824894071705600/1630825086661562368/1630825198599147520/1630825556142592000/1630825777417293824', '/财务-资产负责类/资产/非流动资产/固定资产/技术资产及机器设备折旧/技术设备和机器的折旧', '/BS/A1000/A1100/A1110/112250/112211', NULL, 1, '0', '1', '1', '2023-03-01 15:02:19', '1', '2023-03-01 15:02:19');
INSERT INTO `qf_subject_international_info` VALUES ('1630825777975136256', 'BS1', '112221', '工具的折旧', 'depreciation tools', '€', '5', '1630825556142592000', 0, '/1630784869674127360/1630824894071705600/1630825086661562368/1630825198599147520/1630825556142592000/1630825777975136256', '/财务-资产负责类/资产/非流动资产/固定资产/技术资产及机器设备折旧/工具的折旧', '/BS/A1000/A1100/A1110/112250/112221', NULL, 2, '0', '1', '1', '2023-03-01 15:02:19', '1', '2023-03-01 15:02:19');
INSERT INTO `qf_subject_international_info` VALUES ('1630825778574921728', 'BS1', '112212', '技术设备和机器的减值', 'impairment technical equipment and machinery', '€', '5', '1630825556780126208', 0, '/1630784869674127360/1630824894071705600/1630825086661562368/1630825198599147520/1630825556780126208/1630825778574921728', '/财务-资产负责类/资产/非流动资产/固定资产/技术资产及机器设备减值/技术设备和机器的减值', '/BS/A1000/A1100/A1110/112290/112212', NULL, 1, '0', '1', '1', '2023-03-01 15:02:20', '1', '2023-03-01 15:02:20');
INSERT INTO `qf_subject_international_info` VALUES ('1630825779325702144', 'BS1', '112222', '工具的减值', 'impairment tools', '€', '5', '1630825556780126208', 0, '/1630784869674127360/1630824894071705600/1630825086661562368/1630825198599147520/1630825556780126208/1630825779325702144', '/财务-资产负责类/资产/非流动资产/固定资产/技术资产及机器设备减值/工具的减值', '/BS/A1000/A1100/A1110/112290/112222', NULL, 2, '0', '1', '1', '2023-03-01 15:02:20', '1', '2023-03-01 15:02:20');
INSERT INTO `qf_subject_international_info` VALUES ('1630825779933876224', 'BS1', '112310', '工厂和办公设备的购置和生产成本', 'acquisition and production costs factory and office equipment', '€', '5', '1630825557409271808', 0, '/1630784869674127360/1630824894071705600/1630825086661562368/1630825198599147520/1630825557409271808/1630825779933876224', '/财务-资产负责类/资产/非流动资产/固定资产/其他设备、工厂及办公设备/工厂和办公设备的购置和生产成本', '/BS/A1000/A1100/A1110/112300/112310', NULL, 1, '0', '1', '1', '2023-03-01 15:02:20', '1', '2023-03-01 15:02:20');
INSERT INTO `qf_subject_international_info` VALUES ('1630825780550438912', 'BS1', '112320', '硬件', 'Hardware', '€', '5', '1630825557409271808', 0, '/1630784869674127360/1630824894071705600/1630825086661562368/1630825198599147520/1630825557409271808/1630825780550438912', '/财务-资产负责类/资产/非流动资产/固定资产/其他设备、工厂及办公设备/硬件', '/BS/A1000/A1100/A1110/112300/112320', NULL, 2, '0', '1', '1', '2023-03-01 15:02:20', '1', '2023-03-01 15:02:20');
INSERT INTO `qf_subject_international_info` VALUES ('1630825781154418688', 'BS1', '112330', '车辆和交通工具', 'vehicles and means of transportation', '€', '5', '1630825557409271808', 0, '/1630784869674127360/1630824894071705600/1630825086661562368/1630825198599147520/1630825557409271808/1630825781154418688', '/财务-资产负责类/资产/非流动资产/固定资产/其他设备、工厂及办公设备/车辆和交通工具', '/BS/A1000/A1100/A1110/112300/112330', NULL, 3, '0', '1', '1', '2023-03-01 15:02:20', '1', '2023-03-01 15:02:20');
INSERT INTO `qf_subject_international_info` VALUES ('1630825781745815552', 'BS1', '112340', '低价值资产', 'low value assets', '€', '5', '1630825557409271808', 0, '/1630784869674127360/1630824894071705600/1630825086661562368/1630825198599147520/1630825557409271808/1630825781745815552', '/财务-资产负责类/资产/非流动资产/固定资产/其他设备、工厂及办公设备/低价值资产', '/BS/A1000/A1100/A1110/112300/112340', NULL, 4, '0', '1', '1', '2023-03-01 15:02:20', '1', '2023-03-01 15:02:20');
INSERT INTO `qf_subject_international_info` VALUES ('1630825782349795328', 'BS1', '112311', '工厂和办公设备的折旧', 'depreciation factory and office equipment', '€', '5', '1630825558046806016', 0, '/1630784869674127360/1630824894071705600/1630825086661562368/1630825198599147520/1630825558046806016/1630825782349795328', '/财务-资产负责类/资产/非流动资产/固定资产/其他设备、工厂及办公设备折旧/工厂和办公设备的折旧', '/BS/A1000/A1100/A1110/112350/112311', NULL, 1, '0', '1', '1', '2023-03-01 15:02:20', '1', '2023-03-01 15:02:21');
INSERT INTO `qf_subject_international_info` VALUES ('1630825782936997888', 'BS1', '112321', '硬件的折旧', 'depreciation hardware', '€', '5', '1630825558046806016', 0, '/1630784869674127360/1630824894071705600/1630825086661562368/1630825198599147520/1630825558046806016/1630825782936997888', '/财务-资产负责类/资产/非流动资产/固定资产/其他设备、工厂及办公设备折旧/硬件的折旧', '/BS/A1000/A1100/A1110/112350/112321', NULL, 2, '0', '1', '1', '2023-03-01 15:02:21', '1', '2023-03-01 15:02:21');
INSERT INTO `qf_subject_international_info` VALUES ('1630825783511617536', 'BS1', '112331', '车辆和交通工具的折旧', 'depreciation vehicles and means of transportation', '€', '5', '1630825558046806016', 0, '/1630784869674127360/1630824894071705600/1630825086661562368/1630825198599147520/1630825558046806016/1630825783511617536', '/财务-资产负责类/资产/非流动资产/固定资产/其他设备、工厂及办公设备折旧/车辆和交通工具的折旧', '/BS/A1000/A1100/A1110/112350/112331', NULL, 3, '0', '1', '1', '2023-03-01 15:02:21', '1', '2023-03-01 15:02:21');
INSERT INTO `qf_subject_international_info` VALUES ('1630825784090431488', 'BS1', '112341', '低价值资产的折旧', 'depreciation low assets', '€', '5', '1630825558046806016', 0, '/1630784869674127360/1630824894071705600/1630825086661562368/1630825198599147520/1630825558046806016/1630825784090431488', '/财务-资产负责类/资产/非流动资产/固定资产/其他设备、工厂及办公设备折旧/低价值资产的折旧', '/BS/A1000/A1100/A1110/112350/112341', NULL, 4, '0', '1', '1', '2023-03-01 15:02:21', '1', '2023-03-01 15:02:21');
INSERT INTO `qf_subject_international_info` VALUES ('1630825784694411264', 'BS1', '112312', '工厂和办公设备的减值', 'impairment factory and office equipment', '€', '5', '1630825558684340224', 0, '/1630784869674127360/1630824894071705600/1630825086661562368/1630825198599147520/1630825558684340224/1630825784694411264', '/财务-资产负责类/资产/非流动资产/固定资产/其他设备、工厂及办公设备减值/工厂和办公设备的减值', '/BS/A1000/A1100/A1110/112390/112312', NULL, 1, '0', '1', '1', '2023-03-01 15:02:21', '1', '2023-03-01 15:02:21');
INSERT INTO `qf_subject_international_info` VALUES ('1630825785298391040', 'BS1', '112332', '车辆和交通工具的折旧', 'impairment vehicles and means of transportation', '€', '5', '1630825558684340224', 0, '/1630784869674127360/1630824894071705600/1630825086661562368/1630825198599147520/1630825558684340224/1630825785298391040', '/财务-资产负责类/资产/非流动资产/固定资产/其他设备、工厂及办公设备减值/车辆和交通工具的折旧', '/BS/A1000/A1100/A1110/112390/112332', NULL, 2, '0', '1', '1', '2023-03-01 15:02:21', '1', '2023-03-01 15:02:21');
INSERT INTO `qf_subject_international_info` VALUES ('1630825785881399296', 'BS1', '112410', '在建工程的预付款', 'Prepayments on constructions in process', '€', '5', '1630825559275737088', 0, '/1630784869674127360/1630824894071705600/1630825086661562368/1630825198599147520/1630825559275737088/1630825785881399296', '/财务-资产负责类/资产/非流动资产/固定资产/预付款及在建工程/在建工程的预付款', '/BS/A1000/A1100/A1110/112400/112410', NULL, 1, '0', '1', '1', '2023-03-01 15:02:21', '1', '2023-03-01 15:02:21');
INSERT INTO `qf_subject_international_info` VALUES ('1630825786435047424', 'BS1', '112420', '在加工工具的预付款', 'Prepayments on tools in process', '€', '5', '1630825559275737088', 0, '/1630784869674127360/1630824894071705600/1630825086661562368/1630825198599147520/1630825559275737088/1630825786435047424', '/财务-资产负责类/资产/非流动资产/固定资产/预付款及在建工程/在加工工具的预付款', '/BS/A1000/A1100/A1110/112400/112420', NULL, 2, '0', '1', '1', '2023-03-01 15:02:21', '1', '2023-03-01 15:02:21');
INSERT INTO `qf_subject_international_info` VALUES ('1630825787026444288', 'BS1', '111950', '使用权资产—房屋和土地的租赁规则', 'Right of use asset IFRS 16 land & building', '€', '5', '1630825560747937792', 0, '/1630784869674127360/1630824894071705600/1630825086661562368/1630825199190544384/1630825560747937792/1630825787026444288', '/财务-资产负责类/资产/非流动资产/使用权资产/使用权资产/使用权资产—房屋和土地的租赁规则', '/BS/A1000/A1100/A1115/111949/111950', NULL, 1, '0', '1', '1', '2023-03-01 15:02:22', '1', '2023-03-01 15:02:22');
INSERT INTO `qf_subject_international_info` VALUES ('1630825787601063936', 'BS1', '111951', '使用权资产的摊销—房屋和土地的租赁规则', 'amortization right of use asset IFRS 16 land & building', '€', '5', '1630825560747937792', 0, '/1630784869674127360/1630824894071705600/1630825086661562368/1630825199190544384/1630825560747937792/1630825787601063936', '/财务-资产负责类/资产/非流动资产/使用权资产/使用权资产/使用权资产的摊销—房屋和土地的租赁规则', '/BS/A1000/A1100/A1115/111949/111951', NULL, 2, '0', '1', '1', '2023-03-01 15:02:22', '1', '2023-03-01 15:02:22');
INSERT INTO `qf_subject_international_info` VALUES ('1630825788301512704', 'BS1', '111953', '使用权资产—厂房和机械的租赁规则', 'Right of use asset IFRS 16 plant & machinery', '€', '5', '1630825560747937792', 0, '/1630784869674127360/1630824894071705600/1630825086661562368/1630825199190544384/1630825560747937792/1630825788301512704', '/财务-资产负责类/资产/非流动资产/使用权资产/使用权资产/使用权资产—厂房和机械的租赁规则', '/BS/A1000/A1100/A1115/111949/111953', NULL, 3, '0', '1', '1', '2023-03-01 15:02:22', '1', '2023-03-01 15:02:22');
INSERT INTO `qf_subject_international_info` VALUES ('1630825788960018432', 'BS1', '111954', '使用权资产的摊销—厂房和机械的租赁规则', 'amortization right of use asset IFRS 16 plant & machinery', '€', '5', '1630825560747937792', 0, '/1630784869674127360/1630824894071705600/1630825086661562368/1630825199190544384/1630825560747937792/1630825788960018432', '/财务-资产负责类/资产/非流动资产/使用权资产/使用权资产/使用权资产的摊销—厂房和机械的租赁规则', '/BS/A1000/A1100/A1115/111949/111954', NULL, 4, '0', '1', '1', '2023-03-01 15:02:22', '1', '2023-03-01 15:02:22');
INSERT INTO `qf_subject_international_info` VALUES ('1630825789551415296', 'BS1', '111956', '使用权资产—土地和建筑家具和设备的租赁规则', 'Right of use asset IFRS 16 land & building furniture & equipment', '€', '5', '1630825560747937792', 0, '/1630784869674127360/1630824894071705600/1630825086661562368/1630825199190544384/1630825560747937792/1630825789551415296', '/财务-资产负责类/资产/非流动资产/使用权资产/使用权资产/使用权资产—土地和建筑家具和设备的租赁规则', '/BS/A1000/A1100/A1115/111949/111956', NULL, 5, '0', '1', '1', '2023-03-01 15:02:22', '1', '2023-03-01 15:02:22');
INSERT INTO `qf_subject_international_info` VALUES ('1630825790184755200', 'BS1', '111957', '使用权资产的摊销—家具和设备的租赁规则', 'amortization right of use asset IFRS 16 furniture & equipment', '€', '5', '1630825560747937792', 0, '/1630784869674127360/1630824894071705600/1630825086661562368/1630825199190544384/1630825560747937792/1630825790184755200', '/财务-资产负责类/资产/非流动资产/使用权资产/使用权资产/使用权资产的摊销—家具和设备的租赁规则', '/BS/A1000/A1100/A1115/111949/111957', NULL, 6, '0', '1', '1', '2023-03-01 15:02:22', '1', '2023-03-01 15:02:22');
INSERT INTO `qf_subject_international_info` VALUES ('1630825790767763456', 'BS1', '111958', '使用权资产的减值—家具和设备的租赁规则', 'impairment right of use asset IFRS 16 furniture & equipment', '€', '5', '1630825560747937792', 0, '/1630784869674127360/1630824894071705600/1630825086661562368/1630825199190544384/1630825560747937792/1630825790767763456', '/财务-资产负责类/资产/非流动资产/使用权资产/使用权资产/使用权资产的减值—家具和设备的租赁规则', '/BS/A1000/A1100/A1115/111949/111958', NULL, 7, '0', '1', '1', '2023-03-01 15:02:23', '1', '2023-03-01 15:02:23');
INSERT INTO `qf_subject_international_info` VALUES ('1630825791329800192', 'BS1', '112510', '资本化租赁', 'Capital Lease', '€', '5', '1630825561473552384', 0, '/1630784869674127360/1630824894071705600/1630825086661562368/1630825199773552640/1630825561473552384/1630825791329800192', '/财务-资产负责类/资产/非流动资产/融资租赁/融资租赁/资本化租赁', '/BS/A1000/A1100/A1111/A11110/112510', NULL, 1, '0', '1', '1', '2023-03-01 15:02:23', '1', '2023-03-01 15:02:23');
INSERT INTO `qf_subject_international_info` VALUES ('1630825791908614144', 'BS1', '112511', '资本化租赁折旧', 'Depreciation capital lease', '€', '5', '1630825562056560640', 0, '/1630784869674127360/1630824894071705600/1630825086661562368/1630825199773552640/1630825562056560640/1630825791908614144', '/财务-资产负责类/资产/非流动资产/融资租赁/融资租赁—折旧/资本化租赁折旧', '/BS/A1000/A1100/A1111/A11115/112511', NULL, 1, '0', '1', '1', '2023-03-01 15:02:23', '1', '2023-03-01 15:02:23');
INSERT INTO `qf_subject_international_info` VALUES ('1630825792491622400', 'BS1', '113104', '萨固密管理公司', 'Cooperation SaarGummi Verwaltungs-GmbH', '€', '5', '1630825562643763200', 0, '/1630784869674127360/1630824894071705600/1630825086661562368/1630825200381726720/1630825562643763200/1630825792491622400', '/财务-资产负责类/资产/非流动资产/对关联公司股份/关联公司股份/萨固密管理公司', '/BS/A1000/A1100/A1125/113100/113104', NULL, 1, '0', '1', '1', '2023-03-01 15:02:23', '1', '2023-03-01 15:02:23');
INSERT INTO `qf_subject_international_info` VALUES ('1630825793095602176', 'BS1', '113106', '萨固密汽车密封件公司', 'Cooperation SaarGummi Automotive Sealings GmbH', '€', '5', '1630825562643763200', 0, '/1630784869674127360/1630824894071705600/1630825086661562368/1630825200381726720/1630825562643763200/1630825793095602176', '/财务-资产负责类/资产/非流动资产/对关联公司股份/关联公司股份/萨固密汽车密封件公司', '/BS/A1000/A1100/A1125/113100/113106', NULL, 2, '0', '1', '1', '2023-03-01 15:02:23', '1', '2023-03-01 15:02:23');
INSERT INTO `qf_subject_international_info` VALUES ('1630825793703776256', 'BS1', '113108', '萨固密伊比利亚公司', 'Cooperation SaarGummi Iberica S.A.', '€', '5', '1630825562643763200', 0, '/1630784869674127360/1630824894071705600/1630825086661562368/1630825200381726720/1630825562643763200/1630825793703776256', '/财务-资产负责类/资产/非流动资产/对关联公司股份/关联公司股份/萨固密伊比利亚公司', '/BS/A1000/A1100/A1125/113100/113108', NULL, 3, '0', '1', '1', '2023-03-01 15:02:23', '1', '2023-03-01 15:02:23');
INSERT INTO `qf_subject_international_info` VALUES ('1630825794270007296', 'BS1', '113109', '萨固密斯洛伐克公司', 'Cooperation SaarGummi Slovakia s.r.o.', '€', '5', '1630825562643763200', 0, '/1630784869674127360/1630824894071705600/1630825086661562368/1630825200381726720/1630825562643763200/1630825794270007296', '/财务-资产负责类/资产/非流动资产/对关联公司股份/关联公司股份/萨固密斯洛伐克公司', '/BS/A1000/A1100/A1125/113100/113109', NULL, 4, '0', '1', '1', '2023-03-01 15:02:23', '1', '2023-03-01 15:02:23');
INSERT INTO `qf_subject_international_info` VALUES ('1630825794857209856', 'BS1', '113111', '萨固密捷克公司', 'Cooperation Saar Gummi Czech s.r.o.', '€', '5', '1630825562643763200', 0, '/1630784869674127360/1630824894071705600/1630825086661562368/1630825200381726720/1630825562643763200/1630825794857209856', '/财务-资产负责类/资产/非流动资产/对关联公司股份/关联公司股份/萨固密捷克公司', '/BS/A1000/A1100/A1125/113100/113111', NULL, 5, '0', '1', '1', '2023-03-01 15:02:23', '1', '2023-03-01 15:02:23');
INSERT INTO `qf_subject_international_info` VALUES ('1630825795440218112', 'BS1', '113112', 'CQLT萨固密技术公司', 'Cooperation CQLT SaarGummi Technologies S.a r.l. Luxembourg', '€', '5', '1630825562643763200', 0, '/1630784869674127360/1630824894071705600/1630825086661562368/1630825200381726720/1630825562643763200/1630825795440218112', '/财务-资产负责类/资产/非流动资产/对关联公司股份/关联公司股份/CQLT萨固密技术公司', '/BS/A1000/A1100/A1125/113100/113112', NULL, 6, '0', '1', '1', '2023-03-01 15:02:24', '1', '2023-03-01 15:02:24');
INSERT INTO `qf_subject_international_info` VALUES ('1630825796044197888', 'BS1', '113113', '萨固密巴西公司', 'Cooperation SaarGummi do Brazil Ltda.', '€', '5', '1630825562643763200', 0, '/1630784869674127360/1630824894071705600/1630825086661562368/1630825200381726720/1630825562643763200/1630825796044197888', '/财务-资产负责类/资产/非流动资产/对关联公司股份/关联公司股份/萨固密巴西公司', '/BS/A1000/A1100/A1125/113100/113113', NULL, 7, '0', '1', '1', '2023-03-01 15:02:24', '1', '2023-03-01 15:02:24');
INSERT INTO `qf_subject_international_info` VALUES ('1630825796627206144', 'BS1', '113115', '萨固密田纳西公司', 'Cooperation SaarGummi Tennessee INC.', '€', '5', '1630825562643763200', 0, '/1630784869674127360/1630824894071705600/1630825086661562368/1630825200381726720/1630825562643763200/1630825796627206144', '/财务-资产负责类/资产/非流动资产/对关联公司股份/关联公司股份/萨固密田纳西公司', '/BS/A1000/A1100/A1125/113100/113115', NULL, 8, '0', '1', '1', '2023-03-01 15:02:24', '1', '2023-03-01 15:02:24');
INSERT INTO `qf_subject_international_info` VALUES ('1630825797268934656', 'BS1', '113116', '萨固密印度公司', 'Cooperation Gold Seal SaarGummi India Ltd.', '€', '5', '1630825562643763200', 0, '/1630784869674127360/1630824894071705600/1630825086661562368/1630825200381726720/1630825562643763200/1630825797268934656', '/财务-资产负责类/资产/非流动资产/对关联公司股份/关联公司股份/萨固密印度公司', '/BS/A1000/A1100/A1125/113100/113116', NULL, 9, '0', '1', '1', '2023-03-01 15:02:24', '1', '2023-03-01 15:02:24');
INSERT INTO `qf_subject_international_info` VALUES ('1630825797919051776', 'BS1', '113119', '萨固密俄罗斯公司', 'Cooperation SaarGummi Russland Ltd.', '€', '5', '1630825562643763200', 0, '/1630784869674127360/1630824894071705600/1630825086661562368/1630825200381726720/1630825562643763200/1630825797919051776', '/财务-资产负责类/资产/非流动资产/对关联公司股份/关联公司股份/萨固密俄罗斯公司', '/BS/A1000/A1100/A1125/113100/113119', NULL, 10, '0', '1', '1', '2023-03-01 15:02:24', '1', '2023-03-01 15:02:24');
INSERT INTO `qf_subject_international_info` VALUES ('1630825798481088512', 'BS1', '113120', '萨固密德国控股公司', 'Cooperation SaarGummi Deutschland Holding GmbH', '€', '5', '1630825562643763200', 0, '/1630784869674127360/1630824894071705600/1630825086661562368/1630825200381726720/1630825562643763200/1630825798481088512', '/财务-资产负责类/资产/非流动资产/对关联公司股份/关联公司股份/萨固密德国控股公司', '/BS/A1000/A1100/A1125/113100/113120', NULL, 11, '0', '1', '1', '2023-03-01 15:02:24', '1', '2023-03-01 15:02:24');
INSERT INTO `qf_subject_international_info` VALUES ('1630825799064096768', 'BS1', '113121', 'CQLT萨固密德国公司', 'Cooperation CQLT SaarGummi Deutschland GmbH', '€', '5', '1630825562643763200', 0, '/1630784869674127360/1630824894071705600/1630825086661562368/1630825200381726720/1630825562643763200/1630825799064096768', '/财务-资产负责类/资产/非流动资产/对关联公司股份/关联公司股份/CQLT萨固密德国公司', '/BS/A1000/A1100/A1125/113100/113121', NULL, 12, '0', '1', '1', '2023-03-01 15:02:24', '1', '2023-03-01 15:02:25');
INSERT INTO `qf_subject_international_info` VALUES ('1630825799663882240', 'BS1', '113126', '萨固密贝特林根公司', 'Cooperation SaarGummi Beteiligungs GmbH', '€', '5', '1630825562643763200', 0, '/1630784869674127360/1630824894071705600/1630825086661562368/1630825200381726720/1630825562643763200/1630825799663882240', '/财务-资产负责类/资产/非流动资产/对关联公司股份/关联公司股份/萨固密贝特林根公司', '/BS/A1000/A1100/A1125/113100/113126', NULL, 13, '0', '1', '1', '2023-03-01 15:02:25', '1', '2023-03-01 15:02:25');
INSERT INTO `qf_subject_international_info` VALUES ('1630825800288833536', 'BS1', '113133', '兴渝国际控股（香港）有限公司', 'CooperationCQLT International Investment Holding Ltd, HK', '€', '5', '1630825562643763200', 0, '/1630784869674127360/1630824894071705600/1630825086661562368/1630825200381726720/1630825562643763200/1630825800288833536', '/财务-资产负责类/资产/非流动资产/对关联公司股份/关联公司股份/兴渝国际控股（香港）有限公司', '/BS/A1000/A1100/A1125/113100/113133', NULL, 14, '0', '1', '1', '2023-03-01 15:02:25', '1', '2023-03-01 15:02:25');
INSERT INTO `qf_subject_international_info` VALUES ('1630825800997670912', 'BS1', '113139', '萨固密（中国）投资有限公司', 'Cooperation Saargummi China Investment Limited', '€', '5', '1630825562643763200', 0, '/1630784869674127360/1630824894071705600/1630825086661562368/1630825200381726720/1630825562643763200/1630825800997670912', '/财务-资产负责类/资产/非流动资产/对关联公司股份/关联公司股份/萨固密（中国）投资有限公司', '/BS/A1000/A1100/A1125/113100/113139', NULL, 15, '0', '1', '1', '2023-03-01 15:02:25', '1', '2023-03-01 15:02:25');
INSERT INTO `qf_subject_international_info` VALUES ('1630825801777811456', 'BS1', '113141', '萨固密渝锦（重庆）橡塑制品有限公司', 'Cooperation SG Yujin  Rubber & Plastic Products Co. Ltd', '€', '5', '1630825562643763200', 0, '/1630784869674127360/1630824894071705600/1630825086661562368/1630825200381726720/1630825562643763200/1630825801777811456', '/财务-资产负责类/资产/非流动资产/对关联公司股份/关联公司股份/萨固密渝锦（重庆）橡塑制品有限公司', '/BS/A1000/A1100/A1125/113100/113141', NULL, 16, '0', '1', '1', '2023-03-01 15:02:25', '1', '2023-03-01 15:02:25');
INSERT INTO `qf_subject_international_info` VALUES ('1630825802394374144', 'BS1', '113142', '萨固密（重庆）密封系统有限公司', 'Cooperation SaarGummi( Chongqing) Sealing System Co.,ltd', '€', '5', '1630825562643763200', 0, '/1630784869674127360/1630824894071705600/1630825086661562368/1630825200381726720/1630825562643763200/1630825802394374144', '/财务-资产负责类/资产/非流动资产/对关联公司股份/关联公司股份/萨固密（重庆）密封系统有限公司', '/BS/A1000/A1100/A1125/113100/113142', NULL, 17, '0', '1', '1', '2023-03-01 15:02:25', '1', '2023-03-01 15:02:25');
INSERT INTO `qf_subject_international_info` VALUES ('1630825802977382400', 'BS1', '113143', '萨固密杭州若林公司', 'Cooperation Hangzhou Jiaxuan Ruolin', '€', '5', '1630825562643763200', 0, '/1630784869674127360/1630824894071705600/1630825086661562368/1630825200381726720/1630825562643763200/1630825802977382400', '/财务-资产负责类/资产/非流动资产/对关联公司股份/关联公司股份/萨固密杭州若林公司', '/BS/A1000/A1100/A1125/113100/113143', NULL, 18, '0', '1', '1', '2023-03-01 15:02:25', '1', '2023-03-01 15:02:25');
INSERT INTO `qf_subject_international_info` VALUES ('1630825803535224832', 'BS1', '113144', '萨固密（营口）密封系统有限公司', 'Cooperation SaarGummi (Yingkou) Sealing System co. LTd', '€', '5', '1630825562643763200', 0, '/1630784869674127360/1630824894071705600/1630825086661562368/1630825200381726720/1630825562643763200/1630825803535224832', '/财务-资产负责类/资产/非流动资产/对关联公司股份/关联公司股份/萨固密（营口）密封系统有限公司', '/BS/A1000/A1100/A1125/113100/113144', NULL, 19, '0', '1', '1', '2023-03-01 15:02:26', '1', '2023-03-01 15:02:26');
INSERT INTO `qf_subject_international_info` VALUES ('1630825804084678656', 'BS1', '113145', '萨固密国际系统有限公司', 'Cooperation SaarGummi International Systems GmbH', '€', '5', '1630825562643763200', 0, '/1630784869674127360/1630824894071705600/1630825086661562368/1630825200381726720/1630825562643763200/1630825804084678656', '/财务-资产负责类/资产/非流动资产/对关联公司股份/关联公司股份/萨固密国际系统有限公司', '/BS/A1000/A1100/A1125/113100/113145', NULL, 20, '0', '1', '1', '2023-03-01 15:02:26', '1', '2023-03-01 15:02:26');
INSERT INTO `qf_subject_international_info` VALUES ('1630825804655104000', 'BS1', '113146', '萨固密（上海）橡塑技术有限公司', 'Cooperation SaarGummi (Shanghai) Rubber Technologies Co. Ltd.', '€', '5', '1630825562643763200', 0, '/1630784869674127360/1630824894071705600/1630825086661562368/1630825200381726720/1630825562643763200/1630825804655104000', '/财务-资产负责类/资产/非流动资产/对关联公司股份/关联公司股份/萨固密（上海）橡塑技术有限公司', '/BS/A1000/A1100/A1125/113100/113146', NULL, 21, '0', '1', '1', '2023-03-01 15:02:26', '1', '2023-03-01 15:02:26');
INSERT INTO `qf_subject_international_info` VALUES ('1630825805217140736', 'BS1', '113147', '萨固密墨西哥公司', 'Cooperation SaarGummi Mexico S.A. de C.V.', '€', '5', '1630825562643763200', 0, '/1630784869674127360/1630824894071705600/1630825086661562368/1630825200381726720/1630825562643763200/1630825805217140736', '/财务-资产负责类/资产/非流动资产/对关联公司股份/关联公司股份/萨固密墨西哥公司', '/BS/A1000/A1100/A1125/113100/113147', NULL, 22, '0', '1', '1', '2023-03-01 15:02:26', '1', '2023-03-01 15:02:26');
INSERT INTO `qf_subject_international_info` VALUES ('1630825805779177472', 'BS1', '113148', '萨固密NEO公司', 'Cooperation SaarGummi Neo GmbH', '€', '5', '1630825562643763200', 0, '/1630784869674127360/1630824894071705600/1630825086661562368/1630825200381726720/1630825562643763200/1630825805779177472', '/财务-资产负责类/资产/非流动资产/对关联公司股份/关联公司股份/萨固密NEO公司', '/BS/A1000/A1100/A1125/113100/113148', NULL, 23, '0', '1', '1', '2023-03-01 15:02:26', '1', '2023-03-01 15:02:26');
INSERT INTO `qf_subject_international_info` VALUES ('1630825806378962944', 'BS1', '113149', '萨固密法国公司', 'Cooperation SaarGummi France S.A.', '€', '5', '1630825562643763200', 0, '/1630784869674127360/1630824894071705600/1630825086661562368/1630825200381726720/1630825562643763200/1630825806378962944', '/财务-资产负责类/资产/非流动资产/对关联公司股份/关联公司股份/萨固密法国公司', '/BS/A1000/A1100/A1125/113100/113149', NULL, 24, '0', '1', '1', '2023-03-01 15:02:26', '1', '2023-03-01 15:02:26');
INSERT INTO `qf_subject_international_info` VALUES ('1630825806953582592', 'BS1', '113150', '萨固密服务公司', 'Cooperation SaarGummi Servicio S.A. de C.V.', '€', '5', '1630825562643763200', 0, '/1630784869674127360/1630824894071705600/1630825086661562368/1630825200381726720/1630825562643763200/1630825806953582592', '/财务-资产负责类/资产/非流动资产/对关联公司股份/关联公司股份/萨固密服务公司', '/BS/A1000/A1100/A1125/113100/113150', NULL, 25, '0', '1', '1', '2023-03-01 15:02:26', '1', '2023-03-01 15:02:26');
INSERT INTO `qf_subject_international_info` VALUES ('1630825807519813632', 'BS1', '113151', '萨固密土耳其公司', 'Cooperation SAARGUMMİ TURKEY KAUÇUK VE PLASTİK LİMİTED ŞİRKETİ', '€', '5', '1630825562643763200', 0, '/1630784869674127360/1630824894071705600/1630825086661562368/1630825200381726720/1630825562643763200/1630825807519813632', '/财务-资产负责类/资产/非流动资产/对关联公司股份/关联公司股份/萨固密土耳其公司', '/BS/A1000/A1100/A1125/113100/113151', NULL, 26, '0', '1', '1', '2023-03-01 15:02:26', '1', '2023-03-01 15:02:27');
INSERT INTO `qf_subject_international_info` VALUES ('1630825808090238976', 'BS1', '112590', '保证金', 'deposit', '€', '5', '1630825563268714496', 0, '/1630784869674127360/1630824894071705600/1630825086661562368/1630825201019260928/1630825563268714496/1630825808090238976', '/财务-资产负责类/资产/非流动资产/其他非流动金融资产/保证金/保证金', '/BS/A1000/A1100/A1140/A1141/112590', NULL, 1, '0', '1', '1', '2023-03-01 15:02:27', '1', '2023-03-01 15:02:27');
INSERT INTO `qf_subject_international_info` VALUES ('1630825808669052928', 'BS1', '113401', '投资<20%', 'investment < 20 %', '€', '5', '1630825563855917056', 0, '/1630784869674127360/1630824894071705600/1630825086661562368/1630825201019260928/1630825563855917056/1630825808669052928', '/财务-资产负责类/资产/非流动资产/其他非流动金融资产/投资/投资<20%', '/BS/A1000/A1100/A1140/113250/113401', NULL, 1, '0', '1', '1', '2023-03-01 15:02:27', '1', '2023-03-01 15:02:27');
INSERT INTO `qf_subject_international_info` VALUES ('1630825809239478272', 'BS1', '122511', '劳务部的应收款', 'receivables ministery of labour', '€', '5', '1630825564464091136', 0, '/1630784869674127360/1630824894071705600/1630825086661562368/1630825201635823616/1630825564464091136/1630825809239478272', '/财务-资产负责类/资产/非流动资产/其他非流动应收账款/贸易应收款和其他应收款/劳务部的应收款', '/BS/A1000/A1100/A1150/A1151/122511', NULL, 1, '0', '1', '1', '2023-03-01 15:02:27', '1', '2023-03-01 15:02:27');
INSERT INTO `qf_subject_international_info` VALUES ('1630825809847652352', 'BS1', '122512', '应收账款再保险', 'Receivables reinsurance', '€', '5', '1630825564464091136', 0, '/1630784869674127360/1630824894071705600/1630825086661562368/1630825201635823616/1630825564464091136/1630825809847652352', '/财务-资产负责类/资产/非流动资产/其他非流动应收账款/贸易应收款和其他应收款/应收账款再保险', '/BS/A1000/A1100/A1150/A1151/122512', NULL, 2, '0', '1', '1', '2023-03-01 15:02:27', '1', '2023-03-01 15:02:27');
INSERT INTO `qf_subject_international_info` VALUES ('1630825810480992256', 'BS1', '122513', '应收账款保险公司', 'Receivables insurance companies', '€', '5', '1630825564464091136', 0, '/1630784869674127360/1630824894071705600/1630825086661562368/1630825201635823616/1630825564464091136/1630825810480992256', '/财务-资产负责类/资产/非流动资产/其他非流动应收账款/贸易应收款和其他应收款/应收账款保险公司', '/BS/A1000/A1100/A1150/A1151/122513', NULL, 3, '0', '1', '1', '2023-03-01 15:02:27', '1', '2023-03-01 15:02:27');
INSERT INTO `qf_subject_international_info` VALUES ('1630825811068194816', 'BS1', '122532', '长期合同资产', 'Contract assets long term', '€', '5', '1630825564464091136', 0, '/1630784869674127360/1630824894071705600/1630825086661562368/1630825201635823616/1630825564464091136/1630825811068194816', '/财务-资产负责类/资产/非流动资产/其他非流动应收账款/贸易应收款和其他应收款/长期合同资产', '/BS/A1000/A1100/A1150/A1151/122532', NULL, 4, '0', '1', '1', '2023-03-01 15:02:27', '1', '2023-03-01 15:02:27');
INSERT INTO `qf_subject_international_info` VALUES ('1630825811659591680', 'BS1', '122531', '非流动所得税资产', 'Non-current income tax assets', '€', '5', '1630825565055488000', 0, '/1630784869674127360/1630824894071705600/1630825086661562368/1630825202332078080/1630825565055488000/1630825811659591680', '/财务-资产负责类/资产/非流动资产/非流动所得税资产/非流动所得税资产/非流动所得税资产', '/BS/A1000/A1100/A1165/A1166/122531', NULL, 1, '0', '1', '1', '2023-03-01 15:02:27', '1', '2023-03-01 15:02:28');
INSERT INTO `qf_subject_international_info` VALUES ('1630825813131792384', 'BS1', '141110', '递延所得税资产', 'deferred tax assets', '€', '5', '1630825565672050688', 0, '/1630784869674127360/1630824894071705600/1630825086661562368/1630825202919280640/1630825565672050688/1630825813131792384', '/财务-资产负责类/资产/非流动资产/递延所得说资产/递延所得税资产/递延所得税资产', '/BS/A1000/A1100/A1160/141100/141110', NULL, 1, '0', '1', '1', '2023-03-01 15:02:28', '1', '2023-03-01 15:02:28');
INSERT INTO `qf_subject_international_info` VALUES ('1630825813668663296', 'BS1', '141112', '由于税收亏损结转而产生的递延所得税资产', 'deferred tax assets due to tax loss carryforward', '€', '5', '1630825565672050688', 0, '/1630784869674127360/1630824894071705600/1630825086661562368/1630825202919280640/1630825565672050688/1630825813668663296', '/财务-资产负责类/资产/非流动资产/递延所得说资产/递延所得税资产/由于税收亏损结转而产生的递延所得税资产', '/BS/A1000/A1100/A1160/141100/141112', NULL, 2, '0', '1', '1', '2023-03-01 15:02:28', '1', '2023-03-01 15:02:28');
INSERT INTO `qf_subject_international_info` VALUES ('1630825814243282944', 'BS1', '121110', '生产材料/原材料库存', 'inventory production material/raw material', '€', '5', '1630825566250864640', 0, '/1630784869674127360/1630824894071705600/1630825087282319360/1630825203519066112/1630825566250864640/1630825814243282944', '/财务-资产负责类/资产/流动资产/存货/原材料及供应/生产材料/原材料库存', '/BS/A1000/A1200/A1210/121100/121110', NULL, 1, '0', '1', '1', '2023-03-01 15:02:28', '1', '2023-03-01 15:02:28');
INSERT INTO `qf_subject_international_info` VALUES ('1630825814901788672', 'BS1', '121111', '生产材料/原材料减值', 'allowance production material/raw material', '€', '5', '1630825566250864640', 0, '/1630784869674127360/1630824894071705600/1630825087282319360/1630825203519066112/1630825566250864640/1630825814901788672', '/财务-资产负责类/资产/流动资产/存货/原材料及供应/生产材料/原材料减值', '/BS/A1000/A1200/A1210/121100/121111', NULL, 2, '0', '1', '1', '2023-03-01 15:02:28', '1', '2023-03-01 15:02:28');
INSERT INTO `qf_subject_international_info` VALUES ('1630825815468019712', 'BS1', '121120', '间接材料存货', 'inventory indirect material', '€', '5', '1630825566250864640', 0, '/1630784869674127360/1630824894071705600/1630825087282319360/1630825203519066112/1630825566250864640/1630825815468019712', '/财务-资产负责类/资产/流动资产/存货/原材料及供应/间接材料存货', '/BS/A1000/A1200/A1210/121100/121120', NULL, 3, '0', '1', '1', '2023-03-01 15:02:28', '1', '2023-03-01 15:02:28');
INSERT INTO `qf_subject_international_info` VALUES ('1630825816000696320', 'BS1', '121121', '间接材料减值', 'allowance indirect material', '€', '5', '1630825566250864640', 0, '/1630784869674127360/1630824894071705600/1630825087282319360/1630825203519066112/1630825566250864640/1630825816000696320', '/财务-资产负责类/资产/流动资产/存货/原材料及供应/间接材料减值', '/BS/A1000/A1200/A1210/121100/121121', NULL, 4, '0', '1', '1', '2023-03-01 15:02:29', '1', '2023-03-01 15:02:29');
INSERT INTO `qf_subject_international_info` VALUES ('1630825816558538752', 'BS1', '121210', '在产品库存', 'inventory work in progress', '€', '5', '1630825566833872896', 0, '/1630784869674127360/1630824894071705600/1630825087282319360/1630825203519066112/1630825566833872896/1630825816558538752', '/财务-资产负责类/资产/流动资产/存货/半成品/在产品库存', '/BS/A1000/A1200/A1210/121200/121210', NULL, 1, '0', '1', '1', '2023-03-01 15:02:29', '1', '2023-03-01 15:02:29');
INSERT INTO `qf_subject_international_info` VALUES ('1630825817145741312', 'BS1', '121211', '在产品减值', 'allowance work in progress', '€', '5', '1630825566833872896', 0, '/1630784869674127360/1630824894071705600/1630825087282319360/1630825203519066112/1630825566833872896/1630825817145741312', '/财务-资产负责类/资产/流动资产/存货/半成品/在产品减值', '/BS/A1000/A1200/A1210/121200/121211', NULL, 2, '0', '1', '1', '2023-03-01 15:02:29', '1', '2023-03-01 15:02:29');
INSERT INTO `qf_subject_international_info` VALUES ('1630825817917493248', 'BS1', '121220', '混合物库存', 'inventory mixtures', '€', '5', '1630825566833872896', 0, '/1630784869674127360/1630824894071705600/1630825087282319360/1630825203519066112/1630825566833872896/1630825817917493248', '/财务-资产负责类/资产/流动资产/存货/半成品/混合物库存', '/BS/A1000/A1200/A1210/121200/121220', NULL, 3, '0', '1', '1', '2023-03-01 15:02:29', '1', '2023-03-01 15:02:29');
INSERT INTO `qf_subject_international_info` VALUES ('1630825818559221760', 'BS1', '121230', '来自合并公司的混合物库存', 'Inventory mixtures from consolidated companies', '€', '5', '1630825566833872896', 0, '/1630784869674127360/1630824894071705600/1630825087282319360/1630825203519066112/1630825566833872896/1630825818559221760', '/财务-资产负责类/资产/流动资产/存货/半成品/来自合并公司的混合物库存', '/BS/A1000/A1200/A1210/121200/121230', NULL, 4, '0', '1', '1', '2023-03-01 15:02:29', '1', '2023-03-01 15:02:29');
INSERT INTO `qf_subject_international_info` VALUES ('1630825820090142720', 'BS1', '121310', '产成品库存', 'inventory finished goods', '€', '5', '1630825567421075456', 0, '/1630784869674127360/1630824894071705600/1630825087282319360/1630825203519066112/1630825567421075456/1630825820090142720', '/财务-资产负责类/资产/流动资产/存货/产成品/产成品库存', '/BS/A1000/A1200/A1210/121300/121310', NULL, 1, '0', '1', '1', '2023-03-01 15:02:29', '1', '2023-03-01 15:02:30');
INSERT INTO `qf_subject_international_info` VALUES ('1630825820660568064', 'BS1', '121311', '产成品减值', 'allowance finished goods', '€', '5', '1630825567421075456', 0, '/1630784869674127360/1630824894071705600/1630825087282319360/1630825203519066112/1630825567421075456/1630825820660568064', '/财务-资产负责类/资产/流动资产/存货/产成品/产成品减值', '/BS/A1000/A1200/A1210/121300/121311', NULL, 2, '0', '1', '1', '2023-03-01 15:02:30', '1', '2023-03-01 15:02:30');
INSERT INTO `qf_subject_international_info` VALUES ('1630825821210021888', 'BS1', '121410', '库存商品', 'inventory merchandise', '€', '5', '1630825568926830592', 0, '/1630784869674127360/1630824894071705600/1630825087282319360/1630825203519066112/1630825568926830592/1630825821210021888', '/财务-资产负责类/资产/流动资产/存货/商品/库存商品', '/BS/A1000/A1200/A1210/121400/121410', NULL, 1, '0', '1', '1', '2023-03-01 15:02:30', '1', '2023-03-01 15:02:30');
INSERT INTO `qf_subject_international_info` VALUES ('1630825821814001664', 'BS1', '121411', '商品减值', 'allowance merchandise', '€', '5', '1630825568926830592', 0, '/1630784869674127360/1630824894071705600/1630825087282319360/1630825203519066112/1630825568926830592/1630825821814001664', '/财务-资产负责类/资产/流动资产/存货/商品/商品减值', '/BS/A1000/A1200/A1210/121400/121411', NULL, 2, '0', '1', '1', '2023-03-01 15:02:30', '1', '2023-03-01 15:02:30');
INSERT INTO `qf_subject_international_info` VALUES ('1630825822430564352', 'BS1', '121510', '开发产品资本化', 'inventory development costs', '€', '5', '1630825569736331264', 0, '/1630784869674127360/1630824894071705600/1630825087282319360/1630825203519066112/1630825569736331264/1630825822430564352', '/财务-资产负责类/资产/流动资产/存货/在产品/半成品/开发产品资本化', '/BS/A1000/A1200/A1210/121500/121510', NULL, 1, '0', '1', '1', '2023-03-01 15:02:30', '1', '2023-03-01 15:02:30');
INSERT INTO `qf_subject_international_info` VALUES ('1630825823219093504', 'BS1', '121511', '开发产品减值', 'allowance development costs', '€', '5', '1630825569736331264', 0, '/1630784869674127360/1630824894071705600/1630825087282319360/1630825203519066112/1630825569736331264/1630825823219093504', '/财务-资产负责类/资产/流动资产/存货/在产品/半成品/开发产品减值', '/BS/A1000/A1200/A1210/121500/121511', NULL, 2, '0', '1', '1', '2023-03-01 15:02:30', '1', '2023-03-01 15:02:31');
INSERT INTO `qf_subject_international_info` VALUES ('1630825824938758144', 'BS1', '121520', '在制模具库存', 'inventory unfinished tools', '€', '5', '1630825569736331264', 0, '/1630784869674127360/1630824894071705600/1630825087282319360/1630825203519066112/1630825569736331264/1630825824938758144', '/财务-资产负责类/资产/流动资产/存货/在产品/半成品/在制模具库存', '/BS/A1000/A1200/A1210/121500/121520', NULL, 3, '0', '1', '1', '2023-03-01 15:02:31', '1', '2023-03-01 15:02:31');
INSERT INTO `qf_subject_international_info` VALUES ('1630825826431930368', 'BS1', '121521', '在制模具减值', 'allowance unfinished tools', '€', '5', '1630825569736331264', 0, '/1630784869674127360/1630824894071705600/1630825087282319360/1630825203519066112/1630825569736331264/1630825826431930368', '/财务-资产负责类/资产/流动资产/存货/在产品/半成品/在制模具减值', '/BS/A1000/A1200/A1210/121500/121521', NULL, 4, '0', '1', '1', '2023-03-01 15:02:31', '1', '2023-03-01 15:02:31');
INSERT INTO `qf_subject_international_info` VALUES ('1630825827006550016', 'BS1', '121610', '在途材料', 'material in transit', '€', '5', '1630825570390642688', 0, '/1630784869674127360/1630824894071705600/1630825087282319360/1630825203519066112/1630825570390642688/1630825827006550016', '/财务-资产负责类/资产/流动资产/存货/在途产品/材料/在途材料', '/BS/A1000/A1200/A1210/121600/121610', NULL, 1, '0', '1', '1', '2023-03-01 15:02:31', '1', '2023-03-01 15:02:31');
INSERT INTO `qf_subject_international_info` VALUES ('1630825827706998784', 'BS1', '121620', '在途产成品', 'finished goods in transit', '€', '5', '1630825570390642688', 0, '/1630784869674127360/1630824894071705600/1630825087282319360/1630825203519066112/1630825570390642688/1630825827706998784', '/财务-资产负责类/资产/流动资产/存货/在途产品/材料/在途产成品', '/BS/A1000/A1200/A1210/121600/121620', NULL, 2, '0', '1', '1', '2023-03-01 15:02:31', '1', '2023-03-01 15:02:31');
INSERT INTO `qf_subject_international_info` VALUES ('1630825828600385536', 'BS1', '121710', '设备备件', 'Spareparts for equipment', '€', '5', '1630825570977845248', 0, '/1630784869674127360/1630824894071705600/1630825087282319360/1630825203519066112/1630825570977845248/1630825828600385536', '/财务-资产负责类/资产/流动资产/存货/设备备件/设备备件', '/BS/A1000/A1200/A1210/121700/121710', NULL, 1, '0', '1', '1', '2023-03-01 15:02:32', '1', '2023-03-01 15:02:32');
INSERT INTO `qf_subject_international_info` VALUES ('1630825829342777344', 'BS1', '122101', '国内应收账款', 'Trade receivables domestic', '€', '5', '1630825571569242112', 0, '/1630784869674127360/1630824894071705600/1630825087282319360/1630825204102074368/1630825571569242112/1630825829342777344', '/财务-资产负责类/资产/流动资产/应收账款和其他资产/应收账款及合同资产/国内应收账款', '/BS/A1000/A1200/A1220/122100/122101', NULL, 1, '0', '1', '1', '2023-03-01 15:02:32', '1', '2023-03-01 15:02:32');
INSERT INTO `qf_subject_international_info` VALUES ('1630825829934174208', 'BS1', '122102', '国外应收账款', 'Trade receivables foreign countries', '€', '5', '1630825571569242112', 0, '/1630784869674127360/1630824894071705600/1630825087282319360/1630825204102074368/1630825571569242112/1630825829934174208', '/财务-资产负责类/资产/流动资产/应收账款和其他资产/应收账款及合同资产/国外应收账款', '/BS/A1000/A1200/A1220/122100/122102', NULL, 2, '0', '1', '1', '2023-03-01 15:02:32', '1', '2023-03-01 15:02:32');
INSERT INTO `qf_subject_international_info` VALUES ('1630825830512988160', 'BS1', '122103', '外包应收账款', 'Trade receivables sold to Factor', '€', '5', '1630825571569242112', 0, '/1630784869674127360/1630824894071705600/1630825087282319360/1630825204102074368/1630825571569242112/1630825830512988160', '/财务-资产负责类/资产/流动资产/应收账款和其他资产/应收账款及合同资产/外包应收账款', '/BS/A1000/A1200/A1220/122100/122103', NULL, 3, '0', '1', '1', '2023-03-01 15:02:32', '1', '2023-03-01 15:02:32');
INSERT INTO `qf_subject_international_info` VALUES ('1630825831146328064', 'BS1', '122104', '短期合同资产', 'Contract assets (PoC) short term', '€', '5', '1630825571569242112', 0, '/1630784869674127360/1630824894071705600/1630825087282319360/1630825204102074368/1630825571569242112/1630825831146328064', '/财务-资产负责类/资产/流动资产/应收账款和其他资产/应收账款及合同资产/短期合同资产', '/BS/A1000/A1200/A1220/122100/122104', NULL, 4, '0', '1', '1', '2023-03-01 15:02:32', '1', '2023-03-01 15:02:32');
INSERT INTO `qf_subject_international_info` VALUES ('1630825831741919232', 'BS1', '122106', '应收账款单项坏账准备', 'Individual  bad debts allowances on trade receivables', '€', '5', '1630825571569242112', 0, '/1630784869674127360/1630824894071705600/1630825087282319360/1630825204102074368/1630825571569242112/1630825831741919232', '/财务-资产负责类/资产/流动资产/应收账款和其他资产/应收账款及合同资产/应收账款单项坏账准备', '/BS/A1000/A1200/A1220/122100/122106', NULL, 5, '0', '1', '1', '2023-03-01 15:02:32', '1', '2023-03-01 15:02:32');
INSERT INTO `qf_subject_international_info` VALUES ('1630825832320733184', 'BS1', '122112', '按零件价格摊销的工装应收账款', 'Trade receivables from tooling when amortization by part price', '€', '5', '1630825571569242112', 0, '/1630784869674127360/1630824894071705600/1630825087282319360/1630825204102074368/1630825571569242112/1630825832320733184', '/财务-资产负责类/资产/流动资产/应收账款和其他资产/应收账款及合同资产/按零件价格摊销的工装应收账款', '/BS/A1000/A1200/A1220/122100/122112', NULL, 6, '0', '1', '1', '2023-03-01 15:02:32', '1', '2023-03-01 15:02:32');
INSERT INTO `qf_subject_international_info` VALUES ('1630825832907935744', 'BS1', '122113', '应收关联方应收账款', 'Trade receivables to related parties', '€', '5', '1630825571569242112', 0, '/1630784869674127360/1630824894071705600/1630825087282319360/1630825204102074368/1630825571569242112/1630825832907935744', '/财务-资产负责类/资产/流动资产/应收账款和其他资产/应收账款及合同资产/应收关联方应收账款', '/BS/A1000/A1200/A1220/122100/122113', NULL, 7, '0', '1', '1', '2023-03-01 15:02:33', '1', '2023-03-01 15:02:33');
INSERT INTO `qf_subject_international_info` VALUES ('1630825833499332608', 'BS1', '122114', '应收票据', 'Notes receivables', '€', '5', '1630825571569242112', 0, '/1630784869674127360/1630824894071705600/1630825087282319360/1630825204102074368/1630825571569242112/1630825833499332608', '/财务-资产负责类/资产/流动资产/应收账款和其他资产/应收账款及合同资产/应收票据', '/BS/A1000/A1200/A1220/122100/122114', NULL, 8, '0', '1', '1', '2023-03-01 15:02:33', '1', '2023-03-01 15:02:33');
INSERT INTO `qf_subject_international_info` VALUES ('1630825834073952256', 'BS1', 'A12210', '其他资产', 'other assets', '€', '5', '1630825572169027584', 13, '/1630784869674127360/1630824894071705600/1630825087282319360/1630825204102074368/1630825572169027584/1630825834073952256', '/财务-资产负责类/资产/流动资产/应收账款和其他资产/其他资产/其他资产', '/BS/A1000/A1200/A1220/A1221/A12210', NULL, 1, '0', '1', '1', '2023-03-01 15:02:33', '1', '2023-03-01 15:06:16');
INSERT INTO `qf_subject_international_info` VALUES ('1630825834669543424', 'BS1', 'A12211', '其他税务资产', 'other tax assets', '€', '5', '1630825572169027584', 2, '/1630784869674127360/1630824894071705600/1630825087282319360/1630825204102074368/1630825572169027584/1630825834669543424', '/财务-资产负责类/资产/流动资产/应收账款和其他资产/其他资产/其他税务资产', '/BS/A1000/A1200/A1220/A1221/A12211', NULL, 2, '0', '1', '1', '2023-03-01 15:02:33', '1', '2023-03-01 15:06:16');
INSERT INTO `qf_subject_international_info` VALUES ('1630825835281911808', 'BS1', '131102', '维护费用预付', 'prepaid expenses maintenance', '€', '5', '1630825572739452928', 0, '/1630784869674127360/1630824894071705600/1630825087282319360/1630825204102074368/1630825572739452928/1630825835281911808', '/财务-资产负责类/资产/流动资产/应收账款和其他资产/预付费用/维护费用预付', '/BS/A1000/A1200/A1220/131100/131102', NULL, 1, '0', '1', '1', '2023-03-01 15:02:33', '1', '2023-03-01 15:02:33');
INSERT INTO `qf_subject_international_info` VALUES ('1630825835932028928', 'BS1', '131104', '保险费用预付', 'prepaid expenses insurances', '€', '5', '1630825572739452928', 0, '/1630784869674127360/1630824894071705600/1630825087282319360/1630825204102074368/1630825572739452928/1630825835932028928', '/财务-资产负责类/资产/流动资产/应收账款和其他资产/预付费用/保险费用预付', '/BS/A1000/A1200/A1220/131100/131104', NULL, 2, '0', '1', '1', '2023-03-01 15:02:33', '1', '2023-03-01 15:02:33');
INSERT INTO `qf_subject_international_info` VALUES ('1630825836498259968', 'BS1', '131105', '银行利息费用应付', 'prepaid expenses bank interests', '€', '5', '1630825572739452928', 0, '/1630784869674127360/1630824894071705600/1630825087282319360/1630825204102074368/1630825572739452928/1630825836498259968', '/财务-资产负责类/资产/流动资产/应收账款和其他资产/预付费用/银行利息费用应付', '/BS/A1000/A1200/A1220/131100/131105', NULL, 3, '0', '1', '1', '2023-03-01 15:02:33', '1', '2023-03-01 15:02:33');
INSERT INTO `qf_subject_international_info` VALUES ('1630825837085462528', 'BS1', '131106', '银行费用应付', 'prepaid expenses bank fees', '€', '5', '1630825572739452928', 0, '/1630784869674127360/1630824894071705600/1630825087282319360/1630825204102074368/1630825572739452928/1630825837085462528', '/财务-资产负责类/资产/流动资产/应收账款和其他资产/预付费用/银行费用应付', '/BS/A1000/A1200/A1220/131100/131106', NULL, 4, '0', '1', '1', '2023-03-01 15:02:34', '1', '2023-03-01 15:02:34');
INSERT INTO `qf_subject_international_info` VALUES ('1630825837639110656', 'BS1', '131107', '咨询费用应付', 'prepaid expenses consulting', '€', '5', '1630825572739452928', 0, '/1630784869674127360/1630824894071705600/1630825087282319360/1630825204102074368/1630825572739452928/1630825837639110656', '/财务-资产负责类/资产/流动资产/应收账款和其他资产/预付费用/咨询费用应付', '/BS/A1000/A1200/A1220/131100/131107', NULL, 5, '0', '1', '1', '2023-03-01 15:02:34', '1', '2023-03-01 15:02:34');
INSERT INTO `qf_subject_international_info` VALUES ('1630825838243090432', 'BS1', '131109', '其他费用应付', 'prepaid expenses other', '€', '5', '1630825572739452928', 0, '/1630784869674127360/1630824894071705600/1630825087282319360/1630825204102074368/1630825572739452928/1630825838243090432', '/财务-资产负责类/资产/流动资产/应收账款和其他资产/预付费用/其他费用应付', '/BS/A1000/A1200/A1220/131100/131109', NULL, 6, '0', '1', '1', '2023-03-01 15:02:34', '1', '2023-03-01 15:02:34');
INSERT INTO `qf_subject_international_info` VALUES ('1630825838821904384', 'BS1', '122204', '应收萨固密管理公司款项', 'Trade receivables  SaarGummi Verwaltungs-GmbH', '€', '5', '1630825573649616896', 0, '/1630784869674127360/1630824894071705600/1630825087282319360/1630825205607829504/1630825573649616896/1630825838821904384', '/财务-资产负责类/资产/流动资产/应收关联公司款项/附属公司间应收账款/应收萨固密管理公司款项', '/BS/A1000/A1200/A1225/122200/122204', NULL, 1, '0', '1', '1', '2023-03-01 15:02:34', '1', '2023-03-01 15:02:34');
INSERT INTO `qf_subject_international_info` VALUES ('1630825839417495552', 'BS1', '122206', '应收萨固密汽车密封件公司款项', 'Trade receivables SaarGummi Automotive Sealings GmbH', '€', '5', '1630825573649616896', 0, '/1630784869674127360/1630824894071705600/1630825087282319360/1630825205607829504/1630825573649616896/1630825839417495552', '/财务-资产负责类/资产/流动资产/应收关联公司款项/附属公司间应收账款/应收萨固密汽车密封件公司款项', '/BS/A1000/A1200/A1225/122200/122206', NULL, 2, '0', '1', '1', '2023-03-01 15:02:34', '1', '2023-03-01 15:02:34');
INSERT INTO `qf_subject_international_info` VALUES ('1630825840034058240', 'BS1', '122208', '应收萨固密伊比利亚公司款项', 'Trade receivables  SaarGummi Iberica S.A.', '€', '5', '1630825573649616896', 0, '/1630784869674127360/1630824894071705600/1630825087282319360/1630825205607829504/1630825573649616896/1630825840034058240', '/财务-资产负责类/资产/流动资产/应收关联公司款项/附属公司间应收账款/应收萨固密伊比利亚公司款项', '/BS/A1000/A1200/A1225/122200/122208', NULL, 3, '0', '1', '1', '2023-03-01 15:02:34', '1', '2023-03-01 15:02:34');
INSERT INTO `qf_subject_international_info` VALUES ('1630825840596094976', 'BS1', '122209', '应收萨固密斯洛伐克公司款项', 'Trade receivables  SaarGummi Slovakia s.r.o.', '€', '5', '1630825573649616896', 0, '/1630784869674127360/1630824894071705600/1630825087282319360/1630825205607829504/1630825573649616896/1630825840596094976', '/财务-资产负责类/资产/流动资产/应收关联公司款项/附属公司间应收账款/应收萨固密斯洛伐克公司款项', '/BS/A1000/A1200/A1225/122200/122209', NULL, 4, '0', '1', '1', '2023-03-01 15:02:34', '1', '2023-03-01 15:02:34');
INSERT INTO `qf_subject_international_info` VALUES ('1630825841288155136', 'BS1', '122211', '应收萨固密捷克公司款项', 'Trade receivables  Saar Gummi Czech s.r.o.', '€', '5', '1630825573649616896', 0, '/1630784869674127360/1630824894071705600/1630825087282319360/1630825205607829504/1630825573649616896/1630825841288155136', '/财务-资产负责类/资产/流动资产/应收关联公司款项/附属公司间应收账款/应收萨固密捷克公司款项', '/BS/A1000/A1200/A1225/122200/122211', NULL, 5, '0', '1', '1', '2023-03-01 15:02:35', '1', '2023-03-01 15:02:35');
INSERT INTO `qf_subject_international_info` VALUES ('1630825842772938752', 'BS1', '122212', '应收CQLT萨固密技术公司款项', 'Trade receivables CQLT SaarGummi Technologies S.a r.l. Luxembourg', '€', '5', '1630825573649616896', 0, '/1630784869674127360/1630824894071705600/1630825087282319360/1630825205607829504/1630825573649616896/1630825842772938752', '/财务-资产负责类/资产/流动资产/应收关联公司款项/附属公司间应收账款/应收CQLT萨固密技术公司款项', '/BS/A1000/A1200/A1225/122200/122212', NULL, 6, '0', '1', '1', '2023-03-01 15:02:35', '1', '2023-03-01 15:02:35');
INSERT INTO `qf_subject_international_info` VALUES ('1630825843402084352', 'BS1', '122213', '应收萨固密巴西公司款项', 'Trade receivables  SaarGummi do Brasil Ltda.', '€', '5', '1630825573649616896', 0, '/1630784869674127360/1630824894071705600/1630825087282319360/1630825205607829504/1630825573649616896/1630825843402084352', '/财务-资产负责类/资产/流动资产/应收关联公司款项/附属公司间应收账款/应收萨固密巴西公司款项', '/BS/A1000/A1200/A1225/122200/122213', NULL, 7, '0', '1', '1', '2023-03-01 15:02:35', '1', '2023-03-01 15:02:35');
INSERT INTO `qf_subject_international_info` VALUES ('1630825844035424256', 'BS1', '122215', '应收萨固密田纳西公司款项', 'Trade receivables  SaarGummi Tennessee Inc.', '€', '5', '1630825573649616896', 0, '/1630784869674127360/1630824894071705600/1630825087282319360/1630825205607829504/1630825573649616896/1630825844035424256', '/财务-资产负责类/资产/流动资产/应收关联公司款项/附属公司间应收账款/应收萨固密田纳西公司款项', '/BS/A1000/A1200/A1225/122200/122215', NULL, 8, '0', '1', '1', '2023-03-01 15:02:35', '1', '2023-03-01 15:02:35');
INSERT INTO `qf_subject_international_info` VALUES ('1630825844605849600', 'BS1', '122216', '应收萨固密印度公司款项', 'Trade receivables  Gold Seal SaarGummi India Ltd.', '€', '5', '1630825573649616896', 0, '/1630784869674127360/1630824894071705600/1630825087282319360/1630825205607829504/1630825573649616896/1630825844605849600', '/财务-资产负责类/资产/流动资产/应收关联公司款项/附属公司间应收账款/应收萨固密印度公司款项', '/BS/A1000/A1200/A1225/122200/122216', NULL, 9, '0', '1', '1', '2023-03-01 15:02:35', '1', '2023-03-01 15:02:35');
INSERT INTO `qf_subject_international_info` VALUES ('1630825845167886336', 'BS1', '122219', '应收萨固密俄罗斯公司款项', 'Trade receivables  SaarGummi Russland Ltd,', '€', '5', '1630825573649616896', 0, '/1630784869674127360/1630824894071705600/1630825087282319360/1630825205607829504/1630825573649616896/1630825845167886336', '/财务-资产负责类/资产/流动资产/应收关联公司款项/附属公司间应收账款/应收萨固密俄罗斯公司款项', '/BS/A1000/A1200/A1225/122200/122219', NULL, 10, '0', '1', '1', '2023-03-01 15:02:35', '1', '2023-03-01 15:02:35');
INSERT INTO `qf_subject_international_info` VALUES ('1630825845784449024', 'BS1', '122220', '应收萨固密德国控股公司款项', 'Trade receivables  SaarGummi Deutschland Holding GmbH', '€', '5', '1630825573649616896', 0, '/1630784869674127360/1630824894071705600/1630825087282319360/1630825205607829504/1630825573649616896/1630825845784449024', '/财务-资产负责类/资产/流动资产/应收关联公司款项/附属公司间应收账款/应收萨固密德国控股公司款项', '/BS/A1000/A1200/A1225/122200/122220', NULL, 11, '0', '1', '1', '2023-03-01 15:02:36', '1', '2023-03-01 15:02:36');
INSERT INTO `qf_subject_international_info` VALUES ('1630825846346485760', 'BS1', '122221', '应收CQLT萨固密德国公司款项', 'Trade receivables CQLT SaarGummi Deutschland GmbH', '€', '5', '1630825573649616896', 0, '/1630784869674127360/1630824894071705600/1630825087282319360/1630825205607829504/1630825573649616896/1630825846346485760', '/财务-资产负责类/资产/流动资产/应收关联公司款项/附属公司间应收账款/应收CQLT萨固密德国公司款项', '/BS/A1000/A1200/A1225/122200/122221', NULL, 12, '0', '1', '1', '2023-03-01 15:02:36', '1', '2023-03-01 15:02:36');
INSERT INTO `qf_subject_international_info` VALUES ('1630825846942076928', 'BS1', '122226', '应收萨固密贝特林根公司款项', 'Trade receivables  SaarGummi Beteiligungs GmbH', '€', '5', '1630825573649616896', 0, '/1630784869674127360/1630824894071705600/1630825087282319360/1630825205607829504/1630825573649616896/1630825846942076928', '/财务-资产负责类/资产/流动资产/应收关联公司款项/附属公司间应收账款/应收萨固密贝特林根公司款项', '/BS/A1000/A1200/A1225/122200/122226', NULL, 13, '0', '1', '1', '2023-03-01 15:02:36', '1', '2023-03-01 15:02:36');
INSERT INTO `qf_subject_international_info` VALUES ('1630825847537668096', 'BS1', '122232', '应收兴渝有限公司款项', 'Trade receivablesCQLT International Investment Company Ltd, China', '€', '5', '1630825573649616896', 0, '/1630784869674127360/1630824894071705600/1630825087282319360/1630825205607829504/1630825573649616896/1630825847537668096', '/财务-资产负责类/资产/流动资产/应收关联公司款项/附属公司间应收账款/应收兴渝有限公司款项', '/BS/A1000/A1200/A1225/122200/122232', NULL, 14, '0', '1', '1', '2023-03-01 15:02:36', '1', '2023-03-01 15:02:36');
INSERT INTO `qf_subject_international_info` VALUES ('1630825848137453568', 'BS1', '122233', '应收兴渝国际控股（香港）有限公司款项', 'Trade receivablesCQLT International Investment Holding Ltd, HK', '€', '5', '1630825573649616896', 0, '/1630784869674127360/1630824894071705600/1630825087282319360/1630825205607829504/1630825573649616896/1630825848137453568', '/财务-资产负责类/资产/流动资产/应收关联公司款项/附属公司间应收账款/应收兴渝国际控股（香港）有限公司款项', '/BS/A1000/A1200/A1225/122200/122233', NULL, 15, '0', '1', '1', '2023-03-01 15:02:36', '1', '2023-03-01 15:02:36');
INSERT INTO `qf_subject_international_info` VALUES ('1630825848724656128', 'BS1', '122239', '应收萨固密（中国）投资有限公司款项', 'trade receivables SaarGummi China Investment Co. Ltd.', '€', '5', '1630825573649616896', 0, '/1630784869674127360/1630824894071705600/1630825087282319360/1630825205607829504/1630825573649616896/1630825848724656128', '/财务-资产负责类/资产/流动资产/应收关联公司款项/附属公司间应收账款/应收萨固密（中国）投资有限公司款项', '/BS/A1000/A1200/A1225/122200/122239', NULL, 16, '0', '1', '1', '2023-03-01 15:02:36', '1', '2023-03-01 15:02:36');
INSERT INTO `qf_subject_international_info` VALUES ('1630825849332830208', 'BS1', '122241', '应收萨固密渝锦（重庆）橡塑制品有限公司款项', 'receivables SG Yujin  Rubber & Plastic Products Co. Ltd', '€', '5', '1630825573649616896', 0, '/1630784869674127360/1630824894071705600/1630825087282319360/1630825205607829504/1630825573649616896/1630825849332830208', '/财务-资产负责类/资产/流动资产/应收关联公司款项/附属公司间应收账款/应收萨固密渝锦（重庆）橡塑制品有限公司款项', '/BS/A1000/A1200/A1225/122200/122241', NULL, 17, '0', '1', '1', '2023-03-01 15:02:36', '1', '2023-03-01 15:02:36');
INSERT INTO `qf_subject_international_info` VALUES ('1630825849928421376', 'BS1', '122242', '应收萨固密（重庆）密封系统有限公司款项', 'receivables SaarGummi( Chongqing) Sealing System Co.,ltd', '€', '5', '1630825573649616896', 0, '/1630784869674127360/1630824894071705600/1630825087282319360/1630825205607829504/1630825573649616896/1630825849928421376', '/财务-资产负责类/资产/流动资产/应收关联公司款项/附属公司间应收账款/应收萨固密（重庆）密封系统有限公司款项', '/BS/A1000/A1200/A1225/122200/122242', NULL, 18, '0', '1', '1', '2023-03-01 15:02:37', '1', '2023-03-01 15:02:37');
INSERT INTO `qf_subject_international_info` VALUES ('1630825850532401152', 'BS1', '122244', '应收萨固密（营口）密封系统有限公司款项', 'Trade receivables SaarGummi (Yingkou) Sealing System Co. LTD.', '€', '5', '1630825573649616896', 0, '/1630784869674127360/1630824894071705600/1630825087282319360/1630825205607829504/1630825573649616896/1630825850532401152', '/财务-资产负责类/资产/流动资产/应收关联公司款项/附属公司间应收账款/应收萨固密（营口）密封系统有限公司款项', '/BS/A1000/A1200/A1225/122200/122244', NULL, 19, '0', '1', '1', '2023-03-01 15:02:37', '1', '2023-03-01 15:02:37');
INSERT INTO `qf_subject_international_info` VALUES ('1630825851094437888', 'BS1', '122245', '应收萨固密国际系统有限公司款项', 'trade receivables SaarGummi International Systems GmbH', '€', '5', '1630825573649616896', 0, '/1630784869674127360/1630824894071705600/1630825087282319360/1630825205607829504/1630825573649616896/1630825851094437888', '/财务-资产负责类/资产/流动资产/应收关联公司款项/附属公司间应收账款/应收萨固密国际系统有限公司款项', '/BS/A1000/A1200/A1225/122200/122245', NULL, 20, '0', '1', '1', '2023-03-01 15:02:37', '1', '2023-03-01 15:02:37');
INSERT INTO `qf_subject_international_info` VALUES ('1630825851740360704', 'BS1', '122246', '应收萨固密（上海）橡塑技术有限公司款项', 'trade receivables SaarGummi (Shanghai) Rubber Technologies Co. Ltd.', '€', '5', '1630825573649616896', 0, '/1630784869674127360/1630824894071705600/1630825087282319360/1630825205607829504/1630825573649616896/1630825851740360704', '/财务-资产负责类/资产/流动资产/应收关联公司款项/附属公司间应收账款/应收萨固密（上海）橡塑技术有限公司款项', '/BS/A1000/A1200/A1225/122200/122246', NULL, 21, '0', '1', '1', '2023-03-01 15:02:37', '1', '2023-03-01 15:02:37');
INSERT INTO `qf_subject_international_info` VALUES ('1630825852386283520', 'BS1', '122247', '应收萨固密墨西哥公司款项', 'trade receivables SaarGummi Mexico', '€', '5', '1630825573649616896', 0, '/1630784869674127360/1630824894071705600/1630825087282319360/1630825205607829504/1630825573649616896/1630825852386283520', '/财务-资产负责类/资产/流动资产/应收关联公司款项/附属公司间应收账款/应收萨固密墨西哥公司款项', '/BS/A1000/A1200/A1225/122200/122247', NULL, 22, '0', '1', '1', '2023-03-01 15:02:37', '1', '2023-03-01 15:02:37');
INSERT INTO `qf_subject_international_info` VALUES ('1630825852981874688', 'BS1', '122248', '应收萨固密NEO公司款项', 'trade receivables SaarGummi Neo GmbH', '€', '5', '1630825573649616896', 0, '/1630784869674127360/1630824894071705600/1630825087282319360/1630825205607829504/1630825573649616896/1630825852981874688', '/财务-资产负责类/资产/流动资产/应收关联公司款项/附属公司间应收账款/应收萨固密NEO公司款项', '/BS/A1000/A1200/A1225/122200/122248', NULL, 23, '0', '1', '1', '2023-03-01 15:02:37', '1', '2023-03-01 15:02:37');
INSERT INTO `qf_subject_international_info` VALUES ('1630825853564882944', 'BS1', '122249', '应收萨固密法国公司款项', 'trade receivables SaarGummi France S.A.', '€', '5', '1630825573649616896', 0, '/1630784869674127360/1630824894071705600/1630825087282319360/1630825205607829504/1630825573649616896/1630825853564882944', '/财务-资产负责类/资产/流动资产/应收关联公司款项/附属公司间应收账款/应收萨固密法国公司款项', '/BS/A1000/A1200/A1225/122200/122249', NULL, 24, '0', '1', '1', '2023-03-01 15:02:37', '1', '2023-03-01 15:02:37');
INSERT INTO `qf_subject_international_info` VALUES ('1630825854286303232', 'BS1', '122251', '应收萨固密土耳其公司款项', 'trade receivables SAARGUMMİ TURKEY KAUÇUK VE PLASTİK LİMİTED ŞİRKETİ', '€', '5', '1630825573649616896', 0, '/1630784869674127360/1630824894071705600/1630825087282319360/1630825205607829504/1630825573649616896/1630825854286303232', '/财务-资产负责类/资产/流动资产/应收关联公司款项/附属公司间应收账款/应收萨固密土耳其公司款项', '/BS/A1000/A1200/A1225/122200/122251', NULL, 25, '0', '1', '1', '2023-03-01 15:02:38', '1', '2023-03-01 15:02:38');
INSERT INTO `qf_subject_international_info` VALUES ('1630825854894477312', 'BS1', '122298', '公司间合同资产', 'Contracted assets Intercompany', '€', '5', '1630825573649616896', 0, '/1630784869674127360/1630824894071705600/1630825087282319360/1630825205607829504/1630825573649616896/1630825854894477312', '/财务-资产负责类/资产/流动资产/应收关联公司款项/附属公司间应收账款/公司间合同资产', '/BS/A1000/A1200/A1225/122200/122298', NULL, 26, '0', '1', '1', '2023-03-01 15:02:38', '1', '2023-03-01 15:02:38');
INSERT INTO `qf_subject_international_info` VALUES ('1630825855523622912', 'BS1', '122304', '应收萨固密管理公司贷款', 'Loan receivables SaarGummi Verwaltungs-GmbH', '€', '5', '1630825574438146048', 0, '/1630784869674127360/1630824894071705600/1630825087282319360/1630825206216003584/1630825574438146048/1630825855523622912', '/财务-资产负责类/资产/流动资产/应收关联公司贷款/应收附属公司间贷款/应收萨固密管理公司贷款', '/BS/A1000/A1200/A1227/122300/122304', NULL, 1, '0', '1', '1', '2023-03-01 15:02:38', '1', '2023-03-01 15:02:38');
INSERT INTO `qf_subject_international_info` VALUES ('1630825856115019776', 'BS1', '122306', '应收萨固密汽车密封件公司贷款', 'Loan receivables SaarGummi Automotive Sealings GmbH', '€', '5', '1630825574438146048', 0, '/1630784869674127360/1630824894071705600/1630825087282319360/1630825206216003584/1630825574438146048/1630825856115019776', '/财务-资产负责类/资产/流动资产/应收关联公司贷款/应收附属公司间贷款/应收萨固密汽车密封件公司贷款', '/BS/A1000/A1200/A1227/122300/122306', NULL, 2, '0', '1', '1', '2023-03-01 15:02:38', '1', '2023-03-01 15:02:38');
INSERT INTO `qf_subject_international_info` VALUES ('1630825856765136896', 'BS1', '122308', '应收萨固密伊比利亚公司贷款', 'Loan receivables SaarGummi Iberica S.A.', '€', '5', '1630825574438146048', 0, '/1630784869674127360/1630824894071705600/1630825087282319360/1630825206216003584/1630825574438146048/1630825856765136896', '/财务-资产负责类/资产/流动资产/应收关联公司贷款/应收附属公司间贷款/应收萨固密伊比利亚公司贷款', '/BS/A1000/A1200/A1227/122300/122308', NULL, 3, '0', '1', '1', '2023-03-01 15:02:38', '1', '2023-03-01 15:02:38');
INSERT INTO `qf_subject_international_info` VALUES ('1630825857343950848', 'BS1', '122309', '应收萨固密斯洛伐克公司贷款', 'Loan receivables SaarGummi Slovakia s.r.o.', '€', '5', '1630825574438146048', 0, '/1630784869674127360/1630824894071705600/1630825087282319360/1630825206216003584/1630825574438146048/1630825857343950848', '/财务-资产负责类/资产/流动资产/应收关联公司贷款/应收附属公司间贷款/应收萨固密斯洛伐克公司贷款', '/BS/A1000/A1200/A1227/122300/122309', NULL, 4, '0', '1', '1', '2023-03-01 15:02:38', '1', '2023-03-01 15:02:38');
INSERT INTO `qf_subject_international_info` VALUES ('1630825857926959104', 'BS1', '122311', '应收萨固密捷克公司贷款', 'Loan receivables Saar Gummi Czech s.r.o.', '€', '5', '1630825574438146048', 0, '/1630784869674127360/1630824894071705600/1630825087282319360/1630825206216003584/1630825574438146048/1630825857926959104', '/财务-资产负责类/资产/流动资产/应收关联公司贷款/应收附属公司间贷款/应收萨固密捷克公司贷款', '/BS/A1000/A1200/A1227/122300/122311', NULL, 5, '0', '1', '1', '2023-03-01 15:02:39', '1', '2023-03-01 15:02:39');
INSERT INTO `qf_subject_international_info` VALUES ('1630825858509967360', 'BS1', '122312', '应收CQLT萨固密技术公司贷款', 'Loan receivables CQLT SaarGummi Technologies S.a r.l. Luxembourg', '€', '5', '1630825574438146048', 0, '/1630784869674127360/1630824894071705600/1630825087282319360/1630825206216003584/1630825574438146048/1630825858509967360', '/财务-资产负责类/资产/流动资产/应收关联公司贷款/应收附属公司间贷款/应收CQLT萨固密技术公司贷款', '/BS/A1000/A1200/A1227/122300/122312', NULL, 6, '0', '1', '1', '2023-03-01 15:02:39', '1', '2023-03-01 15:02:39');
INSERT INTO `qf_subject_international_info` VALUES ('1630825859113947136', 'BS1', '122313', '应收萨固密巴西公司贷款', 'Loan receivables SaarGummi do Brasil Ltda.', '€', '5', '1630825574438146048', 0, '/1630784869674127360/1630824894071705600/1630825087282319360/1630825206216003584/1630825574438146048/1630825859113947136', '/财务-资产负责类/资产/流动资产/应收关联公司贷款/应收附属公司间贷款/应收萨固密巴西公司贷款', '/BS/A1000/A1200/A1227/122300/122313', NULL, 7, '0', '1', '1', '2023-03-01 15:02:39', '1', '2023-03-01 15:02:39');
INSERT INTO `qf_subject_international_info` VALUES ('1630825859705344000', 'BS1', '122315', '应收萨固密田纳西公司贷款', 'Loan receivables SaarGummi Tennessee Inc.', '€', '5', '1630825574438146048', 0, '/1630784869674127360/1630824894071705600/1630825087282319360/1630825206216003584/1630825574438146048/1630825859705344000', '/财务-资产负责类/资产/流动资产/应收关联公司贷款/应收附属公司间贷款/应收萨固密田纳西公司贷款', '/BS/A1000/A1200/A1227/122300/122315', NULL, 8, '0', '1', '1', '2023-03-01 15:02:39', '1', '2023-03-01 15:02:39');
INSERT INTO `qf_subject_international_info` VALUES ('1630825860305129472', 'BS1', '122319', '应收萨固密印度公司贷款', 'Loan receivables SaarGummi Russland Ltd.', '€', '5', '1630825574438146048', 0, '/1630784869674127360/1630824894071705600/1630825087282319360/1630825206216003584/1630825574438146048/1630825860305129472', '/财务-资产负责类/资产/流动资产/应收关联公司贷款/应收附属公司间贷款/应收萨固密印度公司贷款', '/BS/A1000/A1200/A1227/122300/122319', NULL, 9, '0', '1', '1', '2023-03-01 15:02:39', '1', '2023-03-01 15:02:39');
INSERT INTO `qf_subject_international_info` VALUES ('1630825860904914944', 'BS1', '122320', '应收萨固密俄罗斯公司贷款', 'Loan receivables SaarGummi Deutschland Holding GmbH', '€', '5', '1630825574438146048', 0, '/1630784869674127360/1630824894071705600/1630825087282319360/1630825206216003584/1630825574438146048/1630825860904914944', '/财务-资产负责类/资产/流动资产/应收关联公司贷款/应收附属公司间贷款/应收萨固密俄罗斯公司贷款', '/BS/A1000/A1200/A1227/122300/122320', NULL, 10, '0', '1', '1', '2023-03-01 15:02:39', '1', '2023-03-01 15:02:39');
INSERT INTO `qf_subject_international_info` VALUES ('1630825861479534592', 'BS1', '122321', '应收萨固密德国控股公司贷款', 'Loan receivables CQLT SaarGummi Deutschland GmbH', '€', '5', '1630825574438146048', 0, '/1630784869674127360/1630824894071705600/1630825087282319360/1630825206216003584/1630825574438146048/1630825861479534592', '/财务-资产负责类/资产/流动资产/应收关联公司贷款/应收附属公司间贷款/应收萨固密德国控股公司贷款', '/BS/A1000/A1200/A1227/122300/122321', NULL, 11, '0', '1', '1', '2023-03-01 15:02:39', '1', '2023-03-01 15:02:39');
INSERT INTO `qf_subject_international_info` VALUES ('1630825862062542848', 'BS1', '122326', '应收CQLT萨固密德国公司贷款', 'Loan receivables SaarGummi Beteiligungs GmbH', '€', '5', '1630825574438146048', 0, '/1630784869674127360/1630824894071705600/1630825087282319360/1630825206216003584/1630825574438146048/1630825862062542848', '/财务-资产负责类/资产/流动资产/应收关联公司贷款/应收附属公司间贷款/应收CQLT萨固密德国公司贷款', '/BS/A1000/A1200/A1227/122300/122326', NULL, 12, '0', '1', '1', '2023-03-01 15:02:39', '1', '2023-03-01 15:02:40');
INSERT INTO `qf_subject_international_info` VALUES ('1630825862666522624', 'BS1', '122332', '应收萨固密贝特林根公司贷款', 'Loan receivablesCQLT International Investment Company Ltd, China', '€', '5', '1630825574438146048', 0, '/1630784869674127360/1630824894071705600/1630825087282319360/1630825206216003584/1630825574438146048/1630825862666522624', '/财务-资产负责类/资产/流动资产/应收关联公司贷款/应收附属公司间贷款/应收萨固密贝特林根公司贷款', '/BS/A1000/A1200/A1227/122300/122332', NULL, 13, '0', '1', '1', '2023-03-01 15:02:40', '1', '2023-03-01 15:02:40');
INSERT INTO `qf_subject_international_info` VALUES ('1630825864394575872', 'BS1', '122333', '应收兴渝国际控股（香港）有限公司贷款', 'Loan receivablesCQLT International Investment Holding Ltd, HK', '€', '5', '1630825574438146048', 0, '/1630784869674127360/1630824894071705600/1630825087282319360/1630825206216003584/1630825574438146048/1630825864394575872', '/财务-资产负责类/资产/流动资产/应收关联公司贷款/应收附属公司间贷款/应收兴渝国际控股（香港）有限公司贷款', '/BS/A1000/A1200/A1227/122300/122333', NULL, 14, '0', '1', '1', '2023-03-01 15:02:40', '1', '2023-03-01 15:02:40');
INSERT INTO `qf_subject_international_info` VALUES ('1630825865027915776', 'BS1', '122339', '应收萨固密（中国）投资有限公司贷款', 'Loan receivables SaarGummi China Investement Co. Ltd.', '€', '5', '1630825574438146048', 0, '/1630784869674127360/1630824894071705600/1630825087282319360/1630825206216003584/1630825574438146048/1630825865027915776', '/财务-资产负责类/资产/流动资产/应收关联公司贷款/应收附属公司间贷款/应收萨固密（中国）投资有限公司贷款', '/BS/A1000/A1200/A1227/122300/122339', NULL, 15, '0', '1', '1', '2023-03-01 15:02:40', '1', '2023-03-01 15:02:40');
INSERT INTO `qf_subject_international_info` VALUES ('1630825865615118336', 'BS1', '122341', '应收萨固密渝锦（重庆）橡塑制品有限公司贷款', 'Loan receivables SG Yujin  Rubber & Plastic Products Co. Ltd', '€', '5', '1630825574438146048', 0, '/1630784869674127360/1630824894071705600/1630825087282319360/1630825206216003584/1630825574438146048/1630825865615118336', '/财务-资产负责类/资产/流动资产/应收关联公司贷款/应收附属公司间贷款/应收萨固密渝锦（重庆）橡塑制品有限公司贷款', '/BS/A1000/A1200/A1227/122300/122341', NULL, 16, '0', '1', '1', '2023-03-01 15:02:40', '1', '2023-03-01 15:02:40');
INSERT INTO `qf_subject_international_info` VALUES ('1630825866185543680', 'BS1', '122342', '应收萨固密（重庆）密封系统有限公司贷款', 'loan receivables SaarGummi( Chongqing) Sealing System Co.,ltd', '€', '5', '1630825574438146048', 0, '/1630784869674127360/1630824894071705600/1630825087282319360/1630825206216003584/1630825574438146048/1630825866185543680', '/财务-资产负责类/资产/流动资产/应收关联公司贷款/应收附属公司间贷款/应收萨固密（重庆）密封系统有限公司贷款', '/BS/A1000/A1200/A1227/122300/122342', NULL, 17, '0', '1', '1', '2023-03-01 15:02:40', '1', '2023-03-01 15:02:41');
INSERT INTO `qf_subject_international_info` VALUES ('1630825866751774720', 'BS1', '122344', '应收萨固密（营口）密封系统有限公司贷款', 'loan receivables SaarGummi Yingkou', '€', '5', '1630825574438146048', 0, '/1630784869674127360/1630824894071705600/1630825087282319360/1630825206216003584/1630825574438146048/1630825866751774720', '/财务-资产负责类/资产/流动资产/应收关联公司贷款/应收附属公司间贷款/应收萨固密（营口）密封系统有限公司贷款', '/BS/A1000/A1200/A1227/122300/122344', NULL, 18, '0', '1', '1', '2023-03-01 15:02:41', '1', '2023-03-01 15:02:41');
INSERT INTO `qf_subject_international_info` VALUES ('1630825867385114624', 'BS1', '122345', '应收萨固密国际系统有限公司贷款', 'loan receivables  SaarGummi International Systems GmbH', '€', '5', '1630825574438146048', 0, '/1630784869674127360/1630824894071705600/1630825087282319360/1630825206216003584/1630825574438146048/1630825867385114624', '/财务-资产负责类/资产/流动资产/应收关联公司贷款/应收附属公司间贷款/应收萨固密国际系统有限公司贷款', '/BS/A1000/A1200/A1227/122300/122345', NULL, 19, '0', '1', '1', '2023-03-01 15:02:41', '1', '2023-03-01 15:02:41');
INSERT INTO `qf_subject_international_info` VALUES ('1630825868148477952', 'BS1', '122346', '应收萨固密（上海）橡塑技术有限公司贷款', 'loan receivables SaarGummi (Shanghai) Rubber Technologies Co. Ltd.', '€', '5', '1630825574438146048', 0, '/1630784869674127360/1630824894071705600/1630825087282319360/1630825206216003584/1630825574438146048/1630825868148477952', '/财务-资产负责类/资产/流动资产/应收关联公司贷款/应收附属公司间贷款/应收萨固密（上海）橡塑技术有限公司贷款', '/BS/A1000/A1200/A1227/122300/122346', NULL, 20, '0', '1', '1', '2023-03-01 15:02:41', '1', '2023-03-01 15:02:41');
INSERT INTO `qf_subject_international_info` VALUES ('1630825868802789376', 'BS1', '122347', '应收萨固密墨西哥公司贷款', 'loan receivables SaarGummi Mexico LLd.', '€', '5', '1630825574438146048', 0, '/1630784869674127360/1630824894071705600/1630825087282319360/1630825206216003584/1630825574438146048/1630825868802789376', '/财务-资产负责类/资产/流动资产/应收关联公司贷款/应收附属公司间贷款/应收萨固密墨西哥公司贷款', '/BS/A1000/A1200/A1227/122300/122347', NULL, 21, '0', '1', '1', '2023-03-01 15:02:41', '1', '2023-03-01 15:02:41');
INSERT INTO `qf_subject_international_info` VALUES ('1630825869511626752', 'BS1', '122348', '应收萨固密NEO公司贷款', 'loan receivables SaarGummi Neo GmbH', '€', '5', '1630825574438146048', 0, '/1630784869674127360/1630824894071705600/1630825087282319360/1630825206216003584/1630825574438146048/1630825869511626752', '/财务-资产负责类/资产/流动资产/应收关联公司贷款/应收附属公司间贷款/应收萨固密NEO公司贷款', '/BS/A1000/A1200/A1227/122300/122348', NULL, 22, '0', '1', '1', '2023-03-01 15:02:41', '1', '2023-03-01 15:02:41');
INSERT INTO `qf_subject_international_info` VALUES ('1630825870191104000', 'BS1', '122351', '应收萨固密土耳其公司贷款', 'loan receivables SAARGUMMİ TURKEY KAUÇUK VE PLASTİK LİMİTED ŞİRKETİ', '€', '5', '1630825574438146048', 0, '/1630784869674127360/1630824894071705600/1630825087282319360/1630825206216003584/1630825574438146048/1630825870191104000', '/财务-资产负责类/资产/流动资产/应收关联公司贷款/应收附属公司间贷款/应收萨固密土耳其公司贷款', '/BS/A1000/A1200/A1227/122300/122351', NULL, 23, '0', '1', '1', '2023-03-01 15:02:41', '1', '2023-03-01 15:02:41');
INSERT INTO `qf_subject_international_info` VALUES ('1630825870786695168', 'BS1', '122399', '资金池公司间应收款', 'Receivables cash pooling', '€', '5', '1630825574438146048', 0, '/1630784869674127360/1630824894071705600/1630825087282319360/1630825206216003584/1630825574438146048/1630825870786695168', '/财务-资产负责类/资产/流动资产/应收关联公司贷款/应收附属公司间贷款/资金池公司间应收款', '/BS/A1000/A1200/A1227/122300/122399', NULL, 24, '0', '1', '1', '2023-03-01 15:02:42', '1', '2023-03-01 15:02:42');
INSERT INTO `qf_subject_international_info` VALUES ('1630825871357120512', 'BS1', '122402', '利润池公司间应收款', 'receivables from profit pooling', '€', '5', '1630825574438146048', 0, '/1630784869674127360/1630824894071705600/1630825087282319360/1630825206216003584/1630825574438146048/1630825871357120512', '/财务-资产负责类/资产/流动资产/应收关联公司贷款/应收附属公司间贷款/利润池公司间应收款', '/BS/A1000/A1200/A1227/122300/122402', NULL, 25, '0', '1', '1', '2023-03-01 15:02:42', '1', '2023-03-01 15:02:42');
INSERT INTO `qf_subject_international_info` VALUES ('1630825871961100288', 'BS1', '122501', '所得税退税应收款', 'Receivables for income tax refunds', '€', '5', '1630825576208142336', 0, '/1630784869674127360/1630824894071705600/1630825087282319360/1630825207423963136/1630825576208142336/1630825871961100288', '/财务-资产负责类/资产/流动资产/流动所得税资产/流动所得税资产/所得税退税应收款', '/BS/A1000/A1200/A1232/A1233/122501', NULL, 1, '0', '1', '1', '2023-03-01 15:02:42', '1', '2023-03-01 15:02:42');
INSERT INTO `qf_subject_international_info` VALUES ('1630825872644771840', 'BS1', '122502', '当地交易税退税应收款', 'Receivables for local trade tax refunds', '€', '5', '1630825576208142336', 0, '/1630784869674127360/1630824894071705600/1630825087282319360/1630825207423963136/1630825576208142336/1630825872644771840', '/财务-资产负责类/资产/流动资产/流动所得税资产/流动所得税资产/当地交易税退税应收款', '/BS/A1000/A1200/A1232/A1233/122502', NULL, 2, '0', '1', '1', '2023-03-01 15:02:42', '1', '2023-03-01 15:02:42');
INSERT INTO `qf_subject_international_info` VALUES ('1630825873269723136', 'BS1', '122518', '衍生货币合约', 'derivative currency contract', '€', '5', '1630825576820510720', 0, '/1630784869674127360/1630824894071705600/1630825087282319360/1630825208011165696/1630825576820510720/1630825873269723136', '/财务-资产负责类/资产/流动资产/以公允价值计量的金融工具/以公允价值计量的金融工具/衍生货币合约', '/BS/A1000/A1200/A1235/A1236/122518', NULL, 1, '0', '1', '1', '2023-03-01 15:02:42', '1', '2023-03-01 15:02:42');
INSERT INTO `qf_subject_international_info` VALUES ('1630825873802399744', 'BS1', '122519', '利率衍生工具', 'interest rate derivatives', '€', '5', '1630825576820510720', 0, '/1630784869674127360/1630824894071705600/1630825087282319360/1630825208011165696/1630825576820510720/1630825873802399744', '/财务-资产负责类/资产/流动资产/以公允价值计量的金融工具/以公允价值计量的金融工具/利率衍生工具', '/BS/A1000/A1200/A1235/A1236/122519', NULL, 2, '0', '1', '1', '2023-03-01 15:02:42', '1', '2023-03-01 15:02:42');
INSERT INTO `qf_subject_international_info` VALUES ('1630825874351853568', 'BS1', '122525', '公司间货币衍生工具', 'IC currency derivatives', '€', '5', '1630825576820510720', 0, '/1630784869674127360/1630824894071705600/1630825087282319360/1630825208011165696/1630825576820510720/1630825874351853568', '/财务-资产负责类/资产/流动资产/以公允价值计量的金融工具/以公允价值计量的金融工具/公司间货币衍生工具', '/BS/A1000/A1200/A1235/A1236/122525', NULL, 3, '0', '1', '1', '2023-03-01 15:02:42', '1', '2023-03-01 15:02:42');
INSERT INTO `qf_subject_international_info` VALUES ('1630825874909696000', 'BS1', '122526', '公司间货币衍生工具套期会计', 'IC currency derivatives Hedge Accounting', '€', '5', '1630825576820510720', 0, '/1630784869674127360/1630824894071705600/1630825087282319360/1630825208011165696/1630825576820510720/1630825874909696000', '/财务-资产负责类/资产/流动资产/以公允价值计量的金融工具/以公允价值计量的金融工具/公司间货币衍生工具套期会计', '/BS/A1000/A1200/A1235/A1236/122526', NULL, 4, '0', '1', '1', '2023-03-01 15:02:43', '1', '2023-03-01 15:02:43');
INSERT INTO `qf_subject_international_info` VALUES ('1630825875480121344', 'BS1', '122527', '衍生货币合约套期会计', 'derivative currency contract hedge accounting', '€', '5', '1630825576820510720', 0, '/1630784869674127360/1630824894071705600/1630825087282319360/1630825208011165696/1630825576820510720/1630825875480121344', '/财务-资产负责类/资产/流动资产/以公允价值计量的金融工具/以公允价值计量的金融工具/衍生货币合约套期会计', '/BS/A1000/A1200/A1235/A1236/122527', NULL, 5, '0', '1', '1', '2023-03-01 15:02:43', '1', '2023-03-01 15:02:43');
INSERT INTO `qf_subject_international_info` VALUES ('1630825876063129600', 'BS1', '123102', '库存现金', 'Cash on hand', '€', '5', '1630825577399324672', 0, '/1630784869674127360/1630824894071705600/1630825087282319360/1630825208610951168/1630825577399324672/1630825876063129600', '/财务-资产负责类/资产/流动资产/现金和现金等价物/支票、现金、银行存款/库存现金', '/BS/A1000/A1200/A1240/123100/123102', NULL, 1, '0', '1', '1', '2023-03-01 15:02:43', '1', '2023-03-01 15:02:43');
INSERT INTO `qf_subject_international_info` VALUES ('1630825876641943552', 'BS1', '123103', '银行存款', 'Cash on current bank accounts', '€', '5', '1630825577399324672', 0, '/1630784869674127360/1630824894071705600/1630825087282319360/1630825208610951168/1630825577399324672/1630825876641943552', '/财务-资产负责类/资产/流动资产/现金和现金等价物/支票、现金、银行存款/银行存款', '/BS/A1000/A1200/A1240/123100/123103', NULL, 2, '0', '1', '1', '2023-03-01 15:02:43', '1', '2023-03-01 15:02:43');
INSERT INTO `qf_subject_international_info` VALUES ('1630825877266894848', 'BS1', '123104', '保理账户在途资金', 'Factoring Account Cash in transit', '€', '5', '1630825577399324672', 0, '/1630784869674127360/1630824894071705600/1630825087282319360/1630825208610951168/1630825577399324672/1630825877266894848', '/财务-资产负责类/资产/流动资产/现金和现金等价物/支票、现金、银行存款/保理账户在途资金', '/BS/A1000/A1200/A1240/123100/123104', NULL, 3, '0', '1', '1', '2023-03-01 15:02:43', '1', '2023-03-01 15:02:43');
INSERT INTO `qf_subject_international_info` VALUES ('1630825877887651840', 'BS1', '123105', '短期保证金', 'Short term deposits at banks', '€', '5', '1630825577399324672', 0, '/1630784869674127360/1630824894071705600/1630825087282319360/1630825208610951168/1630825577399324672/1630825877887651840', '/财务-资产负责类/资产/流动资产/现金和现金等价物/支票、现金、银行存款/短期保证金', '/BS/A1000/A1200/A1240/123100/123105', NULL, 4, '0', '1', '1', '2023-03-01 15:02:43', '1', '2023-03-01 15:02:43');
INSERT INTO `qf_subject_international_info` VALUES ('1630825878466465792', 'BS2', '211101', '股本', 'capital stock', '€', '5', '1630825578015887360', 0, '/1630784869674127360/1630824894692462592/1630825087873716224/1630825209185570816/1630825578015887360/1630825878466465792', '/财务-资产负责类/所有者权益和负债/所有者权益和负债/实收资本/实收资本/股本', '/BS/P2000/P2100/P2110/211100/211101', NULL, 1, '0', '1', '1', '2023-03-01 15:02:43', '1', '2023-03-01 15:02:43');
INSERT INTO `qf_subject_international_info` VALUES ('1630825879015919616', 'BS2', '211102', '实收资本', 'Subscribed capital', '€', '5', '1630825578015887360', 0, '/1630784869674127360/1630824894692462592/1630825087873716224/1630825209185570816/1630825578015887360/1630825879015919616', '/财务-资产负责类/所有者权益和负债/所有者权益和负债/实收资本/实收资本/实收资本', '/BS/P2000/P2100/P2110/211100/211102', NULL, 2, '0', '1', '1', '2023-03-01 15:02:44', '1', '2023-03-01 15:02:44');
INSERT INTO `qf_subject_international_info` VALUES ('1630825879586344960', 'BS2', '212101', '资本公积', 'Capital Reserves', '€', '5', '1630825578603089920', 0, '/1630784869674127360/1630824894692462592/1630825087873716224/1630825209789550592/1630825578603089920/1630825879586344960', '/财务-资产负责类/所有者权益和负债/所有者权益和负债/资本公积/资本公积/资本公积', '/BS/P2000/P2100/P2120/P2121/212101', NULL, 1, '0', '1', '1', '2023-03-01 15:02:44', '1', '2023-03-01 15:02:44');
INSERT INTO `qf_subject_international_info` VALUES ('1630825880152576000', 'BS2', '212102', '重估盈余', 'Revaluation surplus', '€', '5', '1630825578603089920', 0, '/1630784869674127360/1630824894692462592/1630825087873716224/1630825209789550592/1630825578603089920/1630825880152576000', '/财务-资产负责类/所有者权益和负债/所有者权益和负债/资本公积/资本公积/重估盈余', '/BS/P2000/P2100/P2120/P2121/212102', NULL, 2, '0', '1', '1', '2023-03-01 15:02:44', '1', '2023-03-01 15:02:44');
INSERT INTO `qf_subject_international_info` VALUES ('1630825880739778560', 'BS2', '213101', '首次合并前损益（07.06.2011）', 'Profit/Loss before first consolidation (07.06.2011)', '€', '5', '1630825579202875392', 0, '/1630784869674127360/1630824894692462592/1630825087873716224/1630825210569691136/1630825579202875392/1630825880739778560', '/财务-资产负责类/所有者权益和负债/所有者权益和负债/未分配利润/利润/亏损的结转-留存收益部分/首次合并前损益（07.06.2011）', '/BS/P2000/P2100/P2130/213100/213101', NULL, 1, '0', '1', '1', '2023-03-01 15:02:44', '1', '2023-03-01 15:02:44');
INSERT INTO `qf_subject_international_info` VALUES ('1630825881339564032', 'BS2', '213102', '以前年度留存收益', 'Retained earnings previous years', '€', '5', '1630825579202875392', 0, '/1630784869674127360/1630824894692462592/1630825087873716224/1630825210569691136/1630825579202875392/1630825881339564032', '/财务-资产负责类/所有者权益和负债/所有者权益和负债/未分配利润/利润/亏损的结转-留存收益部分/以前年度留存收益', '/BS/P2000/P2100/P2130/213100/213102', NULL, 2, '0', '1', '1', '2023-03-01 15:02:44', '1', '2023-03-01 15:02:44');
INSERT INTO `qf_subject_international_info` VALUES ('1630825881947738112', 'BS2', 'K3300', '合并抵消调整', 'KTOSGKTP K3300', '€', '5', '1630825579202875392', 0, '/1630784869674127360/1630824894692462592/1630825087873716224/1630825210569691136/1630825579202875392/1630825881947738112', '/财务-资产负责类/所有者权益和负债/所有者权益和负债/未分配利润/利润/亏损的结转-留存收益部分/合并抵消调整', '/BS/P2000/P2100/P2130/213100/K3300', NULL, 3, '0', '1', '1', '2023-03-01 15:02:44', '1', '2023-03-01 15:02:44');
INSERT INTO `qf_subject_international_info` VALUES ('1630825882543329280', 'BS2', 'K3310', '留存收益债务合并', 'Retained earnings debt consolidation', '€', '5', '1630825579202875392', 0, '/1630784869674127360/1630824894692462592/1630825087873716224/1630825210569691136/1630825579202875392/1630825882543329280', '/财务-资产负责类/所有者权益和负债/所有者权益和负债/未分配利润/利润/亏损的结转-留存收益部分/留存收益债务合并', '/BS/P2000/P2100/P2130/213100/K3310', NULL, 4, '0', '1', '1', '2023-03-01 15:02:44', '1', '2023-03-01 15:02:44');
INSERT INTO `qf_subject_international_info` VALUES ('1630825883126337536', 'BS2', 'K3330', '手工合并分录结转利润', 'Profit brought forward from manual consolidation entries', '€', '5', '1630825579202875392', 0, '/1630784869674127360/1630824894692462592/1630825087873716224/1630825210569691136/1630825579202875392/1630825883126337536', '/财务-资产负责类/所有者权益和负债/所有者权益和负债/未分配利润/利润/亏损的结转-留存收益部分/手工合并分录结转利润', '/BS/P2000/P2100/P2130/213100/K3330', NULL, 5, '0', '1', '1', '2023-03-01 15:02:45', '1', '2023-03-01 15:02:45');
INSERT INTO `qf_subject_international_info` VALUES ('1630825883700957184', 'BS2', 'K3340', '合并抵消调整', 'KTOSGKTP K3340', '€', '5', '1630825579202875392', 0, '/1630784869674127360/1630824894692462592/1630825087873716224/1630825210569691136/1630825579202875392/1630825883700957184', '/财务-资产负责类/所有者权益和负债/所有者权益和负债/未分配利润/利润/亏损的结转-留存收益部分/合并抵消调整', '/BS/P2000/P2100/P2130/213100/K3340', NULL, 6, '0', '1', '1', '2023-03-01 15:02:45', '1', '2023-03-01 15:02:45');
INSERT INTO `qf_subject_international_info` VALUES ('1630825884296548352', 'BS2', 'K3350', '合并抵消调整', 'KTOSGKTP K3350', '€', '5', '1630825579202875392', 0, '/1630784869674127360/1630824894692462592/1630825087873716224/1630825210569691136/1630825579202875392/1630825884296548352', '/财务-资产负责类/所有者权益和负债/所有者权益和负债/未分配利润/利润/亏损的结转-留存收益部分/合并抵消调整', '/BS/P2000/P2100/P2130/213100/K3350', NULL, 7, '0', '1', '1', '2023-03-01 15:02:45', '1', '2023-03-01 15:02:45');
INSERT INTO `qf_subject_international_info` VALUES ('1630825884883750912', 'BS2', 'K3500', '合并抵消调整', 'KTOSGKTP K3500', '€', '5', '1630825579202875392', 0, '/1630784869674127360/1630824894692462592/1630825087873716224/1630825210569691136/1630825579202875392/1630825884883750912', '/财务-资产负责类/所有者权益和负债/所有者权益和负债/未分配利润/利润/亏损的结转-留存收益部分/合并抵消调整', '/BS/P2000/P2100/P2130/213100/K3500', NULL, 8, '0', '1', '1', '2023-03-01 15:02:45', '1', '2023-03-01 15:02:45');
INSERT INTO `qf_subject_international_info` VALUES ('1630825885458370560', 'BS2', '213104', '股利', 'Dividends', '€', '5', '1630825579848798208', 0, '/1630784869674127360/1630824894692462592/1630825087873716224/1630825210569691136/1630825579848798208/1630825885458370560', '/财务-资产负责类/所有者权益和负债/所有者权益和负债/未分配利润/利润/亏损的结转-股利部分/股利', '/BS/P2000/P2100/P2130/213110/213104', NULL, 1, '0', '1', '1', '2023-03-01 15:02:45', '1', '2023-03-01 15:02:45');
INSERT INTO `qf_subject_international_info` VALUES ('1630825886066544640', 'BS2', 'K3431', '当年净利润/净损失-少数股东', 'KTOSGKTP K3430', '€', '5', '1630825580431806464', 0, '/1630784869674127360/1630824894692462592/1630825087873716224/1630825210569691136/1630825580431806464/1630825886066544640', '/财务-资产负责类/所有者权益和负债/所有者权益和负债/未分配利润/少数股东损益/当年净利润/净损失-少数股东', '/BS/P2000/P2100/P2130/219300/K3431', NULL, 1, '0', '1', '1', '2023-03-01 15:02:45', '1', '2023-03-01 15:02:45');
INSERT INTO `qf_subject_international_info` VALUES ('1630825886683107328', 'BS2', '213103', '每年净损失/净利润', 'Net Income/net loss for the year', '€', '5', '1630825581031591936', 0, '/1630784869674127360/1630824894692462592/1630825087873716224/1630825210569691136/1630825581031591936/1630825886683107328', '/财务-资产负责类/所有者权益和负债/所有者权益和负债/未分配利润/当期净利润/每年净损失/净利润', '/BS/P2000/P2100/P2130/219200/213103', NULL, 1, '0', '1', '1', '2023-03-01 15:02:45', '1', '2023-03-01 15:02:45');
INSERT INTO `qf_subject_international_info` VALUES ('1630825887240949760', 'BS2', 'K3520', '货币折算调整项目', 'Adjustment item for currency conversion', '€', '5', '1630825581635571712', 0, '/1630784869674127360/1630824894692462592/1630825087873716224/1630825211165282304/1630825581635571712/1630825887240949760', '/财务-资产负责类/所有者权益和负债/所有者权益和负债/其他权益组成部分/货币折算差额/货币折算调整项目', '/BS/P2000/P2100/P2140/219100/K3520', NULL, 1, '0', '1', '1', '2023-03-01 15:02:46', '1', '2023-03-01 15:02:46');
INSERT INTO `qf_subject_international_info` VALUES ('1630825887823958016', 'BS2', '212111', '对冲会计递延所得税', 'deferred tax on hedge accounting', '€', '5', '1630825582222774272', 0, '/1630784869674127360/1630824894692462592/1630825087873716224/1630825211165282304/1630825582222774272/1630825887823958016', '/财务-资产负责类/所有者权益和负债/所有者权益和负债/其他权益组成部分/其他综合收益/对冲会计递延所得税', '/BS/P2000/P2100/P2140/P2142/212111', NULL, 1, '0', '1', '1', '2023-03-01 15:02:46', '1', '2023-03-01 15:02:46');
INSERT INTO `qf_subject_international_info` VALUES ('1630825888369217536', 'BS2', '212112', '对冲会计的净投资/净损益', 'net gains/ losses on hedge accounting net investment', '€', '5', '1630825582222774272', 0, '/1630784869674127360/1630824894692462592/1630825087873716224/1630825211165282304/1630825582222774272/1630825888369217536', '/财务-资产负责类/所有者权益和负债/所有者权益和负债/其他权益组成部分/其他综合收益/对冲会计的净投资/净损益', '/BS/P2000/P2100/P2140/P2142/212112', NULL, 2, '0', '1', '1', '2023-03-01 15:02:46', '1', '2023-03-01 15:02:46');
INSERT INTO `qf_subject_international_info` VALUES ('1630825888910282752', 'BS2', '212106', '设定受益计划精算损益', 'defined benefit plan actuarial gains/ losses', '€', '5', '1630825582822559744', 0, '/1630784869674127360/1630824894692462592/1630825087873716224/1630825211165282304/1630825582822559744/1630825888910282752', '/财务-资产负责类/所有者权益和负债/所有者权益和负债/其他权益组成部分/重新测量/设定受益计划精算损益', '/BS/P2000/P2100/P2140/P2143/212106', NULL, 1, '0', '1', '1', '2023-03-01 15:02:46', '1', '2023-03-01 15:02:46');
INSERT INTO `qf_subject_international_info` VALUES ('1630825889568788480', 'BS2', '212107', '精算收益/损失的递延税', 'deferred tax of actuarial gains/ losses', '€', '5', '1630825582822559744', 0, '/1630784869674127360/1630824894692462592/1630825087873716224/1630825211165282304/1630825582822559744/1630825889568788480', '/财务-资产负责类/所有者权益和负债/所有者权益和负债/其他权益组成部分/重新测量/精算收益/损失的递延税', '/BS/P2000/P2100/P2140/P2143/212107', NULL, 2, '0', '1', '1', '2023-03-01 15:02:46', '1', '2023-03-01 15:02:46');
INSERT INTO `qf_subject_international_info` VALUES ('1630825890277625856', 'BS2', '212105', '法定储备', 'statutory reserves', '€', '5', '1630825583409762304', 0, '/1630784869674127360/1630824894692462592/1630825087873716224/1630825211165282304/1630825583409762304/1630825890277625856', '/财务-资产负责类/所有者权益和负债/所有者权益和负债/其他权益组成部分/法定储备/法定储备', '/BS/P2000/P2100/P2140/P2141/212105', NULL, 1, '0', '1', '1', '2023-03-01 15:02:46', '1', '2023-03-01 15:02:46');
INSERT INTO `qf_subject_international_info` VALUES ('1630825890831273984', 'BS2', '211103', '少数股东权益', 'Minority capital', '€', '5', '1630825584089239552', 0, '/1630784869674127360/1630824894692462592/1630825087873716224/1630825211731513344/1630825584089239552/1630825890831273984', '/财务-资产负责类/所有者权益和负债/所有者权益和负债/非控制性权益/非控制性权益/少数股东权益', '/BS/P2000/P2100/P2150/214100/211103', NULL, 1, '0', '1', '1', '2023-03-01 15:02:46', '1', '2023-03-01 15:02:46');
INSERT INTO `qf_subject_international_info` VALUES ('1630825891380727808', 'BS3', '231201', '长期银行贷款（> 1年）', 'bank loan long term (> 1 year)', '€', '5', '1630825584668053504', 0, '/1630784869674127360/1630824894692462592/1630825088481890304/1630825212343881728/1630825584668053504/1630825891380727808', '/财务-资产负责类/所有者权益和负债/非流动负债/非流动带息贷款和借款/长期银行及类似借款/长期银行贷款（> 1年）', '/BS/P2000/P2200/P2210/231200/231201', NULL, 1, '0', '1', '1', '2023-03-01 15:02:46', '1', '2023-03-01 15:02:47');
INSERT INTO `qf_subject_international_info` VALUES ('1630825891955347456', 'BS3', '231206', '租赁公司负债（> 1年）', 'liabilities lease companies (> 1 year)', '€', '5', '1630825584668053504', 0, '/1630784869674127360/1630824894692462592/1630825088481890304/1630825212343881728/1630825584668053504/1630825891955347456', '/财务-资产负责类/所有者权益和负债/非流动负债/非流动带息贷款和借款/长期银行及类似借款/租赁公司负债（> 1年）', '/BS/P2000/P2200/P2210/231200/231206', NULL, 2, '0', '1', '1', '2023-03-01 15:02:47', '1', '2023-03-01 15:02:47');
INSERT INTO `qf_subject_international_info` VALUES ('1630825892508995584', 'BS3', '231210', '租赁负债>1年', 'liabilities right of use > 1 year', '€', '5', '1630825584668053504', 0, '/1630784869674127360/1630824894692462592/1630825088481890304/1630825212343881728/1630825584668053504/1630825892508995584', '/财务-资产负责类/所有者权益和负债/非流动负债/非流动带息贷款和借款/长期银行及类似借款/租赁负债>1年', '/BS/P2000/P2200/P2210/231200/231210', NULL, 3, '0', '1', '1', '2023-03-01 15:02:47', '1', '2023-03-01 15:02:47');
INSERT INTO `qf_subject_international_info` VALUES ('1630825893096198144', 'BS3', '231211', '外币租赁负债>1年期', 'liabilities right of use > 1 year foreign currency', '€', '5', '1630825584668053504', 0, '/1630784869674127360/1630824894692462592/1630825088481890304/1630825212343881728/1630825584668053504/1630825893096198144', '/财务-资产负责类/所有者权益和负债/非流动负债/非流动带息贷款和借款/长期银行及类似借款/外币租赁负债>1年期', '/BS/P2000/P2200/P2210/231200/231211', NULL, 4, '0', '1', '1', '2023-03-01 15:02:47', '1', '2023-03-01 15:02:47');
INSERT INTO `qf_subject_international_info` VALUES ('1630825893679206400', 'BS3', '231209', '其他贷款和借款（> 1 年）', 'other loans and borrowings (> 1 year)', '€', '5', '1630825585347530752', 0, '/1630784869674127360/1630824894692462592/1630825088481890304/1630825212343881728/1630825585347530752/1630825893679206400', '/财务-资产负责类/所有者权益和负债/非流动负债/非流动带息贷款和借款/其他贷款和借款/其他贷款和借款（> 1 年）', '/BS/P2000/P2200/P2210/231050/231209', NULL, 1, '0', '1', '1', '2023-03-01 15:02:47', '1', '2023-03-01 15:02:47');
INSERT INTO `qf_subject_international_info` VALUES ('1630825894283186176', 'BS3', '233308', '长期股东借款(CQLT)', 'Liabilities shareholder (CQLT) long term', '€', '5', '1630825585347530752', 0, '/1630784869674127360/1630824894692462592/1630825088481890304/1630825212343881728/1630825585347530752/1630825894283186176', '/财务-资产负责类/所有者权益和负债/非流动负债/非流动带息贷款和借款/其他贷款和借款/长期股东借款(CQLT)', '/BS/P2000/P2200/P2210/231050/233308', NULL, 2, '0', '1', '1', '2023-03-01 15:02:47', '1', '2023-03-01 15:02:47');
INSERT INTO `qf_subject_international_info` VALUES ('1630825894832640000', 'BS3', '235204', '应付萨固密管理公司的贷款', 'Loan Liabilities SaarGummi Verwaltungs-GmbH', '€', '5', '1630825585922150400', 0, '/1630784869674127360/1630824894692462592/1630825088481890304/1630825212905918464/1630825585922150400/1630825894832640000', '/财务-资产负责类/所有者权益和负债/非流动负债/对关联公司的贷款负债/应付关联公司的贷款/应付萨固密管理公司的贷款', '/BS/P2000/P2200/P2225/235200/235204', NULL, 1, '0', '1', '1', '2023-03-01 15:02:47', '1', '2023-03-01 15:02:47');
INSERT INTO `qf_subject_international_info` VALUES ('1630825895407259648', 'BS3', '235206', '应付萨固密汽车密封件公司的贷款', 'Loan Liabilities SaarGummi Automotive Sealings GmbH', '€', '5', '1630825585922150400', 0, '/1630784869674127360/1630824894692462592/1630825088481890304/1630825212905918464/1630825585922150400/1630825895407259648', '/财务-资产负责类/所有者权益和负债/非流动负债/对关联公司的贷款负债/应付关联公司的贷款/应付萨固密汽车密封件公司的贷款', '/BS/P2000/P2200/P2225/235200/235206', NULL, 2, '0', '1', '1', '2023-03-01 15:02:47', '1', '2023-03-01 15:02:47');
INSERT INTO `qf_subject_international_info` VALUES ('1630825896048988160', 'BS3', '235208', '应付萨固密伊比利亚公司的贷款', 'Loan Liabilities SaarGummi Iberica S.A.', '€', '5', '1630825585922150400', 0, '/1630784869674127360/1630824894692462592/1630825088481890304/1630825212905918464/1630825585922150400/1630825896048988160', '/财务-资产负责类/所有者权益和负债/非流动负债/对关联公司的贷款负债/应付关联公司的贷款/应付萨固密伊比利亚公司的贷款', '/BS/P2000/P2200/P2225/235200/235208', NULL, 3, '0', '1', '1', '2023-03-01 15:02:48', '1', '2023-03-01 15:02:48');
INSERT INTO `qf_subject_international_info` VALUES ('1630825896606830592', 'BS3', '235209', '应付萨固密斯洛伐克公司的贷款', 'Loan Liabilities SaarGummi Slovakia s.r.o.', '€', '5', '1630825585922150400', 0, '/1630784869674127360/1630824894692462592/1630825088481890304/1630825212905918464/1630825585922150400/1630825896606830592', '/财务-资产负责类/所有者权益和负债/非流动负债/对关联公司的贷款负债/应付关联公司的贷款/应付萨固密斯洛伐克公司的贷款', '/BS/P2000/P2200/P2225/235200/235209', NULL, 4, '0', '1', '1', '2023-03-01 15:02:48', '1', '2023-03-01 15:02:48');
INSERT INTO `qf_subject_international_info` VALUES ('1630825897202421760', 'BS3', '235211', '应付萨固密捷克公司的贷款', 'Loan Liabilities Saar Gummi Czech s.r.o.', '€', '5', '1630825585922150400', 0, '/1630784869674127360/1630824894692462592/1630825088481890304/1630825212905918464/1630825585922150400/1630825897202421760', '/财务-资产负责类/所有者权益和负债/非流动负债/对关联公司的贷款负债/应付关联公司的贷款/应付萨固密捷克公司的贷款', '/BS/P2000/P2200/P2225/235200/235211', NULL, 5, '0', '1', '1', '2023-03-01 15:02:48', '1', '2023-03-01 15:02:48');
INSERT INTO `qf_subject_international_info` VALUES ('1630825897852538880', 'BS3', '235212', '应付CQLT萨固密技术公司的贷款', 'Loan Liabilities CQLT SaarGummi technologies S.a r.l. Luxembourg', '€', '5', '1630825585922150400', 0, '/1630784869674127360/1630824894692462592/1630825088481890304/1630825212905918464/1630825585922150400/1630825897852538880', '/财务-资产负责类/所有者权益和负债/非流动负债/对关联公司的贷款负债/应付关联公司的贷款/应付CQLT萨固密技术公司的贷款', '/BS/P2000/P2200/P2225/235200/235212', NULL, 6, '0', '1', '1', '2023-03-01 15:02:48', '1', '2023-03-01 15:02:48');
INSERT INTO `qf_subject_international_info` VALUES ('1630825898456518656', 'BS3', '235213', '应付萨固密巴西公司的贷款', 'Loan Liabilities SaarGummi do Brasil Ltda.', '€', '5', '1630825585922150400', 0, '/1630784869674127360/1630824894692462592/1630825088481890304/1630825212905918464/1630825585922150400/1630825898456518656', '/财务-资产负责类/所有者权益和负债/非流动负债/对关联公司的贷款负债/应付关联公司的贷款/应付萨固密巴西公司的贷款', '/BS/P2000/P2200/P2225/235200/235213', NULL, 7, '0', '1', '1', '2023-03-01 15:02:48', '1', '2023-03-01 15:02:48');
INSERT INTO `qf_subject_international_info` VALUES ('1630825899035332608', 'BS3', '235215', '应付萨固密田纳西公司的贷款', 'Loan Liabilities SaarGummi Tennessee Inc.', '€', '5', '1630825585922150400', 0, '/1630784869674127360/1630824894692462592/1630825088481890304/1630825212905918464/1630825585922150400/1630825899035332608', '/财务-资产负责类/所有者权益和负债/非流动负债/对关联公司的贷款负债/应付关联公司的贷款/应付萨固密田纳西公司的贷款', '/BS/P2000/P2200/P2225/235200/235215', NULL, 8, '0', '1', '1', '2023-03-01 15:02:48', '1', '2023-03-01 15:02:48');
INSERT INTO `qf_subject_international_info` VALUES ('1630825899635118080', 'BS3', '235219', '应付萨固密俄罗斯公司的贷款', 'Loan Liabilities SaarGummi Russland Ltd.', '€', '5', '1630825585922150400', 0, '/1630784869674127360/1630824894692462592/1630825088481890304/1630825212905918464/1630825585922150400/1630825899635118080', '/财务-资产负责类/所有者权益和负债/非流动负债/对关联公司的贷款负债/应付关联公司的贷款/应付萨固密俄罗斯公司的贷款', '/BS/P2000/P2200/P2225/235200/235219', NULL, 9, '0', '1', '1', '2023-03-01 15:02:48', '1', '2023-03-01 15:02:48');
INSERT INTO `qf_subject_international_info` VALUES ('1630825900209737728', 'BS3', '235220', '应付萨固密德国控股公司的贷款', 'Loan Liabilities SaarGummi Deutschland Holding GmbH', '€', '5', '1630825585922150400', 0, '/1630784869674127360/1630824894692462592/1630825088481890304/1630825212905918464/1630825585922150400/1630825900209737728', '/财务-资产负责类/所有者权益和负债/非流动负债/对关联公司的贷款负债/应付关联公司的贷款/应付萨固密德国控股公司的贷款', '/BS/P2000/P2200/P2225/235200/235220', NULL, 10, '0', '1', '1', '2023-03-01 15:02:49', '1', '2023-03-01 15:02:49');
INSERT INTO `qf_subject_international_info` VALUES ('1630825900775968768', 'BS3', '235221', '应付CQLT萨固密德国公司的贷款', 'Loan Liabilities CQLT SaarGummi Deutschland GmbH', '€', '5', '1630825585922150400', 0, '/1630784869674127360/1630824894692462592/1630825088481890304/1630825212905918464/1630825585922150400/1630825900775968768', '/财务-资产负责类/所有者权益和负债/非流动负债/对关联公司的贷款负债/应付关联公司的贷款/应付CQLT萨固密德国公司的贷款', '/BS/P2000/P2200/P2225/235200/235221', NULL, 11, '0', '1', '1', '2023-03-01 15:02:49', '1', '2023-03-01 15:02:49');
INSERT INTO `qf_subject_international_info` VALUES ('1630825901321228288', 'BS3', '235226', '应付萨固密贝特林根公司的贷款', 'Loan Liabilities SaarGummi Beteiligungs GmbH', '€', '5', '1630825585922150400', 0, '/1630784869674127360/1630824894692462592/1630825088481890304/1630825212905918464/1630825585922150400/1630825901321228288', '/财务-资产负责类/所有者权益和负债/非流动负债/对关联公司的贷款负债/应付关联公司的贷款/应付萨固密贝特林根公司的贷款', '/BS/P2000/P2200/P2225/235200/235226', NULL, 12, '0', '1', '1', '2023-03-01 15:02:49', '1', '2023-03-01 15:02:49');
INSERT INTO `qf_subject_international_info` VALUES ('1630825901921013760', 'BS3', '235232', '应付重庆兴渝投资公司的贷款', 'Loan LiabilitiesCQLT International Investment Company Ltd, China', '€', '5', '1630825585922150400', 0, '/1630784869674127360/1630824894692462592/1630825088481890304/1630825212905918464/1630825585922150400/1630825901921013760', '/财务-资产负责类/所有者权益和负债/非流动负债/对关联公司的贷款负债/应付关联公司的贷款/应付重庆兴渝投资公司的贷款', '/BS/P2000/P2200/P2225/235200/235232', NULL, 13, '0', '1', '1', '2023-03-01 15:02:49', '1', '2023-03-01 15:02:49');
INSERT INTO `qf_subject_international_info` VALUES ('1630825902508216320', 'BS3', '235233', '应付兴渝国际控股（香港）有限公司的贷款', 'Loan LiabilitiesCQLT International Investment Holding Ltd, HK', '€', '5', '1630825585922150400', 0, '/1630784869674127360/1630824894692462592/1630825088481890304/1630825212905918464/1630825585922150400/1630825902508216320', '/财务-资产负责类/所有者权益和负债/非流动负债/对关联公司的贷款负债/应付关联公司的贷款/应付兴渝国际控股（香港）有限公司的贷款', '/BS/P2000/P2200/P2225/235200/235233', NULL, 14, '0', '1', '1', '2023-03-01 15:02:49', '1', '2023-03-01 15:02:49');
INSERT INTO `qf_subject_international_info` VALUES ('1630825903179304960', 'BS3', '235239', '应付萨固密（中国）投资有限公司的贷款', 'Loan Liabilities Saargummi China Investment Co. Ltd.', '€', '5', '1630825585922150400', 0, '/1630784869674127360/1630824894692462592/1630825088481890304/1630825212905918464/1630825585922150400/1630825903179304960', '/财务-资产负责类/所有者权益和负债/非流动负债/对关联公司的贷款负债/应付关联公司的贷款/应付萨固密（中国）投资有限公司的贷款', '/BS/P2000/P2200/P2225/235200/235239', NULL, 15, '0', '1', '1', '2023-03-01 15:02:49', '1', '2023-03-01 15:02:49');
INSERT INTO `qf_subject_international_info` VALUES ('1630825903724564480', 'BS3', '235241', '应付萨固密渝锦（重庆）橡塑制品有限公司的贷款', 'Loan Liabilities SG Yujin  Rubber & Plastic Products Co. Ltd', '€', '5', '1630825585922150400', 0, '/1630784869674127360/1630824894692462592/1630825088481890304/1630825212905918464/1630825585922150400/1630825903724564480', '/财务-资产负责类/所有者权益和负债/非流动负债/对关联公司的贷款负债/应付关联公司的贷款/应付萨固密渝锦（重庆）橡塑制品有限公司的贷款', '/BS/P2000/P2200/P2225/235200/235241', NULL, 16, '0', '1', '1', '2023-03-01 15:02:49', '1', '2023-03-01 15:02:49');
INSERT INTO `qf_subject_international_info` VALUES ('1630825904311767040', 'BS3', '235242', '应付萨固密（重庆）密封系统有限公司的贷款', 'Loan Liabilities SaarGummi( Chongqing) Sealing System Co.,ltd', '€', '5', '1630825585922150400', 0, '/1630784869674127360/1630824894692462592/1630825088481890304/1630825212905918464/1630825585922150400/1630825904311767040', '/财务-资产负责类/所有者权益和负债/非流动负债/对关联公司的贷款负债/应付关联公司的贷款/应付萨固密（重庆）密封系统有限公司的贷款', '/BS/P2000/P2200/P2225/235200/235242', NULL, 17, '0', '1', '1', '2023-03-01 15:02:50', '1', '2023-03-01 15:02:50');
INSERT INTO `qf_subject_international_info` VALUES ('1630825904877998080', 'BS3', '235244', '应付萨固密（营口）密封系统有限公司的贷款', 'loan liabilities SaarGummi (Yingkou) Sealing System Co.Ltd.', '€', '5', '1630825585922150400', 0, '/1630784869674127360/1630824894692462592/1630825088481890304/1630825212905918464/1630825585922150400/1630825904877998080', '/财务-资产负责类/所有者权益和负债/非流动负债/对关联公司的贷款负债/应付关联公司的贷款/应付萨固密（营口）密封系统有限公司的贷款', '/BS/P2000/P2200/P2225/235200/235244', NULL, 18, '0', '1', '1', '2023-03-01 15:02:50', '1', '2023-03-01 15:02:50');
INSERT INTO `qf_subject_international_info` VALUES ('1630825905444229120', 'BS3', '235245', '应付萨固密国际系统有限公司的贷款', 'loan liabilities SaarGummi International Systems GmbH', '€', '5', '1630825585922150400', 0, '/1630784869674127360/1630824894692462592/1630825088481890304/1630825212905918464/1630825585922150400/1630825905444229120', '/财务-资产负责类/所有者权益和负债/非流动负债/对关联公司的贷款负债/应付关联公司的贷款/应付萨固密国际系统有限公司的贷款', '/BS/P2000/P2200/P2225/235200/235245', NULL, 19, '0', '1', '1', '2023-03-01 15:02:50', '1', '2023-03-01 15:02:50');
INSERT INTO `qf_subject_international_info` VALUES ('1630825906018848768', 'BS3', '235246', '应付萨固密（上海）橡塑技术有限公司的贷款', 'loan liabilities SaarGummi (Shanghai) Rubber Technologies Co. Ltd.', '€', '5', '1630825585922150400', 0, '/1630784869674127360/1630824894692462592/1630825088481890304/1630825212905918464/1630825585922150400/1630825906018848768', '/财务-资产负责类/所有者权益和负债/非流动负债/对关联公司的贷款负债/应付关联公司的贷款/应付萨固密（上海）橡塑技术有限公司的贷款', '/BS/P2000/P2200/P2225/235200/235246', NULL, 20, '0', '1', '1', '2023-03-01 15:02:50', '1', '2023-03-01 15:02:50');
INSERT INTO `qf_subject_international_info` VALUES ('1630825906664771584', 'BS3', '235247', '应付萨固密墨西哥公司的贷款', 'loan liabilities SaarGummi Mexico', '€', '5', '1630825585922150400', 0, '/1630784869674127360/1630824894692462592/1630825088481890304/1630825212905918464/1630825585922150400/1630825906664771584', '/财务-资产负责类/所有者权益和负债/非流动负债/对关联公司的贷款负债/应付关联公司的贷款/应付萨固密墨西哥公司的贷款', '/BS/P2000/P2200/P2225/235200/235247', NULL, 21, '0', '1', '1', '2023-03-01 15:02:50', '1', '2023-03-01 15:02:50');
INSERT INTO `qf_subject_international_info` VALUES ('1630825907272945664', 'BS3', '235248', '应付萨固密NEO公司的贷款', 'loan liabilities SaarGummi Neo GmbH', '€', '5', '1630825585922150400', 0, '/1630784869674127360/1630824894692462592/1630825088481890304/1630825212905918464/1630825585922150400/1630825907272945664', '/财务-资产负责类/所有者权益和负债/非流动负债/对关联公司的贷款负债/应付关联公司的贷款/应付萨固密NEO公司的贷款', '/BS/P2000/P2200/P2225/235200/235248', NULL, 22, '0', '1', '1', '2023-03-01 15:02:50', '1', '2023-03-01 15:02:50');
INSERT INTO `qf_subject_international_info` VALUES ('1630825907843371008', 'BS3', '235251', '应付萨固密土耳其公司的贷款', 'loan liabilities SAARGUMMİ TURKEY KAUÇUK VE PLASTİK LİMİTED ŞİRKETİ', '€', '5', '1630825585922150400', 0, '/1630784869674127360/1630824894692462592/1630825088481890304/1630825212905918464/1630825585922150400/1630825907843371008', '/财务-资产负责类/所有者权益和负债/非流动负债/对关联公司的贷款负债/应付关联公司的贷款/应付萨固密土耳其公司的贷款', '/BS/P2000/P2200/P2225/235200/235251', NULL, 23, '0', '1', '1', '2023-03-01 15:02:50', '1', '2023-03-01 15:02:50');
INSERT INTO `qf_subject_international_info` VALUES ('1630825908397019136', 'BS3', '235299', '资金池公司间应付款', 'liabilities cashpooling', '€', '5', '1630825585922150400', 0, '/1630784869674127360/1630824894692462592/1630825088481890304/1630825212905918464/1630825585922150400/1630825908397019136', '/财务-资产负责类/所有者权益和负债/非流动负债/对关联公司的贷款负债/应付关联公司的贷款/资金池公司间应付款', '/BS/P2000/P2200/P2225/235200/235299', NULL, 24, '0', '1', '1', '2023-03-01 15:02:51', '1', '2023-03-01 15:02:51');
INSERT INTO `qf_subject_international_info` VALUES ('1630825908988416000', 'BS3', '235302', '利润池公司间应付款', 'liabilities from profit pooling', '€', '5', '1630825585922150400', 0, '/1630784869674127360/1630824894692462592/1630825088481890304/1630825212905918464/1630825585922150400/1630825908988416000', '/财务-资产负责类/所有者权益和负债/非流动负债/对关联公司的贷款负债/应付关联公司的贷款/利润池公司间应付款', '/BS/P2000/P2200/P2225/235200/235302', NULL, 25, '0', '1', '1', '2023-03-01 15:02:51', '1', '2023-03-01 15:02:51');
INSERT INTO `qf_subject_international_info` VALUES ('1630825909550452736', 'BS3', '221101', '长期养老金预计负债', 'Provision for pensions long term', '€', '5', '1630825586459021312', 0, '/1630784869674127360/1630824894692462592/1630825088481890304/1630825213480538112/1630825586459021312/1630825909550452736', '/财务-资产负责类/所有者权益和负债/非流动负债/养老金预计负债/养老金预计负债/长期养老金预计负债', '/BS/P2000/P2200/P2240/221100/221101', NULL, 1, '0', '1', '1', '2023-03-01 15:02:51', '1', '2023-03-01 15:02:51');
INSERT INTO `qf_subject_international_info` VALUES ('1630825910104100864', 'BS3', '221102', '长期退休金预计负债', 'Provision for retirement long term', '€', '5', '1630825586459021312', 0, '/1630784869674127360/1630824894692462592/1630825088481890304/1630825213480538112/1630825586459021312/1630825910104100864', '/财务-资产负责类/所有者权益和负债/非流动负债/养老金预计负债/养老金预计负债/长期退休金预计负债', '/BS/P2000/P2200/P2240/221100/221102', NULL, 2, '0', '1', '1', '2023-03-01 15:02:51', '1', '2023-03-01 15:02:51');
INSERT INTO `qf_subject_international_info` VALUES ('1630825910720663552', 'BS3', '223104', '非流动保证预提准备金', 'Warranty provisions non-current', '€', '5', '1630825587046223872', 0, '/1630784869674127360/1630824894692462592/1630825088481890304/1630825214071934976/1630825587046223872/1630825910720663552', '/财务-资产负责类/所有者权益和负债/非流动负债/其他非流动预计负债/其他非流动预计负债/非流动保证预提准备金', '/BS/P2000/P2200/P2230/223100/223104', NULL, 1, '0', '1', '1', '2023-03-01 15:02:51', '1', '2023-03-01 15:02:51');
INSERT INTO `qf_subject_international_info` VALUES ('1630825911370780672', 'BS3', '223106', '建造合同预期损失准备金(PoC/ZPMM) -长期', 'Provision for anticipated losses construc. contr.(PoC/ZPMM) long term', '€', '5', '1630825587046223872', 0, '/1630784869674127360/1630824894692462592/1630825088481890304/1630825214071934976/1630825587046223872/1630825911370780672', '/财务-资产负责类/所有者权益和负债/非流动负债/其他非流动预计负债/其他非流动预计负债/建造合同预期损失准备金(PoC/ZPMM) -长期', '/BS/P2000/P2200/P2230/223100/223106', NULL, 2, '0', '1', '1', '2023-03-01 15:02:51', '1', '2023-03-01 15:02:51');
INSERT INTO `qf_subject_international_info` VALUES ('1630825911966371840', 'BS3', '233301', '长期供应商发票应付款', 'Liabilities for missing supplier invoices long term', '€', '5', '1630825587646009344', 0, '/1630784869674127360/1630824894692462592/1630825088481890304/1630825214650748928/1630825587646009344/1630825911966371840', '/财务-资产负责类/所有者权益和负债/非流动负债/其他非流动负债/长期应付账款/长期供应商发票应付款', '/BS/P2000/P2200/P2250/233300/233301', NULL, 1, '0', '1', '1', '2023-03-01 15:02:51', '1', '2023-03-01 15:02:51');
INSERT INTO `qf_subject_international_info` VALUES ('1630825912524214272', 'BS3', '233302', '长期能源、天然气、水费应付款', 'Liabilities for energy, natural gas, water long term', '€', '5', '1630825587646009344', 0, '/1630784869674127360/1630824894692462592/1630825088481890304/1630825214650748928/1630825587646009344/1630825912524214272', '/财务-资产负责类/所有者权益和负债/非流动负债/其他非流动负债/长期应付账款/长期能源、天然气、水费应付款', '/BS/P2000/P2200/P2250/233300/233302', NULL, 2, '0', '1', '1', '2023-03-01 15:02:52', '1', '2023-03-01 15:02:52');
INSERT INTO `qf_subject_international_info` VALUES ('1630825913186914304', 'BS3', '233303', '其他长期应付款', 'Liabilities other  long term', '€', '5', '1630825587646009344', 0, '/1630784869674127360/1630824894692462592/1630825088481890304/1630825214650748928/1630825587646009344/1630825913186914304', '/财务-资产负责类/所有者权益和负债/非流动负债/其他非流动负债/长期应付账款/其他长期应付款', '/BS/P2000/P2200/P2250/233300/233303', NULL, 3, '0', '1', '1', '2023-03-01 15:02:52', '1', '2023-03-01 15:02:52');
INSERT INTO `qf_subject_international_info` VALUES ('1630825913757339648', 'BS3', '233304', '长期发明者奖金应付款', 'Liabilities for inventor\'s bonus long term', '€', '5', '1630825587646009344', 0, '/1630784869674127360/1630824894692462592/1630825088481890304/1630825214650748928/1630825587646009344/1630825913757339648', '/财务-资产负责类/所有者权益和负债/非流动负债/其他非流动负债/长期应付账款/长期发明者奖金应付款', '/BS/P2000/P2200/P2250/233300/233304', NULL, 4, '0', '1', '1', '2023-03-01 15:02:52', '1', '2023-03-01 15:02:52');
INSERT INTO `qf_subject_international_info` VALUES ('1630825914344542208', 'BS3', '233305', '长期审计费应付款', 'Liabilities auditors fees long term', '€', '5', '1630825587646009344', 0, '/1630784869674127360/1630824894692462592/1630825088481890304/1630825214650748928/1630825587646009344/1630825914344542208', '/财务-资产负责类/所有者权益和负债/非流动负债/其他非流动负债/长期应付账款/长期审计费应付款', '/BS/P2000/P2200/P2250/233300/233305', NULL, 5, '0', '1', '1', '2023-03-01 15:02:52', '1', '2023-03-01 15:02:52');
INSERT INTO `qf_subject_international_info` VALUES ('1630825915003047936', 'BS3', '233306', '长期其他咨询费应付款', 'Liabilities consulting fees other  long term', '€', '5', '1630825587646009344', 0, '/1630784869674127360/1630824894692462592/1630825088481890304/1630825214650748928/1630825587646009344/1630825915003047936', '/财务-资产负责类/所有者权益和负债/非流动负债/其他非流动负债/长期应付账款/长期其他咨询费应付款', '/BS/P2000/P2200/P2250/233300/233306', NULL, 6, '0', '1', '1', '2023-03-01 15:02:52', '1', '2023-03-01 15:02:52');
INSERT INTO `qf_subject_international_info` VALUES ('1630825915594444800', 'BS3', '233307', '长期分包商应付款', 'Liabilities subcontractors  long term', '€', '5', '1630825587646009344', 0, '/1630784869674127360/1630824894692462592/1630825088481890304/1630825214650748928/1630825587646009344/1630825915594444800', '/财务-资产负责类/所有者权益和负债/非流动负债/其他非流动负债/长期应付账款/长期分包商应付款', '/BS/P2000/P2200/P2250/233300/233307', NULL, 7, '0', '1', '1', '2023-03-01 15:02:52', '1', '2023-03-01 15:02:52');
INSERT INTO `qf_subject_international_info` VALUES ('1630825916362002432', 'BS3', '233309', '长期递延收益', 'deferred income goverment grands - long term', '€', '5', '1630825587646009344', 0, '/1630784869674127360/1630824894692462592/1630825088481890304/1630825214650748928/1630825587646009344/1630825916362002432', '/财务-资产负责类/所有者权益和负债/非流动负债/其他非流动负债/长期应付账款/长期递延收益', '/BS/P2000/P2200/P2250/233300/233309', NULL, 8, '0', '1', '1', '2023-03-01 15:02:52', '1', '2023-03-01 15:02:52');
INSERT INTO `qf_subject_international_info` VALUES ('1630825916907261952', 'BS3', '237101', '其他退税长期负债', 'Liabilities for other tax refunds long term', '€', '5', '1630825588312903680', 0, '/1630784869674127360/1630824894692462592/1630825088481890304/1630825214650748928/1630825588312903680/1630825916907261952', '/财务-资产负责类/所有者权益和负债/非流动负债/其他非流动负债/应交税费/其他退税长期负债', '/BS/P2000/P2200/P2250/237100/237101', NULL, 1, '0', '1', '1', '2023-03-01 15:02:53', '1', '2023-03-01 15:02:53');
INSERT INTO `qf_subject_international_info` VALUES ('1630825917460910080', 'BS3', '237201', '长期遣散费负债', 'Liabilities severances long term', '€', '5', '1630825588879134720', 0, '/1630784869674127360/1630824894692462592/1630825088481890304/1630825214650748928/1630825588879134720/1630825917460910080', '/财务-资产负责类/所有者权益和负债/非流动负债/其他非流动负债/长期应付职工薪酬/长期遣散费负债', '/BS/P2000/P2200/P2250/237200/237201', NULL, 1, '0', '1', '1', '2023-03-01 15:02:53', '1', '2023-03-01 15:02:53');
INSERT INTO `qf_subject_international_info` VALUES ('1630825918060695552', 'BS3', '237202', '长期直接员工薪酬负债', 'Liabilities time account wages earner  long term', '€', '5', '1630825588879134720', 0, '/1630784869674127360/1630824894692462592/1630825088481890304/1630825214650748928/1630825588879134720/1630825918060695552', '/财务-资产负责类/所有者权益和负债/非流动负债/其他非流动负债/长期应付职工薪酬/长期直接员工薪酬负债', '/BS/P2000/P2200/P2250/237200/237202', NULL, 2, '0', '1', '1', '2023-03-01 15:02:53', '1', '2023-03-01 15:02:53');
INSERT INTO `qf_subject_international_info` VALUES ('1630825918723395584', 'BS3', '237203', '长期间接员工薪酬负债', 'Liabilities time account salary earner  long term', '€', '5', '1630825588879134720', 0, '/1630784869674127360/1630824894692462592/1630825088481890304/1630825214650748928/1630825588879134720/1630825918723395584', '/财务-资产负责类/所有者权益和负债/非流动负债/其他非流动负债/长期应付职工薪酬/长期间接员工薪酬负债', '/BS/P2000/P2200/P2250/237200/237203', NULL, 3, '0', '1', '1', '2023-03-01 15:02:53', '1', '2023-03-01 15:02:53');
INSERT INTO `qf_subject_international_info` VALUES ('1630825919373512704', 'BS3', '237204', '长期变动工资负债', 'Liabilities variable wages/salary  long term', '€', '5', '1630825588879134720', 0, '/1630784869674127360/1630824894692462592/1630825088481890304/1630825214650748928/1630825588879134720/1630825919373512704', '/财务-资产负责类/所有者权益和负债/非流动负债/其他非流动负债/长期应付职工薪酬/长期变动工资负债', '/BS/P2000/P2200/P2250/237200/237204', NULL, 4, '0', '1', '1', '2023-03-01 15:02:53', '1', '2023-03-01 15:02:53');
INSERT INTO `qf_subject_international_info` VALUES ('1630825919981686784', 'BS3', '237205', '长期差旅费负债', 'Liabilities missing travel expenses  long term', '€', '5', '1630825588879134720', 0, '/1630784869674127360/1630824894692462592/1630825088481890304/1630825214650748928/1630825588879134720/1630825919981686784', '/财务-资产负责类/所有者权益和负债/非流动负债/其他非流动负债/长期应付职工薪酬/长期差旅费负债', '/BS/P2000/P2200/P2250/237200/237205', NULL, 5, '0', '1', '1', '2023-03-01 15:02:53', '1', '2023-03-01 15:02:53');
INSERT INTO `qf_subject_international_info` VALUES ('1630825920568889344', 'BS3', '237206', '长期社会福利负债', 'Liabilities social benefits long term', '€', '5', '1630825588879134720', 0, '/1630784869674127360/1630824894692462592/1630825088481890304/1630825214650748928/1630825588879134720/1630825920568889344', '/财务-资产负责类/所有者权益和负债/非流动负债/其他非流动负债/长期应付职工薪酬/长期社会福利负债', '/BS/P2000/P2200/P2250/237200/237206', NULL, 6, '0', '1', '1', '2023-03-01 15:02:53', '1', '2023-03-01 15:02:54');
INSERT INTO `qf_subject_international_info` VALUES ('1630825921311281152', 'BS3', '237207', '长期管理人员奖金负债', 'Liabilities for management bonus entrepreneurship long term', '€', '5', '1630825588879134720', 0, '/1630784869674127360/1630824894692462592/1630825088481890304/1630825214650748928/1630825588879134720/1630825921311281152', '/财务-资产负责类/所有者权益和负债/非流动负债/其他非流动负债/长期应付职工薪酬/长期管理人员奖金负债', '/BS/P2000/P2200/P2250/237200/237207', NULL, 7, '0', '1', '1', '2023-03-01 15:02:54', '1', '2023-03-01 15:02:54');
INSERT INTO `qf_subject_international_info` VALUES ('1630825921936232448', 'BS3', '237208', '长期重组费用负债', 'Liabilities for restructuring  long term', '€', '5', '1630825588879134720', 0, '/1630784869674127360/1630824894692462592/1630825088481890304/1630825214650748928/1630825588879134720/1630825921936232448', '/财务-资产负责类/所有者权益和负债/非流动负债/其他非流动负债/长期应付职工薪酬/长期重组费用负债', '/BS/P2000/P2200/P2250/237200/237208', NULL, 8, '0', '1', '1', '2023-03-01 15:02:54', '1', '2023-03-01 15:02:54');
INSERT INTO `qf_subject_international_info` VALUES ('1630825922540212224', 'BS3', '237209', '长期会费和其他费用负债', 'Liabilities contributions and fees long term', '€', '5', '1630825588879134720', 0, '/1630784869674127360/1630824894692462592/1630825088481890304/1630825214650748928/1630825588879134720/1630825922540212224', '/财务-资产负责类/所有者权益和负债/非流动负债/其他非流动负债/长期应付职工薪酬/长期会费和其他费用负债', '/BS/P2000/P2200/P2250/237200/237209', NULL, 9, '0', '1', '1', '2023-03-01 15:02:54', '1', '2023-03-01 15:02:54');
INSERT INTO `qf_subject_international_info` VALUES ('1630825923412627456', 'BS3', '237210', '长期内部年度会计核算负债', 'Liabilities for internal annual accounting operation long term', '€', '5', '1630825588879134720', 0, '/1630784869674127360/1630824894692462592/1630825088481890304/1630825214650748928/1630825588879134720/1630825923412627456', '/财务-资产负责类/所有者权益和负债/非流动负债/其他非流动负债/长期应付职工薪酬/长期内部年度会计核算负债', '/BS/P2000/P2200/P2250/237200/237210', NULL, 10, '0', '1', '1', '2023-03-01 15:02:54', '1', '2023-03-01 15:02:54');
INSERT INTO `qf_subject_international_info` VALUES ('1630825924201156608', 'BS3', '237405', '长期维护费用负债', 'Liabilities maintenance  long term', '€', '5', '1630825589436977152', 0, '/1630784869674127360/1630824894692462592/1630825088481890304/1630825214650748928/1630825589436977152/1630825924201156608', '/财务-资产负责类/所有者权益和负债/非流动负债/其他非流动负债/其他负债/长期维护费用负债', '/BS/P2000/P2200/P2250/237400/237405', NULL, 1, '0', '1', '1', '2023-03-01 15:02:54', '1', '2023-03-01 15:02:54');
INSERT INTO `qf_subject_international_info` VALUES ('1630825924796747776', 'BS3', '234301', '长期当地交易税负债', 'Liabilities for local trade tax returns long term', '€', '5', '1630825590024179712', 0, '/1630784869674127360/1630824894692462592/1630825088481890304/1630825215250534400/1630825590024179712/1630825924796747776', '/财务-资产负责类/所有者权益和负债/非流动负债/非流动所得税负债/一年以上的应交所得税/长期当地交易税负债', '/BS/P2000/P2200/P2270/234300/234301', NULL, 1, '0', '1', '1', '2023-03-01 15:02:54', '1', '2023-03-01 15:02:54');
INSERT INTO `qf_subject_international_info` VALUES ('1630825925354590208', 'BS3', '234302', '长期所得税负债', 'Liabilities for income tax returns long therm', '€', '5', '1630825590024179712', 0, '/1630784869674127360/1630824894692462592/1630825088481890304/1630825215250534400/1630825590024179712/1630825925354590208', '/财务-资产负责类/所有者权益和负债/非流动负债/非流动所得税负债/一年以上的应交所得税/长期所得税负债', '/BS/P2000/P2200/P2270/234300/234302', NULL, 2, '0', '1', '1', '2023-03-01 15:02:55', '1', '2023-03-01 15:02:55');
INSERT INTO `qf_subject_international_info` VALUES ('1630825925920821248', 'BS3', '234101', '递延税款负债', 'liabilities deferred taxes', '€', '5', '1630825590753988608', 0, '/1630784869674127360/1630824894692462592/1630825088481890304/1630825215812571136/1630825590753988608/1630825925920821248', '/财务-资产负责类/所有者权益和负债/非流动负债/递延所得税负债/递延税款负债/递延税款负债', '/BS/P2000/P2200/P2260/234100/234101', NULL, 1, '0', '1', '1', '2023-03-01 15:02:55', '1', '2023-03-01 15:02:55');
INSERT INTO `qf_subject_international_info` VALUES ('1630825926478663680', 'BS3', '234102', '递延税款负债PPA', 'liabilities deferred taxes PPA', '€', '5', '1630825590753988608', 0, '/1630784869674127360/1630824894692462592/1630825088481890304/1630825215812571136/1630825590753988608/1630825926478663680', '/财务-资产负责类/所有者权益和负债/非流动负债/递延所得税负债/递延税款负债/递延税款负债PPA', '/BS/P2000/P2200/P2260/234100/234102', NULL, 2, '0', '1', '1', '2023-03-01 15:02:55', '1', '2023-03-01 15:02:55');
INSERT INTO `qf_subject_international_info` VALUES ('1630825927120392192', 'BS3', '232101', '集团合同负债（POC预付款）', 'Contract liabilities ( down payment PoC) Group', '€', '5', '1630825591374745600', 0, '/1630784869674127360/1630824894692462592/1630825089119424512/1630825216387190784/1630825591374745600/1630825927120392192', '/财务-资产负责类/所有者权益和负债/流动负债/应付账款、其他应付款及合同负债/合同负债/集团合同负债（POC预付款）', '/BS/P2000/P2300/P2310/232100/232101', NULL, 1, '0', '1', '1', '2023-03-01 15:02:55', '1', '2023-03-01 15:02:55');
INSERT INTO `qf_subject_international_info` VALUES ('1630825927749537792', 'BS3', '232102', '关联公司间预付账款', 'Prepayment  affiliated companies', '€', '5', '1630825591374745600', 0, '/1630784869674127360/1630824894692462592/1630825089119424512/1630825216387190784/1630825591374745600/1630825927749537792', '/财务-资产负责类/所有者权益和负债/流动负债/应付账款、其他应付款及合同负债/合同负债/关联公司间预付账款', '/BS/P2000/P2300/P2310/232100/232102', NULL, 2, '0', '1', '1', '2023-03-01 15:02:55', '1', '2023-03-01 15:02:55');
INSERT INTO `qf_subject_international_info` VALUES ('1630825928328351744', 'BS3', '232103', '第三方合同负债（预付款PoC）', 'Contract liabilities (prepayment PoC) third party', '€', '5', '1630825591374745600', 0, '/1630784869674127360/1630824894692462592/1630825089119424512/1630825216387190784/1630825591374745600/1630825928328351744', '/财务-资产负责类/所有者权益和负债/流动负债/应付账款、其他应付款及合同负债/合同负债/第三方合同负债（预付款PoC）', '/BS/P2000/P2300/P2310/232100/232103', NULL, 3, '0', '1', '1', '2023-03-01 15:02:55', '1', '2023-03-01 15:02:55');
INSERT INTO `qf_subject_international_info` VALUES ('1630825928957497344', 'BS3', '232104', '第三方预付账款', 'Prepayment 3rd parties', '€', '5', '1630825591970336768', 0, '/1630784869674127360/1630824894692462592/1630825089119424512/1630825216387190784/1630825591970336768/1630825928957497344', '/财务-资产负责类/所有者权益和负债/流动负债/应付账款、其他应付款及合同负债/客户预付款/第三方预付账款', '/BS/P2000/P2300/P2310/232110/232104', NULL, 1, '0', '1', '1', '2023-03-01 15:02:55', '1', '2023-03-01 15:02:56');
INSERT INTO `qf_subject_international_info` VALUES ('1630825929691500544', 'BS3', '233101', '国内应付账款', 'Trade Payables domestic', '€', '5', '1630825592591093760', 0, '/1630784869674127360/1630824894692462592/1630825089119424512/1630825216387190784/1630825592591093760/1630825929691500544', '/财务-资产负责类/所有者权益和负债/流动负债/应付账款、其他应付款及合同负债/应付账款（债权人）/国内应付账款', '/BS/P2000/P2300/P2310/233100/233101', NULL, 1, '0', '1', '1', '2023-03-01 15:02:56', '1', '2023-03-01 15:02:56');
INSERT INTO `qf_subject_international_info` VALUES ('1630825930261925888', 'BS3', '233102', '国外应付帐款', 'Trade Payables foreign companies', '€', '5', '1630825592591093760', 0, '/1630784869674127360/1630824894692462592/1630825089119424512/1630825216387190784/1630825592591093760/1630825930261925888', '/财务-资产负责类/所有者权益和负债/流动负债/应付账款、其他应付款及合同负债/应付账款（债权人）/国外应付帐款', '/BS/P2000/P2300/P2310/233100/233102', NULL, 2, '0', '1', '1', '2023-03-01 15:02:56', '1', '2023-03-01 15:02:56');
INSERT INTO `qf_subject_international_info` VALUES ('1630825930832351232', 'BS3', '233105', '其他应付账款', 'Trade Payables other', '€', '5', '1630825592591093760', 0, '/1630784869674127360/1630824894692462592/1630825089119424512/1630825216387190784/1630825592591093760/1630825930832351232', '/财务-资产负责类/所有者权益和负债/流动负债/应付账款、其他应付款及合同负债/应付账款（债权人）/其他应付账款', '/BS/P2000/P2300/P2310/233100/233105', NULL, 3, '0', '1', '1', '2023-03-01 15:02:56', '1', '2023-03-01 15:02:56');
INSERT INTO `qf_subject_international_info` VALUES ('1630825931423748096', 'BS3', '233107', 'GR/IR SAP 帐户', 'GR/IR SAP account', '€', '5', '1630825592591093760', 0, '/1630784869674127360/1630824894692462592/1630825089119424512/1630825216387190784/1630825592591093760/1630825931423748096', '/财务-资产负责类/所有者权益和负债/流动负债/应付账款、其他应付款及合同负债/应付账款（债权人）/GR/IR SAP 帐户', '/BS/P2000/P2300/P2310/233100/233107', NULL, 4, '0', '1', '1', '2023-03-01 15:02:56', '1', '2023-03-01 15:02:56');
INSERT INTO `qf_subject_international_info` VALUES ('1630825932040310784', 'BS3', '233108', '折扣 SAP 帐户', 'Discount SAP account', '€', '5', '1630825592591093760', 0, '/1630784869674127360/1630824894692462592/1630825089119424512/1630825216387190784/1630825592591093760/1630825932040310784', '/财务-资产负责类/所有者权益和负债/流动负债/应付账款、其他应付款及合同负债/应付账款（债权人）/折扣 SAP 帐户', '/BS/P2000/P2300/P2310/233100/233108', NULL, 5, '0', '1', '1', '2023-03-01 15:02:56', '1', '2023-03-01 15:02:56');
INSERT INTO `qf_subject_international_info` VALUES ('1630825932656873472', 'BS3', '233110', '关联方应付账款', 'trade payables to related parties', '€', '5', '1630825592591093760', 0, '/1630784869674127360/1630824894692462592/1630825089119424512/1630825216387190784/1630825592591093760/1630825932656873472', '/财务-资产负责类/所有者权益和负债/流动负债/应付账款、其他应付款及合同负债/应付账款（债权人）/关联方应付账款', '/BS/P2000/P2300/P2310/233100/233110', NULL, 6, '0', '1', '1', '2023-03-01 15:02:56', '1', '2023-03-01 15:02:56');
INSERT INTO `qf_subject_international_info` VALUES ('1630825933256658944', 'BS3', '233111', '预提降价准备金', 'liabilities savings', '€', '5', '1630825592591093760', 0, '/1630784869674127360/1630824894692462592/1630825089119424512/1630825216387190784/1630825592591093760/1630825933256658944', '/财务-资产负责类/所有者权益和负债/流动负债/应付账款、其他应付款及合同负债/应付账款（债权人）/预提降价准备金', '/BS/P2000/P2300/P2310/233100/233111', NULL, 7, '0', '1', '1', '2023-03-01 15:02:56', '1', '2023-03-01 15:02:56');
INSERT INTO `qf_subject_international_info` VALUES ('1630825933877415936', 'BS3', '233112', '支票义务', 'cheque obligations', '€', '5', '1630825592591093760', 0, '/1630784869674127360/1630824894692462592/1630825089119424512/1630825216387190784/1630825592591093760/1630825933877415936', '/财务-资产负责类/所有者权益和负债/流动负债/应付账款、其他应付款及合同负债/应付账款（债权人）/支票义务', '/BS/P2000/P2300/P2310/233100/233112', NULL, 8, '0', '1', '1', '2023-03-01 15:02:57', '1', '2023-03-01 15:02:57');
INSERT INTO `qf_subject_international_info` VALUES ('1630825934519144448', 'BS3', '233201', '短期供应商发票的负债', 'Liabilities for missing supplier invoices short term', '€', '5', '1630825593740333056', 0, '/1630784869674127360/1630824894692462592/1630825089119424512/1630825216387190784/1630825593740333056/1630825934519144448', '/财务-资产负责类/所有者权益和负债/流动负债/应付账款、其他应付款及合同负债/短期应付账款/短期供应商发票的负债', '/BS/P2000/P2300/P2310/233200/233201', NULL, 1, '0', '1', '1', '2023-03-01 15:02:57', '1', '2023-03-01 15:02:57');
INSERT INTO `qf_subject_international_info` VALUES ('1630825935131512832', 'BS3', '233202', '短期能源、天然气、水费负债', 'Liabilities for energy, natural gas, water short term', '€', '5', '1630825593740333056', 0, '/1630784869674127360/1630824894692462592/1630825089119424512/1630825216387190784/1630825593740333056/1630825935131512832', '/财务-资产负责类/所有者权益和负债/流动负债/应付账款、其他应付款及合同负债/短期应付账款/短期能源、天然气、水费负债', '/BS/P2000/P2300/P2310/233200/233202', NULL, 2, '0', '1', '1', '2023-03-01 15:02:57', '1', '2023-03-01 15:02:57');
INSERT INTO `qf_subject_international_info` VALUES ('1630825936075231232', 'BS3', '233205', '短期审计费用负债', 'Liabilities auditors fees short term', '€', '5', '1630825593740333056', 0, '/1630784869674127360/1630824894692462592/1630825089119424512/1630825216387190784/1630825593740333056/1630825936075231232', '/财务-资产负责类/所有者权益和负债/流动负债/应付账款、其他应付款及合同负债/短期应付账款/短期审计费用负债', '/BS/P2000/P2300/P2310/233200/233205', NULL, 3, '0', '1', '1', '2023-03-01 15:02:57', '1', '2023-03-01 15:02:57');
INSERT INTO `qf_subject_international_info` VALUES ('1630825936670822400', 'BS3', '233206', '短期咨询费用负债', 'Liabilities consulting fees other short term', '€', '5', '1630825593740333056', 0, '/1630784869674127360/1630824894692462592/1630825089119424512/1630825216387190784/1630825593740333056/1630825936670822400', '/财务-资产负责类/所有者权益和负债/流动负债/应付账款、其他应付款及合同负债/短期应付账款/短期咨询费用负债', '/BS/P2000/P2300/P2310/233200/233206', NULL, 4, '0', '1', '1', '2023-03-01 15:02:57', '1', '2023-03-01 15:02:57');
INSERT INTO `qf_subject_international_info` VALUES ('1630825937274802176', 'BS3', '233207', '短期分包商负债', 'Liabilities subcontractors short term', '€', '5', '1630825593740333056', 0, '/1630784869674127360/1630824894692462592/1630825089119424512/1630825216387190784/1630825593740333056/1630825937274802176', '/财务-资产负责类/所有者权益和负债/流动负债/应付账款、其他应付款及合同负债/短期应付账款/短期分包商负债', '/BS/P2000/P2300/P2310/233200/233207', NULL, 5, '0', '1', '1', '2023-03-01 15:02:57', '1', '2023-03-01 15:02:57');
INSERT INTO `qf_subject_international_info` VALUES ('1630825937882976256', 'BS3', '233203', '其他短期负债', 'Liabilities other short term', '€', '5', '1630825594323341312', 0, '/1630784869674127360/1630824894692462592/1630825089119424512/1630825216387190784/1630825594323341312/1630825937882976256', '/财务-资产负责类/所有者权益和负债/流动负债/应付账款、其他应付款及合同负债/其他短期负债/其他短期负债', '/BS/P2000/P2300/P2310/233210/233203', NULL, 1, '0', '1', '1', '2023-03-01 15:02:58', '1', '2023-03-01 15:02:58');
INSERT INTO `qf_subject_international_info` VALUES ('1630825938482761728', 'BS3', '233209', '短期递延收益', 'deferred income goverment grands - short term', '€', '5', '1630825594323341312', 0, '/1630784869674127360/1630824894692462592/1630825089119424512/1630825216387190784/1630825594323341312/1630825938482761728', '/财务-资产负责类/所有者权益和负债/流动负债/应付账款、其他应付款及合同负债/其他短期负债/短期递延收益', '/BS/P2000/P2300/P2310/233210/233209', NULL, 2, '0', '1', '1', '2023-03-01 15:02:58', '1', '2023-03-01 15:02:58');
INSERT INTO `qf_subject_international_info` VALUES ('1630825939095130112', 'BS3', '236101', '其他短期退税负债', 'Liabilities for other tax refunds short term', '€', '5', '1630825594902155264', 0, '/1630784869674127360/1630824894692462592/1630825089119424512/1630825216387190784/1630825594902155264/1630825939095130112', '/财务-资产负责类/所有者权益和负债/流动负债/应付账款、其他应付款及合同负债/应交税金/其他短期退税负债', '/BS/P2000/P2300/P2310/236100/236101', NULL, 1, '0', '1', '1', '2023-03-01 15:02:58', '1', '2023-03-01 15:02:58');
INSERT INTO `qf_subject_international_info` VALUES ('1630825939837521920', 'BS3', '236103', '往年增值税负债', 'liabilities VAT previous year', '€', '5', '1630825594902155264', 0, '/1630784869674127360/1630824894692462592/1630825089119424512/1630825216387190784/1630825594902155264/1630825939837521920', '/财务-资产负责类/所有者权益和负债/流动负债/应付账款、其他应付款及合同负债/应交税金/往年增值税负债', '/BS/P2000/P2300/P2310/236100/236103', NULL, 2, '0', '1', '1', '2023-03-01 15:02:58', '1', '2023-03-01 15:02:58');
INSERT INTO `qf_subject_international_info` VALUES ('1630825940407947264', 'BS3', '236104', '工资税', 'payroll tax', '€', '5', '1630825594902155264', 0, '/1630784869674127360/1630824894692462592/1630825089119424512/1630825216387190784/1630825594902155264/1630825940407947264', '/财务-资产负责类/所有者权益和负债/流动负债/应付账款、其他应付款及合同负债/应交税金/工资税', '/BS/P2000/P2300/P2310/236100/236104', NULL, 3, '0', '1', '1', '2023-03-01 15:02:58', '1', '2023-03-01 15:02:58');
INSERT INTO `qf_subject_international_info` VALUES ('1630825941003538432', 'BS3', '236102', '当年增值税', 'VAT current year', '€', '5', '1630825595497746432', 0, '/1630784869674127360/1630824894692462592/1630825089119424512/1630825216387190784/1630825595497746432/1630825941003538432', '/财务-资产负责类/所有者权益和负债/流动负债/应付账款、其他应付款及合同负债/应交税金/当年增值税', '/BS/P2000/P2300/P2310/236110/236102', NULL, 1, '0', '1', '1', '2023-03-01 15:02:58', '1', '2023-03-01 15:02:58');
INSERT INTO `qf_subject_international_info` VALUES ('1630825941603323904', 'BS3', '236201', '法律工作者补偿短期负债', 'Liabilities legal workers compensation short term', '€', '5', '1630825596072366080', 0, '/1630784869674127360/1630824894692462592/1630825089119424512/1630825216387190784/1630825596072366080/1630825941603323904', '/财务-资产负责类/所有者权益和负债/流动负债/应付账款、其他应付款及合同负债/应付社保费/法律工作者补偿短期负债', '/BS/P2000/P2300/P2310/236200/236201', NULL, 1, '0', '1', '1', '2023-03-01 15:02:58', '1', '2023-03-01 15:02:58');
INSERT INTO `qf_subject_international_info` VALUES ('1630825942182137856', 'BS3', '236202', '残疾工人短期负债', 'Liabilities equalization for handicapped workers short term', '€', '5', '1630825596072366080', 0, '/1630784869674127360/1630824894692462592/1630825089119424512/1630825216387190784/1630825596072366080/1630825942182137856', '/财务-资产负责类/所有者权益和负债/流动负债/应付账款、其他应付款及合同负债/应付社保费/残疾工人短期负债', '/BS/P2000/P2300/P2310/236200/236202', NULL, 2, '0', '1', '1', '2023-03-01 15:02:59', '1', '2023-03-01 15:02:59');
INSERT INTO `qf_subject_international_info` VALUES ('1630825942849032192', 'BS3', '236203', '健康保险缴款负债', 'liabilities health insurance contribution', '€', '5', '1630825596072366080', 0, '/1630784869674127360/1630824894692462592/1630825089119424512/1630825216387190784/1630825596072366080/1630825942849032192', '/财务-资产负责类/所有者权益和负债/流动负债/应付账款、其他应付款及合同负债/应付社保费/健康保险缴款负债', '/BS/P2000/P2300/P2310/236200/236203', NULL, 3, '0', '1', '1', '2023-03-01 15:02:59', '1', '2023-03-01 15:02:59');
INSERT INTO `qf_subject_international_info` VALUES ('1630825943453011968', 'BS3', '236204', '社会保险负债', 'liabilities social insurance', '€', '5', '1630825596072366080', 0, '/1630784869674127360/1630824894692462592/1630825089119424512/1630825216387190784/1630825596072366080/1630825943453011968', '/财务-资产负责类/所有者权益和负债/流动负债/应付账款、其他应付款及合同负债/应付社保费/社会保险负债', '/BS/P2000/P2300/P2310/236200/236204', NULL, 4, '0', '1', '1', '2023-03-01 15:02:59', '1', '2023-03-01 15:02:59');
INSERT INTO `qf_subject_international_info` VALUES ('1630825944136683520', 'BS3', '236301', '短期负债遣散费', 'Liabilities severances short term', '€', '5', '1630825596676345856', 0, '/1630784869674127360/1630824894692462592/1630825089119424512/1630825216387190784/1630825596676345856/1630825944136683520', '/财务-资产负责类/所有者权益和负债/流动负债/应付账款、其他应付款及合同负债/应付职工薪酬/短期负债遣散费', '/BS/P2000/P2300/P2310/236300/236301', NULL, 1, '0', '1', '1', '2023-03-01 15:02:59', '1', '2023-03-01 15:02:59');
INSERT INTO `qf_subject_international_info` VALUES ('1630825944765829120', 'BS3', '236302', '工薪阶层账户短期负债', 'Liabilities time account wages earner short term', '€', '5', '1630825596676345856', 0, '/1630784869674127360/1630824894692462592/1630825089119424512/1630825216387190784/1630825596676345856/1630825944765829120', '/财务-资产负责类/所有者权益和负债/流动负债/应付账款、其他应付款及合同负债/应付职工薪酬/工薪阶层账户短期负债', '/BS/P2000/P2300/P2310/236300/236302', NULL, 2, '0', '1', '1', '2023-03-01 15:02:59', '1', '2023-03-01 15:02:59');
INSERT INTO `qf_subject_international_info` VALUES ('1630825945378197504', 'BS3', '236303', '工薪阶层账户短期负债', 'Liabilities time account salary earner short term', '€', '5', '1630825596676345856', 0, '/1630784869674127360/1630824894692462592/1630825089119424512/1630825216387190784/1630825596676345856/1630825945378197504', '/财务-资产负责类/所有者权益和负债/流动负债/应付账款、其他应付款及合同负债/应付职工薪酬/工薪阶层账户短期负债', '/BS/P2000/P2300/P2310/236300/236303', NULL, 3, '0', '1', '1', '2023-03-01 15:02:59', '1', '2023-03-01 15:02:59');
INSERT INTO `qf_subject_international_info` VALUES ('1630825946003148800', 'BS3', '236304', '假期账户工薪阶层短期负债', 'Liabilities holiday account wages earner short term', '€', '5', '1630825596676345856', 0, '/1630784869674127360/1630824894692462592/1630825089119424512/1630825216387190784/1630825596676345856/1630825946003148800', '/财务-资产负责类/所有者权益和负债/流动负债/应付账款、其他应付款及合同负债/应付职工薪酬/假期账户工薪阶层短期负债', '/BS/P2000/P2300/P2310/236300/236304', NULL, 4, '0', '1', '1', '2023-03-01 15:03:00', '1', '2023-03-01 15:03:00');
INSERT INTO `qf_subject_international_info` VALUES ('1630825946602934272', 'BS3', '236305', '假期账户工薪阶层短期负债', 'Liabilities holiday account salary earner short term', '€', '5', '1630825596676345856', 0, '/1630784869674127360/1630824894692462592/1630825089119424512/1630825216387190784/1630825596676345856/1630825946602934272', '/财务-资产负责类/所有者权益和负债/流动负债/应付账款、其他应付款及合同负债/应付职工薪酬/假期账户工薪阶层短期负债', '/BS/P2000/P2300/P2310/236300/236305', NULL, 5, '0', '1', '1', '2023-03-01 15:03:00', '1', '2023-03-01 15:03:00');
INSERT INTO `qf_subject_international_info` VALUES ('1630825947181748224', 'BS3', '236306', '短期变动工资负债', 'Liabilities variable wages/salary short term', '€', '5', '1630825596676345856', 0, '/1630784869674127360/1630824894692462592/1630825089119424512/1630825216387190784/1630825596676345856/1630825947181748224', '/财务-资产负责类/所有者权益和负债/流动负债/应付账款、其他应付款及合同负债/应付职工薪酬/短期变动工资负债', '/BS/P2000/P2300/P2310/236300/236306', NULL, 6, '0', '1', '1', '2023-03-01 15:03:00', '1', '2023-03-01 15:03:00');
INSERT INTO `qf_subject_international_info` VALUES ('1630825947789922304', 'BS3', '236307', '短期社会福利负债', 'Liabilities social benefits short term', '€', '5', '1630825596676345856', 0, '/1630784869674127360/1630824894692462592/1630825089119424512/1630825216387190784/1630825596676345856/1630825947789922304', '/财务-资产负责类/所有者权益和负债/流动负债/应付账款、其他应付款及合同负债/应付职工薪酬/短期社会福利负债', '/BS/P2000/P2300/P2310/236300/236307', NULL, 7, '0', '1', '1', '2023-03-01 15:03:00', '1', '2023-03-01 15:03:00');
INSERT INTO `qf_subject_international_info` VALUES ('1630825948393902080', 'BS3', '236308', '短期管理层奖金负债', 'Liabilities for management bonus entrepreneurship short term', '€', '5', '1630825596676345856', 0, '/1630784869674127360/1630824894692462592/1630825089119424512/1630825216387190784/1630825596676345856/1630825948393902080', '/财务-资产负责类/所有者权益和负债/流动负债/应付账款、其他应付款及合同负债/应付职工薪酬/短期管理层奖金负债', '/BS/P2000/P2300/P2310/236300/236308', NULL, 8, '0', '1', '1', '2023-03-01 15:03:00', '1', '2023-03-01 15:03:00');
INSERT INTO `qf_subject_international_info` VALUES ('1630825949002076160', 'BS3', '236309', '对雇员的资本形成付款负债', 'Liabilities to employess for capital forming payment', '€', '5', '1630825596676345856', 0, '/1630784869674127360/1630824894692462592/1630825089119424512/1630825216387190784/1630825596676345856/1630825949002076160', '/财务-资产负责类/所有者权益和负债/流动负债/应付账款、其他应付款及合同负债/应付职工薪酬/对雇员的资本形成付款负债', '/BS/P2000/P2300/P2310/236300/236309', NULL, 9, '0', '1', '1', '2023-03-01 15:03:00', '1', '2023-03-01 15:03:00');
INSERT INTO `qf_subject_international_info` VALUES ('1630825949610250240', 'BS3', '236310', '其他应收/员工负债', 'other receivables/liabilities employees', '€', '5', '1630825596676345856', 0, '/1630784869674127360/1630824894692462592/1630825089119424512/1630825216387190784/1630825596676345856/1630825949610250240', '/财务-资产负责类/所有者权益和负债/流动负债/应付账款、其他应付款及合同负债/应付职工薪酬/其他应收/员工负债', '/BS/P2000/P2300/P2310/236300/236310', NULL, 10, '0', '1', '1', '2023-03-01 15:03:00', '1', '2023-03-01 15:03:00');
INSERT INTO `qf_subject_international_info` VALUES ('1630825950214230016', 'BS3', '236314', '工资/薪金', 'attachment of wage/salary', '€', '5', '1630825596676345856', 0, '/1630784869674127360/1630824894692462592/1630825089119424512/1630825216387190784/1630825596676345856/1630825950214230016', '/财务-资产负责类/所有者权益和负债/流动负债/应付账款、其他应付款及合同负债/应付职工薪酬/工资/薪金', '/BS/P2000/P2300/P2310/236300/236314', NULL, 11, '0', '1', '1', '2023-03-01 15:03:01', '1', '2023-03-01 15:03:01');
INSERT INTO `qf_subject_international_info` VALUES ('1630825950818209792', 'BS3', '236315', '慈善基金', 'benevolent fund', '€', '5', '1630825596676345856', 0, '/1630784869674127360/1630824894692462592/1630825089119424512/1630825216387190784/1630825596676345856/1630825950818209792', '/财务-资产负责类/所有者权益和负债/流动负债/应付账款、其他应付款及合同负债/应付职工薪酬/慈善基金', '/BS/P2000/P2300/P2310/236300/236315', NULL, 12, '0', '1', '1', '2023-03-01 15:03:01', '1', '2023-03-01 15:03:01');
INSERT INTO `qf_subject_international_info` VALUES ('1630825951426383872', 'BS3', '236317', '差旅费、商务招待费、里程数等负债。', 'liabilities from travel expenses, business entertainment, miles allow.', '€', '5', '1630825596676345856', 0, '/1630784869674127360/1630824894692462592/1630825089119424512/1630825216387190784/1630825596676345856/1630825951426383872', '/财务-资产负责类/所有者权益和负债/流动负债/应付账款、其他应付款及合同负债/应付职工薪酬/差旅费、商务招待费、里程数等负债。', '/BS/P2000/P2300/P2310/236300/236317', NULL, 13, '0', '1', '1', '2023-03-01 15:03:01', '1', '2023-03-01 15:03:01');
INSERT INTO `qf_subject_international_info` VALUES ('1630825952026169344', 'BS3', '236311', '应付工人工资', 'liabilities from wages', '€', '5', '1630825596676345856', 0, '/1630784869674127360/1630824894692462592/1630825089119424512/1630825216387190784/1630825596676345856/1630825952026169344', '/财务-资产负责类/所有者权益和负债/流动负债/应付账款、其他应付款及合同负债/应付职工薪酬/应付工人工资', '/BS/P2000/P2300/P2310/236300/236311', NULL, 14, '0', '1', '1', '2023-03-01 15:03:01', '1', '2023-03-01 15:03:01');
INSERT INTO `qf_subject_international_info` VALUES ('1630825952630149120', 'BS3', '236312', '应付管理人员工资', 'liabilities from salary', '€', '5', '1630825596676345856', 0, '/1630784869674127360/1630824894692462592/1630825089119424512/1630825216387190784/1630825596676345856/1630825952630149120', '/财务-资产负责类/所有者权益和负债/流动负债/应付账款、其他应付款及合同负债/应付职工薪酬/应付管理人员工资', '/BS/P2000/P2300/P2310/236300/236312', NULL, 15, '0', '1', '1', '2023-03-01 15:03:01', '1', '2023-03-01 15:03:01');
INSERT INTO `qf_subject_international_info` VALUES ('1630825953221545984', 'BS3', '236402', '付款期限>120天的其他负债', 'other liabilities with term of payment > 120 days', '€', '5', '1630825597255159808', 0, '/1630784869674127360/1630824894692462592/1630825089119424512/1630825216387190784/1630825597255159808/1630825953221545984', '/财务-资产负责类/所有者权益和负债/流动负债/应付账款、其他应付款及合同负债/其他应付款/付款期限>120天的其他负债', '/BS/P2000/P2300/P2310/P2315/236402', NULL, 1, '0', '1', '1', '2023-03-01 15:03:01', '1', '2023-03-01 15:03:01');
INSERT INTO `qf_subject_international_info` VALUES ('1630825953800359936', 'BS3', '236403', '其他负债', 'other liabilities', '€', '5', '1630825597255159808', 0, '/1630784869674127360/1630824894692462592/1630825089119424512/1630825216387190784/1630825597255159808/1630825953800359936', '/财务-资产负责类/所有者权益和负债/流动负债/应付账款、其他应付款及合同负债/其他应付款/其他负债', '/BS/P2000/P2300/P2310/P2315/236403', NULL, 2, '0', '1', '1', '2023-03-01 15:03:01', '1', '2023-03-01 15:03:01');
INSERT INTO `qf_subject_international_info` VALUES ('1630825954408534016', 'BS3', '236405', '重组短期负债', 'Liabilities for restructuring short term', '€', '5', '1630825597255159808', 0, '/1630784869674127360/1630824894692462592/1630825089119424512/1630825216387190784/1630825597255159808/1630825954408534016', '/财务-资产负责类/所有者权益和负债/流动负债/应付账款、其他应付款及合同负债/其他应付款/重组短期负债', '/BS/P2000/P2300/P2310/P2315/236405', NULL, 3, '0', '1', '1', '2023-03-01 15:03:02', '1', '2023-03-01 15:03:02');
INSERT INTO `qf_subject_international_info` VALUES ('1630825955033485312', 'BS3', '236406', '短期负债供款和费用', 'Liabilities contributions and fees short term', '€', '5', '1630825597255159808', 0, '/1630784869674127360/1630824894692462592/1630825089119424512/1630825216387190784/1630825597255159808/1630825955033485312', '/财务-资产负责类/所有者权益和负债/流动负债/应付账款、其他应付款及合同负债/其他应付款/短期负债供款和费用', '/BS/P2000/P2300/P2310/P2315/236406', NULL, 4, '0', '1', '1', '2023-03-01 15:03:02', '1', '2023-03-01 15:03:02');
INSERT INTO `qf_subject_international_info` VALUES ('1630825955805237248', 'BS3', '236409', '短期费用运营记录保留负债', 'Liabilities for expense operational record retention short term', '€', '5', '1630825597255159808', 0, '/1630784869674127360/1630824894692462592/1630825089119424512/1630825216387190784/1630825597255159808/1630825955805237248', '/财务-资产负责类/所有者权益和负债/流动负债/应付账款、其他应付款及合同负债/其他应付款/短期费用运营记录保留负债', '/BS/P2000/P2300/P2310/P2315/236409', NULL, 5, '0', '1', '1', '2023-03-01 15:03:02', '1', '2023-03-01 15:03:02');
INSERT INTO `qf_subject_international_info` VALUES ('1630825956400828416', 'BS3', '236410', '短期责任保险负债', 'Liabilities insurance short term', '€', '5', '1630825597255159808', 0, '/1630784869674127360/1630824894692462592/1630825089119424512/1630825216387190784/1630825597255159808/1630825956400828416', '/财务-资产负责类/所有者权益和负债/流动负债/应付账款、其他应付款及合同负债/其他应付款/短期责任保险负债', '/BS/P2000/P2300/P2310/P2315/236410', NULL, 6, '0', '1', '1', '2023-03-01 15:03:02', '1', '2023-03-01 15:03:02');
INSERT INTO `qf_subject_international_info` VALUES ('1630825957050945536', 'BS3', '236411', '短期奖金负债', 'Liabilities bonus, Liabilities, short term', '€', '5', '1630825597255159808', 0, '/1630784869674127360/1630824894692462592/1630825089119424512/1630825216387190784/1630825597255159808/1630825957050945536', '/财务-资产负责类/所有者权益和负债/流动负债/应付账款、其他应付款及合同负债/其他应付款/短期奖金负债', '/BS/P2000/P2300/P2310/P2315/236411', NULL, 7, '0', '1', '1', '2023-03-01 15:03:02', '1', '2023-03-01 15:03:02');
INSERT INTO `qf_subject_international_info` VALUES ('1630825957638148096', 'BS3', '236413', '短期负债利息', 'Liabilities interests short term', '€', '5', '1630825597255159808', 0, '/1630784869674127360/1630824894692462592/1630825089119424512/1630825216387190784/1630825597255159808/1630825957638148096', '/财务-资产负责类/所有者权益和负债/流动负债/应付账款、其他应付款及合同负债/其他应付款/短期负债利息', '/BS/P2000/P2300/P2310/P2315/236413', NULL, 8, '0', '1', '1', '2023-03-01 15:03:02', '1', '2023-03-01 15:03:02');
INSERT INTO `qf_subject_international_info` VALUES ('1630825958250516480', 'BS3', '236415', '合并公司外负债', 'Liabilities ex consolidated companies', '€', '5', '1630825597255159808', 0, '/1630784869674127360/1630824894692462592/1630825089119424512/1630825216387190784/1630825597255159808/1630825958250516480', '/财务-资产负责类/所有者权益和负债/流动负债/应付账款、其他应付款及合同负债/其他应付款/合并公司外负债', '/BS/P2000/P2300/P2310/P2315/236415', NULL, 9, '0', '1', '1', '2023-03-01 15:03:02', '1', '2023-03-01 15:03:02');
INSERT INTO `qf_subject_international_info` VALUES ('1630825958850301952', 'BS3', '235404', '应付萨固密管理公司款项', 'Trade Payables SaarGummi Verwaltungs-GmbH', '€', '5', '1630825597842362368', 0, '/1630784869674127360/1630824894692462592/1630825089119424512/1630825217146359808/1630825597842362368/1630825958850301952', '/财务-资产负责类/所有者权益和负债/流动负债/关联公司应付款/附属公司间应付款/应付萨固密管理公司款项', '/BS/P2000/P2300/P2317/235400/235404', NULL, 1, '0', '1', '1', '2023-03-01 15:03:03', '1', '2023-03-01 15:03:03');
INSERT INTO `qf_subject_international_info` VALUES ('1630825959450087424', 'BS3', '235406', '应付萨固密汽车密封件公司款项', 'Trade Payables SaarGummi Automotive Sealings GmbH', '€', '5', '1630825597842362368', 0, '/1630784869674127360/1630824894692462592/1630825089119424512/1630825217146359808/1630825597842362368/1630825959450087424', '/财务-资产负责类/所有者权益和负债/流动负债/关联公司应付款/附属公司间应付款/应付萨固密汽车密封件公司款项', '/BS/P2000/P2300/P2317/235400/235406', NULL, 2, '0', '1', '1', '2023-03-01 15:03:03', '1', '2023-03-01 15:03:03');
INSERT INTO `qf_subject_international_info` VALUES ('1630825960041484288', 'BS3', '235408', '应付萨固密伊比利亚公司款项', 'Trade Payables SaarGummi Iberica S.A.', '€', '5', '1630825597842362368', 0, '/1630784869674127360/1630824894692462592/1630825089119424512/1630825217146359808/1630825597842362368/1630825960041484288', '/财务-资产负责类/所有者权益和负债/流动负债/关联公司应付款/附属公司间应付款/应付萨固密伊比利亚公司款项', '/BS/P2000/P2300/P2317/235400/235408', NULL, 3, '0', '1', '1', '2023-03-01 15:03:03', '1', '2023-03-01 15:03:03');
INSERT INTO `qf_subject_international_info` VALUES ('1630825960645464064', 'BS3', '235409', '应付萨固密斯洛伐克公司款项', 'Trade Payables SaarGummi Slovakia s.r.o.', '€', '5', '1630825597842362368', 0, '/1630784869674127360/1630824894692462592/1630825089119424512/1630825217146359808/1630825597842362368/1630825960645464064', '/财务-资产负责类/所有者权益和负债/流动负债/关联公司应付款/附属公司间应付款/应付萨固密斯洛伐克公司款项', '/BS/P2000/P2300/P2317/235400/235409', NULL, 4, '0', '1', '1', '2023-03-01 15:03:03', '1', '2023-03-01 15:03:03');
INSERT INTO `qf_subject_international_info` VALUES ('1630825961299775488', 'BS3', '235411', '应付萨固密捷克公司款项', 'Trade Payables Saar Gummi Czech s.r.o.', '€', '5', '1630825597842362368', 0, '/1630784869674127360/1630824894692462592/1630825089119424512/1630825217146359808/1630825597842362368/1630825961299775488', '/财务-资产负责类/所有者权益和负债/流动负债/关联公司应付款/附属公司间应付款/应付萨固密捷克公司款项', '/BS/P2000/P2300/P2317/235400/235411', NULL, 5, '0', '1', '1', '2023-03-01 15:03:03', '1', '2023-03-01 15:03:03');
INSERT INTO `qf_subject_international_info` VALUES ('1630825961853423616', 'BS3', '235412', '应付CQLT萨固密技术公司款项', 'Trade Payables CQLT SaarGummi Technologies S.a r.l. Luxembourg', '€', '5', '1630825597842362368', 0, '/1630784869674127360/1630824894692462592/1630825089119424512/1630825217146359808/1630825597842362368/1630825961853423616', '/财务-资产负责类/所有者权益和负债/流动负债/关联公司应付款/附属公司间应付款/应付CQLT萨固密技术公司款项', '/BS/P2000/P2300/P2317/235400/235412', NULL, 6, '0', '1', '1', '2023-03-01 15:03:04', '1', '2023-03-01 15:03:04');
INSERT INTO `qf_subject_international_info` VALUES ('1630825963359178752', 'BS3', '235413', '应付萨固密巴西公司款项', 'Trade Payables SaarGummi do Brazil Ltda.', '€', '5', '1630825597842362368', 0, '/1630784869674127360/1630824894692462592/1630825089119424512/1630825217146359808/1630825597842362368/1630825963359178752', '/财务-资产负责类/所有者权益和负债/流动负债/关联公司应付款/附属公司间应付款/应付萨固密巴西公司款项', '/BS/P2000/P2300/P2317/235400/235413', NULL, 7, '0', '1', '1', '2023-03-01 15:03:04', '1', '2023-03-01 15:03:04');
INSERT INTO `qf_subject_international_info` VALUES ('1630825963937992704', 'BS3', '235415', '应付萨固密田纳西公司款项', 'Trade Payables SaarGummi Tennessee Inc.', '€', '5', '1630825597842362368', 0, '/1630784869674127360/1630824894692462592/1630825089119424512/1630825217146359808/1630825597842362368/1630825963937992704', '/财务-资产负责类/所有者权益和负债/流动负债/关联公司应付款/附属公司间应付款/应付萨固密田纳西公司款项', '/BS/P2000/P2300/P2317/235400/235415', NULL, 8, '0', '1', '1', '2023-03-01 15:03:04', '1', '2023-03-01 15:03:04');
INSERT INTO `qf_subject_international_info` VALUES ('1630825964684578816', 'BS3', '235419', '应付萨固密俄罗斯公司款项', 'Trade Payables SaarGummi Russland', '€', '5', '1630825597842362368', 0, '/1630784869674127360/1630824894692462592/1630825089119424512/1630825217146359808/1630825597842362368/1630825964684578816', '/财务-资产负责类/所有者权益和负债/流动负债/关联公司应付款/附属公司间应付款/应付萨固密俄罗斯公司款项', '/BS/P2000/P2300/P2317/235400/235419', NULL, 9, '0', '1', '1', '2023-03-01 15:03:04', '1', '2023-03-01 15:03:04');
INSERT INTO `qf_subject_international_info` VALUES ('1630825965280169984', 'BS3', '235420', '应付萨固密德国控股公司款项', 'Trade Payables SaarGummi Deutschland Holding GmbH', '€', '5', '1630825597842362368', 0, '/1630784869674127360/1630824894692462592/1630825089119424512/1630825217146359808/1630825597842362368/1630825965280169984', '/财务-资产负责类/所有者权益和负债/流动负债/关联公司应付款/附属公司间应付款/应付萨固密德国控股公司款项', '/BS/P2000/P2300/P2317/235400/235420', NULL, 10, '0', '1', '1', '2023-03-01 15:03:04', '1', '2023-03-01 15:03:04');
INSERT INTO `qf_subject_international_info` VALUES ('1630825965842206720', 'BS3', '235421', '应付CQLT萨固密德国公司款项', 'Trade Payables CQLT SaarGummi Deutschland GmbH', '€', '5', '1630825597842362368', 0, '/1630784869674127360/1630824894692462592/1630825089119424512/1630825217146359808/1630825597842362368/1630825965842206720', '/财务-资产负责类/所有者权益和负债/流动负债/关联公司应付款/附属公司间应付款/应付CQLT萨固密德国公司款项', '/BS/P2000/P2300/P2317/235400/235421', NULL, 11, '0', '1', '1', '2023-03-01 15:03:04', '1', '2023-03-01 15:03:04');
INSERT INTO `qf_subject_international_info` VALUES ('1630825966437797888', 'BS3', '235426', '应付萨固密贝特林根公司款项', 'Trade Payables SaarGummi Beteiligungs GmbH', '€', '5', '1630825597842362368', 0, '/1630784869674127360/1630824894692462592/1630825089119424512/1630825217146359808/1630825597842362368/1630825966437797888', '/财务-资产负责类/所有者权益和负债/流动负债/关联公司应付款/附属公司间应付款/应付萨固密贝特林根公司款项', '/BS/P2000/P2300/P2317/235400/235426', NULL, 12, '0', '1', '1', '2023-03-01 15:03:04', '1', '2023-03-01 15:03:04');
INSERT INTO `qf_subject_international_info` VALUES ('1630825967025000448', 'BS3', '235432', '应付兴渝投资公司款项', 'Trade PayablesCQLT International Investment Company Ltd, China', '€', '5', '1630825597842362368', 0, '/1630784869674127360/1630824894692462592/1630825089119424512/1630825217146359808/1630825597842362368/1630825967025000448', '/财务-资产负责类/所有者权益和负债/流动负债/关联公司应付款/附属公司间应付款/应付兴渝投资公司款项', '/BS/P2000/P2300/P2317/235400/235432', NULL, 13, '0', '1', '1', '2023-03-01 15:03:05', '1', '2023-03-01 15:03:05');
INSERT INTO `qf_subject_international_info` VALUES ('1630825967628980224', 'BS3', '235433', '应付兴渝国际控股（香港）有限公司款项', 'Trade PayablesCQLT International Investment Holding Ltd, HK', '€', '5', '1630825597842362368', 0, '/1630784869674127360/1630824894692462592/1630825089119424512/1630825217146359808/1630825597842362368/1630825967628980224', '/财务-资产负责类/所有者权益和负债/流动负债/关联公司应付款/附属公司间应付款/应付兴渝国际控股（香港）有限公司款项', '/BS/P2000/P2300/P2317/235400/235433', NULL, 14, '0', '1', '1', '2023-03-01 15:03:05', '1', '2023-03-01 15:03:05');
INSERT INTO `qf_subject_international_info` VALUES ('1630825968237154304', 'BS3', '235439', '应付萨固密（中国）投资有限公司款项', 'Trade Payables Saargummi China Investment Co. Ltd', '€', '5', '1630825597842362368', 0, '/1630784869674127360/1630824894692462592/1630825089119424512/1630825217146359808/1630825597842362368/1630825968237154304', '/财务-资产负责类/所有者权益和负债/流动负债/关联公司应付款/附属公司间应付款/应付萨固密（中国）投资有限公司款项', '/BS/P2000/P2300/P2317/235400/235439', NULL, 15, '0', '1', '1', '2023-03-01 15:03:05', '1', '2023-03-01 15:03:05');
INSERT INTO `qf_subject_international_info` VALUES ('1630825968845328384', 'BS3', '235441', '应付萨固密渝锦（重庆）橡塑制品有限公司款项', 'trade payables SG Yujin  Rubber & Plastic Products Co. Ltd', '€', '5', '1630825597842362368', 0, '/1630784869674127360/1630824894692462592/1630825089119424512/1630825217146359808/1630825597842362368/1630825968845328384', '/财务-资产负责类/所有者权益和负债/流动负债/关联公司应付款/附属公司间应付款/应付萨固密渝锦（重庆）橡塑制品有限公司款项', '/BS/P2000/P2300/P2317/235400/235441', NULL, 16, '0', '1', '1', '2023-03-01 15:03:05', '1', '2023-03-01 15:03:05');
INSERT INTO `qf_subject_international_info` VALUES ('1630825969436725248', 'BS3', '235442', '应付萨固密（重庆）密封系统有限公司款项', 'trade payables  SaarGummi( Chongqing) Sealing System Co.,ltd', '€', '5', '1630825597842362368', 0, '/1630784869674127360/1630824894692462592/1630825089119424512/1630825217146359808/1630825597842362368/1630825969436725248', '/财务-资产负责类/所有者权益和负债/流动负债/关联公司应付款/附属公司间应付款/应付萨固密（重庆）密封系统有限公司款项', '/BS/P2000/P2300/P2317/235400/235442', NULL, 17, '0', '1', '1', '2023-03-01 15:03:05', '1', '2023-03-01 15:03:05');
INSERT INTO `qf_subject_international_info` VALUES ('1630825970082648064', 'BS3', '235444', '应付萨固密（重庆）密封系统有限公司款项', 'trade payables  SaarGummi (Yingkou) Sealing Systems Co., Ltd.', '€', '5', '1630825597842362368', 0, '/1630784869674127360/1630824894692462592/1630825089119424512/1630825217146359808/1630825597842362368/1630825970082648064', '/财务-资产负责类/所有者权益和负债/流动负债/关联公司应付款/附属公司间应付款/应付萨固密（重庆）密封系统有限公司款项', '/BS/P2000/P2300/P2317/235400/235444', NULL, 18, '0', '1', '1', '2023-03-01 15:03:05', '1', '2023-03-01 15:03:05');
INSERT INTO `qf_subject_international_info` VALUES ('1630825970703405056', 'BS3', '235445', '应付萨固密国际系统有限公司款项', 'trade payables  SaarGummi International Systems GmbH', '€', '5', '1630825597842362368', 0, '/1630784869674127360/1630824894692462592/1630825089119424512/1630825217146359808/1630825597842362368/1630825970703405056', '/财务-资产负责类/所有者权益和负债/流动负债/关联公司应付款/附属公司间应付款/应付萨固密国际系统有限公司款项', '/BS/P2000/P2300/P2317/235400/235445', NULL, 19, '0', '1', '1', '2023-03-01 15:03:05', '1', '2023-03-01 15:03:05');
INSERT INTO `qf_subject_international_info` VALUES ('1630825971278024704', 'BS3', '235446', '应付萨固密（上海）橡塑技术有限公司款项', 'trade payables  SaarGummi (Shanghai) Rubber Technologies Co. Ltd.', '€', '5', '1630825597842362368', 0, '/1630784869674127360/1630824894692462592/1630825089119424512/1630825217146359808/1630825597842362368/1630825971278024704', '/财务-资产负责类/所有者权益和负债/流动负债/关联公司应付款/附属公司间应付款/应付萨固密（上海）橡塑技术有限公司款项', '/BS/P2000/P2300/P2317/235400/235446', NULL, 20, '0', '1', '1', '2023-03-01 15:03:06', '1', '2023-03-01 15:03:06');
INSERT INTO `qf_subject_international_info` VALUES ('1630825971877810176', 'BS3', '235447', '应付萨固密墨西哥公司款项', 'trade payables SaarGummi Mexico S.A. de C.V.', '€', '5', '1630825597842362368', 0, '/1630784869674127360/1630824894692462592/1630825089119424512/1630825217146359808/1630825597842362368/1630825971877810176', '/财务-资产负责类/所有者权益和负债/流动负债/关联公司应付款/附属公司间应付款/应付萨固密墨西哥公司款项', '/BS/P2000/P2300/P2317/235400/235447', NULL, 21, '0', '1', '1', '2023-03-01 15:03:06', '1', '2023-03-01 15:03:06');
INSERT INTO `qf_subject_international_info` VALUES ('1630825972460818432', 'BS3', '235448', '应付萨固密NEO公司款项', 'trade payables  SaarGummi Neo GmbH', '€', '5', '1630825597842362368', 0, '/1630784869674127360/1630824894692462592/1630825089119424512/1630825217146359808/1630825597842362368/1630825972460818432', '/财务-资产负责类/所有者权益和负债/流动负债/关联公司应付款/附属公司间应付款/应付萨固密NEO公司款项', '/BS/P2000/P2300/P2317/235400/235448', NULL, 22, '0', '1', '1', '2023-03-01 15:03:06', '1', '2023-03-01 15:03:06');
INSERT INTO `qf_subject_international_info` VALUES ('1630825973043826688', 'BS3', '235449', '应付萨固密法国公司款项', 'trade payables  SaarGummi France S.A..', '€', '5', '1630825597842362368', 0, '/1630784869674127360/1630824894692462592/1630825089119424512/1630825217146359808/1630825597842362368/1630825973043826688', '/财务-资产负责类/所有者权益和负债/流动负债/关联公司应付款/附属公司间应付款/应付萨固密法国公司款项', '/BS/P2000/P2300/P2317/235400/235449', NULL, 23, '0', '1', '1', '2023-03-01 15:03:06', '1', '2023-03-01 15:03:06');
INSERT INTO `qf_subject_international_info` VALUES ('1630825973647806464', 'BS3', '235451', '应付萨固密土耳其公司款项', 'trade payables SAARGUMMİ TURKEY KAUÇUK VE PLASTİK LİMİTED ŞİRKETİ', '€', '5', '1630825597842362368', 0, '/1630784869674127360/1630824894692462592/1630825089119424512/1630825217146359808/1630825597842362368/1630825973647806464', '/财务-资产负责类/所有者权益和负债/流动负债/关联公司应付款/附属公司间应付款/应付萨固密土耳其公司款项', '/BS/P2000/P2300/P2317/235400/235451', NULL, 24, '0', '1', '1', '2023-03-01 15:03:06', '1', '2023-03-01 15:03:06');
INSERT INTO `qf_subject_international_info` VALUES ('1630825974285340672', 'BS3', '235498', '重庆兴渝投资有限责任公司短期借款', 'Loan CQLT International Investment Company Ltd, short term', '€', '5', '1630825597842362368', 0, '/1630784869674127360/1630824894692462592/1630825089119424512/1630825217146359808/1630825597842362368/1630825974285340672', '/财务-资产负责类/所有者权益和负债/流动负债/关联公司应付款/附属公司间应付款/重庆兴渝投资有限责任公司短期借款', '/BS/P2000/P2300/P2317/235400/235498', NULL, 25, '0', '1', '1', '2023-03-01 15:03:06', '1', '2023-03-01 15:03:06');
INSERT INTO `qf_subject_international_info` VALUES ('1630825974868348928', 'BS3', '231101', '银行流动负债', 'bank current liabilities', '€', '5', '1630825598429564928', 0, '/1630784869674127360/1630824894692462592/1630825089119424512/1630825217716785152/1630825598429564928/1630825974868348928', '/财务-资产负责类/所有者权益和负债/流动负债/流动带息贷款和借款/流动银行及类似贷款/银行流动负债', '/BS/P2000/P2300/P2320/231100/231101', NULL, 1, '0', '1', '1', '2023-03-01 15:03:06', '1', '2023-03-01 15:03:06');
INSERT INTO `qf_subject_international_info` VALUES ('1630825975489105920', 'BS3', '231102', '银行短期贷款（<1年）', 'bank loan short term (< 1 year)', '€', '5', '1630825598429564928', 0, '/1630784869674127360/1630824894692462592/1630825089119424512/1630825217716785152/1630825598429564928/1630825975489105920', '/财务-资产负责类/所有者权益和负债/流动负债/流动带息贷款和借款/流动银行及类似贷款/银行短期贷款（<1年）', '/BS/P2000/P2300/P2320/231100/231102', NULL, 2, '0', '1', '1', '2023-03-01 15:03:07', '1', '2023-03-01 15:03:07');
INSERT INTO `qf_subject_international_info` VALUES ('1630825976088891392', 'BS3', '231103', '现金循环短期银行贷款', 'bank loan short term Revolving Cash Facility', '€', '5', '1630825598429564928', 0, '/1630784869674127360/1630824894692462592/1630825089119424512/1630825217716785152/1630825598429564928/1630825976088891392', '/财务-资产负责类/所有者权益和负债/流动负债/流动带息贷款和借款/流动银行及类似贷款/现金循环短期银行贷款', '/BS/P2000/P2300/P2320/231100/231103', NULL, 3, '0', '1', '1', '2023-03-01 15:03:07', '1', '2023-03-01 15:03:07');
INSERT INTO `qf_subject_international_info` VALUES ('1630825976667705344', 'BS3', '231104', '在途现金', 'Cash in transit', '€', '5', '1630825598429564928', 0, '/1630784869674127360/1630824894692462592/1630825089119424512/1630825217716785152/1630825598429564928/1630825976667705344', '/财务-资产负责类/所有者权益和负债/流动负债/流动带息贷款和借款/流动银行及类似贷款/在途现金', '/BS/P2000/P2300/P2320/231100/231104', NULL, 4, '0', '1', '1', '2023-03-01 15:03:07', '1', '2023-03-01 15:03:07');
INSERT INTO `qf_subject_international_info` VALUES ('1630825977259102208', 'BS3', '231105', '租赁公司负债（<1年）', 'liabilities lease companies (< 1 year)', '€', '5', '1630825598429564928', 0, '/1630784869674127360/1630824894692462592/1630825089119424512/1630825217716785152/1630825598429564928/1630825977259102208', '/财务-资产负责类/所有者权益和负债/流动负债/流动带息贷款和借款/流动银行及类似贷款/租赁公司负债（<1年）', '/BS/P2000/P2300/P2320/231100/231105', NULL, 5, '0', '1', '1', '2023-03-01 15:03:07', '1', '2023-03-01 15:03:07');
INSERT INTO `qf_subject_international_info` VALUES ('1630825977951162368', 'BS3', '231106', '应付票据', 'bills accepted', '€', '5', '1630825598429564928', 0, '/1630784869674127360/1630824894692462592/1630825089119424512/1630825217716785152/1630825598429564928/1630825977951162368', '/财务-资产负责类/所有者权益和负债/流动负债/流动带息贷款和借款/流动银行及类似贷款/应付票据', '/BS/P2000/P2300/P2320/231100/231106', NULL, 6, '0', '1', '1', '2023-03-01 15:03:07', '1', '2023-03-01 15:03:07');
INSERT INTO `qf_subject_international_info` VALUES ('1630825978571919360', 'BS3', '231107', '其他贷款和借款（<1年）', 'other loans and borrowings (< 1 year)', '€', '5', '1630825598429564928', 0, '/1630784869674127360/1630824894692462592/1630825089119424512/1630825217716785152/1630825598429564928/1630825978571919360', '/财务-资产负责类/所有者权益和负债/流动负债/流动带息贷款和借款/流动银行及类似贷款/其他贷款和借款（<1年）', '/BS/P2000/P2300/P2320/231100/231107', NULL, 7, '0', '1', '1', '2023-03-01 15:03:07', '1', '2023-03-01 15:03:07');
INSERT INTO `qf_subject_international_info` VALUES ('1630825979159121920', 'BS3', '231108', '负债负债<1年', 'liabilities right of use < 1 year', '€', '5', '1630825598429564928', 0, '/1630784869674127360/1630824894692462592/1630825089119424512/1630825217716785152/1630825598429564928/1630825979159121920', '/财务-资产负责类/所有者权益和负债/流动负债/流动带息贷款和借款/流动银行及类似贷款/负债负债<1年', '/BS/P2000/P2300/P2320/231100/231108', NULL, 8, '0', '1', '1', '2023-03-01 15:03:07', '1', '2023-03-01 15:03:07');
INSERT INTO `qf_subject_international_info` VALUES ('1630825979712770048', 'BS3', '231109', '非流动银行贷款（一年内还款）', 'non-current bank loan (repayment within one year)', '€', '5', '1630825598429564928', 0, '/1630784869674127360/1630824894692462592/1630825089119424512/1630825217716785152/1630825598429564928/1630825979712770048', '/财务-资产负责类/所有者权益和负债/流动负债/流动带息贷款和借款/流动银行及类似贷款/非流动银行贷款（一年内还款）', '/BS/P2000/P2300/P2320/231100/231109', NULL, 9, '0', '1', '1', '2023-03-01 15:03:08', '1', '2023-03-01 15:03:08');
INSERT INTO `qf_subject_international_info` VALUES ('1630825980274806784', 'BS3', '231110', '外币租赁负债<1年', 'liabilities right of use < 1 year foreign currency', '€', '5', '1630825598429564928', 0, '/1630784869674127360/1630824894692462592/1630825089119424512/1630825217716785152/1630825598429564928/1630825980274806784', '/财务-资产负责类/所有者权益和负债/流动负债/流动带息贷款和借款/流动银行及类似贷款/外币租赁负债<1年', '/BS/P2000/P2300/P2320/231100/231110', NULL, 10, '0', '1', '1', '2023-03-01 15:03:08', '1', '2023-03-01 15:03:08');
INSERT INTO `qf_subject_international_info` VALUES ('1630825981809922048', 'BS3', '233208', '短期股东借款（CQLT）', 'Liabilities shareholder (CQLT) short term', '€', '5', '1630825598999990272', 0, '/1630784869674127360/1630824894692462592/1630825089119424512/1630825217716785152/1630825598999990272/1630825981809922048', '/财务-资产负责类/所有者权益和负债/流动负债/流动带息贷款和借款/一年内应付股东借款/短期股东借款（CQLT）', '/BS/P2000/P2300/P2320/231220/233208', NULL, 1, '0', '1', '1', '2023-03-01 15:03:08', '1', '2023-03-01 15:03:08');
INSERT INTO `qf_subject_international_info` VALUES ('1630825982451650560', 'BS3', '236416', '货币衍生品', 'currency derivatives', '€', '5', '1630825600333778944', 0, '/1630784869674127360/1630824894692462592/1630825089119424512/1630825218303987712/1630825600333778944/1630825982451650560', '/财务-资产负责类/所有者权益和负债/流动负债/以公允价值计量的金融工具/以公允价值计量的金融工具/货币衍生品', '/BS/P2000/P2300/P2330/P2331/236416', NULL, 1, '0', '1', '1', '2023-03-01 15:03:08', '1', '2023-03-01 15:03:08');
INSERT INTO `qf_subject_international_info` VALUES ('1630825983030464512', 'BS3', '236417', '利率衍生品', 'interest derivates', '€', '5', '1630825600333778944', 0, '/1630784869674127360/1630824894692462592/1630825089119424512/1630825218303987712/1630825600333778944/1630825983030464512', '/财务-资产负责类/所有者权益和负债/流动负债/以公允价值计量的金融工具/以公允价值计量的金融工具/利率衍生品', '/BS/P2000/P2300/P2330/P2331/236417', NULL, 2, '0', '1', '1', '2023-03-01 15:03:08', '1', '2023-03-01 15:03:08');
INSERT INTO `qf_subject_international_info` VALUES ('1630825983667998720', 'BS3', '236418', '公司间货币衍生品', 'IC currency derivatives', '€', '5', '1630825600333778944', 0, '/1630784869674127360/1630824894692462592/1630825089119424512/1630825218303987712/1630825600333778944/1630825983667998720', '/财务-资产负责类/所有者权益和负债/流动负债/以公允价值计量的金融工具/以公允价值计量的金融工具/公司间货币衍生品', '/BS/P2000/P2300/P2330/P2331/236418', NULL, 3, '0', '1', '1', '2023-03-01 15:03:08', '1', '2023-03-01 15:03:09');
INSERT INTO `qf_subject_international_info` VALUES ('1630825984259395584', 'BS3', '236419', '公司间货币衍生品套期会计', 'IC currency derivatives of Hedge Accounting', '€', '5', '1630825600333778944', 0, '/1630784869674127360/1630824894692462592/1630825089119424512/1630825218303987712/1630825600333778944/1630825984259395584', '/财务-资产负责类/所有者权益和负债/流动负债/以公允价值计量的金融工具/以公允价值计量的金融工具/公司间货币衍生品套期会计', '/BS/P2000/P2300/P2330/P2331/236419', NULL, 4, '0', '1', '1', '2023-03-01 15:03:09', '1', '2023-03-01 15:03:09');
INSERT INTO `qf_subject_international_info` VALUES ('1630825984834015232', 'BS3', '236420', '货币衍生品套期会计', 'currency derivatives of Hedge accounting', '€', '5', '1630825600333778944', 0, '/1630784869674127360/1630824894692462592/1630825089119424512/1630825218303987712/1630825600333778944/1630825984834015232', '/财务-资产负责类/所有者权益和负债/流动负债/以公允价值计量的金融工具/以公允价值计量的金融工具/货币衍生品套期会计', '/BS/P2000/P2300/P2330/P2331/236420', NULL, 5, '0', '1', '1', '2023-03-01 15:03:09', '1', '2023-03-01 15:03:09');
INSERT INTO `qf_subject_international_info` VALUES ('1630825985412829184', 'BS3', '222104', '流动保证预提准备金', 'Warranty provisions current', '€', '5', '1630825600954535936', 0, '/1630784869674127360/1630824894692462592/1630825089119424512/1630825218941521920/1630825600954535936/1630825985412829184', '/财务-资产负责类/所有者权益和负债/流动负债/其他流动预计负债/其他流动预计负债/流动保证预提准备金', '/BS/P2000/P2300/P2350/222100/222104', NULL, 1, '0', '1', '1', '2023-03-01 15:03:09', '1', '2023-03-01 15:03:09');
INSERT INTO `qf_subject_international_info` VALUES ('1630825986008420352', 'BS3', '222105', '短期预期损失准备金', 'Provision for anticipated losses short term', '€', '5', '1630825600954535936', 0, '/1630784869674127360/1630824894692462592/1630825089119424512/1630825218941521920/1630825600954535936/1630825986008420352', '/财务-资产负责类/所有者权益和负债/流动负债/其他流动预计负债/其他流动预计负债/短期预期损失准备金', '/BS/P2000/P2300/P2350/222100/222105', NULL, 2, '0', '1', '1', '2023-03-01 15:03:09', '1', '2023-03-01 15:03:09');
INSERT INTO `qf_subject_international_info` VALUES ('1630825986658537472', 'BS3', '222106', '建造合同预计损失准备金（PoC/ZPMM）-短期', 'Provision for anticipated losses construc. contr.(PoC/ZPMM) short term', '€', '5', '1630825600954535936', 0, '/1630784869674127360/1630824894692462592/1630825089119424512/1630825218941521920/1630825600954535936/1630825986658537472', '/财务-资产负责类/所有者权益和负债/流动负债/其他流动预计负债/其他流动预计负债/建造合同预计损失准备金（PoC/ZPMM）-短期', '/BS/P2000/P2300/P2350/222100/222106', NULL, 3, '0', '1', '1', '2023-03-01 15:03:09', '1', '2023-03-01 15:03:09');
INSERT INTO `qf_subject_international_info` VALUES ('1630825987275100160', 'BS3', '234201', '短期当地交易税负债', 'Liabilities for local trade tax returns short term', '€', '5', '1630825601550127104', 0, '/1630784869674127360/1630824894692462592/1630825089119424512/1630825219503558656/1630825601550127104/1630825987275100160', '/财务-资产负责类/所有者权益和负债/流动负债/所得税负债/短期所得税负债（一年内）/短期当地交易税负债', '/BS/P2000/P2300/P2340/234200/234201', NULL, 1, '0', '1', '1', '2023-03-01 15:03:09', '1', '2023-03-01 15:03:09');
INSERT INTO `qf_subject_international_info` VALUES ('1630825987908440064', 'BS3', '234202', '短期所得税负债', 'Liabilities for income tax returns short term', '€', '5', '1630825601550127104', 0, '/1630784869674127360/1630824894692462592/1630825089119424512/1630825219503558656/1630825601550127104/1630825987908440064', '/财务-资产负责类/所有者权益和负债/流动负债/所得税负债/短期所得税负债（一年内）/短期所得税负债', '/BS/P2000/P2300/P2340/234200/234202', NULL, 2, '0', '1', '1', '2023-03-01 15:03:10', '1', '2023-03-01 15:03:10');
INSERT INTO `qf_subject_international_info` VALUES ('1630826760369213440', 'BS1', '122401', '应收股利', 'receivables dividends', '€', '6', '1630825834073952256', 0, '/1630784869674127360/1630824894071705600/1630825087282319360/1630825204102074368/1630825572169027584/1630825834073952256/1630826760369213440', '/财务-资产负责类/资产/流动资产/应收账款和其他资产/其他资产/其他资产/应收股利', '/BS/A1000/A1200/A1220/A1221/A12210/122401', NULL, 1, '0', '1', '1', '2023-03-01 15:06:14', '1', '2023-03-01 15:06:14');
INSERT INTO `qf_subject_international_info` VALUES ('1630826761107410944', 'BS1', '122504', '就业中心应收账款', 'receivables employment centre', '€', '6', '1630825834073952256', 0, '/1630784869674127360/1630824894071705600/1630825087282319360/1630825204102074368/1630825572169027584/1630825834073952256/1630826761107410944', '/财务-资产负责类/资产/流动资产/应收账款和其他资产/其他资产/其他资产/就业中心应收账款', '/BS/A1000/A1200/A1220/A1221/A12210/122504', NULL, 2, '0', '1', '1', '2023-03-01 15:06:14', '1', '2023-03-01 15:06:14');
INSERT INTO `qf_subject_international_info` VALUES ('1630826761703002112', 'BS1', '122505', '预付工资的应收账款', 'receivables wages payments in advance', '€', '6', '1630825834073952256', 0, '/1630784869674127360/1630824894071705600/1630825087282319360/1630825204102074368/1630825572169027584/1630825834073952256/1630826761703002112', '/财务-资产负责类/资产/流动资产/应收账款和其他资产/其他资产/其他资产/预付工资的应收账款', '/BS/A1000/A1200/A1220/A1221/A12210/122505', NULL, 3, '0', '1', '1', '2023-03-01 15:06:14', '1', '2023-03-01 15:06:14');
INSERT INTO `qf_subject_international_info` VALUES ('1630826762306981888', 'BS1', '122506', '预付工资的应收账款', 'receivables salaries payments in advance', '€', '6', '1630825834073952256', 0, '/1630784869674127360/1630824894071705600/1630825087282319360/1630825204102074368/1630825572169027584/1630825834073952256/1630826762306981888', '/财务-资产负责类/资产/流动资产/应收账款和其他资产/其他资产/其他资产/预付工资的应收账款', '/BS/A1000/A1200/A1220/A1221/A12210/122506', NULL, 4, '0', '1', '1', '2023-03-01 15:06:14', '1', '2023-03-01 15:06:14');
INSERT INTO `qf_subject_international_info` VALUES ('1630826762919350272', 'BS1', '122507', '预付旅行费用的应付账款', 'receivables travel expenses payments in advance', '€', '6', '1630825834073952256', 0, '/1630784869674127360/1630824894071705600/1630825087282319360/1630825204102074368/1630825572169027584/1630825834073952256/1630826762919350272', '/财务-资产负责类/资产/流动资产/应收账款和其他资产/其他资产/其他资产/预付旅行费用的应付账款', '/BS/A1000/A1200/A1220/A1221/A12210/122507', NULL, 5, '0', '1', '1', '2023-03-01 15:06:14', '1', '2023-03-01 15:06:14');
INSERT INTO `qf_subject_international_info` VALUES ('1630826763506552832', 'BS1', '122508', '供应商应付账款', 'receivables suppliers', '€', '6', '1630825834073952256', 0, '/1630784869674127360/1630824894071705600/1630825087282319360/1630825204102074368/1630825572169027584/1630825834073952256/1630826763506552832', '/财务-资产负责类/资产/流动资产/应收账款和其他资产/其他资产/其他资产/供应商应付账款', '/BS/A1000/A1200/A1220/A1221/A12210/122508', NULL, 6, '0', '1', '1', '2023-03-01 15:06:14', '1', '2023-03-01 15:06:14');
INSERT INTO `qf_subject_international_info` VALUES ('1630826764068589568', 'BS1', '122509', '国外应收账款增值税', 'receivables VAT foreign countries', '€', '6', '1630825834073952256', 0, '/1630784869674127360/1630824894071705600/1630825087282319360/1630825204102074368/1630825572169027584/1630825834073952256/1630826764068589568', '/财务-资产负责类/资产/流动资产/应收账款和其他资产/其他资产/其他资产/国外应收账款增值税', '/BS/A1000/A1200/A1220/A1221/A12210/122509', NULL, 7, '0', '1', '1', '2023-03-01 15:06:15', '1', '2023-03-01 15:06:15');
INSERT INTO `qf_subject_international_info` VALUES ('1630826764668375040', 'BS1', '122510', '银行机构应收账款', 'receivables bank institutes', '€', '6', '1630825834073952256', 0, '/1630784869674127360/1630824894071705600/1630825087282319360/1630825204102074368/1630825572169027584/1630825834073952256/1630826764668375040', '/财务-资产负责类/资产/流动资产/应收账款和其他资产/其他资产/其他资产/银行机构应收账款', '/BS/A1000/A1200/A1220/A1221/A12210/122510', NULL, 8, '0', '1', '1', '2023-03-01 15:06:15', '1', '2023-03-01 15:06:15');
INSERT INTO `qf_subject_international_info` VALUES ('1630826765276549120', 'BS1', '122514', '杂项其他<1年的应收款', 'sundry other receivables < 1 year', '€', '6', '1630825834073952256', 0, '/1630784869674127360/1630824894071705600/1630825087282319360/1630825204102074368/1630825572169027584/1630825834073952256/1630826765276549120', '/财务-资产负责类/资产/流动资产/应收账款和其他资产/其他资产/其他资产/杂项其他<1年的应收款', '/BS/A1000/A1200/A1220/A1221/A12210/122514', NULL, 9, '0', '1', '1', '2023-03-01 15:06:15', '1', '2023-03-01 15:06:15');
INSERT INTO `qf_subject_international_info` VALUES ('1630826766744555520', 'BS1', '122516', '应收账款保理（不可用金额-冻结账户）', 'receivables Factoring (not available amount - blocked account)', '€', '6', '1630825834073952256', 0, '/1630784869674127360/1630824894071705600/1630825087282319360/1630825204102074368/1630825572169027584/1630825834073952256/1630826766744555520', '/财务-资产负责类/资产/流动资产/应收账款和其他资产/其他资产/其他资产/应收账款保理（不可用金额-冻结账户）', '/BS/A1000/A1200/A1220/A1221/A12210/122516', NULL, 10, '0', '1', '1', '2023-03-01 15:06:15', '1', '2023-03-01 15:06:15');
INSERT INTO `qf_subject_international_info` VALUES ('1630826767314980864', 'BS1', '122517', '合并公司的应收账款', 'receivables ex consolidated companies', '€', '6', '1630825834073952256', 0, '/1630784869674127360/1630824894071705600/1630825087282319360/1630825204102074368/1630825572169027584/1630825834073952256/1630826767314980864', '/财务-资产负责类/资产/流动资产/应收账款和其他资产/其他资产/其他资产/合并公司的应收账款', '/BS/A1000/A1200/A1220/A1221/A12210/122517', NULL, 11, '0', '1', '1', '2023-03-01 15:06:15', '1', '2023-03-01 15:06:15');
INSERT INTO `qf_subject_international_info` VALUES ('1630826767897989120', 'BS1', '122520', '合并公司前可疑帐款准备金', 'provision for specific doubtful accounts ex consolidated companies', '€', '6', '1630825834073952256', 0, '/1630784869674127360/1630824894071705600/1630825087282319360/1630825204102074368/1630825572169027584/1630825834073952256/1630826767897989120', '/财务-资产负责类/资产/流动资产/应收账款和其他资产/其他资产/其他资产/合并公司前可疑帐款准备金', '/BS/A1000/A1200/A1220/A1221/A12210/122520', NULL, 12, '0', '1', '1', '2023-03-01 15:06:15', '1', '2023-03-01 15:06:15');
INSERT INTO `qf_subject_international_info` VALUES ('1630826768472608768', 'BS1', '122528', '其他<1年的杂项存款', 'sundry other deposits < 1 year', '€', '6', '1630825834073952256', 0, '/1630784869674127360/1630824894071705600/1630825087282319360/1630825204102074368/1630825572169027584/1630825834073952256/1630826768472608768', '/财务-资产负责类/资产/流动资产/应收账款和其他资产/其他资产/其他资产/其他<1年的杂项存款', '/BS/A1000/A1200/A1220/A1221/A12210/122528', NULL, 13, '0', '1', '1', '2023-03-01 15:06:16', '1', '2023-03-01 15:06:16');
INSERT INTO `qf_subject_international_info` VALUES ('1630826769080782848', 'BS1', '122503', '其他退税应收账款', 'Receivables for other tax refunds', '€', '6', '1630825834669543424', 0, '/1630784869674127360/1630824894071705600/1630825087282319360/1630825204102074368/1630825572169027584/1630825834669543424/1630826769080782848', '/财务-资产负责类/资产/流动资产/应收账款和其他资产/其他资产/其他税务资产/其他退税应收账款', '/BS/A1000/A1200/A1220/A1221/A12211/122503', NULL, 1, '0', '1', '1', '2023-03-01 15:06:16', '1', '2023-03-01 15:06:16');
INSERT INTO `qf_subject_international_info` VALUES ('1630826769659596800', 'BS1', '122524', '增值税应收账款', 'VAT receivables', '€', '6', '1630825834669543424', 0, '/1630784869674127360/1630824894071705600/1630825087282319360/1630825204102074368/1630825572169027584/1630825834669543424/1630826769659596800', '/财务-资产负责类/资产/流动资产/应收账款和其他资产/其他资产/其他税务资产/增值税应收账款', '/BS/A1000/A1200/A1220/A1221/A12211/122524', NULL, 2, '0', '1', '1', '2023-03-01 15:06:16', '1', '2023-03-01 15:06:16');
INSERT INTO `qf_subject_international_info` VALUES ('1630827002229559296', 'CF1', 'CF1000', '经营活动产生的现金流量净额', 'Net cash flows from operating activities', '€', '1', '1630785386760507392', 16, '/1630785386760507392/1630827002229559296', '/财务-现金流量类/经营活动产生的现金流量净额', '/CF/CF1000', NULL, 1, '0', '1', '1', '2023-03-01 15:07:11', '1', '2023-03-01 15:07:45');
INSERT INTO `qf_subject_international_info` VALUES ('1630827002812567552', 'CF1', 'CF2000', '投资活动产生的现金流量净额', 'Net cash flows from investing activities', '€', '1', '1630785386760507392', 8, '/1630785386760507392/1630827002812567552', '/财务-现金流量类/投资活动产生的现金流量净额', '/CF/CF2000', NULL, 2, '0', '1', '1', '2023-03-01 15:07:11', '1', '2023-03-01 15:07:46');
INSERT INTO `qf_subject_international_info` VALUES ('1630827003403964416', 'CF1', 'CF3000', '筹资活动产生的现金流量净额', 'Net cash flows from financing activities', '€', '1', '1630785386760507392', 7, '/1630785386760507392/1630827003403964416', '/财务-现金流量类/筹资活动产生的现金流量净额', '/CF/CF3000', NULL, 3, '0', '1', '1', '2023-03-01 15:07:12', '1', '2023-03-01 15:07:47');
INSERT INTO `qf_subject_international_info` VALUES ('1630827003986972672', 'CF1', 'CF4000', '现金及现金等价物净增加额', 'Net change in cash and cash equivalents', '€', '1', '1630785386760507392', 0, '/1630785386760507392/1630827003986972672', '/财务-现金流量类/现金及现金等价物净增加额', '/CF/CF4000', NULL, 4, '0', '1', '1', '2023-03-01 15:07:12', '1', '2023-03-01 15:07:12');
INSERT INTO `qf_subject_international_info` VALUES ('1630827004616118272', 'CF1', 'CF5000', '汇率变动对现金及现金等价物的影响', 'Fluctuations in cash and cash equivalents on acc. of changes ex. rates', '€', '1', '1630785386760507392', 0, '/1630785386760507392/1630827004616118272', '/财务-现金流量类/汇率变动对现金及现金等价物的影响', '/CF/CF5000', NULL, 5, '0', '1', '1', '2023-03-01 15:07:12', '1', '2023-03-01 15:07:12');
INSERT INTO `qf_subject_international_info` VALUES ('1630827005236875264', 'CF1', 'CF6000', '期初现金及现金等价物余额', 'Cash and cash equivalents at the beginning of ther periode', '€', '1', '1630785386760507392', 0, '/1630785386760507392/1630827005236875264', '/财务-现金流量类/期初现金及现金等价物余额', '/CF/CF6000', NULL, 6, '0', '1', '1', '2023-03-01 15:07:12', '1', '2023-03-01 15:07:12');
INSERT INTO `qf_subject_international_info` VALUES ('1630827005845049344', 'CF1', 'CF7000', '期末现金及现金等价物余额', 'Cash and cash equivalents at the end of the period', '€', '1', '1630785386760507392', 0, '/1630785386760507392/1630827005845049344', '/财务-现金流量类/期末现金及现金等价物余额', '/CF/CF7000', NULL, 7, '0', '1', '1', '2023-03-01 15:07:12', '1', '2023-03-01 15:07:12');
INSERT INTO `qf_subject_international_info` VALUES ('1630827133385445376', 'CF1', 'CF110001', '税前利润', 'Earnings before income taxes (EBT)', '€', '2', '1630827002229559296', 0, '/1630785386760507392/1630827002229559296/1630827133385445376', '/财务-现金流量类/经营活动产生的现金流量净额/税前利润', '/CF/CF1000/CF110001', NULL, 1, '0', '1', '1', '2023-03-01 15:07:43', '1', '2023-03-01 15:07:43');
INSERT INTO `qf_subject_international_info` VALUES ('1630827134039756800', 'CF1', 'CF110002', '非现金：', 'Non-cash:', '€', '2', '1630827002229559296', 0, '/1630785386760507392/1630827002229559296/1630827134039756800', '/财务-现金流量类/经营活动产生的现金流量净额/非现金：', '/CF/CF1000/CF110002', NULL, 2, '0', '1', '1', '2023-03-01 15:07:43', '1', '2023-03-01 15:07:43');
INSERT INTO `qf_subject_international_info` VALUES ('1630827134660513792', 'CF1', 'CF110003', '固定资产及使用权资产折旧和减值', 'Depreciation and impairments on property, plant and equipment', '€', '2', '1630827002229559296', 0, '/1630785386760507392/1630827002229559296/1630827134660513792', '/财务-现金流量类/经营活动产生的现金流量净额/固定资产及使用权资产折旧和减值', '/CF/CF1000/CF110003', NULL, 3, '0', '1', '1', '2023-03-01 15:07:43', '1', '2023-03-01 15:07:43');
INSERT INTO `qf_subject_international_info` VALUES ('1630827135268687872', 'CF1', 'CF110004', '无形资产摊销和减值', 'Depreciation and impairments on intangible assets', '€', '2', '1630827002229559296', 0, '/1630785386760507392/1630827002229559296/1630827135268687872', '/财务-现金流量类/经营活动产生的现金流量净额/无形资产摊销和减值', '/CF/CF1000/CF110004', NULL, 4, '0', '1', '1', '2023-03-01 15:07:43', '1', '2023-03-01 15:07:43');
INSERT INTO `qf_subject_international_info` VALUES ('1630827135893639168', 'CF1', 'CF110005', '未实现汇兑损益', 'Unrealised foreign exchange rate gains / losses', '€', '2', '1630827002229559296', 0, '/1630785386760507392/1630827002229559296/1630827135893639168', '/财务-现金流量类/经营活动产生的现金流量净额/未实现汇兑损益', '/CF/CF1000/CF110005', NULL, 5, '0', '1', '1', '2023-03-01 15:07:43', '1', '2023-03-01 15:07:43');
INSERT INTO `qf_subject_international_info` VALUES ('1630827136476647424', 'CF1', 'CF110006', '衍生工具公允价值变动净损益', 'Net loss/gain on derivative instruments at FVTPL', '€', '2', '1630827002229559296', 0, '/1630785386760507392/1630827002229559296/1630827136476647424', '/财务-现金流量类/经营活动产生的现金流量净额/衍生工具公允价值变动净损益', '/CF/CF1000/CF110006', NULL, 6, '0', '1', '1', '2023-03-01 15:07:43', '1', '2023-03-01 15:07:43');
INSERT INTO `qf_subject_international_info` VALUES ('1630827137059655680', 'CF1', 'CF110007', '固定资产处置损益', 'Net losses from disposal of property, plant and equipment', '€', '2', '1630827002229559296', 0, '/1630785386760507392/1630827002229559296/1630827137059655680', '/财务-现金流量类/经营活动产生的现金流量净额/固定资产处置损益', '/CF/CF1000/CF110007', NULL, 7, '0', '1', '1', '2023-03-01 15:07:43', '1', '2023-03-01 15:07:44');
INSERT INTO `qf_subject_international_info` VALUES ('1630827137630081024', 'CF1', 'CF110008', '利息收入', 'Finance income', '€', '2', '1630827002229559296', 0, '/1630785386760507392/1630827002229559296/1630827137630081024', '/财务-现金流量类/经营活动产生的现金流量净额/利息收入', '/CF/CF1000/CF110008', NULL, 8, '0', '1', '1', '2023-03-01 15:07:44', '1', '2023-03-01 15:07:44');
INSERT INTO `qf_subject_international_info` VALUES ('1630827138426998784', 'CF1', 'CF110009', '利息费用', 'Finance costs', '€', '2', '1630827002229559296', 0, '/1630785386760507392/1630827002229559296/1630827138426998784', '/财务-现金流量类/经营活动产生的现金流量净额/利息费用', '/CF/CF1000/CF110009', NULL, 9, '0', '1', '1', '2023-03-01 15:07:44', '1', '2023-03-01 15:07:44');
INSERT INTO `qf_subject_international_info` VALUES ('1630827139022589952', 'CF1', 'CF110010', '预提准备金及养老金和类似义务的变动', 'Movements in provisions, provisions for pensions, similar obligations', '€', '2', '1630827002229559296', 0, '/1630785386760507392/1630827002229559296/1630827139022589952', '/财务-现金流量类/经营活动产生的现金流量净额/预提准备金及养老金和类似义务的变动', '/CF/CF1000/CF110010', NULL, 10, '0', '1', '1', '2023-03-01 15:07:44', '1', '2023-03-01 15:07:44');
INSERT INTO `qf_subject_international_info` VALUES ('1630827139651735552', 'CF1', 'CF110011', '其他非现金交易', 'Other Non-Cash', '€', '2', '1630827002229559296', 0, '/1630785386760507392/1630827002229559296/1630827139651735552', '/财务-现金流量类/经营活动产生的现金流量净额/其他非现金交易', '/CF/CF1000/CF110011', NULL, 11, '0', '1', '1', '2023-03-01 15:07:44', '1', '2023-03-01 15:07:44');
INSERT INTO `qf_subject_international_info` VALUES ('1630827140280881152', 'CF1', 'CF110012', '净营运资金调整：', 'Net working capital adjustments:', '€', '2', '1630827002229559296', 0, '/1630785386760507392/1630827002229559296/1630827140280881152', '/财务-现金流量类/经营活动产生的现金流量净额/净营运资金调整：', '/CF/CF1000/CF110012', NULL, 12, '0', '1', '1', '2023-03-01 15:07:44', '1', '2023-03-01 15:07:44');
INSERT INTO `qf_subject_international_info` VALUES ('1630827140893249536', 'CF1', 'CF110013', '应收账款和其他资产增减变动', 'Increase / decrease in trade receivables and other assets', '€', '2', '1630827002229559296', 0, '/1630785386760507392/1630827002229559296/1630827140893249536', '/财务-现金流量类/经营活动产生的现金流量净额/应收账款和其他资产增减变动', '/CF/CF1000/CF110013', NULL, 13, '0', '1', '1', '2023-03-01 15:07:44', '1', '2023-03-01 15:07:44');
INSERT INTO `qf_subject_international_info` VALUES ('1630827141505617920', 'CF1', 'CF110014', '存货增减变动', 'Increase / decrease in inventories', '€', '2', '1630827002229559296', 0, '/1630785386760507392/1630827002229559296/1630827141505617920', '/财务-现金流量类/经营活动产生的现金流量净额/存货增减变动', '/CF/CF1000/CF110014', NULL, 14, '0', '1', '1', '2023-03-01 15:07:45', '1', '2023-03-01 15:07:45');
INSERT INTO `qf_subject_international_info` VALUES ('1630827142109597696', 'CF1', 'CF110015', '应付账款和其他应付款增减变动', 'Increase / decrease trade and other payables', '€', '2', '1630827002229559296', 0, '/1630785386760507392/1630827002229559296/1630827142109597696', '/财务-现金流量类/经营活动产生的现金流量净额/应付账款和其他应付款增减变动', '/CF/CF1000/CF110015', NULL, 15, '0', '1', '1', '2023-03-01 15:07:45', '1', '2023-03-01 15:07:45');
INSERT INTO `qf_subject_international_info` VALUES ('1630827142726160384', 'CF1', 'CF110016', '支付所得税费用', 'Income taxes paid', '€', '2', '1630827002229559296', 0, '/1630785386760507392/1630827002229559296/1630827142726160384', '/财务-现金流量类/经营活动产生的现金流量净额/支付所得税费用', '/CF/CF1000/CF110016', NULL, 16, '0', '1', '1', '2023-03-01 15:07:45', '1', '2023-03-01 15:07:45');
INSERT INTO `qf_subject_international_info` VALUES ('1630827143321751552', 'CF1', 'CF220001', '处置固定资产收到的现金', 'Proceeds from sale of property, plant and equipment', '€', '2', '1630827002812567552', 0, '/1630785386760507392/1630827002812567552/1630827143321751552', '/财务-现金流量类/投资活动产生的现金流量净额/处置固定资产收到的现金', '/CF/CF2000/CF220001', NULL, 1, '0', '1', '1', '2023-03-01 15:07:45', '1', '2023-03-01 15:07:45');
INSERT INTO `qf_subject_international_info` VALUES ('1630827143938314240', 'CF1', 'CF220002', '购买固定资产支付的现金', 'Acquisition of property, plant and equipment', '€', '2', '1630827002812567552', 0, '/1630785386760507392/1630827002812567552/1630827143938314240', '/财务-现金流量类/投资活动产生的现金流量净额/购买固定资产支付的现金', '/CF/CF2000/CF220002', NULL, 2, '0', '1', '1', '2023-03-01 15:07:45', '1', '2023-03-01 15:07:45');
INSERT INTO `qf_subject_international_info` VALUES ('1630827144567459840', 'CF1', 'CF220003', '购买无形资产支付的现金', 'Acquisition of intangible assets', '€', '2', '1630827002812567552', 0, '/1630785386760507392/1630827002812567552/1630827144567459840', '/财务-现金流量类/投资活动产生的现金流量净额/购买无形资产支付的现金', '/CF/CF2000/CF220003', NULL, 3, '0', '1', '1', '2023-03-01 15:07:45', '1', '2023-03-01 15:07:45');
INSERT INTO `qf_subject_international_info` VALUES ('1630827145192411136', 'CF1', 'CF220004', '处置无形资产收到的现金', 'Proceeds from the sale of intangible assets', '€', '2', '1630827002812567552', 0, '/1630785386760507392/1630827002812567552/1630827145192411136', '/财务-现金流量类/投资活动产生的现金流量净额/处置无形资产收到的现金', '/CF/CF2000/CF220004', NULL, 4, '0', '1', '1', '2023-03-01 15:07:45', '1', '2023-03-01 15:07:45');
INSERT INTO `qf_subject_international_info` VALUES ('1630827145800585216', 'CF1', 'CF220005', '使用权资产预付款', 'Prepayments for right-of-use-assets', '€', '2', '1630827002812567552', 0, '/1630785386760507392/1630827002812567552/1630827145800585216', '/财务-现金流量类/投资活动产生的现金流量净额/使用权资产预付款', '/CF/CF2000/CF220005', NULL, 5, '0', '1', '1', '2023-03-01 15:07:46', '1', '2023-03-01 15:07:46');
INSERT INTO `qf_subject_international_info` VALUES ('1630827147344089088', 'CF1', 'CF220006', '投资支付的现金', 'Acquisition of financial assets', '€', '2', '1630827002812567552', 0, '/1630785386760507392/1630827002812567552/1630827147344089088', '/财务-现金流量类/投资活动产生的现金流量净额/投资支付的现金', '/CF/CF2000/CF220006', NULL, 6, '0', '1', '1', '2023-03-01 15:07:46', '1', '2023-03-01 15:07:46');
INSERT INTO `qf_subject_international_info` VALUES ('1630827147931291648', 'CF1', 'CF220007', '收到利息', 'Interest received', '€', '2', '1630827002812567552', 0, '/1630785386760507392/1630827002812567552/1630827147931291648', '/财务-现金流量类/投资活动产生的现金流量净额/收到利息', '/CF/CF2000/CF220007', NULL, 7, '0', '1', '1', '2023-03-01 15:07:46', '1', '2023-03-01 15:07:46');
INSERT INTO `qf_subject_international_info` VALUES ('1630827148552048640', 'CF1', 'CF220008', '取得投资收益收到的现金', 'Dividends received', '€', '2', '1630827002812567552', 0, '/1630785386760507392/1630827002812567552/1630827148552048640', '/财务-现金流量类/投资活动产生的现金流量净额/取得投资收益收到的现金', '/CF/CF2000/CF220008', NULL, 8, '0', '1', '1', '2023-03-01 15:07:46', '1', '2023-03-01 15:07:46');
INSERT INTO `qf_subject_international_info` VALUES ('1630827149160222720', 'CF1', 'CF330001', '吸收投资收到的现金', 'Capital increase/ decrease and other equity transactions', '€', '2', '1630827003403964416', 0, '/1630785386760507392/1630827003403964416/1630827149160222720', '/财务-现金流量类/筹资活动产生的现金流量净额/吸收投资收到的现金', '/CF/CF3000/CF330001', NULL, 1, '0', '1', '1', '2023-03-01 15:07:46', '1', '2023-03-01 15:07:46');
INSERT INTO `qf_subject_international_info` VALUES ('1630827149768396800', 'CF1', 'CF330002', '偿还租赁负债支付的现金', 'Payment of principal portion of lease liabilities', '€', '2', '1630827003403964416', 0, '/1630785386760507392/1630827003403964416/1630827149768396800', '/财务-现金流量类/筹资活动产生的现金流量净额/偿还租赁负债支付的现金', '/CF/CF3000/CF330002', NULL, 2, '0', '1', '1', '2023-03-01 15:07:47', '1', '2023-03-01 15:07:47');
INSERT INTO `qf_subject_international_info` VALUES ('1630827150355599360', 'CF1', 'CF330003', '取得借款收到的现金', 'Proceeds from borrowings', '€', '2', '1630827003403964416', 0, '/1630785386760507392/1630827003403964416/1630827150355599360', '/财务-现金流量类/筹资活动产生的现金流量净额/取得借款收到的现金', '/CF/CF3000/CF330003', NULL, 3, '0', '1', '1', '2023-03-01 15:07:47', '1', '2023-03-01 15:07:47');
INSERT INTO `qf_subject_international_info` VALUES ('1630827150926024704', 'CF1', 'CF330004', '偿还借款支付的现金', 'Repayment of borrowings', '€', '2', '1630827003403964416', 0, '/1630785386760507392/1630827003403964416/1630827150926024704', '/财务-现金流量类/筹资活动产生的现金流量净额/偿还借款支付的现金', '/CF/CF3000/CF330004', NULL, 4, '0', '1', '1', '2023-03-01 15:07:47', '1', '2023-03-01 15:07:47');
INSERT INTO `qf_subject_international_info` VALUES ('1630827151525810176', 'CF1', 'CF330005', '公司间借款', 'IC loans', '€', '2', '1630827003403964416', 0, '/1630785386760507392/1630827003403964416/1630827151525810176', '/财务-现金流量类/筹资活动产生的现金流量净额/公司间借款', '/CF/CF3000/CF330005', NULL, 5, '0', '1', '1', '2023-03-01 15:07:47', '1', '2023-03-01 15:07:47');
INSERT INTO `qf_subject_international_info` VALUES ('1630827152133984256', 'CF1', 'CF330006', '偿付利息支付的现金', 'Interest paid', '€', '2', '1630827003403964416', 0, '/1630785386760507392/1630827003403964416/1630827152133984256', '/财务-现金流量类/筹资活动产生的现金流量净额/偿付利息支付的现金', '/CF/CF3000/CF330006', NULL, 6, '0', '1', '1', '2023-03-01 15:07:47', '1', '2023-03-01 15:07:47');
INSERT INTO `qf_subject_international_info` VALUES ('1630827152758935552', 'CF1', 'CF330007', '分配股利支付的现金', 'Dividend paid', '€', '2', '1630827003403964416', 0, '/1630785386760507392/1630827003403964416/1630827152758935552', '/财务-现金流量类/筹资活动产生的现金流量净额/分配股利支付的现金', '/CF/CF3000/CF330007', NULL, 7, '0', '1', '1', '2023-03-01 15:07:47', '1', '2023-03-01 15:07:47');
INSERT INTO `qf_subject_international_info` VALUES ('1630827966302916608', 'HR1', 'HR010000', '物流人员', '1. Logistics Heads', '人', '1', '1630785662485663744', 5, '/1630785662485663744/1630827966302916608', '/人力资源类/物流人员', '/HR/HR010000', NULL, 1, '0', '1', '1', '2023-03-01 15:11:01', '1', '2023-03-01 15:14:17');
INSERT INTO `qf_subject_international_info` VALUES ('1630827966965616640', 'HR1', 'HR020000', '制造人员', '2.Manufacturing Heads', '人', '1', '1630785662485663744', 11, '/1630785662485663744/1630827966965616640', '/人力资源类/制造人员', '/HR/HR020000', NULL, 2, '0', '1', '1', '2023-03-01 15:11:01', '1', '2023-03-01 15:14:19');
INSERT INTO `qf_subject_international_info` VALUES ('1630827967661871104', 'HR1', 'HR030000', '工业工程人员', '3. Industrial Engineering Heads', '人', '1', '1630785662485663744', 2, '/1630785662485663744/1630827967661871104', '/人力资源类/工业工程人员', '/HR/HR030000', NULL, 3, '0', '1', '1', '2023-03-01 15:11:02', '1', '2023-03-01 15:14:19');
INSERT INTO `qf_subject_international_info` VALUES ('1630827968328765440', 'HR1', 'HR040000', '质量体系人员', '4. Quality systems Heads', '人', '1', '1630785662485663744', 6, '/1630785662485663744/1630827968328765440', '/人力资源类/质量体系人员', '/HR/HR040000', NULL, 4, '0', '1', '1', '2023-03-01 15:11:02', '1', '2023-03-01 15:14:20');
INSERT INTO `qf_subject_international_info` VALUES ('1630827969050185728', 'HR1', 'HR050000', '产品开发人员', '5. Product development Heads', '人', '1', '1630785662485663744', 5, '/1630785662485663744/1630827969050185728', '/人力资源类/产品开发人员', '/HR/HR050000', NULL, 5, '0', '1', '1', '2023-03-01 15:11:02', '1', '2023-03-01 15:14:21');
INSERT INTO `qf_subject_international_info` VALUES ('1630827969721274368', 'HR1', 'HR060000', '人力资源人员', '6. Human Resource Heads', '人', '1', '1630785662485663744', 0, '/1630785662485663744/1630827969721274368', '/人力资源类/人力资源人员', '/HR/HR060000', NULL, 6, '0', '1', '1', '2023-03-01 15:11:02', '1', '2023-03-01 15:11:02');
INSERT INTO `qf_subject_international_info` VALUES ('1630827970379780096', 'HR1', 'HR070000', '财务人员', '7. Finance Heads', '人', '1', '1630785662485663744', 0, '/1630785662485663744/1630827970379780096', '/人力资源类/财务人员', '/HR/HR070000', NULL, 7, '0', '1', '1', '2023-03-01 15:11:02', '1', '2023-03-01 15:11:02');
INSERT INTO `qf_subject_international_info` VALUES ('1630827972061696000', 'HR1', 'HR080000', 'IT人员', '8. Information technology Heads', '人', '1', '1630785662485663744', 0, '/1630785662485663744/1630827972061696000', '/人力资源类/IT人员', '/HR/HR080000', NULL, 8, '0', '1', '1', '2023-03-01 15:11:03', '1', '2023-03-01 15:11:03');
INSERT INTO `qf_subject_international_info` VALUES ('1630827972665675776', 'HR1', 'HR090000', '采购人员', '9. Purchasing Heads', '人', '1', '1630785662485663744', 0, '/1630785662485663744/1630827972665675776', '/人力资源类/采购人员', '/HR/HR090000', NULL, 9, '0', '1', '1', '2023-03-01 15:11:03', '1', '2023-03-01 15:11:03');
INSERT INTO `qf_subject_international_info` VALUES ('1630827973328375808', 'HR1', 'HR100000', '销售&市场人员', '10. Sales & Marketing Heads', '人', '1', '1630785662485663744', 0, '/1630785662485663744/1630827973328375808', '/人力资源类/销售&市场人员', '/HR/HR100000', NULL, 10, '0', '1', '1', '2023-03-01 15:11:03', '1', '2023-03-01 15:11:03');
INSERT INTO `qf_subject_international_info` VALUES ('1630827973957521408', 'HR1', 'HR110000', '运营/商务部管理人员', '11. Operation/Business Unit management Heads', '人', '1', '1630785662485663744', 0, '/1630785662485663744/1630827973957521408', '/人力资源类/运营/商务部管理人员', '/HR/HR110000', NULL, 11, '0', '1', '1', '2023-03-01 15:11:03', '1', '2023-03-01 15:11:03');
INSERT INTO `qf_subject_international_info` VALUES ('1630827974624415744', 'HR1', 'HR120000', '法律事务人员', '12. Regulatory affaires Heads', '人', '1', '1630785662485663744', 0, '/1630785662485663744/1630827974624415744', '/人力资源类/法律事务人员', '/HR/HR120000', NULL, 12, '0', '1', '1', '2023-03-01 15:11:03', '1', '2023-03-01 15:11:03');
INSERT INTO `qf_subject_international_info` VALUES ('1630827975295504384', 'HR1', 'HR010000s', '运营人员总数', 'Total operational employees heads', '人', '1', '1630785662485663744', 0, '/1630785662485663744/1630827975295504384', '/人力资源类/运营人员总数', '/HR/HR010000s', NULL, 13, '0', '1', '1', '2023-03-01 15:11:03', '1', '2023-03-01 15:11:03');
INSERT INTO `qf_subject_international_info` VALUES ('1630827975912067072', 'HR1', 'HR020000s', '其中运营人员总数的非全职人员', 'Total pperational employees thereof PTE', '人', '1', '1630785662485663744', 0, '/1630785662485663744/1630827975912067072', '/人力资源类/其中运营人员总数的非全职人员', '/HR/HR020000s', NULL, 14, '0', '1', '1', '2023-03-01 15:11:03', '1', '2023-03-01 15:11:04');
INSERT INTO `qf_subject_international_info` VALUES ('1630827976516046848', 'HR1', 'HR140000', '其他有合同关系的人员', '14. Others with contractually binding relationships Heads', '人', '1', '1630785662485663744', 2, '/1630785662485663744/1630827976516046848', '/人力资源类/其他有合同关系的人员', '/HR/HR140000', NULL, 15, '0', '1', '1', '2023-03-01 15:11:04', '1', '2023-03-08 16:06:59');
INSERT INTO `qf_subject_international_info` VALUES ('1630827977157775360', 'HR1', 'HR030000s', '支付薪酬人员总数', 'Total headcount paid heads', '人', '1', '1630785662485663744', 1, '/1630785662485663744/1630827977157775360', '/人力资源类/支付薪酬人员总数', '/HR/HR030000s', NULL, 16, '0', '1', '1', '2023-03-01 15:11:04', '1', '2023-03-01 15:14:21');
INSERT INTO `qf_subject_international_info` VALUES ('1630827977988247552', 'HR1', 'HR150000', '部分退休（无活动）', 'Partial Retirement (inactive)', '人', '1', '1630785662485663744', 0, '/1630785662485663744/1630827977988247552', '/人力资源类/部分退休（无活动）', '/HR/HR150000', NULL, 17, '0', '1', '1', '2023-03-01 15:11:04', '1', '2023-03-01 15:11:04');
INSERT INTO `qf_subject_international_info` VALUES ('1630827978692890624', 'HR1', 'HR160000', '在其他SG集团分子公司工作的员工', 'Employees working at other SG-Group-companies', '人', '1', '1630785662485663744', 0, '/1630785662485663744/1630827978692890624', '/人力资源类/在其他SG集团分子公司工作的员工', '/HR/HR160000', NULL, 18, '0', '1', '1', '2023-03-01 15:11:04', '1', '2023-03-01 15:11:04');
INSERT INTO `qf_subject_international_info` VALUES ('1630827979338813440', 'HR1', 'HR170000', '长期病假', 'Long Term Sickness Leave', '人', '1', '1630785662485663744', 0, '/1630785662485663744/1630827979338813440', '/人力资源类/长期病假', '/HR/HR170000', NULL, 19, '0', '1', '1', '2023-03-01 15:11:04', '1', '2023-03-01 15:11:04');
INSERT INTO `qf_subject_international_info` VALUES ('1630827979963764736', 'HR1', 'HR180000', '产假/陪产假', 'Maternity/ Parental leave', '人', '1', '1630785662485663744', 0, '/1630785662485663744/1630827979963764736', '/人力资源类/产假/陪产假', '/HR/HR180000', NULL, 20, '0', '1', '1', '2023-03-01 15:11:04', '1', '2023-03-01 15:11:04');
INSERT INTO `qf_subject_international_info` VALUES ('1630827980647436288', 'HR1', 'HR190000', '军队服役', 'Military Service', '人', '1', '1630785662485663744', 0, '/1630785662485663744/1630827980647436288', '/人力资源类/军队服役', '/HR/HR190000', NULL, 21, '0', '1', '1', '2023-03-01 15:11:05', '1', '2023-03-01 15:11:05');
INSERT INTO `qf_subject_international_info` VALUES ('1630827981276581888', 'HR1', 'HR200000', '其他', 'Others', '人', '1', '1630785662485663744', 0, '/1630785662485663744/1630827981276581888', '/人力资源类/其他', '/HR/HR200000', NULL, 22, '0', '1', '1', '2023-03-01 15:11:05', '1', '2023-03-01 15:11:05');
INSERT INTO `qf_subject_international_info` VALUES ('1630827981914116096', 'HR1', 'HR040000s', '未支付薪酬人员总数', 'Total Headcount Unpaid', '人', '1', '1630785662485663744', 1, '/1630785662485663744/1630827981914116096', '/人力资源类/未支付薪酬人员总数', '/HR/HR040000s', NULL, 23, '0', '1', '1', '2023-03-01 15:11:05', '1', '2023-03-01 15:14:21');
INSERT INTO `qf_subject_international_info` VALUES ('1630827982618759168', 'HR1', 'HR050000s', '总人数', 'Total Headcount', '人', '1', '1630785662485663744', 1, '/1630785662485663744/1630827982618759168', '/人力资源类/总人数', '/HR/HR050000s', NULL, 24, '0', '1', '1', '2023-03-01 15:11:05', '1', '2023-03-01 15:14:21');
INSERT INTO `qf_subject_international_info` VALUES ('1630827983260487680', 'HR1', 'HR060000s', '直接员工数', 'Number of direct employees Heads', '人', '1', '1630785662485663744', 0, '/1630785662485663744/1630827983260487680', '/人力资源类/直接员工数', '/HR/HR060000s', NULL, 25, '0', '1', '1', '2023-03-01 15:11:05', '1', '2023-03-01 15:11:05');
INSERT INTO `qf_subject_international_info` VALUES ('1630827983868661760', 'HR1', 'HR070000s', '非全职直接员工数', 'Number of direct employees thereof PTE', '人', '1', '1630785662485663744', 0, '/1630785662485663744/1630827983868661760', '/人力资源类/非全职直接员工数', '/HR/HR070000s', NULL, 26, '0', '1', '1', '2023-03-01 15:11:05', '1', '2023-03-01 15:11:05');
INSERT INTO `qf_subject_international_info` VALUES ('1630827984489418752', 'HR1', 'HR080000s', '间接员工数', 'Number of indirect employees Heads', '人', '1', '1630785662485663744', 0, '/1630785662485663744/1630827984489418752', '/人力资源类/间接员工数', '/HR/HR080000s', NULL, 27, '0', '1', '1', '2023-03-01 15:11:06', '1', '2023-03-01 15:11:06');
INSERT INTO `qf_subject_international_info` VALUES ('1630827985143730176', 'HR1', 'HR090000s', '非全职间接员工数', 'Number of indirect employees thereof PTE', '人', '1', '1630785662485663744', 0, '/1630785662485663744/1630827985143730176', '/人力资源类/非全职间接员工数', '/HR/HR090000s', NULL, 28, '0', '1', '1', '2023-03-01 15:11:06', '1', '2023-03-01 15:11:06');
INSERT INTO `qf_subject_international_info` VALUES ('1630827985798041600', 'HR1', 'HR100000s', '未支付薪酬人员数', 'Number of unpaid employees Heads', '人', '1', '1630785662485663744', 0, '/1630785662485663744/1630827985798041600', '/人力资源类/未支付薪酬人员数', '/HR/HR100000s', NULL, 30, '0', '1', '1', '2023-03-01 15:11:06', '1', '2023-03-01 15:11:06');
INSERT INTO `qf_subject_international_info` VALUES ('1630827986431381504', 'HR1', 'HR110000s', '未支付薪酬的非全职人员数', 'Number of unpaid employees thereof PTE', '人', '1', '1630785662485663744', 0, '/1630785662485663744/1630827986431381504', '/人力资源类/未支付薪酬的非全职人员数', '/HR/HR110000s', NULL, 31, '0', '1', '1', '2023-03-01 15:11:06', '1', '2023-03-01 15:11:06');
INSERT INTO `qf_subject_international_info` VALUES ('1630827987073110016', 'HR1', 'HR120000s', '“净”直接员工数', '\"Net\" direct employees in heads', '人', '1', '1630785662485663744', 0, '/1630785662485663744/1630827987073110016', '/人力资源类/“净”直接员工数', '/HR/HR120000s', NULL, 32, '0', '1', '1', '2023-03-01 15:11:06', '1', '2023-03-01 15:11:06');
INSERT INTO `qf_subject_international_info` VALUES ('1630827987693867008', 'HR1', 'HR130000s', '每“净”直接员工成本，欧元计', 'Costs per \"net\" direct employee heads in EUR', '人', '1', '1630785662485663744', 0, '/1630785662485663744/1630827987693867008', '/人力资源类/每“净”直接员工成本，欧元计', '/HR/HR130000s', NULL, 33, '0', '1', '1', '2023-03-01 15:11:06', '1', '2023-03-01 15:11:06');
INSERT INTO `qf_subject_international_info` VALUES ('1630827988323012608', 'HR1', 'HR140000s', '“净”间接员工数', '\"Net\" indirect employees in heads', '人', '1', '1630785662485663744', 0, '/1630785662485663744/1630827988323012608', '/人力资源类/“净”间接员工数', '/HR/HR140000s', NULL, 34, '0', '1', '1', '2023-03-01 15:11:06', '1', '2023-03-01 15:11:06');
INSERT INTO `qf_subject_international_info` VALUES ('1630827988989906944', 'HR1', 'HR150000s', '每“净”间接员工成本，欧元计', 'Costs per \"net\" indirect employee heads in EUR', '人', '1', '1630785662485663744', 0, '/1630785662485663744/1630827988989906944', '/人力资源类/每“净”间接员工成本，欧元计', '/HR/HR150000s', NULL, 35, '0', '1', '1', '2023-03-01 15:11:07', '1', '2023-03-01 15:11:07');
INSERT INTO `qf_subject_international_info` VALUES ('1630827989660995584', 'HR1', 'HR160000s', '直接员工成本，欧元计', 'Costs for direct employees in EUR', '人', '1', '1630785662485663744', 0, '/1630785662485663744/1630827989660995584', '/人力资源类/直接员工成本，欧元计', '/HR/HR160000s', NULL, 36, '0', '1', '1', '2023-03-01 15:11:07', '1', '2023-03-01 15:11:07');
INSERT INTO `qf_subject_international_info` VALUES ('1630827990323695616', 'HR1', 'HR170000s', '间接员工，欧元计', 'Costs for indirect employees in EUR', '人', '1', '1630785662485663744', 0, '/1630785662485663744/1630827990323695616', '/人力资源类/间接员工，欧元计', '/HR/HR170000s', NULL, 37, '0', '1', '1', '2023-03-01 15:11:07', '1', '2023-03-01 15:11:07');
INSERT INTO `qf_subject_international_info` VALUES ('1630828783466582016', 'HR1', 'HR010100', '物流管理', 'Logistic Management', '人', '2', '1630827966302916608', 0, '/1630785662485663744/1630827966302916608/1630828783466582016', '/人力资源类/物流人员/物流管理', '/HR/HR010000/HR010100', NULL, 1, '0', '1', '1', '2023-03-01 15:14:16', '1', '2023-03-01 15:14:16');
INSERT INTO `qf_subject_international_info` VALUES ('1630828784099921920', 'HR1', 'HR010200', '物流行政/运输', 'Logistic Administration/Transportation', '人', '2', '1630827966302916608', 0, '/1630785662485663744/1630827966302916608/1630828784099921920', '/人力资源类/物流人员/物流行政/运输', '/HR/HR010000/HR010200', NULL, 2, '0', '1', '1', '2023-03-01 15:14:16', '1', '2023-03-01 15:14:16');
INSERT INTO `qf_subject_international_info` VALUES ('1630828784724873216', 'HR1', 'HR010300', '物料搬运/内部转运', 'Material Handling/Internal transport', '人', '2', '1630827966302916608', 0, '/1630785662485663744/1630827966302916608/1630828784724873216', '/人力资源类/物流人员/物料搬运/内部转运', '/HR/HR010000/HR010300', NULL, 3, '0', '1', '1', '2023-03-01 15:14:16', '1', '2023-03-01 15:14:16');
INSERT INTO `qf_subject_international_info` VALUES ('1630828785303687168', 'HR1', 'HR010400', '仓储', 'Warehousing', '人', '2', '1630827966302916608', 0, '/1630785662485663744/1630827966302916608/1630828785303687168', '/人力资源类/物流人员/仓储', '/HR/HR010000/HR010400', NULL, 4, '0', '1', '1', '2023-03-01 15:14:16', '1', '2023-03-01 15:14:16');
INSERT INTO `qf_subject_international_info` VALUES ('1630828785941221376', 'HR1', 'HR010500', '材料采购', 'Material Procurement', '人', '2', '1630827966302916608', 0, '/1630785662485663744/1630827966302916608/1630828785941221376', '/人力资源类/物流人员/材料采购', '/HR/HR010000/HR010500', NULL, 5, '0', '1', '1', '2023-03-01 15:14:17', '1', '2023-03-01 15:14:17');
INSERT INTO `qf_subject_international_info` VALUES ('1630828786582949888', 'HR1', 'HR020100', '生产管理', 'Production Management', '人', '2', '1630827966965616640', 0, '/1630785662485663744/1630827966965616640/1630828786582949888', '/人力资源类/制造人员/生产管理', '/HR/HR020000/HR020100', NULL, 1, '0', '1', '1', '2023-03-01 15:14:17', '1', '2023-03-01 15:14:17');
INSERT INTO `qf_subject_international_info` VALUES ('1630828787220484096', 'HR1', 'HR020200', '生产监督', 'Production Supervision', '人', '2', '1630827966965616640', 0, '/1630785662485663744/1630827966965616640/1630828787220484096', '/人力资源类/制造人员/生产监督', '/HR/HR020000/HR020200', NULL, 2, '0', '1', '1', '2023-03-01 15:14:17', '1', '2023-03-01 15:14:17');
INSERT INTO `qf_subject_international_info` VALUES ('1630828787862212608', 'HR1', 'HR020300', '小组长', 'Group Leader', '人', '2', '1630827966965616640', 0, '/1630785662485663744/1630827966965616640/1630828787862212608', '/人力资源类/制造人员/小组长', '/HR/HR020000/HR020300', NULL, 3, '0', '1', '1', '2023-03-01 15:14:17', '1', '2023-03-01 15:14:17');
INSERT INTO `qf_subject_international_info` VALUES ('1630828788495552512', 'HR1', 'HR020400', '直接人工（增值效益）', 'Direct Labour Value adding', '人', '2', '1630827966965616640', 0, '/1630785662485663744/1630827966965616640/1630828788495552512', '/人力资源类/制造人员/直接人工（增值效益）', '/HR/HR020000/HR020400', NULL, 4, '0', '1', '1', '2023-03-01 15:14:17', '1', '2023-03-01 15:14:17');
INSERT INTO `qf_subject_international_info` VALUES ('1630828789128892416', 'HR1', 'HR020500', '直接人工（其他）', 'Direct Labour Others', '人', '2', '1630827966965616640', 0, '/1630785662485663744/1630827966965616640/1630828789128892416', '/人力资源类/制造人员/直接人工（其他）', '/HR/HR020000/HR020500', NULL, 5, '0', '1', '1', '2023-03-01 15:14:18', '1', '2023-03-01 15:14:18');
INSERT INTO `qf_subject_international_info` VALUES ('1630828790659813376', 'HR1', 'HR020600', '设备和建筑 维护', 'Maintenance Equipment & Building', '人', '2', '1630827966965616640', 0, '/1630785662485663744/1630827966965616640/1630828790659813376', '/人力资源类/制造人员/设备和建筑 维护', '/HR/HR020000/HR020600', NULL, 6, '0', '1', '1', '2023-03-01 15:14:18', '1', '2023-03-01 15:14:18');
INSERT INTO `qf_subject_international_info` VALUES ('1630828791255404544', 'HR1', 'HR020700', '生产行政', 'Production Administration', '人', '2', '1630827966965616640', 0, '/1630785662485663744/1630827966965616640/1630828791255404544', '/人力资源类/制造人员/生产行政', '/HR/HR020000/HR020700', NULL, 7, '0', '1', '1', '2023-03-01 15:14:18', '1', '2023-03-01 15:14:18');
INSERT INTO `qf_subject_international_info` VALUES ('1630828791838412800', 'HR1', 'HR020800', '工装模具/样品', 'Tooling/Samples', '人', '2', '1630827966965616640', 0, '/1630785662485663744/1630827966965616640/1630828791838412800', '/人力资源类/制造人员/工装模具/样品', '/HR/HR020000/HR020800', NULL, 8, '0', '1', '1', '2023-03-01 15:14:18', '1', '2023-03-01 15:14:18');
INSERT INTO `qf_subject_international_info` VALUES ('1630828792484335616', 'HR1', 'HR020900', '模具安装员', 'Tool Setters', '人', '2', '1630827966965616640', 0, '/1630785662485663744/1630827966965616640/1630828792484335616', '/人力资源类/制造人员/模具安装员', '/HR/HR020000/HR020900', NULL, 9, '0', '1', '1', '2023-03-01 15:14:18', '1', '2023-03-01 15:14:18');
INSERT INTO `qf_subject_international_info` VALUES ('1630828793084121088', 'HR1', 'HR021000', '密炼部 直接', 'Mixing Department direct', '人', '2', '1630827966965616640', 0, '/1630785662485663744/1630827966965616640/1630828793084121088', '/人力资源类/制造人员/密炼部 直接', '/HR/HR020000/HR021000', NULL, 10, '0', '1', '1', '2023-03-01 15:14:18', '1', '2023-03-01 15:14:18');
INSERT INTO `qf_subject_international_info` VALUES ('1630828793730043904', 'HR1', 'HR021100', '密炼部 间接', 'Mixing Department indirect', '人', '2', '1630827966965616640', 0, '/1630785662485663744/1630827966965616640/1630828793730043904', '/人力资源类/制造人员/密炼部 间接', '/HR/HR020000/HR021100', NULL, 11, '0', '1', '1', '2023-03-01 15:14:18', '1', '2023-03-01 15:14:18');
INSERT INTO `qf_subject_international_info` VALUES ('1630828794338217984', 'HR1', 'HR030100', '工艺开发', 'Process Development', '人', '2', '1630827967661871104', 0, '/1630785662485663744/1630827967661871104/1630828794338217984', '/人力资源类/工业工程人员/工艺开发', '/HR/HR030000/HR030100', NULL, 1, '0', '1', '1', '2023-03-01 15:14:19', '1', '2023-03-01 15:14:19');
INSERT INTO `qf_subject_international_info` VALUES ('1630828794925420544', 'HR1', 'HR030200', '其他', 'Others', '人', '2', '1630827967661871104', 0, '/1630785662485663744/1630827967661871104/1630828794925420544', '/人力资源类/工业工程人员/其他', '/HR/HR030000/HR030200', NULL, 2, '0', '1', '1', '2023-03-01 15:14:19', '1', '2023-03-01 15:14:19');
INSERT INTO `qf_subject_international_info` VALUES ('1630828795688783872', 'HR1', 'HR040100', '质量管理', 'Quality Management', '人', '2', '1630827968328765440', 0, '/1630785662485663744/1630827968328765440/1630828795688783872', '/人力资源类/质量体系人员/质量管理', '/HR/HR040000/HR040100', NULL, 1, '0', '1', '1', '2023-03-01 15:14:19', '1', '2023-03-01 15:14:19');
INSERT INTO `qf_subject_international_info` VALUES ('1630828796309540864', 'HR1', 'HR040200', '质量规划', 'Quality Planning', '人', '2', '1630827968328765440', 0, '/1630785662485663744/1630827968328765440/1630828796309540864', '/人力资源类/质量体系人员/质量规划', '/HR/HR040000/HR040200', NULL, 2, '0', '1', '1', '2023-03-01 15:14:19', '1', '2023-03-01 15:14:19');
INSERT INTO `qf_subject_international_info` VALUES ('1630828796951269376', 'HR1', 'HR040300', '质量工程/保证', 'Quality Engineering/Assurance', '人', '2', '1630827968328765440', 0, '/1630785662485663744/1630827968328765440/1630828796951269376', '/人力资源类/质量体系人员/质量工程/保证', '/HR/HR040000/HR040300', NULL, 3, '0', '1', '1', '2023-03-01 15:14:19', '1', '2023-03-01 15:14:19');
INSERT INTO `qf_subject_international_info` VALUES ('1630828797530083328', 'HR1', 'HR040400', '认证/测试', 'Validation/Verification/Testing', '人', '2', '1630827968328765440', 0, '/1630785662485663744/1630827968328765440/1630828797530083328', '/人力资源类/质量体系人员/认证/测试', '/HR/HR040000/HR040400', NULL, 4, '0', '1', '1', '2023-03-01 15:14:19', '1', '2023-03-01 15:14:19');
INSERT INTO `qf_subject_international_info` VALUES ('1630828799014866944', 'HR1', 'HR040500', '在线质量检查', 'In line quality checks', '人', '2', '1630827968328765440', 0, '/1630785662485663744/1630827968328765440/1630828799014866944', '/人力资源类/质量体系人员/在线质量检查', '/HR/HR040000/HR040500', NULL, 5, '0', '1', '1', '2023-03-01 15:14:20', '1', '2023-03-01 15:14:20');
INSERT INTO `qf_subject_international_info` VALUES ('1630828799589486592', 'HR1', 'HR040600', '质量行政', 'Quality Administration', '人', '2', '1630827968328765440', 0, '/1630785662485663744/1630827968328765440/1630828799589486592', '/人力资源类/质量体系人员/质量行政', '/HR/HR040000/HR040600', NULL, 6, '0', '1', '1', '2023-03-01 15:14:20', '1', '2023-03-01 15:14:20');
INSERT INTO `qf_subject_international_info` VALUES ('1630828800193466368', 'HR1', 'HR050100', 'R&D管理', 'R&D Management', '人', '2', '1630827969050185728', 0, '/1630785662485663744/1630827969050185728/1630828800193466368', '/人力资源类/产品开发人员/R&D管理', '/HR/HR050000/HR050100', NULL, 1, '0', '1', '1', '2023-03-01 15:14:20', '1', '2023-03-01 15:14:20');
INSERT INTO `qf_subject_international_info` VALUES ('1630828800864555008', 'HR1', 'HR050200', 'R&D工程', 'R&D Engineering', '人', '2', '1630827969050185728', 0, '/1630785662485663744/1630827969050185728/1630828800864555008', '/人力资源类/产品开发人员/R&D工程', '/HR/HR050000/HR050200', NULL, 2, '0', '1', '1', '2023-03-01 15:14:20', '1', '2023-03-01 15:14:20');
INSERT INTO `qf_subject_international_info` VALUES ('1630828801460146176', 'HR1', 'HR050300', '项目管理', 'Project Management', '人', '2', '1630827969050185728', 0, '/1630785662485663744/1630827969050185728/1630828801460146176', '/人力资源类/产品开发人员/项目管理', '/HR/HR050000/HR050300', NULL, 3, '0', '1', '1', '2023-03-01 15:14:20', '1', '2023-03-01 15:14:20');
INSERT INTO `qf_subject_international_info` VALUES ('1630828802219315200', 'HR1', 'HR050400', 'R & D CAD', 'R & D CAD', '人', '2', '1630827969050185728', 0, '/1630785662485663744/1630827969050185728/1630828802219315200', '/人力资源类/产品开发人员/R & D CAD', '/HR/HR050000/HR050400', NULL, 4, '0', '1', '1', '2023-03-01 15:14:20', '1', '2023-03-01 15:14:21');
INSERT INTO `qf_subject_international_info` VALUES ('1630828802789740544', 'HR1', 'HR050500', '实验室', 'Laboratory', '人', '2', '1630827969050185728', 0, '/1630785662485663744/1630827969050185728/1630828802789740544', '/人力资源类/产品开发人员/实验室', '/HR/HR050000/HR050500', NULL, 5, '0', '1', '1', '2023-03-01 15:14:21', '1', '2023-03-01 15:14:21');
INSERT INTO `qf_subject_international_info` VALUES ('1630828803360165888', 'HR1', 'HR030100s', '其中非全职人员', 'thereof PTE', '人', '2', '1630827977157775360', 0, '/1630785662485663744/1630827977157775360/1630828803360165888', '/人力资源类/支付薪酬人员总数/其中非全职人员', '/HR/HR030000s/HR030100s', NULL, 1, '0', '1', '1', '2023-03-01 15:14:21', '1', '2023-03-01 15:14:21');
INSERT INTO `qf_subject_international_info` VALUES ('1630828803968339968', 'HR1', 'HR040100s', '其中非全职人员', 'thereof PTE', '人', '2', '1630827981914116096', 0, '/1630785662485663744/1630827981914116096/1630828803968339968', '/人力资源类/未支付薪酬人员总数/其中非全职人员', '/HR/HR040000s/HR040100s', NULL, 1, '0', '1', '1', '2023-03-01 15:14:21', '1', '2023-03-01 15:14:21');
INSERT INTO `qf_subject_international_info` VALUES ('1630828804610068480', 'HR1', 'HR050100s', '其中非全职人员', 'thereof PTE', '人', '2', '1630827982618759168', 0, '/1630785662485663744/1630827982618759168/1630828804610068480', '/人力资源类/总人数/其中非全职人员', '/HR/HR050000s/HR050100s', NULL, 1, '0', '1', '1', '2023-03-01 15:14:21', '1', '2023-03-01 15:14:21');
INSERT INTO `qf_subject_international_info` VALUES ('1631534413055660032', 'IN1', 'IN010000', '拥有国际发明专利', 'International invention patent', '个', '1', '1630812037636558848', 0, '/1630812037636558848/1631534413055660032', '/投资类/拥有国际发明专利', '/INV/IN010000', NULL, 1, '0', '1', '1', '2023-03-03 13:58:11', '1', '2023-03-03 13:58:11');
INSERT INTO `qf_subject_international_info` VALUES ('1631534414615941120', 'IN1', 'IN020000', '国内发明专利', 'Domestic invention patent', '个', '1', '1630812037636558848', 0, '/1630812037636558848/1631534414615941120', '/投资类/国内发明专利', '/INV/IN020000', NULL, 2, '0', '1', '1', '2023-03-03 13:58:12', '1', '2023-03-03 13:58:12');
INSERT INTO `qf_subject_international_info` VALUES ('1631534415278641152', 'IN1', 'IN030000', '实用新型专利', 'Utility model patent', '个', '1', '1630812037636558848', 0, '/1630812037636558848/1631534415278641152', '/投资类/实用新型专利', '/INV/IN030000', NULL, 3, '0', '1', '1', '2023-03-03 13:58:12', '1', '2023-03-03 13:58:12');
INSERT INTO `qf_subject_international_info` VALUES ('1631534415974895616', 'IN1', 'IN040000', '外观设计专利', 'Design patent', '个', '1', '1630812037636558848', 0, '/1630812037636558848/1631534415974895616', '/投资类/外观设计专利', '/INV/IN040000', NULL, 4, '0', '1', '1', '2023-03-03 13:58:12', '1', '2023-03-03 13:58:12');
INSERT INTO `qf_subject_international_info` VALUES ('1631534704282963968', 'OP1', 'OP110000', '布伦特原油指数', 'Brent crude index', '美元/桶', '1', '1630786034092609536', 0, '/1630786034092609536/1631534704282963968', '/运营类/布伦特原油指数', '/OP/OP110000', NULL, 1, '0', '1', '1', '2023-03-03 13:59:21', '1', '2023-03-03 13:59:21');
INSERT INTO `qf_subject_international_info` VALUES ('1631534705142796288', 'OP1', 'OP120000', '电力（EEX)', 'Electric power（EEX)', '欧元/兆瓦时', '1', '1630786034092609536', 0, '/1630786034092609536/1631534705142796288', '/运营类/电力（EEX)', '/OP/OP120000', NULL, 2, '0', '1', '1', '2023-03-03 13:59:21', '1', '2023-03-03 13:59:21');
INSERT INTO `qf_subject_international_info` VALUES ('1631534706250092544', 'OP1', 'OP130000', '天然气(TTF）', 'Natural gas(TTF）', '欧元/兆瓦时', '1', '1630786034092609536', 0, '/1630786034092609536/1631534706250092544', '/运营类/天然气(TTF）', '/OP/OP130000', NULL, 3, '0', '1', '1', '2023-03-03 13:59:21', '1', '2023-03-03 13:59:21');
INSERT INTO `qf_subject_international_info` VALUES ('1631534707097341952', 'OP1', 'OP140000', '欧盟通胀指数', 'Eu inflation index', '%', '1', '1630786034092609536', 0, '/1630786034092609536/1631534707097341952', '/运营类/欧盟通胀指数', '/OP/OP140000', NULL, 4, '0', '1', '1', '2023-03-03 13:59:21', '1', '2023-03-03 13:59:21');
INSERT INTO `qf_subject_international_info` VALUES ('1631534708099780608', 'OP1', 'OP150000', '欧元汇率、特殊波动汇率', 'Euro exchange rate', '欧元/人民币', '1', '1630786034092609536', 0, '/1630786034092609536/1631534708099780608', '/运营类/欧元汇率、特殊波动汇率', '/OP/OP150000', NULL, 5, '0', '1', '1', '2023-03-03 13:59:22', '1', '2023-03-03 13:59:22');
INSERT INTO `qf_subject_international_info` VALUES ('1631534710406647808', 'OP1', 'OP160000', '全球汽车生产销售数据', 'Global car production and sales data', '辆', '1', '1630786034092609536', 0, '/1630786034092609536/1631534710406647808', '/运营类/全球汽车生产销售数据', '/OP/OP160000', NULL, 6, '0', '1', '1', '2023-03-03 13:59:22', '1', '2023-03-03 13:59:22');
INSERT INTO `qf_subject_international_info` VALUES ('1631534711723659264', 'OP1', 'OP170000', '中国汽车生产销售数据', 'Chinese car production and sales data', '辆', '1', '1630786034092609536', 0, '/1630786034092609536/1631534711723659264', '/运营类/中国汽车生产销售数据', '/OP/OP170000', NULL, 7, '0', '1', '1', '2023-03-03 13:59:22', '1', '2023-03-03 13:59:22');
INSERT INTO `qf_subject_international_info` VALUES ('1631534712579297280', 'OP1', 'OP180000', '欧洲汽车生产销售数据', 'European car production and sales data', '辆', '1', '1630786034092609536', 0, '/1630786034092609536/1631534712579297280', '/运营类/欧洲汽车生产销售数据', '/OP/OP180000', NULL, 8, '0', '1', '1', '2023-03-03 13:59:23', '1', '2023-03-03 13:59:23');
INSERT INTO `qf_subject_international_info` VALUES ('1631534714932301824', 'OP1', 'OP190000', '美洲汽车生产销售数据', 'Americas car production and sales data', '辆', '1', '1630786034092609536', 0, '/1630786034092609536/1631534714932301824', '/运营类/美洲汽车生产销售数据', '/OP/OP190000', NULL, 9, '0', '1', '1', '2023-03-03 13:59:23', '1', '2023-03-03 13:59:23');
INSERT INTO `qf_subject_international_info` VALUES ('1631534716702298112', 'OP2', 'OP210000', 'EBITDA数', 'EBITDA', '€', '1', '1630786034092609536', 7, '/1630786034092609536/1631534716702298112', '/运营类/EBITDA数', '/OP/OP210000', NULL, 10, '0', '1', '1', '2023-03-03 13:59:24', '1', '2023-03-03 14:00:08');
INSERT INTO `qf_subject_international_info` VALUES ('1631534898688954368', 'OP2', 'OP211000', '原材料', 'Material', '€', '2', '1631534716702298112', 0, '/1630786034092609536/1631534716702298112/1631534898688954368', '/运营类/EBITDA数/原材料', '/OP/OP210000/OP211000', NULL, 1, '0', '1', '1', '2023-03-03 14:00:07', '1', '2023-03-03 14:00:07');
INSERT INTO `qf_subject_international_info` VALUES ('1631534899422957568', 'OP2', 'OP212000', '劳工', 'Labour', '€', '2', '1631534716702298112', 0, '/1630786034092609536/1631534716702298112/1631534899422957568', '/运营类/EBITDA数/劳工', '/OP/OP210000/OP212000', NULL, 2, '0', '1', '1', '2023-03-03 14:00:07', '1', '2023-03-03 14:00:07');
INSERT INTO `qf_subject_international_info` VALUES ('1631534900127600640', 'OP2', 'OP213000', '变动管理费用', 'Var. OH', '€', '2', '1631534716702298112', 0, '/1630786034092609536/1631534716702298112/1631534900127600640', '/运营类/EBITDA数/变动管理费用', '/OP/OP210000/OP213000', NULL, 3, '0', '1', '1', '2023-03-03 14:00:07', '1', '2023-03-03 14:00:07');
INSERT INTO `qf_subject_international_info` VALUES ('1631534900794494976', 'OP2', 'OP214000', '模具成本', 'Tooling Costs', '€', '2', '1631534716702298112', 0, '/1630786034092609536/1631534716702298112/1631534900794494976', '/运营类/EBITDA数/模具成本', '/OP/OP210000/OP214000', NULL, 4, '0', '1', '1', '2023-03-03 14:00:08', '1', '2023-03-03 14:00:08');
INSERT INTO `qf_subject_international_info` VALUES ('1631534901461389312', 'OP2', 'OP215000', '固定管理费用', 'Fixed OH', '€', '2', '1631534716702298112', 0, '/1630786034092609536/1631534716702298112/1631534901461389312', '/运营类/EBITDA数/固定管理费用', '/OP/OP210000/OP215000', NULL, 5, '0', '1', '1', '2023-03-03 14:00:08', '1', '2023-03-03 14:00:08');
INSERT INTO `qf_subject_international_info` VALUES ('1631534902086340608', 'OP2', 'OP216000', '影响数', 'effect mixed measures on EBITDA EBITDA', '€', '2', '1631534716702298112', 0, '/1630786034092609536/1631534716702298112/1631534902086340608', '/运营类/EBITDA数/影响数', '/OP/OP210000/OP216000', NULL, 6, '0', '1', '1', '2023-03-03 14:00:08', '1', '2023-03-03 14:00:08');
INSERT INTO `qf_subject_international_info` VALUES ('1631534902719680512', 'OP2', 'OP217000', '销售额', 'Sales', '€', '2', '1631534716702298112', 2, '/1630786034092609536/1631534716702298112/1631534902719680512', '/运营类/EBITDA数/销售额', '/OP/OP210000/OP217000', NULL, 7, '0', '1', '1', '2023-03-03 14:00:08', '1', '2023-03-03 14:00:40');
INSERT INTO `qf_subject_international_info` VALUES ('1631535037746909184', 'OP2', 'OP217100', '产品销售', 'Product Sales', '€', '3', '1631534902719680512', 0, '/1630786034092609536/1631534716702298112/1631534902719680512/1631535037746909184', '/运营类/EBITDA数/销售额/产品销售', '/OP/OP210000/OP217000/OP217100', NULL, 1, '0', '1', '1', '2023-03-03 14:00:40', '1', '2023-03-03 14:00:40');
INSERT INTO `qf_subject_international_info` VALUES ('1631535038438969344', 'OP2', 'OP217200', '模具销售', 'Tooling Sales', '€', '3', '1631534902719680512', 0, '/1630786034092609536/1631534716702298112/1631534902719680512/1631535038438969344', '/运营类/EBITDA数/销售额/模具销售', '/OP/OP210000/OP217000/OP217200', NULL, 2, '0', '1', '1', '2023-03-03 14:00:40', '1', '2023-03-03 14:00:40');
INSERT INTO `qf_subject_international_info` VALUES ('1632672203382329344', 'RS1', 'RS', '财务-报告类', 'RS', '€', '1', '0', 24, '/1632672203382329344', '/财务-报告类', '/RS', '', 1, '0', '1', '1', '2023-03-06 17:19:22', '1', '2023-03-07 09:27:08');
INSERT INTO `qf_subject_international_info` VALUES ('1632672434954047488', 'RS1', 'RS1000', '外部产品销售', 'Sales External', '€', '2', '1632672203382329344', 0, '/1632672203382329344/1632672434954047488', '/财务-报告类/外部产品销售', '/RS/RS1000', '', 1, '0', '1', '1', '2023-03-06 17:20:17', '1', '2023-03-06 17:20:17');
INSERT INTO `qf_subject_international_info` VALUES ('1632672597521076224', 'RS1', 'RS1100', '外部产品销售汇总', 'Total Sales External', '€', '2', '1632672203382329344', 0, '/1632672203382329344/1632672597521076224', '/财务-报告类/外部产品销售汇总', '/RS/RS1100', '', 2, '0', '1', '1', '2023-03-06 17:20:56', '1', '2023-03-07 09:27:08');
INSERT INTO `qf_subject_international_info` VALUES ('1632672706984022016', 'RS1', 'RS2000', '内部产品销售', 'Sales Internal', '€', '2', '1632672203382329344', 0, '/1632672203382329344/1632672706984022016', '/财务-报告类/内部产品销售', '/RS/RS2000', '', 3, '0', '1', '1', '2023-03-06 17:21:22', '1', '2023-03-06 17:21:22');
INSERT INTO `qf_subject_international_info` VALUES ('1632673175944957952', 'RS1', 'RS3000', '内部工装模具销售', 'Sales Tooling (external)', '€', '2', '1632672203382329344', 0, '/1632672203382329344/1632673175944957952', '/财务-报告类/内部工装模具销售', '/RS/RS3000', '', 4, '0', '1', '1', '2023-03-06 17:23:13', '1', '2023-03-06 17:23:14');
INSERT INTO `qf_subject_international_info` VALUES ('1632673296187265024', 'RS1', 'RS5000', '直接材料', 'Direct Materials (+/- share in stock change)', '€', '2', '1632672203382329344', 0, '/1632672203382329344/1632673296187265024', '/财务-报告类/直接材料', '/RS/RS5000', '', 5, '0', '1', '1', '2023-03-06 17:23:42', '1', '2023-03-06 17:23:42');
INSERT INTO `qf_subject_international_info` VALUES ('1632673404136067072', 'RS1', 'RS6000', '直接人工', 'Direct Labour (+/- share in stock change)', '€', '2', '1632672203382329344', 0, '/1632672203382329344/1632673404136067072', '/财务-报告类/直接人工', '/RS/RS6000', '', 6, '0', '1', '1', '2023-03-06 17:24:08', '1', '2023-03-06 17:24:08');
INSERT INTO `qf_subject_international_info` VALUES ('1632673539725332480', 'RS1', 'RS7000', '变动制造费用', 'Variable Overheads (+/- share in stock change)', '€', '2', '1632672203382329344', 0, '/1632672203382329344/1632673539725332480', '/财务-报告类/变动制造费用', '/RS/RS7000', '', 7, '0', '1', '1', '2023-03-06 17:24:40', '1', '2023-03-06 17:24:40');
INSERT INTO `qf_subject_international_info` VALUES ('1632673623166816256', 'RS1', 'RS8000', '工装模具成本', 'Tooling Costs', '€', '2', '1632672203382329344', 0, '/1632672203382329344/1632673623166816256', '/财务-报告类/工装模具成本', '/RS/RS8000', '', 8, '0', '1', '1', '2023-03-06 17:25:00', '1', '2023-03-06 17:25:00');
INSERT INTO `qf_subject_international_info` VALUES ('1632673742721257472', 'RS1', 'RS9000', '管理费用', 'Overheads', '€', '2', '1632672203382329344', 0, '/1632672203382329344/1632673742721257472', '/财务-报告类/管理费用', '/RS/RS9000', '', 9, '0', '1', '1', '2023-03-06 17:25:29', '1', '2023-03-07 08:57:06');
INSERT INTO `qf_subject_international_info` VALUES ('1632673830667423744', 'RS1', 'RS1010', '直接利润', 'Direct Profit / (Loss)', '€', '2', '1632672203382329344', 0, '/1632672203382329344/1632673830667423744', '/财务-报告类/直接利润', '/RS/RS1010', '', 10, '0', '1', '1', '2023-03-06 17:25:50', '1', '2023-03-06 17:25:50');
INSERT INTO `qf_subject_international_info` VALUES ('1632905850995740672', 'RS1', 'RS2100', '内部产品销售汇总', 'Total Sales Internal', '€', '2', '1632672203382329344', 0, '/1632672203382329344/1632905850995740672', '/财务-报告类/内部产品销售汇总', '/RS/RS2100', '', 11, '0', '1', '1', '2023-03-07 08:47:47', '1', '2023-03-07 08:47:48');
INSERT INTO `qf_subject_international_info` VALUES ('1632906177241288704', 'RS1', 'RS3100', '外部工装模具销售汇总', 'Total Sales Tooling (external)', '€', '2', '1632672203382329344', 0, '/1632672203382329344/1632906177241288704', '/财务-报告类/外部工装模具销售汇总', '/RS/RS3100', '', 12, '0', '1', '1', '2023-03-07 08:49:05', '1', '2023-03-07 08:49:05');
INSERT INTO `qf_subject_international_info` VALUES ('1632906371303346176', 'RS1', 'RS4100', '内部工装模具销售汇总', 'Total Sales Tooling (internal)', '€', '2', '1632672203382329344', 0, '/1632672203382329344/1632906371303346176', '/财务-报告类/内部工装模具销售汇总', '/RS/RS4100', '', 13, '0', '1', '1', '2023-03-07 08:49:52', '1', '2023-03-07 08:49:52');
INSERT INTO `qf_subject_international_info` VALUES ('1632906612807176192', 'RS1', 'RS5100', '直接材料汇总', 'Total Direct Materials (+/- share in stock change)', '€', '2', '1632672203382329344', 0, '/1632672203382329344/1632906612807176192', '/财务-报告类/直接材料汇总', '/RS/RS5100', '', 14, '0', '1', '1', '2023-03-07 08:50:49', '1', '2023-03-07 08:50:49');
INSERT INTO `qf_subject_international_info` VALUES ('1632906760803192832', 'RS1', 'RS6100', '直接人工汇总', 'Total Direct Labour (+/- share in stock change)', '€', '2', '1632672203382329344', 0, '/1632672203382329344/1632906760803192832', '/财务-报告类/直接人工汇总', '/RS/RS6100', '', 15, '0', '1', '1', '2023-03-07 08:51:24', '1', '2023-03-07 08:51:25');
INSERT INTO `qf_subject_international_info` VALUES ('1632907001292001280', 'RS1', 'RS7100', '变动制造费用汇总', 'Total Variable Overheads (+/- share in stock change)', '€', '2', '1632672203382329344', 0, '/1632672203382329344/1632907001292001280', '/财务-报告类/变动制造费用汇总', '/RS/RS7100', '', 16, '0', '1', '1', '2023-03-07 08:52:22', '1', '2023-03-07 08:52:22');
INSERT INTO `qf_subject_international_info` VALUES ('1632907135388094464', 'RS1', 'RS8100', '工装模具成本汇总', 'Total Tooling Costs', '€', '2', '1632672203382329344', 0, '/1632672203382329344/1632907135388094464', '/财务-报告类/工装模具成本汇总', '/RS/RS8100', '', 17, '0', '1', '1', '2023-03-07 08:52:54', '1', '2023-03-07 08:52:54');
INSERT INTO `qf_subject_international_info` VALUES ('1632908299261317120', 'RS1', 'RS9100', '管理费用汇总', 'Total Overheads', '€', '2', '1632672203382329344', 0, '/1632672203382329344/1632908299261317120', '/财务-报告类/管理费用汇总', '/RS/RS9100', '', 18, '0', '1', '1', '2023-03-07 08:57:31', '1', '2023-03-07 08:57:31');
INSERT INTO `qf_subject_international_info` VALUES ('1632908431570636800', 'RS1', 'RS1110', '直接利润汇总', 'Total Direct Profit / (Loss)', '€', '2', '1632672203382329344', 0, '/1632672203382329344/1632908431570636800', '/财务-报告类/直接利润汇总', '/RS/RS1110', '', 19, '0', '1', '1', '2023-03-07 08:58:03', '1', '2023-03-07 08:58:03');
INSERT INTO `qf_subject_international_info` VALUES ('1632908605596504064', 'RS1', 'RS2110', '息税折旧摊销前利润汇总', 'Total EBITDA', '€', '2', '1632672203382329344', 0, '/1632672203382329344/1632908605596504064', '/财务-报告类/息税折旧摊销前利润汇总', '/RS/RS2110', '', 20, '0', '1', '1', '2023-03-07 08:58:44', '1', '2023-03-07 08:58:44');
INSERT INTO `qf_subject_international_info` VALUES ('1632908890968559616', 'RS1', 'RS2010', '息税折旧摊销前利润(报告类)', 'EBITDA（RS）', '€', '2', '1632672203382329344', 0, '/1632672203382329344/1632908890968559616', '/财务-报告类/息税折旧摊销前利润(报告类)', '/RS/RS2010', '', 21, '0', '1', '1', '2023-03-07 08:59:52', '1', '2023-03-07 08:59:52');
INSERT INTO `qf_subject_international_info` VALUES ('1632909091036860416', 'RS1', 'RS3010', '息税前利润（报告类）', 'EBIT（RS）', '€', '2', '1632672203382329344', 0, '/1632672203382329344/1632909091036860416', '/财务-报告类/息税前利润（报告类）', '/RS/RS3010', '', 22, '0', '1', '1', '2023-03-07 09:00:40', '1', '2023-03-07 09:00:40');
INSERT INTO `qf_subject_international_info` VALUES ('1632909279314972672', 'RS1', 'RS3110', '息税前利润汇总', 'Total EBIT', '€', '2', '1632672203382329344', 0, '/1632672203382329344/1632909279314972672', '/财务-报告类/利润总额（不包括汇兑损益、股利等）汇总', '/RS/RS3110', '', 23, '0', '1', '1', '2023-03-07 09:01:25', '1', '2023-03-07 09:02:37');
INSERT INTO `qf_subject_international_info` VALUES ('1632909740533223424', 'RS1', 'RS4110', '利润总额（不包括汇兑损益、股利等）汇总', 'Total Adj. EBT (w/o exchange effects, dividends,PLTA)', '€', '2', '1632672203382329344', 0, '/1632672203382329344/1632909740533223424', '/财务-报告类/利润总额（不包括汇兑损益、股利等）汇总', '/RS/RS4110', '', 24, '0', '1', '1', '2023-03-07 09:03:15', '1', '2023-03-07 09:03:15');
INSERT INTO `qf_subject_international_info` VALUES ('1633378617595662336', 'HR1', 'HR140100', '间接合同雇员', 'Contractual Employees indirect', '人', '3', '1630827976516046848', 0, '/1630785662485663744/1630827976516046848/1633378617595662336', '/人力资源类/其他有合同关系的人员/间接合同雇员', '/HR/HR140000/HR140100', '', 1, '0', '1', '1', '2023-03-08 16:06:24', '1', '2023-03-08 16:06:24');
INSERT INTO `qf_subject_international_info` VALUES ('1633378766074023936', 'HR1', 'HR140200', '直接合同雇员', 'Contractual Employees direct', '人', '3', '1630827976516046848', 0, '/1630785662485663744/1630827976516046848/1633378766074023936', '/人力资源类/其他有合同关系的人员/直接合同雇员', '/HR/HR140000/HR140200', '', 2, '0', '1', '1', '2023-03-08 16:06:59', '1', '2023-03-08 16:06:59');

-- ----------------------------
-- Table structure for qf_subject_relation
-- ----------------------------
DROP TABLE IF EXISTS `qf_subject_relation`;
CREATE TABLE `qf_subject_relation`  (
  `id_` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '主键ID',
  `inter_code_` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '国际科目编码',
  `inter_id_` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '国际科目ID',
  `sub_id_` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '国内科目ID',
  `sub_code_` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '国内科目编码',
  `expression_` varchar(500) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '国际科目转换公式',
  PRIMARY KEY (`id_`) USING BTREE
) ENGINE = oceanbase CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '国内外科目对应关系' ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of qf_subject_relation
-- ----------------------------
INSERT INTO `qf_subject_relation` VALUES ('1633360796224458752', '123102', '1630825876063129600', '1633360681195671552', 'BS10000', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796232847360', '123103', '1630825876641943552', '1633360681195671552', 'BS10000', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796232847361', '123105', '1630825877887651840', '1633360681195671552', 'BS10000', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796232847362', '122518', '1630825873269723136', '1633360682680455168', 'BS10001', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796232847363', '122114', '1630825833499332608', '1633360686312722432', 'BS10004', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796232847364', '122101', '1630825829342777344', '1633360686870564864', 'BS10005', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796232847365', '122102', '1630825829934174208', '1633360686870564864', 'BS10005', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796237041664', '122103', '1630825830512988160', '1633360686870564864', 'BS10005', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796237041665', '122106', '1630825831741919232', '1633360686870564864', 'BS10005', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796237041666', '122112', '1630825832320733184', '1633360686870564864', 'BS10005', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796237041667', '122113', '1630825832907935744', '1633360686870564864', 'BS10005', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796237041668', '131102', '1630825835281911808', '1633360687461961728', 'BS10006', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796237041669', '131104', '1630825835932028928', '1633360687461961728', 'BS10006', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796237041670', '131105', '1630825836498259968', '1633360687461961728', 'BS10006', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796237041671', '131106', '1630825837085462528', '1633360687461961728', 'BS10006', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796241235968', '131107', '1630825837639110656', '1633360687461961728', 'BS10006', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796241235969', '131109', '1630825838243090432', '1633360687461961728', 'BS10006', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796241235970', '122451', '1630825575620939776', '1633360687461961728', 'BS10006', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796241235971', '122504', '1630826761107410944', '1633360688086913024', 'BS10007', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796241235972', '122505', '1630826761703002112', '1633360688086913024', 'BS10007', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796241235973', '122506', '1630826762306981888', '1633360688086913024', 'BS10007', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796241235974', '122507', '1630826762919350272', '1633360688086913024', 'BS10007', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796245430272', '122508', '1630826763506552832', '1633360688086913024', 'BS10007', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796245430273', '122510', '1630826764668375040', '1633360688086913024', 'BS10007', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796245430274', '122511', '1630825809239478272', '1633360688086913024', 'BS10007', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796245430275', '122514', '1630826765276549120', '1633360688086913024', 'BS10007', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796245430276', '122516', '1630826766744555520', '1633360688086913024', 'BS10007', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796245430277', '122517', '1630826767314980864', '1633360688086913024', 'BS10007', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796249624576', '122520', '1630826767897989120', '1633360688086913024', 'BS10007', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796249624577', '122528', '1630826768472608768', '1633360688086913024', 'BS10007', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796249624578', '122511', '1630825809239478272', '1633360688086913024', 'BS10007', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796249624579', '121110', '1630825814243282944', '1633360688804139008', 'BS10008', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796249624580', '121111', '1630825814901788672', '1633360688804139008', 'BS10008', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796249624581', '121120', '1630825815468019712', '1633360688804139008', 'BS10008', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796249624582', '121121', '1630825816000696320', '1633360688804139008', 'BS10008', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796253818880', '121210', '1630825816558538752', '1633360688804139008', 'BS10008', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796253818881', '121211', '1630825817145741312', '1633360688804139008', 'BS10008', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796253818882', '121220', '1630825817917493248', '1633360688804139008', 'BS10008', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796253818883', '121230', '1630825818559221760', '1633360688804139008', 'BS10008', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796253818884', '121310', '1630825820090142720', '1633360688804139008', 'BS10008', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796253818885', '121311', '1630825820660568064', '1633360688804139008', 'BS10008', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796253818886', '121410', '1630825821210021888', '1633360688804139008', 'BS10008', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796253818887', '121411', '1630825821814001664', '1633360688804139008', 'BS10008', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796253818888', '121510', '1630825822430564352', '1633360688804139008', 'BS10008', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796253818889', '121520', '1630825824938758144', '1633360688804139008', 'BS10008', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796253818890', '121610', '1630825827006550016', '1633360688804139008', 'BS10008', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796262207488', '121710', '1630825828600385536', '1633360688804139008', 'BS10008', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796262207489', '121100', '1630825566250864640', '1633360689336815616', 'BS10009', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796262207490', '121110', '1630825814243282944', '1633360689336815616', 'BS10009', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796262207491', '121111', '1630825814901788672', '1633360689336815616', 'BS10009', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796262207492', '121120', '1630825815468019712', '1633360689336815616', 'BS10009', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796262207493', '121121', '1630825816000696320', '1633360689336815616', 'BS10009', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796266401792', '121300', '1630825567421075456', '1633360689848520704', 'BS10010', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796266401793', '121310', '1630825820090142720', '1633360689848520704', 'BS10010', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796266401794', '121311', '1630825820660568064', '1633360689848520704', 'BS10010', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796266401795', '122532', '1630825811068194816', '1633360690406363136', 'BS10011', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796266401796', '122104', '1630825831146328064', '1633360690406363136', 'BS10011', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796266401797', '122509', '1630826764068589568', '1633360692037947392', 'BS10014', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796266401798', '122503', '1630826769080782848', '1633360692037947392', 'BS10014', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796266401799', '122524', '1630826769659596800', '1633360692037947392', 'BS10014', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796270596096', '122501', '1630825871961100288', '1633360692037947392', 'BS10014', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796270596097', '122502', '1630825872644771840', '1633360692037947392', 'BS10014', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796270596098', '113401', '1630825808669052928', '1633360698111299584', 'BS10022', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796270596099', '112110', '1630825771507519488', '1633360700078428160', 'BS10025', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796270596100', '112120', '1630825772086333440', '1633360700078428160', 'BS10025', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796270596101', '112130', '1630825772702896128', '1633360700078428160', 'BS10025', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796270596102', '112111', '1630825773290098688', '1633360700078428160', 'BS10025', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796274790400', '112121', '1630825773881495552', '1633360700078428160', 'BS10025', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796274790401', '112112', '1630825774468698112', '1633360700078428160', 'BS10025', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796274790402', '112122', '1630825775051706368', '1633360700078428160', 'BS10025', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796274790403', '112210', '1630825775685046272', '1633360700078428160', 'BS10025', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796274790404', '112213', '1630825776289026048', '1633360700078428160', 'BS10025', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796274790405', '112220', '1630825776867840000', '1633360700078428160', 'BS10025', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796274790406', '112211', '1630825777417293824', '1633360700078428160', 'BS10025', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796278984704', '112221', '1630825777975136256', '1633360700078428160', 'BS10025', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796278984705', '112212', '1630825778574921728', '1633360700078428160', 'BS10025', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796278984706', '112222', '1630825779325702144', '1633360700078428160', 'BS10025', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796278984707', '112310', '1630825779933876224', '1633360700078428160', 'BS10025', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796278984708', '112320', '1630825780550438912', '1633360700078428160', 'BS10025', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796278984709', '112330', '1630825781154418688', '1633360700078428160', 'BS10025', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796278984710', '112340', '1630825781745815552', '1633360700078428160', 'BS10025', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796283179008', '112311', '1630825782349795328', '1633360700078428160', 'BS10025', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796283179009', '112321', '1630825782936997888', '1633360700078428160', 'BS10025', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796283179010', '112331', '1630825783511617536', '1633360700078428160', 'BS10025', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796283179011', '112341', '1630825784090431488', '1633360700078428160', 'BS10025', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796283179012', '112312', '1630825784694411264', '1633360700078428160', 'BS10025', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796283179013', '112332', '1630825785298391040', '1633360700078428160', 'BS10025', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796283179014', '112410', '1630825785881399296', '1633360700653047808', 'BS10026', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796283179015', '112420', '1630825786435047424', '1633360700653047808', 'BS10026', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796283179016', '111950', '1630825787026444288', '1633360702364323840', 'BS10029', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796283179017', '111951', '1630825787601063936', '1633360702364323840', 'BS10029', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796283179018', '111953', '1630825788301512704', '1633360702364323840', 'BS10029', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796283179019', '111954', '1630825788960018432', '1633360702364323840', 'BS10029', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796283179020', '111956', '1630825789551415296', '1633360702364323840', 'BS10029', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796287373312', '111957', '1630825790184755200', '1633360702364323840', 'BS10029', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796287373313', '111958', '1630825790767763456', '1633360702364323840', 'BS10029', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796287373314', '112510', '1630825791329800192', '1633360702364323840', 'BS10029', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796287373315', '112511', '1630825791908614144', '1633360702364323840', 'BS10029', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796287373316', '111110', '1630825760723963904', '1633360702901194752', 'BS10030', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796287373317', '111111', '1630825761302777856', '1633360702901194752', 'BS10030', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796287373318', '111310', '1630825762049363968', '1633360702901194752', 'BS10030', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796287373319', '111311', '1630825762712064000', '1633360702901194752', 'BS10030', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796287373320', '111510', '1630825763567702016', '1633360702901194752', 'BS10030', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796291567616', '111511', '1630825764519809024', '1633360702901194752', 'BS10030', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796291567617', '111610', '1630825765073457152', '1633360702901194752', 'BS10030', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796291567618', '111611', '1630825765715185664', '1633360702901194752', 'BS10030', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796291567619', '111612', '1630825766440800256', '1633360702901194752', 'BS10030', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796291567620', '111710', '1630825767044780032', '1633360702901194752', 'BS10030', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796291567621', '111711', '1630825767611011072', '1633360702901194752', 'BS10030', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796295761920', '111810', '1630825768240156672', '1633360702901194752', 'BS10030', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796295761921', '111811', '1630825769775271936', '1633360702901194752', 'BS10030', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796295761922', '111901', '1630825770349891584', '1633360704016879616', 'BS10032', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796295761923', '111902', '1630825770928705536', '1633360704016879616', 'BS10032', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796299956224', '141110', '1630825813131792384', '1633360705216450560', 'BS10034', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796299956225', '141112', '1630825813668663296', '1633360705216450560', 'BS10034', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796299956226', '112430', '1630825553160441856', '1633360705774292992', 'BS10035', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796299956227', '112590', '1630825808090238976', '1633360705774292992', 'BS10035', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796299956228', '122512', '1630825809847652352', '1633360705774292992', 'BS10035', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796299956229', '122513', '1630825810480992256', '1633360705774292992', 'BS10035', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796299956230', '122531', '1630825811659591680', '1633360705774292992', 'BS10035', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796299956231', '231101', '1630825974868348928', '1633360707380711424', 'BS10038', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796304150528', '231102', '1630825975489105920', '1633360707380711424', 'BS10038', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796304150529', '231103', '1630825976088891392', '1633360707380711424', 'BS10038', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796304150530', '231104', '1630825976667705344', '1633360707380711424', 'BS10038', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796304150531', '236416', '1630825982451650560', '1633360707934359552', 'BS10039', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796304150532', '231106', '1630825977951162368', '1633360709565943808', 'BS10042', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796304150533', '233101', '1630825929691500544', '1633360710102814720', 'BS10043', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796304150534', '233102', '1630825930261925888', '1633360710102814720', 'BS10043', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796304150535', '233105', '1630825930832351232', '1633360710102814720', 'BS10043', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796308344832', '233107', '1630825931423748096', '1633360710102814720', 'BS10043', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796308344833', '233108', '1630825932040310784', '1633360710102814720', 'BS10043', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796308344834', '233110', '1630825932656873472', '1633360710102814720', 'BS10043', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796308344835', '233112', '1630825933877415936', '1633360710102814720', 'BS10043', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796308344836', '233106', '1630825593148936192', '1633360710102814720', 'BS10043', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796308344837', '233201', '1630825934519144448', '1633360710102814720', 'BS10043', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796308344838', '232103', '1630825928328351744', '1633360711218499584', 'BS10045', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796308344839', '232104', '1630825928957497344', '1633360711218499584', 'BS10045', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796308344840', '236201', '1630825941603323904', '1633360711755370496', 'BS10046', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796312539136', '236202', '1630825942182137856', '1633360711755370496', 'BS10046', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796312539137', '236203', '1630825942849032192', '1633360711755370496', 'BS10046', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796312539138', '236204', '1630825943453011968', '1633360711755370496', 'BS10046', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796312539139', '236301', '1630825944136683520', '1633360711755370496', 'BS10046', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796312539140', '236302', '1630825944765829120', '1633360711755370496', 'BS10046', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796312539141', '236303', '1630825945378197504', '1633360711755370496', 'BS10046', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796312539142', '236304', '1630825946003148800', '1633360711755370496', 'BS10046', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796316733440', '236305', '1630825946602934272', '1633360711755370496', 'BS10046', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796316733441', '236306', '1630825947181748224', '1633360711755370496', 'BS10046', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796316733442', '236307', '1630825947789922304', '1633360711755370496', 'BS10046', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796316733443', '236308', '1630825948393902080', '1633360711755370496', 'BS10046', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796316733444', '236309', '1630825949002076160', '1633360711755370496', 'BS10046', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796316733445', '236310', '1630825949610250240', '1633360711755370496', 'BS10046', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796316733446', '236314', '1630825950214230016', '1633360711755370496', 'BS10046', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796316733447', '236315', '1630825950818209792', '1633360711755370496', 'BS10046', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796316733448', '236317', '1630825951426383872', '1633360711755370496', 'BS10046', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796320927744', '236311', '1630825952026169344', '1633360711755370496', 'BS10046', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796320927745', '236312', '1630825952630149120', '1633360711755370496', 'BS10046', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796320927746', '236101', '1630825939095130112', '1633360712577454080', 'BS10047', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796320927747', '236103', '1630825939837521920', '1633360712577454080', 'BS10047', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796320927748', '236104', '1630825940407947264', '1633360712577454080', 'BS10047', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796320927749', '236102', '1630825941003538432', '1633360712577454080', 'BS10047', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796320927750', '234201', '1630825987275100160', '1633360712577454080', 'BS10047', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796320927751', '234202', '1630825987908440064', '1633360712577454080', 'BS10047', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796320927752', '233111', '1630825933256658944', '1633360713357594624', 'BS10048', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796325122048', '233202', '1630825935131512832', '1633360713357594624', 'BS10048', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796325122049', '233205', '1630825936075231232', '1633360713357594624', 'BS10048', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796325122050', '233206', '1630825936670822400', '1633360713357594624', 'BS10048', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796325122051', '233203', '1630825937882976256', '1633360713357594624', 'BS10048', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796325122052', '236402', '1630825953221545984', '1633360713357594624', 'BS10048', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796325122053', '236403', '1630825953800359936', '1633360713357594624', 'BS10048', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796325122054', '236405', '1630825954408534016', '1633360713357594624', 'BS10048', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796325122055', '236406', '1630825955033485312', '1633360713357594624', 'BS10048', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796329316352', '236409', '1630825955805237248', '1633360713357594624', 'BS10048', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796329316353', '236411', '1630825957050945536', '1633360713357594624', 'BS10048', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796329316354', '236413', '1630825957638148096', '1633360713357594624', 'BS10048', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796329316355', '236415', '1630825958250516480', '1633360713357594624', 'BS10048', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796329316356', '233208', '1630825981809922048', '1633360713357594624', 'BS10048', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796329316357', '233310', '1630825599763353600', '1633360713357594624', 'BS10048', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796329316358', '231105', '1630825977259102208', '1633360714670411776', 'BS10050', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796329316359', '231107', '1630825978571919360', '1633360714670411776', 'BS10050', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796333510656', '231108', '1630825979159121920', '1633360714670411776', 'BS10050', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796333510657', '231109', '1630825979712770048', '1633360714670411776', 'BS10050', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796333510658', '231110', '1630825980274806784', '1633360714670411776', 'BS10050', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796333510659', '222104', '1630825985412829184', '1633360715748347904', 'BS10051', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796333510660', '222105', '1630825986008420352', '1633360715748347904', 'BS10051', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796333510661', '222106', '1630825986658537472', '1633360715748347904', 'BS10051', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796333510662', '231201', '1630825891380727808', '1633360716981473280', 'BS10053', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796333510663', '231206', '1630825891955347456', '1633360718378176512', 'BS10055', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796333510664', '231210', '1630825892508995584', '1633360718378176512', 'BS10055', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796333510665', '231211', '1630825893096198144', '1633360718378176512', 'BS10055', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796333510666', '233308', '1630825894283186176', '1633360718948601856', 'BS10056', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796333510667', '233303', '1630825913186914304', '1633360718948601856', 'BS10056', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796333510668', '233306', '1630825915003047936', '1633360718948601856', 'BS10056', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796337704960', '237101', '1630825916907261952', '1633360718948601856', 'BS10056', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796337704961', '237405', '1630825924201156608', '1633360718948601856', 'BS10056', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796337704962', '234301', '1630825924796747776', '1633360718948601856', 'BS10056', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796337704963', '234302', '1630825925354590208', '1633360718948601856', 'BS10056', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796337704964', '221101', '1630825909550452736', '1633360719749713920', 'BS10057', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796337704965', '223104', '1630825910720663552', '1633360724887736320', 'BS10058', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796346093568', '223106', '1630825911370780672', '1633360724887736320', 'BS10058', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796346093569', '233309', '1630825916362002432', '1633360731007225856', 'BS10059', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796346093570', '233209', '1630825938482761728', '1633360731007225856', 'BS10059', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796346093571', '234101', '1630825925920821248', '1633360731728646144', 'BS10060', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796346093572', '234102', '1630825926478663680', '1633360731728646144', 'BS10060', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796346093573', '231209', '1630825893679206400', '1633360732370374656', 'BS10061', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796350287872', '211101', '1630825878466465792', '1633360734241034240', 'BS10064', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796350287873', '211102', '1630825879015919616', '1633360734241034240', 'BS10064', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796350287874', '212101', '1630825879586344960', '1633360735440605184', 'BS10066', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796350287875', '212102', '1630825880152576000', '1633360735440605184', 'BS10066', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796350287876', 'K3520', '1630825887240949760', '1633360736040390656', 'BS10067', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796350287877', '212111', '1630825887823958016', '1633360736040390656', 'BS10067', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796350287878', '212112', '1630825888369217536', '1633360736040390656', 'BS10067', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796350287879', '212106', '1630825888910282752', '1633360736040390656', 'BS10067', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796350287880', '212107', '1630825889568788480', '1633360736040390656', 'BS10067', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796350287881', '212105', '1630825890277625856', '1633360736656953344', 'BS10068', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796354482176', '213101', '1630825880739778560', '1633360737445482496', 'BS10069', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796354482177', '213102', '1630825881339564032', '1633360737445482496', 'BS10069', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796354482178', 'K3300', '1630825881947738112', '1633360737445482496', 'BS10069', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796354482179', 'K3310', '1630825882543329280', '1633360737445482496', 'BS10069', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796354482180', 'K3330', '1630825883126337536', '1633360737445482496', 'BS10069', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796354482181', 'K3340', '1630825883700957184', '1633360737445482496', 'BS10069', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796354482182', 'K3500', '1630825884883750912', '1633360737445482496', 'BS10069', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796354482183', '219300', '1630825580431806464', '1633360737445482496', 'BS10069', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796358676480', '213103', '1630825886683107328', '1633360737445482496', 'BS10069', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796362870784', '211103', '1630825890831273984', '1633360741488791552', 'BS10071', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796362870785', 'CF1000', '1630827002229559296', '1633360751647395840', 'CF30009', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796362870786', 'CF2000', '1630827002812567552', '1633360761696948224', 'CF30021', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796362870787', 'CF3000', '1630827003403964416', '1633360768835653632', 'CF30032', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796362870788', '311001', '1630823822192152576', '1633360773214507008', 'PL20002', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796362870789', '311002', '1630823822842269696', '1633360773214507008', 'PL20002', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796367065088', '311003', '1630823823509164032', '1633360773214507008', 'PL20002', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796367065089', '311004', '1630823824134115328', '1633360773214507008', 'PL20002', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796367065090', '311005', '1630823824788426752', '1633360773214507008', 'PL20002', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796367065091', '311006', '1630823825514041344', '1633360773214507008', 'PL20002', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796367065092', '311013', '1630823826243850240', '1633360773214507008', 'PL20002', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796367065093', '311014', '1630823826914938880', '1633360773214507008', 'PL20002', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796367065094', '311026', '1630823827527307264', '1633360773214507008', 'PL20002', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796371259392', '311027', '1630823828110315520', '1633360773214507008', 'PL20002', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796371259393', '311028', '1630823828731072512', '1633360773214507008', 'PL20002', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796371259394', '313001', '1630823829347635200', '1633360773214507008', 'PL20002', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796371259395', '313002', '1630823829951614976', '1633360773214507008', 'PL20002', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796371259396', '313003', '1630823830593343488', '1633360773214507008', 'PL20002', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796371259397', '311019', '1630823835093831680', '1633360773214507008', 'PL20002', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796371259398', '311020', '1630823835714588672', '1633360773214507008', 'PL20002', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796371259399', '311021', '1630823836347928576', '1633360773214507008', 'PL20002', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796371259400', '311025', '1630823837035794432', '1633360773214507008', 'PL20002', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796371259401', '312013', '1630824037024403456', '1633360773940121600', 'PL20003', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796371259402', '312015', '1630824037670326272', '1633360773940121600', 'PL20003', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796371259403', '346006', '1630824042850291712', '1633360773940121600', 'PL20003', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796379648000', '346007', '1630824043479437312', '1633360773940121600', 'PL20003', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796379648001', '346008', '1630824044297326592', '1633360773940121600', 'PL20003', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796379648002', '346009', '1630824044955832320', '1633360773940121600', 'PL20003', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796379648003', '440202', '1630824051796742144', '1633360775877890048', 'PL20006', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796379648004', '440301', '1630824052455247872', '1633360775877890048', 'PL20006', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796379648005', '440302', '1630824053998751744', '1633360775877890048', 'PL20006', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796379648006', '440303', '1630824054678228992', '1633360775877890048', 'PL20006', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796379648007', '440304', '1630824055307374592', '1633360775877890048', 'PL20006', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796379648008', '440305', '1630824056850878464', '1633360775877890048', 'PL20006', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796379648009', '440307', '1630824057517772800', '1633360775877890048', 'PL20006', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796379648010', '440308', '1630824058121752576', '1633360775877890048', 'PL20006', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796379648011', '440309', '1630824058746703872', '1633360775877890048', 'PL20006', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796383842304', '440501', '1630824059526844416', '1633360775877890048', 'PL20006', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796383842305', '440502', '1630824060139212800', '1633360775877890048', 'PL20006', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796383842306', '440506', '1630824062882287616', '1633360775877890048', 'PL20006', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796383842307', '440601', '1630824063503044608', '1633360775877890048', 'PL20006', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796383842308', '440603', '1630824064157356032', '1633360775877890048', 'PL20006', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796383842309', '440605', '1630824064824250368', '1633360775877890048', 'PL20006', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796388036608', '440606', '1630824065482756096', '1633360775877890048', 'PL20006', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796388036609', '440701', '1630824066099318784', '1633360775877890048', 'PL20006', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796388036610', '440702', '1630824066715881472', '1633360775877890048', 'PL20006', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796388036611', '440703', '1630824067307278336', '1633360775877890048', 'PL20006', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796388036612', '440704', '1630824068120973312', '1633360775877890048', 'PL20006', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796388036613', '441102', '1630824070566252544', '1633360775877890048', 'PL20006', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796392230912', '441103', '1630824071426084864', '1633360775877890048', 'PL20006', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796392230913', '441104', '1630824072055230464', '1633360775877890048', 'PL20006', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796392230914', '441105', '1630824072692764672', '1633360775877890048', 'PL20006', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796392230915', '441107', '1630824073397407744', '1633360775877890048', 'PL20006', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796392230916', '441108', '1630824074043330560', '1633360775877890048', 'PL20006', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796392230917', '441109', '1630824074718613504', '1633360775877890048', 'PL20006', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796392230918', '441110', '1630824075360342016', '1633360775877890048', 'PL20006', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796392230919', '441111', '1630824075997876224', '1633360775877890048', 'PL20006', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796392230920', '440705', '1630824083207884800', '1633360775877890048', 'PL20006', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796392230921', '440706', '1630824083866390528', '1633360775877890048', 'PL20006', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796400619520', '431003', '1630823939775270912', '1633360775877890048', 'PL20006', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796400619521', '431004', '1630823940521857024', '1633360775877890048', 'PL20006', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796400619522', '431006', '1630823941100670976', '1633360775877890048', 'PL20006', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796400619523', '431007', '1630823941708845056', '1633360775877890048', 'PL20006', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796400619524', '431012', '1630823942317019136', '1633360775877890048', 'PL20006', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796400619525', '431001', '1630823945387249664', '1633360775877890048', 'PL20006', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796400619526', '421213', '1630823911732154368', '1633360775877890048', 'PL20006', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796400619527', '421214', '1630823912344522752', '1633360775877890048', 'PL20006', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796404813824', '421215', '1630823913032388608', '1633360775877890048', 'PL20006', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796404813825', '421216', '1630823913883832320', '1633360775877890048', 'PL20006', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796404813826', '422101', '1630823914676555776', '1633360775877890048', 'PL20006', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796404813827', '422102', '1630823915314089984', '1633360775877890048', 'PL20006', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796404813828', '422103', '1630823915951624192', '1633360775877890048', 'PL20006', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796404813829', '422104', '1630823916551409664', '1633360775877890048', 'PL20006', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796404813830', '422105', '1630823917163778048', '1633360775877890048', 'PL20006', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796409008128', '422106', '1630823917755174912', '1633360775877890048', 'PL20006', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796409008129', '422107', '1630823918363348992', '1633360775877890048', 'PL20006', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796409008130', '422108', '1630823919034437632', '1633360775877890048', 'PL20006', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796409008131', '422109', '1630823919659388928', '1633360775877890048', 'PL20006', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796409008132', '422110', '1630823920305311744', '1633360775877890048', 'PL20006', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796409008133', '422201', '1630823920921874432', '1633360775877890048', 'PL20006', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796409008134', '422202', '1630823921546825728', '1633360775877890048', 'PL20006', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796409008135', '422203', '1630823922154999808', '1633360775877890048', 'PL20006', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796413202432', '422204', '1630823922821894144', '1633360775877890048', 'PL20006', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796413202433', '422205', '1630823923442651136', '1633360775877890048', 'PL20006', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796413202434', '422206', '1630823924042436608', '1633360775877890048', 'PL20006', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796413202435', '422208', '1630823924663193600', '1633360775877890048', 'PL20006', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796413202436', '422209', '1630823925292339200', '1633360775877890048', 'PL20006', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796413202437', '422210', '1630823925900513280', '1633360775877890048', 'PL20006', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796413202438', '422211', '1630823926546436096', '1633360775877890048', 'PL20006', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796413202439', '422212', '1630823927259467776', '1633360775877890048', 'PL20006', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796413202440', '351009', '1630823861702496256', '1633360775877890048', 'PL20006', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796417396736', '411001', '1630823862365196288', '1633360775877890048', 'PL20006', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796417396737', '411002', '1630823863128559616', '1633360775877890048', 'PL20006', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796417396738', '411003', '1630823863740928000', '1633360775877890048', 'PL20006', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796417396739', '411005', '1630823864420405248', '1633360775877890048', 'PL20006', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796417396740', '411006', '1630823865049550848', '1633360775877890048', 'PL20006', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796417396741', '411007', '1630823865678696448', '1633360775877890048', 'PL20006', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796417396742', '411008', '1630823866341396480', '1633360775877890048', 'PL20006', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796417396743', '411009', '1630823866920210432', '1633360775877890048', 'PL20006', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796417396744', '411010', '1630823867566133248', '1633360775877890048', 'PL20006', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796417396745', '411011', '1630823868228833280', '1633360775877890048', 'PL20006', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796417396746', '411012', '1630823868866367488', '1633360775877890048', 'PL20006', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796417396747', '411013', '1630823869457764352', '1633360775877890048', 'PL20006', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796417396748', '411014', '1630823870049161216', '1633360775877890048', 'PL20006', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796425785344', '411015', '1630823870665723904', '1633360775877890048', 'PL20006', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796425785345', '411016', '1630823871315841024', '1633360775877890048', 'PL20006', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796425785346', '411017', '1630823871957569536', '1633360775877890048', 'PL20006', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796425785347', '411018', '1630823872653824000', '1633360775877890048', 'PL20006', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796425785348', '411019', '1630823873324912640', '1633360775877890048', 'PL20006', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796425785349', '411020', '1630823873970835456', '1633360775877890048', 'PL20006', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796429979648', '411021', '1630823874608369664', '1633360775877890048', 'PL20006', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796429979649', '411022', '1630823875224932352', '1633360775877890048', 'PL20006', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796429979650', '411023', '1630823875858272256', '1633360775877890048', 'PL20006', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796429979651', '411026', '1630823876520972288', '1633360775877890048', 'PL20006', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796429979652', '411027', '1630823877137534976', '1633360775877890048', 'PL20006', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796429979653', '411028', '1630823877749903360', '1633360775877890048', 'PL20006', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796429979654', '411029', '1630823878387437568', '1633360775877890048', 'PL20006', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796429979655', '411030', '1630823879134023680', '1633360775877890048', 'PL20006', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796429979656', '411031', '1630823879901581312', '1633360775877890048', 'PL20006', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796429979657', '411033', '1630823880526532608', '1633360775877890048', 'PL20006', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796429979658', '411034', '1630823881210204160', '1633360775877890048', 'PL20006', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796434173952', '411035', '1630823881822572544', '1633360775877890048', 'PL20006', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796434173953', '411037', '1630823882460106752', '1633360775877890048', 'PL20006', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796434173954', '411038', '1630823883093446656', '1633360775877890048', 'PL20006', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796434173955', '412001', '1630823883735175168', '1633360775877890048', 'PL20006', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796434173956', '412002', '1630823884368515072', '1633360775877890048', 'PL20006', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796434173957', '412003', '1630823884997660672', '1633360775877890048', 'PL20006', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796434173958', '413001', '1630823885635194880', '1633360775877890048', 'PL20006', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796434173959', '413004', '1630823886243368960', '1633360775877890048', 'PL20006', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796438368256', '413005', '1630823886872514560', '1633360775877890048', 'PL20006', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796438368257', '413006', '1630823887510048768', '1633360775877890048', 'PL20006', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796438368258', '413007', '1630823888231469056', '1633360775877890048', 'PL20006', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796438368259', '413008', '1630823888856420352', '1633360775877890048', 'PL20006', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796438368260', '413010', '1630823889472983040', '1633360775877890048', 'PL20006', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796438368261', '421101', '1630823893633732608', '1633360775877890048', 'PL20006', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796438368262', '421102', '1630823894233518080', '1633360775877890048', 'PL20006', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796438368263', '421103', '1630823894833303552', '1633360775877890048', 'PL20006', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796442562560', '421104', '1630823895420506112', '1633360775877890048', 'PL20006', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796442562561', '421105', '1630823896032874496', '1633360775877890048', 'PL20006', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796442562562', '421106', '1630823896662020096', '1633360775877890048', 'PL20006', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796442562563', '421107', '1630823897328914432', '1633360775877890048', 'PL20006', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796442562564', '421108', '1630823898004197376', '1633360775877890048', 'PL20006', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796442562565', '421109', '1630823898624954368', '1633360775877890048', 'PL20006', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796442562566', '421110', '1630823899258294272', '1633360775877890048', 'PL20006', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796442562567', '421112', '1630823899937771520', '1633360775877890048', 'PL20006', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796446756864', '421113', '1630823900600471552', '1633360775877890048', 'PL20006', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796446756865', '421117', '1630823901368029184', '1633360775877890048', 'PL20006', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796446756866', '421118', '1630823902034923520', '1633360775877890048', 'PL20006', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796446756867', '421119', '1630823902680846336', '1633360775877890048', 'PL20006', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796446756868', '421120', '1630823903284826112', '1633360775877890048', 'PL20006', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796446756869', '421121', '1630823903897194496', '1633360775877890048', 'PL20006', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796446756870', '421201', '1630823904476008448', '1633360775877890048', 'PL20006', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796450951168', '421202', '1630823905130319872', '1633360775877890048', 'PL20006', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796450951169', '421203', '1630823905763659776', '1633360775877890048', 'PL20006', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796450951170', '421204', '1630823906405388288', '1633360775877890048', 'PL20006', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796450951171', '421205', '1630823907097448448', '1633360775877890048', 'PL20006', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796450951172', '421206', '1630823907751759872', '1633360775877890048', 'PL20006', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796450951173', '421207', '1630823908393488384', '1633360775877890048', 'PL20006', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796450951174', '421208', '1630823908993273856', '1633360775877890048', 'PL20006', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796455145472', '421209', '1630823909681139712', '1633360775877890048', 'PL20006', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796455145473', '421211', '1630823910369005568', '1633360775877890048', 'PL20006', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796455145474', '421212', '1630823910998151168', '1633360775877890048', 'PL20006', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796455145475', '441201', '1630824080745828352', '1633360777647886336', 'PL20008', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796455145476', '441202', '1630824081345613824', '1633360777647886336', 'PL20008', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796455145477', '441204', '1630824081974759424', '1633360777647886336', 'PL20008', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796455145478', '440401', '1630824082595516416', '1633360778306392064', 'PL20009', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796455145479', '440801', '1630824084487147520', '1633360778306392064', 'PL20009', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796459339776', '440802', '1630824085099515904', '1633360778306392064', 'PL20009', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796459339777', '440803', '1630824085728661504', '1633360778306392064', 'PL20009', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796459339778', '440804', '1630824086357807104', '1633360778306392064', 'PL20009', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796459339779', '440808', '1630824088220078080', '1633360778306392064', 'PL20009', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796459339780', '440809', '1630824088870195200', '1633360778306392064', 'PL20009', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796459339781', '440810', '1630824089495146496', '1633360778306392064', 'PL20009', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796459339782', '440811', '1630824090229149696', '1633360778306392064', 'PL20009', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796459339783', '440850', '1630824090875072512', '1633360778306392064', 'PL20009', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796463534080', '440503', '1630824060768358400', '1633360779044589568', 'PL20010', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796463534081', '440505', '1630824062202810368', '1633360779044589568', 'PL20010', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796463534082', '441006', '1630824068771090432', '1633360779044589568', 'PL20010', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796463534083', '441021', '1630824069412818944', '1633360779044589568', 'PL20010', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796463534084', '441001', '1630824091504218112', '1633360779044589568', 'PL20010', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796467728384', '441002', '1630824092133363712', '1633360779044589568', 'PL20010', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796467728385', '441003', '1630824092749926400', '1633360779044589568', 'PL20010', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796467728386', '441004', '1630824093387460608', '1633360779044589568', 'PL20010', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796467728387', '441005', '1630824094024994816', '1633360779044589568', 'PL20010', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796467728388', '441009', '1630824095367172096', '1633360779044589568', 'PL20010', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796467728389', '441010', '1630824095996317696', '1633360779044589568', 'PL20010', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796467728390', '441013', '1630824098072498176', '1633360779044589568', 'PL20010', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796467728391', '441014', '1630824098722615296', '1633360779044589568', 'PL20010', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796467728392', '441015', '1630824099385315328', '1633360779044589568', 'PL20010', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796467728393', '441016', '1630824100018655232', '1633360779044589568', 'PL20010', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796467728394', '441017', '1630824100622635008', '1633360779044589568', 'PL20010', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796471922688', '441018', '1630824101285335040', '1633360779044589568', 'PL20010', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796471922689', '441019', '1630824101927063552', '1633360779044589568', 'PL20010', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796471922690', '441020', '1630824102552014848', '1633360779044589568', 'PL20010', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796471922691', '441106', '1630824103361515520', '1633360779044589568', 'PL20010', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796471922692', '431009', '1630823947157245952', '1633360779044589568', 'PL20010', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796471922693', '344001', '1630824046188957696', '1633360780806197248', 'PL20012', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796471922694', '344003', '1630824047468220416', '1633360780806197248', 'PL20012', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796471922695', '441011', '1630824096621268992', '1633360780806197248', 'PL20012', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796476116992', '441012', '1630824097434963968', '1633360780806197248', 'PL20012', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796476116993', '451005', '1630823954144956416', '1633360780806197248', 'PL20012', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796476116994', '451006', '1630823954761519104', '1633360780806197248', 'PL20012', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796476116995', '451008', '1630823956015616000', '1633360780806197248', 'PL20012', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796476116996', '451013', '1630823956636372992', '1633360780806197248', 'PL20012', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796476116997', '451014', '1630823957269712896', '1633360780806197248', 'PL20012', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796476116998', '451016', '1630823958553169920', '1633360780806197248', 'PL20012', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796476116999', '451017', '1630823959161344000', '1633360780806197248', 'PL20012', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796480311296', '451018', '1630823959769518080', '1633360780806197248', 'PL20012', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796480311297', '451022', '1630823961011032064', '1633360780806197248', 'PL20012', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796480311298', '440901', '1630824103990661120', '1633360780806197248', 'PL20012', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796480311299', '440902', '1630824104619806720', '1633360780806197248', 'PL20012', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796480311300', '440903', '1630824105240563712', '1633360780806197248', 'PL20012', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796480311301', '351001', '1630823949019516928', '1633360780806197248', 'PL20012', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796480311302', '351010', '1630823949644468224', '1633360780806197248', 'PL20012', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796480311303', '345004', '1630824051196956672', '1633360781921882112', 'PL20016', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796480311304', '351007', '1630823950911148032', '1633360782815268864', 'PL20017', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796484505600', '346010', '1630823962218991616', '1633360782815268864', 'PL20017', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796484505601', '351012', '1630823950273613824', '1633360785654812672', 'PL20021', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796488699904', '451020', '1630823960386080768', '1633360785654812672', 'PL20021', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796488699905', '344004', '1630823839715954688', '1633360785654812672', 'PL20021', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796488699906', '440904', '1630823931583795200', '1633360785654812672', 'PL20021', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796488699907', '440101', '1630824076761239552', '1633360786309124096', 'PL20022', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796488699908', '440102', '1630824077436522496', '1633360786309124096', 'PL20022', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796488699909', '431005', '1630823942929387520', '1633360786976018432', 'PL20023', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796492894208', '431013', '1630823944133152768', '1633360786976018432', 'PL20023', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796492894209', '431002', '1630823946561654784', '1633360786976018432', 'PL20023', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796492894210', '341001', '1630824048101560320', '1633360787705827328', 'PL20024', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796492894211', '341002', '1630824048764260352', '1633360787705827328', 'PL20024', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796492894212', '341005', '1630824049368240128', '1633360787705827328', 'PL20024', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796492894213', '342004', '1630824038307860480', '1633360788989284352', 'PL20026', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796492894214', '343001', '1630824038937006080', '1633360788989284352', 'PL20026', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796492894215', '343002', '1630824039587123200', '1633360788989284352', 'PL20026', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796492894216', '346001', '1630824040228851712', '1633360788989284352', 'PL20026', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796501282816', '346003', '1630824041604583424', '1633360788989284352', 'PL20026', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796501282817', '346005', '1630824042212757504', '1633360788989284352', 'PL20026', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796501282818', '346011', '1630824045568200704', '1633360788989284352', 'PL20026', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796501282819', '345002', '1630824049980608512', '1633360788989284352', 'PL20026', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796501282820', '440104', '1630824078153748480', '1633360790469873664', 'PL20028', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796501282821', '440402', '1630824078829031424', '1633360790469873664', 'PL20028', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796501282822', '440403', '1630824079504314368', '1633360790469873664', 'PL20028', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796501282823', '441008', '1630824094662529024', '1633360790469873664', 'PL20028', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796505477120', '471001', '1630823962822971392', '1633360793917591552', 'PL20030', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796505477121', '471002', '1630823963456311296', '1633360793917591552', 'PL20030', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796505477122', '471003', '1630823964135788544', '1633360793917591552', 'PL20030', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796505477123', '472001', '1630823964760739840', '1633360793917591552', 'PL20030', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796505477124', 'PL8100', '1630823721801486336', '1633360795062636544', 'PL20032', NULL);
INSERT INTO `qf_subject_relation` VALUES ('1633360796505477125', '900100', '1630823966002253824', '1633360795729530880', 'PL20033', NULL);

SET FOREIGN_KEY_CHECKS = 1;
