/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.cqlt.manager.impl;

import com.artfess.base.enums.ProductSalesDataTypeEnum;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.util.StringUtil;
import com.artfess.cqlt.dao.QfOperatingStatisticalDao;
import com.artfess.cqlt.dao.QfOperationSalesProductMDao;
import com.artfess.cqlt.dao.SysSubjectTargetDao;
import com.artfess.cqlt.manager.QfOperatingStatisticalManager;
import com.artfess.cqlt.manager.QfOperationCipDManager;
import com.artfess.cqlt.manager.QfOperationCompanyCipDManager;
import com.artfess.cqlt.manager.QfOperationNewOrdersDManager;
import com.artfess.cqlt.manager.QfOperationReductionsDManager;
import com.artfess.cqlt.manager.QfOperationSalesProductMManager;
import com.artfess.cqlt.manager.QfOperationSopDManager;
import com.artfess.cqlt.model.QfOperatingStatistical;
import com.artfess.cqlt.model.SysSubjectTarget;
import com.artfess.cqlt.vo.OpReportReqVo;
import com.artfess.cqlt.vo.OpReportRespVo;
import com.artfess.cqlt.vo.OpTargetRespVo;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.google.api.client.util.Lists;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

@Service
public class QfOperatingStatisticalManagerImpl
extends BaseManagerImpl<QfOperatingStatisticalDao, QfOperatingStatistical>
implements QfOperatingStatisticalManager {
    @Resource
    private QfOperationSalesProductMDao salesProductMDao;
    @Autowired
    private QfOperationSopDManager sopDManager;
    @Autowired
    private QfOperationReductionsDManager reductionsDManager;
    @Autowired
    private QfOperationNewOrdersDManager ordersDManager;
    @Autowired
    private QfOperationCompanyCipDManager companyCipDManager;
    @Autowired
    private QfOperationCipDManager cipDManager;
    @Resource
    private SysSubjectTargetDao subjectTargetDao;
    @Resource
    private QfOperationSalesProductMManager salesProductMManager;

    @Override
    public List<OpTargetRespVo> data(OpReportReqVo t) {
        if (null == t.getYear() || t.getYear() <= 0) {
            int year = LocalDate.now().getYear();
            t.setYear(year);
        }
        if (null == t.getStartYear() || null == t.getEndYear()) {
            t.setEndYear(t.getYear());
            t.setStartYear(t.getYear() - 5);
        }
        t.setYear(null);
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"business_", (Object)"operation");
        queryWrapper.eq((Object)"target_level_", (Object)1);
        List targetList = this.subjectTargetDao.selectList((Wrapper)queryWrapper);
        ArrayList resultList = Lists.newArrayList();
        targetList.forEach(target -> {
            String type = null;
            if (!StringUtil.isEmpty((String)target.getType())) {
                type = target.getType().split(",")[0];
            }
            t.setTargetId(target.getId());
            OpTargetRespVo resultFa = new OpTargetRespVo();
            resultFa.setTargetId(target.getId());
            resultFa.setTargetName(target.getName());
            resultFa.setTargetNameEn(target.getTargetNameEn());
            resultFa.setTargetUnit(target.getUnit());
            resultFa.setType(type);
            resultFa.setStaLat(target.getStaLat().trim());
            resultFa.setSn(target.getSn());
            resultFa.setContainType(target.getType());
            switch (target.getCode()) {
                case "OP001": {
                    t.setDataType(Integer.parseInt(ProductSalesDataTypeEnum.ONE.getType()));
                    List<OpReportRespVo> reportRespVos = this.salesProductMDao.yearData(t);
                    resultFa.setResultData(reportRespVos);
                    break;
                }
                case "OP002": {
                    List<OpReportRespVo> reportRespVos = this.sopDManager.yearData(t);
                    resultFa.setResultData(reportRespVos);
                    break;
                }
                case "OP003": {
                    List<OpReportRespVo> reportRespVos = this.reductionsDManager.yearData(t);
                    resultFa.setResultData(reportRespVos);
                    break;
                }
                case "OP004": {
                    List<OpReportRespVo> reportRespVos = this.ordersDManager.yearData(t);
                    resultFa.setResultData(reportRespVos);
                    break;
                }
                case "OP005": {
                    List<OpReportRespVo> reportRespVos = this.cipDManager.yearData(t);
                    resultFa.setResultData(reportRespVos);
                    break;
                }
                case "OP006": {
                    List<OpReportRespVo> reportRespVos = this.companyCipDManager.yearData(t);
                    resultFa.setResultData(reportRespVos);
                    break;
                }
            }
            resultFa.getResultData().forEach(reportRespVo -> {
                if (StringUtils.isEmpty((Object)target.getStaLat())) {
                    return;
                }
                if (target.getStaLat().length() < 2) {
                    return;
                }
                if (null != reportRespVo.getBudget() && null != reportRespVo.getActual()) {
                    BigDecimal differenceValue = reportRespVo.getActual().subtract(reportRespVo.getBudget());
                    reportRespVo.setDifferenceValue(differenceValue);
                    String differenceRate = null;
                    if (0.0 != reportRespVo.getActual().doubleValue()) {
                        differenceRate = differenceValue.divide(reportRespVo.getActual(), 2, 4).multiply(new BigDecimal("100")) + "%";
                    }
                    reportRespVo.setDifferenceRate(differenceRate);
                }
            });
            resultList.add(resultFa);
        });
        return resultList;
    }

    @Override
    public List<OpTargetRespVo> fromUnderData(OpReportReqVo t) {
        Assert.hasText((String)t.getTargetId(), (String)"\u8bf7\u9009\u62e9\u8981\u7edf\u8ba1\u7684\u6307\u6807id");
        SysSubjectTarget target = (SysSubjectTarget)((Object)this.subjectTargetDao.selectById((Serializable)((Object)t.getTargetId())));
        Assert.notNull((Object)((Object)target), (String)"\u5f53\u524d\u6307\u6807\u4e0d\u5b58\u5728");
        if (StringUtils.isEmpty((Object)target.getType())) {
            return Lists.newArrayList();
        }
        List<Object> list = Lists.newArrayList();
        switch (target.getCode()) {
            case "OP001": {
                list = this.salesProductMManager.dataAnalysis(t, target);
                break;
            }
            case "OP002": {
                list = this.sopDManager.dataAnalysis(t, target);
                break;
            }
            case "OP003": {
                list = this.reductionsDManager.dataAnalysis(t, target);
                break;
            }
            case "OP004": {
                list = this.ordersDManager.dataAnalysis(t, target);
                break;
            }
            case "OP005": {
                list = this.cipDManager.dataAnalysis(t, target);
                break;
            }
            case "OP006": {
                list = this.companyCipDManager.dataAnalysis(t, target);
                break;
            }
        }
        list.forEach(resp -> resp.getResultData().forEach(reportRespVo -> {
            if (StringUtils.isEmpty((Object)target.getStaLat())) {
                return;
            }
            if (target.getStaLat().length() < 2) {
                return;
            }
            if (null != reportRespVo.getBudget() && null != reportRespVo.getActual()) {
                BigDecimal differenceValue = reportRespVo.getActual().subtract(reportRespVo.getBudget());
                reportRespVo.setDifferenceValue(differenceValue);
                String differenceRate = null;
                if (0.0 != reportRespVo.getBudget().doubleValue()) {
                    differenceRate = differenceValue.divide(reportRespVo.getBudget(), 2, 4).multiply(new BigDecimal("100")) + "%";
                }
                reportRespVo.setDifferenceRate(differenceRate);
            }
        }));
        return list;
    }
}

