/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.cqlt.manager.impl;

import com.alibaba.fastjson.JSONObject;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.cqlt.dao.QfInvestPatentDDao;
import com.artfess.cqlt.dao.QfInvestPatentMDao;
import com.artfess.cqlt.dao.QfInvestProductivityDDao;
import com.artfess.cqlt.dao.QfInvestProductivityMDao;
import com.artfess.cqlt.manager.QfInvestPatentDManager;
import com.artfess.cqlt.model.QfInvestExpenditureD;
import com.artfess.cqlt.model.QfInvestPatentD;
import com.artfess.cqlt.model.QfInvestPatentM;
import com.artfess.cqlt.model.QfInvestProductivityD;
import com.artfess.cqlt.model.QfInvestProductivityM;
import com.artfess.cqlt.vo.ReportReqVo;
import com.artfess.i18n.util.I18nUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.google.api.client.util.Lists;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Resource;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service
public class QfInvestPatentDManagerImpl
extends BaseManagerImpl<QfInvestPatentDDao, QfInvestPatentD>
implements QfInvestPatentDManager {
    @Resource
    private QfInvestProductivityMDao investProductivityMDao;
    @Resource
    private QfInvestProductivityDDao investProductivityDDao;
    @Resource
    private QfInvestPatentMDao investPatentMDao;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean batchSave(QfInvestPatentM t) {
        Assert.hasText((String)t.getId(), (String)I18nUtil.getMessage((String)"QfOperationKpiM.reportId", (Locale)LocaleContextHolder.getLocale()));
        QfInvestPatentM qfInvestPatentM = (QfInvestPatentM)((Object)this.investPatentMDao.selectById((Serializable)((Object)t.getId())));
        Assert.notNull((Object)((Object)qfInvestPatentM), (String)I18nUtil.getMessage((String)"filldata.notExist", (Locale)LocaleContextHolder.getLocale()));
        Assert.isTrue((!"1".equals(qfInvestPatentM.getStatus()) ? 1 : 0) != 0, (String)I18nUtil.getMessage((String)"data_operate", (Locale)LocaleContextHolder.getLocale()));
        t.getList().forEach(detail -> detail.setMainId(t.getId()));
        boolean b = this.saveOrUpdateBatch(t.getList());
        return b;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean batchUpdate(QfInvestPatentM t) {
        Assert.hasText((String)t.getId(), (String)I18nUtil.getMessage((String)"QfOperationKpiM.reportId", (Locale)LocaleContextHolder.getLocale()));
        t.getList().forEach(detail -> detail.setMainId(t.getId()));
        boolean b = this.saveOrUpdateBatch(t.getList());
        return b;
    }

    @Override
    public JSONObject investmentSituation(ReportReqVo vo) {
        if (null == vo.getStartYear() && null == vo.getEndYear()) {
            int endYear = LocalDate.now().getYear();
            vo.setEndYear(endYear);
            vo.setStartYear(endYear - 10);
        }
        JSONObject result = new JSONObject();
        ArrayList patentsData = Lists.newArrayList();
        Map<String, List<QfInvestPatentD>> patents = ((QfInvestPatentDDao)this.baseMapper).countPatents(vo).stream().collect(Collectors.groupingBy(QfInvestPatentD::getSubjectCode));
        patents.entrySet().forEach(p -> {
            QfInvestPatentD data = new QfInvestPatentD();
            data.setSubjectCode((String)p.getKey());
            ArrayList list = Lists.newArrayList();
            ((List)p.getValue()).forEach(pl -> {
                data.setSubjectName(pl.getSubjectName());
                data.setSubjectNameEn(pl.getSubjectNameEn());
                data.setSubjectLevel(pl.getSubjectLevel());
                data.setSubjectUnit(pl.getSubjectUnit());
                list.add(new QfInvestPatentD(pl.getFillData(), pl.getFillYear()));
            });
            Comparator<QfInvestPatentD> comparator = Comparator.comparing(QfInvestPatentD::getFillYear);
            List<QfInvestPatentD> filledList = IntStream.range(0, list.size() - 1).mapToObj(i -> {
                QfInvestPatentD prev = (QfInvestPatentD)((Object)((Object)((Object)list.get(i))));
                QfInvestPatentD current = (QfInvestPatentD)((Object)((Object)((Object)list.get(i + 1))));
                int diff = current.getFillYear() - prev.getFillYear();
                if (diff > 1) {
                    return IntStream.range(1, diff).mapToObj(j -> new QfInvestPatentD(new BigDecimal(0), prev.getFillYear() + j)).collect(Collectors.toList());
                }
                return new ArrayList();
            }).flatMap(Collection::stream).collect(Collectors.toList());
            filledList.addAll(list);
            filledList.sort(comparator);
            data.setList(filledList);
            patentsData.add(data);
        });
        result.put("patents", (Object)patentsData);
        List<QfInvestExpenditureD> investmentSituation = ((QfInvestPatentDDao)this.baseMapper).investmentSituation(vo);
        investmentSituation.forEach(reportRespVo -> {
            if (null != reportRespVo.getBudget() && null != reportRespVo.getActual()) {
                BigDecimal differenceValue = reportRespVo.getActual().subtract(reportRespVo.getBudget());
                reportRespVo.setDifferenceValue(differenceValue);
                String differenceRate = null;
                if (0.0 != reportRespVo.getActual().doubleValue()) {
                    differenceRate = differenceValue.divide(reportRespVo.getActual(), 2, 4).multiply(new BigDecimal("100")) + "%";
                }
                reportRespVo.setDifferenceRate(differenceRate);
            }
        });
        result.put("investmentSituation", investmentSituation);
        return result;
    }

    @Override
    public List<QfInvestProductivityD> capacitySituation(ReportReqVo vo) {
        if (null == vo.getStartYear() && null == vo.getEndYear()) {
            int endYear = LocalDate.now().getYear();
            vo.setEndYear(endYear);
            vo.setStartYear(endYear - 5);
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.orderByDesc((Object)"fill_year_");
        queryWrapper.orderByDesc((Object)"fill_month_");
        List qfInvestPatentMS = this.investProductivityMDao.selectList((Wrapper)queryWrapper);
        if (CollectionUtils.isEmpty((Collection)qfInvestPatentMS)) {
            return Lists.newArrayList();
        }
        QfInvestProductivityM main = (QfInvestProductivityM)((Object)qfInvestPatentMS.get(0));
        QueryWrapper dQueryWrapper = new QueryWrapper();
        dQueryWrapper.eq((Object)"main_id_", (Object)main.getId());
        List result = this.investProductivityDDao.selectList((Wrapper)dQueryWrapper);
        return result;
    }
}

