/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.cqlt.manager.impl;

import com.alibaba.fastjson.JSONObject;
import com.artfess.base.enums.DelStatusEnum;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.cqlt.dao.QfEnterpriseInfoDao;
import com.artfess.cqlt.dao.QfFinanceReportingSummaryDDao;
import com.artfess.cqlt.dao.QfFinanceReportingSummaryMDao;
import com.artfess.cqlt.manager.QfFinanceReportingSummaryDManager;
import com.artfess.cqlt.manager.QfFinanceReportingSummarySManager;
import com.artfess.cqlt.model.QfEnterpriseInfo;
import com.artfess.cqlt.model.QfFinanceReportingSummaryD;
import com.artfess.cqlt.model.QfFinanceReportingSummaryM;
import com.artfess.cqlt.model.QfFinanceReportingSummaryS;
import com.artfess.cqlt.vo.ReportDataVo;
import com.artfess.i18n.util.I18nUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.google.api.client.util.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service
public class QfFinanceReportingSummaryDManagerImpl
extends BaseManagerImpl<QfFinanceReportingSummaryDDao, QfFinanceReportingSummaryD>
implements QfFinanceReportingSummaryDManager {
    @Resource
    private QfEnterpriseInfoDao enterpriseInfoDao;
    @Resource
    private QfFinanceReportingSummaryMDao financeReportingSummaryMDao;
    @Resource
    private QfFinanceReportingSummarySManager financeReportingSummarySManager;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean batchUpdate(QfFinanceReportingSummaryM t) {
        Assert.hasText((String)t.getId(), (String)I18nUtil.getMessage((String)"QfOperationKpiM.reportId", (Locale)LocaleContextHolder.getLocale()));
        QfFinanceReportingSummaryM financePlM = (QfFinanceReportingSummaryM)((Object)this.financeReportingSummaryMDao.selectById((Serializable)((Object)t.getId())));
        Assert.notNull((Object)((Object)financePlM), (String)I18nUtil.getMessage((String)"filldata.notExist", (Locale)LocaleContextHolder.getLocale()));
        Assert.isTrue((!"1".equals(financePlM.getStatus()) ? 1 : 0) != 0, (String)I18nUtil.getMessage((String)"data_operate", (Locale)LocaleContextHolder.getLocale()));
        ArrayList list = Lists.newArrayList();
        ArrayList totalList = Lists.newArrayList();
        QueryWrapper enterpriseInfoQuery = new QueryWrapper();
        enterpriseInfoQuery.eq((Object)"IS_DELE_", (Object)DelStatusEnum.N.getType());
        List enterpriseInfoList = this.enterpriseInfoDao.selectList((Wrapper)enterpriseInfoQuery);
        Map<String, QfEnterpriseInfo> enterpriseInfoMap = enterpriseInfoList.stream().collect(Collectors.toMap(item -> item.getCode(), item -> item));
        t.getList().forEach(detail -> {
            detail.setFillDate(financePlM.getFillDate());
            detail.setMainId(t.getId());
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"subject_code_", (Object)detail.getSubjectCode());
            queryWrapper.eq((Object)"main_id_", (Object)t.getId());
            queryWrapper.eq((Object)"enterprise_code_", (Object)detail.getEnterpriseCode());
            QfFinanceReportingSummaryD QfFinanceReportingSummaryD2 = (QfFinanceReportingSummaryD)((Object)((Object)((QfFinanceReportingSummaryDDao)this.baseMapper).selectOne((Wrapper)queryWrapper)));
            if (null != QfFinanceReportingSummaryD2) {
                QfFinanceReportingSummaryD2.setActualYtd(detail.getActualYtd());
                list.add(QfFinanceReportingSummaryD2);
            } else {
                detail.setSubjectNameEn(detail.getSubjectNameEn());
                detail.setSubjectUnit(detail.getSubjectUnit());
                detail.setSubjectCode(detail.getSubjectCode());
                if (enterpriseInfoMap.containsKey(detail.getEnterpriseCode())) {
                    QfEnterpriseInfo qfEnterpriseInfo = (QfEnterpriseInfo)((Object)((Object)enterpriseInfoMap.get(detail.getEnterpriseCode())));
                    detail.setEnterpriseName(qfEnterpriseInfo.getName());
                    detail.setEnterpriseNameEn(qfEnterpriseInfo.getNameEn());
                }
                list.add(detail);
            }
        });
        t.getTotalList().forEach(detail -> {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"subject_code_", (Object)detail.getSubjectCode());
            queryWrapper.eq((Object)"main_id_", (Object)t.getId());
            QfFinanceReportingSummaryS financePlActualS = (QfFinanceReportingSummaryS)((Object)((Object)this.financeReportingSummarySManager.getBaseMapper().selectOne((Wrapper)queryWrapper)));
            if (null != financePlActualS) {
                if (null != detail.getActualTotal()) {
                    financePlActualS.setActualTotal(detail.getActualTotal());
                }
                if (null != detail.getActualPosting()) {
                    financePlActualS.setActualPosting(detail.getActualPosting());
                }
                if (null != detail.getActualConsolidated()) {
                    financePlActualS.setActualConsolidated(detail.getActualConsolidated());
                }
                totalList.add(financePlActualS);
            } else {
                detail.setFillDate(financePlM.getFillDate());
                detail.setFillQuarter(financePlM.getFillQuarter());
                detail.setFillMonth(financePlM.getFillMonth());
                detail.setFillYear(financePlM.getFillYear());
                detail.setMainId(t.getId());
                totalList.add(detail);
            }
        });
        if (!CollectionUtils.isEmpty((Collection)list)) {
            this.saveOrUpdateBatch(list);
        }
        if (!CollectionUtils.isEmpty((Collection)totalList)) {
            this.financeReportingSummarySManager.saveOrUpdateBatch(totalList);
        }
        return true;
    }

    @Override
    public List<JSONObject> detailQuery(List<QfFinanceReportingSummaryD> list) {
        if (CollectionUtils.isEmpty(list)) {
            return Lists.newArrayList();
        }
        String mainId = list.get(0).getMainId();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"main_id_", (Object)mainId);
        List financePlSList = this.financeReportingSummarySManager.getBaseMapper().selectList((Wrapper)queryWrapper);
        List<String> enterpriseCodeHeader = ((QfFinanceReportingSummaryDDao)this.baseMapper).getEnterpriseCodeHeader(mainId);
        List<String> subjectCodes = ((QfFinanceReportingSummaryDDao)this.baseMapper).getSubjectCodes(mainId);
        ArrayList detailList = Lists.newArrayList();
        JSONObject detail = new JSONObject(true);
        detail.put("subjectNameEn", (Object)"subjectNameEn");
        detail.put("subjectCode", (Object)"subjectCode");
        enterpriseCodeHeader.forEach(code -> detail.put(code, code));
        detail.put("Total", (Object)"Total");
        detail.put("Consolidation Posting", (Object)"Consolidation Posting");
        detail.put("Consolidated Financial Statement", (Object)"Consolidated Financial Statement");
        detailList.add(detail);
        for (String subjectCode : subjectCodes) {
            JSONObject data = new JSONObject(true);
            data.put("subjectCode", (Object)subjectCode);
            for (QfFinanceReportingSummaryD pld : list) {
                if (!pld.getSubjectCode().equals(subjectCode)) continue;
                data.put("subjectNameEn", (Object)pld.getSubjectNameEn());
                data.put(pld.getEnterpriseCode(), (Object)pld.getActualYtd());
            }
            for (QfFinanceReportingSummaryS pls : financePlSList) {
                if (!pls.getSubjectCode().equals(subjectCode)) continue;
                data.put("Total", (Object)pls.getActualTotal());
                data.put("Consolidation Posting", (Object)pls.getActualPosting());
                data.put("Consolidated Financial Statement", (Object)pls.getActualConsolidated());
            }
            detailList.add(data);
        }
        return detailList;
    }

    @Override
    public List<ReportDataVo> getDataList(List<String> subjectCodes, Integer fillYear, Integer endMonth) {
        return ((QfFinanceReportingSummaryDDao)this.baseMapper).getDataList(subjectCodes, fillYear, endMonth);
    }
}

