/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.cqlt.utils;

import com.artfess.base.enums.FaTargetTypeEnum;
import com.artfess.cqlt.model.SysSubjectTarget;
import com.artfess.cqlt.vo.DateReqVo;
import com.artfess.cqlt.vo.FaReportRespVo;
import com.artfess.cqlt.vo.FaTargetRespVo;
import com.artfess.cqlt.vo.OpDateReqVo;
import com.artfess.cqlt.vo.OpQueryReqVo;
import com.artfess.cqlt.vo.OpReportReqVo;
import com.artfess.cqlt.vo.QueryReqVo;
import com.artfess.cqlt.vo.ReportReqVo;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class FinancialTimeUtils {
    public DateReqVo processDateReqVo(ReportReqVo t, String type) {
        AtomicReference<DateReqVo> dateReqVo = new AtomicReference<DateReqVo>(new DateReqVo());
        List<QueryReqVo> queryList = t.getQueryList();
        if (CollectionUtils.isEmpty(queryList)) {
            return this.createDateReqVo(type, dateReqVo.get());
        }
        Map<String, QueryReqVo> queryMap = queryList.stream().collect(Collectors.toMap(item -> item.getType(), item -> item));
        if (!queryMap.containsKey(type)) {
            return this.createDateReqVo(type, dateReqVo.get());
        }
        queryMap.forEach((k, v) -> {
            if (!k.equals(type)) {
                return;
            }
            QueryReqVo queryReqVo = (QueryReqVo)queryMap.get(type);
            if (null != queryReqVo && null != queryReqVo.getDateReqVo()) {
                dateReqVo.set(queryReqVo.getDateReqVo());
            }
            this.createDateReqVo(type, (DateReqVo)dateReqVo.get());
        });
        return dateReqVo.get();
    }

    public DateReqVo createDateReqVo(String type, DateReqVo t) {
        if ("1".equals(type) || "2".equals(type) || "9".equals(type)) {
            if (null == t.getYear()) {
                int year = LocalDate.now().getYear();
                t.setYear(year - 1);
            }
            if (null == t.getStartMonth() || null == t.getEndMonth()) {
                t.setEndMonth(12);
                t.setStartMonth(1);
            }
        } else if ("3".equals(type)) {
            if (null == t.getYear()) {
                int year = LocalDate.now().getYear();
                t.setYear(year);
            }
            int monthValue = LocalDate.now().getMonthValue();
            t.setStartMonth(1);
            if (1 == monthValue) {
                t.setEndMonth(1);
            } else {
                t.setEndMonth(monthValue - 1);
            }
            t.setEndYear(t.getYear());
            t.setStartYear(t.getYear() - 1);
        } else if ("4".equals(type)) {
            if (null == t.getYear()) {
                int year = LocalDate.now().getYear();
                t.setYear(year);
            }
            if (null == t.getStartMonth()) {
                t.setStartMonth(1);
            } else {
                t.setStartMonth(t.getStartMonth() - 1);
            }
            if (null == t.getEndMonth()) {
                int monthValue = LocalDate.now().getMonthValue();
                if (monthValue == 1) {
                    t.setYear(t.getYear() - 1);
                    t.setEndMonth(12);
                } else {
                    t.setEndMonth(monthValue - 1);
                }
            }
        } else if ("5".equals(type)) {
            if (null == t.getYear()) {
                int year = LocalDate.now().getYear();
                t.setYear(year);
            }
            if (null == t.getStartYear() || null == t.getEndYear()) {
                t.setEndYear(t.getYear());
                t.setStartYear(t.getYear() - 5);
            }
        } else if ("6".equals(type) || "7".equals(type) || "10".equals(type) || "11".equals(type)) {
            if (null == t.getYear()) {
                int year = LocalDate.now().getYear();
                t.setYear(year);
            }
            if (null == t.getStartMonth()) {
                t.setStartMonth(1);
            }
            if (null == t.getEndMonth()) {
                int monthValue = LocalDate.now().getMonthValue();
                if (monthValue == 1) {
                    t.setYear(t.getYear() - 1);
                    t.setEndMonth(12);
                } else {
                    t.setEndMonth(monthValue - 1);
                }
            }
        } else if ("12".equals(type)) {
            if (null == t.getYear()) {
                int year = LocalDate.now().getYear();
                t.setYear(year);
            }
            if (null == t.getMonth()) {
                int monthValue = LocalDate.now().getMonthValue();
                if (monthValue == 1) {
                    t.setYear(t.getYear() - 1);
                    t.setMonth(12);
                } else {
                    t.setMonth(LocalDate.now().getMonthValue() - 1);
                }
            }
        } else if ("15".equals(type)) {
            if (null == t.getYear()) {
                int year = LocalDate.now().getYear();
                t.setYear(year);
            }
            if (null == t.getStartQuarter()) {
                t.setStartQuarter(1);
            }
            if (null == t.getEndQuarter()) {
                t.setEndQuarter(4);
            }
        }
        return t;
    }

    public FaTargetRespVo getFaTargetRespVo(SysSubjectTarget target, String type, List<FaReportRespVo> faReportRespVos) {
        FaTargetRespVo resultFa = new FaTargetRespVo();
        resultFa.setTargetId(target.getId());
        resultFa.setTargetName(target.getName());
        resultFa.setTargetNameEn(target.getTargetNameEn());
        resultFa.setType(type);
        resultFa.setLevel(target.getTargetLevel());
        resultFa.setSn(target.getSn());
        resultFa.setTargetUnit(target.getUnit());
        resultFa.setContainType(target.getType());
        if ("1".equals(target.getConversionUnit())) {
            resultFa.setTargetUnit("10K\u20ac");
        }
        if ("\u4e07\u6b27".equals(target.getUnit())) {
            resultFa.setTargetUnit("10K\u20ac");
        }
        if ("2".equals(target.getConversionUnit())) {
            resultFa.setTargetUnit("\u4ebf\u6b27");
        }
        if ("\u4e07\u6b27/\u4eba".equals(target.getUnit())) {
            resultFa.setStaLat("3");
            resultFa.setTargetUnit("10K\u20ac/person");
        }
        if ("\u4eba".equals(target.getUnit())) {
            resultFa.setTargetUnit("person");
        }
        if (!StringUtils.isEmpty((Object)target.getUnit())) {
            faReportRespVos.forEach(reportRespVo -> {
                this.conversionUnit((FaReportRespVo)reportRespVo, target);
                if (target.getUnit().contains("\u4eba")) {
                    reportRespVo.setBudget(null);
                }
                if (StringUtils.isEmpty((Object)target.getStaLat())) {
                    return;
                }
                if (target.getStaLat().length() < 2) {
                    return;
                }
                if (null != reportRespVo.getBudget() && null != reportRespVo.getActual()) {
                    BigDecimal differenceValue = reportRespVo.getActual().subtract(reportRespVo.getBudget());
                    reportRespVo.setDifferenceValue(differenceValue);
                    if (!"%".equals(target.getUnit())) {
                        String differenceRate = null;
                        if (0.0 != reportRespVo.getBudget().doubleValue()) {
                            differenceRate = differenceValue.divide(reportRespVo.getBudget(), 2, 4).multiply(new BigDecimal("100")) + "%";
                        }
                        reportRespVo.setDifferenceRate(differenceRate);
                    }
                }
            });
        }
        return resultFa;
    }

    public void conversionUnit(FaReportRespVo reportRespVo, SysSubjectTarget target) {
        if (StringUtils.isEmpty((Object)target.getConversionUnit())) {
            return;
        }
        if (!target.getUnit().contains("\u6b27")) {
            return;
        }
        BigDecimal actual = BigDecimal.ZERO;
        BigDecimal budget = BigDecimal.ZERO;
        if ("1".equals(target.getConversionUnit())) {
            if (null != reportRespVo.getActual()) {
                actual = reportRespVo.getActual().divide(new BigDecimal(10000), 2, 4);
            }
            if (null != reportRespVo.getBudget()) {
                budget = reportRespVo.getBudget().divide(new BigDecimal(10000), 2, 4);
            }
        }
        if ("2".equals(target.getConversionUnit())) {
            if (null != reportRespVo.getActual()) {
                actual = reportRespVo.getActual().divide(new BigDecimal(100000000), 2, 4);
            }
            if (null != reportRespVo.getBudget()) {
                budget = reportRespVo.getBudget().divide(new BigDecimal(100000000), 2, 4);
            }
        }
        reportRespVo.setActual(actual);
        if ("\u4e07\u6b27/\u4eba".equals(target.getUnit())) {
            reportRespVo.setBudget(null);
        } else {
            reportRespVo.setBudget(budget);
        }
    }

    public void processDateQuery(ReportReqVo t, DateReqVo dateReqVo) {
        t.setStartYear(dateReqVo.getStartYear());
        t.setEndYear(dateReqVo.getEndYear());
        t.setYear(dateReqVo.getYear());
        t.setMonth(dateReqVo.getMonth());
        t.setStartMonth(dateReqVo.getStartMonth());
        t.setEndMonth(dateReqVo.getEndMonth());
        t.setQuarter(dateReqVo.getQuarter());
        t.setStartQuarter(dateReqVo.getStartQuarter());
        t.setEndQuarter(dateReqVo.getEndQuarter());
    }

    public FaTargetRespVo getCurrentFaTargetRespVo(FaTargetTypeEnum targetTypeEnum, SysSubjectTarget target, String type, List<FaReportRespVo> faReportRespVos) {
        FaTargetRespVo resultFa = new FaTargetRespVo();
        resultFa.setTargetName(targetTypeEnum.getTargetName());
        resultFa.setTargetNameEn(targetTypeEnum.getTargetNameEn());
        resultFa.setTargetId(target.getId());
        resultFa.setStaLat(targetTypeEnum.getStaLat());
        resultFa.setType(type);
        resultFa.setLevel(target.getTargetLevel());
        resultFa.setSn(target.getSn());
        resultFa.setTargetUnit(target.getUnit());
        resultFa.setLinksType(target.getLinksType());
        resultFa.setContainType(target.getType());
        if ("\u4e07\u6b27/\u4eba".equals(target.getUnit())) {
            resultFa.setStaLat("3");
            resultFa.setTargetUnit("10K\u20ac/person");
        }
        if ("\u4e07\u6b27".equals(target.getUnit())) {
            resultFa.setTargetUnit("10K\u20ac");
        }
        if ("1".equals(target.getConversionUnit())) {
            resultFa.setTargetUnit("10K\u20ac");
        }
        if ("2".equals(target.getConversionUnit())) {
            resultFa.setTargetUnit("\u4ebf\u6b27");
        }
        if ("\u4eba".equals(target.getUnit())) {
            resultFa.setTargetUnit("person");
        }
        if (!StringUtils.isEmpty((Object)target.getUnit()) && !CollectionUtils.isEmpty(faReportRespVos)) {
            faReportRespVos.forEach(reportRespVo -> {
                this.conversionUnit((FaReportRespVo)reportRespVo, target);
                if (target.getUnit().contains("\u4eba")) {
                    reportRespVo.setBudget(null);
                }
                if (StringUtils.isEmpty((Object)resultFa.getStaLat())) {
                    return;
                }
                if (resultFa.getStaLat().length() < 2) {
                    return;
                }
                if (null != reportRespVo.getBudget() && null != reportRespVo.getActual()) {
                    BigDecimal differenceValue = reportRespVo.getActual().subtract(reportRespVo.getBudget());
                    reportRespVo.setDifferenceValue(differenceValue);
                    if (!"%".equals(target.getUnit())) {
                        String differenceRate = null;
                        if (0.0 != reportRespVo.getBudget().doubleValue()) {
                            differenceRate = differenceValue.divide(reportRespVo.getBudget(), 2, 4).multiply(new BigDecimal("100")) + "%";
                        }
                        reportRespVo.setDifferenceRate(differenceRate);
                    }
                }
            });
        }
        return resultFa;
    }

    public OpDateReqVo processOpDateReqVo(OpReportReqVo t, String type) {
        AtomicReference<OpDateReqVo> dateReqVo = new AtomicReference<OpDateReqVo>(new OpDateReqVo());
        List<OpQueryReqVo> queryList = t.getQueryList();
        if (CollectionUtils.isEmpty(queryList)) {
            return this.createOpDateReqVo(type, dateReqVo.get());
        }
        Map<String, OpQueryReqVo> queryMap = queryList.stream().collect(Collectors.toMap(item -> item.getType(), item -> item));
        if (!queryMap.containsKey(type)) {
            return this.createOpDateReqVo(type, dateReqVo.get());
        }
        queryMap.forEach((k, v) -> {
            if (!k.equals(type)) {
                return;
            }
            OpQueryReqVo queryReqVo = (OpQueryReqVo)queryMap.get(type);
            if (null != queryReqVo && null != queryReqVo.getDateReqVo()) {
                dateReqVo.set(queryReqVo.getDateReqVo());
            }
            this.createOpDateReqVo(type, (OpDateReqVo)dateReqVo.get());
        });
        return dateReqVo.get();
    }

    public OpDateReqVo createOpDateReqVo(String type, OpDateReqVo t) {
        return t;
    }

    public void processOpDateQuery(OpReportReqVo t, OpDateReqVo dateReqVo) {
        t.setStartYear(dateReqVo.getStartYear());
        t.setEndYear(dateReqVo.getEndYear());
        t.setYear(dateReqVo.getYear());
        t.setMonth(dateReqVo.getMonth());
        t.setStartMonth(dateReqVo.getStartMonth());
        t.setEndMonth(dateReqVo.getEndMonth());
        t.setCustomer(dateReqVo.getCustomer());
        t.setProduct(dateReqVo.getProduct());
        t.setSubjectCode(dateReqVo.getSubjectCode());
    }
}

