/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.cqlt.manager.impl;

import com.artfess.base.exception.BaseException;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.cqlt.dao.QfEuroRatesMDao;
import com.artfess.cqlt.manager.QfEuroRatesDManager;
import com.artfess.cqlt.manager.QfEuroRatesMManager;
import com.artfess.cqlt.model.QfEuroRatesD;
import com.artfess.cqlt.model.QfEuroRatesM;
import com.artfess.i18n.util.I18nUtil;
import com.artfess.poi.util.HeaderNode;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class QfEuroRatesMManagerImpl
extends BaseManagerImpl<QfEuroRatesMDao, QfEuroRatesM>
implements QfEuroRatesMManager {
    @Autowired
    private QfEuroRatesDManager qfEuroRatesDManager;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean insertInfo(QfEuroRatesM t) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"fill_year_", (Object)t.getFillYear());
        queryWrapper.eq((Object)"report_id_", (Object)t.getReportId());
        List financeLeaseMS = ((QfEuroRatesMDao)this.baseMapper).selectList((Wrapper)queryWrapper);
        if (!CollectionUtils.isEmpty((Collection)financeLeaseMS)) {
            throw new BaseException(I18nUtil.getMessage((String)"QfOperationKpiM.repeat", (Locale)LocaleContextHolder.getLocale()));
        }
        int insert = ((QfEuroRatesMDao)this.baseMapper).insert((Object)t);
        return insert > 0;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean updateInfo(QfEuroRatesM t) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"fill_year_", (Object)t.getFillYear());
        queryWrapper.eq((Object)"report_id_", (Object)t.getReportId());
        queryWrapper.ne((Object)"id_", (Object)t.getId());
        List financeLeaseMS = ((QfEuroRatesMDao)this.baseMapper).selectList((Wrapper)queryWrapper);
        if (!CollectionUtils.isEmpty((Collection)financeLeaseMS)) {
            throw new BaseException(I18nUtil.getMessage((String)"QfOperationKpiM.repeat", (Locale)LocaleContextHolder.getLocale()));
        }
        int insert = ((QfEuroRatesMDao)this.baseMapper).updateById((Object)t);
        return insert > 0;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean updateStatus(QfEuroRatesM t) {
        QfEuroRatesM financeLeaseM = (QfEuroRatesM)((Object)((QfEuroRatesMDao)this.baseMapper).selectById((Serializable)((Object)t.getId())));
        if (null == financeLeaseM) {
            return false;
        }
        financeLeaseM.setStatus(financeLeaseM.getStatus() == 0 ? 1 : 0);
        int i = ((QfEuroRatesMDao)this.baseMapper).updateById((Object)financeLeaseM);
        return i > 0;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean importExcel(List<HeaderNode> list, String mainId) {
        if (CollectionUtils.isEmpty(list)) {
            return false;
        }
        QfEuroRatesM mainInfo = (QfEuroRatesM)((Object)((QfEuroRatesMDao)this.baseMapper).selectById((Serializable)((Object)mainId)));
        Assert.notNull((Object)((Object)mainInfo), (String)I18nUtil.getMessage((String)"filldata.notExist", (Locale)LocaleContextHolder.getLocale()));
        this.removeInfo(mainId);
        List<HeaderNode> headerNodeList = list.stream().collect(Collectors.groupingBy(HeaderNode::getRow)).get(0);
        HashMap headerMap = Maps.newHashMap();
        for (HeaderNode headerNode : headerNodeList) {
            headerMap.put(headerNode.getColumn(), headerNode.getHeaderName());
        }
        Map<Integer, List<HeaderNode>> detailMap = list.stream().collect(Collectors.groupingBy(HeaderNode::getColumn));
        List<HeaderNode> types = detailMap.get(0);
        HashMap rowMap = Maps.newHashMap();
        for (HeaderNode headerNode : types) {
            rowMap.put(headerNode.getRow(), headerNode.getHeaderName());
        }
        ArrayList detailList = Lists.newArrayList();
        for (Map.Entry<Integer, List<HeaderNode>> entry : detailMap.entrySet()) {
            Integer column = entry.getKey();
            List<HeaderNode> nodes = entry.getValue();
            String month = (String)headerMap.get(column);
            for (HeaderNode node : nodes) {
                if (0 == node.getRow() || 0 == node.getColumn()) continue;
                String type = (String)rowMap.get(node.getRow());
                QfEuroRatesD euroRatesD = new QfEuroRatesD();
                euroRatesD.setMonth(month.substring(0, month.length() - 1));
                euroRatesD.setType(type);
                euroRatesD.setFillDate(LocalDate.now());
                euroRatesD.setMainId(mainId);
                if (StringUtils.isEmpty((Object)node.getHeaderName())) continue;
                euroRatesD.setFillData(new BigDecimal(node.getHeaderName()).multiply(new BigDecimal(100)));
                detailList.add(euroRatesD);
            }
        }
        boolean bl = this.qfEuroRatesDManager.saveBatch(detailList);
        return bl;
    }

    private void removeInfo(String mainId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"main_id_", (Object)mainId);
        this.qfEuroRatesDManager.remove((Wrapper)queryWrapper);
    }
}

