/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.cqlt.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.annotation.PowerLogInfo;
import com.artfess.base.controller.BaseController;
import com.artfess.base.enums.LogType;
import com.artfess.base.enums.OperationType;
import com.artfess.base.model.CommonResult;
import com.artfess.base.valid.AddGroup;
import com.artfess.base.valid.UpdateGroup;
import com.artfess.cqlt.manager.SysSubjectClassManager;
import com.artfess.cqlt.model.SysSubjectClass;
import com.artfess.i18n.util.I18nUtil;
import com.artfess.poi.util.ExcelUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@Api(tags={"\u4e3b\u9898/\u4e13\u9898\u5206\u7c7b\u8868"})
@RequestMapping(value={"/sys/subject/class/"})
@ApiGroup(group={"group_biz"})
public class SysSubjectClassController
extends BaseController<SysSubjectClassManager, SysSubjectClass> {
    private static final Logger log = LoggerFactory.getLogger(SysSubjectClassController.class);

    @PostMapping(value={"/"})
    @ApiOperation(value="\u6dfb\u52a0\u5b9e\u4f53\u7684\u63a5\u53e3")
    public CommonResult<String> create(@ApiParam(name="model", value="\u5b9e\u4f53\u4fe1\u606f") @RequestBody @Validated(value={AddGroup.class}) SysSubjectClass t) {
        boolean b = ((SysSubjectClassManager)this.baseService).saveInfo(t);
        if (!b) {
            return new CommonResult(false, I18nUtil.getMessage((String)"option.fail", (Locale)LocaleContextHolder.getLocale()), null);
        }
        return new CommonResult(true, I18nUtil.getMessage((String)"option.success", (Locale)LocaleContextHolder.getLocale()), null);
    }

    @PutMapping(value={"/"})
    @ApiOperation(value="\u66f4\u65b0\u5b9e\u4f53")
    public CommonResult<String> updateById(@ApiParam(name="model", value="\u5b9e\u4f53\u4fe1\u606f") @RequestBody @Validated(value={UpdateGroup.class}) SysSubjectClass t) {
        boolean b = ((SysSubjectClassManager)this.baseService).updateInfo(t);
        if (!b) {
            return new CommonResult(false, I18nUtil.getMessage((String)"update.fail", (Locale)LocaleContextHolder.getLocale()), null);
        }
        return new CommonResult(true, I18nUtil.getMessage((String)"option.success", (Locale)LocaleContextHolder.getLocale()), null);
    }

    @ApiOperation(value="\u4e3b\u9898/\u4e13\u9898\u5206\u7c7b\u8868\u5bfc\u5165")
    @PostMapping(value={"/importExcel"})
    public CommonResult<String> importExcel(@RequestParam(value="file") MultipartFile file) throws Exception {
        try {
            ExcelUtils excelUtil = new ExcelUtils(SysSubjectClass.class);
            List list = excelUtil.importExcel(null, file.getInputStream());
            boolean result = ((SysSubjectClassManager)this.baseService).importExcel(list);
            if (!result) {
                throw new IllegalArgumentException(I18nUtil.getMessage((String)"import.fail", (Locale)LocaleContextHolder.getLocale()));
            }
            return new CommonResult();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IllegalArgumentException(I18nUtil.getMessage((String)"import.fail", (Locale)LocaleContextHolder.getLocale()) + "," + e.getMessage());
        }
    }

    @GetMapping(value={"/getTree/{targetId}"})
    @ApiOperation(value="\u83b7\u53d6\u5f53\u524d\u6307\u6807\u5173\u8054\u6811")
    @PowerLogInfo(logType=LogType.BIZ, operaionType=OperationType.QUERY, description="\u83b7\u53d6\u5f53\u524d\u6307\u6807\u5173\u8054\u6811")
    public CommonResult<String> getTree(@ApiParam(name="targetId", value="\u6307\u6807id") @PathVariable String targetId) {
        List<SysSubjectClass> list = ((SysSubjectClassManager)this.baseService).getTree(targetId);
        return CommonResult.success(list, null);
    }

    @GetMapping(value={"/getPatentTarget/{targetId}"})
    @ApiOperation(value="\u83b7\u53d6\u5f53\u524d\u6307\u6807\u7236\u7ea7\u6307\u6807")
    @PowerLogInfo(logType=LogType.BIZ, operaionType=OperationType.QUERY, description="\u83b7\u53d6\u5f53\u524d\u6307\u6807\u7236\u7ea7\u6307\u6807")
    public CommonResult<String> getPatentTarget(@ApiParam(name="targetId", value="\u6307\u6807id") @PathVariable String targetId) {
        List<SysSubjectClass> list = ((SysSubjectClassManager)this.baseService).getPatentTarget(targetId);
        return CommonResult.success(list, null);
    }
}

