/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.cqlt.manager.impl;

import com.artfess.base.enums.DelStatusEnum;
import com.artfess.base.exception.BaseException;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.cqlt.dao.QfOperationCompanyCipMDao;
import com.artfess.cqlt.manager.QfEnterpriseInfoManager;
import com.artfess.cqlt.manager.QfOperationCompanyCipDManager;
import com.artfess.cqlt.manager.QfOperationCompanyCipMManager;
import com.artfess.cqlt.model.QfEnterpriseInfo;
import com.artfess.cqlt.model.QfOperationCompanyCipD;
import com.artfess.cqlt.model.QfOperationCompanyCipM;
import com.artfess.i18n.util.I18nUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class QfOperationCompanyCipMManagerImpl
extends BaseManagerImpl<QfOperationCompanyCipMDao, QfOperationCompanyCipM>
implements QfOperationCompanyCipMManager {
    @Autowired
    private QfOperationCompanyCipDManager operationCipDManager;
    @Autowired
    private QfEnterpriseInfoManager enterpriseInfoManager;

    private void processDetail(List<QfOperationCompanyCipD> list, String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"main_id_", (Object)id);
        this.operationCipDManager.remove((Wrapper)queryWrapper);
        list.forEach(detail -> detail.setMainId(id));
        this.operationCipDManager.saveBatch(list);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean importExcel(List<QfOperationCompanyCipD> list, String mainId) {
        QfOperationCompanyCipM cipM = (QfOperationCompanyCipM)((Object)((QfOperationCompanyCipMDao)this.baseMapper).selectById((Serializable)((Object)mainId)));
        Assert.notNull((Object)((Object)cipM), (String)I18nUtil.getMessage((String)"filldata.notExist", (Locale)LocaleContextHolder.getLocale()));
        Assert.isTrue((!"1".equals(cipM.getStatus()) ? 1 : 0) != 0, (String)I18nUtil.getMessage((String)"data_operate", (Locale)LocaleContextHolder.getLocale()));
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"IS_DELE_", (Object)DelStatusEnum.N.getType());
        Map<String, QfEnterpriseInfo> enterpriseInfoMap = this.enterpriseInfoManager.getEnterpriseInfoMap(null);
        StringBuffer sb = new StringBuffer();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"main_id_", (Object)mainId);
        this.operationCipDManager.remove((Wrapper)queryWrapper);
        list.forEach(detail -> {
            detail.setMainId(mainId);
            detail.setFillDate(cipM.getFillDate());
            if (StringUtils.isEmpty((Object)detail.getEnterpriseCode())) {
                throw new BaseException(I18nUtil.getMessage((String)"fill.code", (Locale)LocaleContextHolder.getLocale()));
            }
            if (!enterpriseInfoMap.containsKey(detail.getEnterpriseCode())) {
                sb.append(",");
                sb.append(detail.getEnterpriseCode());
            } else {
                QfEnterpriseInfo qfEnterpriseInfo = (QfEnterpriseInfo)((Object)((Object)enterpriseInfoMap.get(detail.getEnterpriseCode())));
                detail.setEnterpriseName(qfEnterpriseInfo.getName());
                detail.setEnterpriseType(qfEnterpriseInfo.getEconomyType());
                detail.setEnterpriseArea(qfEnterpriseInfo.getContinent());
            }
        });
        boolean b = this.operationCipDManager.saveBatch(list);
        return b;
    }

    @Override
    public boolean updateStatus(QfOperationCompanyCipM t) {
        QfOperationCompanyCipM cipM = (QfOperationCompanyCipM)((Object)((QfOperationCompanyCipMDao)this.baseMapper).selectById((Serializable)((Object)t.getId())));
        if (null == cipM) {
            return false;
        }
        cipM.setStatus(cipM.getStatus() == 0 ? 1 : 0);
        int i = ((QfOperationCompanyCipMDao)this.baseMapper).updateById((Object)cipM);
        return i > 0;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean insertInfo(QfOperationCompanyCipM t) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"fill_year_", (Object)t.getFillYear());
        queryWrapper.eq((Object)"fill_month_", (Object)t.getFillMonth());
        queryWrapper.eq((Object)"report_id_", (Object)t.getReportId());
        List operationCipMS = ((QfOperationCompanyCipMDao)this.baseMapper).selectList((Wrapper)queryWrapper);
        if (!CollectionUtils.isEmpty((Collection)operationCipMS)) {
            throw new BaseException(I18nUtil.getMessage((String)"QfOperationKpiM.repeat", (Locale)LocaleContextHolder.getLocale()));
        }
        int insert = ((QfOperationCompanyCipMDao)this.baseMapper).insert((Object)t);
        return insert > 0;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean updateInfo(QfOperationCompanyCipM t) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"fill_year_", (Object)t.getFillYear());
        queryWrapper.eq((Object)"fill_month_", (Object)t.getFillMonth());
        queryWrapper.eq((Object)"report_id_", (Object)t.getReportId());
        queryWrapper.ne((Object)"id_", (Object)t.getId());
        List operationCipMS = ((QfOperationCompanyCipMDao)this.baseMapper).selectList((Wrapper)queryWrapper);
        if (!CollectionUtils.isEmpty((Collection)operationCipMS)) {
            throw new BaseException(I18nUtil.getMessage((String)"QfOperationKpiM.repeat", (Locale)LocaleContextHolder.getLocale()));
        }
        int insert = ((QfOperationCompanyCipMDao)this.baseMapper).updateById((Object)t);
        return insert > 0;
    }
}

