/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.cqlt.manager.impl;

import com.artfess.base.enums.OperationTargetTypeEnum;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.cqlt.dao.QfOperationNewOrdersDDao;
import com.artfess.cqlt.dao.QfOperationNewOrdersMDao;
import com.artfess.cqlt.manager.QfOperationNewOrdersDManager;
import com.artfess.cqlt.model.QfOperationNewOrdersD;
import com.artfess.cqlt.model.QfOperationNewOrdersM;
import com.artfess.cqlt.model.SysSubjectTarget;
import com.artfess.cqlt.utils.FinancialTimeUtils;
import com.artfess.cqlt.vo.OpDateReqVo;
import com.artfess.cqlt.vo.OpReportReqVo;
import com.artfess.cqlt.vo.OpReportRespVo;
import com.artfess.cqlt.vo.OpTargetRespVo;
import com.artfess.i18n.util.I18nUtil;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import javax.annotation.Resource;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class QfOperationNewOrdersDManagerImpl
extends BaseManagerImpl<QfOperationNewOrdersDDao, QfOperationNewOrdersD>
implements QfOperationNewOrdersDManager {
    @Resource
    private QfOperationNewOrdersMDao ordersMDao;
    private FinancialTimeUtils financialTimeUtils = new FinancialTimeUtils();

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean batchSave(QfOperationNewOrdersM t) {
        Assert.hasText((String)t.getId(), (String)I18nUtil.getMessage((String)"QfOperationKpiM.reportId", (Locale)LocaleContextHolder.getLocale()));
        t.getList().forEach(detail -> detail.setMainId(t.getId()));
        boolean b = this.saveOrUpdateBatch(t.getList());
        return b;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean batchUpdate(QfOperationNewOrdersM t) {
        Assert.hasText((String)t.getId(), (String)I18nUtil.getMessage((String)"QfOperationKpiM.reportId", (Locale)LocaleContextHolder.getLocale()));
        QfOperationNewOrdersM qfOperationNewOrdersM = (QfOperationNewOrdersM)((Object)this.ordersMDao.selectById((Serializable)((Object)t.getId())));
        Assert.notNull((Object)((Object)qfOperationNewOrdersM), (String)I18nUtil.getMessage((String)"filldata.notExist", (Locale)LocaleContextHolder.getLocale()));
        Assert.isTrue((!"1".equals(qfOperationNewOrdersM.getStatus()) ? 1 : 0) != 0, (String)I18nUtil.getMessage((String)"data_operate", (Locale)LocaleContextHolder.getLocale()));
        t.getList().forEach(detail -> detail.setMainId(t.getId()));
        boolean b = this.saveOrUpdateBatch(t.getList());
        return b;
    }

    @Override
    public List<OpReportRespVo> yearData(OpReportReqVo t) {
        return ((QfOperationNewOrdersDDao)this.baseMapper).yearData(t);
    }

    @Override
    public List<OpTargetRespVo> dataAnalysis(OpReportReqVo t, SysSubjectTarget target) {
        List<String> typeList = Arrays.asList(target.getType().split(","));
        ArrayList resultList = Lists.newArrayList();
        typeList.forEach(type -> {
            OperationTargetTypeEnum targetTypeEnum = OperationTargetTypeEnum.getTarget((String)type);
            if (null == targetTypeEnum) {
                return;
            }
            OpDateReqVo dateReqVo = this.financialTimeUtils.processOpDateReqVo(t, (String)type);
            this.financialTimeUtils.processOpDateQuery(t, dateReqVo);
            switch (targetTypeEnum) {
                case scqysj: {
                    t.setYear(null);
                    this.yearAnalysis(target, t, resultList, targetTypeEnum);
                    break;
                }
                case fscqysj: {
                    this.revenueLifeAnalysis(target, t, resultList, targetTypeEnum);
                    break;
                }
                case zzlfx: {
                    this.yearAnalysis(target, t, resultList, targetTypeEnum);
                    break;
                }
                case jtwclfx: {
                    this.revenueLifeAnalysis(target, t, resultList, targetTypeEnum);
                    break;
                }
                case zqywclfx: {
                    this.yearAreaAnalysis(target, t, resultList, targetTypeEnum);
                    break;
                }
                case zbfx: {
                    this.areaRevenueLifeAnalysis(target, t, resultList, targetTypeEnum);
                    break;
                }
                case zqydysj: {
                    t.setYear(null);
                    this.yearEbitdaAnalysis(target, t, resultList, targetTypeEnum);
                    break;
                }
                case ndlbsy: {
                    t.setYear(null);
                    this.revenueLifeAnalysis(target, t, resultList, targetTypeEnum);
                    break;
                }
            }
        });
        return resultList;
    }

    private void yearEbitdaAnalysis(SysSubjectTarget target, OpReportReqVo t, List<OpTargetRespVo> resultList, OperationTargetTypeEnum targetTypeEnum) {
        OpTargetRespVo resultFa = this.getOpTargetRespVo(target, targetTypeEnum);
        List<OpReportRespVo> opReportRespVos = ((QfOperationNewOrdersDDao)this.baseMapper).yearEbitdaData(t);
        opReportRespVos.forEach(resp -> resp.setActual(resp.getActual().multiply(new BigDecimal(100))));
        resultFa.setTargetUnit("%");
        resultFa.setResultData(opReportRespVos);
        resultList.add(resultFa);
    }

    private void areaRevenueLifeAnalysis(SysSubjectTarget target, OpReportReqVo t, List<OpTargetRespVo> resultList, OperationTargetTypeEnum targetTypeEnum) {
        OpTargetRespVo resultFa = this.getOpTargetRespVo(target, targetTypeEnum);
        List<OpReportRespVo> opReportRespVos = ((QfOperationNewOrdersDDao)this.baseMapper).areaRevenueLifeData(t);
        resultFa.setResultData(opReportRespVos);
        resultList.add(resultFa);
    }

    private void yearAreaAnalysis(SysSubjectTarget target, OpReportReqVo t, List<OpTargetRespVo> resultList, OperationTargetTypeEnum targetTypeEnum) {
        OpTargetRespVo resultFa = this.getOpTargetRespVo(target, targetTypeEnum);
        List<OpReportRespVo> opReportRespVos = ((QfOperationNewOrdersDDao)this.baseMapper).yearAreaData(t);
        resultFa.setResultData(opReportRespVos);
        resultList.add(resultFa);
    }

    private void revenueLifeAnalysis(SysSubjectTarget target, OpReportReqVo t, List<OpTargetRespVo> resultList, OperationTargetTypeEnum targetTypeEnum) {
        OpTargetRespVo resultFa = this.getOpTargetRespVo(target, targetTypeEnum);
        List<OpReportRespVo> opReportRespVos = ((QfOperationNewOrdersDDao)this.baseMapper).revenueLifeData(t);
        resultFa.setResultData(opReportRespVos);
        resultList.add(resultFa);
    }

    private void yearAnalysis(SysSubjectTarget target, OpReportReqVo t, List<OpTargetRespVo> resultList, OperationTargetTypeEnum targetTypeEnum) {
        OpTargetRespVo resultFa = this.getOpTargetRespVo(target, targetTypeEnum);
        List<OpReportRespVo> opReportRespVos = ((QfOperationNewOrdersDDao)this.baseMapper).yearData(t);
        resultFa.setResultData(opReportRespVos);
        resultList.add(resultFa);
    }

    private OpTargetRespVo getOpTargetRespVo(SysSubjectTarget target, OperationTargetTypeEnum targetTypeEnum) {
        String type = targetTypeEnum.getType().toString();
        OpTargetRespVo resultFa = new OpTargetRespVo();
        resultFa.setTargetId(target.getId());
        resultFa.setTargetName(targetTypeEnum.getTargetName());
        resultFa.setTargetNameEn(targetTypeEnum.getTargetNameEn());
        resultFa.setTargetUnit(target.getUnit());
        resultFa.setType(type);
        resultFa.setSn(targetTypeEnum.getType());
        resultFa.setStaLat(targetTypeEnum.getStaLat());
        return resultFa;
    }
}

