/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.cqlt.manager.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.trans.TransitionUtil;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.CommonUtil;
import com.artfess.cqlt.dao.QfFinancialStatisticalDao;
import com.artfess.cqlt.manager.QfFinancialStatisticalManager;
import com.artfess.cqlt.manager.SysSubjectTargetManager;
import com.artfess.cqlt.model.QfFinancialStatistical;
import com.artfess.cqlt.model.SysSubjectTarget;
import com.artfess.cqlt.vo.DataInfoVo;
import com.artfess.cqlt.vo.FaReportRespVo;
import com.artfess.cqlt.vo.FaTargetRespVo;
import com.artfess.cqlt.vo.FinancialVo;
import com.artfess.cqlt.vo.ReportReqVo;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class QfFinancialStatisticalManagerImpl
extends BaseManagerImpl<QfFinancialStatisticalDao, QfFinancialStatistical>
implements QfFinancialStatisticalManager {
    private static final Logger log = LoggerFactory.getLogger(QfFinancialStatisticalManagerImpl.class);
    @Autowired
    private SysSubjectTargetManager sysSubjectTargetManager;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean saveData(List<FinancialVo> list, DataInfoVo dataInfoVo, Integer dataType) {
        if (CollectionUtils.isEmpty(list)) {
            return false;
        }
        List<SysSubjectTarget> targetList = this.sysSubjectTargetManager.getTargetList("Finance");
        ArrayList dataList = Lists.newArrayList();
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"year_", (Object)dataInfoVo.getYear());
        query.eq((Object)"quarter_", (Object)dataInfoVo.getQuarter());
        query.eq((Object)"month_", (Object)dataInfoVo.getMonth());
        List qfFinancialStatisticals = ((QfFinancialStatisticalDao)this.baseMapper).selectList((Wrapper)query);
        if (CollectionUtils.isEmpty((Collection)qfFinancialStatisticals)) {
            targetList.forEach(target -> this.saveFinancialStatistical((SysSubjectTarget)((Object)target), dataList, list, dataType, dataInfoVo));
        } else {
            Map<String, List<QfFinancialStatistical>> statisticalMap = qfFinancialStatisticals.stream().collect(Collectors.groupingBy(QfFinancialStatistical::getTargetId));
            targetList.forEach(target -> {
                List statisticalList = Lists.newArrayList();
                if (statisticalMap.containsKey(target.getSubjectId())) {
                    statisticalList = (List)statisticalMap.get(target.getSubjectId());
                }
                this.updateFinancialStatistical((SysSubjectTarget)((Object)target), dataList, statisticalList, list, dataType);
            });
        }
        try {
            this.partitionSave(dataList);
            return true;
        }
        catch (Exception e) {
            log.error("\u8d22\u52a1\u5927\u5c4f\u62a5\u8868\u5b9e\u9645\u6570\u636e\u751f\u6210\u5931\u8d25:{}", (Object)e.getMessage());
            return false;
        }
    }

    @Override
    public List<FaTargetRespVo> data(ReportReqVo t) {
        if (StringUtils.isEmpty((Object)t.getTargetId())) {
            t.setTargetLevel("1");
        }
        List<QfFinancialStatistical> list = ((QfFinancialStatisticalDao)this.baseMapper).getGroupData(t);
        Map<String, List<QfFinancialStatistical>> statisticalMap = list.stream().collect(Collectors.groupingBy(QfFinancialStatistical::getTargetId));
        ArrayList data = Lists.newArrayList();
        statisticalMap.forEach((k, v) -> {
            QfFinancialStatistical qfFinancialStatistical = new QfFinancialStatistical();
            qfFinancialStatistical.setData((List<QfFinancialStatistical>)v);
            qfFinancialStatistical.setTargetId((String)k);
            if (!CollectionUtils.isEmpty((Collection)v)) {
                QfFinancialStatistical financialStatistical = (QfFinancialStatistical)((Object)((Object)v.get(0)));
                qfFinancialStatistical.setTargetUnit(financialStatistical.getTargetUnit());
                qfFinancialStatistical.setTargetName(financialStatistical.getTargetName());
                qfFinancialStatistical.setTargetNameEn(financialStatistical.getTargetNameEn());
                qfFinancialStatistical.setType(financialStatistical.getType());
                qfFinancialStatistical.setAnalyseType(financialStatistical.getAnalyseType());
                qfFinancialStatistical.setLargerType(financialStatistical.getLargerType());
                qfFinancialStatistical.setStaLat(financialStatistical.getStaLat());
            }
            data.add(qfFinancialStatistical);
        });
        ArrayList resultList = Lists.newArrayList();
        data.forEach(fa -> {
            if (StringUtils.isEmpty((Object)fa.getType())) {
                return;
            }
            List<String> typeList = Arrays.asList(fa.getType().split(","));
            typeList.forEach(type -> {
                FaTargetRespVo resultFa = new FaTargetRespVo();
                resultFa.setTargerId(fa.getTargetId());
                resultFa.setTargetName(fa.getTargetName());
                resultFa.setTargetNameEn(fa.getTargetNameEn());
                resultFa.setTargetUnit(fa.getTargetUnit());
                resultFa.setType((String)type);
                switch (type) {
                    case "1": {
                        List reportRespVos = TransitionUtil.copyList(fa.getData(), FaReportRespVo.class, null);
                        resultFa.setResultData(reportRespVos);
                        resultList.add(resultFa);
                        break;
                    }
                    case "2": {
                        break;
                    }
                    case "3": {
                        break;
                    }
                    case "4": {
                        break;
                    }
                    case "5": {
                        break;
                    }
                    case "6": {
                        if (!CollectionUtils.isEmpty(fa.getData())) {
                            resultFa.setShowValue(fa.getData().get(fa.getData().size() - 1).getActual());
                        }
                        resultList.add(resultFa);
                        break;
                    }
                }
            });
        });
        return resultList;
    }

    @Override
    public List<FaReportRespVo> enterpriseData(ReportReqVo t) {
        Assert.hasText((String)t.getTargetId(), (String)"\u8bf7\u9009\u62e9\u8981\u7edf\u8ba1\u7684\u6307\u6807id");
        int year = LocalDate.now().getYear();
        t.setYear(year);
        return ((QfFinancialStatisticalDao)this.baseMapper).enterpriseData(t);
    }

    @Override
    public List<FaTargetRespVo> fromUnderData(ReportReqVo t) {
        List<QfFinancialStatistical> monthData;
        List<QfFinancialStatistical> quarterData;
        List<QfFinancialStatistical> yearData;
        ArrayList resultList = Lists.newArrayList();
        if (null == t.getYear()) {
            int year = LocalDate.now().getYear();
            t.setYear(year);
        }
        if (null == t.getStartYear() || null == t.getEndYear()) {
            t.setEndYear(t.getYear());
            t.setStartYear(t.getYear() - 10);
        }
        if (null == t.getStartQuarter() || null == t.getEndQuarter()) {
            t.setEndQuarter(4);
            t.setStartQuarter(1);
        }
        if (null == t.getStartMonth() || null == t.getEndMonth()) {
            t.setEndMonth(12);
            t.setStartMonth(1);
        }
        if (!CollectionUtils.isEmpty(yearData = ((QfFinancialStatisticalDao)this.baseMapper).yearData(t))) {
            FaTargetRespVo resultFa = new FaTargetRespVo();
            resultFa.setTargerId(yearData.get(0).getTargetId());
            resultFa.setTargetName(yearData.get(0).getTargetName());
            resultFa.setTargetNameEn(yearData.get(0).getTargetNameEn());
            resultFa.setTargetUnit(yearData.get(0).getTargetUnit());
            resultFa.setType("2");
            List reportRespVos = TransitionUtil.copyList(yearData, FaReportRespVo.class, null);
            resultFa.setResultData(reportRespVos);
            resultList.add(resultFa);
        }
        if (!CollectionUtils.isEmpty(quarterData = ((QfFinancialStatisticalDao)this.baseMapper).quarterData(t))) {
            FaTargetRespVo resultFa = new FaTargetRespVo();
            resultFa.setType("3");
            List reportRespVos = TransitionUtil.copyList(quarterData, FaReportRespVo.class, null);
            resultFa.setResultData(reportRespVos);
            resultList.add(resultFa);
        }
        if (!CollectionUtils.isEmpty(monthData = ((QfFinancialStatisticalDao)this.baseMapper).monthData(t))) {
            FaTargetRespVo resultFa = new FaTargetRespVo();
            resultFa.setType("4");
            List reportRespVos = TransitionUtil.copyList(monthData, FaReportRespVo.class, null);
            resultFa.setResultData(reportRespVos);
            resultList.add(resultFa);
        }
        SysSubjectTarget target = (SysSubjectTarget)this.sysSubjectTargetManager.get((Serializable)((Object)t.getTargetId()));
        t.setParentTargetId(target.getSubjectId());
        t.setTargetId(null);
        List<QfFinancialStatistical> fromUnderTargtYearData = ((QfFinancialStatisticalDao)this.baseMapper).yearData(t);
        if (!CollectionUtils.isEmpty(fromUnderTargtYearData)) {
            fromUnderTargtYearData.forEach(targetYearData -> {
                if (StringUtils.isEmpty((Object)targetYearData.getAnalyseType())) {
                    return;
                }
            });
            FaTargetRespVo resultFa = new FaTargetRespVo();
            resultFa.setType("1");
            List reportRespVos = TransitionUtil.copyList(fromUnderTargtYearData, FaReportRespVo.class, null);
            resultFa.setResultData(reportRespVos);
            resultList.add(resultFa);
        }
        return resultList;
    }

    private void partitionSave(List<QfFinancialStatistical> detailList) throws InterruptedException {
        List partition = BeanUtils.partition(detailList, (int)(detailList.size() / 10));
        ExecutorService executorService = Executors.newFixedThreadPool(partition.size());
        CountDownLatch countDownLatch = new CountDownLatch(partition.size());
        int i = 0;
        while (i < partition.size()) {
            int finalI = i++;
            executorService.execute(() -> {
                List importParamDTOList = (List)partition.get(finalI);
                this.saveOrUpdateBatch(importParamDTOList);
                countDownLatch.countDown();
            });
        }
        countDownLatch.await();
        executorService.shutdown();
    }

    private void saveFinancialStatistical(SysSubjectTarget target, List<QfFinancialStatistical> dataList, List<FinancialVo> list, Integer dataType, DataInfoVo dataInfoVo) {
        Map<String, List<FinancialVo>> enterpriseMap = list.stream().collect(Collectors.groupingBy(FinancialVo::getEnterpriseCode));
        String targetCalculation = target.getTargetCalculation();
        List expressionKey = CommonUtil.getExpressionKey((String)targetCalculation);
        enterpriseMap.forEach((enterpriseCode, financialVoList) -> {
            QfFinancialStatistical qfFinancialStatistical = new QfFinancialStatistical();
            qfFinancialStatistical.setEnterpriseCode((String)enterpriseCode);
            this.createInfo(target, dataInfoVo, qfFinancialStatistical);
            this.calculateData(dataType, targetCalculation, expressionKey, (List<FinancialVo>)financialVoList, qfFinancialStatistical);
            dataList.add(qfFinancialStatistical);
        });
    }

    private void calculateData(Integer dataType, String targetCalculation, List<String> expressionKey, List<FinancialVo> financialVoList, QfFinancialStatistical qfFinancialStatistical) {
        String targetCalculationJson = qfFinancialStatistical.getTargetCalculation();
        Map map = (Map)JSONObject.parseObject((String)targetCalculationJson, Map.class);
        HashMap newMap = Maps.newHashMap();
        HashMap targetCalculationMap = Maps.newHashMap();
        expressionKey.forEach(key -> {
            if (StringUtils.isEmpty((Object)key)) {
                return;
            }
            financialVoList.forEach(financialVo -> {
                if (StringUtils.isEmpty((Object)financialVo.getSubjectCode()) || !financialVo.getSubjectCode().equals(key)) {
                    return;
                }
                if (CollectionUtils.isEmpty((Map)map)) {
                    if (dataType == 1) {
                        targetCalculationMap.put(key, financialVo.getActual());
                    } else if (dataType == 2) {
                        targetCalculationMap.put(key, financialVo.getBudget());
                    }
                } else {
                    Map stringBigDecimalMap = (Map)map.get(dataType);
                    stringBigDecimalMap.forEach((k, v) -> {
                        if (key.equals(k)) {
                            if (dataType == 1) {
                                targetCalculationMap.put(key, financialVo.getActual());
                            } else if (dataType == 2) {
                                targetCalculationMap.put(key, financialVo.getBudget());
                            }
                        }
                    });
                }
            });
        });
        newMap.put(dataType, targetCalculationMap);
        targetCalculation = CommonUtil.replaceExpression(expressionKey, (String)targetCalculation, (Map)targetCalculationMap);
        log.error("expressionKey:{},targetCalculation:{},targetCalculationMap:{}", new Object[]{expressionKey, targetCalculation, targetCalculationMap});
        qfFinancialStatistical.setTargetCalculation(JSON.toJSONString((Object)newMap));
        if (expressionKey.size() == targetCalculationMap.size()) {
            BigDecimal bigDecimal = CommonUtil.convertToCode((String)targetCalculation, (Map)targetCalculationMap, (int)2);
            if (dataType == 1) {
                qfFinancialStatistical.setActual(bigDecimal);
            } else if (dataType == 2) {
                qfFinancialStatistical.setBudget(bigDecimal);
            }
        }
    }

    private void createInfo(SysSubjectTarget target, DataInfoVo dataInfoVo, QfFinancialStatistical qfFinancialStatistical) {
        qfFinancialStatistical.setTargetId(target.getId());
        qfFinancialStatistical.setTargetLevel(target.getTargetLevel());
        qfFinancialStatistical.setTargetName(target.getName());
        qfFinancialStatistical.setTargetNameEn(target.getTargetNameEn());
        qfFinancialStatistical.setTargetUnit(target.getUnit());
        qfFinancialStatistical.setType(target.getType());
        qfFinancialStatistical.setStaLat(target.getStaLat());
        qfFinancialStatistical.setAnalyseType(target.getAnalyseType());
        qfFinancialStatistical.setLargerType(target.getLargerType());
        qfFinancialStatistical.setParentTargetId(target.getParentId());
        qfFinancialStatistical.setYear(dataInfoVo.getYear());
        qfFinancialStatistical.setQuarter(dataInfoVo.getQuarter());
        qfFinancialStatistical.setMonth(dataInfoVo.getMonth());
    }

    private void updateFinancialStatistical(SysSubjectTarget target, List<QfFinancialStatistical> dataList, List<QfFinancialStatistical> statisticalList, List<FinancialVo> list, Integer dataType) {
        if (CollectionUtils.isEmpty(statisticalList)) {
            return;
        }
        String targetCalculation = target.getTargetCalculation();
        List expressionKey = CommonUtil.getExpressionKey((String)targetCalculation);
        statisticalList.forEach(qfFinancialStatistical -> {
            this.calculateData(dataType, targetCalculation, expressionKey, list, (QfFinancialStatistical)((Object)qfFinancialStatistical));
            dataList.add((QfFinancialStatistical)((Object)qfFinancialStatistical));
        });
    }
}

