/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.cqlt.manager.impl;

import com.alibaba.fastjson.JSONObject;
import com.artfess.base.enums.SubjectSpeciesEnum;
import com.artfess.base.exception.BaseException;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.util.BeanUtils;
import com.artfess.cqlt.dao.QfFinanceSasacCompanyMDao;
import com.artfess.cqlt.manager.QfFinanceBsDManager;
import com.artfess.cqlt.manager.QfFinanceCfDManager;
import com.artfess.cqlt.manager.QfFinancePlDManager;
import com.artfess.cqlt.manager.QfFinanceSasacCompanyDManager;
import com.artfess.cqlt.manager.QfFinanceSasacCompanyMManager;
import com.artfess.cqlt.manager.QfHrPersonDManager;
import com.artfess.cqlt.manager.QfReportRangeManager;
import com.artfess.cqlt.manager.QfReportSubjectManager;
import com.artfess.cqlt.model.QfEnterpriseInfo;
import com.artfess.cqlt.model.QfFinanceSasacCompanyD;
import com.artfess.cqlt.model.QfFinanceSasacCompanyM;
import com.artfess.cqlt.model.QfSubjectInfo;
import com.artfess.cqlt.model.QfSubjectRelation;
import com.artfess.cqlt.vo.ReportDataVo;
import com.artfess.i18n.util.I18nUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.google.api.client.util.Lists;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class QfFinanceSasacCompanyMManagerImpl
extends BaseManagerImpl<QfFinanceSasacCompanyMDao, QfFinanceSasacCompanyM>
implements QfFinanceSasacCompanyMManager {
    private static final Logger log = LoggerFactory.getLogger(QfFinanceSasacCompanyMManagerImpl.class);
    @Autowired
    private QfReportSubjectManager reportSubjectManager;
    @Autowired
    private QfReportRangeManager reportRangeManager;
    @Autowired
    private QfFinanceSasacCompanyDManager financeSasacCompanyDManager;
    @Autowired
    private QfFinanceBsDManager financeBsDManager;
    @Autowired
    private QfFinancePlDManager financePlDManager;
    @Autowired
    private QfHrPersonDManager personDManager;
    @Autowired
    private QfFinanceCfDManager financeCfDManager;
    @Resource
    private ThreadPoolExecutor threadPoolExecutor;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean conversion(String mainId) throws ExecutionException, InterruptedException {
        if (StringUtils.isEmpty((Object)mainId)) {
            return false;
        }
        QfFinanceSasacCompanyM mainInfo = (QfFinanceSasacCompanyM)((Object)((QfFinanceSasacCompanyMDao)this.baseMapper).selectById((Serializable)((Object)mainId)));
        if (null == mainInfo) {
            return false;
        }
        String reportId = mainInfo.getReportId();
        List<QfEnterpriseInfo> rangeList = this.reportRangeManager.getQfEnterpriseInfo(reportId);
        List<QfSubjectInfo> subjectInfoList = this.reportSubjectManager.getSubjectInfo(reportId);
        if (CollectionUtils.isEmpty(subjectInfoList)) {
            return false;
        }
        List<QfSubjectRelation> relationList = this.reportSubjectManager.getRelationList(reportId);
        if (CollectionUtils.isEmpty(relationList)) {
            return false;
        }
        Map<String, List<QfSubjectRelation>> relationMap = relationList.stream().collect(Collectors.groupingBy(QfSubjectRelation::getSubCode));
        QueryWrapper companyDQueryWrapper = new QueryWrapper();
        companyDQueryWrapper.eq((Object)"main_id_", (Object)mainId);
        this.financeSasacCompanyDManager.remove((Wrapper)companyDQueryWrapper);
        Map<String, List<String>> typeSubjectMap = this.getTypeSubjectMap(relationList);
        List<ReportDataVo> allData = this.getAllData(mainInfo, typeSubjectMap);
        Map<String, List<ReportDataVo>> subjectDataMap = this.getSubjectDataMap(subjectInfoList, relationMap, allData);
        ArrayList detailList = com.google.common.collect.Lists.newArrayList();
        subjectInfoList.forEach(subjectInfo -> rangeList.forEach(range -> {
            QfFinanceSasacCompanyD detail = new QfFinanceSasacCompanyD();
            this.createBaseInfo(mainInfo, (QfSubjectInfo)((Object)subjectInfo), (QfEnterpriseInfo)((Object)((Object)range)), detail);
            if (subjectDataMap.containsKey(subjectInfo.getCode())) {
                this.calculateData(mainInfo, subjectDataMap, (QfSubjectInfo)((Object)subjectInfo), (QfEnterpriseInfo)((Object)((Object)range)), detail);
            }
            detailList.add(detail);
        }));
        if (CollectionUtils.isEmpty((Collection)detailList)) {
            return false;
        }
        try {
            this.partitionSave(detailList);
        }
        catch (Exception e) {
            log.error("\u8f6c\u6362\u56fd\u8d44\u59d4\u62a5\u8868\u5931\u8d25:{}", (Object)e.getMessage());
            return false;
        }
        return true;
    }

    private Map<String, List<ReportDataVo>> getSubjectDataMap(List<QfSubjectInfo> subjectInfoList, Map<String, List<QfSubjectRelation>> relationMap, List<ReportDataVo> allData) {
        HashMap subjectDataMap = Maps.newHashMap();
        Map<Object, Object> interSubjectDataMap = Maps.newHashMap();
        if (!CollectionUtils.isEmpty(allData)) {
            interSubjectDataMap = allData.stream().collect(Collectors.groupingBy(ReportDataVo::getSubjectCode));
        }
        HashMap finalInterSubjectDataMap = interSubjectDataMap;
        subjectInfoList.forEach(subjectInfo -> {
            List relations = (List)relationMap.get(subjectInfo.getCode());
            if (CollectionUtils.isEmpty((Collection)relations)) {
                return;
            }
            ArrayList subjectDataList = com.google.common.collect.Lists.newArrayList();
            relations.forEach(qfSubjectRelation -> {
                if (finalInterSubjectDataMap.containsKey(qfSubjectRelation.getInterCode())) {
                    subjectDataList.addAll((Collection)finalInterSubjectDataMap.get(qfSubjectRelation.getInterCode()));
                    subjectDataMap.put(qfSubjectRelation.getSubCode(), subjectDataList);
                }
            });
        });
        return subjectDataMap;
    }

    private void partitionSave(List<QfFinanceSasacCompanyD> detailList) throws InterruptedException {
        List partition = BeanUtils.partition(detailList, (int)100);
        ExecutorService executorService = Executors.newFixedThreadPool(partition.size());
        CountDownLatch countDownLatch = new CountDownLatch(partition.size());
        int i = 0;
        while (i < partition.size()) {
            int finalI = i++;
            executorService.execute(() -> {
                List importParamDTOList = (List)partition.get(finalI);
                this.financeSasacCompanyDManager.saveBatch(importParamDTOList);
                countDownLatch.countDown();
            });
        }
        countDownLatch.await();
        executorService.shutdown();
    }

    private void calculateData(QfFinanceSasacCompanyM mainInfo, Map<String, List<ReportDataVo>> subjectReportDataMap, QfSubjectInfo subjectInfo, QfEnterpriseInfo range, QfFinanceSasacCompanyD detail) {
        List<ReportDataVo> reportDataVos = subjectReportDataMap.get(subjectInfo.getCode());
        if (CollectionUtils.isEmpty(reportDataVos)) {
            return;
        }
        Map<String, List<ReportDataVo>> enterpriseReportDataMap = reportDataVos.stream().collect(Collectors.groupingBy(ReportDataVo::getEnterpriseCode));
        if (enterpriseReportDataMap.containsKey(range.getCode())) {
            BigDecimal fillUnrealData = BigDecimal.ZERO;
            BigDecimal lastYearfillRealData = BigDecimal.ZERO;
            BigDecimal lastYearfillUnrealData = BigDecimal.ZERO;
            BigDecimal fillRealData = BigDecimal.ZERO;
            reportDataVos = enterpriseReportDataMap.get(range.getCode());
            for (ReportDataVo reportDataVo : reportDataVos) {
                if (null != reportDataVo.getFillRealData()) {
                    fillRealData = fillRealData.add(reportDataVo.getFillRealData());
                }
                if (null != reportDataVo.getFillUnrealData()) {
                    fillUnrealData = fillUnrealData.add(reportDataVo.getFillUnrealData());
                }
                if (null != reportDataVo.getLastYearfillRealData()) {
                    lastYearfillRealData = lastYearfillRealData.add(reportDataVo.getLastYearfillRealData());
                }
                if (null == reportDataVo.getLastYearfillUnrealData()) continue;
                lastYearfillUnrealData = lastYearfillUnrealData.add(reportDataVo.getLastYearfillUnrealData());
            }
            BigDecimal dataRate = this.getDataRata(subjectInfo, mainInfo);
            detail.setFillRealData(fillRealData.multiply(dataRate));
            detail.setFillUnrealData(fillUnrealData.multiply(dataRate));
            detail.setLastYearfillRealData(lastYearfillRealData.multiply(dataRate));
            detail.setLastYearfillUnrealData(lastYearfillUnrealData.multiply(dataRate));
        }
    }

    private void createBaseInfo(QfFinanceSasacCompanyM mainInfo, QfSubjectInfo subjectInfo, QfEnterpriseInfo range, QfFinanceSasacCompanyD detail) {
        detail.setMainId(mainInfo.getId());
        detail.setFillDate(mainInfo.getFillDate());
        detail.setSubjectCode(subjectInfo.getCode());
        detail.setSubjectName(subjectInfo.getName());
        detail.setSubjectLevel(subjectInfo.getLevel());
        detail.setSubjectNameEn(subjectInfo.getNameEn());
        detail.setSubjectUnit(subjectInfo.getUnit());
        detail.setEnterpriseCode(range.getCode());
        detail.setEnterpriseName(range.getName());
        detail.setEnterpriseNameEn(range.getNameEn());
        detail.setSn(subjectInfo.getSn());
        detail.setStartMonth(1);
        detail.setEndMonth(mainInfo.getFillQuarter() * 3);
    }

    private BigDecimal getDataRata(QfSubjectInfo subjectInfo, QfFinanceSasacCompanyM mainInfo) {
        BigDecimal dataRate = BigDecimal.ONE;
        if (StringUtils.isEmpty((Object)subjectInfo.getRateType())) {
            return dataRate;
        }
        if (subjectInfo.getRateType().equals("1")) {
            dataRate = mainInfo.getAvgRate();
        } else if (subjectInfo.getRateType().equals("2")) {
            dataRate = mainInfo.getEndRate();
        }
        if (null == dataRate) {
            dataRate = BigDecimal.ONE;
        }
        return dataRate;
    }

    private List<ReportDataVo> getAllData(QfFinanceSasacCompanyM mainInfo, Map<String, List<String>> typeSubjectMap) throws ExecutionException, InterruptedException {
        ArrayList list = com.google.common.collect.Lists.newArrayList();
        Integer startMonth = 1;
        Integer endMonth = mainInfo.getFillQuarter() * 3;
        CompletableFuture<Void> cfFuture = CompletableFuture.runAsync(() -> {
            List<ReportDataVo> cfList;
            if (typeSubjectMap.containsKey(SubjectSpeciesEnum.CF.getType()) && !CollectionUtils.isEmpty(cfList = this.financeCfDManager.getCfDataList((List)typeSubjectMap.get(SubjectSpeciesEnum.CF.getType()), mainInfo.getFillYear(), startMonth, endMonth))) {
                list.addAll(cfList);
            }
        }, this.threadPoolExecutor);
        CompletableFuture<Void> bsFuture = CompletableFuture.runAsync(() -> {
            List<ReportDataVo> bsList;
            if (typeSubjectMap.containsKey(SubjectSpeciesEnum.BS.getType()) && !CollectionUtils.isEmpty(bsList = this.financeBsDManager.getBsDataList((List)typeSubjectMap.get(SubjectSpeciesEnum.BS.getType()), mainInfo.getFillYear(), startMonth, endMonth))) {
                list.addAll(bsList);
            }
        }, this.threadPoolExecutor);
        CompletableFuture<Void> hrFuture = CompletableFuture.runAsync(() -> {
            List<ReportDataVo> personList;
            if (typeSubjectMap.containsKey(SubjectSpeciesEnum.HR.getType()) && !CollectionUtils.isEmpty(personList = this.personDManager.getPersonDataList((List)typeSubjectMap.get(SubjectSpeciesEnum.HR.getType()), mainInfo.getFillYear(), startMonth, endMonth))) {
                list.addAll(personList);
            }
        }, this.threadPoolExecutor);
        CompletableFuture<Void> plFuture = CompletableFuture.runAsync(() -> {
            List<ReportDataVo> plList;
            if (typeSubjectMap.containsKey(SubjectSpeciesEnum.PL.getType()) && !CollectionUtils.isEmpty(plList = this.financePlDManager.getActualDataList((List)typeSubjectMap.get(SubjectSpeciesEnum.PL.getType()), mainInfo.getFillYear(), startMonth, endMonth))) {
                list.addAll(plList);
            }
        }, this.threadPoolExecutor);
        CompletableFuture.allOf(cfFuture, bsFuture, hrFuture, plFuture).get();
        return list;
    }

    private Map<String, List<String>> getTypeSubjectMap(List<QfSubjectRelation> relationList) {
        Map<String, List<QfSubjectRelation>> gnSubjectMap = relationList.stream().collect(Collectors.groupingBy(QfSubjectRelation::getType));
        HashMap typeSubjectMap = Maps.newHashMap();
        for (Map.Entry<String, List<QfSubjectRelation>> entry : gnSubjectMap.entrySet()) {
            List<QfSubjectRelation> value = entry.getValue();
            List subjectCodes = value.stream().map(QfSubjectRelation::getInterCode).collect(Collectors.toList());
            if (entry.getKey().contains(SubjectSpeciesEnum.BS.getType())) {
                typeSubjectMap.put(SubjectSpeciesEnum.BS.getType(), subjectCodes);
                continue;
            }
            if (entry.getKey().contains(SubjectSpeciesEnum.PL.getType())) {
                typeSubjectMap.put(SubjectSpeciesEnum.PL.getType(), subjectCodes);
                continue;
            }
            if (entry.getKey().contains(SubjectSpeciesEnum.HR.getType())) {
                typeSubjectMap.put(SubjectSpeciesEnum.HR.getType(), subjectCodes);
                continue;
            }
            if (!entry.getKey().contains(SubjectSpeciesEnum.CF.getType())) continue;
            typeSubjectMap.put(SubjectSpeciesEnum.CF.getType(), subjectCodes);
        }
        return typeSubjectMap;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean updateStatus(QfFinanceSasacCompanyM t) {
        QfFinanceSasacCompanyM QfFinanceSasacCompanyM2 = (QfFinanceSasacCompanyM)((Object)((QfFinanceSasacCompanyMDao)this.baseMapper).selectById((Serializable)((Object)t.getId())));
        if (null == QfFinanceSasacCompanyM2) {
            return false;
        }
        QfFinanceSasacCompanyM2.setStatus(QfFinanceSasacCompanyM2.getStatus() == 0 ? 1 : 0);
        int i = ((QfFinanceSasacCompanyMDao)this.baseMapper).updateById((Object)QfFinanceSasacCompanyM2);
        return i > 0;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean updateInfo(QfFinanceSasacCompanyM t) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"fill_year_", (Object)t.getFillYear());
        queryWrapper.eq((Object)"fill_quarter_", (Object)t.getFillQuarter());
        queryWrapper.eq((Object)"report_id_", (Object)t.getReportId());
        queryWrapper.ne((Object)"id_", (Object)t.getId());
        List QfFinanceSasacCompanyMS = ((QfFinanceSasacCompanyMDao)this.baseMapper).selectList((Wrapper)queryWrapper);
        if (!CollectionUtils.isEmpty((Collection)QfFinanceSasacCompanyMS)) {
            throw new BaseException(I18nUtil.getMessage((String)"QfOperationKpiM.repeat", (Locale)LocaleContextHolder.getLocale()));
        }
        int insert = ((QfFinanceSasacCompanyMDao)this.baseMapper).updateById((Object)t);
        return insert > 0;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean insertInfo(QfFinanceSasacCompanyM t) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"fill_year_", (Object)t.getFillYear());
        queryWrapper.eq((Object)"fill_quarter_", (Object)t.getFillQuarter());
        queryWrapper.eq((Object)"report_id_", (Object)t.getReportId());
        List QfFinanceSasacCompanyMS = ((QfFinanceSasacCompanyMDao)this.baseMapper).selectList((Wrapper)queryWrapper);
        if (!CollectionUtils.isEmpty((Collection)QfFinanceSasacCompanyMS)) {
            throw new BaseException(I18nUtil.getMessage((String)"QfOperationKpiM.repeat", (Locale)LocaleContextHolder.getLocale()));
        }
        int insert = ((QfFinanceSasacCompanyMDao)this.baseMapper).insert((Object)t);
        return insert > 0;
    }

    @Override
    public List<JSONObject> detailQuery(List<QfFinanceSasacCompanyD> list) {
        if (CollectionUtils.isEmpty(list)) {
            return Lists.newArrayList();
        }
        String mainId = list.get(0).getMainId();
        QfFinanceSasacCompanyM mainInfo = (QfFinanceSasacCompanyM)((Object)((QfFinanceSasacCompanyMDao)this.baseMapper).selectById((Serializable)((Object)mainId)));
        List<QfEnterpriseInfo> rangeList = this.reportRangeManager.getQfEnterpriseInfo(mainInfo.getReportId());
        List<QfSubjectInfo> subjectInfoList = this.reportSubjectManager.getSubjectInfo(mainInfo.getReportId());
        ArrayList detailList = com.google.common.collect.Lists.newArrayList();
        this.createHeaderInfo(mainInfo, rangeList, detailList);
        for (QfSubjectInfo subject : subjectInfoList) {
            JSONObject data = new JSONObject(true);
            data.put("subjectCode", (Object)subject.getCode());
            BigDecimal fillUnrealData = BigDecimal.ZERO;
            BigDecimal lastYearfillRealData = BigDecimal.ZERO;
            BigDecimal lastYearfillUnrealData = BigDecimal.ZERO;
            BigDecimal fillRealData = BigDecimal.ZERO;
            for (QfFinanceSasacCompanyD companyD : list) {
                if (!companyD.getSubjectCode().equals(subject.getCode())) continue;
                data.put("subjectName", (Object)companyD.getSubjectName());
                data.put("sn", (Object)companyD.getSn());
                data.put("subjectLevel", (Object)companyD.getSubjectLevel());
                data.put("nowUnreal" + companyD.getEnterpriseCode(), (Object)companyD.getFillUnrealData());
                data.put("lastUnreal" + companyD.getEnterpriseCode(), (Object)companyD.getLastYearfillUnrealData());
                data.put("nowReal" + companyD.getEnterpriseCode(), (Object)companyD.getFillRealData());
                data.put("lastReal" + companyD.getEnterpriseCode(), (Object)companyD.getLastYearfillRealData());
                if (null != companyD.getFillRealData()) {
                    fillRealData = fillRealData.add(companyD.getFillRealData());
                }
                if (null != companyD.getFillUnrealData()) {
                    fillUnrealData = fillUnrealData.add(companyD.getFillUnrealData());
                }
                if (null != companyD.getLastYearfillRealData()) {
                    lastYearfillRealData = lastYearfillRealData.add(companyD.getLastYearfillRealData());
                }
                if (null == companyD.getLastYearfillUnrealData()) continue;
                lastYearfillUnrealData = lastYearfillUnrealData.add(companyD.getLastYearfillUnrealData());
            }
            data.put("fillUnrealData", (Object)fillUnrealData);
            data.put("lastYearfillUnrealData", (Object)lastYearfillUnrealData);
            data.put("fillRealData", (Object)fillRealData);
            data.put("lastYearfillRealData", (Object)lastYearfillUnrealData);
            detailList.add(data);
        }
        return detailList;
    }

    private void createHeaderInfo(QfFinanceSasacCompanyM mainInfo, List<QfEnterpriseInfo> enterpriseHeader, List<JSONObject> detailList) {
        JSONObject detail = new JSONObject(true);
        detail.put("subjectName", (Object)"\u9879\u76ee");
        detail.put("sn", (Object)"\u884c\u6b21");
        detail.put("fillUnrealData", (Object)("1-" + (mainInfo.getFillQuarter() * 3 - 1) + "\u6708\u672c\u5e74\u7d2f\u8ba1"));
        detail.put("lastYearfillUnrealData", (Object)("1-" + (mainInfo.getFillQuarter() * 3 - 1) + "\u6708\u4e0a\u5e74\u540c\u671f"));
        detail.put("fillRealData", (Object)("1-" + mainInfo.getFillQuarter() * 3 + "\u6708\u672c\u5e74\u7d2f\u8ba1"));
        detail.put("lastYearfillRealData", (Object)("1-" + mainInfo.getFillQuarter() * 3 + "\u6708\u4e0a\u5e74\u540c\u671f"));
        detail.put("subjectLevel", (Object)"subjectLevel");
        enterpriseHeader.forEach(enterprise -> {
            String code = enterprise.getCode();
            detail.put("nowUnreal" + code, (Object)(code + "\n1-" + (mainInfo.getFillQuarter() * 3 - 1) + "\u6708\u672c\u5e74\u7d2f\u8ba1"));
            detail.put("lastUnreal" + code, (Object)(code + "\n1-" + (mainInfo.getFillQuarter() * 3 - 1) + "\u6708\u4e0a\u5e74\u540c\u671f"));
            detail.put("nowReal" + code, (Object)(code + "\n1-" + mainInfo.getFillQuarter() * 3 + "\u6708\u672c\u5e74\u7d2f\u8ba1"));
            detail.put("lastReal" + code, (Object)(code + "\n1-" + mainInfo.getFillQuarter() * 3 + "\u6708\u4e0a\u5e74\u540c\u671f"));
        });
        detailList.add(detail);
    }
}

