/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.cqlt.manager.impl;

import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.cqlt.dao.QfFinanceSasacCompanyDDao;
import com.artfess.cqlt.manager.QfFinanceSasacCompanyDManager;
import com.artfess.cqlt.manager.QfFinanceSasacCompanyMManager;
import com.artfess.cqlt.manager.QfReportRangeManager;
import com.artfess.cqlt.manager.QfReportSubjectManager;
import com.artfess.cqlt.model.QfEnterpriseInfo;
import com.artfess.cqlt.model.QfFinanceSasacCompanyD;
import com.artfess.cqlt.model.QfFinanceSasacCompanyM;
import com.artfess.cqlt.model.QfSubjectInfo;
import com.artfess.poi.util.CustomHeader;
import com.artfess.poi.util.HeaderNode;
import com.google.api.client.util.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class QfFinanceSasacCompanyDManagerImpl
extends BaseManagerImpl<QfFinanceSasacCompanyDDao, QfFinanceSasacCompanyD>
implements QfFinanceSasacCompanyDManager {
    @Autowired
    private QfReportSubjectManager reportSubjectManager;
    @Autowired
    private QfReportRangeManager reportRangeManager;
    @Autowired
    private QfFinanceSasacCompanyMManager financeSasacCompanyMManager;

    @Override
    public void export(HttpServletRequest request, HttpServletResponse response, List<QfFinanceSasacCompanyD> list, String sheetName) throws IOException {
        HeaderNode headerNode;
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        String mainId = list.get(0).getMainId();
        QfFinanceSasacCompanyM mainInfo = (QfFinanceSasacCompanyM)((Object)this.financeSasacCompanyMManager.getById((Serializable)((Object)mainId)));
        if (null == mainInfo) {
            return;
        }
        String reportId = mainInfo.getReportId();
        List<QfEnterpriseInfo> rangeList = this.reportRangeManager.getQfEnterpriseInfo(reportId);
        List<QfSubjectInfo> subjectInfoList = this.reportSubjectManager.getSubjectInfo(reportId);
        HashMap rowMap = Maps.newHashMap();
        AtomicReference<Integer> row = new AtomicReference<Integer>(1);
        subjectInfoList.forEach(subject -> {
            row.getAndSet((Integer)row.get() + 1);
            rowMap.put(subject.getCode(), row.get());
        });
        HashMap columMap = Maps.newHashMap();
        ArrayList headerNodeList = Lists.newArrayList();
        this.createHeader(mainInfo, columMap, headerNodeList);
        Integer headerColum = 6;
        for (QfEnterpriseInfo enterprise : rangeList) {
            Integer n = headerColum;
            Integer n2 = headerColum = Integer.valueOf(headerColum + 1);
            String code = enterprise.getCode();
            headerNode = new HeaderNode();
            headerNode.setRow(0);
            headerNode.setColumn(headerColum.intValue());
            headerNode.setHeaderName(code);
            headerNodeList.add(headerNode);
            headerNode = new HeaderNode();
            headerNode.setRow(1);
            headerNode.setColumn(headerColum.intValue());
            headerNode.setHeaderName("1-" + (mainInfo.getFillQuarter() * 3 - 1) + "\u6708\u672c\u5e74\u7d2f\u8ba1");
            headerNodeList.add(headerNode);
            columMap.put(code + "1", headerColum);
            n2 = headerColum;
            Integer n3 = headerColum = Integer.valueOf(headerColum + 1);
            headerNode = new HeaderNode();
            headerNode.setRow(0);
            headerNode.setColumn(headerColum.intValue());
            headerNode.setHeaderName(code);
            headerNodeList.add(headerNode);
            headerNode = new HeaderNode();
            headerNode.setRow(1);
            headerNode.setColumn(headerColum.intValue());
            headerNode.setHeaderName("1-" + (mainInfo.getFillQuarter() * 3 - 1) + "\u6708\u4e0a\u5e74\u540c\u671f");
            headerNodeList.add(headerNode);
            columMap.put(code + "2", headerColum);
            n2 = headerColum;
            n3 = headerColum = Integer.valueOf(headerColum + 1);
            headerNode = new HeaderNode();
            headerNode.setRow(0);
            headerNode.setColumn(headerColum.intValue());
            headerNode.setHeaderName(code);
            headerNodeList.add(headerNode);
            headerNode = new HeaderNode();
            headerNode.setRow(1);
            headerNode.setColumn(headerColum.intValue());
            headerNode.setHeaderName("1-" + mainInfo.getFillQuarter() * 3 + "\u6708\u672c\u5e74\u7d2f\u8ba1");
            headerNodeList.add(headerNode);
            columMap.put(code + "3", headerColum);
            n2 = headerColum;
            n3 = headerColum = Integer.valueOf(headerColum + 1);
            headerNode = new HeaderNode();
            headerNode.setRow(0);
            headerNode.setColumn(headerColum.intValue());
            headerNode.setHeaderName(code);
            headerNodeList.add(headerNode);
            headerNode = new HeaderNode();
            headerNode.setRow(1);
            headerNode.setColumn(headerColum.intValue());
            headerNode.setHeaderName("1-" + (mainInfo.getFillQuarter() * 3 - 1) + "\u6708\u4e0a\u5e74\u540c\u671f");
            headerNodeList.add(headerNode);
            columMap.put(code + "4", headerColum);
        }
        for (QfSubjectInfo subject2 : subjectInfoList) {
            String subjectCode = subject2.getCode();
            headerNode = new HeaderNode();
            headerNode.setRow(((Integer)rowMap.get(subjectCode)).intValue());
            headerNode.setColumn(((Integer)columMap.get("subjectName")).intValue());
            headerNode.setHeaderName(subject2.getName());
            headerNodeList.add(headerNode);
            headerNode = new HeaderNode();
            headerNode.setRow(((Integer)rowMap.get(subjectCode)).intValue());
            headerNode.setColumn(((Integer)columMap.get("subjectCode")).intValue());
            headerNode.setHeaderName(subjectCode);
            headerNodeList.add(headerNode);
            headerNode = new HeaderNode();
            headerNode.setRow(((Integer)rowMap.get(subjectCode)).intValue());
            headerNode.setColumn(((Integer)columMap.get("sn")).intValue());
            headerNode.setHeaderName(subject2.getSn() + "");
            headerNodeList.add(headerNode);
            BigDecimal fillUnrealData = BigDecimal.ZERO;
            BigDecimal lastYearfillRealData = BigDecimal.ZERO;
            BigDecimal lastYearfillUnrealData = BigDecimal.ZERO;
            BigDecimal fillRealData = BigDecimal.ZERO;
            for (QfFinanceSasacCompanyD companyD : list) {
                if (!companyD.getSubjectCode().equals(subject2.getCode())) continue;
                if (null != companyD.getFillUnrealData()) {
                    headerNode = new HeaderNode();
                    headerNode.setRow(((Integer)rowMap.get(subjectCode)).intValue());
                    headerNode.setColumn(((Integer)columMap.get(companyD.getEnterpriseCode() + "1")).intValue());
                    headerNode.setHeaderName(companyD.getFillUnrealData() + "");
                    headerNodeList.add(headerNode);
                }
                if (null != companyD.getLastYearfillUnrealData()) {
                    headerNode = new HeaderNode();
                    headerNode.setRow(((Integer)rowMap.get(subjectCode)).intValue());
                    headerNode.setColumn(((Integer)columMap.get(companyD.getEnterpriseCode() + "2")).intValue());
                    headerNode.setHeaderName(companyD.getLastYearfillUnrealData() + "");
                    headerNodeList.add(headerNode);
                }
                if (null != companyD.getFillRealData()) {
                    headerNode = new HeaderNode();
                    headerNode.setRow(((Integer)rowMap.get(subjectCode)).intValue());
                    headerNode.setColumn(((Integer)columMap.get(companyD.getEnterpriseCode() + "3")).intValue());
                    headerNode.setHeaderName(companyD.getFillRealData() + "");
                    headerNodeList.add(headerNode);
                }
                if (null != companyD.getLastYearfillRealData()) {
                    headerNode = new HeaderNode();
                    headerNode.setRow(((Integer)rowMap.get(subjectCode)).intValue());
                    headerNode.setColumn(((Integer)columMap.get(companyD.getEnterpriseCode() + "4")).intValue());
                    headerNode.setHeaderName(companyD.getLastYearfillRealData() + "");
                    headerNodeList.add(headerNode);
                }
                if (null != companyD.getFillRealData()) {
                    fillRealData = fillRealData.add(companyD.getFillRealData());
                }
                if (null != companyD.getFillUnrealData()) {
                    fillUnrealData = fillUnrealData.add(companyD.getFillUnrealData());
                }
                if (null != companyD.getLastYearfillRealData()) {
                    lastYearfillRealData = lastYearfillRealData.add(companyD.getLastYearfillRealData());
                }
                if (null == companyD.getLastYearfillUnrealData()) continue;
                lastYearfillUnrealData = lastYearfillUnrealData.add(companyD.getLastYearfillUnrealData());
            }
            if (null != fillUnrealData) {
                headerNode = new HeaderNode();
                headerNode.setRow(((Integer)rowMap.get(subjectCode)).intValue());
                headerNode.setColumn(((Integer)columMap.get("fillUnrealData")).intValue());
                headerNode.setHeaderName(fillUnrealData + "");
                headerNodeList.add(headerNode);
            }
            if (null != lastYearfillUnrealData) {
                headerNode = new HeaderNode();
                headerNode.setRow(((Integer)rowMap.get(subjectCode)).intValue());
                headerNode.setColumn(((Integer)columMap.get("lastYearfillUnrealData")).intValue());
                headerNode.setHeaderName(lastYearfillUnrealData + "");
                headerNodeList.add(headerNode);
            }
            if (null != fillRealData) {
                headerNode = new HeaderNode();
                headerNode.setRow(((Integer)rowMap.get(subjectCode)).intValue());
                headerNode.setColumn(((Integer)columMap.get("fillRealData")).intValue());
                headerNode.setHeaderName(fillRealData + "");
                headerNodeList.add(headerNode);
            }
            if (null == lastYearfillRealData) continue;
            headerNode = new HeaderNode();
            headerNode.setRow(((Integer)rowMap.get(subjectCode)).intValue());
            headerNode.setColumn(((Integer)columMap.get("lastYearfillRealData")).intValue());
            headerNode.setHeaderName(lastYearfillRealData + "");
            headerNodeList.add(headerNode);
        }
        String date = new SimpleDateFormat("yyyyMMddHHmmss").format(new Date());
        String fileName = String.format(sheetName + "-%s", date);
        CustomHeader.export((List)headerNodeList, (HttpServletResponse)response, (String)fileName, (String)sheetName);
    }

    private void createHeader(QfFinanceSasacCompanyM mainInfo, Map<String, Integer> columMap, List<HeaderNode> headerNodeList) {
        columMap.put("subjectName", 0);
        HeaderNode headerNode = new HeaderNode();
        headerNode.setRow(1);
        headerNode.setColumn(0);
        headerNode.setHeaderName("\u9879\u76ee");
        headerNodeList.add(headerNode);
        columMap.put("subjectCode", 1);
        headerNode = new HeaderNode();
        headerNode.setRow(1);
        headerNode.setColumn(1);
        headerNode.setHeaderName("\u7f16\u7801");
        headerNodeList.add(headerNode);
        columMap.put("sn", 2);
        headerNode = new HeaderNode();
        headerNode.setRow(1);
        headerNode.setColumn(2);
        headerNode.setHeaderName("\u884c\u6b21");
        headerNodeList.add(headerNode);
        columMap.put("fillUnrealData", 3);
        columMap.put("lastYearfillUnrealData", 4);
        columMap.put("fillRealData", 5);
        columMap.put("lastYearfillRealData", 6);
        headerNode = new HeaderNode();
        headerNode.setRow(1);
        headerNode.setColumn(3);
        headerNode.setHeaderName("1-" + (mainInfo.getFillQuarter() * 3 - 1) + "\u6708\u672c\u5e74\u7d2f\u8ba1");
        headerNodeList.add(headerNode);
        headerNode = new HeaderNode();
        headerNode.setRow(1);
        headerNode.setColumn(4);
        headerNode.setHeaderName("1-" + (mainInfo.getFillQuarter() * 3 - 1) + "\u6708\u4e0a\u5e74\u540c\u671f");
        headerNodeList.add(headerNode);
        headerNode = new HeaderNode();
        headerNode.setRow(1);
        headerNode.setColumn(5);
        headerNode.setHeaderName("1-" + mainInfo.getFillQuarter() * 3 + "\u6708\u672c\u5e74\u7d2f\u8ba1");
        headerNodeList.add(headerNode);
        headerNode = new HeaderNode();
        headerNode.setRow(1);
        headerNode.setColumn(6);
        headerNode.setHeaderName("1-" + mainInfo.getFillQuarter() * 3 + "\u6708\u4e0a\u5e74\u540c\u671f");
        headerNodeList.add(headerNode);
    }
}

