/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.cqlt.manager.impl;

import com.artfess.base.enums.DelStatusEnum;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.cqlt.dao.QfEnterpriseInfoDao;
import com.artfess.cqlt.dao.QfFinanceReportingSummaryDDao;
import com.artfess.cqlt.dao.QfFinanceReportingSummaryMDao;
import com.artfess.cqlt.dao.QfSubjectInternationalInfoDao;
import com.artfess.cqlt.manager.QfFinanceReportingSummaryDManager;
import com.artfess.cqlt.model.QfEnterpriseInfo;
import com.artfess.cqlt.model.QfFinanceReportingSummaryD;
import com.artfess.cqlt.model.QfFinanceReportingSummaryM;
import com.artfess.cqlt.model.QfSubjectInternationalInfo;
import com.artfess.i18n.util.I18nUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import java.io.Serializable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class QfFinanceReportingSummaryDManagerImpl
extends BaseManagerImpl<QfFinanceReportingSummaryDDao, QfFinanceReportingSummaryD>
implements QfFinanceReportingSummaryDManager {
    @Resource
    private QfSubjectInternationalInfoDao subjectInternationalInfoDao;
    @Resource
    private QfEnterpriseInfoDao enterpriseInfoDao;
    @Resource
    private QfFinanceReportingSummaryMDao financeReportingSummaryMDao;

    @Override
    public void export(HttpServletRequest request, HttpServletResponse response, List<QfFinanceReportingSummaryD> rows, String sheetName) {
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean batchUpdate(QfFinanceReportingSummaryM t) {
        Assert.hasText((String)t.getId(), (String)I18nUtil.getMessage((String)"QfOperationKpiM.reportId", (Locale)LocaleContextHolder.getLocale()));
        QfFinanceReportingSummaryM personM = (QfFinanceReportingSummaryM)((Object)this.financeReportingSummaryMDao.selectById((Serializable)((Object)t.getId())));
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"IS_DELE_", (Object)DelStatusEnum.N.getType());
        List qfSubjectInternationalInfos = this.subjectInternationalInfoDao.selectList((Wrapper)query);
        Map<String, QfSubjectInternationalInfo> detailMap = qfSubjectInternationalInfos.stream().collect(Collectors.toMap(item -> item.getCode(), item -> item));
        QueryWrapper enterpriseInfoQuery = new QueryWrapper();
        enterpriseInfoQuery.eq((Object)"IS_DELE_", (Object)DelStatusEnum.N.getType());
        List enterpriseInfoList = this.enterpriseInfoDao.selectList((Wrapper)enterpriseInfoQuery);
        Map<String, QfEnterpriseInfo> enterpriseInfoMap = enterpriseInfoList.stream().collect(Collectors.toMap(item -> item.getCode(), item -> item));
        t.getList().forEach(detail -> {
            detail.setFillDate(personM.getFillDate());
            detail.setMainId(t.getId());
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"subject_code_", (Object)detail.getSubjectCode());
            queryWrapper.eq((Object)"main_id_", (Object)detail.getMainId());
            queryWrapper.eq((Object)"enterprise_code_", (Object)detail.getEnterpriseCode());
            QfFinanceReportingSummaryD summaryD = (QfFinanceReportingSummaryD)((Object)((Object)((QfFinanceReportingSummaryDDao)this.baseMapper).selectOne((Wrapper)queryWrapper)));
            if (null == summaryD) {
                QfSubjectInternationalInfo subjectInternationalInfo = (QfSubjectInternationalInfo)((Object)((Object)detailMap.get(detail.getSubjectCode())));
                detail.setSubjectNameEn(subjectInternationalInfo.getNameEn());
                detail.setSubjectUnit(subjectInternationalInfo.getUnit());
                detail.setSubjectName(subjectInternationalInfo.getName());
                if (!StringUtils.isEmpty((Object)subjectInternationalInfo.getLevel())) {
                    detail.setSubjectLevel(Integer.parseInt(subjectInternationalInfo.getLevel()));
                }
                if (enterpriseInfoMap.containsKey(detail.getEnterpriseCode())) {
                    QfEnterpriseInfo qfEnterpriseInfo = (QfEnterpriseInfo)((Object)((Object)enterpriseInfoMap.get(detail.getEnterpriseCode())));
                    detail.setEnterpriseName(qfEnterpriseInfo.getName());
                    detail.setEnterpriseNameEn(qfEnterpriseInfo.getNameEn());
                }
            }
        });
        if (CollectionUtils.isEmpty(t.getList())) {
            return false;
        }
        boolean b = this.saveOrUpdateBatch(t.getList());
        return b;
    }
}

