/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.cqlt.controller;

import com.alibaba.fastjson.JSON;
import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.annotation.PowerLogInfo;
import com.artfess.base.controller.BaseController;
import com.artfess.base.enums.DelStatusEnum;
import com.artfess.base.enums.LogType;
import com.artfess.base.enums.OperationType;
import com.artfess.base.exception.RequiredException;
import com.artfess.base.model.CommonResult;
import com.artfess.base.valid.AddGroup;
import com.artfess.base.valid.UpdateGroup;
import com.artfess.cqlt.manager.QfSubjectInfoManager;
import com.artfess.cqlt.model.QfSubjectInfo;
import com.artfess.i18n.util.I18nUtil;
import com.artfess.poi.util.ExcelUtils;
import com.artfess.poi.util.FileDownloadUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.core.io.ClassPathResource;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@Api(tags={"\u56fd\u5185\u51c6\u5219\u79d1\u76ee\u4fe1\u606f"})
@RequestMapping(value={"/qf/subject/info/"})
@ApiGroup(group={"group_biz"})
public class QfSubjectInfoController
extends BaseController<QfSubjectInfoManager, QfSubjectInfo> {
    private static final Logger log = LoggerFactory.getLogger(QfSubjectInfoController.class);

    @PostMapping(value={"/"})
    @ApiOperation(value="\u6dfb\u52a0\u5b9e\u4f53\u7684\u63a5\u53e3")
    public CommonResult<String> create(@ApiParam(name="model", value="\u5b9e\u4f53\u4fe1\u606f") @RequestBody @Validated(value={AddGroup.class}) QfSubjectInfo t) {
        String id = ((QfSubjectInfoManager)this.baseService).newInsertTree(t);
        int length = t.getFullId().split("/").length;
        t.setLevel(length);
        if (t.getSn() == null) {
            t.setSn(((QfSubjectInfoManager)this.baseService).getNextSequence(null));
        }
        ((QfSubjectInfoManager)this.baseService).updateById((Object)t);
        if (!StringUtils.isNotBlank((CharSequence)id)) {
            return new CommonResult(false, I18nUtil.getMessage((String)"option.fail", (Locale)LocaleContextHolder.getLocale()), null);
        }
        return new CommonResult(true, I18nUtil.getMessage((String)"option.success", (Locale)LocaleContextHolder.getLocale()), null);
    }

    @PutMapping(value={"/"})
    @ApiOperation(value="\u66f4\u65b0\u5b9e\u4f53")
    public CommonResult<String> updateById(@ApiParam(name="model", value="\u5b9e\u4f53\u4fe1\u606f") @RequestBody @Validated(value={UpdateGroup.class}) QfSubjectInfo t) {
        QfSubjectInfo byId = (QfSubjectInfo)((Object)((QfSubjectInfoManager)this.baseService).getById((Serializable)((Object)t.getId())));
        String id = ((QfSubjectInfoManager)this.baseService).newUpdateTree(t, byId.getName());
        int length = t.getFullId().split("/").length;
        t.setLevel(length);
        if (t.getSn() == null) {
            t.setSn(((QfSubjectInfoManager)this.baseService).getNextSequence(null));
        }
        ((QfSubjectInfoManager)this.baseService).updateById((Object)t);
        if (!StringUtils.isNotBlank((CharSequence)id)) {
            return new CommonResult(false, I18nUtil.getMessage((String)"update.fail", (Locale)LocaleContextHolder.getLocale()), null);
        }
        return new CommonResult(true, I18nUtil.getMessage((String)"option.success", (Locale)LocaleContextHolder.getLocale()), null);
    }

    @PostMapping(value={"/getTree"})
    @ApiOperation(value="\u83b7\u53d6\u56fd\u5185\u51c6\u5219\u79d1\u76ee\u4fe1\u606f\u4e0b\u62c9\u6811")
    @PowerLogInfo(logType=LogType.BIZ, operaionType=OperationType.QUERY, description="\u83b7\u53d6\u56fd\u5185\u51c6\u5219\u79d1\u76ee\u4fe1\u606f\u4e0b\u62c9\u6811")
    public CommonResult<String> getTree(@ApiParam(name="model", value="\u83b7\u53d6\u56fd\u5185\u51c6\u5219\u79d1\u76ee\u4fe1\u606f\u4e0b\u62c9\u6811") @RequestBody QfSubjectInfo entity) {
        log.info("\u83b7\u53d6\u56fd\u5185\u51c6\u5219\u79d1\u76ee\u4fe1\u606f\u4e0b\u62c9\u6811\u8bf7\u6c42\u53c2\u6570:{}", (Object)JSON.toJSONString((Object)((Object)entity)));
        List<QfSubjectInfo> list = ((QfSubjectInfoManager)this.baseService).getTree(entity);
        return CommonResult.success(list, null);
    }

    @DeleteMapping(value={"/{id}"})
    @ApiOperation(value="\u6839\u636eid\u5220\u9664")
    public CommonResult<String> deleteById(@ApiParam(name="id", value="\u5b9e\u4f53id") @PathVariable String id) {
        boolean result = ((QfSubjectInfoManager)this.baseService).removeById((Serializable)((Object)id));
        if (!result) {
            return new CommonResult(false, I18nUtil.getMessage((String)"delete.fail", (Locale)LocaleContextHolder.getLocale()), null);
        }
        return new CommonResult(true, I18nUtil.getMessage((String)"option.success", (Locale)LocaleContextHolder.getLocale()), null);
    }

    @DeleteMapping(value={"/"})
    @ApiOperation(value="\u6839\u636eid\u96c6\u5408\u6279\u91cf\u5220\u9664")
    public CommonResult<String> deleteByIds(String ... ids) {
        boolean result = ((QfSubjectInfoManager)this.baseService).removeByIds(Arrays.asList(ids));
        if (!result) {
            return new CommonResult(false, I18nUtil.getMessage((String)"delete.fail", (Locale)LocaleContextHolder.getLocale()), null);
        }
        return new CommonResult(true, I18nUtil.getMessage((String)"option.success", (Locale)LocaleContextHolder.getLocale()), null);
    }

    @RequestMapping(value={"updateSequence"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6279\u91cf\u4fee\u6539\u6392\u5e8f\u53f7", notes="\u6279\u91cf\u4fee\u6539\u6392\u5e8f\u53f7")
    public CommonResult<String> updateSequence(@ApiParam(name="params", value="\u6392\u5e8f\u53c2\u6570\uff1aKey\uff1aID\uff0cValue\uff1a\u6392\u5e8f\u53f7") @RequestBody HashMap<String, Integer> params) throws Exception {
        if (!params.isEmpty()) {
            ((QfSubjectInfoManager)this.baseService).updateSequence(params);
        }
        return new CommonResult(true, I18nUtil.getMessage((String)"option.success", (Locale)LocaleContextHolder.getLocale()), null);
    }

    @PostMapping(value={"/associatedSubject"})
    @ApiOperation(value="\u5173\u8054\u56fd\u9645\u51c6\u5219\u79d1\u76ee")
    public CommonResult<String> associatedSubject(@ApiParam(name="model", value="\u5b9e\u4f53\u4fe1\u606f") @RequestBody QfSubjectInfo t) {
        ((QfSubjectInfoManager)this.baseService).associatedSubject(t);
        return new CommonResult(true, I18nUtil.getMessage((String)"option.success", (Locale)LocaleContextHolder.getLocale()), null);
    }

    @GetMapping(value={"/{id}"})
    @ApiOperation(value="\u6839\u636eid\u67e5\u8be2\u5b9e\u4f53")
    public QfSubjectInfo getById(@ApiParam(name="id", value="\u5b9e\u4f53id") @PathVariable String id) {
        return ((QfSubjectInfoManager)this.baseService).findById(id);
    }

    @PostMapping(value={"/move"})
    @ApiOperation(value="\u79fb\u52a8\u79d1\u76ee\u7684\u4e0a\u4e0b\u7ea7")
    public CommonResult<String> move(@RequestBody QfSubjectInfo entity) {
        boolean result = ((QfSubjectInfoManager)this.baseService).move(entity);
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"parent_Id_", (Object)entity.getId());
        queryWrapper.eq((Object)"is_dele_", (Object)DelStatusEnum.N.getType());
        List ts = ((QfSubjectInfoManager)this.baseService).list((Wrapper)queryWrapper);
        ts.forEach(qfSubjectInfo -> {
            int length = qfSubjectInfo.getFullName().split("/").length;
            qfSubjectInfo.setLevel(length);
        });
        ((QfSubjectInfoManager)this.baseService).updateBatchById(ts);
        if (!result) {
            return new CommonResult(false, I18nUtil.getMessage((String)"delete.fail", (Locale)LocaleContextHolder.getLocale()), null);
        }
        return new CommonResult(true, I18nUtil.getMessage((String)"option.success", (Locale)LocaleContextHolder.getLocale()), null);
    }

    @ApiOperation(value="\u56fd\u5185\u79d1\u76ee\u6570\u636e\u5bfc\u5165")
    @PostMapping(value={"/importExcel"})
    public CommonResult<String> importExcel(@RequestParam(value="file") MultipartFile file) throws Exception {
        try {
            ExcelUtils excelUtil = new ExcelUtils(QfSubjectInfo.class);
            List list = excelUtil.importExcel(null, file.getInputStream());
            boolean result = ((QfSubjectInfoManager)this.baseService).importExcel(list);
            if (!result) {
                throw new IllegalArgumentException(I18nUtil.getMessage((String)"import.fail", (Locale)LocaleContextHolder.getLocale()));
            }
            return new CommonResult();
        }
        catch (Exception e) {
            throw new IllegalArgumentException(I18nUtil.getMessage((String)"import.fail", (Locale)LocaleContextHolder.getLocale()) + "," + e.getMessage());
        }
    }

    @ApiOperation(value="\u4e0b\u8f7d\u5bfc\u5165\u6a21\u677f", notes="\u5176\u4e2d\u5c42\u7ea7\uff0c\u4f7f\u7528Excel")
    @GetMapping(value={"/downModel"})
    public void downTemplate(HttpServletResponse response) {
        try {
            ClassPathResource classPathResource = new ClassPathResource("model/financeBSBudgetDetail.xlsx");
            FileDownloadUtil.fileDownload((HttpServletResponse)response, (InputStream)classPathResource.getInputStream(), (String)"\u56fd\u5185\u79d1\u76ee\u51c6\u5219\u6570\u636e\u5bfc\u5165\u6a21\u677f\u00b7\u542b\u6570\u636e.xlsx");
        }
        catch (Exception e) {
            response.setCharacterEncoding("utf-8");
            throw new RequiredException(I18nUtil.getMessage((String)"resources.noexist", (Locale)LocaleContextHolder.getLocale()));
        }
    }

    @ApiOperation(value="\u4e0b\u8f7dSQL\u5907\u4efd")
    @GetMapping(value={"/downSQL"})
    public void downSQL(HttpServletResponse response) {
        try {
            ClassPathResource classPathResource = new ClassPathResource("sql/subjectInfoAndRelate.sql");
            FileDownloadUtil.fileDownload((HttpServletResponse)response, (InputStream)classPathResource.getInputStream(), (String)"\u56fd\u5185\u5916\u79d1\u76ee\u6570\u636e\u53ca\u5173\u8054\u6570\u636e\u5907\u4efd\u30102023.03.08\u3011.sql");
        }
        catch (Exception e) {
            response.setCharacterEncoding("utf-8");
            throw new RequiredException(I18nUtil.getMessage((String)"resources.noexist", (Locale)LocaleContextHolder.getLocale()));
        }
    }
}

