/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.cqlt.manager.impl;

import com.artfess.base.exception.BaseException;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.cqlt.dao.QfOperationSopMDao;
import com.artfess.cqlt.manager.QfOperationSopDManager;
import com.artfess.cqlt.manager.QfOperationSopMManager;
import com.artfess.cqlt.model.QfOperationSopD;
import com.artfess.cqlt.model.QfOperationSopM;
import com.artfess.i18n.util.I18nUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service
public class QfOperationSopMManagerImpl
extends BaseManagerImpl<QfOperationSopMDao, QfOperationSopM>
implements QfOperationSopMManager {
    @Autowired
    private QfOperationSopDManager sopDManager;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean importExcel(List<QfOperationSopD> list, String mainId) {
        QfOperationSopM qfOperationSopM = (QfOperationSopM)((Object)((QfOperationSopMDao)this.baseMapper).selectById((Serializable)((Object)mainId)));
        Assert.notNull((Object)((Object)qfOperationSopM), (String)I18nUtil.getMessage((String)"filldata.notExist", (Locale)LocaleContextHolder.getLocale()));
        Assert.isTrue((!"1".equals(qfOperationSopM.getStatus()) ? 1 : 0) != 0, (String)I18nUtil.getMessage((String)"data_operate", (Locale)LocaleContextHolder.getLocale()));
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"main_id_", (Object)mainId);
        this.sopDManager.remove((Wrapper)queryWrapper);
        Map<String, QfOperationSopD> historyMap = this.historyList(qfOperationSopM);
        list.forEach(detail -> {
            detail.setMainId(mainId);
            detail.setFillDate(qfOperationSopM.getFillDate());
            if (null == detail.getBudgetYtd()) {
                detail.setBudgetYtd(BigDecimal.ZERO);
            }
            if (null == detail.getActualYtd()) {
                detail.setActualYtd(BigDecimal.ZERO);
            }
            if (!historyMap.containsKey(detail.getCustomer())) {
                detail.setActual(detail.getActualYtd());
                detail.setBudget(detail.getActualYtd());
            } else {
                QfOperationSopD sopD = (QfOperationSopD)((Object)((Object)historyMap.get(detail.getCustomer())));
                if (null == sopD.getBudgetYtd()) {
                    detail.setBudget(BigDecimal.ZERO);
                } else {
                    detail.setBudget(detail.getBudgetYtd().subtract(sopD.getBudgetYtd()));
                }
                if (null == sopD.getActualYtd()) {
                    detail.setActual(BigDecimal.ZERO);
                } else {
                    detail.setActual(detail.getActualYtd().subtract(sopD.getActualYtd()));
                }
                if (null == sopD) {
                    detail.setActual(detail.getActualYtd());
                    detail.setBudget(detail.getActualYtd());
                }
            }
        });
        boolean b = this.sopDManager.saveBatch(list);
        return b;
    }

    @Override
    public boolean updateStatus(QfOperationSopM t) {
        QfOperationSopM qfOperationKpiM = (QfOperationSopM)((Object)((QfOperationSopMDao)this.baseMapper).selectById((Serializable)((Object)t.getId())));
        if (null == qfOperationKpiM) {
            return false;
        }
        qfOperationKpiM.setStatus(qfOperationKpiM.getStatus() == 0 ? 1 : 0);
        int i = ((QfOperationSopMDao)this.baseMapper).updateById((Object)qfOperationKpiM);
        return i > 0;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean insertInfo(QfOperationSopM t) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"fill_year_", (Object)t.getFillYear());
        queryWrapper.eq((Object)"fill_month_", (Object)t.getFillMonth());
        queryWrapper.eq((Object)"report_id_", (Object)t.getReportId());
        List qfOperationKpiMS = ((QfOperationSopMDao)this.baseMapper).selectList((Wrapper)queryWrapper);
        if (!CollectionUtils.isEmpty((Collection)qfOperationKpiMS)) {
            throw new BaseException(I18nUtil.getMessage((String)"QfOperationKpiM.repeat", (Locale)LocaleContextHolder.getLocale()));
        }
        int insert = ((QfOperationSopMDao)this.baseMapper).insert((Object)t);
        return insert > 0;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean updateInfo(QfOperationSopM t) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"fill_year_", (Object)t.getFillYear());
        queryWrapper.eq((Object)"fill_month_", (Object)t.getFillMonth());
        queryWrapper.eq((Object)"report_id_", (Object)t.getReportId());
        queryWrapper.ne((Object)"id_", (Object)t.getId());
        List qfOperationKpiMS = ((QfOperationSopMDao)this.baseMapper).selectList((Wrapper)queryWrapper);
        if (!CollectionUtils.isEmpty((Collection)qfOperationKpiMS)) {
            throw new BaseException(I18nUtil.getMessage((String)"QfOperationKpiM.repeat", (Locale)LocaleContextHolder.getLocale()));
        }
        int insert = ((QfOperationSopMDao)this.baseMapper).updateById((Object)t);
        return insert > 0;
    }

    private Map<String, QfOperationSopD> historyList(QfOperationSopM operationSopM) {
        List<QfOperationSopD> historyList = ((QfOperationSopMDao)this.baseMapper).historyList(operationSopM.getFillMonth() - 1, operationSopM.getFillYear());
        if (CollectionUtils.isEmpty(historyList)) {
            return Maps.newHashMap();
        }
        Map<String, QfOperationSopD> historyProduct = historyList.stream().collect(Collectors.toMap(item -> item.getCustomer(), item -> item));
        return historyProduct;
    }
}

