/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.cqlt.manager.impl;

import com.alibaba.fastjson.JSONObject;
import com.artfess.base.enums.SubjectSpeciesEnum;
import com.artfess.base.exception.BaseException;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.CommonUtil;
import com.artfess.base.util.StringUtil;
import com.artfess.cqlt.dao.QfFinanceSasacCompanyMDao;
import com.artfess.cqlt.manager.QfFinanceBsDManager;
import com.artfess.cqlt.manager.QfFinanceCfDManager;
import com.artfess.cqlt.manager.QfFinancePlDManager;
import com.artfess.cqlt.manager.QfFinanceReportingSummaryDManager;
import com.artfess.cqlt.manager.QfFinanceSasacCompanyDManager;
import com.artfess.cqlt.manager.QfFinanceSasacCompanyMManager;
import com.artfess.cqlt.manager.QfHrPersonDManager;
import com.artfess.cqlt.manager.QfReportRangeManager;
import com.artfess.cqlt.manager.QfReportSubjectManager;
import com.artfess.cqlt.model.QfEnterpriseInfo;
import com.artfess.cqlt.model.QfFinanceSasacCompanyD;
import com.artfess.cqlt.model.QfFinanceSasacCompanyM;
import com.artfess.cqlt.model.QfSubjectInfo;
import com.artfess.cqlt.vo.ReportDataVo;
import com.artfess.i18n.util.I18nUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.google.api.client.util.Lists;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class QfFinanceSasacCompanyMManagerImpl
extends BaseManagerImpl<QfFinanceSasacCompanyMDao, QfFinanceSasacCompanyM>
implements QfFinanceSasacCompanyMManager {
    private static final Logger log = LoggerFactory.getLogger(QfFinanceSasacCompanyMManagerImpl.class);
    @Autowired
    private QfReportSubjectManager reportSubjectManager;
    @Autowired
    private QfReportRangeManager reportRangeManager;
    @Autowired
    private QfFinanceSasacCompanyDManager financeSasacCompanyDManager;
    @Autowired
    private QfFinanceBsDManager financeBsDManager;
    @Autowired
    private QfFinancePlDManager financePlDManager;
    @Autowired
    private QfHrPersonDManager personDManager;
    @Autowired
    private QfFinanceCfDManager financeCfDManager;
    @Autowired
    private QfFinanceReportingSummaryDManager reportingSummaryDManager;
    @Resource
    private ThreadPoolExecutor threadPoolExecutor;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean conversion(String mainId) throws ExecutionException, InterruptedException {
        if (StringUtils.isEmpty((Object)mainId)) {
            return false;
        }
        QfFinanceSasacCompanyM mainInfo = (QfFinanceSasacCompanyM)((Object)((QfFinanceSasacCompanyMDao)this.baseMapper).selectById((Serializable)((Object)mainId)));
        if (null == mainInfo) {
            return false;
        }
        Assert.isTrue((!"1".equals(mainInfo.getStatus()) ? 1 : 0) != 0, (String)I18nUtil.getMessage((String)"data_operate", (Locale)LocaleContextHolder.getLocale()));
        String reportId = mainInfo.getReportId();
        List<QfEnterpriseInfo> rangeList = this.reportRangeManager.getQfEnterpriseInfo(reportId);
        List<QfSubjectInfo> subjectInfoList = this.reportSubjectManager.getSubjectInfo(reportId);
        if (CollectionUtils.isEmpty(subjectInfoList)) {
            return false;
        }
        QueryWrapper companyDQueryWrapper = new QueryWrapper();
        companyDQueryWrapper.eq((Object)"main_id_", (Object)mainId);
        this.financeSasacCompanyDManager.remove((Wrapper)companyDQueryWrapper);
        Map<String, List<String>> typeSubjectMap = this.getTypeSubjectMap(subjectInfoList);
        List<ReportDataVo> allData = this.getAllData(mainInfo, typeSubjectMap);
        Map<String, QfEnterpriseInfo> enterpriseInfoMap = rangeList.stream().collect(Collectors.toMap(item -> item.getCode(), item -> item));
        ArrayList detailList = com.google.common.collect.Lists.newArrayList();
        subjectInfoList.forEach(subjectInfo -> this.processDetail((QfSubjectInfo)((Object)subjectInfo), detailList, allData, mainInfo, enterpriseInfoMap));
        if (CollectionUtils.isEmpty((Collection)detailList)) {
            return false;
        }
        try {
            this.partitionSave(detailList);
        }
        catch (Exception e) {
            log.error("\u8f6c\u6362\u56fd\u8d44\u59d4\u62a5\u8868\u5931\u8d25:{}", (Object)e.getMessage());
            return false;
        }
        return true;
    }

    private void processDetail(QfSubjectInfo subjectInfo, List<QfFinanceSasacCompanyD> detailList, List<ReportDataVo> allData, QfFinanceSasacCompanyM mainInfo, Map<String, QfEnterpriseInfo> enterpriseInfoMap) {
        Map<String, List<ReportDataVo>> enterpriseMap = allData.stream().collect(Collectors.groupingBy(ReportDataVo::getEnterpriseCode));
        String targetCalculation = subjectInfo.getExpression();
        List expressionKey = CommonUtil.getExpressionKey((String)targetCalculation);
        enterpriseMap.forEach((enterpriseCode, dataVoList) -> {
            if (!enterpriseInfoMap.containsKey(enterpriseCode)) {
                return;
            }
            QfEnterpriseInfo qfEnterpriseInfo = (QfEnterpriseInfo)((Object)((Object)enterpriseInfoMap.get(enterpriseCode)));
            QfFinanceSasacCompanyD detail = new QfFinanceSasacCompanyD();
            this.createBaseInfo(mainInfo, subjectInfo, detail);
            detail.setEnterpriseNameEn(qfEnterpriseInfo.getNameEn());
            detail.setEnterpriseName(qfEnterpriseInfo.getName());
            detail.setEnterpriseCode((String)enterpriseCode);
            if (!StringUtils.isEmpty((Object)targetCalculation)) {
                this.calculateData(subjectInfo, mainInfo, targetCalculation, expressionKey, (List<ReportDataVo>)dataVoList, detail);
            }
            detailList.add(detail);
        });
    }

    private void partitionSave(List<QfFinanceSasacCompanyD> detailList) throws InterruptedException {
        List partition = BeanUtils.partition(detailList, (int)100);
        ExecutorService executorService = Executors.newFixedThreadPool(partition.size());
        CountDownLatch countDownLatch = new CountDownLatch(partition.size());
        int i = 0;
        while (i < partition.size()) {
            int finalI = i++;
            executorService.execute(() -> {
                List importParamDTOList = (List)partition.get(finalI);
                this.financeSasacCompanyDManager.saveBatch(importParamDTOList);
                countDownLatch.countDown();
            });
        }
        countDownLatch.await();
        executorService.shutdown();
    }

    private void calculateData(QfSubjectInfo subjectInfo, QfFinanceSasacCompanyM mainInfo, String targetCalculation, List<String> expressionKey, List<ReportDataVo> dataVoList, QfFinanceSasacCompanyD detail) {
        BigDecimal dataRata;
        BigDecimal fillUnrealData = BigDecimal.ZERO;
        BigDecimal lastYearfillRealData = BigDecimal.ZERO;
        BigDecimal lastYearfillUnrealData = BigDecimal.ZERO;
        BigDecimal fillRealData = BigDecimal.ZERO;
        HashMap fillUnreal_TCM = Maps.newHashMap();
        HashMap lastYearfillReal_TCM = Maps.newHashMap();
        HashMap lastYearfillUnReal_TCM = Maps.newHashMap();
        HashMap fillReal_TCM = Maps.newHashMap();
        Map<String, ReportDataVo> dataVoMap = dataVoList.stream().collect(Collectors.toMap(item -> item.getSubjectCode(), item -> item));
        for (String key : expressionKey) {
            if (StringUtils.isEmpty((Object)key) || !dataVoMap.containsKey(key)) continue;
            ReportDataVo dataVo = dataVoMap.get(key);
            key = "U" + key;
            fillReal_TCM.put(key, dataVo.getFillRealData());
            fillUnreal_TCM.put(key, dataVo.getFillUnrealData());
            lastYearfillReal_TCM.put(key, dataVo.getLastYearfillRealData());
            lastYearfillUnReal_TCM.put(key, dataVo.getLastYearfillUnrealData());
        }
        log.info("expressionKey:{},targetCalculation:{},fillReal_TCM:{},\u516c\u53f8\u7f16\u7801\uff1a{}", new Object[]{expressionKey, targetCalculation, fillReal_TCM, detail.getEnterpriseCode()});
        Map<String, BigDecimal> dataRataMap = this.getDataRata(subjectInfo, mainInfo);
        String handledTargetCalculation = targetCalculation;
        for (String key : expressionKey) {
            key = "U" + key;
            if (!fillReal_TCM.containsKey(key)) {
                fillReal_TCM.put(key, BigDecimal.ZERO);
            }
            if (!fillUnreal_TCM.containsKey(key)) {
                fillUnreal_TCM.put(key, BigDecimal.ZERO);
            }
            if (!lastYearfillUnReal_TCM.containsKey(key)) {
                lastYearfillUnReal_TCM.put(key, BigDecimal.ZERO);
            }
            if (lastYearfillReal_TCM.containsKey(key)) continue;
            lastYearfillReal_TCM.put(key, BigDecimal.ZERO);
        }
        if (fillReal_TCM.size() == expressionKey.size()) {
            targetCalculation = CommonUtil.replaceExpression(expressionKey, (String)handledTargetCalculation);
            dataRata = BigDecimal.ONE;
            if (dataRataMap.containsKey("fillRealData") && null != dataRataMap.get("fillRealData")) {
                dataRata = dataRataMap.get("fillRealData");
            }
            fillRealData = CommonUtil.convertToCode((String)targetCalculation, (Map)fillReal_TCM, (int)2).multiply(dataRata);
        }
        detail.setFillRealData(fillRealData);
        if (fillUnreal_TCM.size() == expressionKey.size()) {
            dataRata = BigDecimal.ONE;
            if (dataRataMap.containsKey("fillUnrealData") && null != dataRataMap.get("fillUnrealData")) {
                dataRata = dataRataMap.get("fillUnrealData");
            }
            targetCalculation = CommonUtil.replaceExpression(expressionKey, (String)handledTargetCalculation);
            fillUnrealData = CommonUtil.convertToCode((String)targetCalculation, (Map)fillUnreal_TCM, (int)2).multiply(dataRata);
        }
        detail.setFillUnrealData(fillUnrealData);
        if (lastYearfillUnReal_TCM.size() == expressionKey.size()) {
            dataRata = BigDecimal.ONE;
            if (dataRataMap.containsKey("lastYearfillUnrealData") && null != dataRataMap.get("lastYearfillUnrealData")) {
                dataRata = dataRataMap.get("lastYearfillUnrealData");
            }
            targetCalculation = CommonUtil.replaceExpression(expressionKey, (String)handledTargetCalculation);
            lastYearfillUnrealData = CommonUtil.convertToCode((String)targetCalculation, (Map)lastYearfillUnReal_TCM, (int)2).multiply(dataRata);
        }
        detail.setLastYearfillUnrealData(lastYearfillUnrealData);
        if (lastYearfillReal_TCM.size() == expressionKey.size()) {
            dataRata = BigDecimal.ONE;
            if (dataRataMap.containsKey("lastYearfillRealData") && null != dataRataMap.get("lastYearfillRealData")) {
                dataRata = dataRataMap.get("lastYearfillRealData");
            }
            targetCalculation = CommonUtil.replaceExpression(expressionKey, (String)handledTargetCalculation);
            lastYearfillRealData = CommonUtil.convertToCode((String)targetCalculation, (Map)lastYearfillReal_TCM, (int)2).multiply(dataRata);
        }
        detail.setLastYearfillRealData(lastYearfillRealData);
    }

    private void createBaseInfo(QfFinanceSasacCompanyM mainInfo, QfSubjectInfo subjectInfo, QfFinanceSasacCompanyD detail) {
        detail.setMainId(mainInfo.getId());
        detail.setFillDate(mainInfo.getFillDate());
        detail.setSubjectCode(subjectInfo.getCode());
        detail.setSubjectName(subjectInfo.getName());
        detail.setSubjectLevel(subjectInfo.getLevel());
        detail.setSubjectNameEn(subjectInfo.getNameEn());
        detail.setSubjectUnit(subjectInfo.getUnit());
        detail.setSn(subjectInfo.getSn());
        detail.setStartMonth(1);
        detail.setEndMonth(mainInfo.getFillQuarter() * 3);
    }

    private Map<String, BigDecimal> getDataRata(QfSubjectInfo subjectInfo, QfFinanceSasacCompanyM mainInfo) {
        HashMap map = Maps.newHashMap();
        if (StringUtils.isEmpty((Object)subjectInfo.getRateType())) {
            return map;
        }
        if (StringUtil.isEmpty((String)subjectInfo.getCode()) || !"\uffe5".equals(subjectInfo.getUnit())) {
            return map;
        }
        if (subjectInfo.getRateType().equals(1)) {
            map.put("fillUnrealData", mainInfo.getYearAvgRate());
            map.put("lastYearfillUnrealData", mainInfo.getLastYearAvgRate());
            map.put("fillRealData", mainInfo.getYearYtdAvgRate());
            map.put("lastYearfillRealData", mainInfo.getLastYearYtdAvgRate());
        } else if (subjectInfo.getRateType().equals(2)) {
            map.put("fillUnrealData", mainInfo.getYearEndRate());
            map.put("lastYearfillUnrealData", mainInfo.getLastYearEndRate());
            map.put("fillRealData", mainInfo.getYearYtdEndRate());
            map.put("lastYearfillRealData", mainInfo.getLastYearYtdEndRate());
        }
        return map;
    }

    private List<ReportDataVo> getAllData(QfFinanceSasacCompanyM mainInfo, Map<String, List<String>> typeSubjectMap) throws ExecutionException, InterruptedException {
        ArrayList list = com.google.common.collect.Lists.newArrayList();
        Integer endMonth = mainInfo.getFillQuarter() * 3;
        CompletableFuture<Void> cfFuture = CompletableFuture.runAsync(() -> {
            List<ReportDataVo> cfList;
            if (typeSubjectMap.containsKey(SubjectSpeciesEnum.CF.getType()) && !CollectionUtils.isEmpty(cfList = this.financeCfDManager.getCfDataList((List)typeSubjectMap.get(SubjectSpeciesEnum.CF.getType()), mainInfo.getFillYear(), endMonth))) {
                list.addAll(cfList);
            }
        }, this.threadPoolExecutor);
        CompletableFuture<Void> bsFuture = CompletableFuture.runAsync(() -> {
            List<ReportDataVo> bsList;
            if (typeSubjectMap.containsKey(SubjectSpeciesEnum.BS.getType()) && !CollectionUtils.isEmpty(bsList = this.financeBsDManager.getBsDataList((List)typeSubjectMap.get(SubjectSpeciesEnum.BS.getType()), mainInfo.getFillYear(), endMonth))) {
                list.addAll(bsList);
            }
        }, this.threadPoolExecutor);
        CompletableFuture<Void> hrFuture = CompletableFuture.runAsync(() -> {
            List<ReportDataVo> personList;
            if (typeSubjectMap.containsKey(SubjectSpeciesEnum.HR.getType()) && !CollectionUtils.isEmpty(personList = this.personDManager.getPersonDataList((List)typeSubjectMap.get(SubjectSpeciesEnum.HR.getType()), mainInfo.getFillYear(), endMonth))) {
                list.addAll(personList);
            }
        }, this.threadPoolExecutor);
        CompletableFuture<Void> plFuture = CompletableFuture.runAsync(() -> {
            List<ReportDataVo> plList;
            if (typeSubjectMap.containsKey(SubjectSpeciesEnum.PL.getType()) && !CollectionUtils.isEmpty(plList = this.financePlDManager.getActualDataList((List)typeSubjectMap.get(SubjectSpeciesEnum.PL.getType()), mainInfo.getFillYear(), endMonth))) {
                list.addAll(plList);
            }
        }, this.threadPoolExecutor);
        CompletableFuture<Void> reportFuture = CompletableFuture.runAsync(() -> {
            List<ReportDataVo> cfList;
            if (typeSubjectMap.containsKey(SubjectSpeciesEnum.SA.getType()) && !CollectionUtils.isEmpty(cfList = this.reportingSummaryDManager.getDataList((List)typeSubjectMap.get(SubjectSpeciesEnum.SA.getType()), mainInfo.getFillYear(), endMonth))) {
                list.addAll(cfList);
            }
        }, this.threadPoolExecutor);
        CompletableFuture.allOf(cfFuture, bsFuture, hrFuture, plFuture, reportFuture).get();
        return list;
    }

    private Map<String, List<String>> getTypeSubjectMap(List<QfSubjectInfo> relationList) {
        relationList.forEach(subjectInfo -> {
            if (subjectInfo.getType().contains(SubjectSpeciesEnum.BS.getType())) {
                subjectInfo.setType(SubjectSpeciesEnum.BS.getType());
            } else if (subjectInfo.getType().contains(SubjectSpeciesEnum.PL.getType())) {
                subjectInfo.setType(SubjectSpeciesEnum.PL.getType());
            } else if (subjectInfo.getType().contains(SubjectSpeciesEnum.HR.getType())) {
                subjectInfo.setType(SubjectSpeciesEnum.HR.getType());
            } else if (subjectInfo.getType().contains(SubjectSpeciesEnum.CF.getType())) {
                subjectInfo.setType(SubjectSpeciesEnum.CF.getType());
            } else if (subjectInfo.getType().contains(SubjectSpeciesEnum.SA.getType())) {
                subjectInfo.setType(SubjectSpeciesEnum.SA.getType());
            }
        });
        Map<String, List<QfSubjectInfo>> gnSubjectMap = relationList.stream().collect(Collectors.groupingBy(QfSubjectInfo::getType));
        HashMap typeSubjectMap = Maps.newHashMap();
        gnSubjectMap.forEach((k, v) -> {
            ArrayList subjectCodes = com.google.common.collect.Lists.newArrayList();
            v.forEach(qfSubjectInfo -> {
                if (StringUtils.isEmpty((Object)qfSubjectInfo.getExpression())) {
                    return;
                }
                subjectCodes.addAll(CommonUtil.getExpressionKey((String)qfSubjectInfo.getExpression()));
            });
            if (k.contains(SubjectSpeciesEnum.BS.getType())) {
                typeSubjectMap.put(SubjectSpeciesEnum.BS.getType(), subjectCodes);
            } else if (k.contains(SubjectSpeciesEnum.PL.getType())) {
                typeSubjectMap.put(SubjectSpeciesEnum.PL.getType(), subjectCodes);
            } else if (k.contains(SubjectSpeciesEnum.HR.getType())) {
                typeSubjectMap.put(SubjectSpeciesEnum.HR.getType(), subjectCodes);
            } else if (k.contains(SubjectSpeciesEnum.CF.getType())) {
                typeSubjectMap.put(SubjectSpeciesEnum.CF.getType(), subjectCodes);
            } else if (k.contains(SubjectSpeciesEnum.SA.getType())) {
                typeSubjectMap.put(SubjectSpeciesEnum.SA.getType(), subjectCodes);
            }
        });
        return typeSubjectMap;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean updateStatus(QfFinanceSasacCompanyM t) {
        QfFinanceSasacCompanyM QfFinanceSasacCompanyM2 = (QfFinanceSasacCompanyM)((Object)((QfFinanceSasacCompanyMDao)this.baseMapper).selectById((Serializable)((Object)t.getId())));
        if (null == QfFinanceSasacCompanyM2) {
            return false;
        }
        QfFinanceSasacCompanyM2.setStatus(QfFinanceSasacCompanyM2.getStatus() == 0 ? 1 : 0);
        int i = ((QfFinanceSasacCompanyMDao)this.baseMapper).updateById((Object)QfFinanceSasacCompanyM2);
        return i > 0;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean updateInfo(QfFinanceSasacCompanyM t) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"fill_year_", (Object)t.getFillYear());
        queryWrapper.eq((Object)"fill_quarter_", (Object)t.getFillQuarter());
        queryWrapper.eq((Object)"report_id_", (Object)t.getReportId());
        queryWrapper.ne((Object)"id_", (Object)t.getId());
        List QfFinanceSasacCompanyMS = ((QfFinanceSasacCompanyMDao)this.baseMapper).selectList((Wrapper)queryWrapper);
        if (!CollectionUtils.isEmpty((Collection)QfFinanceSasacCompanyMS)) {
            throw new BaseException(I18nUtil.getMessage((String)"QfOperationKpiM.repeat", (Locale)LocaleContextHolder.getLocale()));
        }
        int insert = ((QfFinanceSasacCompanyMDao)this.baseMapper).updateById((Object)t);
        return insert > 0;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean insertInfo(QfFinanceSasacCompanyM t) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"fill_year_", (Object)t.getFillYear());
        queryWrapper.eq((Object)"fill_quarter_", (Object)t.getFillQuarter());
        queryWrapper.eq((Object)"report_id_", (Object)t.getReportId());
        List QfFinanceSasacCompanyMS = ((QfFinanceSasacCompanyMDao)this.baseMapper).selectList((Wrapper)queryWrapper);
        if (!CollectionUtils.isEmpty((Collection)QfFinanceSasacCompanyMS)) {
            throw new BaseException(I18nUtil.getMessage((String)"QfOperationKpiM.repeat", (Locale)LocaleContextHolder.getLocale()));
        }
        int insert = ((QfFinanceSasacCompanyMDao)this.baseMapper).insert((Object)t);
        return insert > 0;
    }

    @Override
    public List<JSONObject> detailQuery(List<QfFinanceSasacCompanyD> list) {
        if (CollectionUtils.isEmpty(list)) {
            return Lists.newArrayList();
        }
        String mainId = list.get(0).getMainId();
        QfFinanceSasacCompanyM mainInfo = (QfFinanceSasacCompanyM)((Object)((QfFinanceSasacCompanyMDao)this.baseMapper).selectById((Serializable)((Object)mainId)));
        List<QfEnterpriseInfo> rangeList = this.reportRangeManager.getQfEnterpriseInfo(mainInfo.getReportId());
        List<QfSubjectInfo> subjectInfoList = this.reportSubjectManager.getSubjectInfo(mainInfo.getReportId());
        ArrayList detailList = com.google.common.collect.Lists.newArrayList();
        this.createHeaderInfo(mainInfo, rangeList, detailList);
        for (QfSubjectInfo subject : subjectInfoList) {
            JSONObject data = new JSONObject(true);
            data.put("subjectCode", (Object)subject.getCode());
            for (QfFinanceSasacCompanyD companyD : list) {
                if (!companyD.getSubjectCode().equals(subject.getCode())) continue;
                data.put("subjectName", (Object)companyD.getSubjectName());
                data.put("sn", (Object)companyD.getSn());
                if (!StringUtils.isEmpty((Object)subject.getUnit()) && "\uffe5".equals(subject.getUnit())) {
                    companyD.setSubjectUnit("\u4e07\u5143");
                    if (null != companyD.getFillUnrealData()) {
                        companyD.setFillUnrealData(companyD.getFillUnrealData().divide(new BigDecimal(10000), 2, 4));
                    }
                    if (null != companyD.getLastYearfillUnrealData()) {
                        companyD.setLastYearfillUnrealData(companyD.getLastYearfillUnrealData().divide(new BigDecimal(10000), 2, 4));
                    }
                    if (null != companyD.getFillRealData()) {
                        companyD.setFillRealData(companyD.getFillUnrealData().divide(new BigDecimal(10000), 2, 4));
                    }
                    if (null != companyD.getLastYearfillRealData()) {
                        companyD.setLastYearfillRealData(companyD.getFillUnrealData().divide(new BigDecimal(10000), 2, 4));
                    }
                }
                data.put("unit", (Object)companyD.getSubjectUnit());
                data.put("subjectLevel", (Object)companyD.getSubjectLevel());
                if ("CIGR".equals(companyD.getEnterpriseCode())) {
                    data.put("fillUnrealData", (Object)companyD.getFillUnrealData());
                    data.put("lastYearfillUnrealData", (Object)companyD.getLastYearfillUnrealData());
                    data.put("fillRealData", (Object)companyD.getFillRealData());
                    data.put("lastYearfillRealData", (Object)companyD.getLastYearfillRealData());
                    continue;
                }
                data.put("nowUnreal" + companyD.getEnterpriseCode(), (Object)companyD.getFillUnrealData());
                data.put("lastUnreal" + companyD.getEnterpriseCode(), (Object)companyD.getLastYearfillUnrealData());
                data.put("nowReal" + companyD.getEnterpriseCode(), (Object)companyD.getFillRealData());
                data.put("lastReal" + companyD.getEnterpriseCode(), (Object)companyD.getLastYearfillRealData());
            }
            detailList.add(data);
        }
        return detailList;
    }

    private void createHeaderInfo(QfFinanceSasacCompanyM mainInfo, List<QfEnterpriseInfo> enterpriseHeader, List<JSONObject> detailList) {
        JSONObject detail = new JSONObject(true);
        detail.put("subjectName", (Object)"\u9879\u76ee");
        detail.put("sn", (Object)"\u884c\u6b21");
        detail.put("unit", (Object)"\u5355\u4f4d");
        detail.put("fillUnrealData", (Object)("1-" + (mainInfo.getFillQuarter() * 3 - 1) + "\u6708\u672c\u5e74\u7d2f\u8ba1"));
        detail.put("lastYearfillUnrealData", (Object)("1-" + (mainInfo.getFillQuarter() * 3 - 1) + "\u6708\u4e0a\u5e74\u540c\u671f"));
        detail.put("fillRealData", (Object)("1-" + mainInfo.getFillQuarter() * 3 + "\u6708\u672c\u5e74\u7d2f\u8ba1"));
        detail.put("lastYearfillRealData", (Object)("1-" + mainInfo.getFillQuarter() * 3 + "\u6708\u4e0a\u5e74\u540c\u671f"));
        detail.put("subjectLevel", (Object)"subjectLevel");
        enterpriseHeader.forEach(enterprise -> {
            String code = enterprise.getCode();
            if ("CIGR".equals(code)) {
                return;
            }
            detail.put("nowUnreal" + code, (Object)(code + "\n" + "1-" + (mainInfo.getFillQuarter() * 3 - 1) + "\u6708\u672c\u5e74\u7d2f\u8ba1"));
            detail.put("lastUnreal" + code, (Object)(code + "\n" + "1-" + (mainInfo.getFillQuarter() * 3 - 1) + "\u6708\u4e0a\u5e74\u540c\u671f"));
            detail.put("nowReal" + code, (Object)(code + "\n" + "1-" + mainInfo.getFillQuarter() * 3 + "\u6708\u672c\u5e74\u7d2f\u8ba1"));
            detail.put("lastReal" + code, (Object)(code + "\n" + "1-" + mainInfo.getFillQuarter() * 3 + "\u6708\u4e0a\u5e74\u540c\u671f"));
        });
        detailList.add(detail);
    }
}

