/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.cqlt.manager.impl;

import com.artfess.base.exception.BaseException;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.util.StringUtil;
import com.artfess.cqlt.dao.QfFinanceLiquidityMDao;
import com.artfess.cqlt.manager.QfEnterpriseInfoManager;
import com.artfess.cqlt.manager.QfFinanceLiquidityDetailManager;
import com.artfess.cqlt.manager.QfFinanceLiquidityMManager;
import com.artfess.cqlt.model.QfEnterpriseInfo;
import com.artfess.cqlt.model.QfFinanceLiquidityDetail;
import com.artfess.cqlt.model.QfFinanceLiquidityM;
import com.artfess.i18n.util.I18nUtil;
import com.artfess.poi.util.HeaderNode;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.temporal.TemporalAdjusters;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class QfFinanceLiquidityMManagerImpl
extends BaseManagerImpl<QfFinanceLiquidityMDao, QfFinanceLiquidityM>
implements QfFinanceLiquidityMManager {
    private static final Logger log = LoggerFactory.getLogger(QfFinanceLiquidityMManagerImpl.class);
    private static final String TOTAL_ACTUAL = "Cumulative";
    private static final String BALANCE_SUMMARY = "SGGR";
    private static final String SLR = "SLR";
    private static final String SGGR_SLR = "SGGR_SLR";
    @Autowired
    private QfFinanceLiquidityDetailManager liquidityDetailManager;
    @Autowired
    private QfEnterpriseInfoManager enterpriseInfoManager;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean insertInfo(QfFinanceLiquidityM t) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"fill_year_", (Object)t.getFillYear());
        queryWrapper.eq((Object)"fill_week_", (Object)t.getFillWeek());
        queryWrapper.eq((Object)"report_id_", (Object)t.getReportId());
        List QfFinanceLiquidityMS = ((QfFinanceLiquidityMDao)this.baseMapper).selectList((Wrapper)queryWrapper);
        if (!CollectionUtils.isEmpty((Collection)QfFinanceLiquidityMS)) {
            throw new BaseException(I18nUtil.getMessage((String)"QfFinanceLiquidityM.repeat", (Locale)LocaleContextHolder.getLocale()));
        }
        int insert = ((QfFinanceLiquidityMDao)this.baseMapper).insert((Object)t);
        return insert > 0;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean updateInfo(QfFinanceLiquidityM t) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"fill_year_", (Object)t.getFillYear());
        queryWrapper.eq((Object)"fill_week_", (Object)t.getFillWeek());
        queryWrapper.eq((Object)"report_id_", (Object)t.getReportId());
        queryWrapper.ne((Object)"id_", (Object)t.getId());
        List QfFinanceLiquidityMS = ((QfFinanceLiquidityMDao)this.baseMapper).selectList((Wrapper)queryWrapper);
        if (!CollectionUtils.isEmpty((Collection)QfFinanceLiquidityMS)) {
            throw new BaseException(I18nUtil.getMessage((String)"QfOperationKpiM.repeat", (Locale)LocaleContextHolder.getLocale()));
        }
        int insert = ((QfFinanceLiquidityMDao)this.baseMapper).updateById((Object)t);
        return insert > 0;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean updateStatus(QfFinanceLiquidityM t) {
        QfFinanceLiquidityM QfFinanceLiquidityM2 = (QfFinanceLiquidityM)((Object)((QfFinanceLiquidityMDao)this.baseMapper).selectById((Serializable)((Object)t.getId())));
        if (null == QfFinanceLiquidityM2) {
            return false;
        }
        QfFinanceLiquidityM2.setStatus(QfFinanceLiquidityM2.getStatus() == 0 ? 1 : 0);
        int i = ((QfFinanceLiquidityMDao)this.baseMapper).updateById((Object)QfFinanceLiquidityM2);
        return i > 0;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean importExcel(List<HeaderNode> list, String mainId) {
        if (CollectionUtils.isEmpty(list)) {
            return false;
        }
        QfFinanceLiquidityM mainInfo = (QfFinanceLiquidityM)((Object)((QfFinanceLiquidityMDao)this.baseMapper).selectById((Serializable)((Object)mainId)));
        Assert.notNull((Object)((Object)mainInfo), (String)I18nUtil.getMessage((String)"filldata.notExist", (Locale)LocaleContextHolder.getLocale()));
        Assert.isTrue((!"1".equals(mainInfo.getStatus()) ? 1 : 0) != 0, (String)I18nUtil.getMessage((String)"data_operate", (Locale)LocaleContextHolder.getLocale()));
        this.removeInfo(mainId);
        Map<String, QfEnterpriseInfo> enterpriseInfoMap = this.enterpriseInfoManager.getEnterpriseInfoMap(null);
        List<HeaderNode> headerNodeList = list.stream().collect(Collectors.groupingBy(HeaderNode::getRow)).get(0);
        HashMap headerMap = Maps.newHashMap();
        for (HeaderNode headerNode : headerNodeList) {
            headerMap.put(headerNode.getColumn(), headerNode.getHeaderName());
        }
        Map<Integer, List<HeaderNode>> detailMap = list.stream().collect(Collectors.groupingBy(HeaderNode::getColumn));
        List<HeaderNode> periodList = detailMap.get(1);
        HashMap periodMap = Maps.newHashMap();
        HashMap dataTypeMap = Maps.newHashMap();
        HashMap slrMap = Maps.newHashMap();
        for (HeaderNode headerNode : periodList) {
            periodMap.put(headerNode.getRow(), headerNode.getHeaderName());
        }
        periodList = detailMap.get(0);
        for (HeaderNode headerNode : periodList) {
            if (StringUtils.isEmpty((Object)headerNode.getHeaderName())) continue;
            dataTypeMap.put(headerNode.getRow(), headerNode.getHeaderName());
        }
        periodList = detailMap.get(2);
        for (HeaderNode headerNode : periodList) {
            if (StringUtils.isEmpty((Object)headerNode.getHeaderName()) || !headerNode.getHeaderName().contains(SLR)) continue;
            slrMap.put(headerNode.getRow(), headerNode.getHeaderName());
        }
        LocalDate localDate = LocalDate.of((int)mainInfo.getFillYear(), 1, 1);
        Integer fillWeek = mainInfo.getFillWeek();
        ArrayList actualList = Lists.newArrayList();
        for (Map.Entry<Integer, List<HeaderNode>> entry : detailMap.entrySet()) {
            Integer column = entry.getKey();
            List<HeaderNode> nodes = entry.getValue();
            for (HeaderNode node : nodes) {
                if (0 == node.getRow() || 1 == node.getColumn() || 0 == node.getColumn()) continue;
                Integer week = fillWeek + column - 2;
                String period = (String)periodMap.get(node.getRow());
                QfFinanceLiquidityDetail detail = new QfFinanceLiquidityDetail();
                detail.setMainId(mainInfo.getId());
                detail.setFillYear(mainInfo.getFillYear());
                detail.setFillDate(mainInfo.getFillDate());
                detail.setFillWeek(week);
                detail.setSn(node.getRow());
                LocalDate startTime = localDate.with(TemporalAdjusters.dayOfWeekInMonth(week - 1, DayOfWeek.SATURDAY));
                LocalDate endTime = localDate.with(TemporalAdjusters.dayOfWeekInMonth(week, DayOfWeek.FRIDAY));
                detail.setFillStartDate(startTime);
                detail.setFillEndDate(endTime);
                if (week.equals(mainInfo.getFillWeek())) {
                    detail.setFillType(1);
                } else {
                    detail.setFillType(2);
                }
                this.createDetail(enterpriseInfoMap, dataTypeMap, actualList, slrMap, node, period, detail);
            }
        }
        this.liquidityDetailManager.saveBatch(actualList);
        return true;
    }

    private void createDetail(Map<String, QfEnterpriseInfo> enterpriseInfoMap, Map<Integer, String> dataTypeMap, List<QfFinanceLiquidityDetail> actualList, Map<Integer, String> slrMap, HeaderNode node, String period, QfFinanceLiquidityDetail detail) {
        if (enterpriseInfoMap.containsKey(period)) {
            QfEnterpriseInfo qfEnterpriseInfo = enterpriseInfoMap.get(period);
            detail.setEnterpriseCode(qfEnterpriseInfo.getCode());
            detail.setEnterpriseName(qfEnterpriseInfo.getName());
            detail.setEnterpriseNameEn(qfEnterpriseInfo.getNameEn());
        } else if (StringUtil.isNotEmpty((String)period)) {
            detail.setEnterpriseCode(period);
        } else {
            detail.setEnterpriseCode(slrMap.get(node.getRow()));
        }
        if (dataTypeMap.containsKey(node.getRow()) && !StringUtils.isEmpty((Object)dataTypeMap.get(node.getRow()))) {
            detail.setDataType(Integer.parseInt(dataTypeMap.get(node.getRow())));
        }
        Integer[] dateTypes = new Integer[]{3, 6, 9, 11, 13};
        if (1 == detail.getFillType() && Arrays.asList(dateTypes).contains(detail.getDataType())) {
            detail.setEnterpriseCode(slrMap.get(node.getRow()));
        } else if (!StringUtils.isEmpty((Object)node.getHeaderName()) && !"-".equals(node.getHeaderName())) {
            detail.setFillData(new BigDecimal(node.getHeaderName()));
        }
        actualList.add(detail);
    }

    private void removeInfo(String mainId) {
        QueryWrapper actualQuery = new QueryWrapper();
        actualQuery.eq((Object)"main_id_", (Object)mainId);
        this.liquidityDetailManager.remove((Wrapper)actualQuery);
    }
}

