/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.cqlt.controller;

import com.alibaba.fastjson.JSONObject;
import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.enums.ProductSalesDataTypeEnum;
import com.artfess.base.enums.SubjectTypeEnum;
import com.artfess.base.model.CommonResult;
import com.artfess.cqlt.manager.QfOperatingStatisticalManager;
import com.artfess.cqlt.manager.QfSubjectInternationalInfoManager;
import com.artfess.cqlt.model.QfSubjectInternationalInfo;
import com.artfess.cqlt.vo.OpReportReqVo;
import com.artfess.cqlt.vo.OpTargetRespVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u5927\u5c4f\u7edf\u8ba1--\u8fd0\u8425\u4e3b\u9898"})
@RequestMapping(value={"/qf/operation/statistical/"})
@ApiGroup(group={"group_biz"})
public class QfOperationStatisticalController {
    private static final Logger log = LoggerFactory.getLogger(QfOperationStatisticalController.class);
    @Autowired
    private QfOperatingStatisticalManager statisticalManager;
    @Autowired
    private QfSubjectInternationalInfoManager subjectInternationalInfoManager;

    @PostMapping(value={"/oneLevelData"})
    @ApiOperation(value="\u9500\u552e\u677f\u5757\u6307\u6807\u4e00\u7ea7\u754c\u9762\u7edf\u8ba1\u63a5\u53e3", response=OpTargetRespVo.class, notes="\u5305\u62ec\u6301\u7eed\u6539\u8fdb\u7c7b\u6570\u636e")
    public CommonResult<String> oneLevelData(@ApiParam(name="model", value="\u8bf7\u6c42\u53c2\u6570") @RequestBody OpReportReqVo t) {
        List<OpTargetRespVo> data = this.statisticalManager.data(t);
        return CommonResult.success(data, null);
    }

    @PostMapping(value={"/fromUnderData"})
    @ApiOperation(value="\u9500\u552e\u677f\u5757\u6839\u636e\u6307\u6807id\u83b7\u53d6\u5f53\u524d\u6307\u6807\u5206\u6790)", notes="\u5305\u62ec\u6301\u7eed\u6539\u8fdb\u7c7b\u6570\u636e")
    public CommonResult<String> fromUnderData(@ApiParam(name="model", value="\u8bf7\u6c42\u53c2\u6570") @RequestBody OpReportReqVo t) {
        List<OpTargetRespVo> data = this.statisticalManager.fromUnderData(t);
        return CommonResult.success(data, null);
    }

    @PostMapping(value={"/getSubjectList"})
    @ApiOperation(value="\u83b7\u53d6\u6240\u6709\u6301\u7eed\u6539\u8fdb\u7c7b\u522b")
    public CommonResult<List<QfSubjectInternationalInfo>> getSubjectList() {
        String type = SubjectTypeEnum.OP2.getType();
        List<QfSubjectInternationalInfo> list = this.subjectInternationalInfoManager.findByType(type);
        return CommonResult.success(list, null);
    }

    @PostMapping(value={"/getProductList"})
    @ApiOperation(value="\u83b7\u53d6\u6240\u6709\u4ea7\u54c1")
    public CommonResult getProductList() {
        ProductSalesDataTypeEnum[] values = ProductSalesDataTypeEnum.values();
        JSONObject json = new JSONObject(true);
        for (ProductSalesDataTypeEnum productSalesDataTypeEnum : values) {
            json.put(productSalesDataTypeEnum.getType(), (Object)productSalesDataTypeEnum.getDesc());
        }
        return CommonResult.success((Object)json, null);
    }
}

