/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.sysConfig.persistence.manager.impl;

import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.util.BeanUtils;
import com.artfess.sysConfig.persistence.dao.SysAreasDao;
import com.artfess.sysConfig.persistence.manager.SysAreasManager;
import com.artfess.sysConfig.persistence.model.SysAreas;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service
public class SysAreasManagerImpl
extends BaseManagerImpl<SysAreasDao, SysAreas>
implements SysAreasManager {
    @Resource
    SysAreasDao sysAreasDao;

    @Override
    @Transactional
    public String saveSysAreas(SysAreas sysAreas) {
        Assert.notNull((Object)((Object)sysAreas), (String)"\u884c\u653f\u533a\u5212\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        String msg = "";
        if (StringUtils.isNotBlank((CharSequence)sysAreas.getId())) {
            SysAreas old = (SysAreas)((Object)this.sysAreasDao.selectById((Serializable)((Object)sysAreas.getId())));
            this.updateTree(sysAreas, old.getName());
            msg = "\u66f4\u65b0\u6210\u529f";
        } else {
            sysAreas.setHasChildren(0);
            sysAreas.setSn(this.getNextSequenceByParentId(sysAreas.getParentId()));
            this.insertTree(sysAreas);
            msg = "\u65b0\u589e\u6210\u529f";
        }
        return msg;
    }

    @Override
    public List<SysAreas> queryAreasEntity(SysAreas sysAreas) {
        QueryWrapper queryWrapper = new QueryWrapper();
        if (StringUtils.isNotEmpty((CharSequence)sysAreas.getName())) {
            queryWrapper.like((Object)"name_", (Object)sysAreas.getName());
        }
        if (!CollectionUtils.isEmpty(sysAreas.getLevels())) {
            queryWrapper.in((Object)"LEVEL_CODE_", sysAreas.getLevels());
        }
        if (StringUtils.isNotEmpty((CharSequence)sysAreas.getLevelCode())) {
            queryWrapper.like((Object)"LEVEL_CODE_", (Object)sysAreas.getLevelCode());
        }
        queryWrapper.orderByAsc((Object)"SN_");
        return this.sysAreasDao.selectList((Wrapper)queryWrapper);
    }

    @Override
    @Transactional
    public void updateSequence(Map<String, Integer> params) {
        Assert.notNull(params, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        for (String key : params.keySet()) {
            UpdateWrapper updateWrapper = new UpdateWrapper();
            ((UpdateWrapper)updateWrapper.set((Object)"SN_", (Object)params.get(key))).eq((Object)"ID_", (Object)key);
            this.update((Wrapper)updateWrapper);
        }
    }

    @Override
    @Transactional
    public void deleteBatch(String ids) {
        Assert.hasText((String)ids, (String)"\u53c2\u6570ids\u4e0d\u80fd\u4e3a\u7a7a");
        List<String> idsList = Arrays.asList(ids.split(","));
        idsList.forEach(s -> {
            SysAreas sysAreas = (SysAreas)((Object)((Object)this.sysAreasDao.selectById((Serializable)((Object)s))));
            if (!sysAreas.getParentId().equals("root")) {
                SysAreas parent = (SysAreas)((Object)((Object)this.sysAreasDao.selectById((Serializable)((Object)sysAreas.getParentId()))));
                parent.setHasChildren(parent.getHasChildren() - 1);
                this.update((Model)parent);
            }
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.like((Object)"FULL_ID_", (Object)sysAreas.getFullId());
            this.sysAreasDao.delete((Wrapper)queryWrapper);
        });
    }

    @Override
    public List<SysAreas> tree(SysAreas sysAreas) {
        List<SysAreas> list = this.queryAreasEntity(sysAreas);
        List tree = BeanUtils.listToTree(list);
        return tree;
    }
}

