package com.artfess.bpm.plugin.usercalc.job.runtime;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import com.artfess.base.util.StringUtil;
import com.artfess.bpm.api.constant.BpmConstants;
import com.artfess.bpm.api.constant.ExtractType;
import com.artfess.bpm.api.model.identity.BpmIdentity;
import com.artfess.bpm.api.plugin.core.def.BpmPluginDef;
import com.artfess.bpm.api.plugin.core.session.BpmUserCalcPluginSession;
import com.artfess.bpm.plugin.core.runtime.AbstractUserCalcPlugin;
import com.artfess.bpm.plugin.usercalc.job.def.JobPluginDef;
import com.artfess.uc.api.constant.GroupTypeConstant;
import com.artfess.uc.api.impl.model.OrgJob;
import com.artfess.uc.api.model.IGroup;
import com.artfess.uc.api.service.IOrgService;

/**
 * 岗位作为审批人的插件
 *
 * @company 阿特菲斯信息技术有限公司
 * @author heyifan
 * @email heyf@jee-soft.cn
 * @date 2018年11月18日
 */
public class JobPlugin extends AbstractUserCalcPlugin{

	@Override
	public List<BpmIdentity> queryByPluginDef(BpmUserCalcPluginSession pluginSession, BpmPluginDef pluginDef) {
		List<BpmIdentity> identityList=new ArrayList<BpmIdentity>();
		JobPluginDef def = (JobPluginDef)pluginDef;
		String jobCode = def.getJobCode();
		String jobName = def.getJobName();
		if(StringUtil.isEmpty(jobCode)) return identityList;
		IOrgService orgEngine= pluginSession.getOrgEngine();
		Map<String, Object> vars= pluginSession.getVariables();
		boolean isReqUc = StringUtil.isEmpty((String)vars.get(BpmConstants.NOT_REQUEST_UC));
		IGroup group = null;
		if (isReqUc || ExtractType.EXACT_EXACT_USER.equals(def.getExtract())) {
			group = orgEngine.getUserGroupService().getGroupByIdOrCode(GroupTypeConstant.JOB.key(), jobCode);
		}else {
			group = buildJobGroup(jobCode, jobName);
		}
		BpmIdentity bpmIdentity = getBpmIdentityConverter().convertGroup(group);
		identityList.add(bpmIdentity);
		return identityList;
	}
	
	private IGroup buildJobGroup(String jobCode, String jobName) {
		OrgJob job = new OrgJob();
		job.setCode(jobCode);
		job.setName(jobName);
		return job;
	}
}
