/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.base.util.time;

import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.time.DateFormatUtil;
import java.text.ParseException;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DateUtil {
    private static final Log logger = LogFactory.getLog(DateUtil.class);

    public static Date asDate(LocalDate localDate) {
        return Date.from(localDate.atStartOfDay().atZone(ZoneId.systemDefault()).toInstant());
    }

    public static Date asDate(LocalDateTime localDateTime) {
        return Date.from(localDateTime.atZone(ZoneId.systemDefault()).toInstant());
    }

    public static LocalDate asLocalDate(Date date) {
        return Instant.ofEpochMilli(date.getTime()).atZone(ZoneId.systemDefault()).toLocalDate();
    }

    public static LocalDateTime asLocalDateTime(Date date) {
        return Instant.ofEpochMilli(date.getTime()).atZone(ZoneId.systemDefault()).toLocalDateTime();
    }

    public static Calendar toCalendar(LocalDateTime date) {
        Calendar c = Calendar.getInstance();
        ZoneId zone = ZoneId.systemDefault();
        Instant instant = date.atZone(zone).toInstant();
        Date udate = Date.from(instant);
        c.setTime(udate);
        return c;
    }

    public static LocalDateTime setAsBegin(LocalDateTime date) {
        LocalDateTime ndate = LocalDateTime.of(date.getYear(), date.getMonthValue(), date.getDayOfMonth(), 0, 0, 0);
        return ndate;
    }

    public static LocalDateTime setAsEnd(LocalDateTime date) {
        LocalDateTime ndate = LocalDateTime.of(date.getYear(), date.getMonthValue(), date.getDayOfMonth(), 23, 59, 59);
        return ndate;
    }

    public static String getCurrentTime(String style) {
        if (StringUtils.isEmpty((String)style)) {
            style = "yyyy-MM-dd HH:mm:ss";
        }
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(style);
        return LocalDateTime.now().format(formatter);
    }

    public static String getCurrentTime() {
        return DateUtil.getCurrentTime("");
    }

    public static LocalDateTime getCurrentDate() {
        return LocalDateTime.now();
    }

    public static long getCurrentTimeInMillis() {
        return Calendar.getInstance().getTimeInMillis();
    }

    public static LocalDateTime[] getDaysBetween(LocalDateTime startDate, LocalDateTime endDate) {
        long day = (startDate.toInstant(ZoneOffset.of("+8")).toEpochMilli() - endDate.toInstant(ZoneOffset.of("+8")).toEpochMilli()) / 86400000L > 0L ? (startDate.toInstant(ZoneOffset.of("+8")).toEpochMilli() - endDate.toInstant(ZoneOffset.of("+8")).toEpochMilli()) / 86400000L : (endDate.toInstant(ZoneOffset.of("+8")).toEpochMilli() - startDate.toInstant(ZoneOffset.of("+8")).toEpochMilli()) / 86400000L;
        LocalDateTime[] dateArr = new LocalDateTime[Integer.valueOf(String.valueOf(day + 1L)).intValue()];
        for (int i = 0; i < dateArr.length; ++i) {
            if (i == 0) {
                dateArr[i] = DateUtil.setAsBegin(startDate);
                continue;
            }
            LocalDateTime nextDay = startDate.plusDays(1L);
            dateArr[i] = startDate = DateUtil.setAsBegin(nextDay);
        }
        return dateArr;
    }

    public static int getDaysOfMonth(int year, int month) {
        Calendar cal = Calendar.getInstance();
        cal.set(1, year);
        cal.set(2, month - 1);
        return cal.getActualMaximum(5);
    }

    public static int getWeekDayOfMonth(int year, int month) {
        Calendar cal = Calendar.getInstance();
        cal.set(year, month - 1, 1);
        return cal.get(7);
    }

    public static boolean compare(String beginDateStr, String endDateStr) {
        try {
            LocalDateTime beginDate = DateFormatUtil.parse(beginDateStr);
            LocalDateTime endDate = DateFormatUtil.parse(endDateStr);
            return beginDate.compareTo(endDate) < 0;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static int compareTo(String beginDateStr, String endDateStr) {
        try {
            LocalDateTime beginDate = DateFormatUtil.parse(beginDateStr);
            LocalDateTime endDate = DateFormatUtil.parse(endDateStr);
            return beginDate.compareTo(endDate);
        }
        catch (Exception e) {
            return -2;
        }
    }

    public static LocalDateTime getDate(int year, int month, int date) {
        return DateUtil.getDate(year, month, date, 0, 0, 0);
    }

    public static LocalDateTime getDate(int year, int month, int date, int hourOfDay, int minute, int second) {
        LocalDateTime dateTime = LocalDateTime.of(year, month, date, hourOfDay, minute, second);
        return dateTime;
    }

    public static long getTime(LocalDateTime startTime, LocalDateTime endTime) {
        ZoneId zone = ZoneId.systemDefault();
        Instant sinstant = startTime.atZone(zone).toInstant();
        Instant einstant = endTime.atZone(zone).toInstant();
        return einstant.toEpochMilli() - sinstant.toEpochMilli();
    }

    public static String getDurationTime(LocalDateTime date) {
        return DateUtil.getDurationTime(date, LocalDateTime.now());
    }

    public static String getDurationTime(LocalDateTime startTime, LocalDateTime endTime) {
        if (startTime == null || endTime == null) {
            return "";
        }
        Long millseconds = DateUtil.getTime(startTime, LocalDateTime.now());
        return DateUtil.getTime(millseconds);
    }

    public static String getTime(Long millseconds) {
        long minuteMillseconds;
        int minutes;
        long hourMillseconds;
        int hours;
        StringBuffer time = new StringBuffer();
        if (millseconds == null) {
            return "";
        }
        int days = (int)millseconds.longValue() / 1000 / 60 / 60 / 24;
        if (days > 0) {
            time.append(days).append("\u5929");
        }
        if ((hours = (int)(hourMillseconds = millseconds - (long)(days * 1000 * 60 * 60 * 24)) / 1000 / 60 / 60) > 0) {
            time.append(hours).append("\u5c0f\u65f6");
        }
        if ((minutes = (int)(minuteMillseconds = millseconds - (long)(days * 1000 * 60 * 60 * 24) - (long)(hours * 1000 * 60 * 60)) / 1000 / 60) > 0) {
            time.append(minutes).append("\u5206\u949f");
        }
        return time.toString();
    }

    public static boolean belongCalendar(LocalDateTime nowTime, LocalDateTime beginTime, LocalDateTime endTime) {
        Calendar date = Calendar.getInstance();
        ZoneId zone = ZoneId.systemDefault();
        Instant nowinstant = nowTime.atZone(zone).toInstant();
        Date nowdate = Date.from(nowinstant);
        date.setTime(nowdate);
        Instant begininstant = beginTime.atZone(zone).toInstant();
        Date begindate = Date.from(begininstant);
        Calendar begin = Calendar.getInstance();
        begin.setTime(begindate);
        Instant endinstant = endTime.atZone(zone).toInstant();
        Date enddate = Date.from(endinstant);
        Calendar end = Calendar.getInstance();
        end.setTime(enddate);
        return !(!date.after(begin) && nowinstant.toEpochMilli() != begininstant.toEpochMilli() || !date.before(end) && nowinstant.toEpochMilli() != endinstant.toEpochMilli());
    }

    public static boolean isDateEquals(LocalDateTime startTime, LocalDateTime endTime) {
        if (BeanUtils.isEmpty(startTime) && BeanUtils.isEmpty(endTime)) {
            return true;
        }
        if (BeanUtils.isNotEmpty(startTime) && BeanUtils.isNotEmpty(endTime)) {
            return startTime.toEpochSecond(ZoneOffset.of("+8")) - endTime.toEpochSecond(ZoneOffset.of("+8")) == 0L;
        }
        return false;
    }

    public static boolean isDateEquals(LocalDateTime startTime, String endTime) {
        if (BeanUtils.isEmpty(startTime) && BeanUtils.isEmpty(endTime)) {
            return true;
        }
        if (BeanUtils.isNotEmpty(startTime) && BeanUtils.isNotEmpty(endTime)) {
            try {
                LocalDateTime date = DateFormatUtil.parse(endTime);
                return startTime.toEpochSecond(ZoneOffset.of("+8")) - date.toEpochSecond(ZoneOffset.of("+8")) < 0L;
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    public static boolean isDateEquals(String startTime, String endTime) {
        if (BeanUtils.isEmpty(startTime) && BeanUtils.isEmpty(endTime)) {
            return true;
        }
        if (BeanUtils.isNotEmpty(startTime) && BeanUtils.isNotEmpty(endTime)) {
            try {
                LocalDateTime sdate = DateFormatUtil.parse(startTime);
                LocalDateTime date = DateFormatUtil.parse(endTime);
                return sdate.toEpochSecond(ZoneOffset.of("+8")) - date.toEpochSecond(ZoneOffset.of("+8")) < 0L;
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    public static boolean isDateLarge(LocalDateTime startTime, LocalDateTime endTime) {
        if (BeanUtils.isEmpty(startTime)) {
            return false;
        }
        if (BeanUtils.isEmpty(endTime)) {
            return true;
        }
        return startTime.toEpochSecond(ZoneOffset.of("+8")) - endTime.toEpochSecond(ZoneOffset.of("+8")) > 0L;
    }

    public static boolean isDateLarge(LocalDateTime startTime, String endTime) {
        if (BeanUtils.isEmpty(startTime)) {
            return false;
        }
        if (BeanUtils.isEmpty(endTime)) {
            return true;
        }
        try {
            LocalDateTime date = DateFormatUtil.parse(endTime);
            return startTime.toEpochSecond(ZoneOffset.of("+8")) - date.toEpochSecond(ZoneOffset.of("+8")) > 0L;
        }
        catch (ParseException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean isDateLarge(String startTime, String endTime) {
        if (BeanUtils.isEmpty(startTime)) {
            return false;
        }
        if (BeanUtils.isEmpty(endTime)) {
            return true;
        }
        try {
            LocalDateTime sdate = DateFormatUtil.parse(startTime);
            LocalDateTime date = DateFormatUtil.parse(endTime);
            return sdate.toEpochSecond(ZoneOffset.of("+8")) - date.toEpochSecond(ZoneOffset.of("+8")) > 0L;
        }
        catch (ParseException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean isDateLittle(LocalDateTime startTime, LocalDateTime endTime) {
        if (BeanUtils.isEmpty(startTime) && BeanUtils.isNotEmpty(endTime)) {
            return true;
        }
        if (BeanUtils.isEmpty(endTime)) {
            return false;
        }
        return startTime.toEpochSecond(ZoneOffset.of("+8")) - endTime.toEpochSecond(ZoneOffset.of("+8")) < 0L;
    }

    public static boolean isDateLittle(LocalDateTime startTime, String endTime) {
        if (BeanUtils.isEmpty(startTime)) {
            return true;
        }
        if (BeanUtils.isEmpty(endTime)) {
            return false;
        }
        try {
            LocalDateTime date = DateFormatUtil.parse(endTime);
            return startTime.toEpochSecond(ZoneOffset.of("+8")) - date.toEpochSecond(ZoneOffset.of("+8")) < 0L;
        }
        catch (ParseException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean isDateLittle(String startTime, String endTime) {
        if (BeanUtils.isEmpty(startTime)) {
            return true;
        }
        if (BeanUtils.isEmpty(endTime)) {
            return false;
        }
        try {
            LocalDateTime sdate = DateFormatUtil.parse(startTime);
            LocalDateTime edate = DateFormatUtil.parse(endTime);
            return sdate.toEpochSecond(ZoneOffset.of("+8")) - edate.toEpochSecond(ZoneOffset.of("+8")) < 0L;
        }
        catch (ParseException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean isDateLargeEquals(LocalDateTime startTime, LocalDateTime endTime) {
        if (BeanUtils.isEmpty(startTime)) {
            return false;
        }
        if (BeanUtils.isEmpty(endTime)) {
            return true;
        }
        return startTime.toEpochSecond(ZoneOffset.of("+8")) - endTime.toEpochSecond(ZoneOffset.of("+8")) >= 0L;
    }

    public static boolean isDateLargeEquals(LocalDateTime startTime, String endTime) {
        if (BeanUtils.isEmpty(startTime)) {
            return false;
        }
        if (BeanUtils.isEmpty(endTime)) {
            return true;
        }
        try {
            LocalDateTime date = DateFormatUtil.parse(endTime);
            return startTime.toEpochSecond(ZoneOffset.of("+8")) - date.toEpochSecond(ZoneOffset.of("+8")) >= 0L;
        }
        catch (ParseException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean isDateLargeEquals(String startTime, String endTime) {
        if (BeanUtils.isEmpty(startTime)) {
            return false;
        }
        if (BeanUtils.isEmpty(endTime)) {
            return true;
        }
        try {
            LocalDateTime sdate = DateFormatUtil.parse(startTime);
            LocalDateTime date = DateFormatUtil.parse(endTime);
            return sdate.toEpochSecond(ZoneOffset.of("+8")) - date.toEpochSecond(ZoneOffset.of("+8")) >= 0L;
        }
        catch (ParseException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean isDateLittleEquals(LocalDateTime startTime, LocalDateTime endTime) {
        if (BeanUtils.isEmpty(startTime) && BeanUtils.isNotEmpty(endTime)) {
            return true;
        }
        if (BeanUtils.isEmpty(endTime)) {
            return false;
        }
        return startTime.toEpochSecond(ZoneOffset.of("+8")) - endTime.toEpochSecond(ZoneOffset.of("+8")) <= 0L;
    }

    public static boolean isDateLittleEquals(LocalDateTime startTime, String endTime) {
        if (BeanUtils.isEmpty(startTime)) {
            return true;
        }
        if (BeanUtils.isEmpty(endTime)) {
            return false;
        }
        try {
            LocalDateTime date = DateFormatUtil.parse(endTime);
            return startTime.toEpochSecond(ZoneOffset.of("+8")) - date.toEpochSecond(ZoneOffset.of("+8")) <= 0L;
        }
        catch (ParseException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean isDateLittleEquals(String startTime, String endTime) {
        if (BeanUtils.isEmpty(startTime)) {
            return true;
        }
        if (BeanUtils.isEmpty(endTime)) {
            return false;
        }
        try {
            LocalDateTime sdate = DateFormatUtil.parse(startTime);
            LocalDateTime edate = DateFormatUtil.parse(endTime);
            return sdate.toEpochSecond(ZoneOffset.of("+8")) - edate.toEpochSecond(ZoneOffset.of("+8")) <= 0L;
        }
        catch (ParseException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean isDateBelongTo(String time, String boundary) {
        if (BeanUtils.isEmpty(time) || BeanUtils.isEmpty(boundary)) {
            return false;
        }
        try {
            LocalDateTime date = DateFormatUtil.parse(time);
            String[] boundaryArr = boundary.split(",");
            if (boundaryArr.length != 2) {
                return false;
            }
            LocalDateTime sdate = DateFormatUtil.parse(boundaryArr[0]);
            LocalDateTime edate = DateFormatUtil.parse(boundaryArr[1]);
            return date.toEpochSecond(ZoneOffset.of("+8")) >= sdate.toEpochSecond(ZoneOffset.of("+8")) && date.toEpochSecond(ZoneOffset.of("+8")) <= edate.toEpochSecond(ZoneOffset.of("+8"));
        }
        catch (ParseException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean isRqSjFormat(String mes) {
        String format = "([0-9]{4})-(0[1-9]|1[012])-(0[1-9]|[12][0-9]|3[01]) ([01][0-9]|2[0-3]):[0-5][0-9]:[0-5][0-9]";
        Pattern pattern = Pattern.compile(format);
        Matcher matcher = pattern.matcher(mes);
        if (matcher.matches()) {
            pattern = Pattern.compile("(\\d{4})(\\d{2})(\\d{2}).*");
            matcher = pattern.matcher(mes);
            if (matcher.matches()) {
                int y = Integer.valueOf(matcher.group(1));
                int m = Integer.valueOf(matcher.group(2));
                int d = Integer.valueOf(matcher.group(3));
                if (d > 28) {
                    Calendar c = Calendar.getInstance();
                    c.set(y, m - 1, 1);
                    int lastDay = c.getActualMaximum(5);
                    return lastDay >= d;
                }
            }
            return true;
        }
        return false;
    }

    public static boolean isRqFormat(String mes) {
        String format = "([0-9]{4})-(0[1-9]|1[012])-(0[1-9]|[12][0-9]|3[01])";
        Pattern pattern = Pattern.compile(format);
        Matcher matcher = pattern.matcher(mes);
        if (matcher.matches()) {
            pattern = Pattern.compile("(\\d{4})(\\d{2})(\\d{2}).*");
            matcher = pattern.matcher(mes);
            if (matcher.matches()) {
                int y = Integer.valueOf(matcher.group(1));
                int m = Integer.valueOf(matcher.group(2));
                int d = Integer.valueOf(matcher.group(3));
                if (d > 28) {
                    Calendar c = Calendar.getInstance();
                    c.set(y, m - 1, 1);
                    int lastDay = c.getActualMaximum(5);
                    return lastDay >= d;
                }
            }
            return true;
        }
        return false;
    }

    public static void main(String[] args) {
        boolean rqSjFormat = DateUtil.isRqSjFormat("2020-02-02 11:30:00");
        System.out.println(rqSjFormat);
    }
}

