package com.artfess.base.valid;

import lombok.SneakyThrows;
import org.springframework.beans.factory.annotation.Autowired;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;

/**
 * 注解接口实现
 */
public class FieldRepeatClass implements ConstraintValidator<FieldRepeat, Object> {

    @Autowired
    FieldRepeatUtils fieldRepeatUtils;

    private String [] fileds;
    private String message;
    private Class[] groups;

    @Override
    public void initialize(FieldRepeat validator) {
        this.fileds = validator.fields();
        this.message = validator.message();
        this.groups = validator.groups();
    }

    @SneakyThrows
    @Override
    public boolean isValid(Object o, ConstraintValidatorContext constraintValidatorContext) {
        Class[] groups = this.groups;
        return fieldRepeatUtils.fieldRepeat(fileds,message,o);
    }
}
