package com.artfess.manage.material.controller;


import cn.hutool.poi.excel.ExcelReader;
import cn.hutool.poi.excel.ExcelUtil;
import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.controller.BaseController;
import com.artfess.base.enums.ResponseErrorEnums;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.util.ReflectUtil;
import com.artfess.base.valid.AddGroup;
import com.artfess.base.valid.UpdateGroup;
import com.artfess.manage.material.manager.CmgtMaterialCustomManager;
import com.artfess.manage.material.manager.CmgtMaterialWarehouseInoutDetailManager;
import com.artfess.manage.material.manager.CmgtMaterialWarehouseInoutManager;
import com.artfess.manage.material.model.CmgtMaterialCustom;
import com.artfess.manage.material.model.CmgtMaterialWarehouseInout;
import com.artfess.manage.material.model.CmgtMaterialWarehouseInoutDetail;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

import java.io.IOException;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 物资入库单 前端控制器
 *
 * @author wujl
 * @company 阿特菲斯信息技术有限公司
 * @since 2022-07-25
 */
@Slf4j
@RestController
@RequestMapping("/manager/material/into/warehouse/")
@ApiGroup(group = {ApiGroupConsts.MANAGER_BIZ})
public class CmgtMaterialWarehouseInController extends BaseController<CmgtMaterialWarehouseInoutManager, CmgtMaterialWarehouseInout> {


    @Autowired
    private CmgtMaterialWarehouseInoutDetailManager warehouseInoutDetailManager;

    @Autowired
    private CmgtMaterialWarehouseInoutManager warehouseInoutManager;

    @Autowired
    private CmgtMaterialCustomManager cmgtMaterialCustomManager;


    @PostMapping("/add")
    @ApiOperation("添加实体的接口")
    public CommonResult<String> create(@ApiParam(name = "model", value = "实体信息") @RequestBody @Validated({AddGroup.class}) CmgtMaterialWarehouseInout t) {
        boolean result = warehouseInoutManager.createInout(t);
        if (!result) {
            return new CommonResult<>(ResponseErrorEnums.FAIL_OPTION, null);
        }
        return new CommonResult<>();
    }

    @PostMapping("/getDetailList")
    @ApiOperation("获取入库单下所有物资明细")
    public CommonResult<String> getDetailList(@RequestBody String wid) {
        List<CmgtMaterialWarehouseInoutDetail> list = warehouseInoutDetailManager.findMaterialDetailById(wid);
        return CommonResult.success(list, null);
    }

    @PutMapping("/update")
    @ApiOperation("更新实体")
    public CommonResult<String> updateById(@ApiParam(name = "model", value = "实体信息") @RequestBody @Validated({UpdateGroup.class}) CmgtMaterialWarehouseInout t) {

        boolean result = this.warehouseInoutManager.updateInout(t); //baseService.updateById(t);

        if (!result) {
            return new CommonResult<>(ResponseErrorEnums.FAIL_OPTION, "更新实体失败");
        }
        return new CommonResult<>();
    }


    @DeleteMapping("/delete")
    @ApiOperation("根据id集合批量删除")
    public CommonResult<String> deleteByIds(@ApiParam(name = "ids", value = "实体集合") @RequestParam String... ids) {
        boolean result = this.warehouseInoutManager.removeInoutById(ids);
        if (!result) {
            return new CommonResult<>(ResponseErrorEnums.FAIL_OPTION, "删除实体失败");
        }
        return new CommonResult<>();
    }

    @PostMapping("/allCustom")
    @ApiOperation("获取所有供应商")
    public List<CmgtMaterialCustom> findAllCmgtMaterialCustom() {
        QueryFilter<CmgtMaterialCustom> queryFilter = QueryFilter.build();
        List<CmgtMaterialCustom> list = cmgtMaterialCustomManager.queryNoPage(queryFilter);
        list.forEach(l -> {
            System.out.println(l.toString());
        });
        return list;
    }


    @PostMapping(value = "/importdata")
    @ApiOperation("导入数据")
    public ResponseEntity<Object> upload(@RequestParam("file") MultipartFile file) throws IOException {

        ExcelReader reader = ExcelUtil.getReader(file.getInputStream(), 0);

        Map<String, String> alias = new HashMap<String, String>();
        List<Field> fields = ReflectUtil.getAllField(CmgtMaterialWarehouseInoutDetail.class);
        fields.addAll(ReflectUtil.getAllField(CmgtMaterialWarehouseInout.class));
        for (Field field : fields) {
            ApiModelProperty apiModelProperty = field.getAnnotation(ApiModelProperty.class);
            if (apiModelProperty != null) {
                alias.put(apiModelProperty.value(), field.getName());
            }
        }

        //reader.setHeaderAlias()

        //alias.put("物资名称","materialName");
        //Subnonroadvehbasicinfo subnonroadvehbasicinfoEntity = JSONUtil.toBean(subroadvehbasicinfo, .class);
        reader.setHeaderAlias(alias);

        System.out.println("==========alias=========" + alias);

        List<Map<String, Object>> rowsList = reader.readAll();

        warehouseInoutManager.importRKData(rowsList);

        System.out.println("==========rowsList=========" + rowsList);
        Map<String, Object> ro = new HashMap<String, Object>();
        ro.put("realName", file.getName());
        //ro.put("type", type);
        ro.put("msg", "导入完成");
        return new ResponseEntity<>(ro, HttpStatus.OK);
    }


}
