package com.artfess.manage.material.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.controller.BaseController;
import com.artfess.base.enums.ResponseErrorEnums;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.manage.material.dao.CmgtMaterialQuantityDao;
import com.artfess.manage.material.manager.CmgtMaterialQuantityManage;
import com.artfess.manage.material.model.CmgtMaterialQuantity;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

/**
 * @Description: 物资库存
 * @ClassName: CmgtMaterialAccoutController
 * @Author: wjl
 * @Date: 2022/8/3 11:07
 * @Version: 1.0
 */
@Slf4j
@RestController
@Api(tags = "物资管理-物资库存")
@RequestMapping("/manager/material/quantity/")
@ApiGroup(group = {ApiGroupConsts.MANAGER_BIZ})
public class CmgtMaterialQuantityController extends BaseController<CmgtMaterialQuantityManage, CmgtMaterialQuantity> {

    @Resource
    private CmgtMaterialQuantityDao cmgtMaterialQuantityDao;

    @Resource
    private CmgtMaterialQuantityManage cmgtMaterialQuantityManage;


    @PostMapping(value="/findAllQuantity", produces={"application/json; charset=utf-8" })
    @ApiOperation("获取物资库存信息")
    public List<Map<String,Object>> findAllUnit(@RequestBody String quantityId){
        List<Map<String,Object>> list = cmgtMaterialQuantityDao.findDetailByquantityId(quantityId);
        return list;
    }

    @PostMapping(value="/pageQuery", produces={"application/json; charset=utf-8" })
    @ApiOperation("分页查询")
    public PageList<CmgtMaterialQuantity> pageQuery(@ApiParam(name="queryFilter", value="分页查询信息") @RequestBody QueryFilter<CmgtMaterialQuantity> queryFilter) {
        return cmgtMaterialQuantityManage.pageQuery(queryFilter);
    }

    @Override
    @DeleteMapping("/delete")
    @ApiOperation("根据id集合批量删除")
    public CommonResult<String> deleteByIds(@ApiParam(name = "ids", value = "实体集合") @RequestParam String... ids) {
        boolean result =  cmgtMaterialQuantityManage.delete(Arrays.asList(ids));
        if (!result) {
            return new CommonResult<>(ResponseErrorEnums.FAIL_OPTION, "删除实体失败");
        }
        return new CommonResult<>();
    }

}
