package com.artfess.manage.safty.manager.dto;

import com.artfess.manage.base.ManageBaseModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;


/**
 * cmgt_safty_training_record
 *
 * @company 阿特菲斯信息技术有限公司
 * @author yuanhc
 * @since 2022-09-03
 */
@Data
@ApiModel(value="CmgtSaftyTrainingRecordDto", description="安全培训记录DTO对象")
public class CmgtSaftyTrainingRecordDto extends ManageBaseModel<CmgtSaftyTrainingRecordDto> {


    /** 培训时间 */
    @ApiModelProperty(value = "培训时间")
    private LocalDateTime trainingDate;




    /** 主键_ID */
    @ApiModelProperty(value = "主键_ID")
    private String id;




    /** 培训项目 */
    @ApiModelProperty(value = "培训项目")
    private String trainingProjectId;

    private Object trainingProjectIdName;



    /** 培训讲师 */
    @ApiModelProperty(value = "培训讲师")
    private String teacher;

    private Object teacherName;



    /** 关联计划 */
    @ApiModelProperty(value = "关联计划")
    private String trainingPlanId;

    private Object trainingPlanIdName;



    /** 培训对象 */
    @ApiModelProperty(value = "培训对象")
    private String trainee;

    public void setTraineeValues(String[] t) {
        if (t != null) {
            this.trainee= Arrays.asList(t).stream().collect(Collectors.joining(","));
        } else {
            this.trainee= null;
        }
    }

    public String[] getTraineeValues() {
        if (this.trainee != null) {
            return this.trainee.split(",");
        } else {
            return new String[]{};
        }
    }



    /** 培训地点 */
    @ApiModelProperty(value = "培训地点")
    private String location;




    /** 培训内容 */
    @ApiModelProperty(value = "培训内容")
    private String content;




    /** 培训总结 */
    @ApiModelProperty(value = "培训总结")
    private String summary;




    /** 排序 */
    @ApiModelProperty(value = "排序")
    private Integer sn;




    /** 备注 */
    @ApiModelProperty(value = "备注")
    private String memo;




     /** 安全培训记录人员明细明细 */
    @ApiModelProperty(value = "安全培训记录人员明细明细")
    private List<CmgtSaftyTrainingRecordDetailDto> cmgtSaftyTrainingRecordDetailList;

    private String createByName;

}
