package com.artfess.manage.dwd.model;

import com.artfess.base.entity.BaseModel;
import com.artfess.base.valid.AddGroup;
import com.artfess.base.valid.UpdateGroup;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;
import javax.validation.constraints.Null;


/**
 * dwd_sj_weather_pheno_mi
 *
 * @company 阿特菲斯信息技术有限公司
 * @author yuanhc
 * @since 2022-09-21
 */
@Data
@ApiModel(value="DwdSjWeatherPhenoMi对象", description="来自互联网心知天气的天气现象")
//@FieldRepeat(fields = {"code","name"},message = "名称不能重复，请重新输入",groups = {AddGroup.class, UpdateGroup.class})
public class DwdSjWeatherPhenoMi extends BaseModel<DwdSjWeatherPhenoMi> {


    /** id */
    @NotNull(message = "修改必须指定id",groups = {UpdateGroup.class})
    @Null(message = "新增不能指定id",groups = {AddGroup.class})
    @ApiModelProperty(value = "主键_ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    /** 地区 */
    @ApiModelProperty(value = "地区")
    @TableField("name")
    private String name;

    /** 路径 */
    @ApiModelProperty(value = "路径")
    @TableField("path")
    private String path;

    /** 时区 */
    @ApiModelProperty(value = "时区")
    @TableField("timezone")
    private String timezone;

    /** 时区偏移 */
    @ApiModelProperty(value = "时区偏移")
    @TableField("timezone_offset")
    private String timezoneOffset;

    /** 天气现象 */
    @ApiModelProperty(value = "天气现象")
    @TableField("text")
    private String text;

    /** 天气现象编码 */
    @ApiModelProperty(value = "天气现象编码")
    @TableField("code")
    private String code;

    /** 温度 */
    @ApiModelProperty(value = "温度")
    @TableField("temperature")
    private String temperature;

    /** 来源更新时间 */
    @ApiModelProperty(value = "来源更新时间")
    @TableField("last_update")
    private String lastUpdate;

    /** 中台插入时间 */
    @ApiModelProperty(value = "中台插入时间")
    @TableField("insert_time")
    private String insertTime;


    /** 接收ID */
    @ApiModelProperty(value = "接收ID")
    @TableField("area_id")
    private String areaId;



    /** 中台插入时间 */
    @ApiModelProperty(value = "中台插入时间")
    @TableField("update_time")
    private String updateTime;


}
