package com.artfess.manage.dwd.manager;


import com.artfess.base.manager.BaseManager;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.manage.dwd.manager.dto.DwdSjCqEventDto;
import com.artfess.manage.dwd.model.DwdSjCqEvent;

import java.util.List;

/**
 * 数据中台-事件表 服务类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author yuanhc
 * @since 2022-10-08
 */
public interface DwdSjCqEventManager extends BaseManager<DwdSjCqEvent> {

    /**
     * 条件分页查询
     * @param queryFilter
     * @return
     */
    PageList<DwdSjCqEventDto> pageQuery(QueryFilter<DwdSjCqEvent> queryFilter);

    /**
     * 新增
     * @param t
     * @return
     */
    String createInfo(DwdSjCqEvent t);

    /**
     * 更新
     * @param t
     * @return
     */
    String updateInfo(DwdSjCqEvent t);

    /**
     * 删除
     * @param t
     */
    void deleteInfo(DwdSjCqEvent t);


    String create(DwdSjCqEventDto dto);

    String update(DwdSjCqEventDto dto);

    boolean delete(List<String> ids);



}
