package com.artfess.manage.duty.manager.impl;


import cn.hutool.core.util.RandomUtil;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.manage.base.ManageCommonService;
import com.artfess.manage.duty.dao.CmgtDutyVehicleDao;
import com.artfess.manage.duty.dao.CmgtDutyVehicleGpsinfoDao;
import com.artfess.manage.duty.manager.CmgtDutyVehicleGpsinfoManager;
import com.artfess.manage.duty.manager.dto.CmgtDutyVehicleGpsinfoDto;
import com.artfess.manage.duty.manager.mapper.CmgtDutyVehicleGpsinfoDtoMapper;
import com.artfess.manage.duty.model.CmgtDutyVehicle;
import com.artfess.manage.duty.model.CmgtDutyVehicleGpsinfo;
import com.artfess.manage.duty.model.TeamMemberStatusEnum;
import com.artfess.manage.utils.GeoUtils;
import com.artfess.uc.dao.UserDao;
import com.artfess.uc.exception.BadRequestException;
import com.artfess.uc.model.User;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;
import java.util.stream.Collectors;


/**
 * 车辆GPS信息 服务实现类
 *
 * @author yuanhc
 * @company 阿特菲斯信息技术有限公司
 * @since 2022-09-12
 */
@Service
public class CmgtDutyVehicleGpsinfoManagerImpl extends BaseManagerImpl<CmgtDutyVehicleGpsinfoDao, CmgtDutyVehicleGpsinfo> implements CmgtDutyVehicleGpsinfoManager {

    @Resource
    private UserDao userDao;

    @Resource
    private CmgtDutyVehicleGpsinfoDao cmgtDutyVehicleGpsinfoDao;


    @Resource
    private CmgtDutyVehicleDao cmgtDutyVehicleDao;

    @Resource
    private CmgtDutyVehicleGpsinfoDtoMapper cmgtDutyVehicleGpsinfoDtoMapper;

    @Resource
    private ManageCommonService manageCommonService;


    @Override
    public PageList<CmgtDutyVehicleGpsinfoDto> pageQuery(QueryFilter<CmgtDutyVehicleGpsinfo> queryFilter) {
        PageList<CmgtDutyVehicleGpsinfo> result = query(queryFilter);
        PageList<CmgtDutyVehicleGpsinfoDto> r = new PageList<CmgtDutyVehicleGpsinfoDto>(
                result.getRows().stream().map(e -> {
                            CmgtDutyVehicleGpsinfoDto t = cmgtDutyVehicleGpsinfoDtoMapper.toDto(e);
                            t.setVehicleIdName(manageCommonService.getfindSelectOptionsLabel("cmgtDutySelectOptions.getCmgtDutyVehicles", "value", "label", t.getVehicleId()));


                            if (e.getCreateBy() != null) {
                                User user = userDao.selectById(e.getCreateBy());
                                if (user != null) {
                                    t.setCreateByName(user.getFullname());
                                }
                            }

                            return t;
                        }
                ).collect(Collectors.toList())
        );
        r.setTotal(result.getTotal());
        r.setPage(result.getPage());
        r.setPageSize(result.getPageSize());
        return r;
    }

    @Override
    public String createInfo(CmgtDutyVehicleGpsinfo t) {
        if (t.getVehicleId() == null) {
            throw new BadRequestException("所属车辆不能为空");
        }
        int i = this.baseMapper.insert(t);
        CmgtDutyVehicle cmgtDutyVehicle = cmgtDutyVehicleDao.selectById(t.getVehicleId());
        cmgtDutyVehicle.setLocation(t.getLatitude() + "," + t.getLongitude());
        cmgtDutyVehicle.setReceiveTime(t.getReceiveTime());

        if (cmgtDutyVehicle.getArea() != null
                && !GeoUtils.pointInPolygon(cmgtDutyVehicle.getLocation(), cmgtDutyVehicle.getArea())) {
            cmgtDutyVehicle.setStatus(TeamMemberStatusEnum.CROSSING.name());
        } else {
            cmgtDutyVehicle.setStatus(TeamMemberStatusEnum.ONLINE.name());
        }
        cmgtDutyVehicleDao.updateById(cmgtDutyVehicle);
        if (i > 0) {
            return t.getId();
        }
        return null;
    }

    @Override
    public String updateInfo(CmgtDutyVehicleGpsinfo t) {
        if (t.getVehicleId() == null) {
            throw new BadRequestException("所属车辆不能为空");
        }
        CmgtDutyVehicle cmgtDutyVehicle = cmgtDutyVehicleDao.selectById(t.getVehicleId());
        cmgtDutyVehicle.setLocation(t.getLatitude() + "," + t.getLongitude());
        cmgtDutyVehicle.setReceiveTime(t.getReceiveTime());
        cmgtDutyVehicleDao.updateById(cmgtDutyVehicle);

        this.baseMapper.updateById(t);
        return t.getId();
    }

    @Transactional
    public void createSumilatedGpsData() {
        List<CmgtDutyVehicle> vehicles = cmgtDutyVehicleDao.selectList(null);
        int idx = RandomUtil.randomInt(0, vehicles.size());
        CmgtDutyVehicleGpsinfo gpsinfo = new CmgtDutyVehicleGpsinfo();
        gpsinfo.setVehicleId(vehicles.get(idx).getId());
        gpsinfo.setReceiveTime(LocalDateTime.now());
        gpsinfo.setMemo("随机生成模拟数据");
        gpsinfo.setLatitude(RandomUtil.randomBigDecimal(BigDecimal.valueOf(106.537288), BigDecimal.valueOf(106.55633)) + "");
        gpsinfo.setLongitude(RandomUtil.randomBigDecimal(BigDecimal.valueOf(29.606626), BigDecimal.valueOf(29.615619)) + "");
        this.createInfo(gpsinfo);
    }

    @Override
    public void deleteInfo(CmgtDutyVehicleGpsinfo t) {
        this.baseMapper.deleteById(t.getId());
    }


    public String create(CmgtDutyVehicleGpsinfoDto dto) {
        CmgtDutyVehicleGpsinfo t = cmgtDutyVehicleGpsinfoDtoMapper.toEntity(dto);
        int i = this.baseMapper.insert(t);
        if (i > 0) {
            return t.getId();
        }
        return null;
    }


    public String update(CmgtDutyVehicleGpsinfoDto dto) {
        CmgtDutyVehicleGpsinfo t = cmgtDutyVehicleGpsinfoDtoMapper.toEntity(dto);
        this.baseMapper.updateById(t);


        return t.getId();
    }

    public boolean delete(List<String> ids) {
        for (String id : ids) {

            int count = this.baseMapper.deleteById(id);
            if (count == 0) {
                return false;
            }
        }
        return true;
    }


}
