package com.artfess.manage.base.model;

import com.artfess.base.valid.AddGroup;
import com.artfess.base.valid.UpdateGroup;
import com.artfess.manage.base.ManageBaseModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Null;
import java.time.LocalDateTime;

/**
 * cmgt_base_position
 *
 * @company 阿特菲斯信息技术有限公司
 * @author fanxm
 * @since 2022-09-24
 */
@Data
@ApiModel(value="CmgtBasePosition对象", description="基础位置信息")
//@FieldRepeat(fields = {"code","name"},message = "名称不能重复，请重新输入",groups = {AddGroup.class, UpdateGroup.class})
public class CmgtBasePosition extends ManageBaseModel<CmgtBasePosition> {


    /** 主键_ID */
    @NotNull(message = "修改必须指定id",groups = {UpdateGroup.class})
    @Null(message = "新增不能指定id",groups = {AddGroup.class})
    @ApiModelProperty(value = "主键_ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    /** 编号 */
    @ApiModelProperty(value = "编号")
    @TableField("code_")
    private String code;

    /** 名称 */
    @ApiModelProperty(value = "名称")
    @TableField("name_")
    @NotBlank(message = "名称",groups = {AddGroup.class,UpdateGroup.class})
    private String name;

    /** 别名 */
    @ApiModelProperty(value = "别名")
    @TableField("alias_")
    private String alias;

    /**  类型 */
    @ApiModelProperty(value = " 类型")
    @TableField("dtype_")
    @NotBlank(message = " 类型",groups = {AddGroup.class,UpdateGroup.class})
    private String dtype;

    /** 关联实体 */
    @ApiModelProperty(value = "关联实体")
    @TableField("rid_")
    private String rid;

    /** 纬度 */
    @ApiModelProperty(value = "纬度")
    @TableField("latitude_")
    private String latitude;

    /** 经度 */
    @ApiModelProperty(value = "经度")
    @TableField("longitude_")
    private String longitude;

    /** 定位信息 */
    @ApiModelProperty(value = "定位信息")
    @TableField("location_")
    private String location;

    /** 排序 */
    @ApiModelProperty(value = "排序")
    @TableField("sn_")
    private Integer sn;

    /** 接收时间 */
    @ApiModelProperty(value = "接收时间")
    @TableField("receive_time_")
    private LocalDateTime receiveTime;

    /** 备注 */
    @ApiModelProperty(value = "备注")
    @TableField("memo_")
    private String memo;

}
