/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.manage.material.controller;

import cn.hutool.poi.excel.ExcelReader;
import cn.hutool.poi.excel.ExcelUtil;
import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.controller.BaseController;
import com.artfess.base.enums.ResponseErrorEnums;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.util.ReflectUtil;
import com.artfess.base.valid.AddGroup;
import com.artfess.base.valid.UpdateGroup;
import com.artfess.manage.material.manager.CmgtMaterialCustomManager;
import com.artfess.manage.material.manager.CmgtMaterialWarehouseInoutDetailManager;
import com.artfess.manage.material.manager.CmgtMaterialWarehouseInoutManager;
import com.artfess.manage.material.model.CmgtMaterialCustom;
import com.artfess.manage.material.model.CmgtMaterialWarehouseInout;
import com.artfess.manage.material.model.CmgtMaterialWarehouseInoutDetail;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/manager/material/into/warehouse/"})
@ApiGroup(group={"manager_biz"})
public class CmgtMaterialWarehouseInController
extends BaseController<CmgtMaterialWarehouseInoutManager, CmgtMaterialWarehouseInout> {
    private static final Logger log = LoggerFactory.getLogger(CmgtMaterialWarehouseInController.class);
    @Autowired
    private CmgtMaterialWarehouseInoutDetailManager warehouseInoutDetailManager;
    @Autowired
    private CmgtMaterialWarehouseInoutManager warehouseInoutManager;
    @Autowired
    private CmgtMaterialCustomManager cmgtMaterialCustomManager;

    @PostMapping(value={"/add"})
    @ApiOperation(value="\u6dfb\u52a0\u5b9e\u4f53\u7684\u63a5\u53e3")
    public CommonResult<String> create(@ApiParam(name="model", value="\u5b9e\u4f53\u4fe1\u606f") @RequestBody @Validated(value={AddGroup.class}) CmgtMaterialWarehouseInout t) {
        boolean result = this.warehouseInoutManager.createInout(t);
        if (!result) {
            return new CommonResult(ResponseErrorEnums.FAIL_OPTION, null);
        }
        return new CommonResult();
    }

    @PostMapping(value={"/getDetailList"})
    @ApiOperation(value="\u83b7\u53d6\u5165\u5e93\u5355\u4e0b\u6240\u6709\u7269\u8d44\u660e\u7ec6")
    public CommonResult<String> getDetailList(@RequestBody String wid) {
        List<CmgtMaterialWarehouseInoutDetail> list = this.warehouseInoutDetailManager.findMaterialDetailById(wid);
        return CommonResult.success(list, null);
    }

    @PutMapping(value={"/update"})
    @ApiOperation(value="\u66f4\u65b0\u5b9e\u4f53")
    public CommonResult<String> updateById(@ApiParam(name="model", value="\u5b9e\u4f53\u4fe1\u606f") @RequestBody @Validated(value={UpdateGroup.class}) CmgtMaterialWarehouseInout t) {
        boolean result = this.warehouseInoutManager.updateInout(t);
        if (!result) {
            return new CommonResult(ResponseErrorEnums.FAIL_OPTION, (Object)"\u66f4\u65b0\u5b9e\u4f53\u5931\u8d25");
        }
        return new CommonResult();
    }

    @DeleteMapping(value={"/delete"})
    @ApiOperation(value="\u6839\u636eid\u96c6\u5408\u6279\u91cf\u5220\u9664")
    public CommonResult<String> deleteByIds(String ... ids) {
        boolean result = this.warehouseInoutManager.removeInoutById(ids);
        if (!result) {
            return new CommonResult(ResponseErrorEnums.FAIL_OPTION, (Object)"\u5220\u9664\u5b9e\u4f53\u5931\u8d25");
        }
        return new CommonResult();
    }

    @PostMapping(value={"/allCustom"})
    @ApiOperation(value="\u83b7\u53d6\u6240\u6709\u4f9b\u5e94\u5546")
    public List<CmgtMaterialCustom> findAllCmgtMaterialCustom() {
        QueryFilter queryFilter = QueryFilter.build();
        List list = this.cmgtMaterialCustomManager.queryNoPage(queryFilter);
        list.forEach(l -> System.out.println(l.toString()));
        return list;
    }

    @PostMapping(value={"/importdata"})
    @ApiOperation(value="\u5bfc\u5165\u6570\u636e")
    public ResponseEntity<Object> upload(@RequestParam(value="file") MultipartFile file) throws IOException {
        ExcelReader reader = ExcelUtil.getReader((InputStream)file.getInputStream(), (int)0);
        HashMap<String, String> alias = new HashMap<String, String>();
        List fields = ReflectUtil.getAllField(CmgtMaterialWarehouseInoutDetail.class);
        fields.addAll(ReflectUtil.getAllField(CmgtMaterialWarehouseInout.class));
        for (Field field : fields) {
            ApiModelProperty apiModelProperty = field.getAnnotation(ApiModelProperty.class);
            if (apiModelProperty == null) continue;
            alias.put(apiModelProperty.value(), field.getName());
        }
        reader.setHeaderAlias(alias);
        System.out.println("==========alias=========" + alias);
        List rowsList = reader.readAll();
        this.warehouseInoutManager.importRKData(rowsList);
        System.out.println("==========rowsList=========" + rowsList);
        HashMap<String, String> ro = new HashMap<String, String>();
        ro.put("realName", file.getName());
        ro.put("msg", "\u5bfc\u5165\u5b8c\u6210");
        return new ResponseEntity(ro, HttpStatus.OK);
    }
}

