package com.artfess.device.monitor.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.controller.BaseController;
import com.artfess.device.monitor.manager.DeviceDataSignboaerdManager;
import com.artfess.device.monitor.model.DeviceDataSignboaerd;
import io.swagger.annotations.Api;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 实时监控-标识牌监控（DEVICE_DATA_SIGNBOAERD） 前端控制器
 *
 * @company 阿特菲斯信息技术有限公司
 * @author chens
 * @since 2022-07-26
 */
@Slf4j
@RestController
@Api(tags = "设施数据-标识牌监控数据")
@RequestMapping("/data/signboaerd/")
@ApiGroup(group = {ApiGroupConsts.DEVICE_BIZ})
public class DeviceDataSignboaerdController extends BaseController<DeviceDataSignboaerdManager, DeviceDataSignboaerd> {

}
