package com.artfess.device.base.model;

import com.artfess.base.entity.BaseModel;
import com.artfess.base.valid.AddGroup;
import com.artfess.base.valid.UpdateGroup;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.FieldStrategy;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;
import javax.validation.constraints.Null;
import java.time.LocalDateTime;

/**
 * 视频点位扩展信息表与视频点位信息一一对应（DEVICE_VIDEO_POINT_EXTEND）
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2022-08-19
 */
@Data
@ApiModel(value="DeviceVideoPointExtend对象", description="视频点位扩展信息表与视频点位信息一一对应（DEVICE_VIDEO_POINT_EXTEND）")
public class DeviceVideoPointExtend extends BaseModel<DeviceVideoPointExtend> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "id_", type = IdType.ASSIGN_ID)
    private String id;

    @NotNull(message = "请填写视频点编号",groups = {UpdateGroup.class})
    @ApiModelProperty(value = "视频点编号（或视频平台点位编号）")
    @TableField("code_")
    private String code;

    @ApiModelProperty(value = "摄像头类型【字典】（1：枪机，2：球机）")
    @TableField("type_")
    private String type;

    @ApiModelProperty(value = "视频点位图标")
    @TableField("icon_")
    private String icon;

    @ApiModelProperty(value = "GIS区域标识")
    @TableField("gis_area_")
    private String gisArea;

    @ApiModelProperty(value = "所属行政区划")
    @TableField("addvcd_")
    private String addvcd;

    @ApiModelProperty(value = "所属区域（关联区域表ID）")
    @TableField("area_id_")
    private String areaId;

    @ApiModelProperty(value = "安装地点类型【字典】（1：室外，2：室内）")
    @TableField("address_type_")
    private String addressType;

    @ApiModelProperty(value = "安装楼层【字典】（-2：负二楼，-1：负一楼，1：一楼、2：二楼、3：三楼）")
    @TableField("floor_")
    private Integer floor;

    @ApiModelProperty(value = "设备供应商")
    @TableField("supplier_company_id_")
    private String supplierCompanyId;

    @ApiModelProperty(value = "设备维护单位")
    @TableField("repair_company_id_")
    private String repairCompanyId;

    @ApiModelProperty(value = "设备维护人员")
    @TableField("repair_user_id_")
    private String repairUserId;

    @ApiModelProperty(value = "设备管理单位")
    @TableField("manager_company_id_")
    private String managerCompanyId;

    @ApiModelProperty(value = "设备管理人员")
    @TableField("manager_user_id_")
    private String managerUserId;

    @JsonIgnore
    @ApiModelProperty(value = "数据时间戳", hidden=true, accessMode= ApiModelProperty.AccessMode.READ_ONLY)
    @TableField(updateStrategy= FieldStrategy.NOT_NULL,value="last_time_", fill= FieldFill.INSERT_UPDATE, select=false)
    private LocalDateTime lastTime;

    @TableField(exist = false)
    @ApiModelProperty(value = "所属区域编码")
    private String areaCode;

    @TableField(exist = false)
    @ApiModelProperty(value = "所属区域名称")
    private String areaName;
}
