package com.artfess.device.base.manager;

import com.artfess.base.manager.BaseManager;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.device.base.model.DeviceBaseUser;

import java.util.List;

/**
 * 对单位人员信息进行管理 服务类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2022-07-12
 */
public interface DeviceBaseUserManager extends BaseManager<DeviceBaseUser> {

    /**
     * 根据单位id获取单位人员信息
     * @param asList
     * @return
     */
    List<DeviceBaseUser> findByCompanyIds(List<String> asList);

    /**
     * 单位人员分页查询
     * @param queryFilter
     * @return
     */
    PageList<DeviceBaseUser> findByPage(QueryFilter<DeviceBaseUser> queryFilter);
}
