package com.artfess.device.base.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.annotation.PowerLogInfo;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.controller.BaseController;
import com.artfess.base.enums.LogType;
import com.artfess.base.enums.OperationType;
import com.artfess.base.enums.ResponseErrorEnums;
import com.artfess.base.model.CommonResult;
import com.artfess.base.valid.AddGroup;
import com.artfess.base.valid.UpdateGroup;
import com.artfess.device.base.manager.DeviceProductInfoManager;
import com.artfess.device.base.model.DeviceProductInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * 设备产品信息 前端控制器
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2022-07-15
 */
@Slf4j
@RestController
@Api(tags = "设施设备-产品管理")
@RequestMapping("/device/product/info/")
@ApiGroup(group = {ApiGroupConsts.DEVICE_BIZ})
public class DeviceProductInfoController extends BaseController<DeviceProductInfoManager, DeviceProductInfo> {


    @Override
    @PostMapping("/")
    @ApiOperation("添加实体的接口")
    public CommonResult<String> create(@ApiParam(name="model", value="实体信息") @RequestBody @Validated({AddGroup.class}) DeviceProductInfo t) {
        String id = baseService.createInfo(t);
        if(!StringUtils.isNotBlank(id)) {
            return new CommonResult<>(ResponseErrorEnums.FAIL_OPTION, null);
        }
        return new CommonResult<>();
    }

    @Override
    @PutMapping("/")
    @ApiOperation("更新实体")
    public CommonResult<String> updateById(@ApiParam(name="model", value="实体信息") @RequestBody @Validated({UpdateGroup.class})  DeviceProductInfo t) {
        String id = baseService.updateInfo(t);
        if(!StringUtils.isNotBlank(id)) {
            return new CommonResult<>(ResponseErrorEnums.FAIL_OPTION, "更新实体失败");
        }
        return new CommonResult<>();
    }

    @PostMapping(value="/findAll", produces={"application/json; charset=utf-8" })
    @ApiOperation("获取产品列表（不分页）")
    public List<DeviceProductInfo> findAll(@ApiParam(name="model", value="查询条件") @RequestBody DeviceProductInfo productInfo) {
        return baseService.findAll(productInfo);
    }

    @GetMapping("/publish/{id}")
    @ApiOperation("发布产品")
    @PowerLogInfo(logType = LogType.BIZ, operaionType = OperationType.UPDATE, description = "发布产品")
    public CommonResult<String> publish(@ApiParam(name = "id", value = "产品id") @PathVariable String id) {
        log.info("发布产品请求参数:{}", id);
        boolean b = baseService.publish(id);
        log.info("发布产品响应结果:{}", b);
        if (!b) {
            return new CommonResult<>(ResponseErrorEnums.FAIL_OPTION, null);
        }
        return new CommonResult<>();
    }

}
