package com.artfess.device.base.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.controller.BaseController;
import com.artfess.base.enums.ResponseErrorEnums;
import com.artfess.base.model.CommonResult;
import com.artfess.base.valid.UpdateGroup;
import com.artfess.device.base.manager.AppraiseInfoManager;
import com.artfess.device.base.model.AppraiseInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 绩效考核-考核情况（DEVICE_APPRAISE_INFO） 前端控制器
 *
 * @company 阿特菲斯信息技术有限公司
 * @author Limuhua
 * @since 2022-08-02
 */
@Slf4j
@RestController
@Api(tags = "绩效考核-考核情况")
@RequestMapping("/device/appraiseInfo/")
@ApiGroup(group = {ApiGroupConsts.DEVICE_BIZ})
public class AppraiseInfoController extends BaseController<AppraiseInfoManager, AppraiseInfo> {

    @PutMapping("/closeInfo")
    @ApiOperation("变更结算状态")
    public CommonResult<String> closeInfo(@ApiParam(name="infoId", value="考核情况ID") @RequestBody @Validated({UpdateGroup.class}) String infoId) {
        boolean result = baseService.closeInfo(infoId);
        if(!result) {
            return new CommonResult<>(ResponseErrorEnums.FAIL_OPTION, "变更结算状态失败");
        }
        return new CommonResult<>();
    }

    @PostMapping("/getExaminees")
    @ApiOperation(value = "获取被考核者列表", notes = "传入类型、年份、标题 获取没有考核过该项考核的考核对象列表")
    public CommonResult<List<String>> getExaminees(@ApiParam(name="infoId", value="考核情况ID") @RequestBody AppraiseInfo dto) {
        List<String> result = baseService.getExaminees(dto);
        return new CommonResult<>(true, "", result);
    }

}
