package com.artfess.device.base.model;

import com.artfess.base.entity.BaseModel;
import com.artfess.base.valid.AddGroup;
import com.artfess.base.valid.UpdateGroup;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.FieldStrategy;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.time.LocalDateTime;

/**
 * 基础扩展内容
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2022-07-19
 */
@Data
@ApiModel(value="DeviceBaseParamsValue对象", description="基础扩展内容")
public class DeviceBaseParamsValue extends BaseModel<DeviceBaseParamsValue> {

    private static final long serialVersionUID = 1L;

    @TableId(value = "id_", type = IdType.ASSIGN_ID)
    private String id;

    @NotBlank(message = "请选择配置类型",groups = {AddGroup.class, UpdateGroup.class})
    @ApiModelProperty(value = "配置类型(1单位2人员3备品库4备品件)")
    @TableField("type_")
    private String type;

    @ApiModelProperty(value = "基础信息ID")
    @TableField("base_id_")
    private String baseId;

    @ApiModelProperty(value = "参数配置ID")
    @TableField("conf_id_")
    private String confId;

    @ApiModelProperty(value = "参数值")
    @TableField("value_")
    private String value;

    @JsonIgnore
    @ApiModelProperty(value = "数据时间戳", hidden=true, accessMode= ApiModelProperty.AccessMode.READ_ONLY)
    @TableField(updateStrategy= FieldStrategy.NOT_NULL,value="last_time_", fill= FieldFill.INSERT_UPDATE, select=false)
    private LocalDateTime lastTime;


}
