package com.artfess.device.base.manager.impl;

import com.artfess.base.enums.DelStatusEnum;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.device.base.dao.DeviceParamsConfDao;
import com.artfess.device.base.manager.DeviceParamsConfManager;
import com.artfess.device.base.model.DeviceParamsConf;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 设备扩展信息配置 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2022-07-15
 */
@Service
public class DeviceParamsConfManagerImpl extends BaseManagerImpl<DeviceParamsConfDao, DeviceParamsConf> implements DeviceParamsConfManager {

    @Override
    public List<DeviceParamsConf> findAll(DeviceParamsConf conf) {
        QueryWrapper<DeviceParamsConf> queryWrapper = new QueryWrapper();
        if(StringUtils.isNotBlank(conf.getCode())){
            queryWrapper.like("code_", conf.getCode());
        }

        if(StringUtils.isNotBlank(conf.getName())){
            queryWrapper.like("name_", conf.getName());
        }

        if(StringUtils.isNotBlank(conf.getDeviceId())){
            queryWrapper.eq("device_id_", conf.getDeviceId());
        }

        if(StringUtils.isNotBlank(conf.getProductConfId())){
            queryWrapper.eq("product_conf_id_", conf.getProductConfId());
        }

        queryWrapper.eq("is_dele_", DelStatusEnum.N.getType());
        queryWrapper.orderByAsc("sn_");
        return this.baseMapper.selectList(queryWrapper);
    }


}
