package com.artfess.device.monitor.model;

import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.*;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * 实时监控-危险源监控（DEVICE_DATA_HAZARD）
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2022-08-01
 */
@Data
@TableName("device_data_hazard")
@ApiModel(value="DeviceDataHazard对象", description="实时监控-危险源监控（DEVICE_DATA_HAZARD）")
public class DeviceDataHazard extends BaseModel<DeviceDataHazard> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "id_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "数据采集时间")
    @TableField("coll_time_")
    private LocalDateTime collTime;

    @ApiModelProperty(value = "设备唯一标识")
    @TableField("device_code_")
    private String deviceCode;

    @ApiModelProperty(value = "原始采集数据")
    @TableField("src_data_")
    private String srcData;

    @ApiModelProperty(value = "甲烷浓度")
    @TableField("sdata_")
    private BigDecimal sdata;

    @ApiModelProperty(value = "设备电压（单位：V）")
    @TableField("voltage_")
    private BigDecimal voltage;

    @ApiModelProperty(value = "入库时间")
    @TableField("create_time_")
    private LocalDateTime createTime = LocalDateTime.now();

    @JsonIgnore
    @ApiModelProperty(value = "数据时间戳", hidden=true, accessMode= ApiModelProperty.AccessMode.READ_ONLY)
    @TableField(updateStrategy= FieldStrategy.NOT_NULL,value="last_time_", fill= FieldFill.INSERT_UPDATE, select=false)
    private LocalDateTime lastTime;

    @ApiModelProperty(value = "报警ID")
    @TableField("warn_id_")
    private String warnId;

    @ApiModelProperty(value = "设备名称")
    @TableField(exist = false)
    private String deviceName;

}
