package com.artfess.device.monitor.model;

import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.*;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDateTime;

/**
 * 实时监控-路障操作数据（DEVICE_DATA_BARRICADE）
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2022-08-01
 */
@Data
@TableName("DEVICE_DATA_BARRICADE")
@ApiModel(value="DeviceDataBarricade对象", description="实时监控-路障操作数据（DEVICE_DATA_BARRICADE）")
public class DeviceDataBarricade extends BaseModel<DeviceDataBarricade> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "id_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "操作时间")
    @TableField("coll_time_")
    private LocalDateTime collTime;

    @ApiModelProperty(value = "设备唯一标识")
    @TableField("device_code_")
    private String deviceCode;

    @ApiModelProperty(value = "动作标识【字典】（01-上升，10-下降，20-锁定，21-解锁。）")
    @TableField("action_")
    private String action;

    @ApiModelProperty(value = "成功状态【字典】（0-失败，1-成功。）")
    @TableField("status_")
    private String status;

    @ApiModelProperty(value = "操作人")
    @TableField("create_by_")
    private String createBy;

    @ApiModelProperty(value = "操作人组织ID")
    @TableField("create_org_id_")
    private String createOrgId;

    @ApiModelProperty(value = "入库时间")
    @TableField("create_time_")
    private LocalDateTime createTime;

    @JsonIgnore
    @ApiModelProperty(value = "数据时间戳", hidden=true, accessMode= ApiModelProperty.AccessMode.READ_ONLY)
    @TableField(updateStrategy= FieldStrategy.NOT_NULL,value="last_time_", fill= FieldFill.INSERT_UPDATE, select=false)
    private LocalDateTime lastTime;

    @ApiModelProperty(value = "报警ID")
    @TableField("warn_id_")
    private String warnId;

    @ApiModelProperty(value = "设备名称")
    @TableField(exist = false)
    private String deviceName;

}
