package com.artfess.device.monitor.manager.impl;

import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.device.monitor.dao.DeviceDataBarricadeStatusDao;
import com.artfess.device.monitor.manager.DeviceDataBarricadeStatusManager;
import com.artfess.device.monitor.model.DeviceDataBarricadeStatus;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.google.common.collect.Maps;
import org.springframework.stereotype.Service;

import java.util.Map;

/**
 * 实时监控-路障设备状态信息（DEVICE_DATA_BARRICADE_STATUS） 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 黎沐华
 * @since 2022-09-13
 */
@Service
public class DeviceDataBarricadeStatusManagerImpl extends BaseManagerImpl<DeviceDataBarricadeStatusDao, DeviceDataBarricadeStatus> implements DeviceDataBarricadeStatusManager {

    @Override
    public CommonResult findByDeviceId(String productType, QueryFilter<DeviceDataBarricadeStatus> queryFilter) {
        Map<String, Object> data = Maps.newHashMap();
        data.put("productType", productType);

        PageBean pageBean = queryFilter.getPageBean();
        IPage<DeviceDataBarricadeStatus> result = baseMapper.findByDeviceId(convert2IPage(pageBean), convert2Wrapper(queryFilter, currentModelClass()));

        data.put("data", new PageList<DeviceDataBarricadeStatus>(result));
        return CommonResult.success(data, "查询成功");
    }

}
